#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>

#include <WSCvlabel.h>
#include <WSCvbtn.h>
#include <WSCvdrawingArea.h>
#include <WSCwindow.h>

#include "gmain.h"
#include "draw.h"
#include "menu.h"
#include "draw-prot.h"
#include "menu-prot.h"

#include "GlobalVar.h"
#include "StatWinIdx.h"

extern WSCwindow *StatWin;

////////////////////////////////////////////////////////////////
// ̾ܥ򥯥åν
// WSCbase *object : ܥ
////////////////////////////////////////////////////////////////

void StatNameActivate( WSCbase *object )
{
	long n = object->getVariantData( "mbr_n" );

	menu_crsr_move_mbr_n( n );
	set_flg_break_key( TRUE );
}

////////////////////////////////////////////////////////////////
// ֥ܥ򥯥åν
// WSCbase *object : ܥ
////////////////////////////////////////////////////////////////

void StatCondActivate( WSCbase *object )
{
	long n = object->getVariantData( "mbr_n" );

	char sCmdMbr[15 + 1];
	sCmdMbr[0] = 'A' + n;
	sCmdMbr[1] = '\0';

	WSCstring sCmd;
	sCmd << "0@" << sCmdMbr << "d";

	set_key_buf_str( sCmd );
	set_flg_break_key( TRUE );
}

////////////////////////////////////////////////////////////////
// ܥ٥η˱ new 
// WSCbase *object : ƤΥɥ
// WSCstring name : ̾
// StatWinIdx idx : ơɥ
//                  ֥Ȥֹ
////////////////////////////////////////////////////////////////

WSCbase *newLabel( WSCbase *object, WSCstring name, StatWinIdx idx )
{
	WSCbase *lab = NULL;

	WSCprocedure *procName = new WSCprocedure( "StatNameActivate",
			WSEV_ACTIVATE );
	procName->setFunction( StatNameActivate, "StatNameActivate" );

	WSCprocedure *procCond = new WSCprocedure( "StatCondActivate",
			WSEV_ACTIVATE );
	procCond->setFunction( StatCondActivate, "StatCondActivate" );

	switch( idx ){
	case STAT_WIN_IDX_NAME:
		lab = new WSCvbtn( object, name );
		lab->initialize();
		lab->addProcedure( procName );
		break;
	case STAT_WIN_IDX_COND:
		lab = new WSCvbtn( object, name );
		lab->initialize();
		lab->addProcedure( procCond );
		break;
	case STAT_WIN_IDX_HP:
	case STAT_WIN_IDX_MP:
	case STAT_WIN_IDX_ACT:
		lab = new WSCvlabel( object, name );
		lab->initialize();
		break;
	case STAT_WIN_IDX_MAX_N:
		break;
	}

	return lab;
}

//----------------------------------------------------------
//Function for the event procedure
//----------------------------------------------------------
void StatWinDAInit(WSCbase* object){
  //do something...
	nCharWidth = 8;
	nCharHeight = 24;
	nMarginX = 2;
	nMarginY = 2;

	WSCstring name;

	for( long i = 0; i < MBR_MAX_N; i++ ){
		for( long j = 0; j < STAT_WIN_IDX_MAX_N; j++ ){
			name = "";
			name << "StatLabel_" << i << "_" << j;

			gStatLabel[i][j] = newLabel( object, name,
					(StatWinIdx)j );
			gStatLabel[i][j]->setVariantData( "mbr_n", i );
			gStatLabel[i][j]->setProperty( WSNx, 0 );
			gStatLabel[i][j]->setProperty( WSNy, 0 );
			gStatLabel[i][j]->setProperty( WSNwidth,
					nCharWidth );
			gStatLabel[i][j]->setProperty( WSNheight,
					nCharHeight );
			gStatLabel[i][j]->setProperty( WSNlabelString,
					name );
			gStatLabel[i][j]->setVisible( True );
		}

		long lenName = 16;
		long lenHpAndMp = 2 + 4 + 1 + 4;

		gStatLabel[i][STAT_WIN_IDX_NAME]->setProperty(
				WSNwidth,
				nCharWidth * lenName );
		gStatLabel[i][STAT_WIN_IDX_HP]->setProperty(
				WSNwidth,
				nCharWidth * lenHpAndMp );
		gStatLabel[i][STAT_WIN_IDX_MP]->setProperty(
				WSNwidth,
				nCharWidth * lenHpAndMp );
		gStatLabel[i][STAT_WIN_IDX_ACT]->setProperty(
				WSNwidth,
				nCharWidth * (40 - lenName) );
		gStatLabel[i][STAT_WIN_IDX_COND]->setProperty(
				WSNwidth,
				nCharWidth * (40 - (lenHpAndMp * 2)) );
	}

	StatWin->execProcedure( WSEV_RESIZE );
}
static WSCfunctionRegister  op("StatWinDAInit",(void*)StatWinDAInit);
