#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>

#include <WSCvlabel.h>
#include <WSCvdrawingArea.h>

#include "party.h"
#include "GlobalVar.h"
#include "StatWinIdx.h"

//----------------------------------------------------------
//Function for the event procedure
//----------------------------------------------------------
void StatWinResize(WSCbase* object){
  //do something...
	long nWinWidth = (long)(object->getProperty( WSNwidth ))
			- (nMarginX * 2);
	long w = nWinWidth;
	long h = nCharHeight + nMarginY;
	long x = nMarginX;
	long y = nMarginY;

	for( long i = 0; i < MBR_MAX_N; i++ ){
		long wName, wHp, wMp, wAct, wCond;

		if( gStatLabel[i][STAT_WIN_IDX_NAME] == NULL )
			continue;

		wName = (long)(gStatLabel[i][STAT_WIN_IDX_NAME]
				->getProperty( WSNwidth ));
		wHp = (long)(gStatLabel[i][STAT_WIN_IDX_HP]
				->getProperty( WSNwidth ));
		wMp = (long)(gStatLabel[i][STAT_WIN_IDX_MP]
				->getProperty( WSNwidth ));
		wAct = (long)(gStatLabel[i][STAT_WIN_IDX_ACT]
				->getProperty( WSNwidth ));
		wCond = (long)(gStatLabel[i][STAT_WIN_IDX_COND]
				->getProperty( WSNwidth ));
		wName += nMarginX;
		wHp += nMarginX;
		wMp += nMarginX;
		wAct += nMarginX;
		wCond += nMarginX;

		long wRow1 = wName + wAct;
		long wRow2 = wHp + wMp + wCond;
		long wRowMax;
		if( wRow1 > wRow2 )
			wRowMax = wRow1;
		else
			wRowMax = wRow2;

		if( (w != nWinWidth) && (w < wRowMax) ){
			w = nWinWidth;
			x = nMarginX;
			y += h * 3;
		}

		gStatLabel[i][STAT_WIN_IDX_NAME]
				->setProperty( WSNx, x );
		gStatLabel[i][STAT_WIN_IDX_NAME]
				->setProperty( WSNy, y );

		gStatLabel[i][STAT_WIN_IDX_ACT]
				->setProperty( WSNx, x + wName );
		gStatLabel[i][STAT_WIN_IDX_ACT]
				->setProperty( WSNy, y );

		gStatLabel[i][STAT_WIN_IDX_HP]
				->setProperty( WSNx, x );
		gStatLabel[i][STAT_WIN_IDX_HP]
				->setProperty( WSNy, y + h );

		gStatLabel[i][STAT_WIN_IDX_MP]
				->setProperty( WSNx, x + wHp );
		gStatLabel[i][STAT_WIN_IDX_MP]
				->setProperty( WSNy, y + h );

		gStatLabel[i][STAT_WIN_IDX_COND]
				->setProperty( WSNx, x + wHp + wMp );
		gStatLabel[i][STAT_WIN_IDX_COND]
				->setProperty( WSNy, y + h );

		w -= wRowMax;
		x += wRowMax;
	}
}
static WSCfunctionRegister  op("StatWinResize",(void*)StatWinResize);
