/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2006 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: fight.c,v 1.115 2006/01/27 16:25:25 bowkenken Exp $
***************************************************************/

/***************************************************************
* Ʈ
***************************************************************/

#define	FIGHT_C
#include	"inc.h"

/***************************************************************
* ٥ɶζ
***************************************************************/

#if	1

/* ٥뤬㤤ۤɶ */
/* ٥뤬夬о夬ۤɺ̵ʤ */
#define	FLG_ITEM_ADD_RATE

#else

/* ٥뤬㤤Ϻ̵ */
/* ٥뤬夬о夬ۤɶϤˤʤ */

#endif

/***************************************************************
* ٥ɶζδ
***************************************************************/

#define	HIT_FIT_AVE_N	10
#define	HIT_HNT_AVE_N	10
#define	WPN_CRTCL_FIT_AVE_N	20
#define	WPN_CRTCL_HNT_AVE_N	20
#define	DAM_FIT_AVE_N	10
#define	DAM_HNT_AVE_N	10

#define	HIT_MON_MUL	10
#define	HIT_MON_ADD	0
#define	DAM_MON_MUL	10
#define	DAM_MON_ADD	0
#define	DEF_MON_MUL	10
#define	DEF_MON_ADD	0

/* դΥƥ롦ҥåΨ */
#define	WPN_CRTCL_THF_LEV_RATE	30
#define	WPN_CRTCL_THF_MAX_RATE	30

/* ǦԤμڤΨ */
#define	NINJA_CRTCL_RATE	150

#define	DEF_MIN_RATE	30
#define	DEF_AVE_N	10
#define	ARMOR_CRTCL_AVE_N	10
#define	AC_AVE_N	20

/* ɸ(⤷Ƥʤ)ɸϥåΨ */
#define	DEF_DEF_RATE	150
#define	DEF_AC_RATE	150

/* ˡξι */
#define	DAM_STICK_RATE	((rate_t)120)
#define	DAM_STICK_ADD	2

/* ʸι */
#define	DAM_SPELL_RATE	((rate_t)150)
#define	DAM_SPELL_ADD	2

/* ֥Ȥɸ */
#define	DOOR_DEF	12
#define	TRAP_DEF	8
#define	ITEM_DEF	6

/* ֹϤεΥˤäƸΨ */
#define	RATE_PER_RANGE	((rate_t)200)

/* СƱΤηи */
#define	TRAINING_EXP	1

/***************************************************************
* Ǽξιǡ
***************************************************************/

static attack_t	mbr_attack_bash[] = {
	{ ATTACK_KIND_PUNCH, 1, FALSE, TRUE,
		WPN_HIT_UNARMED, WPN_CRTCL_UNARMED, WPN_DAM_UNARMED,
		RESI_KIND_KNOC, 1, 1,
		FX_KIND_NULL, 0,
		SPELL_KIND_NULL,
		EXTENT_KIND_NULL, N_MSG_NULL, },
	{ ATTACK_KIND_KICK, 1, FALSE, TRUE,
		WPN_HIT_UNARMED, WPN_CRTCL_UNARMED, WPN_DAM_UNARMED,
		RESI_KIND_KNOC, 1, 1,
		FX_KIND_NULL, 0,
		SPELL_KIND_NULL,
		EXTENT_KIND_NULL, N_MSG_NULL, },
	{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
		0, 0, 0,
		RESI_KIND_MAX_N, 1, 1,
		FX_KIND_NULL, 0,
		SPELL_KIND_NULL,
		EXTENT_KIND_NULL, N_MSG_NULL, },
};

/***************************************************************
* ƥꤲιǡ
***************************************************************/

static attack_t	mbr_attack_throw[] = {
	{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
		WPN_HIT_UNARMED, WPN_CRTCL_UNARMED, WPN_DAM_UNARMED,
		RESI_KIND_KNOC, 1, 10,
		FX_KIND_NULL, 0,
		SPELL_KIND_NULL,
		EXTENT_KIND_NULL, N_MSG_NULL, },
	{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
		0, 0, 0,
		RESI_KIND_MAX_N, 1, 1,
		FX_KIND_NULL, 0,
		SPELL_KIND_NULL,
		EXTENT_KIND_NULL, N_MSG_NULL, },
};

/***************************************************************
* ꤲιǡ
***************************************************************/

static attack_t	mbr_attack_throw_light[] = {
	{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
		WPN_HIT_UNARMED, WPN_CRTCL_UNARMED, WPN_DAM_UNARMED,
		RESI_KIND_HEAT, 1, 10,
		FX_KIND_NULL, 0,
		SPELL_KIND_NULL,
		EXTENT_KIND_NULL, N_MSG_NULL, },
	{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
		0, 0, 0,
		RESI_KIND_MAX_N, 1, 1,
		FX_KIND_NULL, 0,
		SPELL_KIND_NULL,
		EXTENT_KIND_NULL, N_MSG_NULL, },
};

/***************************************************************
* ܹ
* chr_t *chr : ¦饯
* chr_t *chr2 : ɸ¦饯
* attack_t *dflt_attack : ǥեȤιǡ
* return : ?
***************************************************************/

bool_t	fight_bash( chr_t *chr, chr_t *chr2, attack_t *dflt_attack )
{
	attack_t	attack;
	long	d;

	if( chr == NULL )
		return FALSE;
	if( chr2 == NULL )
		return FALSE;

	d = get_trgt_range( chr );

	if( dflt_attack == NULL ){
		if( !set_attack_chr_bash( chr, &attack, 1, FALSE ) )
			return FALSE;
	} else {
		attack = *dflt_attack;
	}

	return fight( chr, chr2, &attack, d );
}

/***************************************************************
* ܹǡ
* chr_t *chr : ¦饯
* attack_t *attack : ǡ֤
* long range : Υ
* bool_t flg_ave : ʿ֤ͤ?
* return : 뤫?
***************************************************************/

bool_t	set_attack_chr_bash(
	chr_t *chr, attack_t *attack, long range, bool_t flg_ave
)
{
	if( chr->kind == CHR_KIND_MBR )
		return set_attack_mbr_bash( chr, attack, range, flg_ave );
	if( chr->kind == CHR_KIND_MNSTR )
		return set_attack_mnstr_bash( chr, attack, range, flg_ave );

	return FALSE;
}

/***************************************************************
* Сζܹǡ
* mbr_t *mbr : ¦С
* attack_t *attack : ǡ֤
* long range : Υ
* bool_t flg_ave : ʿ֤ͤ?
* return : 뤫?
***************************************************************/

bool_t	set_attack_mbr_bash(
	mbr_t *mbr, attack_t *attack, long range, bool_t flg_ave
)
{
	item_t	*eq;
	wpn_tab_t	*wpn_tab;
	attack_t	*p;

	if( attack == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( mbr->kind != CHR_KIND_MBR )
		return FALSE;

	/* Υơ֥ */
	eq = get_mbr_item_asgn_equip( mbr );
	if( eq == NULL )
		return FALSE;

	eq = &(eq[EQUIP_KIND_WIELDING]);
	if( eq->kind == ITEM_KIND_WPN )
		wpn_tab = eq->tab.wpn;
	else
		wpn_tab = NULL;

	if( wpn_tab == NULL ){
		/* Ǽξ */
		p = get_attack( flg_ave, mbr_attack_bash, range,
				FALSE, TRUE, FALSE, FALSE );
		if( p == NULL )
			return FALSE;
		*attack = *p;
	} else {
		/* ξ */
		p = get_attack( flg_ave, wpn_tab->attack, range,
				TRUE, FALSE, FALSE, FALSE );
		if( p == NULL )
			return FALSE;
		*attack = *p;

		attack->hit += add_hit( eq->dat.wpn.add_hit );
		attack->crtcl += add_wpn_crtcl( eq->dat.wpn.add_crtcl );
		attack->dam += add_dam( eq->dat.wpn.add_dam );
		attack->dam += attack->dam
				* add_dam_two_handed_wpn( mbr, eq )
				/ _100_PERCENT;
	}

	return TRUE;
}

/***************************************************************
* 󥹥ζܹǡ
* mnstr_t *mnstr : ¦󥹥
* attack_t *attack : ǡ֤
* long range : Υ
* bool_t flg_ave : ʿ֤ͤ?
* return : 뤫?
***************************************************************/

bool_t	set_attack_mnstr_bash(
	mnstr_t *mnstr, attack_t *attack, long range, bool_t flg_ave
)
{
	attack_t	*p;

	if( attack == NULL )
		return FALSE;
	if( mnstr == NULL )
		return FALSE;
	if( mnstr->kind != CHR_KIND_MNSTR )
		return FALSE;

	if( mnstr->mnstr_tab == NULL )
		return FALSE;

	p = get_attack( flg_ave, mnstr->mnstr_tab->attack, range,
			TRUE, TRUE, FALSE, FALSE );
	if( p == NULL )
		return FALSE;

	*attack = *p;

	return TRUE;
}

/***************************************************************
* ֹ
* chr_t *chr : ¦饯
* chr_t *chr2 : ɸ¦饯
* attack_t *dflt_attack : ǥեȤιǡ
* return : ?
***************************************************************/

bool_t	fight_throw( chr_t *chr1, chr_t *chr2, attack_t *dflt_attack )
{
	item_t	*eq;
	attack_t	attack;
	long	d;

	if( chr1 == NULL )
		return FALSE;
	if( chr2 == NULL )
		return FALSE;

	eq = get_mbr_item_asgn_equip( chr1 );
	if( eq == NULL )
		return FALSE;

	/* check stick */

	if( eq[EQUIP_KIND_BOW].kind == ITEM_KIND_STICK ){
		if( !zap_stick( chr1, &(eq[EQUIP_KIND_BOW]) ) )
			clr_chr_trgt_act( chr1, FALSE );
		return TRUE;
	}

	d = get_trgt_range( chr1 );

	if( dflt_attack == NULL ){
		if( !set_attack_chr_throw( chr1, &attack, d, FALSE ) )
			return FALSE;
	} else {
		attack = *dflt_attack;
	}

	return fight( chr1, chr2, &attack, d );
}

/***************************************************************
* ֹǡ
* chr_t *chr : ¦饯
* attack_t *attack : ǡ֤
* long range : Υ
* bool_t flg_ave : ʿ֤ͤ?
* return : 뤫?
***************************************************************/

bool_t	set_attack_chr_throw(
	chr_t *chr, attack_t *attack, long range, bool_t flg_ave
)
{
	if( chr->kind == CHR_KIND_MBR )
		return set_attack_mbr_throw( chr, attack, range, flg_ave );
	if( chr->kind == CHR_KIND_MNSTR )
		return set_attack_mnstr_throw( chr, attack, range, flg_ave );

	return FALSE;
}

/***************************************************************
* Сαֹǡ
* mbr_t *mbr : ¦С
* attack_t *attack : ǡ֤
* long range : Υ
* bool_t flg_ave : ʿ֤ͤ?
* return : 뤫?
***************************************************************/

bool_t	set_attack_mbr_throw(
	mbr_t *mbr, attack_t *attack, long range, bool_t flg_ave
)
{
	item_t	*eq;
	wpn_tab_t	*bow_tab, *arw_tab;
	attack_t	*p;

	if( mbr == NULL )
		return FALSE;
	if( mbr->kind != CHR_KIND_MBR )
		return FALSE;
	if( attack == NULL )
		return FALSE;

	eq = get_mbr_item_asgn_equip( mbr );
	if( eq == NULL )
		return FALSE;

	/* Υơ֥ */

	if( eq[EQUIP_KIND_BOW].kind == ITEM_KIND_WPN )
		bow_tab = eq[EQUIP_KIND_BOW].tab.wpn;
	else
		bow_tab = NULL;
	if( eq[EQUIP_KIND_ARW].kind == ITEM_KIND_WPN )
		arw_tab = eq[EQUIP_KIND_ARW].tab.wpn;
	else
		arw_tab = NULL;

	if( chk_dagger( arw_tab ) ){
		/* ξ */

		p = get_attack( flg_ave, arw_tab->attack, range,
				FALSE, FALSE, TRUE, FALSE );
		if( p == NULL )
			return FALSE;
		*attack = *p;

		attack->hit += add_hit( eq[EQUIP_KIND_ARW]
				.dat.wpn.add_hit );
		attack->crtcl += add_wpn_crtcl( eq[EQUIP_KIND_ARW]
				.dat.wpn.add_crtcl );
		attack->dam += add_dam( eq[EQUIP_KIND_ARW]
				.dat.wpn.add_dam );
	} else if( chk_bow( arw_tab, bow_tab ) ){
		attack_t	attack_bow, attack_arw;
		/* ݤʤɤξ */

		/* bow */

		p = get_attack( flg_ave, bow_tab->attack, range,
				FALSE, FALSE, TRUE, FALSE );
		if( p == NULL )
			return FALSE;
		attack_bow = *p;

		attack_bow.hit += add_hit( eq[EQUIP_KIND_BOW]
				.dat.wpn.add_hit );
		attack_bow.crtcl += add_wpn_crtcl( eq[EQUIP_KIND_BOW]
				.dat.wpn.add_crtcl );
		attack_bow.dam += add_dam( eq[EQUIP_KIND_BOW]
				.dat.wpn.add_dam );

		/* arrow */

		p = get_attack( flg_ave, arw_tab->attack, range,
				FALSE, FALSE, TRUE, FALSE );
		if( p == NULL )
			return FALSE;
		attack_arw = *p;

		attack_arw.hit += add_hit( eq[EQUIP_KIND_ARW]
				.dat.wpn.add_hit );
		attack_arw.crtcl += add_wpn_crtcl( eq[EQUIP_KIND_ARW]
				.dat.wpn.add_crtcl );
		attack_arw.dam += add_dam( eq[EQUIP_KIND_ARW]
				.dat.wpn.add_dam );

		/* sum */

		*attack = attack_bow;
		attack->hit += attack_arw.hit;
		attack->crtcl += attack_arw.crtcl;
		attack->dam += attack_arw.dam;
	} else {
		/* ¾Υƥξ */

		if( eq[EQUIP_KIND_ARW].kind == ITEM_KIND_LIGHT ){
			p = get_attack( flg_ave,
					mbr_attack_throw_light, range,
					FALSE, FALSE, TRUE, FALSE );
		} else {
			p = get_attack( flg_ave,
					mbr_attack_throw, range,
					FALSE, FALSE, TRUE, FALSE );
		}
		if( p == NULL )
			return FALSE;
		*attack = *p;
	}

	return TRUE;
}

/***************************************************************
* 󥹥αֹǡ
* mnstr_t *mnstr : ¦󥹥
* attack_t *attack : ǡ֤
* long range : Υ
* bool_t flg_ave : ʿ֤ͤ?
* return : 뤫?
***************************************************************/

bool_t	set_attack_mnstr_throw(
	mnstr_t *mnstr, attack_t *attack, long range, bool_t flg_ave
)
{
	attack_t	*p;

	if( mnstr == NULL )
		return FALSE;
	if( mnstr->kind != CHR_KIND_MNSTR )
		return FALSE;
	if( mnstr->mnstr_tab == NULL )
		return FALSE;
	if( attack == NULL )
		return FALSE;

	p = get_attack( flg_ave, mnstr->mnstr_tab->attack, range,
			FALSE, FALSE, TRUE, FALSE );
	if( p == NULL )
		return FALSE;

	*attack = *p;

	return TRUE;
}

/***************************************************************
* ǡμư
* bool_t flg_ave : ʿͤ?
* attack_t *ls : ǡΥơ֥
* long range : Υ
* bool_t flg_bash : ܹ˴ޤफ?
* bool_t flg_monk : Ʈ˴ޤफ?
* bool_t flg_throw : ֹ˴ޤफ?
* bool_t flg_spell : ʸ˴ޤफ?
* return : 򤵤줿ǡ
***************************************************************/

attack_t	*get_attack(
	bool_t flg_ave, attack_t *ls, long range,
	bool_t flg_bash, bool_t flg_monk,
	bool_t flg_throw, bool_t flg_spell
)
{
	if( flg_ave ){
		return( get_attack_ave( ls, range,
				flg_bash, flg_monk,
				flg_throw, flg_spell ) );
	} else {
		return( get_attack_randm( ls, range,
				flg_bash, flg_monk,
				flg_throw, flg_spell ) );
	}
}

/***************************************************************
* ʿŪʹǡμư
* attack_t *ls : ǡΥơ֥
* long range : Υ
* bool_t flg_bash : ܹ˴ޤफ?
* bool_t flg_monk : Ʈ˴ޤफ?
* bool_t flg_throw : ֹ˴ޤफ?
* bool_t flg_spell : ʸ˴ޤफ?
* return : 򤵤줿ǡ
***************************************************************/

attack_t	*get_attack_ave(
	attack_t *ls, long range,
	bool_t flg_bash, bool_t flg_monk,
	bool_t flg_throw, bool_t flg_spell
)
{
	long	i;
	ratio_t	n, sum;
	static attack_t	ave;

	if( ls == NULL )
		return NULL;

	ave.kind = ATTACK_KIND_NULL;
	ave.ratio = 1;
	ave.resi_kind = RESI_KIND_MAX_N;
	ave.flg_throw = flg_throw;
	ave.flg_monk = flg_monk;
	ave.hit = 0;
	ave.crtcl = 0;
	ave.dam = 0;

	sum = 0;
	for( i = 0; i < LOOP_MAX_1000; i++ ){
		if( ls[i].kind == ATTACK_KIND_NULL )
			break;

		if( ls[i].kind == ATTACK_KIND_SPELL ){
			if( !flg_spell )
				continue;
		} else if( ls[i].kind == ATTACK_KIND_SPELL_SELF ){
			if( !flg_spell )
				continue;
		} else if( ls[i].kind == ATTACK_KIND_SPELL_FRIEND ){
			if( !flg_spell )
				continue;
		} else if( ls[i].flg_monk ){
			if( !flg_monk )
				continue;
		} else if( ls[i].flg_throw ){
			if( !flg_throw )
				continue;
			if( ls[i].range_throw < range )
				continue;
		} else {
			if( !flg_bash )
				continue;
			if( ls[i].range_bash < range )
				continue;
		}

		n = ls[i].ratio;
		sum += n;
		ave.hit += ls[i].hit * n;
		ave.crtcl += ls[i].crtcl * n;
		ave.dam += ls[i].dam * n;
	}

	if( sum <= 0 )
		return NULL;

	ave.hit /= sum;
	ave.crtcl /= sum;
	ave.dam /= sum;

	return &ave;
}

/***************************************************************
* ʹǡμư
* attack_t *ls : ǡΥơ֥
* long range : Υ
* bool_t flg_bash : ܹ˴ޤफ?
* bool_t flg_monk : Ʈ˴ޤफ?
* bool_t flg_throw : ֹ˴ޤफ?
* bool_t flg_spell : ʸ˴ޤफ?
* return : 򤵤줿ǡ
***************************************************************/

attack_t	*get_attack_randm(
	attack_t *ls, long range,
	bool_t flg_bash, bool_t flg_monk,
	bool_t flg_throw, bool_t flg_spell
)
{
	long	i;
	ratio_t	n, sum;

	if( ls == NULL )
		return NULL;

	sum = 0;
	for( i = 0; i < LOOP_MAX_1000; i++ ){
		if( ls[i].kind == ATTACK_KIND_NULL )
			break;

		if( ls[i].kind == ATTACK_KIND_SPELL ){
			if( !flg_spell )
				continue;
		} else if( ls[i].kind == ATTACK_KIND_SPELL_SELF ){
			if( !flg_spell )
				continue;
		} else if( ls[i].kind == ATTACK_KIND_SPELL_FRIEND ){
			if( !flg_spell )
				continue;
		} else if( ls[i].flg_monk ){
			if( !flg_monk )
				continue;
		} else if( ls[i].flg_throw ){
			if( !flg_throw )
				continue;
			if( ls[i].range_throw < range )
				continue;
		} else {
			if( !flg_bash )
				continue;
			if( ls[i].range_bash < range )
				continue;
		}

		sum += ls[i].ratio;
	}

	if( sum <= 0 )
		return NULL;

	n = randm( sum );

	sum = 0;
	for( i = 0; i < LOOP_MAX_1000; i++ ){
		if( ls[i].kind == ATTACK_KIND_NULL )
			break;
		if( ls[i].kind == ATTACK_KIND_SPELL ){
			if( !flg_spell )
				continue;
		} else if( ls[i].kind == ATTACK_KIND_SPELL_SELF ){
			if( !flg_spell )
				continue;
		} else if( ls[i].kind == ATTACK_KIND_SPELL_FRIEND ){
			if( !flg_spell )
				continue;
		} else if( ls[i].flg_monk ){
			if( !flg_monk )
				continue;
		} else if( ls[i].flg_throw ){
			if( !flg_throw )
				continue;
		} else {
			if( !flg_bash )
				continue;
		}

		sum += ls[i].ratio;
		if( sum > n )
			return( &(ls[i]) );
	}

	return NULL;
}

/***************************************************************
* ϤιΨ׻
* attack_t *ls : ǡΥơ֥
* bool_t flg_bash : ܹ˴ޤफ?
* bool_t flg_monk : Ʈ˴ޤफ?
* bool_t flg_throw : ֹ˴ޤफ?
* bool_t flg_spell : ʸ˴ޤफ?
* return : ϤιΨ
***************************************************************/

ratio_t	calc_attack_sum(
	attack_t *ls,
	bool_t flg_bash, bool_t flg_monk,
	bool_t flg_throw, bool_t flg_spell
)
{
	ratio_t	sum;
	long	i;

	if( ls == NULL )
		return 0;

	sum = 0;
	for( i = 0; i < LOOP_MAX_1000; i++ ){
		if( ls[i].kind == ATTACK_KIND_NULL )
			break;
		if( ls[i].kind == ATTACK_KIND_SPELL ){
			if( !flg_spell )
				continue;
		} else if( ls[i].kind == ATTACK_KIND_SPELL_SELF ){
			if( !flg_spell )
				continue;
		} else if( ls[i].kind == ATTACK_KIND_SPELL_FRIEND ){
			if( !flg_spell )
				continue;
		} else if( ls[i].flg_monk ){
			if( !flg_monk )
				continue;
		} else if( ls[i].flg_throw ){
			if( !flg_throw )
				continue;
		} else {
			if( !flg_bash )
				continue;
		}

		sum += ls[i].ratio;
	}

	return sum;
}

/***************************************************************
* Ʈ
* chr_t *o_p : ¦饯
* chr_t *d_p : ɸ¦饯
* const attack_t *attack : ǡ
* long range : Υ
* return : ?
***************************************************************/

bool_t	fight( chr_t *o_p, chr_t *d_p, const attack_t *attack, long range )
{
	chr_kind_t	o_k, d_k;
	long	o_hit, o_dam;
	static char	o_name[CHR_NAME_MAX_LEN + 1];
	static char	d_name[CHR_NAME_MAX_LEN + 1];
	long	d_def, d_ac;
	rate_t	d_resi;
	abl_val_t	*d_hp;
	fx_t	*d_fx;
	long	d_x, d_y;
	flg_stat_t	stat;
	item_t	*eq;
	pos_t	bgn, end;
	bool_t	flg_crtcl, flg_ninja_crtcl;
	bool_t	flg_dead;
	bool_t	flg_d_null;
	bool_t	flg_auto_hit;
	bool_t	flg_serious;
	bool_t	flg_err_range;
	char	mjr;

	if( attack == NULL )
		return FALSE;

	if( o_p == NULL )
		return FALSE;
	else
		o_k = o_p->kind;

	if( d_p == NULL )
		d_k = CHR_KIND_MNSTR;
	else
		d_k = d_p->kind;

	flg_d_null = FALSE;
	if( d_p == NULL ){
		flg_d_null = TRUE;
	} else {
		if( d_k == CHR_KIND_MNSTR )
			if( ((mnstr_t *)d_p)->mnstr_tab == NULL )
				flg_d_null = TRUE;
	}
	if( o_p->kind == CHR_KIND_MBR )
		if( ((mbr_t *)o_p)->trgt.kind == TRGT_KIND_MNSTR_NULL )
			flg_d_null = TRUE;

	/* ξǤƮϽʤ */

	if( (o_p != NULL) && chk_map_sanctuary( o_p->x, o_p->y ) )
		return FALSE;
	if( (d_p != NULL) && chk_map_sanctuary( d_p->x, d_p->y ) )
		return FALSE;

	/* ꤲʪ̵ʤä饭󥻥 */

	eq = NULL;
	if( attack->flg_throw && (o_k == CHR_KIND_MBR) ){
		eq = get_mbr_item_asgn_equip( (mbr_t *)o_p );
		if( eq[EQUIP_KIND_ARW].kind == ITEM_KIND_NULL ){
			print_msg( FLG_MSG_ERR, MSG_ERR_THROW, o_name );

			clr_chr_trgt_act( (mbr_t *)o_p, TRUE );

			return FALSE;
		}
	}

	/* ΥΥå */

	flg_err_range = FALSE;
	if( attack->flg_throw ){
		if( attack->range_throw < range )
			flg_err_range = TRUE;
	} else {
		if( attack->range_bash < range )
			flg_err_range = TRUE;
	}
	if( flg_err_range ){
		print_msg( FLG_MSG_ERR, MSG_ERR_ATTACK_RANGE, o_p->name );

		return FALSE;
	}

	/* Ʃθ̤ */

	if( cancel_fx_vanish( o_p ) )
		return FALSE;

	/* ø */

	flg_serious = TRUE;
	if( d_p != NULL ){
		if( d_p->attitude == ATTITUDE_MATE ){
			if( o_p->attitude == ATTITUDE_MATE ){
				/* ̣ɤʤø */
				flg_serious = FALSE;
			}
		} else {
			set_enemy_mnstr_group( o_p, d_p );
		}
	}
	if( chk_flg( get_flg_party(), FLG_PARTY_ACTUAL_FIGHTING ) )
		flg_serious = TRUE;

	/* ¦̾μ */

	strncpy( o_name, o_p->name, CHR_NAME_MAX_LEN );

	/* ɸ¦̾ȥǡμ */

	if( flg_d_null ){
		strncpy( d_name, MSG_NULL, CHR_NAME_MAX_LEN );
		d_hp = NULL;
		d_fx = NULL;
		d_x = 0;
		d_y = 0;
	} else {
		strncpy( d_name, d_p->name, CHR_NAME_MAX_LEN );
		d_hp = &(d_p->abl.hp);
		d_fx = &(d_p->fx);
		d_x = d_p->x;
		d_y = d_p->y;
	}

	/* ¦廊뤫 */

	if( o_k == CHR_KIND_MBR )
		stat = ((mbr_t *)o_p)->stat;
	else
		stat = ((mnstr_t *)o_p)->stat;
	if( chk_flg_or( stat, FLG_STAT_NOT_EXIST
			| FLG_STAT_DEAD
			| FLG_STAT_STONE
			| FLG_STAT_PARALYZE
			| FLG_STAT_CONFUSION
			| FLG_STAT_SLEEP
			| FLG_STAT_FAINT ) ){
		return FALSE;
	}

	/* ɸ¦廊뤫 */

	if( d_k == CHR_KIND_MBR )
		stat = ((mbr_t *)d_p)->stat;
	else if( flg_d_null )
		stat = FLG_NULL;
	else
		stat = ((mnstr_t *)d_p)->stat;
	if( chk_flg_or( stat, FLG_STAT_NOT_EXIST
			| FLG_STAT_STONE
			| FLG_STAT_DEAD ) ){
		return FALSE;
	}
	if( chk_flg_or( stat, FLG_STAT_PARALYZE
			| FLG_STAT_CONFUSION
			| FLG_STAT_BLIND
			| FLG_STAT_SLEEP
			| FLG_STAT_FAINT ) ){
		flg_auto_hit = TRUE;
	} else {
		flg_auto_hit = FALSE;
	}

	/* ꤬Ƥ뤫 */

	if( !flg_d_null ){
		if( !chk_find_chr( o_p, d_p ) ){
			if( o_k == CHR_KIND_MBR ){
				print_msg( FLG_MSG_ERR,
						MSG_ERR_NOT_FIND,
						o_name, d_name );
			}
			return FALSE;
		}
	}

	print_msg( FLG_NULL, get_msg_attack( attack ), o_name, d_name );

	bgn.x = o_p->x;
	bgn.y = o_p->y;
	end.x = o_p->trgt.true_x;
	end.y = o_p->trgt.true_y;

	mjr = MNSTR_THROW_MJR;
	if( attack->flg_throw ){
		/* ꤲʪ */
		if( (o_k == CHR_KIND_MBR) && (eq != NULL) )
			mjr = get_item_mjr( &(eq[EQUIP_KIND_ARW]) );
		vfx_arw( o_k, &bgn, &end, mjr, ANIM_ARW_LEN );
	}

	/* ɸ¦Υǡ */

	if( flg_d_null ){
		d_def = 0;
		d_ac = 0;
		d_resi = _100_PERCENT;
	} else {
		d_def = get_def( d_p );
		d_def = roll_dice( d_def, FALSE );
		d_def += d_def * d_p->fx_data.bless;
		d_ac = get_ac( d_p );
		if( d_k == CHR_KIND_MBR ){
			if( ((mbr_t *)d_p)->act.kind == ACT_KIND_NULL ){
				/* ⤷Ƥʤɸ */
				d_def *= DEF_DEF_RATE;
				d_def /= _100_PERCENT;
				d_ac *= DEF_AC_RATE;
				d_ac /= _100_PERCENT;
			}
		}
		d_resi = get_resi_def( d_p, attack->resi_kind );
	}
	if( flg_auto_hit )
		d_def = 0;

	/* ¦Υǡ */

	o_hit = get_hit( o_p, attack );
	o_hit = roll_dice( o_hit, FALSE );
	o_hit += o_hit * o_p->fx_data.bless;
	o_hit = o_hit * get_chr_throw_range_rate( o_p, d_p ) / _100_PERCENT;

	o_dam = get_dam( o_p, attack );
	flg_crtcl = rate_randm( get_crtcl( o_p, d_p, attack ) );

	if( !flg_d_null ){
		o_dam = roll_dice( o_dam, TRUE );
		o_dam = calc_resi( d_resi, o_dam );
		o_dam -= d_ac;
	}
	if( o_dam <= 0 )
		o_dam = 1;

	/* ƥ */

	if( flg_crtcl && flg_serious )
		flg_ninja_crtcl = chk_ninja_crtcl( o_p, d_p );
	else
		flg_ninja_crtcl = FALSE;

	if( chk_slayer( o_p, d_p, attack->flg_throw ) ){
		o_hit *= 2;
		o_dam *= 2;
	}

	print_msg( FLG_MSG_DEBUG, "o_hit: %ld, d_def: %ld",
			o_hit, d_def );

	/* ʤ */

	if( flg_d_null || (!flg_crtcl && (d_def > o_hit)) ){
		if( flg_d_null ){
			print_msg( FLG_MSG_ERR, MSG_ERR_MNSTR_NULL );
		} else {
			fx_t	*fx;

			fx = srch_fx( &(d_p->fx), FX_KIND_SUBSTITUTE );
			if( fx != NULL ){
				print_msg( FLG_NULL, MSG_FIGHT_SUBSTITUTE,
						d_name );
			}

			print_msg( FLG_NULL, MSG_FIGHT_MISS_STD,
					o_name, d_name );
		}

		if( o_k != CHR_KIND_MBR )
			return TRUE;
		if( eq == NULL )
			return TRUE;
		if( !attack->flg_throw )
			return TRUE;

		/* ֹν */

		if( chk_come_back_arw( (mbr_t *)o_p ) ){
			/* ֡Τ褦äƤ */
			vfx_arw( o_k, &end, &bgn, mjr, ANIM_ARW_LEN );
		} else {
			/*  */
			dec_throw( (mbr_t *)o_p, TRUE, d_x, d_y );
		}

		return TRUE;
	}

	/* 񤹤 */

	if( attack->flg_throw && (eq != NULL) && (o_k == CHR_KIND_MBR) ){
		if( (eq[EQUIP_KIND_ARW].kind == ITEM_KIND_WPN)
				&& chk_flg( eq[EQUIP_KIND_ARW].dat.wpn.flg,
				FLG_WPN_TAB_NOT_SPEND ) ){
			/* 񤻤 */
			dec_throw( (mbr_t *)o_p, TRUE, d_x, d_y );
		} else {
			dec_throw( (mbr_t *)o_p, FALSE, d_x, d_y );
		}
	}

	/* Ƥ */

	if( chk_flg( d_p->stat, FLG_STAT_IRON_BODY ) ){
		curs_attrset_chr( d_p, +1, FALSE );
		print_msg( FLG_NULL, MSG_REPEL_ATTACK,
				d_p->name, o_p->name );
		curs_attrset_dflt();

		return FALSE;
	}

	/* ø */

	if( !flg_serious )
		o_dam = 0;

	/* ˡ路ʤå */

	if( !flg_crtcl )
		if( chk_magic_protect( o_p, d_p, attack->flg_throw ) )
			o_dam = 0;

	/* ݡä */

	if( (eq != NULL) && (eq[EQUIP_KIND_ARW].kind == ITEM_KIND_POTION) )
		o_dam = 0;

	/* ⤬ä */

	/* ᡼ɽ */

	if( o_dam <= 0 ){
		o_dam = 0;
	} else if( flg_ninja_crtcl ){
		curs_attrset_chr( d_p, -1, TRUE );
		print_msg( FLG_NULL, MSG_FIGHT_CRTCL_NINJA, o_name );
		curs_attrset_dflt();

		vfx_ninja_crtcl( d_k, end.x, end.y );
	} else if( flg_crtcl ){
		o_dam *= 2;

		curs_attrset_chr( d_p, -1, TRUE );
		print_msg( FLG_NULL, MSG_FIGHT_CRTCL_STD, o_name );
		curs_attrset_dflt();

		vfx_crtcl( d_k, end.x, end.y );

		curs_attrset_chr( d_p, -1, FALSE );
		print_msg( FLG_NULL, MSG_FIGHT_HIT_STD, d_name, o_dam );
		curs_attrset_dflt();
	} else {
		curs_attrset_chr( d_p, -1, FALSE );
		print_msg( FLG_NULL, MSG_FIGHT_HIT_STD, d_name, o_dam );
		curs_attrset_dflt();

		vfx_hit( d_k, end.x, end.y );
	}

	/* Υե */

	fight_fx( o_p, d_p, attack );

	/* ݡä */

	if( (eq != NULL) && (eq[EQUIP_KIND_ARW].kind == ITEM_KIND_POTION) ){
		o_dam = 0;

		quaff_potion( (chr_t *)d_p, &(eq[EQUIP_KIND_ARW]), FALSE );
	}

	/*  */

	do {
		abl_kind_t	o_abl, d_abl;
		long	o_lev, d_lev;

		if( flg_serious )
			break;

		if( attack->flg_throw )
			o_abl = ABL_KIND_HUN;
		else if( attack->flg_monk )
			o_abl = ABL_KIND_MON;
		else
			o_abl = ABL_KIND_FIG;
		d_abl = get_def_abl( d_p );

		o_lev = get_lev( o_p, o_abl );
		d_lev = get_lev( d_p, d_abl );

		if( o_lev >= d_lev )
			break;

		exp_chr( (mbr_t *)o_p, TRAINING_EXP, FALSE, TRUE, TRUE );
	} while( 0 );

	/* ɲø */

	added_fx( d_p, attack->resi_kind );

	/* HP򸺤餹 */

	flg_dead = FALSE;
	if( flg_ninja_crtcl )
		flg_dead = TRUE;
	if( (d_hp != NULL) && (d_hp->n <= o_dam) )
		flg_dead = TRUE;

	if( flg_dead ){
		/*  */
		curs_attrset_chr( d_p, -1, TRUE );
		print_msg( FLG_NULL, MSG_FIGHT_KILL_STD,
				o_name, d_name );
		curs_attrset_dflt();
	}

	if( flg_ninja_crtcl )
		die_chr( d_p, TRUE, TRUE, TRUE );
	else
		add_hp( d_p, -o_dam, TRUE, FALSE );

	return TRUE;
}

/***************************************************************
* ʸ
* chr_t *o_p : ¦饯
* chr_t *d_p : ɸ¦饯
* resi_kind_t resi : ͤμ
* bool_t flg_stick : ˡξ?
* abl_kind_t abl : Ѥǽͤμ
* rate_t rate : ᡼¿
* return : ?
***************************************************************/

bool_t	spell_attack(
	chr_t *o_p, chr_t *d_p,
	resi_kind_t resi, bool_t flg_stick,
	abl_kind_t abl, rate_t rate
)
{
	flg_stat_t	o_stat;
	pos_t	o_pos, d_pos;
	static char	o_name[CHR_NAME_MAX_LEN + 1];
	static char	d_name[CHR_NAME_MAX_LEN + 1];
	long	dam;
	long	ac;
	bool_t	flg_serious;

	if( o_p == NULL )
		return FALSE;
	if( d_p == NULL ){
		print_msg( FLG_MSG_ERR, MSG_ERR_MNSTR_NULL );

		if( o_p->kind == CHR_KIND_MBR )
			clr_chr_trgt_act( (mbr_t *)o_p, FALSE );

		return FALSE;
	}

	/* Ʃθ̤ */

	if( cancel_fx_vanish( o_p ) )
		return FALSE;

	/* ø */

	flg_serious = TRUE;
	if( d_p != NULL ){
		if( d_p->attitude == ATTITUDE_MATE ){
			if( o_p->attitude == ATTITUDE_MATE ){
				/* ̣ɤʤø */
				flg_serious = FALSE;
			}
		} else {
			set_enemy_mnstr_group( o_p, d_p );
		}
	}
	if( chk_flg( get_flg_party(), FLG_PARTY_ACTUAL_FIGHTING ) )
		flg_serious = TRUE;

	/* ¦ǡ */

	o_stat = o_p->stat;
	o_pos.x = o_p->x;
	o_pos.y = o_p->y;
	strncpy( o_name, o_p->name, CHR_NAME_MAX_LEN );

	/* ɸ¦ǡ */

	d_pos.x = d_p->x;
	d_pos.y = d_p->y;
	strncpy( d_name, d_p->name, CHR_NAME_MAX_LEN );

	/* Ǥ뤫 */

	if( chk_flg_or( o_stat, FLG_STAT_NOT_EXIST
			| FLG_STAT_DEAD
			| FLG_STAT_STONE
			| FLG_STAT_PARALYZE
			| FLG_STAT_CONFUSION
			| FLG_STAT_SLEEP
			| FLG_STAT_FAINT ) ){
		return FALSE;
	}

	/* Ƥ뤫 */

	if( !chk_find( &o_pos, &d_pos ) ){
		print_msg( FLG_MSG_ERR, MSG_ERR_NOT_FIND, o_name, d_name );

		return FALSE;
	}

	/* ᡼ */

	if( flg_stick )
		dam = get_dam_stick( o_p );
	else
		dam = get_dam_spell( o_p, abl, get_sub_abl( abl ) );
	dam = dam * rate / _100_PERCENT;
	dam = roll_dice( dam, TRUE );

	/* ޡ饹 */

	ac = get_ac( d_p );

	/* и */

	if( flg_stick ){
		char	mjr = '*';

		vfx_arw( o_p->kind, &o_pos, &d_pos, mjr, ANIM_ARW_LEN );
	}

	/* ᡼η׻ */

	dam = calc_resi( get_resi_def( d_p, resi ), dam );
	dam -= ac;
	if( dam < 1 )
		dam = 1;
	if( !flg_serious )
		dam = 0;

	/* ᡼ɽ */

	curs_attrset_chr( d_p, -1, FALSE );
	print_msg_find( d_p, FLG_NULL, MSG_FIGHT_HIT_STD, d_name, dam );
	curs_attrset_dflt();

	/* ɲø */

	added_fx( d_p, resi );

	/* HP򸺤餹 */

	if( d_p->abl.hp.n <= dam ){
		/*  */
		curs_attrset_chr( d_p, -1, TRUE );
		print_msg( FLG_NULL, MSG_FIGHT_KILL_STD, o_name, d_name );
		curs_attrset_dflt();
	}
	add_hp( d_p, -dam, TRUE, FALSE );

	return TRUE;
}

/***************************************************************
* ɲø
* chr_t *chr : 饯
* resi_kind_t resi : ͤμ
***************************************************************/

void	added_fx( chr_t *chr, resi_kind_t resi )
{
	fx_t	*fx;

	if( chr == NULL )
		return;

	/* ܤФ */

	fx = srch_fx( &(chr->fx), FX_KIND_SLEEP );
	clr_fx( fx );

	/* ɲø */

	switch( resi ){
	case RESI_KIND_KNOC:
	case RESI_KIND_SLAS:
	case RESI_KIND_STIN:
	case RESI_KIND_HEAT:
	case RESI_KIND_COLD:
	case RESI_KIND_MIND:
		break;
	case RESI_KIND_ACID:
		fx_acid( chr );
		break;
	case RESI_KIND_ELEC:
		break;
	case RESI_KIND_POIS:
		fx_poison( chr );
		break;
	case RESI_KIND_MAX_N:
		break;
	}
}

/***************************************************************
* Υե
* chr_t *o_p : ¦饯
* chr_t *d_p : ɸ¦饯
* const attack_t *attack : ǡ
***************************************************************/

void	fight_fx( chr_t *o_p, chr_t *d_p, const attack_t *attack )
{
	long	o_lev;

	if( o_p == NULL )
		return;
	if( d_p == NULL )
		return;
	if( attack == NULL )
		return;
	if( attack->fx_kind == FX_KIND_NULL )
		return;

	o_lev = get_specialist_lev( o_p );

	if( !resi_roll( o_p, ABL_KIND_MAX_N, d_p, attack->resi_kind ) )
		set_fx( d_p, attack->fx_kind, attack->fx_turn );
}

/***************************************************************
* ɥ
* chr_t *chr : 饯
* long dr_n : ɥֹ
* return : ?
***************************************************************/

bool_t	chr_break_door( chr_t *chr, long dr_n )
{
	long	hit;
	dun_t	*dun;
	attack_t	attack;

	dun = get_dun();

	if( chr == NULL )
		return FALSE;

	clr_chr_trgt_act( chr, FALSE );

	if( set_attack_chr_bash( chr, &attack, 1, FALSE ) )
		hit = get_hit( chr, &attack );
	else
		hit = get_hit( chr, NULL );
	hit = roll_dice( hit, FALSE );
	hit += hit * chr->fx_data.bless;

	if( DOOR_DEF > hit ){
		if( chr->kind == CHR_KIND_MBR ){
			print_msg( FLG_MSG_ERR, MSG_ERR_DOOR_BREAK_LEV,
					chr->name );
		}
		return FALSE;
	}

	if( !break_door( dr_n ) )
		return FALSE;

	if( chr->kind == CHR_KIND_MBR )
		print_msg( FLG_NULL, MSG_DOOR_BREAK, chr->name );

	return TRUE;
}

/***************************************************************
* 櫤
* chr_t *chr : 饯
* trap_t *trap : 
* return : ?
***************************************************************/

bool_t	chr_break_trap( chr_t *chr, trap_t *trap )
{
	long	hit;
	attack_t	attack;

	if( chr == NULL )
		return FALSE;

	if( set_attack_chr_bash( chr, &attack, 1, FALSE ) )
		hit = get_hit( chr, &attack );
	else
		hit = get_hit( chr, NULL );
	hit = roll_dice( hit, FALSE );
	hit += hit * chr->fx_data.bless;

	if( TRAP_DEF > hit ){
		print_msg( FLG_MSG_ERR, MSG_ERR_TRAP_BREAK_LEV );

		caught_trap( trap, chr );
	} else {
		print_msg( FLG_NULL, MSG_TRAP_BREAK, chr->name );
		caught_trap( trap, chr );
		free_trap( trap );
	}

	return TRUE;
}

/***************************************************************
* ƥ
* chr_t *chr : 饯
* item_t *item : ƥ
* return : ?
***************************************************************/

bool_t	chr_break_item( chr_t *chr, item_t *item )
{
	long	hit;
	attack_t	attack;

	if( chr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	if( item->kind == ITEM_KIND_JUNK ){
		print_msg( FLG_MSG_ERR, MSG_ERR_ITEM_BREAK_BROKEN,
				item->name );

		return TRUE;
	}


	if( set_attack_chr_bash( chr, &attack, 1, FALSE ) )
		hit = get_hit( chr, &attack );
	else
		hit = get_hit( chr, NULL );
	hit = roll_dice( hit, FALSE );
	hit += hit * chr->fx_data.bless;

	if( ITEM_DEF > hit ){
		print_msg( FLG_MSG_ERR, MSG_ERR_ITEM_BREAK_LEV, item->name );

		return FALSE;
	}


	print_msg( FLG_NULL, MSG_ITEM_BREAK, chr->name, item->name );

	break_item_contents( item, chr );
	break_item( item, TRUE );

	draw_item( item );

	return TRUE;
}

/***************************************************************
* м²̡֡פĴ٤
* chr_t *o_p : ¦饯
* chr_t *d_p : ɸ¦饯
* bool_t flg_throw : ƻ?
* return : ?
***************************************************************/

bool_t	chk_slayer( chr_t *o_p, chr_t *d_p, bool_t flg_throw )
{
	item_t	*eq;

	if( o_p == NULL )
		return FALSE;
	if( d_p == NULL )
		return FALSE;

	if( o_p->kind != CHR_KIND_MBR )
		return FALSE;

	eq = get_mbr_item_asgn_equip( (mbr_t *)o_p );
	if( eq == NULL )
		return FALSE;

	if( flg_throw ){
		if( eq[EQUIP_KIND_ARW].kind != ITEM_KIND_WPN )
			return FALSE;
		if( eq[EQUIP_KIND_ARW].dat.wpn.slayer == d_p->face.mjr )
			return TRUE;

		if( eq[EQUIP_KIND_BOW].kind != ITEM_KIND_WPN )
			return FALSE;
		if( eq[EQUIP_KIND_BOW].dat.wpn.slayer == d_p->face.mjr )
			return TRUE;
	} else {
		if( eq[EQUIP_KIND_WIELDING].kind != ITEM_KIND_WPN )
			return FALSE;
		if( eq[EQUIP_KIND_WIELDING].dat.wpn.slayer
				== d_p->face.mjr )
			return TRUE;
	}

	return FALSE;
}

/***************************************************************
* ˡʳʤŨĴ٤
* chr_t *o_p : ¦饯
* chr_t *d_p : ɸ¦饯
* bool_t flg_throw : ƻ?
* return : ˡʳʤʤ TRUEʤ FALSE
***************************************************************/

bool_t	chk_magic_protect( chr_t *o_p, chr_t *d_p, bool_t flg_throw )
{
	if( o_p == NULL )
		return FALSE;
	if( d_p == NULL )
		return FALSE;

	if( !chk_flg( d_p->flg_chr, FLG_CHR_MAGIC_PROTECT ) )
		return FALSE;
	if( o_p->kind != CHR_KIND_MBR )
		return FALSE;

	do {
		item_t	*eq;

		eq = get_mbr_item_asgn_equip( (mbr_t *)o_p );
		if( eq == NULL )
			break;

		if( flg_throw ){
			if( eq[EQUIP_KIND_ARW].kind != ITEM_KIND_WPN )
				break;

			if( eq[EQUIP_KIND_ARW].kind == ITEM_KIND_WPN )
				if( eq[EQUIP_KIND_ARW].dat.wpn.add_hit <= 0 )
					break;
			if( eq[EQUIP_KIND_BOW].kind == ITEM_KIND_WPN )
				if( eq[EQUIP_KIND_BOW].dat.wpn.add_hit <= 0 )
					break;
		} else {
			if( eq[EQUIP_KIND_WIELDING].kind != ITEM_KIND_WPN )
				break;
			if( eq[EQUIP_KIND_WIELDING].dat.wpn.add_hit <= 0 )
				break;
		}

		return FALSE;
	} while( 0 );

	print_msg( FLG_NULL, MSG_FIGHT_MAGIC_PROTECT, d_p->name );
	return TRUE;
}

/***************************************************************
* 饯ιϤ׻
* chr_t *p : 饯
* const attack_t *attack : ǡ
* return : 
***************************************************************/

long	get_hit( chr_t *p, const attack_t *attack )
{
	long	hit, wpn_hit;
	abl_kind_t	abl;

	if( p == NULL )
		return 1;
	if( attack == NULL )
		return 1;

	/* ǽ */

	wpn_hit = attack->hit;

	if( attack->flg_throw )
		abl = ABL_KIND_HUN;
	else if( attack->flg_monk )
		abl = ABL_KIND_MON;
	else
		abl = ABL_KIND_FIG;

	hit = 0;
	hit += calc_lev_to_val( get_lev( p, ABL_KIND_DEX ), ABL_KIND_DEX );
	hit += calc_lev_to_val( get_lev( p, abl ), abl );
	hit /= 2;

	if( abl == ABL_KIND_MON ){
		long	n;

		n = get_lev( p, abl );
		wpn_hit += HIT_MON_MUL * n;
		if( n > 0 )
			wpn_hit += HIT_MON_ADD;
	}

	if( p->kind == CHR_KIND_MBR )
		hit = hit * calc_rate_abl_equip( p, abl ) / _100_PERCENT;

	/* FXͤä */

	wpn_hit += p->fx_data.wpn_hit;

#ifdef	FLG_ITEM_ADD_RATE

	hit += HIT_FIT_AVE_N * wpn_hit / _100_PERCENT;

#else	/* FLG_ITEM_ADD_RATE */

	hit = hit * wpn_hit / _100_PERCENT;

#endif	/* FLG_ITEM_ADD_RATE */

	if( hit < 1 )
		hit = 1;

	return hit;
}

/***************************************************************
* 饯Υ᡼׻
* chr_t *p : 饯
* const attack_t *attack : ǡ
* return : ᡼
***************************************************************/

long	get_dam( chr_t *p, const attack_t *attack )
{
	long	dam, wpn_dam;
	abl_kind_t	abl, sub_abl;

	if( p == NULL )
		return 1;
	if( attack == NULL )
		return 1;

	/* ǽ */

	wpn_dam = attack->dam;

	if( attack->flg_throw ){
		abl = ABL_KIND_HUN;
		sub_abl = ABL_KIND_DEX;
	} else if( attack->flg_monk ){
		abl = ABL_KIND_MON;
		sub_abl = ABL_KIND_STR;
	} else {
		abl = ABL_KIND_FIG;
		sub_abl = ABL_KIND_STR;
	}

	dam = 0;
	dam += calc_lev_to_val( get_lev( p, abl ), abl );
	dam += calc_lev_to_val( get_lev( p, sub_abl ), sub_abl );
	dam /= 2;

	if( abl == ABL_KIND_MON ){
		long	n;

		n = get_lev( p, abl );
		wpn_dam += DAM_MON_MUL * n;
		if( n > 0 )
			wpn_dam += DAM_MON_ADD;
	}

	if( p->kind == CHR_KIND_MBR )
		dam = dam * calc_rate_abl_equip( p, abl ) / _100_PERCENT;

	/* FXͤä */

	wpn_dam += p->fx_data.wpn_dam;

#ifdef	FLG_ITEM_ADD_RATE

	dam += DAM_FIT_AVE_N * wpn_dam / _100_PERCENT;

#else	/* FLG_ITEM_ADD_RATE */

	dam = dam * wpn_dam / _100_PERCENT;

#endif	/* FLG_ITEM_ADD_RATE */

	if( dam < 1 )
		dam = 1;

	return dam;
}

/***************************************************************
* 饯ɸϤ׻
* chr_t *p : 饯
* return : ɸ
***************************************************************/

long	get_def( chr_t *p )
{
	long	def;
	rate_t	armor_def;
	abl_kind_t	abl;

	if( p == NULL )
		return 1;

	/* ǽ */

	abl = get_def_abl( p );

	def = 0;
	def += calc_lev_to_val( get_lev( p, ABL_KIND_AGI ), ABL_KIND_AGI );
	def += calc_lev_to_val( get_lev( p, abl ), abl );
	def /= 2;

	if( p->kind == CHR_KIND_MBR )
		def = def * calc_rate_abl_equip( p, abl ) / _100_PERCENT;

	armor_def = get_armor_def( p, abl );

	if( armor_def < DEF_MIN_RATE )
		armor_def = DEF_MIN_RATE;

#ifdef	FLG_ITEM_ADD_RATE

	def += DEF_AVE_N * armor_def / _100_PERCENT;

#else	/* FLG_ITEM_ADD_RATE */

	def = def * armor_def / _100_PERCENT;

#endif	/* FLG_ITEM_ADD_RATE */

	if( def < 1 )
		def = 1;

	return def;
}

/***************************************************************
* 饯ɸ˻Ȥǽͤμ֤
* chr_t *p : 饯
* return : ǽͤμ
***************************************************************/

abl_kind_t	get_def_abl( chr_t *p )
{
	if( p == NULL )
		return ABL_KIND_FIG;

	if( p->kind == CHR_KIND_MBR ){
		item_t	*eq;
		bool_t	*flg_abl;

		eq = get_mbr_item_asgn_equip( (mbr_t *)p );
		if( eq == NULL )
			return ABL_KIND_FIG;

		if( eq[EQUIP_KIND_WIELDING].kind != ITEM_KIND_WPN )
			return ABL_KIND_MON;

		if( eq[EQUIP_KIND_WIELDING].tab.wpn == NULL )
			return ABL_KIND_MON;

		flg_abl = eq[EQUIP_KIND_WIELDING].tab.wpn->flg_abl;
		if( flg_abl[ABL_KIND_MON] )
			return ABL_KIND_MON;
		else
			return ABL_KIND_FIG;
	} else {
		return ABL_KIND_FIG;
	}

	return ABL_KIND_FIG;
}

/***************************************************************
* 饯ɸϤ׻
* chr_t *p : 饯
* abl_kind_t abl : ǽͤμ
* return : ɸ
***************************************************************/

long	get_armor_def( chr_t *p, abl_kind_t abl )
{
	long	armor_def = 0;

	if( abl == ABL_KIND_MON ){
		long	n;

		n = get_lev( p, abl );
		armor_def += DEF_MON_MUL * n;
		if( n > 0 )
			armor_def += DEF_MON_ADD;

		return armor_def;
	}

	if( p->kind == CHR_KIND_MBR ){
		item_t	*eq;
		long	i;

		/* ɶΥơ֥ */

		eq = get_mbr_item_asgn_equip( (mbr_t *)p );
		if( eq == NULL )
			return 1;

		/* ɶͤä */

		for( i = 0; i < EQUIP_KIND_MAX_N; i++ ){
			if( eq[i].kind != ITEM_KIND_ARMOR )
				continue;
			if( eq[i].tab.armor == NULL )
				continue;

			armor_def += eq[i].tab.armor->def;
			armor_def += add_def(
					eq[i].dat.armor.add_def );
		}
	} else if( p->kind == CHR_KIND_MNSTR ){
		/* ɶͤä */

		armor_def += p->mnstr_tab->def;
		armor_def += add_def( p->add_def );
	}

	/* FXͤä */

	armor_def += p->fx_data.armor_def;

	return armor_def;
}

/***************************************************************
* 饯Υޡ饹׻
* chr_t *p : 饯
* return : ޡ饹
***************************************************************/

long	get_ac( chr_t *p )
{
	long	ac;
	rate_t	armor_ac;

	if( p == NULL )
		return 1;

	ac = 0;
	armor_ac = 0;

	if( p->kind == CHR_KIND_MBR ){
		item_t	*eq;
		long	i;

		/* ɶΥơ֥ */

		eq = get_mbr_item_asgn_equip( (mbr_t *)p );
		if( eq == NULL )
			return 0;

		/* ɶͤä */

		for( i = 0; i < EQUIP_KIND_MAX_N; i++ ){
			if( eq[i].kind != ITEM_KIND_ARMOR )
				continue;
			if( eq[i].tab.armor == NULL )
				continue;

			armor_ac += eq[i].tab.armor->ac;
			armor_ac += add_ac(
					eq[i].dat.armor.add_ac );
		}
	} else if( p->kind == CHR_KIND_MNSTR ){
		/* ɶͤä */

		armor_ac += p->mnstr_tab->ac;
		armor_ac += add_ac( p->add_ac );
	}

	/* FXͤä */

	armor_ac += p->fx_data.armor_ac;

	ac = AC_AVE_N * armor_ac / _100_PERCENT;

	if( ac < 1 )
		ac = 1;

	return ac;
}

/***************************************************************
* ƥΨ򹶷¦ɸ¦ͤƷ׻
* chr_t *o_p : ¦饯
* chr_t *d_p : ɸ¦饯
* const attack_t *attack : ǡ
* return : ƥΨ
***************************************************************/

rate_t	get_crtcl( chr_t *o_p, chr_t *d_p, const attack_t *attack )
{
	rate_t	rate;

	rate = get_wpn_crtcl( o_p, attack );
	rate -= get_armor_crtcl( d_p );

	if( rate < 1 )
		rate = 1;

	return rate;
}

/***************************************************************
* ¦ΥƥΨ׻
* chr_t *p : 饯
* const attack_t *attack : ǡ
* return : ƥΨ
***************************************************************/

rate_t	get_wpn_crtcl( chr_t *p, const attack_t *attack )
{
	rate_t	crtcl, wpn_crtcl, thf;

	if( p == NULL )
		return 1;
	if( attack == NULL )
		return 1;

	/* ǽ */

	thf = 0;
	thf += get_lev( p, ABL_KIND_THI );
	thf += get_lev( p, ABL_KIND_DEX );
	thf /= 2;
	thf = thf * WPN_CRTCL_THF_LEV_RATE / _100_PERCENT;
	if( thf > WPN_CRTCL_THF_MAX_RATE )
		thf = WPN_CRTCL_THF_MAX_RATE;

	crtcl = thf;

	/* ͤä */

	wpn_crtcl = attack->crtcl;

	/* FXͤä */

	wpn_crtcl += p->fx_data.wpn_crtcl;

#ifdef	FLG_ITEM_ADD_RATE

	crtcl += WPN_CRTCL_FIT_AVE_N * wpn_crtcl / _100_PERCENT;

#else	/* FLG_ITEM_ADD_RATE */

	crtcl += WPN_CRTCL_FIT_AVE_N;
	crtcl = crtcl * wpn_crtcl / _100_PERCENT;

#endif	/* FLG_ITEM_ADD_RATE */

	if( crtcl < 1 )
		crtcl = 1;

	return crtcl;
}

/***************************************************************
* ɸ¦ΥƥΨ׻
* chr_t *p : 饯
* return : ƥΨ
***************************************************************/

rate_t	get_armor_crtcl( chr_t *p )
{
	rate_t	crtcl, armor_crtcl;

	if( p == NULL )
		return 1;

	crtcl = 0;
	armor_crtcl = 0;

	if( p->kind == CHR_KIND_MBR ){
		item_t	*eq;
		long	i;

		/* ɶΥơ֥ */

		eq = get_mbr_item_asgn_equip( (mbr_t *)p );
		if( eq == NULL )
			return 0;

		/* ɶͤä */

		for( i = 0; i < EQUIP_KIND_MAX_N; i++ ){
			if( eq[i].kind != ITEM_KIND_ARMOR )
				continue;
			if( eq[i].tab.armor == NULL )
				continue;

			armor_crtcl += eq[i].tab.armor->crtcl;
			armor_crtcl += add_armor_crtcl(
					eq[i].dat.armor.add_crtcl );
		}
	} else if( p->kind == CHR_KIND_MNSTR ){
		/* ɶͤä */

		armor_crtcl += p->mnstr_tab->armor_crtcl;
		armor_crtcl += add_armor_crtcl( p->add_crtcl );
	}

	/* FXͤä */

	armor_crtcl += p->fx_data.armor_crtcl;

	crtcl = ARMOR_CRTCL_AVE_N * armor_crtcl / _100_PERCENT;

	if( crtcl < 1 )
		crtcl = 1;

	return crtcl;
}

/***************************************************************
* ڤ꤬ȯĴ٤
* chr_t *o_p : ¦饯
* chr_t *d_p : ɸ¦饯
* return : ڤ꤬ȯ?
***************************************************************/

bool_t	chk_ninja_crtcl( chr_t *o_p, chr_t *d_p )
{
	abl_kind_t	o_abl_m, o_abl_s;
	abl_kind_t	d_abl_m, d_abl_s;
	long	o_val, d_val;
	long	o_dice, d_dice;

	if( o_p == NULL )
		return FALSE;
	if( d_p == NULL )
		return FALSE;

	if( chk_resi_stat( d_p, FLG_STAT_DEAD ) )
		return FALSE;

	o_abl_m = ABL_KIND_NIN;
	o_abl_s = ABL_KIND_DEX;
	o_val = 0;
	o_val += calc_lev_to_val( get_lev( o_p, o_abl_m ), o_abl_m );
	o_val += calc_lev_to_val( get_lev( o_p, o_abl_s ), o_abl_s );
	o_val /= 2;

	d_abl_m = get_specialist_abl( d_p );
	d_abl_s = ABL_KIND_DEX;
	d_val = 0;
	d_val += calc_lev_to_val( get_lev( d_p, d_abl_m ), d_abl_m );
	d_val += calc_lev_to_val( get_lev( d_p, d_abl_s ), d_abl_s );
	d_val /= 2;

	if( get_lev( o_p, ABL_KIND_NIN ) <= 0 )
		return FALSE;

	o_val = o_val * NINJA_CRTCL_RATE / _100_PERCENT;

	o_dice = roll_dice( o_val, FALSE );
	d_dice = roll_dice( d_val, FALSE );

	if( o_dice > d_dice )
		return TRUE;
	else
		return FALSE;
}

/***************************************************************
* ˤ᡼׻
* chr_t *p : 饯
* return : ˤ᡼
***************************************************************/

long	get_dam_stick( chr_t *p )
{
	abl_kind_t	abl_main, abl_sub;

	long	dam;

	if( p == NULL )
		return 1;

	abl_main = get_specialist_abl( p );
	abl_sub = get_specialist_abl( p );

	dam = 0;
	dam += calc_lev_to_val( get_lev( p, abl_main ), abl_main );
	dam += calc_lev_to_val( get_lev( p, abl_sub ), abl_sub );
	dam /= 2;

	dam = dam * DAM_STICK_RATE / _100_PERCENT;
	dam += DAM_STICK_ADD;

	if( dam < 1 )
		dam = 1;

	return dam;
}

/***************************************************************
* ʸˤ᡼׻
* chr_t *p : 饯
* abl_kind_t abl_main : ǽͤμ
* abl_kind_t abl_sub : ǽͤμ
* return : ʸˤ᡼
***************************************************************/

long	get_dam_spell( chr_t *p, abl_kind_t abl_main, abl_kind_t abl_sub )
{
	long	dam;

	if( p == NULL )
		return 1;

	dam = 0;
	dam += calc_lev_to_val( get_lev( p, abl_main ), abl_main );
	dam += calc_lev_to_val( get_lev( p, abl_sub ), abl_sub );
	dam /= 2;

	dam = dam * DAM_SPELL_RATE / _100_PERCENT;
	dam += DAM_SPELL_ADD;

	if( dam < 1 )
		dam = 1;

	return dam;
}

/***************************************************************
* 饯ͤ׻
* chr_t *p : 饯
* resi_kind_t resi : ͤμ
* return : 饯
***************************************************************/

rate_t	get_resi_def( chr_t *p, resi_kind_t resi )
{
	rate_t	n;

	if( p == NULL )
		return _100_PERCENT;

	n = get_resi( p, resi );
	if( n == RESI_PERFECT_N )
		return RESI_PERFECT_N;
	if( n < 1)
		n = 1;

	return n;
}

/***************************************************************
* 饯ƱΤεΥ顢ƻιΨ׻
* chr_t *o_p : ¦饯
* chr_t *d_p : ɸ¦饯
* return : ƻιΨ
***************************************************************/

rate_t	get_chr_throw_range_rate( chr_t *o_p, chr_t *d_p )
{
	rate_t	rate;

	if( o_p == NULL )
		return 0;
	if( d_p == NULL )
		return 0;

	rate = get_throw_range_rate(
			o_p->trgt.true_x, o_p->trgt.true_y,
			d_p->trgt.true_x, d_p->trgt.true_y );

	return rate;
}

/***************************************************************
* ֤εΥ顢ƻιΨ׻
* long x1 : Xɸ
* long y1 : Yɸ
* long x2 : Xɸ
* long y2 : Yɸ
* return : ƻιΨ
***************************************************************/

rate_t	get_throw_range_rate( long x1, long y1, long x2, long y2 )
{
	long	dx, dy, r;
	rate_t	rate;

	if( !clip_pos( x1, y1 ) )
		return 0;
	if( !clip_pos( x2, y2 ) )
		return 0;

	dx = labs( x1 - x2 );
	dy = labs( y1 - y2 );

	r = max_l( dx, dy );

	rate = _100_PERCENT;
	rate -= r * RATE_PER_RANGE / _100_PERCENT;

	print_msg( FLG_MSG_DEBUG, "fight range rate: %ld", rate );

	return rate;
}

/***************************************************************
* μ̤Υå֤
* const attack_t *attack : ǡ
* return : μ̤Υå
***************************************************************/

char	*get_msg_attack( const attack_t *attack )
{
	switch( attack->kind ){
	case ATTACK_KIND_NULL:
		break;
	case ATTACK_KIND_SPELL:
	case ATTACK_KIND_SPELL_SELF:
	case ATTACK_KIND_SPELL_FRIEND:
		break;
	case ATTACK_KIND_PUNCH:
		return MSG_ATTACK_PUNCH;
	case ATTACK_KIND_KICK:
		return MSG_ATTACK_KICK;
	case ATTACK_KIND_KNOCK:
		return MSG_ATTACK_KNOCK;
	case ATTACK_KIND_SLASH:
		return MSG_ATTACK_SLASH;
	case ATTACK_KIND_STING:
		return MSG_ATTACK_STING;
	case ATTACK_KIND_MOW:
		return MSG_ATTACK_MOW;
	case ATTACK_KIND_SHOOT:
		return MSG_ATTACK_SHOOT;
	case ATTACK_KIND_THROW:
		return MSG_ATTACK_THROW;
	case ATTACK_KIND_BITE:
		return MSG_ATTACK_BITE;
	case ATTACK_KIND_PECK:
		return MSG_ATTACK_PECK;
	case ATTACK_KIND_CLAW:
		return MSG_ATTACK_CLAW;
	case ATTACK_KIND_NIP:
		return MSG_ATTACK_NIP;
	case ATTACK_KIND_STRANGLE:
		return MSG_ATTACK_STRANGLE;
	case ATTACK_KIND_TACKLE:
		return MSG_ATTACK_TACKLE;
	case ATTACK_KIND_TOUCH:
		return MSG_ATTACK_TOUCH;
	case ATTACK_KIND_INDICATE:
		return MSG_ATTACK_INDICATE;
	case ATTACK_KIND_KISS:
		return MSG_ATTACK_KISS;
	case ATTACK_KIND_SEDUCE:
		return MSG_ATTACK_SEDUCE;
	case ATTACK_KIND_CARESS_BUST:
		return MSG_ATTACK_CARESS_BUST;
	case ATTACK_KIND_CARESS_HIP:
		return MSG_ATTACK_CARESS_HIP;
	case ATTACK_KIND_CARESS_CROTCH:
		return MSG_ATTACK_CARESS_CROTCH;
	case ATTACK_KIND_MAX_N:
		break;
	}

	return MSG_NULL;
}
