/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2006 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: gmain.c,v 1.72 2006/02/01 18:35:37 bowkenken Exp $
***************************************************************/

/***************************************************************
* ᥤ
***************************************************************/

#define	EXTERN

#define	GMAIN_C
#include	"inc.h"

/***************************************************************
* ν
***************************************************************/

void	init_arg( void )
{
	g_flg_debug = FALSE;
#ifdef	DEBUG
	g_flg_debug = TRUE;
#endif	/* DEBUG */
#ifdef	NDEBUG
	g_flg_debug = FALSE;
#endif	/* NDEBUG */

	g_flg_cui = TRUE;
	g_flg_gui = FALSE;
	g_gui_key_kind = GUI_KEY_KIND_CONSOLE;

	g_flg_clr_key_buf = TRUE;
	g_flg_clr_key_buf_menu = TRUE;

	g_flg_echo_key = FALSE;

	g_flg_use_curs = TRUE;
	g_flg_use_keypad = FALSE;

	g_flg_measure_clk_tck = FALSE;
}

/***************************************************************
* Τν
***************************************************************/

void	init_game( void )
{
	dun_t	*dun;

	g_flg_init = FALSE;

	init_signal();
	init_scrn();

	srandm( time( NULL ) );
	init_turn();

	init_msg();
	init_draw();

	ena_scrn( TRUE );
	ena_curs_draw();
	wipe_all();

	init_game_file();

	init_var_menu();
	init_var_main_menu();
	init_var_misc_menu();

	if( !load_game_conf() )
		g_flg_measure_clk_tck = TRUE;

	init_dun();
	init_item();
	init_trap();
	init_fx();
	init_chr();
	init_spell();
	init_town();
	init_menu();
	init_tmenu();
	init_auto_menu();
	init_misc_menu();
	init_main_menu();
	init_request();

	init_mbr_formation();
	init_spell_nin();

	if( g_flg_debug )
		set_flg_no_save( TRUE );

	if( g_flg_measure_clk_tck )
		measure_clk_tck();

	dun = get_dun();
	dun->lev = 0;
	up_dun( 0 );

	g_flg_init = TRUE;
}

/***************************************************************
* ᥤ󡦥롼
***************************************************************/

void	game_main( void )
{
	if( !g_flg_debug ){
		door_t	*dr;

		print_msg( FLG_NULL, MSG_HINT_CANCEL_MENU_1 );
		print_msg( FLG_NULL, MSG_HINT_CANCEL_MENU_2 );

		menu_bar_load();

		dr = get_shop_door( SHOP_N_BAR );
		if( dr != NULL ){
			open_door_shop( dr->n );
			exec_all_phase();
		}
	}

	while( 1 ){
		chk_key( TRUE, TRUE );
	}
}

/***************************************************************
* νλ
* long code : λ
***************************************************************/

void	exit_game( long code )
{
	FILE	*fp;

	curs_move( WIN_MSG_DRAW_MIN_Y, SCREEN_MIN_X );

	reset_scrn();

	if( code == 0 )
		fp = stdout;
	else
		fp = stderr;

	version( fp );

	exit( code );
}

/***************************************************************
* ɽ
***************************************************************/

void	about_game( void )
{
	static char	tmp[1023 + 1];

	curs_move( WIN_MSG_DRAW_MIN_Y, SCREEN_MIN_X );

	dis_scrn();

	fprintf( OUT_FP, MSG_FMT_COPYRIGHT, LS_STR_COPYRIGHT );
	fprintf( OUT_FP, "\n%s\n", MSG_HIT_ENTER_KEY );
	fflush( OUT_FP );
	fgets( tmp, sizeof( tmp ) - 1, stdin );

	fprintf( OUT_FP, MSG_S, MSG_ABOUT_GAME );
	fprintf( OUT_FP, "\n%s\n", MSG_HIT_ENTER_KEY );
	fflush( OUT_FP );
	fgets( tmp, sizeof( tmp ) - 1, stdin );

	ena_scrn( FALSE );
}

/***************************************************************
* ΥСɽ
* FILE *fp : ե
***************************************************************/

void	version( FILE *fp )
{
	fprintf( fp, STR_FMT_COPYRIGHT, LS_STR_COPYRIGHT );
	fflush( fp );
}

/***************************************************************
* ƤӽФ
***************************************************************/

void	child_ps( void )
{
#ifdef	D_DOS
	child_ps_dos();
#else	/* D_DOS */
	child_ps_unix();
#endif	/* D_DOS */
}

/***************************************************************
* ʥν
***************************************************************/

void	init_signal( void )
{
#ifdef	D_X68K
	signal( SIGINT, signal_handler );
	signal( SIGABRT, signal_handler );
	signal( SIGTERM, signal_handler );
#elif	defined( D_DOS )
	signal( SIGINT, signal_handler );
	signal( SIGSEGV, signal_handler );
	signal( SIGABRT, signal_handler );
	signal( SIGTERM, signal_handler );
#else	/* D_X68K */
	signal( SIGHUP, signal_handler );
	signal( SIGINT, signal_handler );
	signal( SIGKILL, signal_handler );
	signal( SIGBUS, signal_handler );
	signal( SIGSEGV, signal_handler );
	signal( SIGABRT, signal_handler );
	signal( SIGTERM, signal_handler );
#endif	/* D_X68K */
}

/***************************************************************
* ʥνϥɥ
* int sig : ʥ
***************************************************************/

void	signal_handler( int sig )
{
	reset_scrn();

	exit( EXIT_FAILURE );
}

/***************************************************************
* ̤ν
***************************************************************/

void	init_scrn( void )
{
	init_curs();
	init_term();
}

/***************************************************************
* ̤Υꥻå
***************************************************************/

void	reset_scrn( void )
{
	while( chk_term() )
		dis_term();

	curs_refresh();
	while( chk_curs() ){
		curs_endwin();
	}
}

/***************************************************************
* ̤ͭ
* bool_t flg_initscr : curses 뤫?
***************************************************************/

void	ena_scrn( bool_t flg_initscr )
{
	if( flg_initscr ){
		curs_initscr();
		curs_keypad( stdscr, TRUE );
	} else {
		curs_clearok( stdscr, TRUE );
		curs_refresh();
	}

	ena_term();
}

/***************************************************************
* ̵̤
***************************************************************/

void	dis_scrn( void )
{
	dis_term();

	curs_refresh();
	curs_endwin();
}

/***************************************************************
* üν
***************************************************************/

void	init_term( void )
{
#ifdef	D_DOS
	init_term_dos();
#else	/* D_DOS */
	init_term_unix();
#endif	/* D_DOS */
}

/***************************************************************
* üͭĴ٤
* return : üͭ?
***************************************************************/

bool_t	chk_term( void )
{
#ifdef	D_DOS
	return chk_term_dos();
#else	/* D_DOS */
	return chk_term_unix();
#endif	/* D_DOS */
}

/***************************************************************
* üͭ
***************************************************************/

void	ena_term( void )
{
#ifdef	D_DOS
	ena_term_dos();
#else	/* D_DOS */
	ena_term_unix();
#endif	/* D_DOS */
}

/***************************************************************
* ü̵
***************************************************************/

void	dis_term( void )
{
#ifdef	D_DOS
	dis_term_dos();
#else	/* D_DOS */
	dis_term_unix();
#endif	/* D_DOS */
}

/***************************************************************
* Ԥ
***************************************************************/

void	set_key_wait( void )
{
#ifdef	D_DOS
	set_key_wait_dos();
#else	/* D_DOS */
	set_key_wait_unix();
#endif	/* D_DOS */
}

/***************************************************************
* Ԥ
***************************************************************/

void	clr_key_wait( void )
{
#ifdef	D_DOS
	clr_key_wait_dos();
#else	/* D_DOS */
	clr_key_wait_unix();
#endif	/* D_DOS */
}

