/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2006 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: MapFormInit.cpp,v 1.18 2006/02/02 19:37:24 bowkenken Exp $
***************************************************************/

#include <WScom.h>
#include <WSCfunctionList.h>
#include <WSCbase.h>

#include <WSCvscrBar.h>
#include <WSCwindow.h>

#include "menu.h"
#include "draw.h"
#include "imenu-prot.h"
#include "draw-prot.h"

#include "Key.h"
#include "MouseMotion.h"
#include "GlobalVar.h"

extern WSCvscrBar *MapScrollX;
extern WSCvscrBar *MapScrollY;
extern WSCwindow* MenuWin;

////////////////////////////////////////////////////////////////
// ޥˤݥȤΥ롦Хå
// MouseMotion::MouseButtonN n : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

static void funcMotionPoint(
		MouseMotion::MouseButtonN n,
		long nBgnX, long nBgnY,
		long nCurX, long nCurY )
{
	if( (WSCbool)(MenuWin->getProperty( WSNvis )) )
		return;

	long x = (long)MapScrollX->getProperty( WSNvalue );
	long y = (long)MapScrollY->getProperty( WSNvalue );

	long mapX = (x + nCurX) / gPcgDun.nTileSizeX;
	long mapY = (y + nCurY) / gPcgDun.nTileSizeY;

	move_crsr_abs( mapX, mapY );

	set_flg_break_key( TRUE );
}

////////////////////////////////////////////////////////////////
// ɥåΥ롦Хå
// MouseMotion::MouseButtonN n : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

static void funcMotionDragL(
		MouseMotion::MouseButtonN n,
		long nBgnX, long nBgnY,
		long nCurX, long nCurY )
{
	if( (WSCbool)(MenuWin->getProperty( WSNvis )) )
		return;

	long x = gMapDragBgnX - (nCurX - nBgnX);
	long y = gMapDragBgnY - (nCurY - nBgnY);
	long w = (long)MapScrollX->getProperty( WSNmaximum );
	long h = (long)MapScrollY->getProperty( WSNmaximum );

	if( x < 0 )
		x = 0;
	if( x > w)
		x = w;
	if( y < 0 )
		y = 0;
	if( y > h)
		y = h;

	x = (x / gPcgDun.nTileSizeX) * gPcgDun.nTileSizeX;
	y = (y / gPcgDun.nTileSizeY) * gPcgDun.nTileSizeY;

	if( gPcgDun.chkScroll( x, y, w, h ) )
		gPcgDun.scrollMap( x, y );
}

////////////////////////////////////////////////////////////////
// ܥκɥåΥ롦Хå
// MouseMotion::MouseButtonN n : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

static void funcMotionLeftR(
		MouseMotion::MouseButtonN n,
		long nBgnX, long nBgnY,
		long nCurX, long nCurY )
{
	gKey.setString( "/" );
}

////////////////////////////////////////////////////////////////
// ܥαɥåΥ롦Хå
// MouseMotion::MouseButtonN n : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

static void funcMotionRightR(
		MouseMotion::MouseButtonN n,
		long nBgnX, long nBgnY,
		long nCurX, long nCurY )
{
	gKey.setString( "*" );
}

////////////////////////////////////////////////////////////////
// ܥξɥåΥ롦Хå
// MouseMotion::MouseButtonN n : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

static void funcMotionUpR(
		MouseMotion::MouseButtonN n,
		long nBgnX, long nBgnY,
		long nCurX, long nCurY )
{
	gKey.setString( "-" );
}

////////////////////////////////////////////////////////////////
// ܥβɥåΥ롦Хå
// MouseMotion::MouseButtonN n : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

static void funcMotionDownR(
		MouseMotion::MouseButtonN n,
		long nBgnX, long nBgnY,
		long nCurX, long nCurY )
{
	gKey.setString( "+" );
}

////////////////////////////////////////////////////////////////
// 汦åΥ롦Хå
// MouseMotion::MouseButtonN n : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

static void funcMotionClick(
		MouseMotion::MouseButtonN n,
		long nBgnX, long nBgnY,
		long nCurX, long nCurY )
{
	if( n == MouseMotion::nMouseButtonL ){
		gKey.setChar( 'M' - '@' );
	}

	if( n == MouseMotion::nMouseButtonM ){
		gKey.setString( "." );
	}

	if( n == MouseMotion::nMouseButtonR ){
		gKey.setString( "0" );
	}
}

////////////////////////////////////////////////////////////////
// ƱåΥ롦Хå
// MouseMotion::MouseButtonN n : ˥ץ쥹ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

static void funcMotionClickLR(
		MouseMotion::MouseButtonN n,
		long nBgnX, long nBgnY,
		long nCurX, long nCurY )
{
	if( n == MouseMotion::nMouseButtonL ){
		gKey.setString( "5" );
	}

	if( n == MouseMotion::nMouseButtonR ){
		gKey.setString( "v" );
	}
}

//----------------------------------------------------------
//Function for the event procedure
//----------------------------------------------------------
void MapFormInit(WSCbase* object){
  //do something...
	gKey.init();

	MapScrollX->execProcedure( "MapScrollXDraw" );
	MapScrollY->execProcedure( "MapScrollYDraw" );

	// ݥ

	gMouseMotion.setFuncPoint(
			funcMotionPoint );

	// ɥå

	gMouseMotion.setFunc(
			MouseMotion::nMouseButtonL,
			MouseMotion::nMotionDrag,
			funcMotionDragL );

	// ܥκɥåΥ롦Хå

	gMouseMotion.setFunc(
			MouseMotion::nMouseButtonR,
			MouseMotion::nMotionLeft,
			funcMotionLeftR );

	// ܥαɥåΥ롦Хå

	gMouseMotion.setFunc(
			MouseMotion::nMouseButtonR,
			MouseMotion::nMotionRight,
			funcMotionRightR );

	// ܥξɥåΥ롦Хå

	gMouseMotion.setFunc(
			MouseMotion::nMouseButtonR,
			MouseMotion::nMotionUp,
			funcMotionUpR );

	// ܥβɥåΥ롦Хå

	gMouseMotion.setFunc(
			MouseMotion::nMouseButtonR,
			MouseMotion::nMotionDown,
			funcMotionDownR );

	// å

	gMouseMotion.setFuncClick(
			MouseMotion::nMouseButtonL,
			funcMotionClick );

	// 楯å

	gMouseMotion.setFuncClick(
			MouseMotion::nMouseButtonM,
			funcMotionClick );

	// å

	gMouseMotion.setFuncClick(
			MouseMotion::nMouseButtonR,
			funcMotionClick );

	// ץ쥹 + å

	gMouseMotion.setFuncClickLR(
			MouseMotion::nMouseButtonL,
			funcMotionClickLR );

	// ץ쥹 + å

	gMouseMotion.setFuncClickLR(
			MouseMotion::nMouseButtonR,
			funcMotionClickLR );
}
static WSCfunctionRegister  op("MapFormInit",(void*)MapFormInit);
