/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2006 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: amenu.c,v 1.57 2006/08/11 00:43:13 bowkenken Exp $
***************************************************************/

/***************************************************************
* ưޡ
***************************************************************/

#define	AMENU_C
#include	"inc.h"

/***************************************************************/

#define	STR_TTL_AUTO_MARK_SPLIT_NAME	" - "
#define	STR_TTL_AUTO_MARK_SPLIT_CODE	"\n"

/***************************************************************/

static auto_mark_t	ls_auto_mark[LS_MBR_MAX_N][AUTO_MARK_MAX_N];
static auto_mark_t	clip_board_large[LS_MBR_MAX_N];
static auto_mark_t	clip_board_small;

static char	msg_ttl_auto_mark[AUTO_MARK_MAX_N]
		[MSG_TTL_AUTO_MARK_MAX_LEN + 1];
static char	clip_board_ttl
		[MSG_TTL_AUTO_MARK_MAX_LEN + 1];

static long	auto_mark_cur_n;
static mbr_t	*g_sel_mbr;

static auto_mark_t	dflt_auto_mark_fight = {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_ACT_FIGHT,
	AUTO_MARK_COND_DISPERSE,
	"",
	FLG_AUTO_MARK_EDIT_CONT,
};

static auto_mark_t	dflt_auto_mark_fight_prio = {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_ACT_FIGHT,
	AUTO_MARK_COND_DISPERSE,
	"",
	FLG_AUTO_MARK_EDIT_PRIORITY | FLG_AUTO_MARK_EDIT_CONT,
};

static auto_mark_t	dflt_auto_mark_throw = {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_DIST_MEDIUM,
	AUTO_MARK_ACT_THROW,
	AUTO_MARK_COND_DISPERSE,
	"",
	FLG_NULL,
};

static auto_mark_t	dflt_auto_mark_throw_prio = {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_DIST_MEDIUM,
	AUTO_MARK_ACT_THROW,
	AUTO_MARK_COND_DISPERSE,
	"",
	FLG_AUTO_MARK_EDIT_PRIORITY | FLG_AUTO_MARK_EDIT_CONT,
};

static auto_mark_t	dflt_auto_mark_fight_far = {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_DIST_FAR,
	AUTO_MARK_ACT_FIGHT,
	AUTO_MARK_COND_DISPERSE,
	"",
	FLG_NULL,
};

static auto_mark_t	dflt_auto_mark_fight_far_prio = {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_DIST_FAR,
	AUTO_MARK_ACT_FIGHT,
	AUTO_MARK_COND_DISPERSE,
	"",
	FLG_AUTO_MARK_EDIT_PRIORITY | FLG_AUTO_MARK_EDIT_CONT,
};

static auto_mark_t	dflt_auto_mark_fight_all = {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_ACT_FIGHT,
	AUTO_MARK_COND_DISPERSE,
	"",
	FLG_NULL,
};

static auto_mark_t	dflt_auto_mark_fight_all_prio = {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_ACT_FIGHT,
	AUTO_MARK_COND_DISPERSE,
	"",
	FLG_AUTO_MARK_EDIT_PRIORITY | FLG_AUTO_MARK_EDIT_CONT,
};

static auto_mark_t	dflt_auto_mark_item_all = {
	AUTO_MARK_TRGT_ITEM,
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_ACT_PICK_UP,
	AUTO_MARK_COND_DISPERSE,
	"",
	FLG_AUTO_MARK_EDIT_PRIORITY | FLG_AUTO_MARK_EDIT_CONT,
};

static auto_mark_t	dflt_auto_mark_item_own = {
	AUTO_MARK_TRGT_ITEM,
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_ACT_PICK_UP,
	AUTO_MARK_COND_OWN,
	"",
	FLG_AUTO_MARK_EDIT_PRIORITY | FLG_AUTO_MARK_EDIT_CONT,
};

static auto_mark_t	dflt_auto_mark_clear = {
	AUTO_MARK_TRGT_CLEAR,
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_ACT_FIGHT,
	AUTO_MARK_COND_DISPERSE,
	"",
	FLG_AUTO_MARK_EDIT_PRIORITY,
};

static auto_mark_appoint_item_t	auto_mark_appoint_item
		[LS_MBR_MAX_N][AUTO_MARK_MAX_N]
		[AUTO_MARK_APPOINT_ITEM_MAX_N];

static auto_mark_appoint_item_t	auto_mark_appoint_item_dflt
		[AUTO_MARK_APPOINT_ITEM_MAX_N] = {
	{ FACE_MJR_WEAPON, FACE_MNR_KNIFE, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_SHORT_SWORD, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_LONG_SWORD, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_SABRE, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_RAPIER, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_HAND_AXE, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_BATTLE_AXE, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_SPEAR, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_LANCE, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_FLAIL, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_MACE, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_HAMMER, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_GLAIVE, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_KNUCKLE, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_BOW, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_ARW, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_STONE, TRUE },
	{ FACE_MJR_WEAPON, FACE_MNR_DAGGER, TRUE },

	{ FACE_MJR_ARMOR, FACE_MNR_ARMOR_SHIELD, TRUE },
	{ FACE_MJR_ARMOR, FACE_MNR_ARMOR_HEAD, TRUE },
	{ FACE_MJR_ARMOR, FACE_MNR_ARMOR_BODY, TRUE },
	{ FACE_MJR_ARMOR, FACE_MNR_ARMOR_ARM, TRUE },
	{ FACE_MJR_ARMOR, FACE_MNR_ARMOR_FEET, TRUE },
	{ FACE_MJR_ARMOR, FACE_MNR_ARMOR_ABOUT_BODY, TRUE },

	{ FACE_MJR_POTION, FACE_MNR_NULL, TRUE },

	{ FACE_MJR_SCROLL, FACE_MNR_NULL, TRUE },

	{ FACE_MJR_STICK, FACE_MNR_WAND, TRUE },
	{ FACE_MJR_STICK, FACE_MNR_ROD, TRUE },
	{ FACE_MJR_STICK, FACE_MNR_STAFF, TRUE },

	{ FACE_MJR_ACCESSORY, FACE_MNR_RING, TRUE },
	{ FACE_MJR_ACCESSORY, FACE_MNR_AMULET, TRUE },
	{ FACE_MJR_ACCESSORY, FACE_MNR_NECKLACE, TRUE },

	{ FACE_MJR_FOOD, FACE_MNR_NULL, TRUE },

	{ FACE_MJR_CHEST, FACE_MNR_NULL, FALSE },

	{ FACE_MJR_COIN, FACE_MNR_NULL, TRUE },

	{ FACE_MJR_GEM, FACE_MNR_NULL, TRUE },

	{ FACE_MJR_MISC, FACE_MNR_INST, TRUE },
	{ FACE_MJR_MISC, FACE_MNR_ANTHOLOGY, TRUE },
	{ FACE_MJR_MISC, FACE_MNR_LIGHT, TRUE },
	{ FACE_MJR_MISC, FACE_MNR_SPIKE, TRUE },
	{ FACE_MJR_MISC, FACE_MNR_TOBACCO, TRUE },
	{ FACE_MJR_MISC, FACE_MNR_PIPE, TRUE },
	{ FACE_MJR_MISC, FACE_MNR_RARE_GOODS, TRUE },
	{ FACE_MJR_MISC, FACE_MNR_BONE_GOOD, FALSE },
	{ FACE_MJR_MISC, FACE_MNR_BONE_EVIL, FALSE },
	{ FACE_MJR_MISC, FACE_MNR_JUNK, FALSE },

	{ FACE_MJR_NULL, FACE_MNR_NULL, FALSE },
};

/***************************************************************/

#include	"amenu-tab.h"

/***************************************************************
* 
***************************************************************/

void	init_auto_menu( void )
{
	long	i;

	g_sel_mbr = NULL;
	auto_mark_cur_n = 0;

	init_auto_mark_all_appoint();
	init_auto_mark_all_mbr();

	for( i = 0; i < LS_MBR_MAX_N; i++ ){
		clip_board_large[i] = ls_auto_mark[i][0];

		str_nz_cpy( clip_board_ttl,
				msg_ttl_auto_mark[0],
				MSG_TTL_AUTO_MARK_MAX_LEN );
	}
	clip_board_small = ls_auto_mark[0][0];
}

/***************************************************************
* ٤ƤΥСΥƥμν
***************************************************************/

void	init_auto_mark_all_appoint( void )
{
	long	i;

	for( i = 0; i < LS_MBR_MAX_N; i++ )
		init_auto_mark_appoint( i );
}

/***************************************************************
* СΥƥμν
***************************************************************/

void	init_auto_mark_appoint( long ls_mbr_n )
{
	long	i, j, k;

	i = ls_mbr_n;

	for( j = 0; j < AUTO_MARK_MAX_N; j++ ){
		for( k = 0; k < AUTO_MARK_APPOINT_ITEM_MAX_N; k++ ){
			auto_mark_appoint_item_t	*a;

			a = &(auto_mark_appoint_item_dflt[k]);
			auto_mark_appoint_item[i][j][k] = *a;
		}
	}
}

/***************************************************************
* ٤ƤΥСν
***************************************************************/

void	init_auto_mark_all_mbr( void )
{
	long	i;

	for( i = 0; i < LS_MBR_MAX_N; i++ )
		init_auto_mark_mbr( i );
}

/***************************************************************
* Сν
* long ls_mbr_n : СΥꥹֹ
***************************************************************/

void	init_auto_mark_mbr( long ls_mbr_n )
{
	long	j;

	/*  */

	for( j = 0; j < AUTO_MARK_MAX_N; j++ ){
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_clear;
		str_nz_cpy( msg_ttl_auto_mark[j],
				MSG_NAME_DFLT_AUTO_MARK_CLEAR,
				MSG_TTL_AUTO_MARK_MAX_LEN );
	}

	j = 0;

	/* Ʈ(ɲ) */

	switch( ls_mbr_n ){
	default:
	case 0:
	case 1:
	case 3:
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_fight;
		break;
	case 2:
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_throw;
		break;
	case 4:
	case 5:
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_fight_far;
		break;
	}
	str_nz_cpy( msg_ttl_auto_mark[j],
			MSG_NAME_DFLT_AUTO_MARK_FIGHT,
			MSG_TTL_AUTO_MARK_MAX_LEN );
	j++;

	/* Ʈ() */

	switch( ls_mbr_n ){
	default:
	case 0:
	case 1:
	case 3:
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_fight_prio;
		break;
	case 2:
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_throw_prio;
		break;
	case 4:
	case 5:
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_fight_far_prio;
		break;
	}
	str_nz_cpy( msg_ttl_auto_mark[j],
			MSG_NAME_DFLT_AUTO_MARK_FIGHT_PRIO,
			MSG_TTL_AUTO_MARK_MAX_LEN );
	j++;

	/* ܶƮ(ɲ) */

	switch( ls_mbr_n ){
	default:
	case 0:
	case 1:
	case 2:
	case 3:
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_fight;
		break;
	case 4:
	case 5:
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_fight_far;
		break;
	}
	str_nz_cpy( msg_ttl_auto_mark[j],
			MSG_NAME_DFLT_AUTO_MARK_FIGHT_NO_THROW,
			MSG_TTL_AUTO_MARK_MAX_LEN );
	j++;

	/* ܶƮ() */

	switch( ls_mbr_n ){
	default:
	case 0:
	case 1:
	case 2:
	case 3:
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_fight_prio;
		break;
	case 4:
	case 5:
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_fight_far_prio;
		break;
	}
	str_nz_cpy( msg_ttl_auto_mark[j],
			MSG_NAME_DFLT_AUTO_MARK_FIGHT_NO_THROW_PRIO,
			MSG_TTL_AUTO_MARK_MAX_LEN );
	j++;

	/* (ɲ) */

	if( j < AUTO_MARK_MAX_N ){
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_fight_all;
		str_nz_cpy( msg_ttl_auto_mark[j],
				MSG_NAME_DFLT_AUTO_MARK_FIGHT_ALL,
				MSG_TTL_AUTO_MARK_MAX_LEN );
	}
	j++;

	/* () */

	if( j < AUTO_MARK_MAX_N ){
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_fight_all_prio;
		str_nz_cpy( msg_ttl_auto_mark[j],
				MSG_NAME_DFLT_AUTO_MARK_FIGHT_ALL_PRIO,
				MSG_TTL_AUTO_MARK_MAX_LEN );
	}
	j++;

	/* ƤΥƥ */

	j += 2;

	if( j < AUTO_MARK_MAX_N ){
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_item_all;
		str_nz_cpy( msg_ttl_auto_mark[j],
				MSG_NAME_DFLT_AUTO_MARK_ITEM_ALL,
				MSG_TTL_AUTO_MARK_MAX_LEN );
	}
	j++;

	/* äƤ륢ƥ */

	if( j < AUTO_MARK_MAX_N ){
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_item_own;
		str_nz_cpy( msg_ttl_auto_mark[j],
				MSG_NAME_DFLT_AUTO_MARK_ITEM_OWN,
				MSG_TTL_AUTO_MARK_MAX_LEN );
	}
	j++;

	j = AUTO_MARK_MAX_N - 1;
	ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_clear;
	str_nz_cpy( msg_ttl_auto_mark[j],
			MSG_NAME_DFLT_AUTO_MARK_CLEAR,
			MSG_TTL_AUTO_MARK_MAX_LEN );
}

/***************************************************************
* ΥСʥå
* long ls_mbr_n : СΥꥹֹ
***************************************************************/

void	ver_up_auto_mark_1_0_4( long ls_mbr_n )
{
	long	j;
	char	*msg_no_throw = MSG_NAME_DFLT_AUTO_MARK_FIGHT_NO_THROW;
	char	*msg_no_throw_prio
			= MSG_NAME_DFLT_AUTO_MARK_FIGHT_NO_THROW_PRIO;

	j = 0;

	/* õ */

	for( ; j < AUTO_MARK_MAX_N; j++ ){
		if( ls_auto_mark[ls_mbr_n][j].trgt == AUTO_MARK_TRGT_CLEAR )
			break;
	}

	/* (ɲ) */

	if( j < AUTO_MARK_MAX_N ){
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_fight_all;
		str_nz_cpy( msg_ttl_auto_mark[j],
				MSG_NAME_DFLT_AUTO_MARK_FIGHT_ALL,
				MSG_TTL_AUTO_MARK_MAX_LEN );
	}
	j++;

	/* õ */

	for( ; j < AUTO_MARK_MAX_N; j++ ){
		if( ls_auto_mark[ls_mbr_n][j].trgt == AUTO_MARK_TRGT_CLEAR )
			break;
	}

	/* () */

	if( j < AUTO_MARK_MAX_N ){
		ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_fight_all_prio;
		str_nz_cpy( msg_ttl_auto_mark[j],
				MSG_NAME_DFLT_AUTO_MARK_FIGHT_ALL_PRIO,
				MSG_TTL_AUTO_MARK_MAX_LEN );
	}
	j++;

	/* ܶƮ(ɲ)õ */

	for( j = 0; j < AUTO_MARK_MAX_N; j++ ){
		if( strcmp( msg_ttl_auto_mark[j],
				msg_no_throw ) == 0 ){
			break;
		}
	}

	/* ܶƮ(ɲ) */

	if( j < AUTO_MARK_MAX_N ){
		switch( ls_mbr_n ){
		default:
		case 0:
		case 1:
		case 2:
		case 3:
			ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_fight;
			break;
		case 4:
		case 5:
			ls_auto_mark[ls_mbr_n][j] = dflt_auto_mark_fight_far;
			break;
		}
	}

	/* ܶƮ()õ */

	for( j = 0; j < AUTO_MARK_MAX_N; j++ ){
		if( strcmp( msg_ttl_auto_mark[j],
				msg_no_throw_prio ) == 0 ){
			break;
		}
	}

	/* ܶƮ() */

	if( j < AUTO_MARK_MAX_N ){
		switch( ls_mbr_n ){
		default:
		case 0:
		case 1:
		case 2:
		case 3:
			ls_auto_mark[ls_mbr_n][j]
					= dflt_auto_mark_fight_prio;
			break;
		case 4:
		case 5:
			ls_auto_mark[ls_mbr_n][j]
					= dflt_auto_mark_fight_far_prio;
			break;
		}
	}
}

/***************************************************************
* ΥСʥå
* long ls_mbr_n : СΥꥹֹ
***************************************************************/

void	ver_up_auto_mark_1_1_1( long ls_mbr_n )
{
	init_auto_mark_appoint( ls_mbr_n );
}

/***************************************************************
* ΥСʥå
* long ls_mbr_n : СΥꥹֹ
***************************************************************/

void	ver_up_auto_mark_1_1_3( void )
{
	long	j;

	for( j = 0; j < AUTO_MARK_MAX_N; j++ )
		cv_msg_ttl_auto_mark( msg_ttl_auto_mark[j] );
}

/***************************************************************
* ȥζڤʸ " - "  "\n" Ѵ
* char *ttl : ȥ
***************************************************************/

void	cv_msg_ttl_auto_mark( char *ttl )
{
	static char	old_split[] = " - ";
	char	work_left[MSG_TTL_AUTO_MARK_MAX_LEN + 1];
	char	work_right[MSG_TTL_AUTO_MARK_MAX_LEN + 1];
	char	*p;

	/* ȥ뤫 " - " κ¦Ф */

	str_nz_cpy( work_left, ttl, MSG_TTL_AUTO_MARK_MAX_LEN );
	p = strstr( work_left, old_split );
	if( p != NULL )
		*p = '\0';

	str_trim_tail( work_left, " \t\n" );

	/* ȥ뤫 " - " α¦Ф */

	p = strstr( ttl, old_split );
	if( p == NULL ){
		work_right[0] = '\0';
	} else {
		long	len;

		len = str_len_std( old_split );
		str_nz_cpy( work_right, &(p[len]), MSG_TTL_AUTO_MARK_MAX_LEN );
	}

	/* ȥ˽᤹ */

	ttl[0] = '\0';
	str_max_n_cat( ttl, work_left,
			MSG_TTL_AUTO_MARK_MAX_LEN );
	str_max_n_cat( ttl, STR_TTL_AUTO_MARK_SPLIT_CODE,
			MSG_TTL_AUTO_MARK_MAX_LEN );
	str_max_n_cat( ttl, work_right,
			MSG_TTL_AUTO_MARK_MAX_LEN );
}

/***************************************************************
* ˥塼
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*menu_auto_mark( menu_t **pp, menu_t **dflt )
{
	*dflt = NULL;

	set_menu_auto_mark( dflt );

	*pp = ls_menu_auto_mark;

	return NULL;
}

/***************************************************************
* ˥塼ΥꥹȤ
* menu_t **dflt : ˥塼Υǥե
***************************************************************/

void	set_menu_auto_mark( menu_t **dflt )
{
	long	left_max_len;
	menu_t	*p;
	char	buf[MSG_TTL_AUTO_MARK_MAX_LEN * 2 + 16 + 1];
	long	i, k;

	p = ls_menu_auto_mark;
	k = 0;

	str_nz_cpy( p[k].path, "/auto mark", MENU_PATH_MAX_LEN );
	str_nz_cpy( p[k].kind, "<Branch>", MENU_KIND_MAX_LEN );
	p[k].accel_key = '\0';
	p[k].short_key[0] = '\0';
	p[k].msg[0] = '\0';
	p[k].call_back = NULL;
	p[k].arg = NULL;
	p[k].flg = FLG_NULL;
	k++;

	str_nz_cpy( p[k].path, "/auto mark/title", MENU_PATH_MAX_LEN );
	str_nz_cpy( p[k].kind, "<Title>", MENU_KIND_MAX_LEN );
	p[k].accel_key = '\0';
	p[k].short_key[0] = '\0';
	str_nz_cpy( p[k].msg, MSG_TTL_MENU_AUTO_MARK,
			MENU_MSG_MAX_LEN );
	p[k].call_back = NULL;
	p[k].arg = NULL;
	p[k].flg = FLG_NULL;
	k++;

	left_max_len = 1;
	for( i = 0; i < AUTO_MARK_MAX_N; i++ ){
		long	len;

		len = str_len_draw( get_msg_ttl_auto_mark_info( i ) );
		left_max_len = max_l( left_max_len, len );
	}

	for( i = 0; i < AUTO_MARK_MAX_N; i++ ){
		long	kk;

		kk = k;

		if( i == auto_mark_cur_n )
			*dflt = &(p[k]);

		sprintf( buf, "%*s%s%s",
				(int)left_max_len,
				get_msg_ttl_auto_mark_info( i ),
				STR_TTL_AUTO_MARK_SPLIT_NAME,

				get_msg_ttl_auto_mark_hint( i ) );

		sprintf( p[k].path, "/auto mark/%ld", i );
		str_nz_cpy( p[k].kind, "<Branch>", MENU_KIND_MAX_LEN );
		p[k].accel_key = (char)('A' + i);
		p[k].short_key[0] = '\0';
		str_nz_cpy( p[k].msg, buf, MENU_MSG_MAX_LEN );
		p[k].call_back = NULL;
		p[k].arg = NULL;
		p[k].flg = FLG_NULL;
		k++;

		sprintf( p[k].path, "%s/exec", p[kk].path );
		str_nz_cpy( p[k].kind, "<Item>", MENU_KIND_MAX_LEN );
		p[k].accel_key = 'X';
		p[k].short_key[0] = '\0';
		str_nz_cpy( p[k].msg, MSG_MENU_AUTO_MARK_EXEC,
				MENU_MSG_MAX_LEN );
		p[k].call_back = cb_menu_auto_mark_exec;
		p[k].arg = (void *)i;
		p[k].flg = FLG_NULL;
		k++;

		sprintf( p[k].path, "%s/edit", p[kk].path );
		str_nz_cpy( p[k].kind, "<Branch>", MENU_KIND_MAX_LEN );
		p[k].accel_key = 'E';
		p[k].short_key[0] = '\0';
		str_nz_cpy( p[k].msg, MSG_MENU_AUTO_MARK_EDIT,
				MENU_MSG_MAX_LEN );
		p[k].call_back = cb_menu_auto_mark_edit;
		p[k].arg = (void *)i;
		p[k].flg = FLG_NULL;
		k++;

		sprintf( p[k].path, "%s/copy", p[kk].path );
		str_nz_cpy( p[k].kind, "<Item>", MENU_KIND_MAX_LEN );
		p[k].accel_key = 'W';
		p[k].short_key[0] = '\0';
		str_nz_cpy( p[k].msg, MSG_MENU_AUTO_MARK_COPY,
				MENU_MSG_MAX_LEN );
		p[k].call_back = cb_menu_auto_mark_copy_large;
		p[k].arg = (void *)i;
		p[k].flg = FLG_NULL;
		k++;

		sprintf( p[k].path, "%s/paste", p[kk].path );
		str_nz_cpy( p[k].kind, "<Item>", MENU_KIND_MAX_LEN );
		p[k].accel_key = 'Y';
		p[k].short_key[0] = '\0';
		str_nz_cpy( p[k].msg, MSG_MENU_AUTO_MARK_PASTE,
				MENU_MSG_MAX_LEN );
		p[k].call_back = cb_menu_auto_mark_paste_large;
		p[k].arg = (void *)i;
		p[k].flg = FLG_NULL;
		k++;

		sprintf( p[k].path, "%s/arrange top", p[kk].path );
		str_nz_cpy( p[k].kind, "<Item>", MENU_KIND_MAX_LEN );
		p[k].accel_key = 'T';
		p[k].short_key[0] = '\0';
		str_nz_cpy( p[k].msg, MSG_MENU_AUTO_MARK_ARRANGE_TOP,
				MENU_MSG_MAX_LEN );
		p[k].call_back = cb_menu_auto_mark_arrange_top;
		p[k].arg = (void *)i;
		p[k].flg = FLG_NULL;
		k++;

		sprintf( p[k].path, "%s/arrange bottom", p[kk].path );
		str_nz_cpy( p[k].kind, "<Item>", MENU_KIND_MAX_LEN );
		p[k].accel_key = 'B';
		p[k].short_key[0] = '\0';
		str_nz_cpy( p[k].msg, MSG_MENU_AUTO_MARK_ARRANGE_BOTTOM,
				MENU_MSG_MAX_LEN );
		p[k].call_back = cb_menu_auto_mark_arrange_bottom;
		p[k].arg = (void *)i;
		p[k].flg = FLG_NULL;
		k++;
	}
	p[k].path[0] = '\0';
}

/***************************************************************
* ˥塼Ǽ¹Ԥ򤵤줿˸ƤФ
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_exec( menu_t **pp, menu_t **dflt )
{
	party_t	*pty = get_party();
	long	n;
	long	i;

	n = (long)((*pp)->arg);
	if( auto_mark_cur_n != n ){
		auto_mark_cur_n = n;

		for( i = 0; i < MBR_MAX_N; i++ ){
			set_auto_mark_cont( pty->mbr[i] );
		}
	}

	for( i = 0; i < MBR_MAX_N; i++ )
		exec_menu_auto_mark( pty->mbr[i] );

	return NULL;
}

/***************************************************************
* Ū˥ޡʤʤϢ³ޡ
* mbr_t *mbr : С
***************************************************************/

void	set_auto_mark_cont( mbr_t *mbr )
{
	if( mbr == NULL )
		return;

	if( chk_flg( ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n].flg,
			FLG_AUTO_MARK_EDIT_PRIORITY ) ){
		mbr->flg_chr &= ~(FLG_CHR_AUTO_MARK_CONT);
	}
}

/***************************************************************
* ˥塼¹Ԥ
* mbr_t *mbr : С
* return : Ԥ
***************************************************************/

bool_t	exec_menu_auto_mark( mbr_t *mbr )
{
	auto_mark_t	*am;
	bool_t	flg_clr;
	char	*macro;

	if( chk_flg_or( mbr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return FALSE;

	am = &(ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n]);

	/* Ǥ˥ޡƤ뤫 */
	if( !chk_flg( am->flg, FLG_AUTO_MARK_EDIT_PRIORITY ) )
		if( mbr->act.kind != ACT_KIND_NULL )
			return FALSE;

	flg_clr = FALSE;
	switch( am->trgt ){
	case AUTO_MARK_TRGT_MNSTR:
		if( !exec_menu_auto_mark_mnstr( mbr ) )
			flg_clr = TRUE;
		break;
	case AUTO_MARK_TRGT_ITEM:
		if( !exec_menu_auto_mark_item( mbr ) )
			flg_clr = TRUE;
		break;
	case AUTO_MARK_TRGT_DOOR:
		if( !exec_menu_auto_mark_door( mbr ) )
			flg_clr = TRUE;
		break;
	case AUTO_MARK_TRGT_TRAP:
		break;
	case AUTO_MARK_TRGT_MBR:
		if( !exec_menu_auto_mark_mbr( mbr ) )
			flg_clr = TRUE;
		break;
	case AUTO_MARK_TRGT_UNCHANGE:
		return TRUE;
	case AUTO_MARK_TRGT_CLEAR:
		flg_clr = TRUE;
		break;
	}

	if( flg_clr )
		clr_chr_trgt_act( mbr, TRUE );

	if( chk_flg( ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n].flg,
			FLG_AUTO_MARK_EDIT_CONT ) ){
		mbr->flg_chr |= FLG_CHR_AUTO_MARK_CONT;
	} else {
		mbr->flg_chr &= ~(FLG_CHR_AUTO_MARK_CONT);
	}

	macro = ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n].macro;
	set_key_buf_str( macro );

	return TRUE;
}

/***************************************************************
* 󥹥оݤ˥˥塼¹Ԥ
* mbr_t *mbr : С
* return : Ԥ
***************************************************************/

bool_t	exec_menu_auto_mark_mnstr( mbr_t *mbr )
{
	auto_mark_t	*am;
	mnstr_t	*mnstr;
	dist_t	dist;
	act_kind_t	act_kind;

	am = &(ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n]);

	switch( am->act ){
	case AUTO_MARK_ACT_FIGHT:
		act_kind = ACT_KIND_MNSTR_FIGHT;
		break;
	case AUTO_MARK_ACT_THROW:
		act_kind = ACT_KIND_MNSTR_THROW;
		break;
	case AUTO_MARK_ACT_STEAL:
		act_kind = ACT_KIND_MNSTR_STEAL;
		break;
	case AUTO_MARK_ACT_TAIL:
		act_kind = ACT_KIND_MNSTR_TAIL;
		break;
	case AUTO_MARK_ACT_PICK_UP:
	case AUTO_MARK_ACT_OPEN:
	case AUTO_MARK_ACT_CLOSE:
	case AUTO_MARK_ACT_JAM:
	case AUTO_MARK_ACT_DISARM:
	case AUTO_MARK_ACT_BREAK:
	case AUTO_MARK_ACT_PEEP:
	case AUTO_MARK_ACT_CHK:
	default:
		return FALSE;
	}

	/* 󥹥õ */
	mnstr = NULL;
	switch( am->cond ){
	case AUTO_MARK_COND_NEAREST:
		mnstr = get_mnstr_nearest( mbr->x, mbr->y );
		break;
	case AUTO_MARK_COND_DISPERSE:
		mnstr = get_mnstr_disperse( mbr );
		if( mnstr == NULL )
			mnstr = get_mnstr_randm( mbr->x, mbr->y );
		break;
	case AUTO_MARK_COND_STAGGER:
	case AUTO_MARK_COND_OWN:
		return FALSE;
	}
	if( mnstr == NULL )
		return FALSE;

	/* ֹ礤򥻥å */
	switch( am->dist ){
	case AUTO_MARK_DIST_NEAR:
		dist = DIST_NEAR;
		break;
	case AUTO_MARK_DIST_MEDIUM:
		dist = DIST_MEDIUM;
		break;
	case AUTO_MARK_DIST_FAR:
		dist = DIST_FAR;
		break;
	default:
		return FALSE;
	}

	/* 򥻥å */
	set_chr_act( mbr, act_kind, NULL, NULL, 0, 0 );

	/* 󥹥ޡ */
	mark_mnstr( mbr, mnstr, dist );

	draw_mbr_stat( mbr );

	return TRUE;
}

/***************************************************************
* ƥоݤ˥˥塼¹Ԥ
* mbr_t *mbr : С
* return : Ԥ
***************************************************************/

bool_t	exec_menu_auto_mark_item( mbr_t *mbr )
{
	auto_mark_t	*am;
	item_t	*item;
	dist_t	dist;
	act_kind_t	act_kind;

	am = &(ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n]);

	switch( am->act ){
	case AUTO_MARK_ACT_FIGHT:
	case AUTO_MARK_ACT_THROW:
	case AUTO_MARK_ACT_STEAL:
	case AUTO_MARK_ACT_TAIL:
		return FALSE;
	case AUTO_MARK_ACT_PICK_UP:
		act_kind = ACT_KIND_ITEM_PICK_UP;
		break;
	case AUTO_MARK_ACT_OPEN:
		act_kind = ACT_KIND_ITEM_OPEN;
		break;
	case AUTO_MARK_ACT_CLOSE:
	case AUTO_MARK_ACT_JAM:
		return FALSE;
	case AUTO_MARK_ACT_DISARM:
		act_kind = ACT_KIND_ITEM_DISARM;
		break;
	case AUTO_MARK_ACT_BREAK:
		act_kind = ACT_KIND_ITEM_BREAK;
		break;
	case AUTO_MARK_ACT_PEEP:
		return FALSE;
	case AUTO_MARK_ACT_CHK:
		act_kind = ACT_KIND_ITEM_CHK;
		break;
	default:
		return FALSE;
	}

	/* ƥõ */
	item = NULL;
	switch( am->cond ){
	case AUTO_MARK_COND_NEAREST:
		item = get_item_nearest( mbr, act_kind, TRUE );
		break;
	case AUTO_MARK_COND_DISPERSE:
		item = get_item_disperse( mbr, act_kind, TRUE );
		if( item == NULL )
			item = get_item_randm( mbr, act_kind, TRUE );
		break;
	case AUTO_MARK_COND_STAGGER:
		return FALSE;
	case AUTO_MARK_COND_OWN:
		item = get_item_own( mbr, act_kind, TRUE );
		break;
	}
	if( item == NULL )
		return FALSE;

	/* ֹ礤򥻥å */
	switch( am->dist ){
	case AUTO_MARK_DIST_NEAR:
		dist = DIST_NEAR;
		break;
	case AUTO_MARK_DIST_MEDIUM:
		dist = DIST_MEDIUM;
		break;
	case AUTO_MARK_DIST_FAR:
		dist = DIST_FAR;
		break;
	default:
		return FALSE;
	}

	/* 򥻥å */
	set_chr_act( mbr, act_kind, NULL, NULL, 0, 0 );

	/* ƥޡ */
	mark_item( mbr, item, dist );

	draw_mbr_stat( mbr );

	return TRUE;
}

/***************************************************************
* ɥоݤ˥˥塼¹Ԥ
* mbr_t *mbr : С
* return : Ԥ
***************************************************************/

bool_t	exec_menu_auto_mark_door( mbr_t *mbr )
{
	auto_mark_t	*am;
	door_t	*door;
	dist_t	dist;
	act_kind_t	act_kind;

	am = &(ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n]);

	switch( am->act ){
	case AUTO_MARK_ACT_FIGHT:
	case AUTO_MARK_ACT_THROW:
	case AUTO_MARK_ACT_STEAL:
	case AUTO_MARK_ACT_TAIL:
	case AUTO_MARK_ACT_PICK_UP:
		return FALSE;
	case AUTO_MARK_ACT_OPEN:
		act_kind = ACT_KIND_DOOR_OPEN;
		break;
	case AUTO_MARK_ACT_CLOSE:
		act_kind = ACT_KIND_DOOR_CLOSE;
		break;
	case AUTO_MARK_ACT_JAM:
		act_kind = ACT_KIND_DOOR_JAM;
		break;
	case AUTO_MARK_ACT_DISARM:
		act_kind = ACT_KIND_DOOR_DISARM;
		break;
	case AUTO_MARK_ACT_BREAK:
		act_kind = ACT_KIND_DOOR_BREAK;
		break;
	case AUTO_MARK_ACT_PEEP:
		act_kind = ACT_KIND_DOOR_PEEP;
		break;
	case AUTO_MARK_ACT_CHK:
		act_kind = ACT_KIND_DOOR_CHK;
		break;
	default:
		return FALSE;
	}

	/* ɥõ */
	door = NULL;
	switch( am->cond ){
	case AUTO_MARK_COND_NEAREST:
		door = get_door_nearest( mbr->x, mbr->y, act_kind );
		break;
	case AUTO_MARK_COND_DISPERSE:
		door = get_door_disperse( mbr, act_kind );
		if( door == NULL )
			door = get_door_randm( mbr->x, mbr->y, act_kind );
		break;
	case AUTO_MARK_COND_STAGGER:
	case AUTO_MARK_COND_OWN:
		return FALSE;
	}
	if( door == NULL )
		return FALSE;

	/* ֹ礤򥻥å */
	switch( am->dist ){
	case AUTO_MARK_DIST_NEAR:
		dist = DIST_NEAR;
		break;
	case AUTO_MARK_DIST_MEDIUM:
		dist = DIST_MEDIUM;
		break;
	case AUTO_MARK_DIST_FAR:
		dist = DIST_FAR;
		break;
	default:
		return FALSE;
	}

	/* 򥻥å */
	set_chr_act( mbr, act_kind, NULL, NULL, 0, 0 );

	/* ɥޡ */
	mark_door( mbr, door, dist );

	draw_mbr_stat( mbr );

	return TRUE;
}

/***************************************************************
* Соݤ˥˥塼¹Ԥ
* mbr_t *mbr : С
* return : Ԥ
***************************************************************/

bool_t	exec_menu_auto_mark_mbr( mbr_t *mbr )
{
	auto_mark_t	*am;
	mbr_t	*p;
	dist_t	dist;
	act_kind_t	act_kind;

	am = &(ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n]);

	/* Сõ */
	p = NULL;
	switch( am->cond ){
	case AUTO_MARK_COND_NEAREST:
		p = get_mbr_nearest( mbr->x, mbr->y );
		break;
	case AUTO_MARK_COND_DISPERSE:
		p = get_mbr_disperse( mbr );
		if( p == NULL )
			p = get_mbr_randm( mbr->x, mbr->y );
		break;
	case AUTO_MARK_COND_STAGGER:
		p = get_mbr_stagger( mbr );
		break;
	case AUTO_MARK_COND_OWN:
		return FALSE;
	}
	if( p == NULL )
		return FALSE;

	/* ֹ礤򥻥å */
	switch( am->dist ){
	case AUTO_MARK_DIST_NEAR:
		dist = DIST_NEAR;
		break;
	case AUTO_MARK_DIST_MEDIUM:
		dist = DIST_MEDIUM;
		break;
	case AUTO_MARK_DIST_FAR:
		dist = DIST_FAR;
		break;
	default:
		return FALSE;
	}

	switch( am->act ){
	case AUTO_MARK_ACT_FIGHT:
		act_kind = ACT_KIND_MBR_FIGHT;
		break;
	case AUTO_MARK_ACT_THROW:
		act_kind = ACT_KIND_MBR_THROW;
		break;
	case AUTO_MARK_ACT_STEAL:
		act_kind = ACT_KIND_MBR_STEAL;
		break;
	case AUTO_MARK_ACT_TAIL:
		act_kind = ACT_KIND_MBR_TAIL;
		break;
	case AUTO_MARK_ACT_PICK_UP:
	case AUTO_MARK_ACT_OPEN:
	case AUTO_MARK_ACT_CLOSE:
	case AUTO_MARK_ACT_JAM:
	case AUTO_MARK_ACT_DISARM:
	case AUTO_MARK_ACT_BREAK:
	case AUTO_MARK_ACT_PEEP:
	case AUTO_MARK_ACT_CHK:
		return FALSE;
	default:
		return FALSE;
	}

	/* 򥻥å */
	set_chr_act( mbr, act_kind, NULL, NULL, 0, 0 );

	/* Сޡ */
	mark_mbr( mbr, p, dist );

	draw_mbr_stat( mbr );

	return TRUE;
}

/***************************************************************
* ˥塼Խ򤵤줿˸ƤФ
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_edit( menu_t **pp, menu_t **dflt )
{
	char	*str_goto;

	auto_mark_cur_n = (long)((*pp)->arg);

	while( 1 ){
		str_goto = exec_menu_sel_mbr(
				&g_sel_mbr, NULL, TRUE, FALSE );
		if( str_goto != NULL )
			return str_goto;

		while( 1 ){
			str_goto = exec_menu(
					ls_menu_auto_mark_edit,
					NULL, NULL );
			if( str_goto == NULL )
				continue;
			if( strcmp( str_goto, STR_MENU_ERR ) == 0 )
				return STR_MENU_ERR;
			if( strcmp( str_goto, STR_MENU_CANCEL ) == 0 )
				break;
		}
	}

	return STR_MENU_ERR;
}

/***************************************************************
* Խ˥塼
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_edit_init(
	menu_t **pp, menu_t **dflt
)
{
	menu_t	*p;

	/* ȥ */
	p = srch_menu( *pp, "title" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_TTL_MENU_AUTO_MARK_EDIT,
			get_msg_ttl_auto_mark_name( auto_mark_cur_n ),
			g_sel_mbr->name );

	/* о */
	p = srch_menu( *pp, "target" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_MENU_AUTO_MARK_EDIT_TRGT,
			get_msg_menu_auto_mark_edit_trgt( g_sel_mbr ) );

	/* ֹ礤 */
	p = srch_menu( *pp, "dist" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_MENU_AUTO_MARK_EDIT_DIST,
			get_msg_menu_auto_mark_edit_dist( g_sel_mbr ) );

	/* ư */
	p = srch_menu( *pp, "action" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_MENU_AUTO_MARK_EDIT_ACT,
			get_msg_menu_auto_mark_edit_act( g_sel_mbr ) );

	/*  */
	p = srch_menu( *pp, "condition" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_MENU_AUTO_MARK_EDIT_COND,
			get_msg_menu_auto_mark_edit_cond( g_sel_mbr ) );

	/* ƥ */
	if( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt
			== AUTO_MARK_TRGT_ITEM ){
		clr_flg_menu( *pp, "appoint item", FLG_MENU_HIDDEN );
	} else {
		set_flg_menu( *pp, "appoint item", FLG_MENU_HIDDEN );
	}

	/* ޥ */

	/* Ϣ³ޡ */
	if( chk_flg( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].flg,
			FLG_AUTO_MARK_EDIT_CONT ) ){
		set_chk_on_menu( *pp, "continue" );
	} else {
		set_chk_off_menu( *pp, "continue" );
	}

	/* ߤͥ */
	if( chk_flg( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].flg,
			FLG_AUTO_MARK_EDIT_PRIORITY ) ){
		set_chk_on_menu( *pp, "priority" );
	} else {
		set_chk_off_menu( *pp, "priority" );
	}

	return NULL;
}

/***************************************************************
* Խ˥塼оݤ
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_trgt_init(
	menu_t **pp, menu_t **dflt
)
{
	menu_t	*p;
	char	*s;

	p = srch_menu( *pp, "title" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_TTL_MENU_AUTO_MARK_TRGT,
			get_msg_ttl_auto_mark_name( auto_mark_cur_n ),
			g_sel_mbr->name );

	s = NULL;
	switch( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt ){
	case AUTO_MARK_TRGT_MNSTR:
		s = "monster";
		break;
	case AUTO_MARK_TRGT_ITEM:
		s = "item";
		break;
	case AUTO_MARK_TRGT_DOOR:
		s = "door";
		break;
	case AUTO_MARK_TRGT_TRAP:
		s = "trap";
		break;
	case AUTO_MARK_TRGT_MBR:
		s = "member";
		break;
	case AUTO_MARK_TRGT_UNCHANGE:
		s = "unchange";
		break;
	case AUTO_MARK_TRGT_CLEAR:
		s = "clear";
		break;
	}

	*dflt = srch_menu( *pp, s );

	return NULL;
}

/***************************************************************
* Խ˥塼оݤ򤷤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_trgt( menu_t **pp, menu_t **dflt )
{
	auto_mark_trgt_t	trgt;

	trgt = (auto_mark_trgt_t)(long)((*pp)->arg);
	ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt = trgt;

	switch( trgt ){
	case AUTO_MARK_TRGT_MNSTR:
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].act
				= AUTO_MARK_ACT_FIGHT;
		break;
	case AUTO_MARK_TRGT_ITEM:
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].act
				= AUTO_MARK_ACT_PICK_UP;
		break;
	case AUTO_MARK_TRGT_DOOR:
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].act
				= AUTO_MARK_ACT_OPEN;
		break;
	case AUTO_MARK_TRGT_TRAP:
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].act
				= AUTO_MARK_ACT_DISARM;
		break;
	case AUTO_MARK_TRGT_MBR:
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].act
				= AUTO_MARK_ACT_TAIL;
		break;
	case AUTO_MARK_TRGT_UNCHANGE:
	case AUTO_MARK_TRGT_CLEAR:
		break;
	}

	return NULL;
}

/***************************************************************
* Խ˥塼δֹ礤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_dist_init(
	menu_t **pp, menu_t **dflt
)
{
	menu_t	*p;
	char	*s;

	if( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt
			== AUTO_MARK_TRGT_UNCHANGE ){
		return STR_MENU_CANCEL;
	}
	if( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt
			== AUTO_MARK_TRGT_CLEAR ){
		return STR_MENU_CANCEL;
	}

	p = srch_menu( *pp, "title" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_TTL_MENU_AUTO_MARK_DIST,
			get_msg_ttl_auto_mark_name( auto_mark_cur_n ),
			g_sel_mbr->name );

	s = NULL;
	switch( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].dist ){
	case AUTO_MARK_DIST_NEAR:
		s = "near";
		break;
	case AUTO_MARK_DIST_MEDIUM:
		s = "medium";
		break;
	case AUTO_MARK_DIST_FAR:
		s = "far";
		break;
	}

	*dflt = srch_menu( *pp, s );

	return NULL;
}

/***************************************************************
* Խ˥塼δֹ礤򤷤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_dist( menu_t **pp, menu_t **dflt )
{
	ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].dist
			= (auto_mark_dist_t)(long)((*pp)->arg);

	return NULL;
}

/***************************************************************
* Խ˥塼ιư
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_act_init( menu_t **pp, menu_t **dflt )
{
	menu_t	*p;
	char	*s;

	clr_flg_menu( *pp, NULL, FLG_MENU_ALL );

	if( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt
			== AUTO_MARK_TRGT_UNCHANGE ){
		return STR_MENU_CANCEL;
	}
	if( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt
			== AUTO_MARK_TRGT_CLEAR ){
		return STR_MENU_CANCEL;
	}

	p = srch_menu( *pp, "title" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_TTL_MENU_AUTO_MARK_ACT,
			get_msg_ttl_auto_mark_name( auto_mark_cur_n ),
			g_sel_mbr->name );

	s = NULL;
	switch( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].act ){
	case AUTO_MARK_ACT_FIGHT:
		s = "fight";
		break;
	case AUTO_MARK_ACT_THROW:
		s = "throw";
		break;
	case AUTO_MARK_ACT_STEAL:
		s = "steal";
		break;
	case AUTO_MARK_ACT_TAIL:
		s = "tail";
		break;
	case AUTO_MARK_ACT_PICK_UP:
		s = "pick up";
		break;
	case AUTO_MARK_ACT_OPEN:
		s = "open";
		break;
	case AUTO_MARK_ACT_CLOSE:
		s = "close";
		break;
	case AUTO_MARK_ACT_JAM:
		s = "jam";
		break;
	case AUTO_MARK_ACT_DISARM:
		s = "disarm";
		break;
	case AUTO_MARK_ACT_BREAK:
		s = "break";
		break;
	case AUTO_MARK_ACT_PEEP:
		s = "peep";
		break;
	case AUTO_MARK_ACT_CHK:
		s = "check";
		break;
	}

	*dflt = srch_menu( *pp, s );

	/* оݤ˱ƥ˥塼ܤ̵ */

	switch( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt ){
	case AUTO_MARK_TRGT_MNSTR:
		set_flg_menu( *pp, "pick up", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "open", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "close", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "jam", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "disarm", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "break", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "peep", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "search", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_ITEM:
		set_flg_menu( *pp, "fight", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "throw", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "steal", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "tail", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "close", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "jam", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "peep", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_DOOR:
		set_flg_menu( *pp, "fight", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "throw", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "steal", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "tail", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "pick up", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_TRAP:
		set_flg_menu( *pp, "fight", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "throw", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "steal", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "tail", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "pick up", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "open", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "close", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "jam", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "peep", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_MBR:
		set_flg_menu( *pp, "pick up", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "open", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "close", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "jam", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "disarm", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "break", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "peep", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "search", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_UNCHANGE:
	case AUTO_MARK_TRGT_CLEAR:
		return STR_MENU_CANCEL;
	}

	if( chk_flg( (*dflt)->flg, FLG_MENU_HIDDEN ) )
		*dflt = NULL;

	return NULL;
}

/***************************************************************
* Խ˥塼ιư򤷤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_act( menu_t **pp, menu_t **dflt )
{
	ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].act
			= (auto_mark_act_t)(long)((*pp)->arg);

	return NULL;
}

/***************************************************************
* Խ˥塼ξ
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_cond_init(
	menu_t **pp, menu_t **dflt
)
{
	char	*s;
	menu_t	*p;

	clr_flg_menu( *pp, NULL, FLG_MENU_ALL );

	if( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt
			== AUTO_MARK_TRGT_UNCHANGE ){
		return STR_MENU_CANCEL;
	}
	if( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt
			== AUTO_MARK_TRGT_CLEAR ){
		return STR_MENU_CANCEL;
	}

	p = srch_menu( *pp, "title" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_TTL_MENU_AUTO_MARK_COND,
			get_msg_ttl_auto_mark_name( auto_mark_cur_n ),
			g_sel_mbr->name );

	/* ǥեȤΥ */

	s = NULL;
	switch( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].cond ){
	case AUTO_MARK_COND_NEAREST:
		s = "nearest";
		break;
	case AUTO_MARK_COND_DISPERSE:
		s = "disperse";
		break;
	case AUTO_MARK_COND_STAGGER:
		s = "stagger";
		break;
	case AUTO_MARK_COND_OWN:
		s = "own";
		break;
	}
	*dflt = srch_menu( *pp, s );

	/* оݤ˱ƥ˥塼ܤ̵ */

	switch( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt ){
	case AUTO_MARK_TRGT_DOOR:
	case AUTO_MARK_TRGT_TRAP:
	case AUTO_MARK_TRGT_MNSTR:
		set_flg_menu( *pp, "stagger", FLG_MENU_HIDDEN );
		set_flg_menu( *pp, "own", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_ITEM:
		set_flg_menu( *pp, "stagger", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_MBR:
		set_flg_menu( *pp, "own", FLG_MENU_HIDDEN );
		break;
	case AUTO_MARK_TRGT_UNCHANGE:
	case AUTO_MARK_TRGT_CLEAR:
		return STR_MENU_ERR;
	}

	if( (*dflt != NULL) && chk_flg( (*dflt)->flg, FLG_MENU_HIDDEN ) )
		*dflt = NULL;

	p = srch_menu( *pp, "title" );
	if( p == NULL )
		return STR_MENU_ERR;
	sprintf( p->msg, MSG_TTL_MENU_AUTO_MARK_COND,
			get_msg_ttl_auto_mark_name( auto_mark_cur_n ),
			g_sel_mbr->name );

	return NULL;
}

/***************************************************************
* Խ˥塼ξ򤷤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_cond( menu_t **pp, menu_t **dflt )
{
	switch( (auto_mark_cond_t)(long)((*pp)->arg) ){
	case AUTO_MARK_COND_NEAREST:
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].cond
				= AUTO_MARK_COND_NEAREST;
		break;
	case AUTO_MARK_COND_DISPERSE:
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].cond
				= AUTO_MARK_COND_DISPERSE;
		break;
	case AUTO_MARK_COND_STAGGER:
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].cond
				= AUTO_MARK_COND_STAGGER;
		break;
	case AUTO_MARK_COND_OWN:
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].cond
				= AUTO_MARK_COND_OWN;
		break;
	}

	return NULL;
}

/***************************************************************
* Խ˥塼Υƥ̤򤷤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_appoint_item(
	menu_t **pp, menu_t **dflt
)
{
	menu_t	*ls;
	long	k;
	auto_mark_appoint_item_t	*apo;
	long	i;

	if( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].trgt
			!= AUTO_MARK_TRGT_ITEM ){
		return STR_MENU_CANCEL;
	}

	ls = ls_menu_appoint_item;
	k = 0;

	str_nz_cpy( ls[k].path, "/appoint item",
			MENU_PATH_MAX_LEN );
	str_nz_cpy( ls[k].kind, "<Branch>",
			MENU_KIND_MAX_LEN );
	ls[k].accel_key = '\0';
	ls[k].short_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	ls[k].msg[0] = '\0';
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	str_nz_cpy( ls[k].path, "/appoint item/title",
			MENU_PATH_MAX_LEN );
	str_nz_cpy( ls[k].kind, "<Title>",
			MENU_KIND_MAX_LEN );
	ls[k].accel_key = '\0';
	ls[k].short_key[0] = '\0';
	ls[k].n_msg = N_MSG_NULL;
	sprintf( ls[k].msg, MSG_TTL_MENU_AUTO_MARK_APPOINT_ITEM_MJR,
			get_msg_ttl_auto_mark_name( auto_mark_cur_n ),
			g_sel_mbr->name );
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	apo = get_auto_mark_appoint_item( g_sel_mbr );
	if( apo == NULL )
		return STR_MENU_ERR;

	for( i = 0; i < LOOP_MAX_1000; i++ ){
		char	*ret;

		if( apo->mjr == FACE_MJR_NULL )
			break;

		ret = set_menu_auto_mark_appoint_item(
				ls, &k, (char)('A' + i), &apo );
		if( ret != NULL )
			return ret;
	}
	ls[k].path[0] = '\0';

	*pp = ls;
	*dflt = NULL;

	return NULL;
}

/***************************************************************
* Խ˥塼Υƥ̤
* menu_t *ls : ˥塼
* long *k : Υ˥塼ֹ
* char mjr_key : 򥭡
* auto_mark_appoint_item_t **apo : ƥ̤Υǡ
* return : ˥塼ΰư
***************************************************************/

char	*set_menu_auto_mark_appoint_item(
	menu_t *ls, long *k, char mjr_key,
	auto_mark_appoint_item_t **apo
)
{
	char	mjr;
	char	mnr_key;

	mjr = (*apo)->mjr;

	sprintf( ls[*k].path, "/appoint item/%c", mjr );
	str_nz_cpy( ls[*k].kind, "<Branch>",
			MENU_KIND_MAX_LEN );
	ls[*k].accel_key = mjr_key;
	ls[*k].short_key[0] = '\0';
	ls[*k].n_msg = N_MSG_NULL;
	str_nz_cpy( ls[*k].msg, get_item_mjr_name( mjr ),
			MENU_MSG_MAX_LEN );
	ls[*k].call_back = cb_menu_auto_mark_appoint_item_init;
	ls[*k].arg = (void *)(*apo);
	ls[*k].flg = FLG_NULL;
	(*k)++;

	mnr_key = 'A';
	for( ; (*apo)->mjr != FACE_MJR_NULL; (*apo)++ ){
		char	*name;

		if( (*apo)->mjr != mjr )
			break;

		name = get_item_mnr_name( mjr, (*apo)->mnr );
		if( strcmp( name, MSG_ITEM_MNR_NAME_ERR ) == 0 )
			continue;
		if( strcmp( name, MSG_NULL ) == 0 )
			continue;

		sprintf( ls[*k].path, "/appoint item/%c/%c",
				(*apo)->mjr, (*apo)->mnr );
		str_nz_cpy( ls[*k].kind, "<CheckItem>",
				MENU_KIND_MAX_LEN );
		ls[*k].accel_key = mnr_key;
		ls[*k].short_key[0] = '\0';
		ls[*k].n_msg = N_MSG_NULL;
		str_nz_cpy( ls[*k].msg, name, MENU_MSG_MAX_LEN );
		ls[*k].call_back = cb_menu_auto_mark_appoint_item_mnr;
		ls[*k].arg = (void *)(*apo);
		ls[*k].flg = FLG_NULL;
		(*k)++;

		mnr_key++;
	}

	return NULL;
}

/***************************************************************
* Խ˥塼Υƥ̤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_appoint_item_init(
	menu_t **pp, menu_t **dflt
)
{
	auto_mark_appoint_item_t	*apo;
	char	mjr;
	char	sub_path[MENU_PATH_MAX_LEN + 1];

	apo = (auto_mark_appoint_item_t *)((*pp)->arg);
	mjr = apo->mjr;

	for( ; apo->mjr != FACE_MJR_NULL; apo++ ){
		if( apo->mjr != mjr )
			break;

		sprintf( sub_path, "%c", apo->mnr );
		if( apo->flg_ena )
			set_chk_on_menu( *pp, sub_path );
		else
			set_chk_off_menu( *pp, sub_path );
	}

	return NULL;
}

/***************************************************************
* Խ˥塼Υƥ̤ξܺ٤򤷤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_appoint_item_mnr(
	menu_t **pp, menu_t **dflt
)
{
	auto_mark_appoint_item_t	*apo;

	apo = (auto_mark_appoint_item_t *)((*pp)->arg);
	if( chk_flg( (*pp)->flg, FLG_MENU_CHK_ON ) )
		apo->flg_ena = TRUE;
	else
		apo->flg_ena = FALSE;

	return STR_MENU_CANCEL;
}

/***************************************************************
* Խ˥塼Υޥ
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_macro( menu_t **pp, menu_t **dflt )
{
	char	*cmd;
	static char	msg_cmd[WIN_MSG_DRAW_WIDTH + 1];
	static char	buf_cmd[MACRO_MAX_LEN + 1];
	long	x, y;

	/* ȥɽ */

	print_msg( FLG_NULL, MSG_GETS_AUTO_MARK_MACRO_TTL );

	/* Υޥɽ */

	cmd = ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].macro;
	print_msg( FLG_NULL, MSG_GETS_AUTO_MARK_MACRO_PREV, cmd );

	/* ץץȤɽ */

	sprintf( msg_cmd, MSG_GETS_AUTO_MARK_MACRO_CMD, MACRO_MAX_LEN );
	print_msg( FLG_NULL, msg_cmd );

	/* ޥ桼 */

	x = str_len_draw( msg_cmd );
	y = get_max_line() - 1;
	if( game_gets( x, y, buf_cmd, MACRO_MAX_LEN, TRUE ) ){
		long	len;

		/* βԤ */

		len = str_len_std( buf_cmd );
		if( len >= 1 )
			if( buf_cmd[len - 1] == '\n' )
				buf_cmd[len - 1] = '\0';

		/* Ϥ̵ʤ饭󥻥 */

		if( buf_cmd[0] == '\0' )
			return STR_MENU_CANCEL;
	} else {
		/* 顼ʤ饭󥻥 */
		return STR_MENU_CANCEL;
	}

	/* ޥ */

	str_nz_cpy( ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].macro,
			buf_cmd, MACRO_MAX_LEN );

	return STR_MENU_CANCEL;
}

/***************************************************************
* Խ˥塼Ϣ³ޡ
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_cont( menu_t **pp, menu_t **dflt )
{
	if( chk_flg( (*pp)->flg, FLG_MENU_CHK_ON ) ){
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].flg
				|= FLG_AUTO_MARK_EDIT_CONT;
	} else {
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].flg
				&= ~(FLG_AUTO_MARK_EDIT_CONT);
	}

	return STR_MENU_CANCEL;
}

/***************************************************************
* Խ˥塼ͥ
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_priority( menu_t **pp, menu_t **dflt )
{
	if( chk_flg( (*pp)->flg, FLG_MENU_CHK_ON ) ){
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].flg
				|= FLG_AUTO_MARK_EDIT_PRIORITY;
	} else {
		ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n].flg
				&= ~(FLG_AUTO_MARK_EDIT_PRIORITY);
	}

	return STR_MENU_CANCEL;
}

/***************************************************************
* ʬॳԡ˥塼򤷤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_copy_large( menu_t **pp, menu_t **dflt )
{
	long	n;
	long	i;

	n = (long)((*pp)->arg);

	for( i = 0; i < LS_MBR_MAX_N; i++ ){
		clip_board_large[i] = ls_auto_mark[i][n];

		str_nz_cpy( clip_board_ttl,
				msg_ttl_auto_mark[n],
				MSG_TTL_AUTO_MARK_MAX_LEN );
	}

	print_msg( FLG_NULL, MSG_MENU_AUTO_MARK_DONE_COPY );

	return STR_MENU_CANCEL;
}

/***************************************************************
* ʬڡȡ˥塼򤷤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_paste_large( menu_t **pp, menu_t **dflt )
{
	long	n;
	long	i;

	n = (long)((*pp)->arg);

	for( i = 0; i < LS_MBR_MAX_N; i++ ){
		ls_auto_mark[i][n] = clip_board_large[i];

		str_nz_cpy( msg_ttl_auto_mark[n],
				clip_board_ttl,
				MSG_TTL_AUTO_MARK_MAX_LEN );
	}

	set_menu_auto_mark( dflt );

	print_msg( FLG_NULL, MSG_MENU_AUTO_MARK_DONE_PASTE );

	return "/auto mark/0";
}

/***************************************************************
* ʬॳԡ˥塼򤷤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_copy_small( menu_t **pp, menu_t **dflt )
{
	clip_board_small = ls_auto_mark[g_sel_mbr->ls_mbr_n]
			[auto_mark_cur_n];

	print_msg( FLG_NULL, MSG_MENU_AUTO_MARK_DONE_COPY );

	return STR_MENU_CANCEL;
}

/***************************************************************
* ʬڡȡ˥塼򤷤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_paste_small( menu_t **pp, menu_t **dflt )
{
	ls_auto_mark[g_sel_mbr->ls_mbr_n][auto_mark_cur_n]
			= clip_board_small;

	print_msg( FLG_NULL, MSG_MENU_AUTO_MARK_DONE_PASTE );

	return "/edit";
}

/***************************************************************
* Ƭ¤ٴ˥塼򤷤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_arrange_top( menu_t **pp, menu_t **dflt )
{
	char	*ret;

	ret = menu_auto_mark_arrange( (long)((*pp)->arg), -1 );

	set_menu_auto_mark( dflt );

	return ret;
}

/***************************************************************
* ¤ٴ˥塼򤷤
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*cb_menu_auto_mark_arrange_bottom( menu_t **pp, menu_t **dflt )
{
	char	*ret;

	ret = menu_auto_mark_arrange( (long)((*pp)->arg), +1 );

	set_menu_auto_mark( dflt );

	return ret;
}

/***************************************************************
* ˥塼¤ٴ
* menu_t **pp : ˥塼
* menu_t **dflt : ˥塼Υǥե
* return : ˥塼ΰư
***************************************************************/

char	*menu_auto_mark_arrange( long n, long d )
{
	long	i, j;
	auto_mark_t	am;
	char	buf[MSG_TTL_AUTO_MARK_MAX_LEN + 1];

	if( d <= -1 )
		d = -1;
	else if( d >= +1 )
		d = +1;
	else
		return STR_MENU_ERR;

	for( i = 0; i < LS_MBR_MAX_N; i++ ){
		am = ls_auto_mark[i][n];

		if( d <= -1 ){
			for( j = n - 1; j >= 0; j-- ){
				ls_auto_mark[i][j + 1]
						= ls_auto_mark[i][j];
			}

			ls_auto_mark[i][0] = am;
		} else {
			for( j = n + 1; j < AUTO_MARK_MAX_N; j++ ){
				ls_auto_mark[i][j - 1]
						= ls_auto_mark[i][j];
			}

			ls_auto_mark[i][AUTO_MARK_MAX_N - 1] = am;
		}
	}

	/**/

	str_nz_cpy( buf, get_msg_ttl_auto_mark_code( n ),
			MSG_TTL_AUTO_MARK_MAX_LEN );

	if( d <= -1 ){
		for( j = n - 1; j >= 0; j-- ){
			str_nz_cpy( get_msg_ttl_auto_mark_code( j + 1 ),
					get_msg_ttl_auto_mark_code( j ),
					MSG_TTL_AUTO_MARK_MAX_LEN );
		}

		str_nz_cpy( get_msg_ttl_auto_mark_code( 0 ), buf,
				MSG_TTL_AUTO_MARK_MAX_LEN );
	} else {
		for( j = n + 1; j < AUTO_MARK_MAX_N; j++ ){
			str_nz_cpy( get_msg_ttl_auto_mark_code( j - 1 ),
					get_msg_ttl_auto_mark_code( j ),
					MSG_TTL_AUTO_MARK_MAX_LEN );
		}

		str_nz_cpy( get_msg_ttl_auto_mark_code( j - 1 ), buf,
				MSG_TTL_AUTO_MARK_MAX_LEN );
	}

	/**/

	auto_mark_cur_n = 0;

	if( d <= -1 ){
		print_msg( FLG_NULL,
				MSG_MENU_AUTO_MARK_DONE_ARRANGE_TOP );
	} else {
		print_msg( FLG_NULL,
				MSG_MENU_AUTO_MARK_DONE_ARRANGE_BOTTOM );
	}

	return "/auto mark";
}

/***************************************************************
* оݤоݤʸѴ
* mbr_t *mbr : С
* return : оݤΥ˥塼ʸ
***************************************************************/

char	*get_msg_menu_auto_mark_edit_trgt( mbr_t *mbr )
{
	switch( ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n].trgt ){
	case AUTO_MARK_TRGT_MNSTR:
		return MSG_MENU_AUTO_MARK_TRGT_MNSTR;
	case AUTO_MARK_TRGT_ITEM:
		return MSG_MENU_AUTO_MARK_TRGT_ITEM;
	case AUTO_MARK_TRGT_DOOR:
		return MSG_MENU_AUTO_MARK_TRGT_DOOR;
	case AUTO_MARK_TRGT_TRAP:
		return MSG_MENU_AUTO_MARK_TRGT_TRAP;
	case AUTO_MARK_TRGT_MBR:
		return MSG_MENU_AUTO_MARK_TRGT_MBR;
	case AUTO_MARK_TRGT_UNCHANGE:
		return MSG_MENU_AUTO_MARK_TRGT_UNCHANGE;
	case AUTO_MARK_TRGT_CLEAR:
		return MSG_MENU_AUTO_MARK_TRGT_CLEAR;
	}

	return MSG_NOT_NULL;
}

/***************************************************************
* ֹ礤ֹ礤ʸѴ
* mbr_t *mbr : С
* return : ֹ礤Υ˥塼ʸ
***************************************************************/

char	*get_msg_menu_auto_mark_edit_dist( mbr_t *mbr )
{
	auto_mark_trgt_t	trgt;

	trgt = ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n].trgt;
	if( (trgt == AUTO_MARK_TRGT_UNCHANGE)
			|| (trgt ==AUTO_MARK_TRGT_CLEAR) ){
		return MSG_MENU_AUTO_MARK_INVALID;
	}

	switch( ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n].dist ){
	case AUTO_MARK_DIST_NEAR:
		return MSG_MENU_AUTO_MARK_DIST_NEAR;
	case AUTO_MARK_DIST_MEDIUM:
		return MSG_MENU_AUTO_MARK_DIST_MEDIUM;
	case AUTO_MARK_DIST_FAR:
		return MSG_MENU_AUTO_MARK_DIST_FAR;
	}

	return MSG_NOT_NULL;
}

/***************************************************************
* ưưʸѴ
* mbr_t *mbr : С
* return : ưΥ˥塼ʸ
***************************************************************/

char	*get_msg_menu_auto_mark_edit_act( mbr_t *mbr )
{
	auto_mark_trgt_t	trgt;

	trgt = ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n].trgt;
	if( (trgt == AUTO_MARK_TRGT_UNCHANGE)
			|| (trgt ==AUTO_MARK_TRGT_CLEAR) ){
		return MSG_MENU_AUTO_MARK_INVALID;
	}

	switch( ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n].act ){
	case AUTO_MARK_ACT_FIGHT:
		return MSG_MENU_AUTO_MARK_ACT_FIGHT;
	case AUTO_MARK_ACT_THROW:
		return MSG_MENU_AUTO_MARK_ACT_THROW;
	case AUTO_MARK_ACT_STEAL:
		return MSG_MENU_AUTO_MARK_ACT_STEAL;
	case AUTO_MARK_ACT_TAIL:
		return MSG_MENU_AUTO_MARK_ACT_TAIL;
	case AUTO_MARK_ACT_PICK_UP:
		return MSG_MENU_AUTO_MARK_ACT_PICK_UP;
	case AUTO_MARK_ACT_OPEN:
		return MSG_MENU_AUTO_MARK_ACT_OPEN;
	case AUTO_MARK_ACT_CLOSE:
		return MSG_MENU_AUTO_MARK_ACT_CLOSE;
	case AUTO_MARK_ACT_JAM:
		return MSG_MENU_AUTO_MARK_ACT_JAM;
	case AUTO_MARK_ACT_DISARM:
		return MSG_MENU_AUTO_MARK_ACT_DISARM;
	case AUTO_MARK_ACT_BREAK:
		return MSG_MENU_AUTO_MARK_ACT_BREAK;
	case AUTO_MARK_ACT_PEEP:
		return MSG_MENU_AUTO_MARK_ACT_PEEP;
	case AUTO_MARK_ACT_CHK:
		return MSG_MENU_AUTO_MARK_ACT_CHK;
	}

	return MSG_NOT_NULL;
}

/***************************************************************
* 狼ʸѴ
* mbr_t *mbr : С
* return : Υ˥塼ʸ
***************************************************************/

char	*get_msg_menu_auto_mark_edit_cond( mbr_t *mbr )
{
	auto_mark_trgt_t	trgt;

	trgt = ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n].trgt;
	if( (trgt == AUTO_MARK_TRGT_UNCHANGE)
			|| (trgt ==AUTO_MARK_TRGT_CLEAR) ){
		return MSG_MENU_AUTO_MARK_INVALID;
	}

	switch( ls_auto_mark[mbr->ls_mbr_n][auto_mark_cur_n].cond ){
	case AUTO_MARK_COND_NEAREST:
		return MSG_MENU_AUTO_MARK_COND_NEAREST;
	case AUTO_MARK_COND_DISPERSE:
		return MSG_MENU_AUTO_MARK_COND_DISPERSE;
	case AUTO_MARK_COND_STAGGER:
		return MSG_MENU_AUTO_MARK_COND_STAGGER;
	case AUTO_MARK_COND_OWN:
		return MSG_MENU_AUTO_MARK_COND_OWN;
	}

	return MSG_NOT_NULL;
}

/***************************************************************
* ߤμưޡֹ֤
* return : ߤμưޡֹ
***************************************************************/

long	get_auto_mark_cur_n( void )
{
	return auto_mark_cur_n;
}

/***************************************************************
* ߤμưޡΥƥ̤֤
* return : ߤμưޡΥƥ
***************************************************************/

auto_mark_appoint_item_t	*get_auto_mark_appoint_item( mbr_t *mbr )
{
	long	n;

	if( mbr == NULL )
		return NULL;

	n = get_auto_mark_cur_n();

	return auto_mark_appoint_item[mbr->ls_mbr_n][n];
}

/***************************************************************
* ưޡΥȥʸ֤
* n : ưޡֹ
* return : ưޡΥȥʸ
***************************************************************/

char	*get_msg_ttl_auto_mark_code( long n )
{
	return msg_ttl_auto_mark[n];
}

/***************************************************************
* ưޡΥȥ̾ʸ֤
* n : ưޡֹ
* return : ưޡΥȥ̾ʸ
***************************************************************/

char	*get_msg_ttl_auto_mark_name( long n )
{
	static char	str[MSG_TTL_AUTO_MARK_MAX_LEN + 1];

	str[0] = '\0';
	str_max_n_cat( str, get_msg_ttl_auto_mark_info( n ),
			MSG_TTL_AUTO_MARK_MAX_LEN );
	str_max_n_cat( str, STR_TTL_AUTO_MARK_SPLIT_NAME,
			MSG_TTL_AUTO_MARK_MAX_LEN );
	str_max_n_cat( str, get_msg_ttl_auto_mark_hint( n ),
			MSG_TTL_AUTO_MARK_MAX_LEN );

	return str;
}

/***************************************************************
* ưޡΥȥξܺʸ֤
* n : ưޡֹ
* return : ưޡΥȥξܺʸ
***************************************************************/

char	*get_msg_ttl_auto_mark_info( long n )
{
	static char	str[MSG_TTL_AUTO_MARK_MAX_LEN + 1];
	char	*ttl, *p;

	ttl = msg_ttl_auto_mark[n];

	p = strstr( ttl, STR_TTL_AUTO_MARK_SPLIT_CODE );
	if( p == NULL ){
		str_nz_cpy( str, ttl, MSG_TTL_AUTO_MARK_MAX_LEN );
	} else {
		long	len;

		len = p - ttl;
		if( len < 0 )
			len = 0;
		if( len > MSG_TTL_AUTO_MARK_MAX_LEN )
			len = MSG_TTL_AUTO_MARK_MAX_LEN;

		str_nz_cpy( str, ttl, len );
	}

	return str;
}

/***************************************************************
* ưޡΥȥΥҥʸ֤
* n : ưޡֹ
* return : ưޡΥȥΥҥʸ
***************************************************************/

char	*get_msg_ttl_auto_mark_hint( long n )
{
	static char	str[MSG_TTL_AUTO_MARK_MAX_LEN + 1];
	char	*ttl, *p;

	ttl = msg_ttl_auto_mark[n];

	p = strstr( ttl, STR_TTL_AUTO_MARK_SPLIT_CODE );
	if( p == NULL ){
		str[0] = '\0';
	} else {
		long	len;

		len = str_len_std( STR_TTL_AUTO_MARK_SPLIT_CODE );
		str_nz_cpy( str, &(p[len]), MSG_TTL_AUTO_MARK_MAX_LEN );
	}

	return str;
}

/***************************************************************
* ưޡΥǡ֤
* long ls_mbr_n : СꥹȤֹ
* return : ưޡΥǡ֤
***************************************************************/

auto_mark_t	*get_ls_auto_mark( long ls_mbr_n )
{
	if( ls_mbr_n < 0 )
		return NULL;
	if( ls_mbr_n >= LS_MBR_MAX_N )
		return NULL;

	return( ls_auto_mark[ls_mbr_n] );
}

/***************************************************************
* ưޡΥƥΥǡ֤
* long ls_mbr_n : СꥹȤֹ
* n : ưޡֹ
* return : ưޡΥƥΥǡ֤
***************************************************************/

auto_mark_appoint_item_t	*get_ls_auto_mark_appoint_item(
	long ls_mbr_n, long n
)
{
	if( ls_mbr_n < 0 )
		return NULL;
	if( ls_mbr_n >= LS_MBR_MAX_N )
		return NULL;
	if( n < 0 )
		return NULL;
	if( n >= AUTO_MARK_MAX_N )
		return NULL;

	return( auto_mark_appoint_item[ls_mbr_n][n] );
}
