/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2006 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: menu.c,v 1.182 2006/08/13 20:02:58 bowkenken Exp $
***************************************************************/

#define	MENU_C
#include	"inc.h"

/**/

#define	DRAW_MENU_CLR_N	-1

#define	FUNC_KEY_MAX_N	15

/**/

static bool_t	g_flg_space_select;
static bool_t	g_flg_chk_short_key;

static ask_t	g_sel_ask;

static char	*menu_kind_ls[] = {
	/* ȥ */
	"<Title>",

	/*  */
	"<Item>",

	/* å */
	"<CheckItem>",

	/*  */
	"<RadioItem>",

	/* ̥ɥ򳫤 */
	"<OpenWinItem>",

	/* <RadioItem>ζڤ */
	"<Separator>",

	/* ˥塼ʣڡͭζڤ */
	"<PageSeparator>",

	/* ֥˥塼 */
	"<Branch>",

	NULL,
};

static char	g_macro[FUNC_KEY_MAX_N + 1][MACRO_MAX_LEN + 1];

typedef struct {
	char	*key;
	char	*dflt;
} macro_short_key_t;

static macro_short_key_t
		g_ls_macro_short_key[FUNC_KEY_MAX_N + 1] = {
	{ NULL, NULL },	/* NULL */
	{ NULL, NULL },	/* F1 */
	{ NULL, NULL },	/* F2 */
	{ NULL, NULL },	/* F3 */
	{ NULL, NULL },	/* F4 */
	{ NULL, NULL },	/* F5 */
	{ NULL, NULL },	/* F6 */
	{ NULL, NULL },	/* F7 */
	{ NULL, NULL },	/* F8 */
	{ NULL, "x" },	/* F9 */
	{ NULL, "a" },	/* F10 */
	{ NULL, "c" },	/* F11 */
	{ NULL, "v" },	/* F12 */
};

static bool_t	g_flg_dup_short_key[256];

/**/

#include	"menu-tab.h"

/**/

void	init_var_menu( void )
{
	set_flg_space_select( FALSE );
}

/**/

void	init_menu( void )
{
	long	i;

	g_flg_chk_short_key = FALSE;

	chk_dup_short_key();

	for( i = 1; i <= FUNC_KEY_MAX_N; i++ ){
		g_macro[i][0] = '\0';

		if( g_ls_macro_short_key[i].dflt != NULL ){
			str_nz_cpy( g_macro[i],
					g_ls_macro_short_key[i].dflt,
					MACRO_MAX_LEN );
		}
	}

	init_ls_menu_macro();
}

/**/

void	init_ls_menu_macro( void )
{
	menu_t	*ls;
	long	i, k;

	ls = ls_menu_macro;
	k = 0;

	str_nz_cpy( ls[k].path, "/macro", MENU_PATH_MAX_LEN );
	str_nz_cpy( ls[k].kind, "<Branch>", MENU_KIND_MAX_LEN );
	ls[k].accel_key = '\0';
	ls[k].short_key[0] = '\0';
	ls[k].msg[0] = '\0';
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	str_nz_cpy( ls[k].path, "/macro/--", MENU_PATH_MAX_LEN );
	str_nz_cpy( ls[k].kind, "<Title>", MENU_KIND_MAX_LEN );
	ls[k].accel_key = '\0';
	ls[k].short_key[0] = '\0';
	str_nz_cpy( ls[k].msg, MSG_MENU_MACRO, MENU_MSG_MAX_LEN );
	ls[k].call_back = NULL;
	ls[k].arg = NULL;
	ls[k].flg = FLG_NULL;
	k++;

	for( i = 1; i <= FUNC_KEY_MAX_N; i++ ){
		sprintf( ls[k].path, "/macro/%ld", i );
		str_nz_cpy( ls[k].kind, "<Branch>", MENU_KIND_MAX_LEN );
		ls[k].accel_key = (char)('A' + (i - 1));
		ls[k].short_key[0] = '\0';
		sprintf( ls[k].msg, MSG_MENU_FUNC_KEY, i );
		ls[k].call_back = NULL;
		ls[k].arg = NULL;
		ls[k].flg = FLG_NULL;
		k++;

		sprintf( ls[k].path, "/macro/%ld/--", i );
		str_nz_cpy( ls[k].kind, "<Title>", MENU_KIND_MAX_LEN );
		ls[k].accel_key = '\0';
		ls[k].short_key[0] = '\0';
		sprintf( ls[k].msg, MSG_MENU_FUNC_KEY, i );
		ls[k].call_back = NULL;
		ls[k].arg = NULL;
		ls[k].flg = FLG_NULL;
		k++;

		sprintf( ls[k].path, "/macro/%ld/exec", i );
		str_nz_cpy( ls[k].kind, "<Item>", MENU_KIND_MAX_LEN );
		ls[k].accel_key = 'X';
		if( g_ls_macro_short_key[i].key == NULL ){
			sprintf( ls[k].short_key, "&%02ld", i );
		} else {
			sprintf( ls[k].short_key, "%s &%02ld",
					g_ls_macro_short_key[i].key, i );
		}
		str_nz_cpy( ls[k].msg, MSG_MENU_MACRO_EXEC, MENU_MSG_MAX_LEN );
		ls[k].call_back = cb_menu_macro_exec;
		ls[k].arg = (void *)i;
		ls[k].flg = FLG_NULL;
		k++;

		sprintf( ls[k].path, "/macro/%ld/edit", i );
		str_nz_cpy( ls[k].kind, "<OpenWinItem>", MENU_KIND_MAX_LEN );
		ls[k].accel_key = 'E';
		ls[k].short_key[0] = '\0';
		str_nz_cpy( ls[k].msg, MSG_MENU_MACRO_EDIT, MENU_MSG_MAX_LEN );
		ls[k].call_back = cb_menu_macro_edit;
		ls[k].arg = (void *)i;
		ls[k].flg = FLG_NULL;
		k++;
	}
	ls[k].path[0] = '\0';
}

/**/

char	*exec_menu( menu_t *p, menu_t *dflt, char *str_goto )
{
	bool_t	flg_short = FALSE;
	bool_t	flg_ret = FALSE;

	if( p == NULL )
		return STR_MENU_ERR;

	chk_err_menu_kind( p );

	if( str_goto != NULL ){
		flg_short = TRUE;
		if( strcmp( p->path, str_goto ) == 0 )
			str_goto = NULL;
	}

	if( p->call_back != NULL ){
		menu_t	*pre_p = p;
		char	*str_goto_call_back;

		str_goto_call_back = p->call_back( &p, &dflt );

		if( str_goto_call_back != NULL )
			return str_goto_call_back;

		if( pre_p != p ){
			clr_msg();
			return exec_menu( p, dflt, str_goto );
		}
	}

	if( p == NULL )
		return STR_MENU_ERR;

	if( strcmp( p->kind, "<Branch>" ) != 0 )
		return NULL;

	while( 1 ){
		if( str_goto == NULL ){
			dflt = sel_menu( p, dflt );
			if( dflt == NULL )
				return STR_MENU_CANCEL;

			if( strcmp( dflt->kind, "<CheckItem>" ) == 0 ){
				if( !set_menu_check_item( dflt ) )
					return STR_MENU_ERR;
			} else if( strcmp( dflt->kind, "<RadioItem>" ) == 0 ){
				if( !set_menu_radio_item( p, dflt ) )
					return STR_MENU_ERR;
			}
		} else {
			dflt = srch_goto_menu( p, str_goto );
			if( dflt == NULL ){
				if( flg_ret )
					return str_goto;
				else
					return STR_MENU_ERR;
			}
		}

		clr_msg();
		str_goto = exec_menu( dflt, NULL, str_goto );

		if( str_goto == NULL ){
			return NULL;
		} else if( strcmp( str_goto, STR_MENU_ERR ) == 0 ){
			return STR_MENU_ERR;
		} else if( strcmp( str_goto, STR_MENU_CANCEL ) == 0 ){
			if( flg_short )
				return NULL;
			else
				str_goto = NULL;
		} else {
			flg_ret = TRUE;
		}
	}

	return STR_MENU_ERR;
}

/**/

bool_t	chk_err_menu_kind( menu_t *ls )
{
	bool_t	flg_err_ret;
	long	i, j;

	flg_err_ret = FALSE;

	for( i = 0; i < MENU_MAX_N; i++ ){
		bool_t	flg_ok;

		if( ls[i].path[0] == '\0' )
			break;

		flg_ok = FALSE;

		for( j = 0; j < LOOP_MAX_100; j++ ){
			if( menu_kind_ls[j] == NULL )
				break;

			if( strcmp( ls[i].kind, menu_kind_ls[j] ) == 0 ){
				flg_ok = TRUE;
				break;
			}
		}

		if( !flg_ok ){
			print_msg( FLG_MSG_DEBUG, MSG_ERR_MENU_KIND,
					ls[i].kind );
			flg_err_ret = TRUE;
		}
	}

	return flg_err_ret;
}

/**/

bool_t	set_menu_check_item( menu_t *p )
{
	if( chk_flg( p->flg, FLG_MENU_CHK_ON ) ){
		p->flg &= ~(FLG_MENU_CHK_ON);
		p->flg |= FLG_MENU_CHK_OFF;
	} else if( chk_flg( p->flg, FLG_MENU_CHK_OFF ) ){
		p->flg |= FLG_MENU_CHK_ON;
		p->flg &= ~(FLG_MENU_CHK_OFF);
	} else {
		return FALSE;
	}

	return TRUE;
}

/**/

bool_t	set_menu_radio_item( menu_t *ls, menu_t *p )
{
	long	i;
	const long	max_i = LOOP_MAX_4000;
	long	sep_begin_n, sep_end_n;

	sep_begin_n = 0;
	sep_end_n = 0;

	/* search begin <Separator> */

	for( i = 0; i < max_i; i++ ){
		if( ls[i].path[0] == '\0' )
			return FALSE;
		if( strcmp( ls[i].kind, "<Separator>" ) == 0 )
			sep_begin_n = i;
		if( &(ls[i]) == p )
			break;
	}
	if( i >= max_i )
		return FALSE;

	/* search end <Separator> */

	for( ; i < max_i; i++ ){
		if( ls[i].path[0] == '\0' )
			break;
		if( strcmp( ls[i].kind, "<Separator>" ) == 0 )
			break;
	}
	if( i >= max_i )
		return FALSE;
	sep_end_n = i;

	/* off other <RadioItem> */

	for( i = sep_begin_n; i <= sep_end_n; i++ ){
		if( strcmp( ls[i].kind, "<RadioItem>" ) == 0 ){
			ls[i].flg &= ~(FLG_MENU_CHK_ON);
			ls[i].flg |= FLG_MENU_CHK_OFF;
		}
	}

	/* on selected <RadioItem> */

	p->flg |= FLG_MENU_CHK_ON;
	p->flg &= ~(FLG_MENU_CHK_OFF);

	return TRUE;
}

/**/

ask_t	exec_menu_ask( char *ttl, ask_t dflt, bool_t can_cancel )
{
	menu_t	*p;
	char	*str_goto;

	g_sel_ask = dflt;

	p = srch_menu( ls_menu_ask, "title" );
	if( p == NULL )
		return ASK_ERR;

	if( ttl == NULL )
		p->msg[0] = '\0';
	else
		str_nz_cpy( p->msg, ttl, MENU_MSG_MAX_LEN );

	while( 1 ){
		str_goto = exec_menu( ls_menu_ask, NULL, NULL );

		if( str_goto != NULL ){
			if( strcmp( str_goto, STR_MENU_CANCEL ) == 0 )
				g_sel_ask = ASK_CANCEL;
		}

		if( !can_cancel && (g_sel_ask == ASK_CANCEL) )
			continue;

		break;
	}

	clr_msg();

	return g_sel_ask;
}

/**/

char	*cb_menu_ask_init( menu_t **pp, menu_t **dflt )
{
	char	*sub_path;

	if( g_sel_ask == ASK_YES )
		sub_path = "yes";
	else
		sub_path = "no";

	*dflt = srch_menu( *pp, sub_path );
	if( *dflt == NULL )
		return STR_MENU_ERR;

	return NULL;
}

/**/

char	*cb_menu_ask_yes( menu_t **pp, menu_t **dflt )
{
	g_sel_ask = ASK_YES;

	return NULL;
}

/**/

char	*cb_menu_ask_no( menu_t **pp, menu_t **dflt )
{
	g_sel_ask = ASK_NO;

	return NULL;
}

/**/

char	*exec_menu_sel_num( long min, long max, long *p )
{
	long	i;
	long	figure;
	long	sel_n;
	char	num[FIGURE_MAX_N];
	const char	*fmt = "%+0*ld";

	figure = 0;
	if( labs( min ) < labs( max ) )
		i = labs( max );
	else
		i = labs( min );
	for( ; i > 0; i /= 10 )
		figure++;
	if( figure < 1 )
		figure = 1;

	sprintf( num, fmt, (int)(figure + 1), *p );

	sel_n = 1 + figure + MENU_NUM_OK;
	while( 1 ){
		long	d;
		bool_t	flg_ret;

		draw_menu_num( figure, sel_n, num );

		d = 0;
		flg_ret = FALSE;

		switch( get_key( g_flg_clr_key_buf_menu ) ){
		case CASE_CANCEL:
			return STR_MENU_CANCEL;
		case ' ':
			if( g_flg_space_select ){
				flg_ret = TRUE;
				d = +1;
			}
			break;
		case CASE_ENTER:
			if( !g_flg_space_select ){
				flg_ret = TRUE;
				d = +1;
			}
			break;
		case CASE_CRSR_UP:
			d = +1;
			break;
		case CASE_CRSR_DOWN:
			d = -1;
			break;
		case CASE_CRSR_LEFT:
			sel_n--;
			if( sel_n < 0 ){
				sel_n = 1 + figure + MENU_NUM_MAX_N - 1;
			}
			break;
		case CASE_CRSR_RIGHT:
			sel_n++;
			if( sel_n > 1 + figure + MENU_NUM_MAX_N - 1 )
				sel_n = 0;
			break;
		default:
			break;
		}

		*p = strtol( num, (char **)NULL, 10 );

		if( (d != 0) || flg_ret ){
			if( sel_n == 1 + figure + MENU_NUM_OK ){
				if( flg_ret ){
					if( *p < min )
						*p = min;
					else if( *p > max )
						*p = max;
					else
						return NULL;
				}
			} else if( sel_n == 1 + figure + MENU_NUM_MIN ){
				if( flg_ret )
					*p = min;
			} else if( sel_n == 1 + figure + MENU_NUM_MAX ){
				if( flg_ret )
					*p = max;
			} else if( sel_n == 1 + figure + MENU_NUM_CLR ){
				if( flg_ret )
					*p = 0;
			} else if( sel_n == 0 ){
				if( num[0] == '-' )
					num[0] = '+';
				else
					num[0] = '-';

				*p = strtol( num, (char **)NULL, 10 );
			} else {
				long	n;

				n = num[sel_n] - '0' + d;
				if( n > 9 )
					n = 0;
				if( n < 0 )
					n = 9;
				num[sel_n] = (char)('0' + n);

				*p = strtol( num, (char **)NULL, 10 );
			}

			sprintf( num, fmt, (int)(figure + 1), *p );
		}
	}

	return STR_MENU_ERR;
}

/**/

void	sel_menu_clr( draw_menu_t *data )
{
	long	pre_n;

	pre_n = data->sel_n;
	data->sel_n = DRAW_MENU_CLR_N;

	draw_menu( data );

	data->sel_n = pre_n;
}

/**/

menu_t	*sel_menu( menu_t *p, menu_t *dflt )
{
	static draw_menu_t	data;
	menu_t	*tmp_p;
	long	page_sel_n, page_max_n;
	long	n, sel_n, max_n;
	bool_t	flg_head;
	bool_t	flg_set_dflt;
	int	i;

	if( p == NULL )
		return NULL;

	page_sel_n = 0;
	page_max_n = 0;
	sel_n = 0;
	max_n = 0;
	tmp_p = p;
	flg_head = TRUE;

	for( i = 0, n = 0; i < LOOP_MAX_4000; i++ ){
		tmp_p++;
		tmp_p = srch_next_menu( p, tmp_p, TRUE );
		if( tmp_p == NULL )
			break;

		if( flg_head ){
			flg_head = FALSE;
			page_max_n++;
		}

		if( tmp_p == dflt ){
			page_sel_n = page_max_n - 1;
			sel_n = n;
		}

		if( strcmp( tmp_p->kind, "<Title>" ) == 0 ){
			;
		} else if( strcmp( tmp_p->kind, "<Separator>" ) == 0 ){
			;
		} else if( strcmp( tmp_p->kind, "<PageSeparator>" ) == 0 ){
			n = 0;
			flg_head = TRUE;
		} else {
			n++;
		}
	}

	max_n = set_ls_menu( &data, p, page_sel_n );
	if( max_n <= 0 )
		return NULL;

	flg_set_dflt = TRUE;

	while( 1 ){
		long	dx, dy;
		long	key;
		long	i;

		data.sel_n = sel_n;
		data.page_sel_n = page_sel_n;
		data.page_max_n = page_max_n;
		if( page_sel_n == 0 )
			data.flg_min_page = TRUE;
		else
			data.flg_min_page = FALSE;
		if( page_sel_n == page_max_n - 1 )
			data.flg_max_page = TRUE;
		else
			data.flg_max_page = FALSE;

		draw_menu( &data );
		data.flg_redraw = FALSE;
		if( flg_set_dflt ){
			call_set_mouse_dflt_menu( sel_n );
			flg_set_dflt = FALSE;
		}

		dx = 0;
		dy = 0;
		key = get_key( g_flg_clr_key_buf_menu );

		switch( key ){
		case '\0':
			break;
		default:
			for( i = 0; i < max_n; i++ )
				if( data.ls[i]->accel_key == key )
					break;
			if( i >= max_n )
				break;

			sel_n = i;
			sel_menu_clr( &data );
			return( data.ls[sel_n] );
		case ' ':
			if( g_flg_space_select ){
				/* ܤ */
				sel_menu_clr( &data );
				return( data.ls[sel_n] );
			} else {
				break;
			}
		case CASE_ENTER:
			if( g_flg_space_select ){
				/* ˥塼Ĥ */
				sel_menu_clr( &data );
				return NULL;
			} else {
				/* ܤ */
				sel_menu_clr( &data );
				return( data.ls[sel_n] );
			}
		case CASE_CANCEL:
			sel_menu_clr( &data );
			return NULL;
		case CASE_CRSR_UP:
			dy = -1;
			break;
		case CASE_CRSR_DOWN:
			dy = +1;
			break;
		case CASE_CRSR_LEFT:
			dx = -1;
			break;
		case CASE_CRSR_RIGHT:
			dx = +1;
			break;
		case CASE_CRSR_UP_LEFT:
			dx = -1;
			dy = -1;
			break;
		case CASE_CRSR_UP_RIGHT:
			dx = +1;
			dy = -1;
			break;
		case CASE_CRSR_DOWN_LEFT:
			dx = -1;
			dy = +1;
			break;
		case CASE_CRSR_DOWN_RIGHT:
			dx = +1;
			dy = +1;
			break;
		case '<':
			dx = 0 - page_sel_n;
			break;
		case '>':
			dx = (page_max_n - 1) - page_sel_n;
			break;
		}

		if( dy != +-0 ){
			sel_n += dy;
			sel_n += max_n;
			sel_n %= max_n;
		}
		if( dx != +-0 ){
			page_sel_n += dx;
			page_sel_n += page_max_n;
			page_sel_n %= page_max_n;

			sel_menu_clr( &data );

			max_n = set_ls_menu( &data, p, page_sel_n );

			if( max_n <= 0 )
				return NULL;
			if( sel_n > max_n - 1 )
				sel_n = max_n - 1;
		}
	}

	return NULL;
}

/**/

long	set_ls_menu(
	draw_menu_t *data,
	menu_t *p,
	long page_sel_n
)
{
	long	n;
	long	page_n;
	menu_t	*tmp_p;
	bool_t	key_tab[256];
	long	i;

	if( p == NULL )
		return 0;

	data->ttl = NULL;
	data->ls[0] = NULL;
	data->sel_n = 0;
	data->prev_sel_n = 0;
	data->page_sel_n = 0;
	data->page_max_n = 0;
	data->flg_min_page = FALSE;
	data->flg_max_page = FALSE;
	data->flg_redraw = TRUE;

	for( i = 0; i < 256; i++ )
		key_tab[i] = FALSE;

	n = 0;
	page_n = 0;
	tmp_p = p;
	for( i = 0; i < LOOP_MAX_4000; i++ ){
		tmp_p++;
		tmp_p = srch_next_menu( p, tmp_p, TRUE );
		if( tmp_p == NULL )
			break;

		if( tmp_p->msg[0] == '\0' )
			str_nz_cpy( tmp_p->msg, MSG( tmp_p->n_msg ),
					MENU_MSG_MAX_LEN );

		if( page_n == page_sel_n ){
			if( strcmp( tmp_p->kind, "<Title>" ) == 0 ){
				data->ttl = tmp_p->msg;
			} else if( strcmp( tmp_p->kind,
					"<Separator>" ) == 0 ){
				;
			} else if( strcmp( tmp_p->kind,
					"<PageSeparator>" ) == 0 ){
				;
			} else {
				do {
					if( !g_flg_debug )
						break;
					if( tmp_p->accel_key == '\0' )
						break;
					if( !key_tab[tmp_p->accel_key] )
						break;

					print_msg( FLG_MSG_ERR,
							MSG_ERR_MENU_ACCEL_KEY,
							tmp_p->accel_key,
							tmp_p->msg );
				} while( 0 );

				key_tab[tmp_p->accel_key] = TRUE;
				data->ls[n] = tmp_p;
				n++;
				data->ls[n] = NULL;
			}
		}
		if( page_n > page_sel_n )
			break;
		if( strcmp( tmp_p->kind, "<PageSeparator>" ) == 0 ){
			if( page_n == page_sel_n )
				break;
			page_n++;
		}
	}

	if( data->sel_n > n )
		data->sel_n = n;

	return n;
}

/**/

menu_t	*srch_menu( menu_t *ls, char *sub_path )
{
	long	idx;
	menu_t *p;

	if( ls == NULL )
		return NULL;
	if( ls->path[0] == '\0' )
		return NULL;
	if( sub_path == NULL )
		return NULL;

	idx = str_len_std( ls->path ) + 1;
	for( p = &(ls[1]); p->path[0] != '\0'; p++ ){
		p = srch_next_menu( ls, p, FALSE );
		if( p == NULL )
			return NULL;

		if( strcmp( &(p->path[idx]), sub_path ) == 0 )
			return p;
	}

	return NULL;
}

/**/

menu_t	*srch_next_menu(
	menu_t *ls, menu_t *p, bool_t flg_skip_hidden
)
{
	long	idx;

	if( ls == NULL )
		return NULL;
	if( p == NULL )
		return NULL;
	if( ls->path[0] == '\0' )
		return NULL;
	if( p->path[0] == '\0' )
		return NULL;

	if( strcmp( ls->path, "/" ) == 0 )
		idx = 0;
	else
		idx = str_len_std( ls->path );

	for( ; ; p++ ){
		if( p->path[0] == '\0' )
			return NULL;

		if( idx > 0 )
			if( strncmp( ls->path, p->path, idx ) != 0 )
				return NULL;

		if( flg_skip_hidden )
			if( chk_flg( p->flg, FLG_MENU_HIDDEN ) )
				continue;

		if( strchr( &(p->path[idx + 1]), '/' ) == NULL )
			return p;
	}

	return NULL;
}

/**/

menu_t	*srch_goto_menu( menu_t *p, char *str_goto )
{
	long	len_goto;
	menu_t *tmp_p;

	if( p == NULL )
		return NULL;
	if( p->path[0] == '\0' )
		return NULL;
	if( str_goto == NULL )
		return NULL;
	if( strcmp( p->kind, "<Branch>" ) != 0 )
		return NULL;

	len_goto = str_len_std( str_goto );

	for( tmp_p = &p[1]; tmp_p->path[0] != '\0'; tmp_p++ ){
		long	len;

		len = str_len_std( p->path );
		if( strncmp( tmp_p->path, p->path, len ) != 0 )
			return NULL;

		len = str_len_std( tmp_p->path );
		if( strncmp( tmp_p->path, str_goto, len ) == 0 ){
			if( len == len_goto ){
				return tmp_p;
			} else if( len < len_goto ){
				if( str_goto[len] == '/' )
					return tmp_p;
			} else {
				return NULL;
			}
		}
	}

	return NULL;
}

/**/

void	set_chk_on_menu( menu_t *p, char *sub_path )
{
	set_flg_menu( p, sub_path, FLG_MENU_CHK_ON );
	clr_flg_menu( p, sub_path, FLG_MENU_CHK_OFF );
}

/**/

void	set_chk_off_menu( menu_t *p, char *sub_path )
{
	clr_flg_menu( p, sub_path, FLG_MENU_CHK_ON );
	set_flg_menu( p, sub_path, FLG_MENU_CHK_OFF );
}

/**/

bool_t	set_flg_menu( menu_t *p, char *sub_path, unsigned long flg )
{
	return equ_flg_menu( p, sub_path, flg, TRUE );
}

/**/

bool_t	clr_flg_menu( menu_t *p, char *sub_path, unsigned long flg )
{
	return equ_flg_menu( p, sub_path, flg, FALSE );
}

/**/

bool_t	equ_flg_menu(
	menu_t *p, char *sub_path, unsigned long flg, bool_t flg_set
)
{
	static char	path[255 + 1];
	const long	len = sizeof( path ) - 1;
	menu_t	*tmp_p;
	bool_t	flg_find;

	if( p == NULL )
		return FALSE;

	path[0] = '\0';
	if( sub_path != NULL ){
		if( strcmp( p->path, "/" ) != 0 )
			str_nz_cpy( path, p->path, len );
		str_max_n_cat( path, "/", len );
		str_max_n_cat( path, sub_path, len );
	}

	flg_find = FALSE;
	for( tmp_p = &p[1]; tmp_p->path[0] != '\0'; tmp_p++ ){
		tmp_p = srch_next_menu( p, tmp_p, FALSE );
		if( tmp_p == NULL )
			break;

		if( sub_path != NULL )
			if( strcmp( tmp_p->path, path ) != 0 )
				continue;

		if( flg_set )
			tmp_p->flg |= flg;
		else
			tmp_p->flg &= ~flg;

		flg_find = TRUE;
	}

	if( !flg_find && (sub_path != NULL) )
		print_msg( FLG_NULL, MSG_ERR_MENU_SRCH_PATH, path );

	return flg_find;
}

/**/

void	wait_key( bool_t flg_can_move_crsr )
{
	print_msg( FLG_NULL, MSG_WAIT_KEY );

	wait_key_ex( FALSE, flg_can_move_crsr );
}

/**/

void	wait_key_ex( bool_t flg_exec_key, bool_t flg_can_move_crsr )
{
	long	c;

	while( 1 ){
		if( flg_can_move_crsr )
			c = chk_key( TRUE, FALSE );
		else
			c = get_key( g_flg_clr_key_buf );

		switch( c ){
		case CASE_CANCEL:
		case ' ':
		case CASE_ENTER:
			return;
		case CASE_EXEC:
			if( flg_exec_key )
				return;
			break;
		default:
			break;
		}
	}
}

/**/

long	chk_key( bool_t flg_clr_key_buf, bool_t flg_chk_menu )
{
	long	c;

	wipe_menu();

	reset_crsr();

	c = get_key( flg_clr_key_buf );

	if( flg_chk_menu )
		clr_msg();

	switch( c ){
	case '\0':
	case ' ':
	case CASE_CANCEL:
		break;
	case CASE_ENTER:
	case 'M':
	case 'm':
		/* ˥塼ɽ */
		if( flg_chk_menu ){
			move_all_mbr_trgt();
			exec_menu( get_ls_menu_main(),
					get_menu_dflt_main(), NULL );
			wipe_menu();
		}
		break;

#if	HAVE_LIBCURSES
	case KEY_RESIZE:
		redraw_all();
		break;
#endif	/* HAVE_LIBCURSES */

	default:
		g_flg_chk_short_key = TRUE;

		if( chk_short_key( get_ls_menu_move_crsr(), c ) ){
			wipe_menu();
			break;
		}

		if( flg_chk_menu ){
			if( chk_short_key( get_ls_menu_main(), c ) ){
				wipe_menu();
				break;
			}
			if( chk_short_key( get_ls_menu_sel_obj(), c ) ){
				wipe_menu();
				break;
			}
			if( chk_short_key( get_ls_menu_macro(), c ) ){
				wipe_menu();
				break;
			}
		}

		if( flg_chk_menu ){
			print_msg( FLG_NULL, MSG_ERR_CHK_KEY,
					(unsigned char)c, (long)c );
		}
		break;
	}

	if( chk_redraw_every_turn() )
		force_redraw_map();

	if( g_flg_echo_key ){
		if( (c != '\0') && (c != -1) ){
			long	cc;

			if( isprint( c ) )
				cc = c;
			else
				cc = ' ';

			print_msg( FLG_MSG_NO_MORE,
					MSG_ECHO_KEY,
					(unsigned char)cc, (long)c );
		}
	}

	g_flg_chk_short_key = FALSE;

	update_crsr();

	return c;
}

/**/

void	chk_dup_short_key( void )
{
	chk_dup_short_key_init();
	chk_dup_short_key_main( get_ls_menu_move_crsr() );
	chk_dup_short_key_main( get_ls_menu_main() );
	chk_dup_short_key_main( get_ls_menu_sel_obj() );
}

/**/

void	chk_dup_short_key_init( void )
{
	long	i;

	for( i = 0; i < 256; i++ ){
		g_flg_dup_short_key[i] = FALSE;
	}
}

/**/

bool_t	chk_dup_short_key_main( menu_t *ls )
{
	menu_t	*p;

	for( p = ls; p->path[0] != '\0'; p++ ){
		char	*cp;

		for( cp = p->short_key; *cp != '\0'; cp++ ){
			if( isspace( *cp ) ){
				continue;
			} else if( *cp == '\\' ){
				cp++;
				if( *cp == '\0' )
					break;
			} else if( *cp == '^' ){
				cp++;
				if( *cp == '\0' )
					break;

				chk_dup_short_key_sub( *cp - '@', p );
				continue;
			}

			chk_dup_short_key_sub( *cp, p );
		}
	}

	return TRUE;
}

/**/

bool_t	chk_dup_short_key_sub( unsigned char c, menu_t *ls )
{
	if( g_flg_dup_short_key[c] ){
		char	s[8];

		if( ('A' - '@' <= c) && (c <= 'Z' - '@') )
			sprintf( s, "^%c", c + '@' );
		else
			sprintf( s, "%c", c );

		print_err( MSG_ERR_MENU_SHORT_CUT_KEY,
				s, MSG( ls->n_msg ) );
		return FALSE;
	}

	g_flg_dup_short_key[c] = TRUE;

	return TRUE;
}

/**/

bool_t	chk_short_key( menu_t *ls, long c )
{
	bool_t	flg_find = FALSE;
	menu_t	*p;

	if( ls == NULL )
		return FALSE;

	for( p = ls; p->path[0] != '\0'; p++ ){
		char	*cp;

		for( cp = p->short_key; *cp != '\0'; cp++ ){
			if( isspace( *cp ) ){
				continue;
			} else if( *cp == '\\' ){
				cp++;
				if( *cp == '\0' )
					return FALSE;
			} else if( *cp == '^' ){
				cp++;
				if( *cp == '\0' )
					return FALSE;
				if( *cp == '^' ){
					if( c == '^' ){
						flg_find = TRUE;
						break;
					}
				}
				if( *cp - '@' == c ){
					flg_find = TRUE;
					break;
				}
				continue;
			} else if( *cp == '&' ){
				long	fn;

				cp++;
				if( *cp == '\0' )
					return FALSE;
				if( *cp == '&' ){
					if( c == '&' ){
						flg_find = TRUE;
						break;
					}
				}

				/* Function Key */

				fn = *cp - '0';
				cp++;
				if( *cp == '\0' )
					return FALSE;
				fn *= 10;
				fn = *cp - '0';
//@@@#if	HAVE_LIBCURSES
				if( c == KEY_F( fn ) ){
					flg_find = TRUE;
					break;
				}
//@@@#endif	/* HAVE_LIBCURSES */

				continue;
			}

			if( *cp == c ){
				flg_find = TRUE;
				break;
			}
		}
		if( flg_find ){
			exec_menu( ls, NULL, p->path );
			return TRUE;
		}
	}

	return FALSE;
}

/**/

menu_t	*get_ls_menu_macro( void )
{
	return ls_menu_macro;
}

/**/

char	*get_macro( long n )
{
	if( n < 0 )
		n = 0;
	if( n >= FUNC_KEY_MAX_N )
		n = 0;

	return g_macro[n];
}

/**/

bool_t	get_flg_chk_short_key( void )
{
	return g_flg_chk_short_key;
}

/**/

bool_t	get_flg_space_select( void )
{
	return g_flg_space_select;
}

/**/

bool_t	set_flg_space_select( bool_t flg )
{
	g_flg_space_select = flg;

	return g_flg_space_select;
}

/**/

