/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2006 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: call.cpp,v 1.24 2006/08/18 08:00:42 bowkenken Exp $
***************************************************************/

#define	CALL_CPP
#include	"inc.h"

#ifdef D_WS
extern WSCwindow *StatWin;
#endif

/***************************************************************
* ᥤ󡦥롼פΥåɤڤ
* void *(*func)( void * ) : 롦Хåؿ
* return : 顼̵ä
***************************************************************/

bool_t	call_game_thread_create( void *(*func)( void * ) )
{
#ifdef D_WS
	if( GameThreadCreate( func ) )
		return TRUE;
	else
		return FALSE;
#endif // D_WS

#ifdef D_GTK
	if( GameThreadCreate( func ) )
		return TRUE;
	else
		return FALSE;
#endif // D_GTK

	return TRUE;
}

/***************************************************************
* ޥåסɥϢ³¹ԥܥΥå
* bool_t flagExec : 
***************************************************************/

void	call_gui_map_cont_exec_set( bool_t flagExec )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gtk_toggle_button_set_active(
			GTK_TOGGLE_BUTTON( gMapButtonContExec ),
			flagExec );
#endif // D_GTK
}

/***************************************************************
* ˥塼ɥ
* draw_menu_t *data : ˥塼ѥǡ
***************************************************************/

void	call_gui_menu_draw( draw_menu_t *data )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gGuiMenu.draw( data );

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiMenu.draw( data );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* ˥塼ɥĤ
***************************************************************/

void	call_gui_menu_wipe()
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gGuiMenu.wipe();

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiMenu.wipe();

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* ǥեȤܤ˥ޥư
* long sel_n : 
***************************************************************/

void	call_set_mouse_dflt_menu( long sel_n )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gGuiMenu.setMouseDfltMenu( sel_n );

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiMenu.setMouseDfltMenu( sel_n );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* եåѥΥꥻå
***************************************************************/

void	call_pcg_dun_reset()
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gPcgDun.reset();

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
#if 0
//@@@
	if( !g_flg_init )
		return;
#endif
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gPcgDun.reset();

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* ޥåפιե饰Υꥻå
***************************************************************/

void	call_pcg_dun_reset_update_flg()
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gPcgDun.resetUpdateFlg();

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gPcgDun.resetUpdateFlg();

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* եåѥ
* long map_x : ޥåפ X ɸ
* long map_y : ޥåפ Y ɸ
* long map_w : ޥåפ
* long map_h : ޥåפι⤵
***************************************************************/

void	call_pcg_dun_draw( long map_x, long map_y, long map_w, long map_h )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gPcgDun.draw( map_x, map_y, map_w, map_h );

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gPcgDun.draw( map_x, map_y, map_w, map_h );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* ޥåפΥ
* long map_x : ޥåפ X ɸ
* long map_y : ޥåפ Y ɸ
***************************************************************/

void	call_pcg_dun_scroll( long map_x, long map_y )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gPcgDun.scrollTile( map_x, map_y );

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gPcgDun.scrollTile( map_x, map_y );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* ơɥ
***************************************************************/

void	call_stat_win_redraw()
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	StatWin->redraw();

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
#endif // D_GTK
}

/***************************************************************
* ʸ
* return : Ϥ줿
***************************************************************/

long	call_key_get_char()
{
	long	c = '\0';

#ifdef D_WS
	if( !g_flg_init )
		return c;
	if( !g_flg_gui )
		return c;

	WSGIappDev()->lock();

	c = gKey.getChar();

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
#endif // D_GTK

	return c;
}
