/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2006 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: fx.h,v 1.48 2006/02/17 04:45:36 bowkenken Exp $
***************************************************************/

#ifndef	FX_H
#define	FX_H

/***************************************************************
* ե
***************************************************************/

#include	"abl-kind.h"

/***************************************************************
* եȤθ̤ζ
***************************************************************/

#define	RESURRECTION_MIN_RATE	30
#define	RESURRECTION_MAX_RATE	90

#define	MAGIC_SHIELD_ADD_DEF_RATE	50
#define	MAGIC_SHIELD_MAX_N	1

#define	MAGE_ARMOR_ADD_AC_RATE	20
#define	MAGE_ARMOR_MAX_N	3

#define	SUBSTITUTE_ADD_DEF_RATE	20
#define	SUBSTITUTE_ADD_AC_RATE	20
#define	SUBSTITUTE_MAX_N	2

#define	BURNING_HANDS_ADD_HIT_RATE	20
#define	BURNING_HANDS_ADD_DAM_RATE	20
#define	BURNING_HANDS_MAX_N	2

#define	MIND_READING_ADD_WPN_CRTCL_RATE	20
#define	MIND_READING_ADD_ARMOR_CRTCL_RATE	20
#define	MIND_READING_MAX_N	2

/***************************************************************
* եȤʿѻ³
***************************************************************/

/* Ⱦʵ */
#define	FX_TURN_INFINITE_N	(-1)

/* Ǥǲ HP 뤫? */
#define	FX_AVE_TURN_POISON_DEC	20

#define	FX_AVE_TURN_STONE	FX_TURN_INFINITE_N
#define	FX_AVE_TURN_PARALYZE	16
#define	FX_AVE_TURN_POISON	1024
#define	FX_AVE_TURN_CONFUSION	16
#define	FX_AVE_TURN_BLIND	512
#define	FX_AVE_TURN_SLEEP	32
#define	FX_AVE_TURN_SILENCE	32
#define	FX_AVE_TURN_FEAR	32
#define	FX_AVE_TURN_HALLUCINATION	32
#define	FX_AVE_TURN_CHARM	32
#define	FX_AVE_TURN_FLY	128
#define	FX_AVE_TURN_VANISH	128
#define	FX_AVE_TURN_IRON_BODY	32
#define	FX_AVE_TURN_PASSWALL	128
#define	FX_AVE_TURN_SENSE_INVISIBLE	128

#define	FX_AVE_TURN_MAGIC_SHIELD	64
#define	FX_AVE_TURN_MAGE_ARMOR	64
#define	FX_AVE_TURN_SUBSTITUTE	32
#define	FX_AVE_TURN_BURNING_HANDS	32
#define	FX_AVE_TURN_MIND_READING	32

#define	FX_AVE_TURN_POW_UP_HP	64
#define	FX_AVE_TURN_POW_UP_ABL	64
#define	FX_AVE_TURN_POW_DOWN_ABL	64
#define	FX_AVE_TURN_POW_UP_RESI	64
#define	FX_AVE_TURN_SPEED_UP	256
#define	FX_AVE_TURN_SPEED_DOWN	256

#define	FX_AVE_TURN_STORE_LIGHT	FX_TURN_INFINITE_N

#define	FX_AVE_TURN_DARKVISION	128
#define	FX_AVE_TURN_RECALL	20

#define	FX_AVE_TURN_BLESS	64

#define	FX_AVE_TURN_FAINT	16
#define	FX_TURN_DRUNK	1024

/***************************************************************
* եȤμ
***************************************************************/

typedef enum {
	FX_KIND_NULL,
	FX_KIND_STONE,
	FX_KIND_PARALYZE,
	FX_KIND_POISON,
	FX_KIND_CONFUSION,
	FX_KIND_BLIND,
	FX_KIND_SLEEP,
	FX_KIND_SILENCE,
	FX_KIND_FEAR,
	FX_KIND_HALLUCINATION,
	FX_KIND_CHARM,
	FX_KIND_FLY,
	FX_KIND_FAINT,
	FX_KIND_DRUNK,
	FX_KIND_VANISH,
	FX_KIND_IRON_BODY,
	FX_KIND_PASSWALL,
	FX_KIND_SENSE_INVISIBLE,
	FX_KIND_WEAK_HEAT,
	FX_KIND_WEAK_COLD,
	FX_KIND_WEAK_MIND,
	FX_KIND_WEAK_ACID,
	FX_KIND_WEAK_ELEC,
	FX_KIND_WEAK_POIS,
	FX_KIND_RESI_KNOC,
	FX_KIND_RESI_SLAS,
	FX_KIND_RESI_STIN,
	FX_KIND_RESI_HEAT,
	FX_KIND_RESI_COLD,
	FX_KIND_RESI_MIND,
	FX_KIND_RESI_ACID,
	FX_KIND_RESI_ELEC,
	FX_KIND_RESI_POIS,
	FX_KIND_SHARPNESS,
	FX_KIND_DULLNESS,
	FX_KIND_STRENGTH,
	FX_KIND_WEAKNESS,
	FX_KIND_QUICKNESS,
	FX_KIND_SLOWNESS,
	FX_KIND_BRAINY,
	FX_KIND_BRAINLESS,
	FX_KIND_WISE,
	FX_KIND_FOOLISH,
	FX_KIND_ATTRACTIVE,
	FX_KIND_UNATTRACTIVE,
	FX_KIND_POW_UP_HP,
	FX_KIND_MAGIC_SHIELD,
	FX_KIND_MAGE_ARMOR,
	FX_KIND_SUBSTITUTE,
	FX_KIND_BURNING_HANDS,
	FX_KIND_MIND_READING,
	FX_KIND_SPEED_UP,
	FX_KIND_SPEED_DOWN,
	FX_KIND_BLESS,
	FX_KIND_STORE_LIGHT,
	FX_KIND_MAX_N,
} fx_kind_t;

/***************************************************************
* HP  MP β
***************************************************************/

typedef struct {
	long	count;
	long	turn;
	rate_t	rate;
	long	n;
} cure_t;

/***************************************************************
* ʢ
***************************************************************/

typedef struct {
	/* ߤΨ */
	rate_t	rate;
	/* ʢΨ */
	rate_t	full_rate;

	/* 1ξò */
	long	digest_p_day;
	/* ò */
	long	digest_n;

	/* ʢˤʤΨ */
	rate_t	hungry_rate;
	/* 䤹Ψ */
	rate_t	starvation_rate;
} stomach_t;

/***************************************************************
* ˥¸
***************************************************************/

typedef struct {
	/* ˥ηǻ */
	rate_t	rate;
	/* ˥ */
	rate_t	poisoning_rate;
	/* Ψ */
	rate_t	lost_rate;
} nicotine_t;

/***************************************************************
* ե
***************************************************************/

typedef struct fx {
	/*  */
	struct fx	*next, *prev;

	/*  */
	fx_kind_t	kind;

	/* Ĥ꥿ */
	long	turn;

	/* Ťͳݤ */
	long	n;

	/* оݥ顢Ӿ */
	struct chr_t	*chr, *cast_chr;

	/* ¦ǽ */
	abl_kind_t	abl_kind;
} fx_t;

/***************************************************************
* μ
***************************************************************/

typedef enum {
	LIQUOR_KIND_RED_WINE,
	LIQUOR_KIND_WHITE_WINE,
	LIQUOR_KIND_ROSE_WINE,
	LIQUOR_KIND_ALE,
	LIQUOR_KIND_BRANDY,
	LIQUOR_KIND_RUM,
	LIQUOR_KIND_MAX_N
} liquor_kind_t;

/***************************************************************
* 
***************************************************************/

/* κȾ */

#define	BLAST_MAX_X	64
#define	BLAST_MAX_Y	64

/* μ */

typedef enum {
	BLAST_KIND_STD,
	BLAST_KIND_NINJA_CRTCL,
	BLAST_KIND_WORD_OF_DESTRUCTION,
	BLAST_KIND_MAX_N
} blast_kind_t;

/* ǡ */

typedef struct {
	/* ľ */
	long	xl, yl;

	/* Ⱦ */
	long	xr, yr;

	/* Ʃʸ */
	long	transmit_chr;

	/* ѥ */
	char	ptn[BLAST_MAX_Y + 1][BLAST_MAX_X + 1];
} blast_t;

#endif	/* FX_H */

