/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: main-dos.c,v 1.11 2007/01/11 17:31:35 bowkenken Exp $
***************************************************************/

/***************************************************************
* DOS ѤΥᥤ
***************************************************************/

#define	MAIN_DOS_C
#include	"inc.h"

/***************************************************************
* 
***************************************************************/

#define	STR_ENV_SHELL	"SHELL"
#ifdef	D_DOS
# define	STR_DFLT_SHELL	"command"
#else	/* D_DOS */
# define	STR_DFLT_SHELL	"sh"
#endif	/* D_DOS */

/***************************************************************
* Ԥ
***************************************************************/

#define	KEY_WAIT_VMIN	0
#define	KEY_WAIT_VTIME	1

/***************************************************************
* 
***************************************************************/

#define	OPT_ARG_MAX_LEN	128
#define	STR_OPT	"gcuk:e:s:p:md:Vh"

#if	HAVE_GETOPT_LONG
static struct option	long_opt[] = {
	{ "gui",           no_argument,       NULL, 'g' },
	{ "cui",           no_argument,       NULL, 'c' },
	{ "gui-and-cui",   no_argument,       NULL, 'u' },
	{ "clear-key-buf", required_argument, NULL, 'k' },
	{ "echo-key",      required_argument, NULL, 'e' },
	{ "use-curses",    required_argument, NULL, 's' },
	{ "use-keypad",    required_argument, NULL, 'p' },
	{ "measure-clock", no_argument,       NULL, 'm' },
	{ "debug",         required_argument, NULL, 'd' },
	{ "version",       no_argument,       NULL, 'V' },
	{ "help",          no_argument,       NULL, 'h' },
	{ 0, 0, 0, 0 }
};
#endif	/* HAVE_GETOPT_LONG */

/***************************************************************
* 
***************************************************************/

char	str_usage[] = {
	"Usage: %s [OPTION]...\n"
	"OPTION:\n"
#if	0
	"  -g, --gui                set GUI mode\n"
	"  -c, --cui                set CUI mode\n"
	"  -u, --gui-and-cui        set GUI and CUI mode\n"
#endif
	"  -k, --clear-key-buf=FLAG clear key buffer:\n"
	"                             ON, OFF\n"
	"  -e, --echo-key=FLAG      echo key:\n"
	"                             ON, OFF\n"
	"  -s, --use-curses=FLAG    use curses library:\n"
	"                             ON, OFF\n"
	"  -p, --use-keypad=FLAG    use cursor key (call keypad):\n"
	"                             ON, OFF\n"
	"  -m, --measure-clock      measure frame rate\n"
#if	0
	"  -d, --debug=FLAG         set debug mode:\n"
	"                             ON, OFF\n"
#endif
	"  -V, --version            display version and exit\n"
	"  -h, --help               display this help and exit\n"
};

/***************************************************************
* ѿ
***************************************************************/

long	flg_term;

/***************************************************************
* ᥤ󡦥롼
* int argc : ο
* char **argv : Υꥹ
* return : λ
***************************************************************/

int	main_dos( void )
{
	init_arg();

	init_game();
	game_main();

	return EXIT_FAILURE;
}

/***************************************************************
* ν
* int argc : ο
* char **argv : Υꥹ
***************************************************************/

void	chk_arg( int argc, char **argv )
{
	if( argv == NULL )
		return;

#if	HAVE_GETOPT || HAVE_GETOPT_LONG
	while( 1 ){
		long	c;
# if	HAVE_GETOPT_LONG
		int	opt_idx;

		c = getopt_long( argc, argv, STR_OPT, long_opt, &opt_idx );
# else	/* HAVE_GETOPT_LONG */
		c = getopt( argc, argv, STR_OPT );
# endif	/* HAVE_GETOPT_LONG */

		if( c <= -1 )
			break;
		switch( c ){
		case 'g':
			g_flg_cui = FALSE;
			g_flg_gui = TRUE;
			break;
		case 'c':
			g_flg_cui = TRUE;
			g_flg_gui = FALSE;
			break;
		case 'u':
			g_flg_cui = TRUE;
			g_flg_gui = TRUE;
			break;
		case 'k':
			g_flg_clr_key_buf_arg_overwrite = TRUE;
			g_flg_clr_key_buf_arg = chk_opt_flg( optarg );
			break;
		case 'e':
			g_flg_echo_key = chk_opt_flg( optarg );
			break;
		case 's':
			g_flg_use_curs = chk_opt_flg( optarg );
			break;
		case 'p':
			g_flg_use_keypad = chk_opt_flg( optarg );
			break;
		case 'm':
			g_flg_measure_clk_tck = TRUE;
			break;
		case 'd':
			g_flg_debug = chk_opt_flg( optarg );
			break;
		case 'V':
			version( stdout );
			exit( EXIT_SUCCESS );
			break;
		case 'h':
			usage( stdout );
			exit( EXIT_SUCCESS );
			break;
		case '\0':
			break;
		case '?':
		case ':':
		default:
			usage( stderr );
			exit( EXIT_FAILURE );
			break;
		}
	}

	if( (argc - optind) > 0 ){
		usage( stderr );
		exit( EXIT_FAILURE );
	}
#endif	/* HAVE_GETOPT || HAVE_GETOPT_LONG */
}

/***************************************************************
* Υ󡿥դΥե饰å
* const char *optarg : ץʸ
* return : ե饰?
***************************************************************/

bool_t	chk_opt_flg( const char *optarg )
{
	static char	str[OPT_ARG_MAX_LEN + 1];
	long	i;

	if( optarg == NULL )
		return FALSE;

	for( i = 0; i < OPT_ARG_MAX_LEN; i++ ){
		if( optarg[i] == '\0' )
			break;
		str[i] = toupper( optarg[i] );
	}
	str[i] = '\0';

	if( strcmp( str, "ON" ) == 0 )
		return TRUE;
	if( strcmp( str, "TRUE" ) == 0 )
		return TRUE;
	if( strcmp( str, "T" ) == 0 )
		return TRUE;
	if( strcmp( str, "YES" ) == 0 )
		return TRUE;
	if( strcmp( str, "1" ) == 0 )
		return TRUE;

	if( strcmp( str, "OFF" ) == 0 )
		return FALSE;
	if( strcmp( str, "FALSE" ) == 0 )
		return FALSE;
	if( strcmp( str, "NIL" ) == 0 )
		return FALSE;
	if( strcmp( str, "NO" ) == 0 )
		return FALSE;
	if( strcmp( str, "0" ) == 0 )
		return FALSE;

	return FALSE;
}

/***************************************************************
* ǻꤵ줿
***************************************************************/

void	overwrite_arg( void )
{
	if( g_flg_clr_key_buf_arg_overwrite ){
		g_flg_clr_key_buf = g_flg_clr_key_buf_arg;
		g_flg_clr_key_buf_menu = g_flg_clr_key_buf_arg;
	}
}

/***************************************************************
* ɽ
* FILE *fp : ե
***************************************************************/

void	usage( FILE *fp )
{
	if( !g_flg_cui )
		return;

	fprintf( fp, str_usage, STR_FILE_NAME_GAME );
	fflush( fp );
}

/***************************************************************
* θƤӽФ
***************************************************************/

void	child_ps_dos( void )
{
	char	*shell;

	if( !g_flg_cui )
		return;

	dis_scrn();

	shell = getenv( STR_ENV_SHELL );
	if( shell == NULL )
		shell = STR_DFLT_SHELL;

	fprintf( stdout, MSG_CHILD_PS, shell );
	fflush( stdout );
	system( shell );

	ena_scrn( FALSE );
}

/***************************************************************
* üν
***************************************************************/

void	init_term_dos( void )
{
	flg_term = 0;
}

/***************************************************************
* üͭĴ٤
* return : üͭ?
***************************************************************/

bool_t	chk_term_dos( void )
{
	return( flg_term > 0 );
}

/***************************************************************
* üͭˤ
***************************************************************/

void	ena_term_dos( void )
{
	if( !g_flg_cui )
		return;

	flg_term++;
}

/***************************************************************
* ü̵ˤ
***************************************************************/

void	dis_term_dos( void )
{
	if( !g_flg_cui )
		return;

	flg_term--;
}

/***************************************************************
* Ԥ
***************************************************************/

void	set_key_wait_dos( void )
{
	set_key_wait_vtime( KEY_WAIT_VTIME );
}

/***************************************************************
* Ԥ
***************************************************************/

void	clr_key_wait_dos( void )
{
	set_key_wait_vtime( 0 );
}

/***************************************************************
* Ԥ֤
* long wait_vtime : Ԥ
***************************************************************/

void	set_key_wait_vtime( long wait_vtime )
{
	if( !g_flg_cui )
		return;
}

