/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: FileList.cpp,v 1.4 2007/02/04 12:34:49 bowkenken Exp $
***************************************************************/

#ifdef D_WS
# include <WSDenv.h>
#endif //D_WS

#include "spell.h"
#include "menu.h"
#include "amenu.h"

#include "FileList.h"

#include "draw.h"
#include "town.h"
#include "gfile.h"
#include "draw-prot.h"
#include "gfile-prot.h"

////////////////////////////////////////////////////////////////
// Υꥻå
// WSCstring dirSub : फХѥ
// WSCstring ext : ĥҤΥꥹ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool FileList::reset( WSCstring dirSub, WSCstring ext )
{
	if( dpFile != NULL ){
		closedir( dpFile );
		dpFile = NULL;
	}

	sDirBase = jointDir( getBaseDir(), "" );
	sDirSub = jointDir( dirSub, "" );
	sDirFullPath = jointDir( sDirBase, sDirSub );

	make_dir( sDirFullPath );

	sExt = ext;
	bFlagExist = false;

	dpFile = opendir( sDirFullPath );
	if( dpFile == NULL )
		return false;

	return true;
}

////////////////////////////////////////////////////////////////
// Υե򸡺
// Ĥʤäǥ쥯ȥ򤵤Τܤ
// return : ĤäեХѥ
////////////////////////////////////////////////////////////////

WSCstring FileList::next()
{
	for( long i = 0; i < LOOP_MAX_100; i++ ){
		WSCstring path = nextNode();

		if( path.getChars() > 0 )
			return path;
		if( bFlagExist )
			return "";

		// ǥ쥯ȥ򺬤˸ä̤

		for( long j = 0; j < LOOP_MAX_100; j++ ){
			long nWords = sDirSub.getWords( "/" );
			if( nWords <= 1 )
				return "";

			long nPos = sDirSub.getWordCharPos( nWords - 2, "/" );
			if( nPos > -1 )
				sDirSub.cutString( nPos );
			if( reset( sDirSub, sExt ) )
				break;
		}
	}

	return "";
}

////////////////////////////////////////////////////////////////
// Υե򸡺
// return : ĤäեХѥ
////////////////////////////////////////////////////////////////

WSCstring FileList::nextNode()
{
	if( dpFile == NULL )
		return "";

	while( 1 ){
		struct dirent *buf = readdir( dpFile );
		if( buf == NULL )
			break;

		WSCstring fileName = buf->d_name;
#ifdef D_WIN
		fileName.replaceString( "\\", "/", 0 );
#endif // D_WIN
		WSCstring name = jointDir( sDirFullPath, fileName );

		struct stat statBuf;
		stat( name, &statBuf );
		if( S_ISDIR( statBuf.st_mode ) )
			continue;

		WSCstring ext = name.getWord(
				name.getWords( "." ) - 1, "." );
		long nExtMaxN = sExt.getWords();
		for( long i = 0; i < nExtMaxN; i++ ){
			WSCstring curExt = sExt.getWord( i, "" );

			if( curExt = ext ){
				bFlagExist = true;
				return name;
			}
		}
	}

	return "";
}

////////////////////////////////////////////////////////////////
// ǥ쥯ȥꤹ
// WSCstring dir : ǥ쥯ȥ
// return : ǥ쥯ȥ
////////////////////////////////////////////////////////////////

WSCstring setStrDirSelGraph( WSCstring dir )
{
	sDirBaseSelGraph = dir;

	return dir;
}

////////////////////////////////////////////////////////////////
// ǥ쥯ȥ֤
// return : ǥ쥯ȥ
////////////////////////////////////////////////////////////////

WSCstring FileList::getBaseDir()
{
	WSCstring dir = jointDir( get_home_dir(), STR_DIR_BASE );
	dir = jointDir( dir, sDirBaseSelGraph );

	return dir;
}

////////////////////////////////////////////////////////////////
// ǥ쥯ȥɤ "/" ֤Ϣ뤹
// WSCstring dir1 : ǥ쥯ȥ̾
// WSCstring dir2 : ǥ쥯ȥ̾
// return : ָΥǥ쥯ȥ̾
////////////////////////////////////////////////////////////////

WSCstring FileList::jointDir(
	WSCstring dir1, WSCstring dir2 )
{
	const WSCstring sSlash = "/";

	long n = dir1.getChars() - 1;
	if( n < 0 )
		return( dir2 );

	if( dir1[n] == '/' )
		return( dir1 + dir2 );
	else
		return( dir1 + sSlash + dir2 );
}
