/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: FileList.h,v 1.6 2007/02/25 12:26:59 bowkenken Exp $
***************************************************************/

#ifndef FILE_LIST_H
#define FILE_LIST_H	1

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <dirent.h>
#include <sys/stat.h>

#ifdef D_WS
# include <WSCstring.h>
#endif //D_WS

#ifdef D_GTK
# include "GtkWSCstring.h"
#endif //D_GTK

////////////////////////////////////////////////////////////////
// ꤵ줿ĥҤΥե򸡺
// Ĥʤä顢ǥ쥯ȥ곬ؤǥ쥯ȥ
// ޤǡΤܤ
////////////////////////////////////////////////////////////////

#define	STR_DIR_BASE	".lnl/xlnl/graph/"

static WSCstring sDirBaseSelGraph = "sample-3.1.7/";
WSCstring setStrDirSelGraph( WSCstring dir );

//

class FileList {
public:

private:
	// ǥ쥯ȥ
	WSCstring sDirBase;

	// ǥ쥯ȥ꤫Хѥ
	WSCstring sDirSub;

	// եѥ
	WSCstring sDirFullPath;

	// ĥҤΥꥹȡڡǶڤ
	WSCstring sExt;

	// Υǥ쥯ȥ
	DIR *dpFile;

	// ĤǤե뤬Ĥä
	// Ĥäǥ쥯ȥϤΤܤʤ
	bool bFlagExist;

public:
	FileList()
	{
		sDirBase = "";
		sDirSub = "";
		sDirFullPath = "";
		sExt = "";
		dpFile = NULL;
		bFlagExist = false;
	}
	~FileList()
	{
		if( dpFile != NULL ){
			closedir( dpFile );
			dpFile = NULL;
		}
	}

	bool reset( WSCstring dir, WSCstring ext );

	WSCstring next();

	WSCstring getBaseDir();
	WSCstring jointDir( WSCstring dir1, WSCstring dir2 );

private:
	WSCstring nextNode();
};

#endif /* FILE_LIST_H */
