/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: GtkWSCstring.cpp,v 1.4 2007/02/04 12:34:49 bowkenken Exp $
***************************************************************/

#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include "GtkWSDmwindowDev.h"
#include "GlobalVar.h"

WSCstring::WSCstring()
{
}

WSCstring::WSCstring( char *str )
{
	if( str == NULL )
		*(string *)this = string( "" );
	else
		*(string *)this = string( str );
}

WSCstring::WSCstring( string str )
{
	*(string *)this = str;
}

WSCstring::WSCstring( long n )
{
	char str[32 + 1] = "";
	sprintf( str, "%ld", n );

	*(string *)this = string( str );
}

WSCstring::operator char *()
{
	return( (char *)(this->c_str()) );
}

WSCstring WSCstring::operator +( WSCstring str )
{
	return( WSCstring( string( *this ) + string( str ) ) );
}

WSCstring WSCstring::operator +( char *str )
{
	return( WSCstring( string( *this ) + string( str ) ) );
}

WSCstring &WSCstring::operator <<( WSCstring str )
{
	string( *this ) += string( str );

	return *this;
}

char WSCstring::operator []( int n )
{
	return( (char)(string( *this )[n]) );
}

long WSCstring::getChars()
{
	return( (long)(this->length()) );
}

void WSCstring::deleteChar( long pos )
{
	deleteChars( pos, 1 );
}

void WSCstring::deleteChars( long pos, long len )
{
	erase( pos, len );
}

long WSCstring::getWords(
	WSCstring str, long encoding )
{
	long n = 1;
	unsigned long pos = 0;

	if( str.length() <= 0 )
		return 0;

	while( 1 ){
		pos = find( str, pos + str.length() );
		if( pos == npos )
			break;
		n++;
	}

	return n;
}

long WSCstring::getWordCharPos(
	long n, WSCstring str, long encoding )
{
	unsigned long pos = 0;

	for( long i = 0; i < n; i++ ){
		pos = find( str, pos );
		if( pos == npos )
			return -1;

		pos += str.length();
	}

	return pos;
}

void WSCstring::cutString( long pos, long encoding )
{
	erase( pos, npos );
}

WSCstring WSCstring::getWord(
	long n, WSCstring str, long encoding )
{
	long n1 = getWordCharPos( n, str );
	long n2 = getWordCharPos( n + 1, str );

	return( substr( n1, n2 - n1 - 1 ) );
}
