/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: GuiInputString.cpp,v 1.3 2007/02/23 05:30:28 bowkenken Exp $
***************************************************************/

////////////////////////////////////////////////////////////////
// ʸϥɥ
////////////////////////////////////////////////////////////////

#ifdef	D_WS
# include "MapWin.h"
#endif	// D_WS

#include "GuiInputString.h"
#include "GlobalVar.h"

//@@@#include "main-gtk-prot.h"

////////////////////////////////////////////////////////////////
// ٥ȡϥɥ
////////////////////////////////////////////////////////////////

gint handle_input_string_delete(
	GtkWidget *widget, gpointer user_data
);
void handle_input_string_destroy(
	GtkWidget *widget, gpointer user_data
);
void handle_input_string_cancel_clicked(
	GtkWidget *widget, gpointer user_data
);
void handle_input_string_ok_clicked(
	GtkWidget *widget, gpointer user_data
);

////////////////////////////////////////////////////////////////
// åʸϥɥν
////////////////////////////////////////////////////////////////

void GuiInputString::init()
{
	newWin();
}

////////////////////////////////////////////////////////////////
// ʸϥɥκ
////////////////////////////////////////////////////////////////

void GuiInputString::newWin()
{
	if( mWin != NULL )
		return;

#ifdef D_WS
	mWin = (void *)InpStrWin;
#endif // D_WS

#ifdef D_GTK
	// ʸϥɥκ

	mWin = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	if( mWin == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_window_new()" );
		return;
	}
	gtk_window_set_title( GTK_WINDOW( mWin ),
			"InputString" );

	// ʸϥɥؤΥ٥ȡϥɥ

	gtk_signal_connect( GTK_OBJECT( mWin ),
			"delete_event",
			GTK_SIGNAL_FUNC( handle_input_string_delete ),
			this );
	gtk_signal_connect( GTK_OBJECT( mWin ),
			"destroy",
			GTK_SIGNAL_FUNC( handle_input_string_destroy ),
			this );

	//

	GtkWidget *pBox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( mWin ), pBox );
	gtk_widget_show( pBox );

	// ȥ

	mTitle = gtk_entry_new();
	if( mTitle == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_entry_new()" );
		return;
	}
	gtk_entry_set_editable( GTK_ENTRY( mTitle ), FALSE );
	gtk_box_pack_start( GTK_BOX( pBox ), mTitle,
			FALSE, TRUE, 0 );
	gtk_widget_show( mTitle );

	// ȥ꡼

	mEntry = gtk_entry_new();
	if( mEntry == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_entry_new()" );
		return;
	}
	gtk_box_pack_start( GTK_BOX( pBox ), mEntry,
			FALSE, TRUE, 0 );
	gtk_widget_show( mEntry );

	// 󥻥롦ܥ

	GtkWidget *pBoxButton = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( pBox ), pBoxButton,
			FALSE, TRUE, 0 );
	gtk_widget_show( pBoxButton );

	GtkWidget *mCancelButton = gtk_button_new_with_label(
			MSG_GUI_INPUT_STRING_CANCEL );
	if( mCancelButton == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_button_new_with_label()" );
		return;
	}
	gtk_box_pack_start( GTK_BOX( pBoxButton ), mCancelButton,
			FALSE, FALSE, 0 );
	gtk_widget_show( mCancelButton );

	// 󥻥롦ܥؤΥ٥ȡϥɥ

	gtk_signal_connect( GTK_OBJECT( mCancelButton ),
			"clicked",
			GTK_SIGNAL_FUNC(
			handle_input_string_cancel_clicked ),
			this );

	// OK ܥ

	GtkWidget *mOkButton = gtk_button_new_with_label(
			MSG_GUI_INPUT_STRING_OK );
	if( mOkButton == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_button_new_with_label()" );
		return;
	}
	gtk_box_pack_start( GTK_BOX( pBoxButton ), mOkButton,
			FALSE, FALSE, 0 );
	gtk_widget_show( mOkButton );

	// OK ܥؤΥ٥ȡϥɥ

	gtk_signal_connect( GTK_OBJECT( mOkButton ),
			"clicked",
			GTK_SIGNAL_FUNC(
			handle_input_string_ok_clicked ),
			this );
#endif	// D_GTK
}

////////////////////////////////////////////////////////////////
// ʸϥɥκ
////////////////////////////////////////////////////////////////

void GuiInputString::destroy()
{
	mWin = NULL;
}

////////////////////////////////////////////////////////////////
// ʸϥɥɽ
////////////////////////////////////////////////////////////////

void GuiInputString::draw( const char *ttl, const char *str, long len )
{
	newWin();

#ifdef D_WS
	if( mWin == NULL )
		return;

	((WSCwindow *)mWin)->setVisible( true );
#endif // D_WS

#ifdef D_GTK
	GtkEntry *e;
	GtkWindow *w;

	e = GTK_ENTRY( gGuiInpStr.mTitle );
	w = GTK_WINDOW( gGuiInpStr.mWin );
	if( ttl == NULL ){
		gtk_window_set_title( w, "" );
		gtk_entry_set_text( e, "" );
	} else {
		gtk_window_set_title( w, ttl );
		gtk_entry_set_text( e, ttl );
	}

	e = GTK_ENTRY( gGuiInpStr.mEntry );
	if( str == NULL ){
		gtk_entry_set_text( e, "" );
	} else {
		gtk_entry_set_text( e, str );
	}

	gtk_widget_show( mWin );
#endif // D_GTK
}

////////////////////////////////////////////////////////////////
// ʸϥɥĤ
////////////////////////////////////////////////////////////////

void GuiInputString::wipe()
{
	newWin();

#ifdef D_WS
	if( mWin == NULL )
		return;

	((WSCwindow *)mWin)->setVisible( false );
#endif // D_WS

#ifdef D_GTK
	gtk_widget_hide( mWin );
#endif // D_GTK
}

////////////////////////////////////////////////////////////////
// ʸϥɥĤΥϥɥ
////////////////////////////////////////////////////////////////

gint handle_input_string_delete(
	GtkWidget *widget, gpointer user_data
)
{
	set_key_buf_str( "\n" );
	gGuiInpStr.wipe();

	return true;
}

////////////////////////////////////////////////////////////////
// ʸϥɥνλΥϥɥ
////////////////////////////////////////////////////////////////

void handle_input_string_destroy(
	GtkWidget *widget, gpointer user_data
)
{
	gGuiInpStr.wipe();
}

////////////////////////////////////////////////////////////////
// 󥻥롦ܥΥåΥϥɥ
////////////////////////////////////////////////////////////////

void handle_input_string_cancel_clicked(
	GtkWidget *widget, gpointer user_data
)
{
	set_key_buf_str( "\n" );
	gGuiInpStr.wipe();
}

////////////////////////////////////////////////////////////////
// OK ܥΥåΥϥɥ
////////////////////////////////////////////////////////////////

void handle_input_string_ok_clicked(
	GtkWidget *widget, gpointer user_data
)
{
#ifdef D_WS
	WSCvifield *w = InpStrField;

	if( w != NULL ){
		WSCstring s = ((char *)w->getProperty( WSNlabelString ));

		set_key_buf_str( s );
	}
#endif // D_WS

#ifdef D_GTK
	GtkEntry *w = GTK_ENTRY( gGuiInpStr.mEntry );

	if( w != NULL ){
		const gchar *buf = gtk_entry_get_text( w );
		WSCstring s = (char *)buf;

		set_key_buf_str( s );
	}
#endif	// D_GTK

	set_key_buf_str( "\n" );
	gGuiInpStr.wipe();
}
