/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: GuiMessage.cpp,v 1.21 2007/02/26 00:50:37 bowkenken Exp $
***************************************************************/

////////////////////////////////////////////////////////////////
// åɥ
////////////////////////////////////////////////////////////////

#include "GuiMessage.h"
#include "GlobalVar.h"

#include "main-gtk-prot.h"

////////////////////////////////////////////////////////////////

#define	MESSAGE_WIN_INIT_WIDTH	(80 * 8)
#define	MESSAGE_WIN_INIT_HEIGHT	(3 * 16)

////////////////////////////////////////////////////////////////
// ٥ȡϥɥ
////////////////////////////////////////////////////////////////

gint handle_message_delete(
	GtkWidget *widget, gpointer user_data
);
void handle_message_destroy(
	GtkWidget *widget, gpointer user_data
);
gint handle_message_expose(
	GtkWidget *widget, GdkEventExpose *event
);
gint handle_message_configure(
	GtkWidget *widget, GdkEventConfigure *event
);
void handle_message_scroll_changed(
	GtkAdjustment *adjustment,
	gpointer user_data
);

////////////////////////////////////////////////////////////////
// åɥν
////////////////////////////////////////////////////////////////

void GuiMessage::init()
{
	newWin();
	gtk_widget_show( mMessageWin );
}

////////////////////////////////////////////////////////////////
// åɥκ
////////////////////////////////////////////////////////////////

void GuiMessage::newWin()
{
	GtkAttachOptions xOpt, yOpt;

	if( mMessageWin != NULL )
		return;

#ifdef D_WS
	mMessageWin = (void *)1;
#endif // D_WS

#ifdef D_GTK
	mFont[0] = gdk_fontset_load(
			"-abobe-helvetica-medium-*,-*" );

	// åɥκ

	mMessageWin = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	if( mMessageWin == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_window_new()" );
		return;
	}
	gtk_window_set_title( GTK_WINDOW( mMessageWin ),
			"Message" );

	// åɥؤΥ٥ȡϥɥ

	gtk_signal_connect( GTK_OBJECT( mMessageWin ),
			"delete_event",
			GTK_SIGNAL_FUNC( handle_message_delete ),
			this );
	gtk_signal_connect( GTK_OBJECT( mMessageWin ),
			"destroy",
			GTK_SIGNAL_FUNC( handle_message_destroy ),
			this );

	// 襨ꥢ

	GtkWidget *pTab = gtk_table_new( 2, 2, FALSE );
	gtk_container_add( GTK_CONTAINER( mMessageWin ), pTab );
	gtk_widget_show( pTab );

	mMessageDrawingArea = gtk_drawing_area_new();
	if( mMessageDrawingArea == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_drawing_area_new()" );
		return;
	}
	gtk_drawing_area_size( GTK_DRAWING_AREA( mMessageDrawingArea ),
			MESSAGE_WIN_INIT_WIDTH, MESSAGE_WIN_INIT_HEIGHT );
	xOpt = (GtkAttachOptions)(GTK_EXPAND | GTK_SHRINK | GTK_FILL);
	yOpt = (GtkAttachOptions)(GTK_EXPAND | GTK_SHRINK | GTK_FILL);
	gtk_table_attach( GTK_TABLE( pTab ), mMessageDrawingArea,
			0, 1, 0, 1,
			xOpt, yOpt,
			0, 0 );
	gtk_widget_show( mMessageDrawingArea );

	// 襨ꥢؤΥ٥ȡϥɥ

	gtk_signal_connect( GTK_OBJECT( mMessageDrawingArea ),
			"expose_event",
			GTK_SIGNAL_FUNC( handle_message_expose ),
			NULL );
	gtk_signal_connect( GTK_OBJECT( mMessageDrawingArea ),
			"configure_event",
			GTK_SIGNAL_FUNC( handle_message_configure ),
			NULL );

	// ʿ롦СĴ

	long w = WIN_MSG_DRAW_WIDTH * 32;
	mMessageHScrollBarAdjustment = gtk_adjustment_new(
			0, 0, w,
			1, w, w );
	if( mMessageHScrollBarAdjustment == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_adjustment_new()" );
		return;
	}

	// ʿ롦СĴΥ٥ȡϥɥ

	gtk_signal_connect( GTK_OBJECT( mMessageHScrollBarAdjustment ),
			"changed",
			GTK_SIGNAL_FUNC( handle_message_scroll_changed ),
			NULL );
	gtk_signal_connect( GTK_OBJECT( mMessageHScrollBarAdjustment ),
			"value_changed",
			GTK_SIGNAL_FUNC( handle_message_scroll_changed ),
			NULL );

	// ʿ롦С

	mMessageHScrollBar = gtk_hscrollbar_new(
			GTK_ADJUSTMENT( mMessageHScrollBarAdjustment ) );
	if( mMessageHScrollBar == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_hscrollbar_new()" );
		return;
	}
	xOpt = (GtkAttachOptions)(GTK_SHRINK | GTK_FILL);
	yOpt = (GtkAttachOptions)(GTK_FILL);
	gtk_table_attach( GTK_TABLE( pTab ),
			mMessageHScrollBar,
			0, 1, 1, 2,
			xOpt, yOpt,
			0, 0 );
	gtk_widget_show( mMessageHScrollBar );

	// ľ롦СĴ

	mMessageVScrollBarAdjustment = gtk_adjustment_new(
			0, 0, LS_MSG_MAX_N,
			1, 3, 3 );
	if( mMessageVScrollBarAdjustment == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_adjustment_new()" );
		return;
	}

	// ľ롦СĴΥ٥ȡϥɥ

	gtk_signal_connect( GTK_OBJECT( mMessageVScrollBarAdjustment ),
			"changed",
			GTK_SIGNAL_FUNC( handle_message_scroll_changed ),
			NULL );
	gtk_signal_connect( GTK_OBJECT( mMessageVScrollBarAdjustment ),
			"value_changed",
			GTK_SIGNAL_FUNC( handle_message_scroll_changed ),
			NULL );

	// ľ롦С

	mMessageVScrollBar = gtk_vscrollbar_new(
			GTK_ADJUSTMENT( mMessageVScrollBarAdjustment ) );
	if( mMessageVScrollBar == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_vscrollbar_new()" );
		return;
	}
	xOpt = (GtkAttachOptions)(GTK_FILL);
	yOpt = (GtkAttachOptions)(GTK_SHRINK | GTK_FILL);
	gtk_table_attach( GTK_TABLE( pTab ),
			mMessageVScrollBar,
			1, 2, 0, 1,
			xOpt, yOpt,
			0, 0 );
	gtk_widget_show( mMessageVScrollBar );
#endif	// D_GTK
}

////////////////////////////////////////////////////////////////
// åɥκ
////////////////////////////////////////////////////////////////

void GuiMessage::destroy()
{
#ifdef D_GTK
	mMessageWin = NULL;
#endif // D_GTK
}

////////////////////////////////////////////////////////////////
// å³ޡ
////////////////////////////////////////////////////////////////

void GuiMessage::setFlagMore( bool flag )
{
	flagMore = flag;
	redraw();
}

////////////////////////////////////////////////////////////////
// åκɽ
////////////////////////////////////////////////////////////////

void GuiMessage::redraw()
{
	draw( true );
}

////////////////////////////////////////////////////////////////
// åɽ
////////////////////////////////////////////////////////////////

void GuiMessage::draw( bool flagRedraw )
{
	newWin();

#ifdef D_GTK
	if( mFgGc == NULL )
		mFgGc = gdk_gc_new( mMessageDrawingArea->window );
	if( mBgGc == NULL )
		mBgGc = gdk_gc_new( mMessageDrawingArea->window );
	GdkDrawable *gd = GDK_DRAWABLE( mMessageDrawingArea->window );

	// 賫Ϻɸ

	long x = 0;
	long y = mMessageDrawingArea->allocation.height - 1;

	// ʿ롦С

	GtkAdjustment *hAdj = GTK_ADJUSTMENT(
			gGuiMessage.mMessageHScrollBarAdjustment );
	x -= (long)hAdj->value;

	// ľ롦С

	GtkAdjustment *vAdj = GTK_ADJUSTMENT(
			gGuiMessage.mMessageVScrollBarAdjustment );
	long maxN = (long)(vAdj->upper - vAdj->page_size);

	if( !flagRedraw )
		if( (long)(vAdj->value) >= maxN )
			vAdj->value = maxN + 1;

	mLsMessageDrawBeginN = maxN - (long)(vAdj->value);

	if( mLsMessageDrawBeginN > maxN )
		mLsMessageDrawBeginN = maxN;
	if( mLsMessageDrawBeginN < 0 )
		mLsMessageDrawBeginN = 0;

	// 

	long i;
	for( i = mLsMessageDrawBeginN; i < LS_MSG_MAX_N; i++ ){
		ls_msg_t *ls = get_ls_msg( i );
		if( ls == NULL )
			break;

		long w = mMessageDrawingArea->allocation.width;
		long h = gdk_string_height( mFont[0], ls->msg );

		SetPenAttr( mFgGc, mBgGc, &(ls->attr) );

		// طʤɤĤ֤

		gdk_draw_rectangle( gd, mBgGc, TRUE, 0, y - h + 1, w, h );

		// 饤

		if( ls->attr.attr & A_UNDERLINE )
			gdk_draw_line( gd, mFgGc, 0, y, 0 + w, y );

		// å

		gdk_draw_string( gd, mFont[0], mFgGc,
				x, y - 1, ls->msg );

		if( (i == 0) && flagMore ){
			long w = gdk_string_width( mFont[0], MSG_MORE );
			long moreX = mMessageDrawingArea->allocation
					.width - w;

			gdk_draw_string( gd, mFont[0], mFgGc,
					moreX, y, MSG_MORE );
		}

		y -= h;
		if( y < 0 )
			break;
	}

	mLsMessageDrawN = i - mLsMessageDrawBeginN;

	// طʤλĤʬɤĤ֤

	curs_attr_t *attr = get_curs_attr();
	SetPenAttr( NULL, mBgGc, &(attr[0]) );

	long w = mMessageDrawingArea->allocation.width;
	if( (y + 1) > 0 )
		gdk_draw_rectangle( gd, mBgGc, TRUE, 0, 0, w, y + 1 );
#endif // D_GTK

	// åɥɽ

#ifdef D_WS
	MessageWin->setVisible( true );
#endif // D_WS

#ifdef D_GTK
	gtk_widget_show( mMessageDrawingArea );
	showWin( mMessageWin, &nPreX, &nPreY, &nPreW, &nPreH );
#endif // D_GTK
}

////////////////////////////////////////////////////////////////
// åɥĤ
////////////////////////////////////////////////////////////////

void GuiMessage::wipe()
{
	newWin();

#ifdef D_WS
	MessageWin->setVisible( false );
#endif // D_WS

#ifdef D_GTK
	wipeWin( mMessageWin, &nPreX, &nPreY, &nPreW, &nPreH );
#endif // D_GTK
}

////////////////////////////////////////////////////////////////
// åɥΥ롦С
////////////////////////////////////////////////////////////////

void GuiMessage::drawScrollBar()
{
	// ʿ롦СĴ

	GtkAdjustment *hAdj = GTK_ADJUSTMENT(
			gGuiMessage.mMessageHScrollBarAdjustment );

	static char tmp[WIN_MSG_DRAW_WIDTH + 1];
	long i;
	for( i = 0; i < WIN_MSG_DRAW_WIDTH; i++ )
		tmp[i] = 'X';
	tmp[i] = '\0';
//@@@ mFont[0]
	long maxW = gdk_string_width( gGuiMessage.mFont[0], tmp );
	long pageW = gGuiMessage.mMessageDrawingArea->allocation.width;
	long incPageW = pageW / 2;
	if( incPageW < 1 )
		incPageW = 1;

	hAdj->lower = 0;
	hAdj->upper = maxW;
	hAdj->step_increment = maxW / WIN_MSG_DRAW_WIDTH;
	hAdj->page_increment = pageW;
	hAdj->page_size = pageW;

	gtk_adjustment_changed( hAdj );

	// ľ롦СĴ

	GtkAdjustment *vAdj = GTK_ADJUSTMENT(
			gGuiMessage.mMessageVScrollBarAdjustment );

	long maxH = get_ls_msg_n() - 1;
	if( maxH < 0 )
		maxH = 0;

	long pageH = gGuiMessage.mLsMessageDrawN;
	if( pageH < 1 )
		pageH = 1;

	long incPageH = pageH / 1;
	if( incPageH < 1 )
		incPageH = 1;

	vAdj->lower = 0;
	vAdj->upper = maxH + pageH;
	vAdj->step_increment = 1;
	vAdj->page_increment = incPageH;
	vAdj->page_size = pageH;

	gtk_adjustment_changed( vAdj );
}

////////////////////////////////////////////////////////////////
// åɥĤΥϥɥ
////////////////////////////////////////////////////////////////

gint handle_message_delete(
	GtkWidget *widget, gpointer user_data
)
{
	gGuiMessage.wipe();

	return true;
}

////////////////////////////////////////////////////////////////
// åɥνλΥϥɥ
////////////////////////////////////////////////////////////////

void handle_message_destroy(
	GtkWidget *widget, gpointer user_data
)
{
	gGuiMessage.destroy();
}

////////////////////////////////////////////////////////////////
// åɥ襤٥Ȥν
// GtkWidget *widget : åΥɥ󥰡ꥢ
// GdkEventExpose *event : ٥
// return : ?
////////////////////////////////////////////////////////////////

gint handle_message_expose(
	GtkWidget *widget, GdkEventExpose *event
)
{
	gGuiMessage.redraw();
	gGuiMessage.drawScrollBar();

	return TRUE;
}

////////////////////////////////////////////////////////////////
// åɥΥѹ٥Ȥν
// GtkWidget *widget : åΥɥ󥰡ꥢ
// GdkEventConfigure *event : ٥
// return : ?
////////////////////////////////////////////////////////////////

gint handle_message_configure(
	GtkWidget *widget, GdkEventConfigure *event
)
{
	gGuiMessage.redraw();
	gGuiMessage.drawScrollBar();

	return TRUE;
}

////////////////////////////////////////////////////////////////
// 롦С٥Ȥν
// GtkAdjustment *adjustment : ʿľ롦СĴ
// gpointer user_data : ϿϤ줿ǡ
////////////////////////////////////////////////////////////////

void handle_message_scroll_changed(
	GtkAdjustment *adjustment,
	gpointer user_data
)
{
	gGuiMessage.redraw();
}
