/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: GuiMisc.cpp,v 1.8 2007/02/04 20:13:32 bowkenken Exp $
***************************************************************/

////////////////////////////////////////////////////////////////
// ¾ν
////////////////////////////////////////////////////////////////

#include "gmain.h"
#include "gmain-prot.h"

#include "GuiMisc.h"

////////////////////////////////////////////////////////////////
// ڥ°ꤹ
// GdkGC *gc : ꤹ륰եåƥ
// curs_attr_t *attr : °
////////////////////////////////////////////////////////////////

void SetPenAttr( GdkGC *fgGc, GdkGC *bgGc, curs_attr_t *attr )
{
	if( attr == NULL )
		return;

	GdkColor colorFg;
	GdkColor colorBg;

	CvColorRGB( &colorFg, attr->fg );
	CvColorRGB( &colorBg, attr->bg );
	gdk_color_alloc( gdk_colormap_get_system(), &colorFg );
	gdk_color_alloc( gdk_colormap_get_system(), &colorBg );

	if( (attr->attr) & A_REVERSE ){
		if( fgGc != NULL ){
			gdk_gc_set_foreground( fgGc, &colorBg );
			gdk_gc_set_background( fgGc, &colorFg );
		}
		if( bgGc != NULL ){
			gdk_gc_set_foreground( bgGc, &colorFg );
			gdk_gc_set_background( bgGc, &colorBg );
		}
	} else {
		if( fgGc != NULL ){
			gdk_gc_set_foreground( fgGc, &colorFg );
			gdk_gc_set_background( fgGc, &colorBg );
		}
		if( bgGc != NULL ){
			gdk_gc_set_foreground( bgGc, &colorBg );
			gdk_gc_set_background( bgGc, &colorFg );
		}
	}
}

////////////////////////////////////////////////////////////////
// curses οֹ椫 GDK οѴ
// GdkColor *color : GDK ο
// int n : ֹ
////////////////////////////////////////////////////////////////

void CvColorRGB( GdkColor *color, int n )
{
	if( color == NULL )
		return;

	switch( n ){
	case COLOR_BLACK:
		color->red = 0x0000;
		color->green = 0x0000;
		color->blue = 0x0000;
		break;
	case COLOR_RED:
		color->red = 0xffff;
		color->green = 0x0000;
		color->blue = 0x0000;
		break;
	case COLOR_GREEN:
		color->red = 0x0000;
		color->green = 0xffff;
		color->blue = 0x0000;
		break;
	case COLOR_YELLOW:
		color->red = 0xffff;
		color->green = 0xffff;
		color->blue = 0x0000;
		break;
	case COLOR_BLUE:
		color->red = 0x0000;
		color->green = 0x0000;
		color->blue = 0xffff;
		break;
	case COLOR_MAGENTA:
		color->red = 0xffff;
		color->green = 0x0000;
		color->blue = 0xffff;
		break;
	case COLOR_CYAN:
		color->red = 0x0000;
		color->green = 0xffff;
		color->blue = 0xffff;
		break;
	case COLOR_WHITE:
		color->red = 0xffff;
		color->green = 0xffff;
		color->blue = 0xffff;
		break;
	}
}

////////////////////////////////////////////////////////////////
// ʿꤹ
// GdkGC *gc : ꤹ륰եåƥ
// long r : 
// long g : 
// long b : 
////////////////////////////////////////////////////////////////

void SetFgColor( GdkGC *gc, long r, long g, long b )
{
	GdkColor color;
	color.red = r;
	color.green = g;
	color.blue = b;

	gdk_color_alloc( gdk_colormap_get_system(), &color );
	gdk_gc_set_foreground( gc, &color );
}

////////////////////////////////////////////////////////////////
// طʿꤹ
// GdkGC *gc : ꤹ륰եåƥ
// long r : 
// long g : 
// long b : 
////////////////////////////////////////////////////////////////

void SetBgColor( GdkGC *gc, long r, long g, long b )
{
	GdkColor color;
	color.red = r;
	color.green = g;
	color.blue = b;

	gdk_color_alloc( gdk_colormap_get_system(), &color );
	gdk_gc_set_background( gc, &color );
}

////////////////////////////////////////////////////////////////
// ܥΥ٥֤
// GtkButton *btn : ܥ
// const char *str : ƥȤꤹʸ
////////////////////////////////////////////////////////////////

GtkLabel *get_label_from_button( GtkButton *btn )
{
	if( btn == NULL )
		return NULL;

	GList *ls = gtk_container_children( GTK_CONTAINER( btn ) );
	if( ls == NULL )
		return NULL;

	GList *p = g_list_nth( ls, 0 );
	if( p == NULL )
		return NULL;

	GtkLabel *label = GTK_LABEL( p->data );
	if( label == NULL )
		return NULL;

	return label;
}

////////////////////////////////////////////////////////////////
// ܥΥƥȤꤹ
// GtkButton *btn : ܥ
// const char *str : ƥȤꤹʸ
// double HAlignment : ƥȤοʿ 0.0  1.0 δ
// double VAlignment : ƥȤοľ 0.0  1.0 δ
////////////////////////////////////////////////////////////////

void set_label_text_button(
	GtkButton *btn, const char *str,
	double HAlignment, double VAlignment
)
{
	if( btn == NULL )
		return;

	GList *ls = gtk_container_children(
			GTK_CONTAINER( btn ) );
	if( ls == NULL )
		return;

	GList *p = g_list_nth( ls, 0 );
	if( p == NULL )
		return;

	GtkLabel *label = GTK_LABEL( p->data );
	if( label == NULL )
		return;

	gtk_misc_set_alignment( GTK_MISC( label ), HAlignment, VAlignment );
	if( str == NULL )
		gtk_label_set_text( label, "" );
	else
		gtk_label_set_text( label, str );
}
