/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: GuiNum.cpp,v 1.5 2007/02/26 00:50:37 bowkenken Exp $
***************************************************************/

////////////////////////////////////////////////////////////////
// ϥɥ
////////////////////////////////////////////////////////////////

#include "GuiNum.h"
#include "GlobalVar.h"

////////////////////////////////////////////////////////////////
// ٥ȡϥɥ
////////////////////////////////////////////////////////////////

void handle_num_destroy( GtkWidget *widget, gpointer user_data );
gint handle_num_expose( GtkWidget *widget, GdkEventExpose *event );

void handle_num_hscale_changed( GtkAdjustment *adj, gpointer user_data );

void handle_num_spin_changed( GtkAdjustment *adj, gpointer user_data );

void handle_num_0_clicked( GtkButton *button, gpointer user_data );
void handle_num_up_clicked( GtkButton *button, gpointer user_data );
void handle_num_down_clicked( GtkButton *button, gpointer user_data );

void handle_num_ok_clicked( GtkButton *button, gpointer user_data );

////////////////////////////////////////////////////////////////
// ϥɥν
////////////////////////////////////////////////////////////////

void GuiNum::init()
{
	newWin();
}

////////////////////////////////////////////////////////////////
// ϥɥκ
////////////////////////////////////////////////////////////////

void GuiNum::newWin()
{
	if( mNumWin != NULL )
		return;

#ifdef D_WS
	mNumWin = (void *)1;
#endif // D_WS

#ifdef D_GTK
	// ϥɥκ

	mNumWin = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	if( mNumWin == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_window_new()" );
		return;
	}
	gtk_window_set_title( GTK_WINDOW( mNumWin ),
			"Input number" );

	// ϥɥؤΥ٥ȡϥɥ

	gtk_signal_connect( GTK_OBJECT( mNumWin ),
			"destroy",
			GTK_SIGNAL_FUNC( handle_num_destroy ),
			this );

	//

	GtkWidget *hBoxWin = gtk_hbox_new( FALSE, 0 );
	if( hBoxWin == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_hbox_new()" );
		return;
	}
	gtk_widget_show( hBoxWin );

	GtkWidget *vBoxWin = gtk_vbox_new( FALSE, 0 );
	if( vBoxWin == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_vbox_new()" );
		return;
	}
	gtk_widget_show( vBoxWin );

	// ʿĴκ

	mHscaleAdjustment = gtk_adjustment_new(
			0, -100, +(100 + 10),
			+1, +10, 10 );
	if( mHscaleAdjustment == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_adjustment_new()" );
		return;
	}

	// ʿĴؤΥ٥ȡϥɥ

	gtk_signal_connect( GTK_OBJECT( mHscaleAdjustment ),
			"changed",
			GTK_SIGNAL_FUNC( handle_num_hscale_changed ),
			(gpointer)0 );
	gtk_signal_connect( GTK_OBJECT( mHscaleAdjustment ),
			"value-changed",
			GTK_SIGNAL_FUNC( handle_num_hscale_changed ),
			(gpointer)0 );

	// ʿκ

	mHscale = gtk_hscale_new(
			GTK_ADJUSTMENT( mHscaleAdjustment ) );
	if(mHscale  == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_hscale_new()" );
		return;
	}
	gtk_box_pack_start( GTK_BOX( vBoxWin ), mHscale,
			TRUE, TRUE, TRUE );
	gtk_widget_show( mHscale );

	// ԥ󡦥ܥĴ

	mNumAdjustment = gtk_adjustment_new(
			0, -100, +100,
			+1, +10, 10 );
	if( mNumAdjustment == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_adjustment_new()" );
		return;
	}

	// ԥ󡦥ܥĴؤΥ٥ȡϥɥ

	gtk_signal_connect( GTK_OBJECT( mNumAdjustment ),
			"changed",
			GTK_SIGNAL_FUNC( handle_num_spin_changed ),
			(gpointer)0 );
	gtk_signal_connect( GTK_OBJECT( mNumAdjustment ),
			"value-changed",
			GTK_SIGNAL_FUNC( handle_num_spin_changed ),
			(gpointer)0 );

	// ԥ󡦥ܥκ

	mNumSpin = gtk_spin_button_new(
			GTK_ADJUSTMENT( mNumAdjustment ), 1.0, 0 );
	if( mNumSpin == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_spin_button_new()" );
		return;
	}
	gtk_box_pack_start( GTK_BOX( vBoxWin ), mNumSpin,
			TRUE, TRUE, TRUE );
	gtk_widget_show( mNumSpin );

	// ܥκ

	GtkWidget *vBox[10];

	GtkWidget *hBox = gtk_hbox_new( FALSE, 0 );
	if( hBox == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_hbox_new()" );
		return;
	}
	gtk_widget_show( hBox );

	for( long i = 0; i < GUI_NUM_BUTTON_MAX_N; i++ ){
		bool flagComma = ((i % 4) == 3);

		// κ

		if( flagComma )
			mButtonLabel[i] = gtk_button_new_with_label( "," );
		else
			mButtonLabel[i] = gtk_button_new_with_label( "0" );
		if( mButtonLabel[i] == NULL ){
			print_msg( FLG_MSG_ERR,
					"gtk_button_new_with_label()" );
			return;
		}
		gtk_widget_show( mButtonLabel[i] );

		// κ

		mArrowUp[i] = gtk_arrow_new(
				GTK_ARROW_UP, GTK_SHADOW_ETCHED_OUT );
		if( mArrowUp[i] == NULL ){
			print_msg( FLG_MSG_ERR, "gtk_arrow_new()" );
			return;
		}
		gtk_widget_show( mArrowUp[i] );

		// ܥκ

		mButtonUp[i] = gtk_button_new();
		if( mButtonUp[i] == NULL ){
			print_msg( FLG_MSG_ERR, "gtk_button_new()" );
			return;
		}
		gtk_container_add( GTK_CONTAINER( mButtonUp[i] ),
				mArrowUp[i] );
		gtk_widget_show( mButtonUp[i] );

		// κ

		mArrowDown[i] = gtk_arrow_new(
				GTK_ARROW_DOWN, GTK_SHADOW_OUT );
		if( mArrowDown[i] == NULL ){
			print_msg( FLG_MSG_ERR, "gtk_arrow_new()" );
			return;
		}
		gtk_widget_show( mArrowDown[i] );

		// ܥκ

		mButtonDown[i] = gtk_button_new();
		if( mButtonDown[i]  == NULL ){
			print_msg( FLG_MSG_ERR, "gtk_button_new()" );
			return;
		}
		gtk_container_add( GTK_CONTAINER( mButtonDown[i] ),
				mArrowDown[i] );
		gtk_widget_show( mButtonDown[i] );

		// ܥؤΥ٥ȡϥɥ

		GtkLabel *lbl = get_label_from_button(
				GTK_BUTTON( mButtonLabel[i] ) );
		if( flagComma )
			lbl = NULL;

		gtk_signal_connect( GTK_OBJECT( mButtonLabel[i] ),
				"clicked",
				GTK_SIGNAL_FUNC( handle_num_0_clicked ),
				(gpointer)lbl );

		gtk_signal_connect( GTK_OBJECT( mButtonUp[i] ),
				"clicked",
				GTK_SIGNAL_FUNC( handle_num_up_clicked ),
				(gpointer)lbl );

		gtk_signal_connect( GTK_OBJECT( mButtonDown[i] ),
				"clicked",
				GTK_SIGNAL_FUNC( handle_num_down_clicked ),
				(gpointer)lbl );

		// ܥåˤΤ

		vBox[i] = gtk_vbox_new( FALSE, 0 );
		if( vBox[i] == NULL ){
			print_msg( FLG_MSG_ERR, "gtk_vbox_new()" );
			return;
		}
		gtk_widget_show( vBox[i] );

		gtk_container_add( GTK_CONTAINER( vBox[i] ),
				mButtonLabel[i] );
		gtk_container_add( GTK_CONTAINER( vBox[i] ),
				mButtonUp[i] );
		gtk_container_add( GTK_CONTAINER( vBox[i] ),
				mButtonDown[i] );

		gtk_box_pack_end( GTK_BOX( hBox ), vBox[i],
				TRUE, TRUE, TRUE );
	}

	gtk_box_pack_start( GTK_BOX( vBoxWin ), hBox,
			TRUE, TRUE, TRUE );

	// Ǿܥκ

	mButtonMin = gtk_button_new_with_label( "Min" );
	if( mButtonMin == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_button_new_with_label()" );
		return;
	}
	gtk_widget_show( mButtonMin );

	// ꥢܥκ

	mButtonClear = gtk_button_new_with_label( "Clear" );
	if( mButtonClear == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_button_new_with_label()" );
		return;
	}
	gtk_widget_show( mButtonClear );

	// ܥκ

	mButtonMax = gtk_button_new_with_label( "Max" );
	if( mButtonMax == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_button_new_with_label()" );
		return;
	}
	gtk_widget_show( mButtonMax );

	// OK ܥκ

	mButtonOk = gtk_button_new_with_label( "Ok" );
	if( mButtonOk == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_button_new_with_label()" );
		return;
	}
	gtk_widget_show( mButtonOk );

	// ǾܥؤΥ٥ȡϥɥ

	gtk_signal_connect( GTK_OBJECT( mButtonMin ),
			"clicked",
			GTK_SIGNAL_FUNC( handle_num_ok_clicked ),
			(gpointer)MENU_NUM_MIN );
	gtk_signal_connect( GTK_OBJECT( mButtonClear ),
			"clicked",
			GTK_SIGNAL_FUNC( handle_num_ok_clicked ),
			(gpointer)MENU_NUM_CLR );
	gtk_signal_connect( GTK_OBJECT( mButtonMax ),
			"clicked",
			GTK_SIGNAL_FUNC( handle_num_ok_clicked ),
			(gpointer)MENU_NUM_MAX );
	gtk_signal_connect( GTK_OBJECT( mButtonOk ),
			"clicked",
			GTK_SIGNAL_FUNC( handle_num_ok_clicked ),
			(gpointer)MENU_NUM_OK );

	// ܥåˤΤ

	GtkWidget *vBoxOk = gtk_vbox_new( FALSE, 0 );
	if( vBoxOk == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_vbox_new()" );
		return;
	}

	gtk_box_pack_start( GTK_BOX( vBoxOk ), mButtonMin,
			TRUE, TRUE, TRUE );
	gtk_box_pack_start( GTK_BOX( vBoxOk ), mButtonClear,
			TRUE, TRUE, TRUE );
	gtk_box_pack_start( GTK_BOX( vBoxOk ), mButtonMax,
			TRUE, TRUE, TRUE );
	gtk_box_pack_start( GTK_BOX( vBoxOk ), mButtonOk,
			TRUE, TRUE, TRUE );

	gtk_widget_show( vBoxOk );

	// ܥåˤΤ

	gtk_box_pack_start( GTK_BOX( hBoxWin ), vBoxWin,
			TRUE, TRUE, TRUE );
	gtk_box_pack_start( GTK_BOX( hBoxWin ), vBoxOk,
			TRUE, TRUE, TRUE );

	gtk_container_add( GTK_CONTAINER( mNumWin ), hBoxWin );

	//

	gtk_widget_show( mNumWin );
#endif	// D_GTK
}

////////////////////////////////////////////////////////////////
// ϥɥκ
////////////////////////////////////////////////////////////////

void GuiNum::destroy()
{
#ifdef D_GTK
	mNumWin = NULL;
#endif // D_GTK
}

////////////////////////////////////////////////////////////////
// ϥɥɽ
////////////////////////////////////////////////////////////////

void GuiNum::draw( long *n, long min, long max, long figure )
{
	if( n == NULL )
		return;

	newWin();

	mN = *n;
	mPN = n;
	mMin = min;
	mMax = max;
	mFigure = figure;

	redraw();
}

////////////////////////////////////////////////////////////////
// ϥɥκɽ
////////////////////////////////////////////////////////////////

void GuiNum::redraw()
{
	newWin();

#ifdef D_GTK
	GtkAdjustment *adj;

	adj = GTK_ADJUSTMENT( mHscaleAdjustment );
	if( adj->value != mN ){
		long incPage = 1;

		adj->value = mN;
		adj->lower = mMin;
		adj->upper = mMax + incPage;
		adj->step_increment = 1;
		adj->page_increment = incPage;
		adj->page_size = incPage;

		gtk_adjustment_value_changed( adj );
	}

	adj = GTK_ADJUSTMENT( mNumAdjustment );
	if( adj->value != mN ){
		long incPage = 1;

		adj->value = mN;
		adj->lower = mMin;
		adj->upper = mMax + incPage;
		adj->step_increment = 1;
		adj->page_increment = incPage;
		adj->page_size = incPage;

		gtk_adjustment_value_changed( adj );
	}

	cvUpDownFromN();
	gtk_widget_show( mNumWin );
#endif // D_GTK
}

////////////////////////////////////////////////////////////////
// ϥɥĤ
////////////////////////////////////////////////////////////////

void GuiNum::wipe()
{
#ifdef D_GTK
	gtk_widget_hide( mNumWin );
#endif // D_GTK
}

////////////////////////////////////////////////////////////////
// ʿȥԥ󡦥ܥĴѲν
////////////////////////////////////////////////////////////////

void GuiNum::valueChanged( long n )
{
	mN = n;

	redraw();
}

////////////////////////////////////////////////////////////////
// ٥οͤ
// void *lbl : ٥
// long d : +1, -1 ξ0 ξ 0 ꥢ
////////////////////////////////////////////////////////////////


void GuiNum::up_down_num_label( void *lbl, long d )
{
	if( lbl == NULL )
		return;

	char *str = NULL;
#ifdef D_WS
#endif // D_WS
#ifdef D_GTK
	gtk_label_get( GTK_LABEL( lbl ), &str );
#endif // D_GTK
	if( str == NULL )
		return;

	char c = str[0];
	c = up_down_num_char( c, d );

	char num[1 + 1] = "";
	num[0] = c;
	num[1] = '\0';

#ifdef D_WS
#endif // D_WS
#ifdef D_GTK
	gtk_label_set_text( GTK_LABEL( lbl ), num );
#endif // D_GTK

	cvUpDownToN();
	redraw();
}

////////////////////////////////////////////////////////////////
// ʸ
// char c : ʸ
// long d : +1, -1 ξ0 ξ 0 ꥢ
// return : ʸ
////////////////////////////////////////////////////////////////

char GuiNum::up_down_num_char( char c, long d )
{
	if( c == '+' ){
		c = '-';
	} else if( c == '-' ){
		c = '+';
	} else if( isdigit( c ) ){
		if( d == +-0 ){
			c = '0';
		} else {
			long n = c - '0';
			n = (n + d + 10) % 10;
			c = n + '0';
		}
	} else {
		c = '0';
	}

	return c;
}

////////////////////////////////////////////////////////////////
// ܥͤѴ
////////////////////////////////////////////////////////////////

void GuiNum::cvUpDownToN()
{
	newWin();

	long n = 0;
	long f = 0;
	long base = 1;
	for( long i = 0; i < GUI_NUM_BUTTON_MAX_N; i++ ){
		if( f >= mFigure + 1 )
			break;
		if( (i % 4) == 3 )
			continue;
		else
			f++;

		char c;
		c = '0';

#ifdef D_GTK
		GtkLabel *lbl = get_label_from_button(
				GTK_BUTTON( mButtonLabel[i] ) );
		if( lbl == NULL )
			return;

		gchar *str = NULL;
		gtk_label_get( lbl, &str );
		if( str == NULL )
			return;
		c = str[0];
#endif // D_GTK

		if( c == '+' ){
			break;
		} else if( c == '-' ){
			n = -n;
			break;
		} else if( isdigit( c ) ){
			n += (c - '0') * base;
		}

		base *= 10;
	}

	mN = n;
}

////////////////////////////////////////////////////////////////
// ܥ˿ͤ
////////////////////////////////////////////////////////////////

void GuiNum::cvUpDownFromN()
{
	newWin();

#ifdef D_GTK
	gtk_widget_show( mNumWin );

	GtkLabel *lbl;
	gchar str[1 + 1]  = "";

	long n = labs( mN );
	long f = 0;
	long i = 0;
	for( ; i < GUI_NUM_BUTTON_MAX_N; i++ ){
		if( f >= mFigure )
			break;

		lbl = get_label_from_button(
				GTK_BUTTON( mButtonLabel[i] ) );
		if( lbl == NULL )
			continue;

		if( (i % 4) == 3 ){
			gtk_label_set_text( lbl, "," );
		} else {
			str[0] = '0' + (n % 10);
			str[1] = '\0';
			gtk_label_set_text( lbl, str );

			f++;
			n /= 10;
		}

		gtk_widget_show( mButtonLabel[i] );
		gtk_widget_show( mArrowUp[i] );
		gtk_widget_show( mButtonUp[i] );
		gtk_widget_show( mArrowDown[i] );
		gtk_widget_show( mButtonDown[i] );
	}

	if( i < GUI_NUM_BUTTON_MAX_N ){
		lbl = get_label_from_button(
				GTK_BUTTON( mButtonLabel[i] ) );
		if( lbl != NULL ){
			if( sgn_l( mN ) <= -1 )
				gtk_label_set_text( lbl, "-" );
			else
				gtk_label_set_text( lbl, "+" );

			gtk_widget_show( mButtonLabel[i] );
			gtk_widget_show( mArrowUp[i] );
			gtk_widget_show( mButtonUp[i] );
			gtk_widget_show( mArrowDown[i] );
			gtk_widget_show( mButtonDown[i] );

			i++;
		}
	}

	for( ; i < GUI_NUM_BUTTON_MAX_N; i++ ){
		lbl = get_label_from_button(
				GTK_BUTTON( mButtonLabel[i] ) );
		if( lbl == NULL )
			continue;
		gtk_label_set_text( lbl, "0" );

		gtk_widget_hide( mButtonLabel[i] );
		gtk_widget_hide( mArrowUp[i] );
		gtk_widget_hide( mButtonUp[i] );
		gtk_widget_hide( mArrowDown[i] );
		gtk_widget_hide( mButtonDown[i] );
	}
#endif // D_GTK
}

////////////////////////////////////////////////////////////////
// ǾܥΥåν
// menu_num_t n : ܥμ
////////////////////////////////////////////////////////////////

void GuiNum::okClicked( menu_num_t n )
{
	switch( n ){
	case MENU_NUM_MIN:
		mN = mMin;
		break;
	case MENU_NUM_CLR:
		mN = *mPN;
		break;
	case MENU_NUM_MAX:
		mN = mMax;
		break;
	case MENU_NUM_OK:
		*mPN = mN;
		gKey.setChar( '|' );
		wipe();
		break;
	case MENU_NUM_MAX_N:
		break;
	}

	redraw();
}

////////////////////////////////////////////////////////////////
// ϥɥνλΥϥɥ
////////////////////////////////////////////////////////////////

void handle_num_destroy( GtkWidget *widget, gpointer user_data )
{
	gGuiNum.destroy();
}

////////////////////////////////////////////////////////////////
// ϥɥ襤٥Ȥν
// GtkWidget *widget : åΥɥ󥰡ꥢ
// GdkEventExpose *event : ٥
// return : ?
////////////////////////////////////////////////////////////////

gint handle_num_expose( GtkWidget *widget, GdkEventExpose *event )
{
	gGuiNum.redraw();

	return TRUE;
}

////////////////////////////////////////////////////////////////
// ʿĴѲΥϥɥ
// GtkAdjustment *adj : ʿ
// gpointer user_data : ߡ
////////////////////////////////////////////////////////////////

void handle_num_hscale_changed( GtkAdjustment *adj, gpointer user_data )
{
#ifdef D_GTK
	if( adj == NULL )
		return;

	gGuiNum.valueChanged( (long)(adj->value) );
#endif // D_GTK
}

////////////////////////////////////////////////////////////////
// ԥ󡦥ܥĴѲΥϥɥ
// GtkAdjustment *adj : ʿ
// gpointer user_data : ߡ
////////////////////////////////////////////////////////////////

void handle_num_spin_changed( GtkAdjustment *adj, gpointer user_data )
{
#ifdef D_GTK
	if( adj == NULL )
		return;

	gGuiNum.valueChanged( (long)(adj->value) );
#endif // D_GTK
}

////////////////////////////////////////////////////////////////
// ꥢܥΥåΥϥɥ
// GtkButton *button : ܥ
// gpointer user_data : ٥
////////////////////////////////////////////////////////////////

void handle_num_0_clicked( GtkButton *button, gpointer user_data )
{
	gGuiNum.up_down_num_label( user_data, +-0 );
}

////////////////////////////////////////////////////////////////
// ܥΥåΥϥɥ
// GtkButton *button : ܥ
// gpointer user_data : ٥
////////////////////////////////////////////////////////////////

void handle_num_up_clicked( GtkButton *button, gpointer user_data )
{
	gGuiNum.up_down_num_label( user_data, +1 );
}

////////////////////////////////////////////////////////////////
// ܥΥåΥϥɥ
// GtkButton *button : ܥ
// gpointer user_data : ٥
////////////////////////////////////////////////////////////////

void handle_num_down_clicked( GtkButton *button, gpointer user_data )
{
	gGuiNum.up_down_num_label( user_data, -1 );
}

////////////////////////////////////////////////////////////////
// ǾܥΥåΥϥɥ
// GtkButton *button : ܥ
// gpointer user_data : ܥμ
////////////////////////////////////////////////////////////////

void handle_num_ok_clicked( GtkButton *button, gpointer user_data )
{
	gGuiNum.okClicked( (menu_num_t)(int)user_data );
}
