/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: GuiStat.cpp,v 1.5 2007/02/28 15:21:47 bowkenken Exp $
***************************************************************/

#include	"gmain.h"
#include	"misc.h"
//#include	"turn.h"
//#include	"dun.h"
//#include	"town.h"
//#include	"item.h"
//#include	"spell.h"
//#include	"chr.h"
#include	"party.h"
//#include	"mnstr.h"
//#include	"pet.h"
//#include	"fight.h"
//#include	"fx.h"
//#include	"trap.h"
#include	"draw.h"
//#include	"curs.h"
//#include	"menu.h"
//#include	"amenu.h"
//#include	"request.h"
//#include	"gfile.h"
#include	"msg.h"
//#include	"ver.h"
#include	"gmain-prot.h"
#include	"misc-prot.h"
//#include	"turn-prot.h"
//#include	"dun-prot.h"
//#include	"town-prot.h"
//#include	"item-prot.h"
//#include	"spell-prot.h"
//#include	"chr-prot.h"
#include	"party-prot.h"
//#include	"mnstr-prot.h"
//#include	"pet-prot.h"
//#include	"fight-prot.h"
//#include	"fx-prot.h"
//#include	"trap-prot.h"
#include	"draw-prot.h"
//#include	"curs-prot.h"
//#include	"menu-prot.h"
//#include	"tmenu-prot.h"
//#include	"amenu-prot.h"
//#include	"request-prot.h"
//#include	"gfile-prot.h"
//#include	"msg-prot.h"

////////////////////////////////////////////////////////////////

# include <gtk/gtk.h>
# include <gdk/gdk.h>

#include "GuiStat.h"
#include "GlobalVar.h"

#include "main-gtk-prot.h"

////////////////////////////////////////////////////////////////

#define	STR_GUI_STAT_HP	"HP: %4ld/%4ld"
#define	STR_GUI_STAT_MP	"MP: %4ld/%4ld"

#define	GUI_STAT_HP_MP_X	4
#define	GUI_STAT_HP_MP_Y	8
#define	GUI_STAT_HP_MP_WIDTH	128
#define	GUI_STAT_HP_MP_HEIGHT	2
#define	GUI_STAT_HP_MP_MAX_WIDTH	\
		(GUI_STAT_HP_MP_X * 2 + GUI_STAT_HP_MP_WIDTH)
#define	GUI_STAT_HP_MP_MAX_HEIGHT	16

////////////////////////////////////////////////////////////////

void handle_stat_win_destroy(
	GtkWidget *widget, gpointer data
);
gint handle_stat_win_expose(
	GtkWidget *widget, GdkEventExpose *event
);
gint handle_stat_win_configure(
	GtkWidget *widget, GdkEventConfigure *event
);

void handle_stat_name_clicked(
	GtkWidget *widget, gpointer data
);
void handle_stat_stat_clicked(
	GtkWidget *widget, gpointer data
);

////////////////////////////////////////////////////////////////
// ơν
////////////////////////////////////////////////////////////////

void GuiStat::init()
{
	newWin();
	redraw();
}

////////////////////////////////////////////////////////////////
// ơɥκ
////////////////////////////////////////////////////////////////

void GuiStat::newWin()
{
	if( mStatWin != NULL )
		return;

	// ơɥκ

	mStatWin = gtk_window_new( GTK_WINDOW_TOPLEVEL );
	if( mStatWin == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_window_new()" );
		return;
	}
	gtk_window_set_title( GTK_WINDOW( mStatWin ),
			"Stat" );

	// ơɥؤΥ٥ȡϥɥ

	gtk_signal_connect( GTK_OBJECT( mStatWin ),
			"destroy",
			GTK_SIGNAL_FUNC( handle_stat_win_destroy ),
			this );
	gtk_signal_connect( GTK_OBJECT( mStatWin ),
			"expose_event",
			GTK_SIGNAL_FUNC( handle_stat_win_expose ),
			this );
	gtk_signal_connect( GTK_OBJECT( mStatWin ),
			"configure_event",
			GTK_SIGNAL_FUNC( handle_stat_win_configure ),
			this );

	// ľܥåκ

	vBox = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( mStatWin ), vBox );
	gtk_widget_show( vBox );

	// ƥС

	party_t *pty = get_party();
	for( long i = 0; i < MBR_MAX_N; i++ )
		newWinMbr( pty->mbr[i], vBox );

	//

	gtk_widget_show( mStatWin );
}

////////////////////////////////////////////////////////////////
// ơɥγƥС
// mbr_t *mbr : С
// GtkWidget *vBox : 
////////////////////////////////////////////////////////////////

void GuiStat::newWinMbr( mbr_t *mbr, GtkWidget *vBox )
{
	if( mbr == NULL )
		return;
	if( vBox == NULL )
		return;

	long n = mbr->mbr_n;

	// ġ롦С

	GtkWidget *handleBox = gtk_handle_box_new();
	gtk_box_pack_start( GTK_BOX( vBox ), handleBox, FALSE, FALSE, 0 );
	gtk_widget_show( handleBox );

	GtkWidget *toolBar = gtk_toolbar_new();
	gtk_toolbar_set_orientation( GTK_TOOLBAR( toolBar ),
			GTK_ORIENTATION_HORIZONTAL );
	gtk_toolbar_set_style( GTK_TOOLBAR( toolBar ),
			GTK_TOOLBAR_ICONS );
	gtk_widget_show( toolBar );

	gtk_container_add( GTK_CONTAINER( handleBox ), toolBar );

	GtkWidget *vBox2 = gtk_vbox_new( FALSE, 0 );
	gtk_container_add( GTK_CONTAINER( toolBar ), vBox2 );
	gtk_widget_show( vBox2 );

	// ơܥκ

	WSCstring sName, sAct, sStat, sHp, sMp;
	long nHp, nMp, nMaxHp, nMaxMp;
	char buf[127 + 1];

	sprintf( buf, "%*c", MBR_NAME_MAX_LEN, ' ' );
	sName = buf;

	sprintf( buf, "%*c", ACT_MSG_MAX_LEN, ' ' );
	sAct = buf;

	sprintf( buf, "%*c", WIN_STAT_DRAW_WIDTH, ' ' );
	sStat = buf;

	nHp = 0;
	nMp = 0;
	nMaxHp = 0;
	nMaxMp = 0;

	char bufHp[31 + 1];
	char bufMp[31 + 1];
	sprintf( bufHp, STR_GUI_STAT_HP, nHp, nMaxHp );
	sprintf( bufMp, STR_GUI_STAT_MP, nMp, nMaxMp );
	sHp = bufHp;
	sMp = bufMp;

	btnName[n] = gtk_button_new_with_label( sName );
	labelAct[n] = gtk_label_new( sAct );
	btnStat[n] = gtk_button_new_with_label( sStat );
	labelHp[n] = gtk_label_new( sHp );
	labelMp[n] = gtk_label_new( sMp );

	gtk_widget_show( btnName[n] );
	gtk_widget_show( labelAct[n] );
	gtk_widget_show( btnStat[n] );
	gtk_widget_show( labelHp[n] );
	gtk_widget_show( labelMp[n] );

	GtkWidget *hBox1 = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( hBox1 ), btnName[n], FALSE, FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( hBox1 ), labelAct[n], FALSE, FALSE, 0 );
	gtk_widget_show( hBox1 );

	// 襨ꥢ HP

	mDrawingAreaHp[n] = gtk_drawing_area_new();
	if( mDrawingAreaHp[n] == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_drawing_area_new()" );
		return;
	}
	gtk_drawing_area_size( GTK_DRAWING_AREA( mDrawingAreaHp[n] ),
			GUI_STAT_HP_MP_MAX_WIDTH,
			GUI_STAT_HP_MP_MAX_HEIGHT );
	gtk_widget_show( mDrawingAreaHp[n] );

	// 襨ꥢ MP

	mDrawingAreaMp[n] = gtk_drawing_area_new();
	if( mDrawingAreaMp[n] == NULL ){
		print_msg( FLG_MSG_ERR, "gtk_drawing_area_new()" );
		return;
	}
	gtk_drawing_area_size( GTK_DRAWING_AREA( mDrawingAreaMp[n] ),
			GUI_STAT_HP_MP_MAX_WIDTH,
			GUI_STAT_HP_MP_MAX_HEIGHT );
	gtk_widget_show( mDrawingAreaMp[n] );

	// HP

	hBoxHp[n] = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( hBoxHp[n] ), labelHp[n],
			FALSE, FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( hBoxHp[n] ), mDrawingAreaHp[n],
			FALSE, FALSE, 0 );
	gtk_widget_show( hBoxHp[n] );

	// MP

	hBoxMp[n] = gtk_hbox_new( FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( hBoxMp[n] ), labelMp[n],
			FALSE, FALSE, 0 );
	gtk_box_pack_start( GTK_BOX( hBoxMp[n] ), mDrawingAreaMp[n],
			FALSE, FALSE, 0 );
	gtk_widget_show( hBoxMp[n] );

	//

	gtk_box_pack_start( GTK_BOX( vBox2 ), hBox1, FALSE, TRUE, 0 );
	gtk_box_pack_start( GTK_BOX( vBox2 ), btnStat[n], FALSE, TRUE, 0 );
	gtk_box_pack_start( GTK_BOX( vBox2 ), hBoxHp[n], FALSE, TRUE, 0 );
	gtk_box_pack_start( GTK_BOX( vBox2 ), hBoxMp[n], FALSE, TRUE, 0 );

	// ơܥؤΥ٥ȡϥɥ

	gtk_signal_connect( GTK_OBJECT( btnName[n] ),
			"clicked",
			GTK_SIGNAL_FUNC( handle_stat_name_clicked ),
			(gpointer)n );
	gtk_signal_connect( GTK_OBJECT( btnStat[n] ),
			"clicked",
			GTK_SIGNAL_FUNC( handle_stat_stat_clicked ),
			(gpointer)n );
}

////////////////////////////////////////////////////////////////
// ơɥκ
////////////////////////////////////////////////////////////////

void GuiStat::destroy()
{
	for( long i = 0; i < MBR_MAX_N; i++ ){
		gtk_widget_destroy( btnName[i] );
		gtk_widget_destroy( labelAct[i] );
		gtk_widget_destroy( btnStat[i] );
		gtk_widget_destroy( labelHp[i] );
		gtk_widget_destroy( labelMp[i] );

		btnName[i] = NULL;
		labelAct[i] = NULL;
		btnStat[i] = NULL;
		labelHp[i] = NULL;
		labelMp[i] = NULL;
	}

	gtk_widget_destroy( vBox );

	mStatWin = NULL;
}

////////////////////////////////////////////////////////////////
// ơɥɽ
// long mbrN : Сֹ
////////////////////////////////////////////////////////////////

void GuiStat::redraw()
{
	for( long i = 0; i < MBR_MAX_N; i++ )
		draw( i );

	g_object_set( GTK_WINDOW( mStatWin ),
			"allow-shrink", FALSE,
			"allow-grow", FALSE,
			NULL );
}

////////////////////////////////////////////////////////////////
// ơɥγƥСɽ
// long mbrN : Сֹ
////////////////////////////////////////////////////////////////

void GuiStat::draw( long n )
{
	newWin();

	party_t *pty = get_party();
	mbr_t *mbr = pty->mbr[n];

	WSCstring sName, sAct, sStat, sHp, sMp;
	long nHp, nMp, nMaxHp, nMaxMp;

	if( (mbr == NULL) || chk_flg( mbr->stat, FLG_STAT_NOT_EXIST ) ){
		sName = "";
		sAct = "";
		sStat = "";
		nHp = 0;
		nMp = 0;
		nMaxHp = 0;
		nMaxMp = 0;
	} else {
		sName = mbr->name;
		sAct = mbr->act.msg;
		sStat = "";
		nHp = mbr->abl.hp.n;
		nMp = mbr->abl.mp.n;
		nMaxHp = mbr->abl.hp.max;
		nMaxMp = mbr->abl.mp.max;
	}

	char bufHp[31 + 1];
	char bufMp[31 + 1];
	sprintf( bufHp, STR_GUI_STAT_HP, nHp, nMaxHp );
	sprintf( bufMp, STR_GUI_STAT_MP, nMp, nMaxMp );
	sHp = bufHp;
	sMp = bufMp;

	// ٥

	set_label_text_button( GTK_BUTTON( btnName[n] ),
			sName, 0.5, 0.5 );

	gtk_misc_set_alignment( GTK_MISC( labelAct[n] ), 0.0, 0.5 );
	gtk_label_set_text( GTK_LABEL( labelAct[n] ), (char *)sAct );

	set_label_text_button( GTK_BUTTON( btnStat[n] ),
			sStat, 0.5, 0.5 );

	gtk_misc_set_alignment( GTK_MISC( labelHp[n] ), 0.0, 0.5 );
	gtk_label_set_text( GTK_LABEL( labelHp[n] ), (char *)sHp );

	gtk_misc_set_alignment( GTK_MISC( labelMp[n] ), 0.0, 0.5 );
	gtk_label_set_text( GTK_LABEL( labelMp[n] ), (char *)sMp );

	// HP, MP

	if( mDrawingAreaHp[n]->window == NULL)
		return;
	if( mDrawingAreaMp[n]->window == NULL)
		return;

	if( mFgGcHp[n] == NULL )
		mFgGcHp[n] = gdk_gc_new( mDrawingAreaHp[n]->window );
	if( mBgGcHp[n] == NULL )
		mBgGcHp[n] = gdk_gc_new( mDrawingAreaHp[n]->window );
	GdkDrawable *gdHp = GDK_DRAWABLE( mDrawingAreaHp[n]->window );

	if( mFgGcMp[n] == NULL )
		mFgGcMp[n] = gdk_gc_new( mDrawingAreaMp[n]->window );
	if( mBgGcMp[n] == NULL )
		mBgGcMp[n] = gdk_gc_new( mDrawingAreaMp[n]->window );
	GdkDrawable *gdMp = GDK_DRAWABLE( mDrawingAreaMp[n]->window );

	//

	GdkColor colorFg1;
	GdkColor colorFg2;
	GdkColor colorFg3;
	GdkColor colorBg;
	long maxW = 1;
	long w = 1;

	// HP

	rate_t nHpRate = 0;

	if( nMaxHp > 0 ){
		nHpRate = nHp * 100;
		nHpRate /= nMaxHp;

		colorBg.red = 0x0000;
		colorBg.green = 0x0000;
		colorBg.blue = 0x0000;
	} else {
		nHpRate = 0;

		colorBg.red = 0x8888;
		colorBg.green = 0x8888;
		colorBg.blue = 0x8888;
	}

	if( nHpRate <= WARNING_HP_RATE_RED ){
		colorFg1.red = 0xeeee;
		colorFg1.green = 0x0000;
		colorFg1.blue = 0x0000;

		colorFg2.red = 0xcccc;
		colorFg2.green = 0x0000;
		colorFg2.blue = 0x0000;

		colorFg3.red = 0xaaaa;
		colorFg3.green = 0x0000;
		colorFg3.blue = 0x0000;
	} else if( nHpRate <= WARNING_HP_RATE_YELLOW ){
		colorFg1.red = 0xaaaa;
		colorFg1.green = 0xaaaa;
		colorFg1.blue = 0x0000;

		colorFg2.red = 0x8888;
		colorFg2.green = 0x8888;
		colorFg2.blue = 0x0000;

		colorFg3.red = 0x6666;
		colorFg3.green = 0x6666;
		colorFg3.blue = 0x0000;
	} else if( nHpRate <= WARNING_HP_RATE_GREEN ){
		colorFg1.red = 0x0000;
		colorFg1.green = 0xcccc;
		colorFg1.blue = 0x0000;

		colorFg2.red = 0x0000;
		colorFg2.green = 0xaaaa;
		colorFg2.blue = 0x0000;

		colorFg3.red = 0x0000;
		colorFg3.green = 0x8888;
		colorFg3.blue = 0x0000;
	} else {
		colorFg1.red = 0xffff;
		colorFg1.green = 0xffff;
		colorFg1.blue = 0xffff;

		colorFg2.red = 0xffff;
		colorFg2.green = 0xffff;
		colorFg2.blue = 0xffff;

		colorFg3.red = 0xffff;
		colorFg3.green = 0xffff;
		colorFg3.blue = 0xffff;
	}

	gdk_color_alloc( gdk_colormap_get_system(), &colorBg );
	gdk_gc_set_background( mBgGcHp[n], &colorBg );

	maxW = 128;
	w = maxW * nHpRate / _100_PERCENT;

	gdk_color_alloc( gdk_colormap_get_system(), &colorBg );
	gdk_gc_set_foreground( mBgGcHp[n], &colorBg );
	gdk_draw_rectangle( gdHp, mBgGcHp[n], TRUE,
			GUI_STAT_HP_MP_X,
			GUI_STAT_HP_MP_Y,
			maxW,
			GUI_STAT_HP_MP_HEIGHT * 3 );

	gdk_color_alloc( gdk_colormap_get_system(), &colorFg1 );
	gdk_gc_set_foreground( mFgGcHp[n], &colorFg1 );
	gdk_draw_rectangle( gdHp, mFgGcHp[n], TRUE,
			GUI_STAT_HP_MP_X,
			GUI_STAT_HP_MP_Y,
			w,
			GUI_STAT_HP_MP_HEIGHT );

	gdk_color_alloc( gdk_colormap_get_system(), &colorFg2 );
	gdk_gc_set_foreground( mFgGcHp[n], &colorFg2 );
	gdk_draw_rectangle( gdHp, mFgGcHp[n], TRUE,
			GUI_STAT_HP_MP_X,
			GUI_STAT_HP_MP_Y + GUI_STAT_HP_MP_HEIGHT,
			w,
			GUI_STAT_HP_MP_HEIGHT );

	gdk_color_alloc( gdk_colormap_get_system(), &colorFg3 );
	gdk_gc_set_foreground( mFgGcHp[n], &colorFg3 );
	gdk_draw_rectangle( gdHp, mFgGcHp[n], TRUE,
			GUI_STAT_HP_MP_X,
			GUI_STAT_HP_MP_Y + GUI_STAT_HP_MP_HEIGHT * 2,
			w,
			GUI_STAT_HP_MP_HEIGHT );

	// MP

	rate_t nMpRate = 0;

	if( nMaxMp > 0 ){
		nMpRate = nMp * 100;
		nMpRate /= nMaxMp;

		colorBg.red = 0x0000;
		colorBg.green = 0x0000;
		colorBg.blue = 0x0000;
	} else {
		nMpRate = 0;

		colorBg.red = 0x8888;
		colorBg.green = 0x8888;
		colorBg.blue = 0x8888;
	}

	if( nMpRate <= WARNING_MP_RATE_RED ){
		colorFg1.red = 0xeeee;
		colorFg1.green = 0x0000;
		colorFg1.blue = 0x0000;

		colorFg2.red = 0xcccc;
		colorFg2.green = 0x0000;
		colorFg2.blue = 0x0000;

		colorFg3.red = 0xaaaa;
		colorFg3.green = 0x0000;
		colorFg3.blue = 0x0000;
	} else if( nMpRate <= WARNING_MP_RATE_YELLOW ){
		colorFg1.red = 0xaaaa;
		colorFg1.green = 0xaaaa;
		colorFg1.blue = 0x0000;

		colorFg2.red = 0x8888;
		colorFg2.green = 0x8888;
		colorFg2.blue = 0x0000;

		colorFg3.red = 0x6666;
		colorFg3.green = 0x6666;
		colorFg3.blue = 0x0000;
	} else if( nMpRate <= WARNING_MP_RATE_GREEN ){
		colorFg1.red = 0x0000;
		colorFg1.green = 0xcccc;
		colorFg1.blue = 0xcccc;

		colorFg2.red = 0x0000;
		colorFg2.green = 0xaaaa;
		colorFg2.blue = 0xaaaa;

		colorFg3.red = 0x0000;
		colorFg3.green = 0x8888;
		colorFg3.blue = 0x8888;
	} else {
		colorFg1.red = 0xffff;
		colorFg1.green = 0xffff;
		colorFg1.blue = 0xffff;

		colorFg2.red = 0xffff;
		colorFg2.green = 0xffff;
		colorFg2.blue = 0xffff;

		colorFg3.red = 0xffff;
		colorFg3.green = 0xffff;
		colorFg3.blue = 0xffff;
	}

	gdk_color_alloc( gdk_colormap_get_system(), &colorBg );
	gdk_gc_set_background( mBgGcMp[n], &colorBg );

	maxW = 128;
	w = maxW * nMpRate / _100_PERCENT;

	gdk_color_alloc( gdk_colormap_get_system(), &colorBg );
	gdk_gc_set_foreground( mBgGcMp[n], &colorBg );
	gdk_draw_rectangle( gdMp, mBgGcMp[n], TRUE,
			GUI_STAT_HP_MP_X,
			GUI_STAT_HP_MP_Y,
			maxW,
			GUI_STAT_HP_MP_HEIGHT * 3 );

	gdk_color_alloc( gdk_colormap_get_system(), &colorFg1 );
	gdk_gc_set_foreground( mFgGcMp[n], &colorFg1 );
	gdk_draw_rectangle( gdMp, mFgGcMp[n], TRUE,
			GUI_STAT_HP_MP_X,
			GUI_STAT_HP_MP_Y,
			w,
			GUI_STAT_HP_MP_HEIGHT );

	gdk_color_alloc( gdk_colormap_get_system(), &colorFg2 );
	gdk_gc_set_foreground( mFgGcMp[n], &colorFg2 );
	gdk_draw_rectangle( gdMp, mFgGcMp[n], TRUE,
			GUI_STAT_HP_MP_X,
			GUI_STAT_HP_MP_Y + GUI_STAT_HP_MP_HEIGHT,
			w,
			GUI_STAT_HP_MP_HEIGHT );

	gdk_color_alloc( gdk_colormap_get_system(), &colorFg3 );
	gdk_gc_set_foreground( mFgGcMp[n], &colorFg3 );
	gdk_draw_rectangle( gdMp, mFgGcMp[n], TRUE,
			GUI_STAT_HP_MP_X,
			GUI_STAT_HP_MP_Y + GUI_STAT_HP_MP_HEIGHT * 2,
			w,
			GUI_STAT_HP_MP_HEIGHT );
}

////////////////////////////////////////////////////////////////
// ơɥκΥ٥ȡϥɥ
// GtkWidget *widget : ơɥ
// gpointer data : ϿϤ줿
////////////////////////////////////////////////////////////////

void handle_stat_win_destroy(
	GtkWidget *widget, gpointer data
)
{
	if( data == NULL )
		return;

	((GuiStat *)data)->destroy();
}

////////////////////////////////////////////////////////////////
// ơɥ襤٥Ȥν
// GtkWidget *widget : åΥɥ󥰡ꥢ
// GdkEventExpose *event : ٥
// return : ?
////////////////////////////////////////////////////////////////

gint handle_stat_win_expose(
	GtkWidget *widget, GdkEventExpose *event
)
{
	gGuiStat.redraw();

	return true;
}

////////////////////////////////////////////////////////////////
// ơɥΥѹ٥Ȥν
// GtkWidget *widget : åΥɥ󥰡ꥢ
// GdkEventConfigure *event : ٥
// return : ?
////////////////////////////////////////////////////////////////

gint handle_stat_win_configure(
	GtkWidget *widget, GdkEventConfigure *event
)
{
	gGuiStat.redraw();

	return TRUE;
}

////////////////////////////////////////////////////////////////
// 饯̾ܥκå٥Ƚ
// GtkWidget *widget : ܥ
// gpointer data : ϿϤ줿ǡ
////////////////////////////////////////////////////////////////

void handle_stat_name_clicked(
	GtkWidget *widget, gpointer data
)
{
	long n = (long)data;

	char sCmdMbr[15 + 1];
	sCmdMbr[0] = 'A' + n;
	sCmdMbr[1] = '\0';

	WSCstring sCmd = "0000000000000000@";
	sCmd += sCmdMbr;
	sCmd += "^M";

	set_key_buf_str( sCmd );
	set_flg_break_key( TRUE );
}

////////////////////////////////////////////////////////////////
// 饯Υơܥκå٥Ƚ
// GtkWidget *widget : ܥ
// gpointer data : ϿϤ줿ǡ
////////////////////////////////////////////////////////////////

void handle_stat_stat_clicked(
	GtkWidget *widget, gpointer data
)
{
	long n = (long)data;

	char sCmdMbr[15 + 1];
	sCmdMbr[0] = 'A' + n;
	sCmdMbr[1] = '\0';

	WSCstring sCmd = "0000000000000000@";
	sCmd += sCmdMbr;
	sCmd += "d";

	set_key_buf_str( sCmd );
	set_flg_break_key( TRUE );
}
