/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: dun.c,v 1.99 2007/02/18 22:49:15 bowkenken Exp $
***************************************************************/

/***************************************************************
* µ
***************************************************************/

#define	DUN_C
#include	"inc.h"

/***************************************************************/

/* ϩ */
#define	PATH_WIDTH	3

/* ϩɽꥢμ */
#define	AREA_PATH	-1

/* Ψ */

/* ꥢˤʤΨ */
#define	RATE_ROOM	((rate_t)50)

/* ɥƤΨ */
#define	RATE_DOOR_OPEN	((rate_t)10)

/* ɥꤵƤΨ */
#define	RATE_DOOR_JAMMED	((rate_t)5)

/* ɥƤΨ */
#define	RATE_DOOR_BROKEN	((rate_t)1)

/* ϩƤΨ */
#define	RATE_HIDE_CROSS_PATH	((rate_t)80)

/**/

/* 곬ʤο */
#define	STAIRS_UP_MAX_N	2

/* 곬ʤο */
#define	STAIRS_DOWN_MAX_N	2

/* 겼ȽγʤޤǤεΥ */
#define	STAIRS_MAX_R	2

/* 󥹥ΥߥߥåȢǤʤΨ */
#define	MIMIC_RATE	50

/* ߤγؤƤ NPC ʿѿ */
#define	DUN_NPC_AVE_N	6

/* 1ֶᤤɥõƱΥˤȽǤΥ */
#define	DOOR_NEAR_R	4

/***************************************************************
* ѿ
***************************************************************/

static dun_t	dun;
static area_t	g_room_ptn_max_n, g_boss_room_ptn_max_n;

static crsr_ptn_t	g_crsr_ptn, g_crsr_ptn_usr[CRSR_PTN_MAX_N];
static crsr_ptn_t	g_sub_crsr_ptn;
static long	g_crsr_ptn_n, g_crsr_ptn_max_n;

static long	g_nest_flg_dun;

/***************************************************************
* ǡե
***************************************************************/

#include	"dun-tab.h"
#include	"crsr-ptn.h"

/***************************************************************
* µܤν
***************************************************************/

void	init_dun( void )
{
	long	i;

	g_nest_flg_dun = make_nest_flg();
	bgn_nest_flg( g_nest_flg_dun );

	reset_dun( FALSE );

	/* cursor */

	g_crsr_ptn_n = 0;

	if( load_crsr_ptn( g_crsr_ptn_usr, &g_crsr_ptn_max_n ) ){
		for( i = 0; i < g_crsr_ptn_max_n; i++ )
			set_crsr_ptn( &(g_crsr_ptn_usr[i]),
					&(g_crsr_ptn_usr[i]) );
	} else {
		g_crsr_ptn_max_n = sizeof( crsr_ptn_dflt )
				/ sizeof( crsr_ptn_dflt[0] );

		for( i = 0; i < g_crsr_ptn_max_n; i++ ){
			set_crsr_ptn( &(crsr_ptn_dflt[i]),
					&(crsr_ptn_dflt[i]) );
			g_crsr_ptn_usr[i] = crsr_ptn_dflt[i];
		}
	}

	reset_crsr_ptn();

	end_nest_flg( g_nest_flg_dun );
}

/***************************************************************
* 롦ѥκ֤
* return : 롦ѥκ
***************************************************************/

long	get_crsr_ptn_max_n( void )
{
	return g_crsr_ptn_max_n;
}

/***************************************************************
* 롦ѥκ
* long n : 롦ѥκ
* return : Υ롦ѥκ
***************************************************************/

long	set_crsr_ptn_max_n( long n )
{
	long	prev;

	prev = g_crsr_ptn_max_n;
	g_crsr_ptn_max_n = n;

	return prev;
}

/***************************************************************
* θߤΥѥ
* return : θߤΥѥ
***************************************************************/

long	get_crsr_ptn_n( void )
{
	return g_crsr_ptn_n;
}

/***************************************************************
* θߤΥѥֹ
* long n : 롦ѥֹ
* return : Υ롦ѥֹ
***************************************************************/

long	set_crsr_ptn_n( long n )
{
	long	prev;

	prev = g_crsr_ptn_n;
	g_crsr_ptn_n = n;

	return prev;
}

/***************************************************************
* 롦ѥꥻå
***************************************************************/

void	reset_crsr_ptn( void )
{
	long	sub_n;

	sub_n = (g_crsr_ptn_n + 1) % g_crsr_ptn_max_n;
	set_crsr_ptn( &g_crsr_ptn, &(g_crsr_ptn_usr[g_crsr_ptn_n]) );
	set_crsr_ptn( &g_sub_crsr_ptn, &(g_crsr_ptn_usr[sub_n]) );
}

/***************************************************************
* µܤꥻå
* bool_t flg_wall : ޥåפɤ뤫?
***************************************************************/

void	reset_dun( bool_t flg_wall )
{
	long	x, y;

	bgn_nest_flg( g_nest_flg_dun );

	for( y = 0; y < MAP_MAX_Y; y++ ){
		for( x = 0; x < MAP_MAX_X; x++ ){
			dun.map.sect[y][x] = 'z';

			if( flg_wall ){
				dun.map.obj.mjr[y][x] = FACE_MJR_WALL;
				dun.map.obj.mnr[y][x] = FACE_MNR_WALL;
				dun.map.obj.flg[y][x] = FLG_NULL;
			} else {
				dun.map.obj.mjr[y][x] = FACE_MJR_FLOOR;
				dun.map.obj.mnr[y][x] = FACE_MNR_FLOOR;
				dun.map.obj.flg[y][x] = FLG_MAP_OBJ_PASS;
			}

			dun.map.chr.mjr[y][x] = FACE_MJR_NULL;
			dun.map.chr.mnr[y][x] = FACE_MNR_NULL;
			dun.map.chr.flg[y][x] = FLG_NULL;

			dun.map.total.mjr[y][x] = dun.map.obj.mjr[y][x];
			dun.map.total.mnr[y][x] = dun.map.obj.mnr[y][x];
			dun.map.total.flg[y][x] = FLG_NULL;

			dun.map.light_depth_obj[y][x] = 0;
			dun.map.light_depth_chr[y][x] = 0;

			dun.map.chr_p[y][x] = NULL;
		}
	}

	for( y = 0; y < AREA_MAP_MAX_Y; y++ ){
		for( x = 0; x < AREA_MAP_MAX_X; x++ ){
			dun.area[y][x] = AREA_PATH;
		}
	}

	dun.door_n = 0;

	end_nest_flg( g_nest_flg_dun );
}

/***************************************************************
* 롦ѥ֤
* reutrn : 롦ѥ
***************************************************************/

crsr_ptn_t	*get_crsr_ptn( void )
{
	return &g_crsr_ptn;
}

/***************************************************************
* ֡롦ѥ֤
* reutrn : ֡롦ѥ
***************************************************************/

crsr_ptn_t	*get_sub_crsr_ptn( void )
{
	return &g_sub_crsr_ptn;
}

/***************************************************************
* 롦ѥ
* crsr_ptn_t *dst : ѥ
* crsr_ptn_t *src : ȸѥ
* reutrn : ꤬?
***************************************************************/

bool_t	set_crsr_ptn( crsr_ptn_t *dst, crsr_ptn_t *src )
{
	long	max_len;
	long	y;

	if( src == NULL )
		return FALSE;
	if( dst == NULL )
		return FALSE;

	*dst = *src;

	max_len = 0;
	for( y = 0; y < CRSR_PTN_MAX_Y_LEN; y++ ){
		long	len;

		if( dst->face[y][0] == '\0' )
			break;

		len = str_len_std( dst->face[y] ) / 2;
		max_len = max_l( max_len, len );
	}
	dst->x_len = max_len;
	dst->y_len = y;
	src->x_len = max_len;
	src->y_len = y;

	dst->x = -(dst->x_len / 2);
	dst->y = -(dst->y_len / 2);
	src->x = -(src->x_len / 2);
	src->y = -(src->y_len / 2);

	return TRUE;
}

/***************************************************************
* µܤ겼ꤹ
* long d : 곬(+)곬(-)
***************************************************************/

void	up_dun( long d )
{
	party_t	*pty = get_party();
	long	i;

	dun.lev += d;

	if( dun.lev > +DUN_MAX_LEV_FLOOR )
		dun.lev = +DUN_MAX_LEV_FLOOR;
	if( dun.lev < -DUN_MAX_LEV_BASE )
		dun.lev = -DUN_MAX_LEV_BASE;

	if( sgn_l( dun.lev ) >= +1 ){
		print_msg( FLG_NULL, MSG_UP_DOWN_DUN_FLOOR,
				labs( dun.lev ) );
	} else if( sgn_l( dun.lev ) <= -1 ){
		print_msg( FLG_NULL, MSG_UP_DOWN_DUN_BASE,
				labs( dun.lev ) );
	} else {
		print_msg( FLG_NULL, MSG_UP_DOWN_DUN_GROUND );
	}

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( sgn_l( dun.lev ) >= +1 ){
			if( pty->mbr[i]->dun_max_lev_floor
					< labs( dun.lev ) ){
				pty->mbr[i]->dun_max_lev_floor
						= labs( dun.lev );
			}
		}
		if( sgn_l( dun.lev ) <= -1 ){
			if( pty->mbr[i]->dun_max_lev_base
					< labs( dun.lev ) ){
				pty->mbr[i]->dun_max_lev_base
						= labs( dun.lev );
			}
		}
	}

	for( i = 0; i < MBR_MAX_N; i++ )
		clr_chr_trgt_act( pty->mbr[i], FALSE );

	reset_all( TRUE );
}

/***************************************************************
* µܤ
* bool_t flg_appear : ѡƥνи򤹤뤫?
***************************************************************/

void	reset_all( bool_t flg_appear )
{
	bgn_nest_flg( g_nest_flg_dun );

	reset_trap();
	clr_dun_item();
	reset_mnstr();
	release_all_mbr();

	clr_map_all_mbr();
	clr_map_all_pet();

	if( dun.lev == 0 ){
		make_town();
		if( flg_appear ){
			if( !appear_party_town() )
				appear_party();
		}
	} else {
		make_dun();
		if( flg_appear ){
			appear_party();
		}
	}
	put_request_all_obj();

	end_nest_flg( g_nest_flg_dun );

	if( g_flg_gui )
		call_pcg_dun_reset();
	redraw_all();
}

/***************************************************************
* µܤư
***************************************************************/

void	make_dun( void )
{
	long	x, y;
	bool_t	flg_boss;
	long	item_n, item_max_n;
	long	mnstr_n, mnstr_max_n;
	long	npc_n, npc_max_n;
	long	trap_n, trap_max_n;
	long	i, j;

	bgn_nest_flg( g_nest_flg_dun );

	reset_dun( TRUE );

	g_room_ptn_max_n = sizeof( room_ptn )
			/ sizeof( room_ptn_t );
	g_boss_room_ptn_max_n = sizeof( boss_room_ptn )
			/ sizeof( room_ptn_t );

	/*  */

	for( y = 0; y < AREA_MAP_MAX_Y; y++ ){
		for( x = 0; x < AREA_MAP_MAX_X; x++ ){
			dun.area[y][x] = AREA_PATH;
		}
	}

	x = randm( AREA_MAP_MAX_X );
	y = randm( AREA_MAP_MAX_Y );
	flg_boss = make_area_boss( boss_room_ptn,
			g_boss_room_ptn_max_n, x, y );

	/* ¤ */

	for( y = 0; y < AREA_MAP_MAX_Y; y++ ){
		for( x = 0; x < AREA_MAP_MAX_X; x++ ){
			make_area( room_ptn, g_room_ptn_max_n, x, y );
		}
	}

	/* ϩ¤ */

	for( y = 0; y < AREA_MAP_MAX_Y; y++ ){
		for( x = 0; x < AREA_MAP_MAX_X; x++ ){
			if( dun.area[y][x] == AREA_PATH ){
				make_path( x, y );
			}
		}
	}

	/* ʿ */

	for( y = 0; y < AREA_MAP_MAX_Y; y++ ){
		for( x = 0; x < AREA_MAP_MAX_X - 1; x++ ){
			if( !chk_room( x, y ) )
				continue;
			if( chk_room( x + 1, y ) )
				connect_room( x, y, +1, 0 );
		}
	}

	/* ľ */

	for( y = 0; y < AREA_MAP_MAX_Y - 1; y++ ){
		for( x = 0; x < AREA_MAP_MAX_X; x++ ){
			if( !chk_room( x, y ) )
				continue;
			if( chk_room( x, y + 1 ) )
				connect_room( x, y, 0, +1 );
		}
	}

	/* ϩ˱ɥϤ */

	for( y = 0; y < AREA_MAP_MAX_Y; y++ ){
		for( x = 0; x < AREA_MAP_MAX_X; x++ ){
			if( !chk_room( x, y ) ){
				make_hide_cross_path( x, y );
			}
		}
	}

	/* ޥåפüɤˤ */

	make_fence();

	/* 곬ʤ¤ */

	for( i = 0; i < STAIRS_UP_MAX_N; i++ )
		make_stairs_randm( FACE_MJR_STAIRS_UP );

	/* 곬ʤ¤ */

	if( !flg_boss ){
		for( i = 0; i < STAIRS_DOWN_MAX_N; i++ ){
			make_stairs_randm( FACE_MJR_STAIRS_DOWN );
		}
	}

	/* ꥢƥ */

	item_n = 0;

	for( y = 0; y < MAP_MAX_Y; y++ ){
		for( x = 0; x < MAP_MAX_X; x++ ){
			if( dun.map.obj.mjr[y][x] != FACE_ROOM_PTN_ITEM )
				continue;

			dun.map.obj.mjr[y][x] = FACE_MJR_FLOOR;
			dun.map.obj.mnr[y][x] = FACE_MNR_FLOOR;
			dun.map.obj.flg[y][x] = FLG_MAP_OBJ_PASS;
			if( make_item( x, y, dun.lev )
					!= ITEM_KIND_NULL ){
				item_n++;
			}
		}
	}

	/* ߥߥå */

	for( y = 0; y < MAP_MAX_Y; y++ ){
		for( x = 0; x < MAP_MAX_X; x++ ){
			if( dun.map.obj.mjr[y][x] != FACE_ROOM_PTN_MIMIC )
				continue;

			dun.map.obj.mjr[y][x] = FACE_MJR_FLOOR;
			dun.map.obj.mnr[y][x] = FACE_MNR_FLOOR;
			dun.map.obj.flg[y][x] |= FLG_MAP_OBJ_PASS;
			if( rate_randm( MIMIC_RATE ) ){
				make_mnstr( x, y, TRUE, dun.lev,
						MNSTR_KIND_MIMIC );
			} else {
				item_t	*item;

				item = make_item_chest( dun.lev,
						get_chest_n( dun.lev ),
						TRUE );
				if( item == NULL )
					continue;
				if( !put_item( item, x, y, 1, FALSE ) ){
					del_item( item );
					continue;
				}
			}
		}
	}

	/* 󥹥 */

	for( y = 0; y < MAP_MAX_Y; y++ ){
		for( x = 0; x < MAP_MAX_X; x++ ){
			mnstr_kind_t	mnstr_kind;
			char	mjr, mnr;

			mjr = dun.map.obj.mjr[y][x];
			mnr = dun.map.obj.mnr[y][x];

			/* GOD ֤ʤ */
			if( !isalpha( mjr ) )
				continue;

			dun.map.obj.mjr[y][x] = FACE_MJR_FLOOR;
			dun.map.obj.mnr[y][x] = FACE_MNR_FLOOR;
			dun.map.obj.flg[y][x] |= FLG_MAP_OBJ_PASS;

			mnstr_kind = get_mnstr_kind_from_face( mjr, mnr );
			if( mnstr_kind == MNSTR_KIND_NULL )
				continue;

			make_mnstr( x, y, TRUE, dun.lev, mnstr_kind );
		}
	}

	/*  */

	for( y = 0; y < MAP_MAX_Y; y++ ){
		for( x = 0; x < MAP_MAX_X; x++ ){
			if( dun.map.obj.mjr[y][x] != FACE_ROOM_PTN_TRAP )
				continue;

			dun.map.obj.mjr[y][x] = FACE_MJR_FLOOR;
			dun.map.obj.mnr[y][x] = FACE_MNR_FLOOR;
			dun.map.obj.flg[y][x] |= FLG_MAP_OBJ_PASS;

			make_trap( x, y, dun.lev );
		}
	}

	/* ॢƥ */

	item_max_n = roll_dice( DUN_ITEM_AVE_N, TRUE );

	for( i = 0; i < LOOP_MAX_10000; i++ ){
		if( item_n >= item_max_n )
			break;

		x = 1 + randm( MAP_MAX_X - 2 );
		y = 1 + randm( MAP_MAX_Y - 2 );
		if( make_item( x, y, dun.lev ) != ITEM_KIND_NULL )
			item_n++;
	}
	item_max_n = item_n;

	/* 󥹥 */

	mnstr_max_n = roll_dice( MNSTR_AVE_N, TRUE );
	if( mnstr_max_n > MNSTR_MAX_N )
		mnstr_max_n = MNSTR_MAX_N;

	mnstr_n = 0;
	for( i = 0; i < LOOP_MAX_4000; i++ ){
		if( mnstr_n >= mnstr_max_n )
			break;

		x = 1 + randm( MAP_MAX_X - 2 );
		y = 1 + randm( MAP_MAX_Y - 2 );
		if( make_mnstr_rand( x, y, FALSE, dun.lev ) != NULL )
			mnstr_n++;
	}

	/*  NPC */

	npc_max_n = roll_dice( DUN_NPC_AVE_N, FALSE );
	if( npc_max_n > (MNSTR_MAX_N - mnstr_n) )
		npc_max_n = (MNSTR_MAX_N - mnstr_n);

	npc_n = 0;
	for( i = 0; i < LOOP_MAX_4000; i++ ){
		if( npc_n >= npc_max_n )
			break;

		x = 1 + randm( MAP_MAX_X - 2 );
		y = 1 + randm( MAP_MAX_Y - 2 );

		if( make_npc_rand( x, y, 0 ) != NULL )
			npc_n++;
	}

	/*  */

	trap_max_n = roll_dice( TRAP_AVE_N, TRUE );
	if( trap_max_n > TRAP_MAX_N )
		trap_max_n = TRAP_MAX_N;

	trap_n = 0;
	for( i = 0; i < LOOP_MAX_1000; i++ ){
		trap_t	*trap;

		x = 0;
		y = 0;
		for( j = 0; j < LOOP_MAX_100; j++ ){
			x = 1 + randm( MAP_MAX_X - 2 );
			y = 1 + randm( MAP_MAX_Y - 2 );
			if( dun.map.obj.mjr[y][x] == FACE_MJR_FLOOR )
				break;
		}

		trap = make_trap( x, y, dun.lev );
		if( trap != NULL )
			trap_n++;
		if( trap_n >= trap_max_n )
			break;
	}

	/* ȥå */

	make_chk_trap_room( dun.lev );

	if( flg_boss ){
		curs_attrset_chr( get_mbr_randm( MAP_DEL_X, MAP_DEL_Y ),
				-1, FALSE );
		print_msg( FLG_NULL, MSG_FEEL_BOSS );
		curs_attrset_dflt();
	}

	end_nest_flg( g_nest_flg_dun );
}

/***************************************************************
* µܤγȤɤ
***************************************************************/

void	make_fence( void )
{
	long	n;

	for( n = 0; n < MAP_MAX_Y; n++ ){
		if( dun.map.obj.mnr[n][0] == FACE_MNR_GATE )
			continue;

		dun.map.obj.mjr[n][0] = FACE_MJR_WALL;
		dun.map.obj.mnr[n][0] = FACE_MNR_WALL;
		dun.map.obj.flg[n][0] &= ~(FLG_MAP_OBJ_PASS);
	}
	for( n = 0; n < MAP_MAX_Y; n++ ){
		if( dun.map.obj.mnr[n][MAP_MAX_X - 1] == FACE_MNR_GATE )
			continue;

		dun.map.obj.mjr[n][MAP_MAX_X - 1] = FACE_MJR_WALL;
		dun.map.obj.mnr[n][MAP_MAX_X - 1] = FACE_MNR_WALL;
		dun.map.obj.flg[n][MAP_MAX_X - 1] &= ~(FLG_MAP_OBJ_PASS);
	}

	for( n = 0; n < MAP_MAX_X; n++ ){
		if( dun.map.obj.mnr[0][n] == FACE_MNR_GATE )
			continue;

		dun.map.obj.mjr[0][n] = FACE_MJR_WALL;
		dun.map.obj.mnr[0][n] = FACE_MNR_WALL;
		dun.map.obj.flg[0][n] &= ~(FLG_MAP_OBJ_PASS);
	}
	for( n = 0; n < MAP_MAX_X; n++ ){
		if( dun.map.obj.mnr[MAP_MAX_Y - 1][n] == FACE_MNR_GATE )
			continue;

		dun.map.obj.mjr[MAP_MAX_Y - 1][n] = FACE_MJR_WALL;
		dun.map.obj.mnr[MAP_MAX_Y - 1][n] = FACE_MNR_WALL;
		dun.map.obj.flg[MAP_MAX_Y - 1][n] &= ~(FLG_MAP_OBJ_PASS);
	}
}

/***************************************************************
* µܤ
* room_ptn_t *ptn : Υѥ
* area_t max_n : Υѥκ
* long x : Xɸ
* long y : Yɸ
***************************************************************/

void	make_area( room_ptn_t *ptn, area_t max_n, long x, long y )
{
	long	i;
	long	flg;

	if( dun.area[y][x] != AREA_PATH )
		return;

	if( !chk_rate_room( dun.lev ) )
		return;

	for( i = 0; i < (max_n * LOOP_MAX_100); i++ ){
		area_t	n;

		n = (area_t)randm( max_n );
		if( labs( dun.lev ) < ptn[n].min_lev )
			continue;
		if( labs( dun.lev ) > ptn[n].max_lev )
			continue;
		if( sgn_l( dun.lev ) != ptn[n].sgn_lev )
			continue;

		flg = randm( 8 ) / 2;	/* ľʿե饰 */
		set_room( ptn, n, x, y, flg );
		break;
	}
}

/***************************************************************
* µܤܥ
* room_ptn_t *ptn : Υѥ
* area_t max_n : Υѥκ
* long x : Xɸ
* long y : Yɸ
***************************************************************/

bool_t	make_area_boss( room_ptn_t *ptn, area_t max_n, long x, long y )
{
	area_t	i;
	long	flg;

	if( dun.area[y][x] != AREA_PATH )
		return FALSE;

	for( i = 0; i < max_n; i++ ){
		if( labs( dun.lev ) < ptn[i].min_lev )
			continue;
		if( labs( dun.lev ) > ptn[i].max_lev )
			continue;
		if( sgn_l( dun.lev ) != ptn[i].sgn_lev )
			continue;

		flg = 0;	/* ľʿե饰 */
		set_room( ptn, i, x, y, flg );
		return TRUE;
	}

	return FALSE;
}

/***************************************************************
* µܤ֤
* room_ptn_t *room : Υѥ
* area_t n : Υѥֹ
* long x : Xɸ
* long y : Yɸ
* long flg_rev : 岼ȿžե饰
***************************************************************/

void	set_room( room_ptn_t *room, area_t n, long x, long y, long flg_rev )
{
	long	i, j, ii, jj;
	long	mx, my;
	char	mjr, mnr;
	flg_map_t	flg;
	sect_t	sect;
	flg_map_t	flg_light;

	dun.area[y][x] = n;
	flg_light = chk_lighted_room();

	for( i = 0; i < AREA_MAX_Y; i++ ){
		for( j = 0; j < AREA_MAX_X; j++ ){
			if( chk_flg( flg_rev, 0x02 ) )
				ii = AREA_MAX_Y - 1 - i;
			else
				ii = i;

			if( chk_flg( flg_rev, 0x01 ) )
				jj = AREA_MAX_X - 1 - j;
			else
				jj = j;

			mx = x * AREA_MAX_X + jj;
			my = y * AREA_MAX_Y + ii;

			mjr = room[n].ptn[i][j * 2 + 0];
			mnr = room[n].ptn[i][j * 2 + 1];
			sect = room[n].sect[i][j];

			dun.map.obj.mjr[my][mx] = mjr;
			dun.map.obj.mnr[my][mx] = mnr;
			dun.map.obj.flg[my][mx] = FLG_NULL;
			dun.map.sect[my][mx] = sect;

			switch( mjr ){
			case FACE_MJR_FLOOR:
			case FACE_MJR_DOOR_OPEN:
				flg = FLG_MAP_OBJ_PASS;
				break;
			case FACE_MJR_WALL:
			case FACE_MJR_DOOR_CLOSE:
				flg = FLG_NULL;
				break;
			default:
				flg = FLG_MAP_OBJ_PASS;
			}
			dun.map.obj.flg[my][mx] = flg;

			if( flg_light )
				dun.map.light_depth_obj[my][mx] = 1;
			else
				dun.map.light_depth_obj[my][mx] = 0;
		}
	}

	/* Ūʥɥ */

	for( i = 0; i < AREA_MAX_Y; i++ ){
		for( j = 0; j < AREA_MAX_X; j++ ){
			mx = x * AREA_MAX_X + j;
			my = y * AREA_MAX_Y + i;
			if( dun.map.obj.mjr[my][mx]
					== FACE_MJR_DOOR_OPEN ){
				make_door_room( mx, my );
			} else if( dun.map.obj.mjr[my][mx]
					== FACE_MJR_DOOR_CLOSE ){
				make_door_room( mx, my );
			}
		}
	}
}

/***************************************************************
* ꤬ĤƤ뤫Ƿ
* return : ꤬ĤƤ뤫
***************************************************************/

bool_t	chk_lighted_room( void )
{
	rate_t	rate;

	rate = 80 - (randm( labs( dun.lev ) ) * 2);

	if( rate <= 0 )
		return FALSE;
	return rate_randm( rate );
}

/***************************************************************
* ϩ꤬ĤƤ뤫Ƿ
* return : ϩ꤬ĤƤ뤫
***************************************************************/

bool_t	chk_lighted_path( void )
{
	rate_t	rate;

	rate = 40 - (randm( labs( dun.lev ) ) * 2);

	if( rate <= 0 )
		return FALSE;
	return rate_randm( rate );
}

/***************************************************************
* ϩ
* long area_x : Xɸ
* long area_y : Yɸ
***************************************************************/

void	make_path( long area_x, long area_y )
{
	long	bgn_x, bgn_y, end_x, end_y;
	long	bend_x, bend_y;
	long	mx, my;

	mx = area_x * AREA_MAX_X;
	my = area_y * AREA_MAX_Y;


	/* ʿϩĤʤ */

	/* ٤ϩΣٺɸ */
	bgn_y = chk_extend_path_h( area_x, area_y, -1 );
	/* ٤ϩΣٺɸ */
	end_y = chk_extend_path_h( area_x, area_y, +1 );
	/* ޤʤغɸ */
	bend_x = 1 + randm( AREA_MAX_X - PATH_WIDTH + 1 - 2 );

	line_path( mx + 0, my + bgn_y, mx + bend_x, my + bgn_y,
			SECT_PATH_H );
	line_path( mx + bend_x, my + bgn_y, mx + bend_x, my + end_y,
			SECT_PATH_H );
	line_path( mx + bend_x, my + end_y,
			mx + AREA_MAX_X - PATH_WIDTH, my + end_y,
			SECT_PATH_H );

	if( chk_room( area_x - 1, area_y ) ){
		finish_path( mx + 0,
				my + bgn_y, -1, 0 );
	}
	if( chk_room( area_x + 1, area_y ) ){
		finish_path( mx + AREA_MAX_Y - PATH_WIDTH,
				my + end_y, +1, 0 );
	}


	/* ľϩĤʤ */

	/* ٤ϩΣغɸ */
	bgn_x = chk_extend_path_v( area_x, area_y, -1 );
	/* ٤ϩΣغɸ */
	end_x = chk_extend_path_v( area_x, area_y, +1 );
	/* ޤʤٺɸ */
	bend_y = 1 + randm( AREA_MAX_Y - PATH_WIDTH + 1 - 2 );

	line_path( mx + bgn_x, my + 0, mx + bgn_x, my + bend_y,
			SECT_PATH_V );
	line_path( mx + bgn_x, my + bend_y, mx + end_x, my + bend_y,
			SECT_PATH_V );
	line_path( mx + end_x, my + bend_y,
			mx + end_x, my + AREA_MAX_Y - PATH_WIDTH,
			SECT_PATH_V );

	if( chk_room( area_x, area_y - 1 ) ){
		finish_path( mx + bgn_x,
				my + 0, 0, -1 );
	}
	if( chk_room( area_x, area_y + 1 ) ){
		finish_path( mx + end_x,
				my + AREA_MAX_Y - PATH_WIDTH, 0, +1 );
	}

	if( chk_lighted_path() ){
		on_light_area( area_x * AREA_MAX_X,
				area_y * AREA_MAX_Y, FALSE );
	}
}

/***************************************************************
* ٤ΥꥢϩӤƤ뤫Ĵ٤
* long ax : ꥢXɸ
* long ay : ꥢYɸ
* long d : (+)(-)λ
* return : ٤ΥꥢϩYɸ
***************************************************************/

long	chk_extend_path_h( long ax, long ay, long d )
{
	long	i;
	long	map_x, map_y;

	/* Ϥ߽Ф */
	if( ((ax + d) < 0) || (AREA_MAP_MAX_X <= (ax + d)) )
		return( 1 + randm( AREA_MAX_Y - PATH_WIDTH + 1 - 2 ) );

	if( d <= -1 )
		map_x = (ax + d) * AREA_MAX_X + (AREA_MAX_X - 1);
	else
		map_x = (ax + d) * AREA_MAX_X + 0;

	for( i = 0; i < AREA_MAX_Y - PATH_WIDTH + 1; i++ ){
		map_y = ay * AREA_MAX_Y + i;

		if( dun.map.obj.mjr[map_y][map_x] == FACE_MJR_FLOOR ){
			return i;
		}
	}

	/* ˷᤿ٺɸ */
	return( 1 + randm( AREA_MAX_Y - PATH_WIDTH + 1 - 2 ) );
}

/***************************************************************
* ٤ΥꥢϩӤƤ뤫Ĵ٤̡
* long ax : ꥢXɸ
* long ay : ꥢYɸ
* long d : (+)(-)λ
* return : ٤ΥꥢϩXɸ
***************************************************************/

long	chk_extend_path_v( long ax, long ay, long d )
{
	long	i;
	long	map_x, map_y;

	/* Ϥ߽Ф */
	if( ((ay + d) < 0) || (AREA_MAP_MAX_Y <= (ay + d)) )
		return( 1 + randm( AREA_MAX_X - PATH_WIDTH + 1 - 2 ) );

	if( d <= -1 )
		map_y = (ay + d) * AREA_MAX_Y + (AREA_MAX_Y - 1);
	else
		map_y = (ay + d) * AREA_MAX_Y + 0;

	for( i = 0; i < AREA_MAX_X - PATH_WIDTH + 1; i++ ){
		map_x = ax * AREA_MAX_X + i;

		if( dun.map.obj.mjr[map_y][map_x] == FACE_MJR_FLOOR ){
			return i;
		}
	}

	/* ˷᤿غɸ */
	return( 1 + randm( AREA_MAX_X - PATH_WIDTH + 1 - 2 ) );
}

/***************************************************************
* Υꥢɤå
* long ax : ꥢXɸ
* long ay : ꥢYɸ
* return : ?
***************************************************************/

bool_t	chk_room( long ax, long ay )
{
	if( ax < 0 )
		return FALSE;
	if( ax >= AREA_MAP_MAX_X )
		return FALSE;
	if( ay < 0 )
		return FALSE;
	if( ay >= AREA_MAP_MAX_Y )
		return FALSE;

	if( dun.area[ay][ax] == AREA_PATH )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ϩüޤǿФ
* long mx : Xɸ
* long my : Yɸ
* long dx : ϩ򷡤(+)(-)
* long dy : ϩ򷡤(+)(-)
***************************************************************/

void	finish_path( long mx, long my, long dx, long dy )
{
	long	i;

	if( dx < 0 ){	/* λ */
		for( i = 0; i < AREA_MAX_X; i++ ){
			if( chk_finish_path( mx, my, -1, 0 ) )
				break;

			/* ϩ򿭤Ф */
			put_path( mx, my, -1, 0, SECT_PATH_DFLT );
			mx--;
		}
	} else if( dx > 0 ){	/* λ */
		for( i = 0; i < AREA_MAX_X; i++ ){
			if( chk_finish_path( mx, my, +1, 0 ) )
				break;

			/* ϩ򿭤Ф */
			put_path( mx, my, +1, 0, SECT_PATH_DFLT );
			mx++;
		}
	} else if( dy < 0 ){	/* λ */
		for( i = 0; i < AREA_MAX_Y; i++ ){
			if( chk_finish_path( mx, my, 0, -1 ) )
				break;

			/* ϩ򿭤Ф */
			put_path( mx, my, 0, -1, SECT_PATH_DFLT );
			my--;
		}
	} else if( dy > 0 ){	/* λ */
		for( i = 0; i < AREA_MAX_Y; i++ ){
			if( chk_finish_path( mx, my, 0, +1 ) )
				break;

			/* ϩ򿭤Ф */
			put_path( mx, my, 0, +1, SECT_PATH_DFLT );
			my++;
		}
	}
}

/***************************************************************
* ϩüޤǷ줿å
* long mx : Xɸ
* long my : Yɸ
* long dx : ϩ򷡤(+)(-)
* long dy : ϩ򷡤(+)(-)
* return : ٽä?
***************************************************************/

bool_t	chk_finish_path( long mx, long my, long dx, long dy )
{
	long	i;
	bool_t	flg;

	if( dx < 0 ){
		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my + i][mx + dx]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, -1, 0 );
			return TRUE;
		}

		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my - 1][mx + i]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, 0, -1 );
			return TRUE;
		}

		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my + PATH_WIDTH][mx + i]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, 0, +1 );
			return TRUE;
		}
	} else if( dx > 0 ){
		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my + i][mx + dx + PATH_WIDTH - 1]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, +1, 0 );
			return TRUE;
		}

		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my - 1][mx - i + PATH_WIDTH - 1]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, 0, -1 );
			return TRUE;
		}

		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my + PATH_WIDTH]
					[mx - i + PATH_WIDTH - 1]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
 			make_door_path( mx, my, 0, +1 );
			return TRUE;
		}
	} else if( dy < 0 ){
		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my + dy][mx + i]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, 0, -1 );
			return TRUE;
		}

		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my + i][mx - 1]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, -1, 0 );
			return TRUE;
		}

		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my + i][mx + PATH_WIDTH]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, +1, 0 );
			return TRUE;
		}
	} else if( dy > 0 ){
		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my + dy + PATH_WIDTH - 1][mx + i]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, 0, +1 );
			return TRUE;
		}

		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my - i + PATH_WIDTH - 1][mx - 1]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, -1, 0 );
			return TRUE;
		}

		flg = TRUE;
		for( i = 0; i < PATH_WIDTH; i++ ){
			if( dun.map.obj.mjr[my - i + PATH_WIDTH - 1]
					[mx + PATH_WIDTH]
					!= FACE_MJR_FLOOR ){
				flg = FALSE;
				break;
			}
		}
		if( flg ){
			make_door_path( mx, my, +1, 0 );
			return TRUE;
		}
	}

	return FALSE;
}

/***************************************************************
* ٤äɤĤʤ
* long ax : ꥢXɸ
* long ay : ꥢYɸ
* long dx : ϩ򷡤(+)(-)
* long dy : ϩ򷡤(+)(-)
***************************************************************/

void	connect_room( long ax, long ay, long dx, long dy )
{
	long	mx, my;

	if( dx < 0 ){
		/* λ */
		my = ay * AREA_MAX_Y + 1
				+ randm( AREA_MAX_Y - PATH_WIDTH - 2 );

		mx = ax * AREA_MAX_X - 1;
		finish_path( mx, my, -1, 0 );
		mx = ax * AREA_MAX_X - PATH_WIDTH + 1;
		finish_path( mx, my, +1, 0 );
	} else if( dx > 0 ){
		/* λ */
		my = ay * AREA_MAX_Y + 1
				+ randm( AREA_MAX_Y - PATH_WIDTH - 2 );

		mx = ax * AREA_MAX_X + AREA_MAX_X - 1;
		finish_path( mx, my, -1, 0 );
		mx = ax * AREA_MAX_X + AREA_MAX_X - PATH_WIDTH + 1;
		finish_path( mx, my, +1, 0 );
	} else if( dy < 0 ){
		/* λ */
		mx = ax * AREA_MAX_X + 1
				+ randm( AREA_MAX_X - PATH_WIDTH - 2 );

		my = ay * AREA_MAX_Y - 1;
		finish_path( mx, my, 0, -1 );
		my = ay * AREA_MAX_Y - PATH_WIDTH + 1;
		finish_path( mx, my, 0, +1 );
	} else if( dy > 0 ){
		/* λ */
		mx = ax * AREA_MAX_X + 1
				+ randm( AREA_MAX_X - PATH_WIDTH - 2 );

		my = ay * AREA_MAX_Y + AREA_MAX_Y - 1;
		finish_path( mx, my, 0, -1 );
		my = ay * AREA_MAX_Y + AREA_MAX_Y - PATH_WIDTH + 1;
		finish_path( mx, my, 0, +1 );
	}
}

/***************************************************************
* ϩ˥ɥ
* long mx : Xɸ
* long my : Yɸ
* long dx : (+)(-)
* long dy : (+)(-)
***************************************************************/

void	make_door_path( long mx, long my, long dx, long dy )
{
	if( dx < 0 ){
		make_door( mx, my,
				mx + 1,
				my + PATH_WIDTH - 1,
				FACE_MNR_NULL );
	}
	if( dx > 0 ){
		make_door( mx + 1, my,
				mx + PATH_WIDTH - 1,
				my + PATH_WIDTH - 1,
				FACE_MNR_NULL );
	}
	if( dy < 0 ){
		make_door( mx, my,
				mx + PATH_WIDTH - 1,
				my + 1,
				FACE_MNR_NULL);
	}
	if( dy > 0 ){
		make_door( mx, my + 1,
				mx + PATH_WIDTH - 1,
				my + PATH_WIDTH - 1,
				FACE_MNR_NULL );
	}
}

/***************************************************************
* ޥåסơ֥ꤵ줿ɥ
* long mx : Xɸ
* long my : Yɸ
***************************************************************/

void	make_door_room( long mx, long my )
{
	long	dx, dy;
	long	i;

	/* ǤϿߤ */
	if( (mx - 1) >= 0 )
		if( dun.map.obj.mjr[my][mx - 1] == FACE_MJR_DOOR_CLOSE )
			return;
	if( (my - 1) >= 0 )
		if( dun.map.obj.mjr[my - 1][mx] == FACE_MJR_DOOR_CLOSE )
			return;


	for( i = 0; i < AREA_MAX_X; i++ ){
		if( dun.map.obj.mjr[my][mx + i] != FACE_MJR_DOOR_CLOSE ){
			break;
		}
	}
	dx = i - 1;
	if( dx < 0 )
		return;

	for( i = 0; i < AREA_MAX_Y; i++ ){
		if( dun.map.obj.mjr[my + i][mx] != FACE_MJR_DOOR_CLOSE ){
			break;
		}
	}
	dy = i - 1;
	if( dy < 0 )
		return;

	make_door( mx, my, mx + dx, my + dy, FACE_MNR_NULL );
}

/***************************************************************
* ɥ
* long bx : Xɸ
* long by : Yɸ
* long ex : Xɸ
* long ey : Yɸ
* char mnr : ޥʡδʸ
* return : ɥ
***************************************************************/

door_t	*make_door( long bx, long by, long ex, long ey, char mnr )
{
	flg_door_t	flg;

	flg = FLG_NULL;

	if( mnr == FACE_MNR_NULL ){
		if( chk_rate_door_open( dun.lev ) )
			flg |= FLG_DOOR_OPEN;

		if( chk_rate_door_jammed( dun.lev ) )
			flg |= FLG_DOOR_JAMMED;

		if( chk_rate_door_broken( dun.lev ) )
			flg |= FLG_DOOR_BROKEN;

		if( chk_rate_door_secret( dun.lev ) )
			flg |= FLG_DOOR_SECRET;

		flg &= ~(FLG_DOOR_CHKED);
	} else if( mnr == FACE_MNR_GATE ){
		flg |= FLG_DOOR_GATE;
	} else {
		flg |= FLG_DOOR_SHOP;
	}

	return make_door_flg( bx, by, ex, ey, mnr, flg );
}

/***************************************************************
* ե饰ꤷƥɥ
* long bx : Xɸ
* long by : Yɸ
* long ex : Xɸ
* long ey : Yɸ
* char mnr : ޥʡδʸ
* flg_door_t flg : ɥΥե饰
* return : ɥ
***************************************************************/

door_t	*make_door_flg(
	long bx, long by,
	long ex, long ey,
	char mnr, flg_door_t flg
)
{
	long	i;
	long	tmp;
	long	dx, dy;
	long	n;

	if( dun.door_n >= DOOR_MAX_N )
		return NULL;

	n = dun.door_n;

	if( bx > ex ){
		tmp = bx;
		bx = ex;
		ex = tmp;
	}
	if( by > ey ){
		tmp = by;
		by = ey;
		ey = tmp;
	}

	if( mnr == FACE_MNR_GATE ){
		if( bx < 0 )
			bx = 0;
		if( ex > MAP_MAX_X - 1 )
			ex = MAP_MAX_X - 1;
		if( by < 0 )
			by = 0;
		if( ey > MAP_MAX_Y - 1 )
			ey = MAP_MAX_Y - 1;
	} else {
		if( bx < 1 )
			bx = 1;
		if( ex > MAP_MAX_X - 2 )
			ex = MAP_MAX_X - 2;
		if( by < 1 )
			by = 1;
		if( ey > MAP_MAX_Y - 2 )
			ey = MAP_MAX_Y - 2;
	}

	dx = ex - bx + 1;
	dy = ey - by + 1;
	if( dx <= 0 )
		return NULL;
	if( dy <= 0 )
		return NULL;

	/* ΰ֤ˤǤ˥ɥʤ return */
	for( i = 0; i < n; i++ ){
		if( dun.door[i].x != bx )
			continue;
		if( dun.door[i].y != by )
			continue;
		if( dun.door[i].dx != dx )
			continue;
		if( dun.door[i].dy != dy )
			continue;

		return NULL;
	}

	dun.door[n].n = n;
	dun.door[n].x = bx;
	dun.door[n].y = by;
	dun.door[n].dx = dx;
	dun.door[n].dy = dy;
	dun.door[n].flg = flg;
	dun.door[n].mnr = mnr;

	dun.door_n++;

	set_face_door( n );

	return( &(dun.door[n]) );
}

/***************************************************************
* ɥξ֤ˤäơե饰ʸ
* long dr_n : ɥֹ
***************************************************************/

void	set_face_door( long dr_n )
{
	long	i, j;
	char	mjr, mnr;
	flg_map_t	flg;

	mjr = FACE_MJR_DOOR_CLOSE;
	mnr = FACE_MNR_DOOR_NORM;
	flg = FLG_NULL;

	/* if ʸν֤ */

	if( chk_flg( dun.door[dr_n].flg, FLG_DOOR_OPEN ) ){
		mjr = FACE_MJR_DOOR_OPEN;
		flg |= FLG_MAP_OBJ_PASS;
	}

	if( chk_flg( dun.door[dr_n].flg, FLG_DOOR_JAMMED ) )
		mnr = FACE_MNR_DOOR_JAMMED;

	if( chk_flg( dun.door[dr_n].flg, FLG_DOOR_CHKED ) )
		flg |= FLG_MAP_OBJ_FIND;
	else
		mnr = FACE_MNR_DOOR_NORM;

	if( chk_flg( dun.door[dr_n].flg, FLG_DOOR_BROKEN ) ){
		dun.door[dr_n].flg |= FLG_DOOR_OPEN;
		mjr = FACE_MJR_DOOR_OPEN;
		mnr = FACE_MNR_DOOR_BROKEN;
		flg |= FLG_MAP_OBJ_PASS;
	}

	if( chk_flg( dun.door[dr_n].flg, FLG_DOOR_SECRET ) ){
		dun.door[dr_n].flg &= ~(FLG_DOOR_OPEN);
		mjr = FACE_MJR_DOOR_CLOSE;
		mnr = FACE_MNR_DOOR_SECRET;
		flg &= ~FLG_MAP_OBJ_PASS;
		flg |= FLG_MAP_OBJ_LOOK_WALL;
	}

	if( chk_flg( dun.door[dr_n].flg, FLG_DOOR_SHOP ) ){
		mjr = FACE_MJR_DOOR_CLOSE;
		/* mnr  make_door() Ѥ */
		mnr = dun.door[dr_n].mnr;
		flg &= ~FLG_MAP_OBJ_PASS;
		flg |= FLG_MAP_OBJ_FIND;
	}

	if( chk_find_door( dr_n ) )
		flg |= FLG_MAP_OBJ_FIND;
	if( dun.lev == 0 )
		flg |= FLG_MAP_OBJ_FIND;

	if( chk_flg( dun.door[dr_n].flg, FLG_DOOR_GATE ) ){
		mjr = FACE_MJR_DOOR_CLOSE;
		mnr = FACE_MNR_GATE;
		flg &= ~FLG_MAP_OBJ_PASS;
		flg |= FLG_MAP_OBJ_FIND;
	}

	/**/

	dun.door[dr_n].mjr = mjr;
	dun.door[dr_n].mnr = mnr;
	for( i = 0; i < dun.door[dr_n].dy; i++ ){
		for( j = 0; j < dun.door[dr_n].dx; j++ ){
			long	x, y;

			x = dun.door[dr_n].x + j;
			y = dun.door[dr_n].y + i;
			dun.map.obj.mjr[y][x] = mjr;
			dun.map.obj.mnr[y][x] = mnr;
			dun.map.obj.flg[y][x] = flg;
		}
	}
}

/***************************************************************
* ɥȯƤ뤫Ĵ٤
* long dr_n : ɥֹ
* return : ɥȯƤ뤫?
***************************************************************/

bool_t	chk_find_door( long dr_n )
{
	long	i, j;

	for( i = 0; i < dun.door[dr_n].dy; i++ ){
		for( j = 0; j < dun.door[dr_n].dx; j++ ){
			long	x, y;

			x = dun.door[dr_n].x + j;
			y = dun.door[dr_n].y + i;
			if( chk_flg( dun.map.obj.flg[y][x],
					FLG_MAP_OBJ_FIND ) ){
				return TRUE;
			}
		}
	}

	return FALSE;
}

/***************************************************************
* ɥ
* long dr_n : ɥֹ
* return : ɥ?
***************************************************************/

bool_t	break_door( long dr_n )
{
	if( chk_flg( dun.door[dr_n].flg, FLG_DOOR_SHOP ) ){
		print_msg( FLG_NULL, MSG_ERR_DOOR_BREAK_SHOP );
		return FALSE;
	}
	if( chk_flg( dun.door[dr_n].flg, FLG_DOOR_BROKEN ) ){
		print_msg( FLG_NULL, MSG_ERR_DOOR_BREAK_BROKEN );
		return FALSE;
	}
	if( chk_flg( dun.door[dr_n].flg, FLG_DOOR_GATE ) ){
		print_msg( FLG_NULL, MSG_ERR_DOOR_BREAK_SHOP );
		return FALSE;
	}

	dun.door[dr_n].flg |= FLG_DOOR_BROKEN | FLG_DOOR_OPEN;
	set_face_door( dr_n );
	draw_door( dr_n );

	return TRUE;
}

/***************************************************************
* ɥܺɸ֤
* pos_t *pos : ɸ֤
* door_t *dr : ɥ
* chr_t *chr : 饯
***************************************************************/

void	get_near_pos_door( pos_t *pos, door_t *dr, chr_t *chr )
{
	if( pos == NULL )
		return;
	if( dr == NULL )
		return;
	if( chr == NULL )
		return;

	pos->x = dr->x;
	pos->y = dr->y;

	/* ɥΣ֥åȤʤ */
	if( chr->x < dr->x )
		pos->x = dr->x - 1;
	else if( (dr->x + dr->dx - 1) < chr->x )
		pos->x = (dr->x + dr->dx - 1) + 1;

	if( chr->y < dr->y )
		pos->y = dr->y - 1;
	else if( (dr->y + dr->dy - 1) < chr->y )
		pos->y = (dr->y + dr->dy - 1) + 1;
}

/***************************************************************
* ꥢνϩ˱ɥ
* long ax : ꥢXɸ
* long ay : ꥢYɸ
* return : ?
***************************************************************/

bool_t	make_hide_cross_path( long ax, long ay )
{
	long	x, y;
	bool_t	ret;

	if( chk_room( ax, ay ) )
		return FALSE;

	if( !chk_rate_hide_cross_path( dun.lev ) )
		return FALSE;

	ret = FALSE;

	for( y = 0; y < AREA_MAX_Y; y++ ){
		for( x = 0; x < AREA_MAX_X; x++ ){
			long	mx, my;

			mx = ax * AREA_MAX_X + x;
			my = ay * AREA_MAX_Y + y;
			if( chk_cross_path( mx, my ) ){
				hide_cross_path( mx, my );
				ret = TRUE;
			}
		}
	}

	return ret;
}

/***************************************************************
* ɥǤ뽽ϩĴ٤
* long mx : Xɸ
* long my : Yɸ
* return : Ǥ뤫?
***************************************************************/

bool_t	chk_cross_path( long mx, long my )
{
	long	x, y;
	long	i, j;

	if( !clip_pos( mx - 1, my - 1 ) )
		return FALSE;
	if( !clip_pos( mx + 1, my + 1 ) )
		return FALSE;

	for( i = 0; i < PATH_WIDTH; i++ ){
		for( j = 0; j < PATH_WIDTH; j++ ){
			x = mx + j;
			y = my + i;
			if( dun.map.obj.mjr[y][x] != FACE_MJR_FLOOR ){
				return FALSE;
			}
		}
	}

	for( i = 0; i < PATH_WIDTH; i++ ){
		x = mx + i;
		y = my - 1;
		if( dun.map.obj.mjr[y][x] != FACE_MJR_FLOOR )
			return FALSE;

		x = mx + i;
		y = my + PATH_WIDTH;
		if( dun.map.obj.mjr[y][x] != FACE_MJR_FLOOR )
			return FALSE;

		x = mx - 1;
		y = my + i;
		if( dun.map.obj.mjr[y][x] != FACE_MJR_FLOOR )
			return FALSE;

		x = mx + PATH_WIDTH;
		y = my + i;
		if( dun.map.obj.mjr[y][x] != FACE_MJR_FLOOR )
			return FALSE;
	}

	x = mx - 1;
	y = my - 1;
	if( dun.map.obj.mjr[y][x] == FACE_MJR_FLOOR )
		return FALSE;

	x = mx + PATH_WIDTH;
	y = my - 1;
	if( dun.map.obj.mjr[y][x] == FACE_MJR_FLOOR )
		return FALSE;

	x = mx - 1;
	y = my + PATH_WIDTH;
	if( dun.map.obj.mjr[y][x] == FACE_MJR_FLOOR )
		return FALSE;

	x = mx + PATH_WIDTH;
	y = my + PATH_WIDTH;
	if( dun.map.obj.mjr[y][x] == FACE_MJR_FLOOR )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ϩ˱ɥ
* long mx : Xɸ
* long my : Yɸ
***************************************************************/

void	hide_cross_path( long mx, long my )
{
	long	bx, by, ex, ey;
	long	x, y;
	char	mnr;
	flg_door_t	flg;

	mnr = FACE_MNR_NULL;
	flg = FLG_DOOR_SECRET;
	flg &= ~(FLG_DOOR_OPEN);

	if( randm( 2 ) == 0 ){
		/* ˥ɥĤ */
		bx = mx - 1;
		ex = mx - 1;
		by = my;
		ey = my + PATH_WIDTH - 1;
		make_door_flg( bx, by, ex, ey, mnr, flg );

		/* ˥ɥĤ */
		bx = mx + PATH_WIDTH;
		ex = mx + PATH_WIDTH;
		by = my;
		ey = my + PATH_WIDTH - 1;
		make_door_flg( bx, by, ex, ey, mnr, flg );

		for( y = my; y < my + PATH_WIDTH; y++ ){
			for( x = mx; x < mx + PATH_WIDTH; x++ ){
				dun.map.sect[y][x] = SECT_PATH_V;
			}
		}
	} else {
		/* ̤˥ɥĤ */
		bx = mx;
		ex = mx + PATH_WIDTH - 1;
		by = my - 1;
		ey = my - 1;
		make_door_flg( bx, by, ex, ey, mnr, flg );

		/* ˥ɥĤ */
		bx = mx;
		ex = mx + PATH_WIDTH - 1;
		by = my + PATH_WIDTH;
		ey = my + PATH_WIDTH;
		make_door_flg( bx, by, ex, ey, mnr, flg );

		for( y = my; y < my + PATH_WIDTH; y++ ){
			for( x = mx; x < mx + PATH_WIDTH; x++ ){
				dun.map.sect[y][x] = SECT_PATH_H;
			}
		}
	}
}

/***************************************************************
* ʤ
* char face : ʤμδʸ
***************************************************************/

void	make_stairs_randm( char face )
{
	long	x, y;
	long	i;

	for( i = 0; i < LOOP_MAX_4000; i++ ){
		x = randm( MAP_MAX_X );
		y = randm( MAP_MAX_Y );

		if( dun.map.obj.mjr[y][x] == FACE_MJR_FLOOR ){
			make_stairs( x, y, face );
			break;
		}
	}
}

/***************************************************************
* ɸꤷơʤ
* long x : Xɸ
* long y : Yɸ
* char face : ʤμδʸ
***************************************************************/

void	make_stairs( long x, long y, char face )
{
	char	mjr, mnr;

	if( dun.map.obj.mjr[y][x] != FACE_MJR_FLOOR )
		return;

	if( (face == FACE_MJR_STAIRS_DOWN)
			|| (face == FACE_MNR_STAIRS_DOWN) ){
		if( labs( dun.lev ) >= labs( DUN_MAX_LEV_BASE ) )
			return;

		mjr = FACE_MJR_STAIRS_DOWN;
		mnr = FACE_MNR_STAIRS_DOWN;
	} else {
		if( labs( dun.lev ) >= labs( DUN_MAX_LEV_FLOOR ) )
			return;

		mjr = FACE_MJR_STAIRS_UP;
		mnr = FACE_MNR_STAIRS_UP;
	}

	dun.map.obj.mjr[y][x] = mjr;
	dun.map.obj.mnr[y][x] = mnr;
}

/***************************************************************
* 
* long x : Xɸ
* long y : Yɸ
* long dun_lev : µܤγ
* bool_t flg_self : 饯Τ֤
* return : Ǥ?
***************************************************************/

bool_t	set_statue( long x, long y, long dun_lev, bool_t flg_self )
{
	long	ix, iy;

	if( dun.map.obj.mjr[y][x] != FACE_MJR_FLOOR )
		return FALSE;
	if( !flg_self && (dun.map.chr.mjr[y][x] != FACE_MJR_NULL) )
		return FALSE;

	dun.map.obj.mjr[y][x] = FACE_MJR_WALL;
	dun.map.obj.mnr[y][x] = FACE_MNR_STATUE;
	dun.map.obj.flg[y][x] = FLG_NULL;

	ix = x + randm( 3 ) - 1;
	iy = y + randm( 3 ) - 1;
	make_item( ix, iy, dun_lev );

	return TRUE;
}

/***************************************************************
* ޥåפγƥ쥤䡼쥤䡼򹹿
* long x : Xɸ
* long y : Yɸ
* long dx : 
* long dy : ⤵
***************************************************************/

void	set_map_total( long x, long y, long dx, long dy )
{
	pos_t	*crsr = get_crsr();
	pos_t	*sub_crsr = get_sub_crsr();
	crsr_ptn_t	*ptn = get_crsr_ptn();
	crsr_ptn_t	*sub_ptn = get_sub_crsr_ptn();

	/* ط */
	set_map_total_bg( x, y, dx, dy );

	/* ° */
	set_map_total_crsr_attr( sub_crsr, sub_ptn, x, y, dx, dy );
	set_map_total_crsr_attr( crsr, ptn, x, y, dx, dy );

	/* ֥ */
	set_map_total_obj( x, y, dx, dy );

	/* 󥫡 */
	set_map_total_square( x, y, dx, dy );

	/* 󥹥ȥС */
	set_map_total_chr( x, y, dx, dy );

	/* Υѥ */
	set_map_total_crsr_ptn( sub_crsr, sub_ptn, x, y, dx, dy );
	set_map_total_crsr_ptn( crsr, ptn, x, y, dx, dy );
}

/***************************************************************
* طʥޥåפ쥤䡼򹹿
* long x : Xɸ
* long y : Yɸ
* long dx : 
* long dy : ⤵
***************************************************************/

void	set_map_total_bg( long x, long y, long dx, long dy )
{
	long	i, j;
	long	xx, yy;
	char	mjr, mnr;
	curs_attr_n_t	attr_n;
	curs_attr_t	*attr_dflt;

	attr_n = CURS_ATTR_N_MAP_NORMAL;
	attr_dflt = get_curs_attr();

	for( i = 0; i < dy; i++ ){
		yy = y + i;
		if( !clip_y( yy ) )
			continue;

		for( j = 0; j < dx; j++ ){
			xx = x + j;
			if( !clip_x( xx ) )
				continue;

			set_face_from_map_obj( TRUE, xx, yy, &mjr, &mnr );

			dun.map.total.mjr[yy][xx] = mjr;
			dun.map.total.mnr[yy][xx] = mnr;
			dun.map.total.flg[yy][xx] = FLG_NULL;
			dun.map.attr[yy][xx] = attr_dflt[attr_n];
		}
	}
}

/***************************************************************
* طʥޥåפθδʸ֤
* long x : Xɸ
* long y : Yɸ
* char *mjr : ᥸㡼δʸ֤
* char *mnr : ޥʡδʸ֤
***************************************************************/

void	set_face_from_map_obj(
	bool_t flg_chk_find, long x, long y, char *mjr, char *mnr
)
{
	flg_map_t	flg;
	long	dep;

	if( mjr != NULL )
		*mjr = FACE_MJR_NULL;
	if( mnr != NULL )
		*mnr = FACE_MNR_NULL;

	if( !clip_pos( x, y ) )
		return;

	if( mjr != NULL )
		*mjr = dun.map.obj.mjr[y][x];
	if( mnr != NULL )
		*mnr = dun.map.obj.mnr[y][x];
	flg = dun.map.obj.flg[y][x];
	dep = calc_light_depth( x, y );

	if( chk_flg( flg, FLG_MAP_OBJ_LOOK_WALL ) ){
		if( mjr != NULL )
			*mjr = FACE_MJR_WALL;
		if( mnr != NULL )
			*mnr = FACE_MNR_WALL;
	}
	if( chk_flg( flg, FLG_MAP_OBJ_LOOK_FLOOR ) ){
		if( mjr != NULL )
			*mjr = FACE_MJR_FLOOR;
		if( mnr != NULL )
			*mnr = FACE_MNR_FLOOR;
	}
	if( flg_chk_find ){
		if( (*mjr == FACE_MJR_FLOOR) && (dep <= 0) ){
			if( mjr != NULL )
				*mjr = FACE_MJR_NULL;
			if( mnr != NULL )
				*mnr = FACE_MNR_NULL;
		}
		if( !chk_flg( flg, FLG_MAP_OBJ_FIND ) ){
			if( mjr != NULL )
				*mjr = FACE_MJR_NULL;
			if( mnr != NULL )
				*mnr = FACE_MNR_NULL;
		}
	}
}

/***************************************************************
* °ޥåפ쥤䡼򹹿
* long x : Xɸ
* long y : Yɸ
* long dx : 
* long dy : ⤵
***************************************************************/

void	set_map_total_crsr_attr(
	pos_t *crsr, crsr_ptn_t *ptn, long x, long y, long dx, long dy
)
{
	long	i, j;
	long	xx, yy;
	curs_attr_n_t	attr_n;
	curs_attr_t	*attr_dflt;

	if( crsr == NULL )
		return;
	if( ptn == NULL )
		return;
	if( !clip_pos( crsr->x, crsr->y ) )
		return;

	attr_dflt = get_curs_attr();
	attr_n = CURS_ATTR_N_MAP_CRSR;
	for( i = 0; i < ptn->y_len; i++ ){
		yy = crsr->y + i + ptn->y;
		if( !clip_y( yy ) )
			continue;

		for( j = 0; j < ptn->x_len; j++ ){
			long	c;

			xx = crsr->x + j + ptn->x;
			if( !clip_x( xx ) )
				continue;

			c = ptn->face[i][j * 2 + 0];
			if( c != ptn->transmit_chr )
				dun.map.attr[yy][xx] = attr_dflt[attr_n];

			c = ptn->face[i][j * 2 + 1];
			if( c != ptn->transmit_chr )
				dun.map.attr[yy][xx] = attr_dflt[attr_n];
		}
	}
}

/***************************************************************
* ֥ȤΥޥåפ쥤䡼򹹿
* long x : Xɸ
* long y : Yɸ
* long dx : 
* long dy : ⤵
***************************************************************/

void	set_map_total_obj( long x, long y, long dx, long dy )
{
	long	i, j;
	long	xx, yy;
	char	mjr, mnr;
	flg_map_t	flg;
	long	dep;
	curs_attr_n_t	attr_n;
	curs_attr_t	*attr_dflt;

	attr_n = CURS_ATTR_N_MAP_ITEM;
	attr_dflt = get_curs_attr();

	for( i = 0; i < dy; i++ ){
		yy = y + i;
		if( !clip_y( yy ) )
			continue;

		for( j = 0; j < dx; j++ ){
			xx = x + j;
			if( !clip_x( xx ) )
				continue;

			mjr = dun.map.obj.mjr[yy][xx];
			mnr = dun.map.obj.mnr[yy][xx];
			flg = dun.map.obj.flg[yy][xx];
			dep = calc_light_depth( xx, yy );

			if( mjr == FACE_MJR_FLOOR )
				continue;
			if( mjr == FACE_MJR_WALL )
				continue;
			if( chk_flg( flg, FLG_MAP_OBJ_LOOK_WALL ) )
				continue;
			if( chk_flg( flg, FLG_MAP_OBJ_LOOK_FLOOR ) )
				continue;
			if( (mjr == FACE_MJR_FLOOR) && (dep <= 0) )
				continue;
			if( !chk_flg( flg, FLG_MAP_OBJ_FIND ) )
				continue;

			dun.map.total.mjr[yy][xx] = mjr;
			dun.map.total.mnr[yy][xx] = mnr;
			dun.map.total.flg[yy][xx] = FLG_NULL;
			dun.map.attr[yy][xx] = attr_dflt[attr_n];
		}
	}
}

/***************************************************************
* 󥫡Υޥåפ쥤䡼򹹿
* long x : Xɸ
* long y : Yɸ
* long dx : 
* long dy : ⤵
***************************************************************/

void	set_map_total_square( long x, long y, long dx, long dy )
{
	long	i, j;
	long	xx, yy;
	curs_attr_t	*attr_dflt;
	party_t	*pty;

	attr_dflt = get_curs_attr();
	pty = get_party();

	if( !clip_pos( pty->square.x, pty->square.y ) )
		return;

	for( i = -1; i <= +1; i++ ){
		yy = pty->square.y + i;
		if( !clip_y( yy ) )
			continue;

		for( j = -1; j <= +1; j++ ){
			mbr_t	*mbr;

			xx = pty->square.x + j;
			if( !clip_x( xx ) )
				continue;

			if( pty->square.chr_dir[i + 1][j + 1] == MBR_NO_POS )
				continue;

			dun.map.total.mjr[yy][xx] = FACE_MJR_SQUARE;
			dun.map.attr[yy][xx]
					= attr_dflt[CURS_ATTR_N_MAP_SQUARE];

			mbr = pty->mbr[pty->square.chr_dir[i + 1][j + 1]];
			if( chk_flg( mbr->stat, FLG_STAT_NOT_EXIST ) ){
				continue;
			}

			dun.map.total.mnr[yy][xx] = mbr->face.mnr;
		}
	}
}

/***************************************************************
* 󥹥ȥСΥޥåפ쥤䡼򹹿
* long x : Xɸ
* long y : Yɸ
* long dx : 
* long dy : ⤵
***************************************************************/

void	set_map_total_chr( long x, long y, long dx, long dy )
{
	long	i, j;
	long	xx, yy;
	char	mjr, mnr;
	flg_map_t	flg, flg_total;
	chr_t	*chr_p;
	curs_attr_n_t	attr_n;
	curs_attr_t	*attr_dflt;

	attr_dflt = get_curs_attr();

	for( i = 0; i < dy; i++ ){
		yy = y + i;
		if( !clip_y( yy ) )
			continue;
		for( j = 0; j < dx; j++ ){
			bool_t	flg_rev_rev;

			xx = x + j;
			if( !clip_x( xx ) )
				continue;

			flg_total = dun.map.total.flg[yy][xx];

			mjr = dun.map.chr.mjr[yy][xx];
			mnr = dun.map.chr.mnr[yy][xx];
			flg = dun.map.chr.flg[yy][xx];
			chr_p = dun.map.chr_p[yy][xx];
			attr_n = CURS_ATTR_N_NORMAL;
			flg_rev_rev = FALSE;

			if( mjr == FACE_MJR_NULL ){
				continue;
			} else if( chr_p == NULL ){
				continue;
			} else if( chr_p->kind == CHR_KIND_MBR ){
				mbr_t	*p;

				/* Сä */
				p = get_mbr( xx, yy );
				if( p != NULL ){
					attr_n = (curs_attr_n_t)
							(CURS_ATTR_N_MBR_1
							+ p->mbr_n);
				}
				if( chk_flg( flg, FLG_MAP_CHR_INVISIBLE ) ){
					/* Ʃʤ */
					flg_rev_rev = TRUE;
				}
			} else if( chr_p->kind == CHR_KIND_MNSTR ){
				/* 󥹥ä */
				if( !chk_flg( flg, FLG_MAP_CHR_FIND ) ){
					/* ĤäƤʤ */
					continue;
				}
				if( chk_flg( flg, FLG_MAP_CHR_NPC ) ){
					attr_n = CURS_ATTR_N_MAP_NPC;
				} else {
					attr_n = CURS_ATTR_N_MAP_MNSTR;
				}
			} else {
				continue;
			}

			dun.map.total.mjr[yy][xx] = mjr;
			dun.map.total.mnr[yy][xx] = mnr;
			dun.map.total.flg[yy][xx] = flg_total;
			dun.map.attr[yy][xx] = attr_dflt[attr_n];
			if( flg_rev_rev )
				dun.map.attr[yy][xx].attr ^= A_REVERSE;
		}
	}
}

/***************************************************************
* ΥѥΥޥåפ쥤䡼򹹿
* long x : Xɸ
* long y : Yɸ
* long dx : 
* long dy : ⤵
***************************************************************/

void	set_map_total_crsr_ptn(
	pos_t *crsr, crsr_ptn_t *ptn,
	long x, long y, long dx, long dy
)
{
	long	i, j;
	long	xx, yy;

	if( crsr == NULL )
		return;
	if( ptn == NULL )
		return;
	if( !clip_pos( crsr->x, crsr->y ) )
		return;

	for( i = 0; i < ptn->y_len; i++ ){
		yy = crsr->y + i + ptn->y;
		if( !clip_y( yy ) )
			continue;

		for( j = 0; j < ptn->x_len; j++ ){
			long	c;

			xx = crsr->x + j + ptn->x;
			if( !clip_x( xx ) )
				continue;

			/* ͭ륢ȥӥ塼Ȥ褹 */

			c = ptn->face[i][j * 2 + 0];
			if( c == '\0' )
				break;
			if( c != ptn->transmit_chr )
				dun.map.total.mjr[yy][xx] = (char)c;

			c = ptn->face[i][j * 2 + 1];
			if( c == '\0' )
				break;
			if( c != ptn->transmit_chr )
				dun.map.total.mnr[yy][xx] = (char)c;
		}
	}
}

/***************************************************************
* ϩ
* long x1 : Xɸ
* long y1 : Yɸ
* long x2 : Xɸ
* long y2 : Yɸ
* sect_t sect : ʸ
***************************************************************/

void	line_path( long x1, long y1, long x2, long y2, sect_t sect )
{
	long	i;

	if( y1 == y2 ){	/* ʿ */
		if( x1 > x2 ){
			long	xx;

			xx = x1;
			x1 = x2;
			x2 = xx;
		}
		for( i = x1; i <= x2; i++ ){
			put_path( i, y1, +1, 0, sect );
		}
	} else if( x1 == x2 ){	/* ľ */
		if( y1 > y2 ){
			long	yy;

			yy = y1;
			y1 = y2;
			y2 = yy;
		}
		for( i = y1; i <= y2; i++ ){
			put_path( x1, i, 0, +1, sect );
		}
	}
}

/***************************************************************
* ɸϩ
* long x : Xɸ
* long y : Yɸ
* long dx : 
* long dy : ⤵
* sect_t sect : ʸ
***************************************************************/

void	put_path( long x, long y, long dx, long dy, sect_t sect )
{
	long	i, j;
	sect_t	dflt_sect;
	long	xx, yy;


	if( dx < 0 ){
		dflt_sect = SECT_PATH_W;
	} else if( dx > 0 ){
		dflt_sect = SECT_PATH_E;
	} else if( dy < 0 ){
		dflt_sect = SECT_PATH_N;
	} else if( dy > 0 ){
		dflt_sect = SECT_PATH_S;
	} else {
		dflt_sect = SECT_PATH_N;
	}

	if( sect == SECT_PATH_DFLT )
		sect = dflt_sect;

	for( i = 0; i < PATH_WIDTH; i++ ){
		yy = y + i;
		for( j = 0; j < PATH_WIDTH; j++ ){
			xx = x + j;
			dun.map.sect[yy][xx] = sect;

			if( dun.map.obj.mjr[yy][xx] != FACE_MJR_WALL ){
				continue;
			}

			dun.map.obj.mjr[yy][xx] = FACE_MJR_FLOOR;
			dun.map.obj.mnr[yy][xx] = FACE_MNR_FLOOR;
			dun.map.obj.flg[yy][xx] |= FLG_MAP_OBJ_PASS;
		}
	}
}

/***************************************************************
* ɥ򳫤
* long n : ɥֹ
* return : ɥ?
***************************************************************/

bool_t	open_door( long n )
{
	flg_door_t	flg;

	if( n < 0 )
		return FALSE;
	if( n >= dun.door_n )
		return FALSE;

	flg = dun.door[n].flg;

	if( chk_flg_or( flg, FLG_DOOR_SECRET | FLG_DOOR_JAMMED ) )
		return FALSE;
	if( chk_flg( flg, FLG_DOOR_GATE ) )
		return FALSE;

	dun.door[n].flg |= FLG_DOOR_OPEN;
	set_face_door( n );

	draw_door( n );

	return TRUE;
}

/***************************************************************
* ɥĤ
* long n : ɥֹ
* return : ɥĤ?
***************************************************************/

bool_t	close_door( long n )
{
	flg_door_t	flg;
	long	i, j;

	if( n < 0 )
		return FALSE;
	if( n >= dun.door_n )
		return FALSE;

	flg = dun.door[n].flg;

	if( chk_flg( flg, FLG_DOOR_SECRET ) )
		return FALSE;
	if( chk_flg( flg, FLG_DOOR_OPEN ) )
		if( chk_flg_or( flg, FLG_DOOR_JAMMED | FLG_DOOR_BROKEN ) )
			return FALSE;
	if( chk_flg( flg, FLG_DOOR_GATE ) )
		return FALSE;

	/* 饯ɥξˤ뤫 */
	for( i = 0; i < dun.door[n].dy; i++ ){
		for( j = 0; j < dun.door[n].dx; j++ ){
			long	x, y;

			x = dun.door[n].x + j;
			y = dun.door[n].y + i;
			if( dun.map.chr.mjr[y][x] != FACE_MJR_NULL ){
				return FALSE;
			}
		}
	}

	dun.door[n].flg &= ~FLG_DOOR_OPEN;
	set_face_door( n );

	draw_door( n );

	return TRUE;
}

/***************************************************************
* ɥ
* long n : ɥֹ
* return : ɥǤ?
***************************************************************/

bool_t	jam_door( long n )
{
	if( n < 0 )
		return FALSE;
	if( n >= dun.door_n )
		return FALSE;

	if( chk_flg( dun.door[n].flg, FLG_DOOR_SECRET ) )
		return FALSE;
	if( chk_flg( dun.door[n].flg, FLG_DOOR_BROKEN ) ){
		print_msg( FLG_NULL, MSG_ERR_DOOR_JAM_BROKEN );
		return FALSE;
	}
	if( chk_flg( dun.door[n].flg, FLG_DOOR_JAMMED ) ){
		print_msg( FLG_NULL, MSG_ERR_DOOR_JAM_JAMMED );
		return FALSE;
	}
	if( chk_flg( dun.door[n].flg, FLG_DOOR_GATE ) )
		return FALSE;

	dun.door[n].flg |= FLG_DOOR_JAMMED;
	set_face_door( n );

	draw_door( n );

	return TRUE;
}

/***************************************************************
* ɥθ
* long n : ɥֹ
* return : ɥθǤ?
***************************************************************/

bool_t	disarm_door( long n )
{
	if( n < 0 )
		return FALSE;
	if( n >= dun.door_n )
		return FALSE;

	if( chk_flg( dun.door[n].flg, FLG_DOOR_SECRET ) )
		return FALSE;
	if( chk_flg( dun.door[n].flg, FLG_DOOR_BROKEN ) ){
		print_msg( FLG_NULL, MSG_ERR_DOOR_DISARM_BROKEN );
		return FALSE;
	}
	if( !chk_flg( dun.door[n].flg, FLG_DOOR_JAMMED ) ){
		print_msg( FLG_NULL, MSG_ERR_DOOR_DISARM_NOT_JAM );
		return FALSE;
	}
	if( chk_flg( dun.door[n].flg, FLG_DOOR_GATE ) )
		return FALSE;

	dun.door[n].flg &= ~(FLG_DOOR_JAMMED);
	set_face_door( n );

	draw_door( n );

	return TRUE;
}

/***************************************************************
* ɥĴ٤
* long n : ɥֹ
* return : ɥĴ٤줿?
***************************************************************/

bool_t	srch_door( long n )
{
	if( n < 0 )
		return FALSE;
	if( n >= dun.door_n )
		return FALSE;

	dun.door[n].flg |= FLG_DOOR_CHKED;
	dun.door[n].flg &= ~(FLG_DOOR_SECRET);
	set_face_door( n );

	draw_door( n );

	return TRUE;
}

/***************************************************************
* ϰϤΥɥĴ٤
* long x : Xɸ
* long y : Yɸ
* long r : Ⱦ
***************************************************************/

void	detect_door( long x, long y, long r )
{
	long	n;

	for( n = 0; n < dun.door_n; n++ ){
		if( (dun.door[n].x + dun.door[n].dx - 1) < (x - r) )
			continue;
		if( (x + r) < dun.door[n].x )
			continue;
		if( (dun.door[n].y + dun.door[n].dy - 1) < (y - r) )
			continue;
		if( (y + r) < dun.door[n].y )
			continue;

		srch_door( n );
	}
}

/***************************************************************
* ɸΥޥåפȯ
* long x : Xɸ
* long y : Yɸ
***************************************************************/

void	find_obj( long x, long y )
{
	long	i, j;
	long	sx, sy;
	flg_map_t	flg;
	long	dep;
	bool_t	flg_redraw;

	flg_redraw = FALSE;

	for( i = -1; i <= +1; i++ ){
		sy = y + i;
		if( !clip_y( sy ) )
			continue;
		for( j = -1; j <= +1; j++ ){
			sx = x + j;
			if( !clip_x( sx ) )
				continue;

			flg = dun.map.obj.flg[sy][sx];
			dep = dun.map.light_depth_obj[sy][sx];
			if( !chk_flg( flg, FLG_MAP_OBJ_FIND ) && (dep > 0) ){
				find_obj_fill( sx, sy );
				flg_redraw = TRUE;
			}
		}
	}

	if( flg_redraw )
		redraw_map();
}

/***************************************************************
* ΤĤƤ륻äˡ
* Υȯ
* long x : Xɸ
* long y : Yɸ
***************************************************************/

void	find_obj_fill( long x, long y )
{
	long	ax, ay;
	long	sx, sy;
	long	dx, dy;
	sect_t	sect;

	ax = x / AREA_MAX_X * AREA_MAX_X;
	ay = y / AREA_MAX_Y * AREA_MAX_Y;
	sect = dun.map.sect[y][x];

	for( dy = 0; dy < AREA_MAX_Y; dy++ ){
		sy = ay + dy;
		for( dx = 0; dx < AREA_MAX_X; dx++ ){
			sx = ax + dx;

			if( dun.map.sect[sy][sx] != sect )
				continue;
			if( !chk_flg( dun.map.obj.flg[sy][sx],
					FLG_MAP_OBJ_PASS ) )
				continue;

			find_obj_fill_field( sx, sy );
		}
	}
}

/***************************************************************
* ꥻȯ
* long x : Xɸ
* long y : Yɸ
***************************************************************/

void	find_obj_fill_field( long x, long y )
{
	long	i, j;
	long	sx, sy;

	for( i = -1; i <= +1; i++ ){
		sy = y + i;
		if( !clip_y( sy ) )
			continue;
		for( j = -1; j <= +1; j++ ){
			sx = x + j;
			if( !clip_x( sx ) )
				continue;

			dun.map.obj.flg[sy][sx] |= FLG_MAP_OBJ_FIND;
		}
	}
}

/***************************************************************
* ꥢĤ
* long x : Xɸ
* long y : Yɸ
* bool_t flg_find : ȯ뤫?
***************************************************************/

void	on_light_area( long x, long y, bool_t flg_find )
{
	turn_light_area( x, y, TRUE, flg_find );
}

/***************************************************************
* ꥢä
* long x : Xɸ
* long y : Yɸ
* bool_t flg_find : ȯ뤫?
***************************************************************/

void	off_light_area( long x, long y, bool_t flg_find )
{
	turn_light_area( x, y, FALSE, flg_find );
}

/***************************************************************
* ꥢĤäꤹ
* long x : Xɸ
* long y : Yɸ
* bool_t flg_on : Ĥ뤫ä?
* bool_t flg_find : ȯ뤫?
***************************************************************/

void	turn_light_area( long x, long y, bool_t flg_on, bool_t flg_find )
{
	sect_t	sect;
	long	ax, ay;
	long	dx, dy;

	sect = dun.map.sect[y][x];

	ax = ((int)(x / AREA_MAX_X)) * AREA_MAX_X;
	ay = ((int)(y / AREA_MAX_Y)) * AREA_MAX_Y;
	for( dy = 0; dy < AREA_MAX_Y; dy++ ){
		for( dx = 0; dx < AREA_MAX_X; dx++ ){
			turn_light_field( ax + dx, ay + dy, sect,
					flg_on, flg_find );
		}
	}

	redraw_map();
}

/***************************************************************
* ɸĤäꤹ
* long x : Xɸ
* long y : Yɸ
* sect_t sect : ʸ
* bool_t flg_on : Ĥ뤫ä?
* bool_t flg_find : ȯ뤫?
***************************************************************/

void	turn_light_field(
	long x, long y, sect_t sect, bool_t flg_on, bool_t flg_find
)
{
	long	dx, dy;
	long	sx, sy;
	bool_t	flg_on_depth;

	sx = 0;
	sy = 0;
	for( dy = -1; dy <= +1; dy++ ){
		sy = y + dy;
		if( !clip_y( sy ) )
			continue;

		for( dx = -1; dx <= +1; dx++ ){
			sx = x + dx;
			if( !clip_x( sx ) )
				continue;

			if( dun.map.sect[sy][sx] != sect )
				continue;

			if( !chk_flg( dun.map.obj.flg[sy][sx],
					FLG_MAP_OBJ_PASS ) )
				continue;

			if( chk_flg( dun.map.obj.flg[sy][sx],
					FLG_MAP_OBJ_LOOK_WALL ) )
				continue;

			/**/

			flg_on_depth = turn_light_obj( x, y, flg_on );
			if( flg_on_depth && flg_find )
				dun.map.obj.flg[y][x] |= FLG_MAP_OBJ_FIND;
			return;
		}
	}
}

/***************************************************************
* ɥĤäꤹ
* door_t *dr : ɥ
* bool_t flg_on : Ĥ뤫ä?
* bool_t flg_find : ȯ뤫?
***************************************************************/

void	turn_light_door( door_t *dr, bool_t flg_on, bool_t flg_find )
{
	long	dx, dy;

	for( dy = 0; dy < dr->dy; dy++ ){
		for( dx = 0; dx < dr->dx; dx++ ){
			long	sx, sy;
			bool_t	flg_on_depth;

			sx = dr->x + dx;
			sy = dr->y + dy;

			flg_on_depth = turn_light_obj( sx, sy, flg_on );
			if( flg_on_depth && flg_find )
				dun.map.obj.flg[sy][sx] |= FLG_MAP_OBJ_FIND;
		}
	}

	draw_door( dr->n );
}

/***************************************************************
* ꥪ֥ȤˤĤäꤹ
* long x : Xɸ
* long y : Yɸ
* bool_t flg_on : Ĥ뤫ä?
* return : 뤯ʤä?
***************************************************************/

bool_t	turn_light_obj( long x, long y, bool_t flg_on )
{
	if( flg_on )
		dun.map.light_depth_obj[y][x]++;
	else
		dun.map.light_depth_obj[y][x]--;

	return( dun.map.light_depth_obj[y][x] > 0 );
}

/***************************************************************
* 饯ˤĤäꤹ
* long x : Xɸ
* long y : Yɸ
* bool_t flg_on : Ĥ뤫ä?
* return : 뤯ʤä?
***************************************************************/

bool_t	turn_light_chr( long x, long y, bool_t flg_on )
{
	if( flg_on )
		dun.map.light_depth_chr[y][x]++;
	else
		dun.map.light_depth_chr[y][x]--;

	return( dun.map.light_depth_chr[y][x] > 0 );
}

/***************************************************************
* ɸ뤵οĴ٤
* long x : Xɸ
* long y : Yɸ
* return : 뤵ο
***************************************************************/

long	calc_light_depth( long x, long y )
{
	long	depth;

	depth = 0;
	depth += dun.map.light_depth_obj[y][x];
	depth += dun.map.light_depth_chr[y][x];

	return depth;
}

/***************************************************************
* 2֤λ̤äƤ뤫ʸƤ뤫Ĵ٤
* pos_t *pos1 : ɸ
* pos_t *pos2 : ɸ
* return : ̤äƤ뤫?
***************************************************************/

bool_t	chk_find( pos_t *pos1, pos_t *pos2 )
{
	long	x1, y1, x2, y2, e;
	long	dx2, dy2, sgn_y;
	long	x, y;

	if( pos1->x < pos2->x ){
		x1 = pos1->x;
		y1 = pos1->y;
		x2 = pos2->x;
		y2 = pos2->y;
	} else {
		x1 = pos2->x;
		y1 = pos2->y;
		x2 = pos1->x;
		y2 = pos1->y;
	}

	dx2 = 2 * (x2 - x1);
	dy2 = 2 * labs( y2 - y1 );
	if( y1 <= y2 )
		sgn_y = +1;
	else
		sgn_y = -1;
	e = -(x2 - x1);
	x = x1;
	y = y1;

	for( ; x <= x2; x++ ){
		if( e < 0 ){
			if( !chk_flg( dun.map.obj.flg[y][x],
					FLG_MAP_OBJ_PASS ) ){
				return FALSE;
			}
		} else {
			do {
				y += sgn_y;
				if( sgn_y >= +1 ){
					if( y > y2 )
						break;
				} else {
					if( y < y2 )
						break;
				}
				e -= dx2;
				if( !chk_flg( dun.map.obj.flg[y][x],
						FLG_MAP_OBJ_PASS ) ){
					return FALSE;
				}
			} while( e >= 0 );
		}
		e += dy2;
	}

	return TRUE;
}

/***************************************************************
* µܤΥǡ֤
* return : µܤΥǡ
***************************************************************/

dun_t	*get_dun( void )
{
	return &dun;
}

/***************************************************************
* µܤθߤγؤ֤
* return : ߤγ
***************************************************************/

long	get_dun_lev( void )
{
	return dun.lev;
}

/***************************************************************
* ɸˤɥΥǡ֤
* long x : Xɸ
* long y : Yɸ
* return : ɥΥǡ
***************************************************************/

door_t	*get_door( long x, long y )
{
	long	i;
	door_t	*dr;

	for( i = 0; i < dun.door_n; i++ ){
		dr = &(dun.door[i]);
		if( (dr->x <= x) && (x <= dr->x + dr->dx)
				&& (dr->y <= y) && (y <= dr->y + dr->dy) ){
			return dr;
		}
	}
	return NULL;
}

/***************************************************************
* ɸ1ֶᤤɥΥǡ֤
* long x : Xɸ
* long y : Yɸ
* act_kind_t act_kind : ɥФ륢
* return : ɥΥǡ
***************************************************************/

door_t	*get_door_nearest( long x, long y, act_kind_t act_kind )
{
	long	dr_n;
	door_t	*p, *ret_p;
	long	min_r, tmp_r;
	long	n;

	min_r = MAP_MAX_X + MAP_MAX_Y;
	ret_p = NULL;
	n = 0;
	for( dr_n = 0; dr_n < dun.door_n; dr_n++ ){
		pos_t	pos1, pos2;
		long	dx, dy;

		p = &(dun.door[dr_n]);

		if( !chk_mark_door( p, act_kind ) )
			continue;
		if( !chk_find_door( dr_n ) )
			continue;

		set_door_pos_chk_find( p, x, y, &pos1, &dx, &dy );
		tmp_r = dx + dy;
		if( tmp_r > min_r )
			continue;

		pos2.x = x;
		pos2.y = y;
		if( !chk_find( &pos1, &pos2 ) )
			continue;

		if( tmp_r < min_r ){
			n = 0;
			min_r = tmp_r;
		} else if( tmp_r == min_r ){
			n++;
			if( randm( n ) != 0 )
				continue;
		}

		ret_p = p;
	}

	return ret_p;
}

/***************************************************************
* ɸˤʤ٤ᤤɥΥǡ֤
* long x : Xɸ
* long y : Yɸ
* act_kind_t act_kind : ɥФ륢
* return : ɥΥǡ
***************************************************************/

door_t	*get_door_near( long x, long y, act_kind_t act_kind )
{
	long	dr_n;
	door_t	*p, *ret_p;
	long	min_r, tmp_r;
	long	n;

	min_r = MAP_MAX_X + MAP_MAX_Y;
	ret_p = NULL;
	n = 0;
	for( dr_n = 0; dr_n < dun.door_n; dr_n++ ){
		pos_t	pos1, pos2;
		long	dx, dy;

		p = &(dun.door[dr_n]);

		if( !chk_mark_door( p, act_kind ) )
			continue;
		if( !chk_find_door( dr_n ) )
			continue;

		set_door_pos_chk_find( p, x, y, &pos1, &dx, &dy );
		tmp_r = dx + dy;

		pos2.x = x;
		pos2.y = y;
		if( !chk_find( &pos1, &pos2 ) )
			continue;

		if( tmp_r < min_r ){
			n = 0;
			min_r = tmp_r;
		} else if( (tmp_r - min_r) <= DOOR_NEAR_R ){
			n++;
			if( randm( n ) != 0 )
				continue;
		}

		ret_p = p;
	}

	return ret_p;
}

/***************************************************************
* ѡƥǡФ餱ɥΥǡ֤
* mbr_t *mbr : С
* act_kind_t act_kind : ɥФ륢
* return : ɥΥǡ
***************************************************************/

door_t	*get_door_disperse( mbr_t *mbr, act_kind_t act_kind )
{
	long	dr_n;
	door_t	*p, *ret_p;
	long	min_r, tmp_r;
	long	n;
	long	x, y;

	x = mbr->x;
	y = mbr->y;

	min_r = MAP_MAX_X + MAP_MAX_Y;
	ret_p = NULL;
	n = 0;
	for( dr_n = 0; dr_n < dun.door_n; dr_n++ ){
		pos_t	pos1, pos2;
		long	dx, dy;

		p = &(dun.door[dr_n]);

		if( !chk_mark_door( p, act_kind ) )
			continue;
		if( !chk_find_door( dr_n ) )
			continue;

		set_door_pos_chk_find( p, x, y, &pos1, &dx, &dy );
		tmp_r = dx + dy;
		if( tmp_r > min_r )
			continue;

		if( chk_already_mark( p, mbr ) )
			continue;
		pos2.x = x;
		pos2.y = y;
		if( !chk_find( &pos1, &pos2 ) )
			continue;

		if( tmp_r < min_r ){
			n = 0;
			min_r = tmp_r;
		} else if( tmp_r == min_r ){
			n++;
			if( randm( n ) != 0 )
				continue;
		}

		ret_p = p;
	}

	return ret_p;
}

/***************************************************************
* Ƥϰǡ˥ɥΥǡ֤
* long x : Xɸ
* long y : Yɸ
* act_kind_t act_kind : ɥФ륢
* return : ɥΥǡ
***************************************************************/

door_t	*get_door_randm( long x, long y, act_kind_t act_kind )
{
	long	dr_n;
	door_t	*p, *ret_p;
	long	n;

	ret_p = NULL;
	n = 0;
	for( dr_n = 0; dr_n < dun.door_n; dr_n++ ){
		pos_t	pos1, pos2;
		long	dx, dy;

		p = &(dun.door[dr_n]);

		if( !chk_mark_door( p, act_kind ) )
			continue;
		if( !chk_find_door( dr_n ) )
			continue;

		set_door_pos_chk_find( p, x, y, &pos1, &dx, &dy );

		pos2.x = x;
		pos2.y = y;
		if( !chk_find( &pos1, &pos2 ) )
			continue;

		n++;
		if( randm( n ) == 0 )
			ret_p = p;
	}

	return ret_p;
}

/***************************************************************
* ν̱˶ᤤʥɥΥǡ֤
* long x : Xɸ
* long y : Yɸ
* long r : Ⱦ
* return : ɥΥǡ
***************************************************************/

door_t	*get_door_towner( long x, long y, long r )
{
	door_t	*ret, *dr;
	long	n;
	long	xx, yy;
	long	dx, dy;
	char	mjr;

	ret = NULL;
	n = 0;
	for( dy = -r; dy <= +r; dy++ ){
		yy = y + dy;
		if( !clip_y( yy ) )
			continue;

		for( dx = -r; dx <= +r; dx++ ){
			xx = x + dx;
			if( !clip_x( xx ) )
				continue;

			mjr = dun.map.obj.mjr[yy][xx];
			if( mjr != FACE_MJR_DOOR_OPEN )
				if( mjr != FACE_MJR_DOOR_CLOSE )
					continue;

			dr = get_door( xx, yy );
			if( dr != NULL ){
				n++;
				if( per_randm( n ) ){
					ret = dr;
				}
			}
		}
	}

	return ret;
}

/***************************************************************
* ΥɥȺɸå˻ȤɸȵΥ֤
* door_t *p : ɥ
* long x :  x ɸ
* long y :  y ɸ
* pos_t *pos : å˻Ȥɸ֤
* long *dx : x εΥ֤
* long *dy : y εΥ֤
***************************************************************/

void	set_door_pos_chk_find(
	door_t *p, long x, long y, pos_t *pos, long *dx, long *dy
)
{
	if( p == NULL )
		return;
	if( pos == NULL )
		return;
	if( dx == NULL )
		return;
	if( dy == NULL )
		return;

	if( p->x > x ){
		*dx = labs( p->x - x );
		pos->x = p->x - 1;
	} else if( (p->x + p->dx - 1) < x ){
		*dx = labs( x - (p->x + p->dx - 1) );
		pos->x = p->x + p->dx - 1 + 1;
	} else {
		*dx = labs( p->x - x );
		pos->x = x;
	}

	if( p->y > y ){
		*dy = labs( p->y - y );
		pos->y = p->y - 1;
	} else if( (p->y + p->dy - 1) < y ){
		*dy = labs( y - (p->y + p->dy - 1) );
		pos->y = p->y + p->dy - 1 + 1;
	} else {
		*dy = labs( p->y - y );
		pos->y = y;
	}
}

/***************************************************************
* ΥɥФơ󤬼¹ԲǽĴ٤
* door_t *p : ɥ
* act_kind_t act_kind : ɥФ륢
* return : 󤬼¹Բǽ?
***************************************************************/

bool_t	chk_mark_door( door_t *p, act_kind_t act_kind )
{
	switch( act_kind ){
	case ACT_KIND_DOOR_OPEN:
		if( chk_flg( p->flg, FLG_DOOR_OPEN ) )
			return FALSE;
		break;
	case ACT_KIND_DOOR_CLOSE:
		if( !chk_flg( p->flg, FLG_DOOR_OPEN ) )
			return FALSE;
		break;
	case ACT_KIND_DOOR_JAM:
		if( chk_flg( p->flg, FLG_DOOR_JAMMED ) )
			return FALSE;
		break;
	case ACT_KIND_DOOR_DISARM:
		if( !chk_flg( p->flg, FLG_DOOR_CHKED ) )
			break;
		if( !chk_flg( p->flg, FLG_DOOR_JAMMED ) )
			return FALSE;
		break;
	case ACT_KIND_DOOR_BREAK:
		if( chk_flg( p->flg, FLG_DOOR_BROKEN ) )
			return FALSE;
		break;
	case ACT_KIND_DOOR_PEEP:
		if( chk_flg( p->flg, FLG_DOOR_OPEN ) )
			return FALSE;
		break;
	case ACT_KIND_DOOR_CHK:
		if( chk_flg( p->flg, FLG_DOOR_CHKED ) )
			return FALSE;
		break;
	default:
		return FALSE;
	}

	return TRUE;
}

/***************************************************************
* ʤ
* return : 夬줿?
***************************************************************/

bool_t	up_stairs( void )
{
	if( !chk_stairs( FACE_MJR_STAIRS_UP ) ){
		print_msg( FLG_NULL, MSG_ERR_STAIRS_UP );
		return FALSE;
	}
	print_msg( FLG_NULL, MSG_UP_DUN );
	up_dun( +1 );

	return TRUE;
}

/***************************************************************
* ʤ򲼤
* return : 줿?
***************************************************************/

bool_t	down_stairs( void )
{
	if( !chk_stairs( FACE_MJR_STAIRS_DOWN ) ){
		print_msg( FLG_NULL, MSG_ERR_STAIRS_DOWN );
		return FALSE;
	}
	print_msg( FLG_NULL, MSG_DOWN_DUN );
	up_dun( -1 );

	return TRUE;
}

/***************************************************************
* ʤ겼뤫Ĵ٤
* long face : ʤμδʸ
* return : 겼뤫?
***************************************************************/

bool_t	chk_stairs( long face )
{
	party_t	*pty;
	bool_t	flg;
	long	i;
	long	x, y;

	if( (face == FACE_MJR_STAIRS_DOWN)
			|| (face == FACE_MNR_STAIRS_DOWN) ){
		face = FACE_MJR_STAIRS_DOWN;
	} else {
		face = FACE_MJR_STAIRS_UP;
	}

	pty = get_party();

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg_or( pty->mbr[i]->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		flg = FALSE;
		for( y = -STAIRS_MAX_R; y <= +STAIRS_MAX_R; y++ ){
			for( x = -STAIRS_MAX_R; x <= +STAIRS_MAX_R; x++ ){
				long	mx, my;

				mx = pty->mbr[i]->x + x;
				my = pty->mbr[i]->y + y;
				if( dun.map.obj.mjr[my][mx] == face ){
					flg = TRUE;
				}
			}
		}
		if( !flg )
			return FALSE;
	}

	return TRUE;
}

/***************************************************************
* ɸɤĴ٤
* long x : Xɸ
* long y : Yɸ
* return : ɤ?
***************************************************************/

bool_t	is_map_wall( long x, long y )
{
	if( !clip_x( x ) )
		return TRUE;
	if( !clip_y( y ) )
		return TRUE;
	if( dun.map.obj.mjr[y][x] == FACE_MJR_WALL )
		return TRUE;
	if( chk_flg( dun.map.obj.flg[y][x], FLG_MAP_OBJ_LOOK_WALL ) )
		return TRUE;

	return FALSE;
}

/***************************************************************
* ɸޥåפͭϰ⤫Ĵ٤
* long x : Xɸ
* long y : Yɸ
* return : ޥåפͭϰ⤫?
***************************************************************/

bool_t	clip_pos( long x, long y )
{
	if( !clip_x( x ) )
		return FALSE;
	if( !clip_y( y ) )
		return FALSE;

	return TRUE;
}

/***************************************************************
* Xɸޥåפͭϰ⤫Ĵ٤
* long n : Xɸ
* return : ޥåפͭϰ⤫?
***************************************************************/

bool_t	clip_x( long n )
{
	if( n == MAP_DEL_X )
		return FALSE;
	if( n < 0 )
		return FALSE;
	if( n >= MAP_MAX_X )
		return FALSE;

	return TRUE;
}

/***************************************************************
* Yɸޥåפͭϰ⤫Ĵ٤
* long n : Yɸ
* return : ޥåפͭϰ⤫?
***************************************************************/

bool_t	clip_y( long n )
{
	if( n == MAP_DEL_Y )
		return FALSE;
	if( n < 0 )
		return FALSE;
	if( n >= MAP_MAX_Y )
		return FALSE;

	return TRUE;
}

/***************************************************************
* ɸޥåפɽϰ⤫Ĵ٤
* long x : Xɸ
* long y : Yɸ
* return : ޥåפɽϰ⤫?
***************************************************************/

bool_t	clip_draw_pos( long x, long y )
{
	if( !clip_draw_x( x ) )
		return FALSE;
	if( !clip_draw_y( y ) )
		return FALSE;

	return TRUE;
}

/***************************************************************
* Xɸޥåפɽϰ⤫Ĵ٤
* long n : Xɸ
* return : ޥåפɽϰ⤫?
***************************************************************/

bool_t	clip_draw_x( long n )
{
	pos_t	*draw;

	if( n == MAP_DEL_X )
		return FALSE;

	if( g_flg_cui ){
		draw = get_map_draw_pos();
		if( (draw->x <= n)
				&& (n <= (draw->x + WIN_MAP_WIDTH - 1)) ){
			return TRUE;
		}
	}
	if( g_flg_gui ){
		if( call_pcg_dun_clip_win_x( n ) )
			return TRUE;
	}

	return FALSE;
}

/***************************************************************
* Yɸޥåפɽϰ⤫Ĵ٤
* long n : Yɸ
* return : ޥåפɽϰ⤫?
***************************************************************/

bool_t	clip_draw_y( long n )
{
	pos_t	*draw;

	if( n == MAP_DEL_Y )
		return FALSE;

	if( g_flg_cui ){
		draw = get_map_draw_pos();
		if( (draw->y <= n)
				&& (n <= (draw->y + WIN_MAP_WIDTH - 1)) ){
			return TRUE;
		}
	}
	if( g_flg_gui ){
		if( call_pcg_dun_clip_win_y( n ) )
			return TRUE;
	}

	return FALSE;
}

/***************************************************************
* ꥢˤ뤫ϩˤ뤫Ƿ
* long dun_lev : µܤγ
* return : ˤ뤫?
***************************************************************/

bool_t	chk_rate_room( long dun_lev )
{
	return rate_randm( RATE_ROOM );
}

/***************************************************************
* ɥ򳫤Ĥ뤫Ƿ
* long dun_lev : µܤγ
* return : ɥ򳫤?
***************************************************************/

bool_t	chk_rate_door_open( long dun_lev )
{
	return rate_randm( RATE_DOOR_OPEN );
}

/***************************************************************
* ɥꤹ뤫Ƿ
* long dun_lev : µܤγ
* return : ɥꤹ뤫?
***************************************************************/

bool_t	chk_rate_door_jammed( long dun_lev )
{
	return rate_randm( RATE_DOOR_JAMMED );
}

/***************************************************************
* ɥǷ
* long dun_lev : µܤγ
* return : ɥ?
***************************************************************/

bool_t	chk_rate_door_broken( long dun_lev )
{
	return rate_randm( RATE_DOOR_BROKEN );
}

/***************************************************************
* ɥ򱣤Ƿ
* long dun_lev : µܤγ
* return : ɥ򱣤?
***************************************************************/

bool_t	chk_rate_door_secret( long dun_lev )
{
	return rate_randm( labs( dun_lev ) * 4 );
}

/***************************************************************
* ϩΥɥ򱣤Ƿ
* long dun_lev : µܤγ
* return : ɥ򱣤?
***************************************************************/

bool_t	chk_rate_hide_cross_path( long dun_lev )
{
	return rate_randm( RATE_HIDE_CROSS_PATH );
}

/***************************************************************
* ֤Υ饯쥤䡼Υ᥸㡼ʸ֤
* return : ᥸㡼δʸ
***************************************************************/

char	get_chr_mjr_crsr( void )
{
	return get_chr_crsr( TRUE );
}

/***************************************************************
* ֤Υ饯쥤䡼Υޥʡʸ֤
* return : ޥʡδʸ
***************************************************************/

char	get_chr_mnr_crsr( void )
{
	return get_chr_crsr( FALSE );
}

/***************************************************************
* ֤Υ饯쥤䡼δʸ֤
* bool_t flg_mjr : ᥸㡼δʸ?
* return : ʸ
***************************************************************/

char	get_chr_crsr( bool_t flg_mjr )
{
	pos_t	*crsr = get_crsr();

	if( crsr == NULL )
		return FACE_MJR_NULL;

	if( !clip_x( crsr->x ) )
		return FACE_MJR_NULL;
	if( !clip_y( crsr->y ) )
		return FACE_MJR_NULL;

	if( flg_mjr )
		return( dun.map.chr.mjr[crsr->y][crsr->x] );
	else
		return( dun.map.chr.mnr[crsr->y][crsr->x] );
}

/***************************************************************
* µܤѹ椫Ĵ٤
* return : ѹ椫?
***************************************************************/

long	chk_nest_flg_dun( void )
{
	return chk_nest_flg( g_nest_flg_dun );
}

/***************************************************************
* µܴطΥǡ򥻡
* return : ֽ褿?
***************************************************************/

bool_t	save_dun( void )
{
	if( !save_crsr_ptn( g_crsr_ptn_usr, g_crsr_ptn_max_n ) ){
		print_msg( FLG_NULL, MSG_S, MSG_ERR_SAVE_CRSR_PTN );
		return FALSE;
	}

	return TRUE;
}

