/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2007 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: MouseMap.cpp,v 1.22 2007/12/24 22:00:28 bowkenken Exp $
***************************************************************/

#ifdef D_WS
# include <WScom.h>
# include <WSCfunctionList.h>
# include <WSCbase.h>

# include <WSCvscrBar.h>
# include <WSCwindow.h>
#endif // D_WS

#include "gmain.h"
#include "replay.h"
#include "draw.h"
#include "menu.h"
#include "gmain-prot.h"
#include "replay-prot.h"
#include "draw-prot.h"
#include "menu-prot.h"
#include "mmenu-prot.h"
#include "imenu-prot.h"

#include "MouseMap.h"
#include "Key.h"
#include "GlobalVar.h"

#ifdef D_WS
extern WSCwindow* MenuWin;
extern WSCvscrBar *MapScrollX;
extern WSCvscrBar *MapScrollY;
#endif // D_WS

////////////////////////////////////////////////////////////////
// ޥΥ롦Хåν
////////////////////////////////////////////////////////////////

void initMouseMotionFunc()
{
	// ݥ

	gMouseMotion.setFuncPoint(
			funcMotionPoint );

	// ɥå

	gMouseMotion.setFunc(
			MouseMotion::nMouseButtonL,
			MouseMotion::nMotionDrag,
			funcMotionDragL );

	// ܥκɥåΥ롦Хå

	gMouseMotion.setFunc(
			MouseMotion::nMouseButtonR,
			MouseMotion::nMotionLeft,
			funcMotionLeftR );

	// ܥαɥåΥ롦Хå

	gMouseMotion.setFunc(
			MouseMotion::nMouseButtonR,
			MouseMotion::nMotionRight,
			funcMotionRightR );

	// ܥξɥåΥ롦Хå

	gMouseMotion.setFunc(
			MouseMotion::nMouseButtonR,
			MouseMotion::nMotionUp,
			funcMotionUpR );

	// ܥβɥåΥ롦Хå

	gMouseMotion.setFunc(
			MouseMotion::nMouseButtonR,
			MouseMotion::nMotionDown,
			funcMotionDownR );

	// å

	gMouseMotion.setFuncClick(
			MouseMotion::nMouseButtonL,
			funcMotionClick );

	// 楯å

	gMouseMotion.setFuncClick(
			MouseMotion::nMouseButtonM,
			funcMotionClick );

	// å

	gMouseMotion.setFuncClick(
			MouseMotion::nMouseButtonR,
			funcMotionClick );

	// å

	long btnMin = (long)MouseMotion::nMouseButton3;
	long btnMax = (long)MouseMotion::nMouseButtonMaxN;
	for( long i = btnMin; i < btnMax; i++ ){
		gMouseMotion.setFuncClick(
				(MouseMotion::MouseButtonN)i,
				funcMotionClick );
	}

	// ץ쥹 + å

	gMouseMotion.setFuncClickLR(
			MouseMotion::nMouseButtonL,
			funcMotionClickLR );

	// ץ쥹 + å

	gMouseMotion.setFuncClickLR(
			MouseMotion::nMouseButtonR,
			funcMotionClickLR );

	// 

	gMouseMotion.setFuncScroll(
			MouseMotion::nScrollLeft,
			funcMotionScroll );

	// 

	gMouseMotion.setFuncScroll(
			MouseMotion::nScrollRight,
			funcMotionScroll );

	// 她

	gMouseMotion.setFuncScroll(
			MouseMotion::nScrollUp,
			funcMotionScroll );

	// 

	gMouseMotion.setFuncScroll(
			MouseMotion::nScrollDown,
			funcMotionScroll );
}

////////////////////////////////////////////////////////////////
// ޥˤݥȤΥ롦Хå
// long m : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionPoint(
	long m,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	if( get_flg_draw_menu() )
		return;

#ifdef D_MFC
	nCurX = nCurX * _100_PERCENT / g_Dir3d.nTileSizeRate;
	nCurY = nCurY * _100_PERCENT / g_Dir3d.nTileSizeRate;
#endif // D_MFC

	long x = gPcgDun.getScrollBarX();
	long y = gPcgDun.getScrollBarY();
	long mapX = (x + nCurX) / gPcgDun.getTileSizeX( true );
	long mapY = (y + nCurY) / gPcgDun.getTileSizeY( true );

	gKey.moveCrsrAbs( mapX, mapY );
}

////////////////////////////////////////////////////////////////
// ɥåΥ롦Хå
// long m : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionDragL(
	long m,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	long maxX = gPcgDun.getScrollBarMaxX();
	long maxY = gPcgDun.getScrollBarMaxY();
	long dx = nCurX - nBgnX;
	long dy = nCurY - nBgnY;
#ifdef D_MFC
	dx = dx * _100_PERCENT / g_Dir3d.nTileSizeRate;
	dy = dy * _100_PERCENT / g_Dir3d.nTileSizeRate;
#endif // D_MFC
	long x = gMapDragBgnX - dx;
	long y = gMapDragBgnY - dy;
	long w = gPcgDun.getScrollBarW();
	long h = gPcgDun.getScrollBarH();

	if( x < 0 )
		x = 0;
	if( y < 0 )
		y = 0;
	if( x > maxX)
		x = maxX;
	if( y > maxY)
		y = maxY;

	long sizX = gPcgDun.getTileSizeX( true );
	long sizY = gPcgDun.getTileSizeY( true );
	x = (x / sizX) * sizX;
	y = (y / sizY) * sizY;

	if( gPcgDun.chkScroll( x, y, w, h ) )
		gPcgDun.scrollMap( x, y );
}

////////////////////////////////////////////////////////////////
// ܥκɥåΥ롦Хå
// long m : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionLeftR(
	long m,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	char str[15 + 1];
	sprintf( str, "&%2ld", (long)FUNC_N_MOTION_LEFT );
	gKey.setString( str );
//@@@	gKey.setString( "/" );
}

////////////////////////////////////////////////////////////////
// ܥαɥåΥ롦Хå
// long m : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionRightR(
	long m,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	char str[15 + 1];
	sprintf( str, "&%2ld", (long)FUNC_N_MOTION_RIGHT );
	gKey.setString( str );
//@@@	gKey.setString( "*" );
}

////////////////////////////////////////////////////////////////
// ܥξɥåΥ롦Хå
// long m : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionUpR(
	long m,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	char str[15 + 1];
	sprintf( str, "&%2ld", (long)FUNC_N_MOTION_UP );
	gKey.setString( str );
//@@@	gKey.setString( "-" );
}

////////////////////////////////////////////////////////////////
// ܥβɥåΥ롦Хå
// long m : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionDownR(
	long m,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	char str[15 + 1];
	sprintf( str, "&%2ld", (long)FUNC_N_MOTION_DOWN );
	gKey.setString( str );
//@@@	gKey.setString( "+" );
}

////////////////////////////////////////////////////////////////
// åΥ롦Хå
// long m : ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionClick(
	long m,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	MouseMotion::MouseButtonN n = (MouseMotion::MouseButtonN)m;

	if( n < MouseMotion::nMouseButton0 )
		return;
	if( n >= MouseMotion::nMouseButtonMaxN )
		return;

#if	0
//@@@
	if( n == MouseMotion::nMouseButtonL ){
		gKey.setChar( 'M' - '@' );
	} else if( n == MouseMotion::nMouseButtonM ){
		gKey.setString( "+" );
	} else if( n == MouseMotion::nMouseButtonR ){
		gKey.setString( "." );
	} else if( n == MouseMotion::nMouseButton3 ){
print_msg( 0, "33333" );//@@@
		gKey.setString( "Q" );
	} else if( n == MouseMotion::nMouseButton4 ){
print_msg( 0, "44444" );//@@@
		gKey.setString( "Q" );
	} else if( n == MouseMotion::nMouseButton5 ){
print_msg( 0, "55555" );//@@@
		gKey.setString( "Q" );
	} else if( n == MouseMotion::nMouseButton6 ){
		gKey.setString( "6" );
	} else {
		char str[15 + 1];
		sprintf( str, "&%2ld", (long)n );
		gKey.setString( str );
	}
#else
//@@@
	long fn = FUNC_N_CLICK_0 + n;
	if( fn < 0 )
		return;
	if( fn > FUNC_KEY_MAX )
		return;

	char str[15 + 1];
	sprintf( str, "&%2ld", (long)fn );
	gKey.setString( str );
#endif
}

////////////////////////////////////////////////////////////////
// ƱåΥ롦Хå
// long m : ˥ץ쥹ޥܥֹ
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionClickLR(
	long m,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	if( get_flg_play_replay() ){
		gKey.setString( "," );
		return;
	}

	MouseMotion::MouseButtonN n = (MouseMotion::MouseButtonN)m;

#if	1
	long fn = FUNC_N_CLICK_0;

	if( n == MouseMotion::nMouseButtonL )
		fn = FUNC_N_PRESS_L_CLICK_R;
	else if( n == MouseMotion::nMouseButtonR )
		fn = FUNC_N_PRESS_R_CLICK_L;
	else
		return;

	if( fn < 0 )
		return;
	if( fn > FUNC_KEY_MAX )
		return;

	char str[15 + 1];
	sprintf( str, "&%2ld", (long)fn );
	gKey.setString( str );
#else
//@@@
	if( n == MouseMotion::nMouseButtonL ){
		gKey.setStringKeyTab( "&11" );
	}

	if( n == MouseMotion::nMouseButtonR ){
		gKey.setStringKeyTab( "&12" );
	}
#endif
}

////////////////////////////////////////////////////////////////
// Υ롦Хå
// long m : 
// long nBgnX : ɥå X ɸ
// long nBgnY : ɥå Y ɸ
// long nCurX : ߤ X ɸ
// long nCurY : ߤ Y ɸ
////////////////////////////////////////////////////////////////

void funcMotionScroll(
	long m,
	long nBgnX, long nBgnY,
	long nCurX, long nCurY
)
{
	MouseMotion::ScrollKind dir = (MouseMotion::ScrollKind)m;

	if( dir < MouseMotion::nScrollKindMinN )
		return;
	if( dir >= MouseMotion::nScrollKindMaxN )
		return;

	if( gKey.chkBuf() )
		return;
	if( chk_key_buf() )
		return;
	if( chk_executing_menu() )
		return;

	switch( dir ){
	case MouseMotion::nScrollLeft:
		gKey.setString( ":/misc/cursor/cursor/scroll/west\n" );
		break;
	case MouseMotion::nScrollRight:
		gKey.setString( ":/misc/cursor/cursor/scroll/east\n" );
		break;
	case MouseMotion::nScrollUp:
		gKey.setString( ":/misc/cursor/cursor/scroll/north\n" );
		break;
	case MouseMotion::nScrollDown:
		gKey.setString( ":/misc/cursor/cursor/scroll/south\n" );
		break;
	default:
		break;
	}
}
