/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2008 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: FileList.h,v 1.21 2008/01/11 09:13:16 bowkenken Exp $
***************************************************************/

#ifndef FILE_LIST_H
#define FILE_LIST_H	1

#if HAVE_UNISTD_H
# include <unistd.h>
#endif // HAVE_UNISTD_H

#include <stdlib.h>
#include <stdio.h>

#if defined( D_WS ) || defined( D_GTK )
# include <dirent.h>
# include <sys/stat.h>
#endif

#ifdef D_WS
# include <WSCstring.h>
#endif // D_WS

#ifdef D_GTK
# include "GtkWSCstring.h"
#endif // D_GTK

#ifdef D_MFC
# include "xlnl-dows/stdafx.h"
# include "MfcWSCstring.h"
#endif // D_GTK

////////////////////////////////////////////////////////////////
// ꤵ줿ĥҤΥե򸡺
// Ĥʤä顢ǥ쥯ȥ곬ؤǥ쥯ȥ
// ޤǡΤܤ
////////////////////////////////////////////////////////////////

#define	STR_DIR_BASE	".lnl/xlnl/graph/"

static WSCstring sDirBaseSelGraph = "default/";

class FileList {
public:

private:
	// ǥ쥯ȥ
	WSCstring sDirBase;
	// ǥ쥯ȥ꤫Хѥ
	WSCstring sDirSub;
	// եѥ
	WSCstring sDirFullPath;

	// ĥҤΥꥹȡڡǶڤ
	WSCstring sExt;

	// ĤǤե뤬Ĥä
	// Ĥäǥ쥯ȥϤΤܤʤ
	bool bFlagExist;

#ifdef D_MFC
	// ե롦

	bool bFlagUseWin32ApiFind;

	WIN32_FIND_DATA findData;
	HANDLE hFindFile;

	CFileFind finder;

	bool bFlagOpen;
#else // D_MFC
	// Υǥ쥯ȥ
	DIR *dpFile;
#endif // D_MFC

public:
	FileList();
	~FileList();

	bool reset( WSCstring dir, WSCstring ext );
	WSCstring next();

	WSCstring getBaseDir();

	static WSCstring setStrDirSelGraph( WSCstring dir );
	static WSCstring jointDir(
		WSCstring dir1, WSCstring dir2 );
	static WSCstring getExt( WSCstring name );

private:
	WSCstring nextNode();
};

#endif /* FILE_LIST_H */
