/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2008 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: FileList.cpp,v 1.19 2008/01/11 09:13:16 bowkenken Exp $
***************************************************************/

#ifdef D_WS
# include <WSDenv.h>
#endif //D_WS

#include "spell.h"
#include "menu.h"
#include "amenu.h"

#include "FileList.h"

#include "draw.h"
#include "town.h"
#include "gfile.h"
#include "draw-prot.h"
#include "gfile-prot.h"

////////////////////////////////////////////////////////////////
// ե븡Υ󥹥ȥ饯
////////////////////////////////////////////////////////////////

FileList::FileList()
{
	sDirBase = "";
	sDirSub = "";
	sDirFullPath = "";
	sExt = "";
	bFlagExist = false;

#ifdef D_MFC
	bFlagUseWin32ApiFind = true;
	bFlagOpen = false;
#else // D_MFC
	dpFile = NULL;
#endif // D_MFC
}

////////////////////////////////////////////////////////////////
// ե븡Υǥȥ饯
////////////////////////////////////////////////////////////////

FileList::~FileList()
{
#ifndef D_MFC
	if( dpFile != NULL ){
		closedir( dpFile );
		dpFile = NULL;
	}
#endif // D_MFC
}

////////////////////////////////////////////////////////////////
// Υꥻå
// WSCstring dirSub : फХѥ
// WSCstring ext : ĥҤΥꥹ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool FileList::reset( WSCstring dirSub, WSCstring ext )
{
#ifdef D_MFC
	if( bFlagOpen ){
		if( bFlagUseWin32ApiFind )
			::FindClose( hFindFile );
		else
			finder.Close();

		bFlagOpen = false;
	}
#else // D_MFC
	if( dpFile != NULL ){
		closedir( dpFile );
		dpFile = NULL;
	}
#endif // D_MFC

	sDirBase = jointDir( getBaseDir(), "" );
	sDirSub = jointDir( dirSub, "" );
	sDirFullPath = jointDir( sDirBase, sDirSub );

	make_dir( sDirFullPath );

	sExt = ext;
	bFlagExist = false;

#ifdef D_MFC
	WSCstring path = jointDir( sDirFullPath, "*.*" );
	path.replaceString( "/", "\\", 0 );

	if( bFlagUseWin32ApiFind ){
		ZeroMemory( &findData, sizeof( findData ) );
		hFindFile = ::FindFirstFile( path, &findData );
		if( hFindFile == INVALID_HANDLE_VALUE )
			return false;

		findData.dwFileAttributes = 0
				| FILE_ATTRIBUTE_ARCHIVE
				| FILE_ATTRIBUTE_COMPRESSED
				| FILE_ATTRIBUTE_READONLY
				;
	} else {
		if( !finder.FindFile( path ) )
			return false;

# if 0
//@@@
		finder.MatchesMask( 0
				| FILE_ATTRIBUTE_ARCHIVE
				| FILE_ATTRIBUTE_COMPRESSED
				| FILE_ATTRIBUTE_READONLY
		);
# endif
	}

	bFlagOpen = true;
#else // D_MFC
	dpFile = opendir( sDirFullPath );
	if( dpFile == NULL )
		return false;
#endif // D_MFC

	return true;
}

////////////////////////////////////////////////////////////////
// Υե򸡺
// Ĥʤäǥ쥯ȥ򤵤Τܤ
// return : ĤäեХѥ
////////////////////////////////////////////////////////////////

WSCstring FileList::next()
{
	for( long i = 0; i < LOOP_MAX_100; i++ ){
		WSCstring path = nextNode();

		if( path.getChars() > 0 )
			return path;
		if( bFlagExist )
			return "";

		// ǥ쥯ȥ򺬤˸ä̤

		for( long j = 0; j < LOOP_MAX_100; j++ ){
			long nWords = sDirSub.getWords( "/" );
			if( nWords <= 1 )
				return "";

			long nPos = sDirSub.getWordCharPos( nWords - 2, "/" );
			if( nPos > -1 )
				sDirSub.cutString( nPos );
			if( reset( sDirSub, sExt ) )
				break;
		}
	}

	return "";
}

////////////////////////////////////////////////////////////////
// Υե򸡺
// return : ĤäեХѥ
////////////////////////////////////////////////////////////////

WSCstring FileList::nextNode()
{
#ifdef D_MFC
	if( !bFlagOpen )
		return "";
#else // D_MFC
	if( dpFile == NULL )
		return "";
#endif // D_MFC

	while( 1 ){
#ifdef D_MFC
		WSCstring name;

		if( bFlagUseWin32ApiFind ){
			if( !::FindNextFile( hFindFile, &findData ) )
				break;

			if( findData.dwFileAttributes
					& (FILE_ATTRIBUTE_DIRECTORY) ){
				continue;
			}

			name = jointDir( sDirFullPath,
					findData.cFileName );
		} else {
			if( !finder.FindNextFile() )
				break;

			if( finder.IsDirectory() )
				continue;

			name = finder.GetFilePath();
		}
		name.replaceString( "\\", "/", 0 );
#else // D_MFC
		struct dirent *buf = readdir( dpFile );
		if( buf == NULL )
			break;

		WSCstring fileName = buf->d_name;
# ifdef D_DOWS
		fileName.replaceString( "\\", "/", 0 );
# endif // D_DOWS
		WSCstring name = jointDir( sDirFullPath, fileName );

		struct stat statBuf;
		stat( name, &statBuf );
		if( S_ISDIR( statBuf.st_mode ) )
			continue;
#endif // D_MFC

		WSCstring ext = getExt( name );
		long nExtMaxN = sExt.getWords();
		for( long i = 0; i < nExtMaxN; i++ ){
			WSCstring curExt = sExt.getWord( i, " " );

			if( curExt == ext ){
				bFlagExist = true;
				return name;
			}
		}
	}

#ifdef D_MFC
	if( bFlagUseWin32ApiFind )
		::FindClose( hFindFile );
	else
		finder.Close();

	bFlagOpen = false;
#endif // D_MFC

	return "";
}

////////////////////////////////////////////////////////////////
// ǥ쥯ȥ֤
// return : ǥ쥯ȥ
////////////////////////////////////////////////////////////////

WSCstring FileList::getBaseDir()
{
	WSCstring dir = jointDir( get_home_dir(), STR_DIR_BASE );
	dir = jointDir( dir, sDirBaseSelGraph );

	return dir;
}

////////////////////////////////////////////////////////////////
// ǥ쥯ȥꤹ
// WSCstring dir : ǥ쥯ȥ
// return : ǥ쥯ȥ
////////////////////////////////////////////////////////////////

WSCstring FileList::setStrDirSelGraph( WSCstring dir )
{
	sDirBaseSelGraph = dir;

	return dir;
}

////////////////////////////////////////////////////////////////
// ǥ쥯ȥɤ "/" ֤Ϣ뤹
// WSCstring dir1 : ǥ쥯ȥ̾
// WSCstring dir2 : ǥ쥯ȥ̾
// return : ָΥǥ쥯ȥ̾
////////////////////////////////////////////////////////////////

WSCstring FileList::jointDir(
	WSCstring dir1, WSCstring dir2 )
{
	const WSCstring sSlash = "/";

	int n = dir1.getChars() - 1;
	if( n < 0 )
		return( dir2 );

	if( dir1[n] == '/' )
		return( dir1 + dir2 );
	else
		return( dir1 + sSlash + dir2 );
}

////////////////////////////////////////////////////////////////
// ե̾γĥʬ֤
// WSCstring name : ե̾
// return : ĥ
////////////////////////////////////////////////////////////////

WSCstring FileList::getExt( WSCstring name )
{
	for( long i = name.getChars() - 1; i >= 0; i-- ){
		if( name[i] == '.' ){
			name.deleteChars( 0, i + 1 );

			return name;
		}
	}

	return "";
}
