/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2008 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: GuiNum.h,v 1.14 2008/05/02 12:00:35 bowkenken Exp $
***************************************************************/

#ifndef GUI_NUM_H
#define GUI_NUM_H	1

////////////////////////////////////////////////////////////////
// ϥɥ
////////////////////////////////////////////////////////////////

#define GUI_NUM_CPP
#include "inc.h"

////////////////////////////////////////////////////////////////

#define GUI_NUM_BUTTON_MAX_N	20

////////////////////////////////////////////////////////////////

class GuiNum {

	//////// ץ饤١ȡСѿ ////////
private:

#ifdef D_WS
#endif // D_WS

#ifdef D_GTK
	GtkObject *mHscaleAdjustment;
	GtkWidget *mHscale;

	GtkObject *mNumAdjustment;
	GtkWidget *mNumSpin;

	GtkWidget *mArrowUp[GUI_NUM_BUTTON_MAX_N];
	GtkWidget *mArrowDown[GUI_NUM_BUTTON_MAX_N];
	GtkWidget *mButtonUp[GUI_NUM_BUTTON_MAX_N];
	GtkWidget *mButtonDown[GUI_NUM_BUTTON_MAX_N];
	GtkWidget *mButtonLabel[GUI_NUM_BUTTON_MAX_N];

	GtkWidget *mButtonMin;
	GtkWidget *mButtonClear;
	GtkWidget *mButtonMax;
	GtkWidget *mButtonOk;
#endif // D_GTK

#ifdef D_MFC
#endif // D_MFC

	//////// ѥ֥åСѿ ////////
public:

#ifdef D_WS
	void *mNumWin;
#endif // D_WS

#ifdef D_GTK
	GtkWidget *mNumWin;
#endif // D_GTK

#ifdef D_MFC
	class CInputNumDlg *mNumWin;
#endif // D_MFC

	volatile long *mPN;
	long mOrg;
	long mMin;
	long mMax;
	long mFigure;

	//////// ѥ֥åСؿ ////////
public:

	GuiNum()
	{
		mPN = NULL;
		mOrg = 0;
		mMin = 0;
		mMax = 1;
		mFigure = 1;
	}
	~GuiNum()
	{
	}

	void init();
	void destroy();

	void draw( volatile long *n, long min, long max, long figure );
	void redraw();
	void wipe();

	void valueChanged( long n );
	void up_down_num_label( long n, long d );
	char up_down_num_char( char c, long d );

	void cvUpDownToN();
	void cvUpDownFromN();
	void okClicked( menu_num_t n );

	//////// ץ饤١ȡСؿ ////////
private:

	void newWin();
};

#endif /* GUI_NUM_H */
