/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2008 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: PcgDun.h,v 1.46 2008/05/10 10:04:38 bowkenken Exp $
***************************************************************/

#ifndef PCG_DUN_H
#define PCG_DUN_H	1

////////////////////////////////////////////////////////////////
// 󥸥
////////////////////////////////////////////////////////////////

#include "misc.h"
#include "mnstr-kind.h"
#include "item.h"
#include "trap.h"
#include "party.h"
#include "mnstr.h"

#include "GraphConf.h"
#include "Pcg.h"

#ifdef D_WS
# include <WSCstring.h>
#endif //D_WS

#ifdef D_GTK
# include "GtkWSCstring.h"
#endif //D_GTK

#ifdef D_MFC
# include "MfcWSCstring.h"
# include "xlnl-dows/Dir3d.h"
#endif //D_MFC

////////////////////////////////////////////////////////////////

// ѥΥե̾γĥ
#if	defined( D_GTK )
# define	STR_GRAPH_FILE_EXT	\
		"png xpm jpg jpeg tif pnm bmp gif " \
		"PNG XPM JPG JPEG TIF PNM BMP GIF"
#elif	defined( D_WS )
# define	STR_GRAPH_FILE_EXT	\
		"png jpg jpeg bmp " \
		"PNG JPG JPEG BMP"
#elif	defined( D_MFC )
# define	STR_GRAPH_FILE_EXT	\
		"png jpg jpeg bmp " \
		"PNG JPG JPEG BMP"
#else
# define	STR_GRAPH_FILE_EXT	\
		"png jpg jpeg bmp " \
		"PNG JPG JPEG BMP"
#endif

#if 0
//@@@
// ѥΥХꥨμ
typedef char PcgMap;
#endif

// ѥΥơ֥
struct PcgTab {
	// 󥹥ξμ
	mnstr_kind_t nMnstrKind;
	// ʸ
	char mjr, mnr;
	// ѥλȤ
	ratio_t nRatio;

	// ѥΥեΤǥ쥯ȥ
	WSCstring sDir;
};

typedef enum {
	WALL_PTN_TYPE_TILE,
	WALL_PTN_TYPE_A,
	WALL_PTN_TYPE_B,
} WallPtnType;

typedef enum {
	N_PTN_DIR_CHR_1 = 1,
	N_PTN_DIR_CHR_4 = 4,
} NPtnDirChr;

////////////////////////////////////////////////////////////////

class PcgDun {
public:
	GraphConf *pGraphConf;

	// ѥγΨ
	rate_t nTileSizeRate;

	// 饯θƤΥѥ
	NPtnDirChr nPtnDirMbr;
	NPtnDirChr nPtnDirMnstr;

private:
	//// 롦⡼ ////

	// ѥδॵ
	long nTileSizeX, nTileSizeY;

	// ȥβ
	Pcg pcgTitle;

	// ΥѥΥꥹ
	Pcg pcgNullTown;
	Pcg pcgNullDun;
	// ΥѥΥꥹ
	Pcg pcgFloorTown;
	Pcg pcgFloorDun;
	// ɤΥѥΥꥹ
	Pcg pcgWallTown;
	Pcg pcgWallDun;
	Pcg pcgStatue;
	// ĤΥѥΥꥹ
	Pcg pcgSignboard;
	// ʤΥѥΥꥹ
	Pcg pcgStairsUpTown;
	Pcg pcgStairsUpDun;
	Pcg pcgStairsDownTown;
	Pcg pcgStairsDownDun;
	// ɥΥѥΥꥹ
	Pcg pcgDoorCloseTown;
	Pcg pcgDoorCloseDun;
	Pcg pcgDoorOpenTown;
	Pcg pcgDoorOpenDun;
	// ΥѥΥꥹ
	Pcg pcgWindowClose;
	Pcg pcgWindowOpen;

	// ΥѥΥꥹ
	Pcg pcgCrsr;
	Pcg pcgCrsrSub;
	// 󥫡ΥѥΥꥹ
	Pcg pcgSquare;

	// ƥΥѥΥꥹ
	Pcg pcgItem;
	// 櫤ΥѥΥꥹ
	Pcg pcgTrap;

	// СΥѥΥꥹ
	Pcg *aPcgMbr[LS_MBR_MAX_N];
	// 󥹥ΥѥΥꥹ
	Pcg *aPcgMnstr[MNSTR_KIND_MAX_N];

	// Ф줿ȥΥեֹ
	long nTitleRandmSelN;
	// ȥΥե
	long nTitleN;

	// ѥΥХꥨμΥޥå
	rate_t rateMap[MAP_MAX_Y][MAP_MAX_X];

	// ɤΥѥ󡦥
	WallPtnType nWallPtnTypeTown;
	WallPtnType nWallPtnTypeDun;

	// 褹ɬפ륭饯Υޥå
	bool bFlgUpdate[MAP_MAX_Y][MAP_MAX_X];

	// ֥롦Хåե
	WSDmwindowDev *pWBuf;

	//// ĤΥե ////

	// եȤΥݥ
	long nSignboardPoint;

	// եȤδॵ
	long nSignboardSizeX, nSignboardSizeY;

	// ʸֳ
	long nSignboardIntervalWidth, nSignboardIntervalHeight;

#ifdef D_GTK
	// եȤΥ
	GtkStyle *pSignboardStyle;

	// եȤΥ
	gint nSignboardLeftBearing, nSignboardRightBearing;
	gint nSignboardWidth, nSignboardAscent, nSignboardDescent;
#endif // D_GTK

#ifdef D_MFC
	// եȤΥ
	void *pSignboardStyle;
	LOGFONT mSignboardFontDesc;
	CFont *pSignboardFont;

	CDir3dText mD3Signboard;
#endif // D_MFC

	//// ƥȡ⡼ ////

	// եȤΥǥեȤΥݥ
	long nTextModeDefaultPoint;

	// եȤδॵ
	long nTextSizeX, nTextSizeY;

	// ʸֳ
	long nIntervalWidth, nIntervalHeight;

#ifdef D_GTK
	// եȤΥ
	GtkStyle *pStyle;

	// եȤΥ
	gint nLeftBearing, nRightBearing;
	gint nWidth, nAscent, nDescent;
#endif // D_GTK

#ifdef D_MFC
	// եȤΥ
	void *pStyle;
	LOGFONT mTextFontDesc;
	CFont *pTextFont;
	CClientDC *pDc;
#endif // D_MFC

	//// ȥ ////

#ifdef D_GTK
	// եȤΥ
	GtkStyle *pTitleStyle;
#endif // D_GTK

#ifdef D_MFC
	// եȤΥ
	void *pTitleStyle;
	LOGFONT mTitleFontDesc;
	CFont *pTitleFont;

	CDir3dText mD3Title;
#endif // D_MFC

	// ˥ޥåפ褹뤫?
	bool bFlgEnaDrawTurn;
	// ̹׵ե饰
	bool bFlgUpdateRequest;

public:
	PcgDun();
	~PcgDun();

	void initTitle();
	void init( GraphConf *cnf );
	void reset();

	long getTileSizeX( bool flgText = false );
	long getTileSizeY( bool flgText = false );

	WSDmwindowDev *getWBuf();

	void scrollTile( long mapX, long mapY );
	void scrollMap( long x, long y );
	bool chkScroll( long x, long y, long w, long h );
	bool drawScroll( long x, long y, long w, long h );

	long getScrollBarX();
	long getScrollBarY();
	long getScrollBarW();
	long getScrollBarH();
	long getScrollBarMaxX();
	long getScrollBarMaxY();
	void setScrollBarX( long x );
	void setScrollBarY( long y );

	bool clipWin( long mapX, long mapY );
	bool clipWinX( long mapX );
	bool clipWinY( long mapY );

	void redraw( bool flgForce = false );
	bool draw(
		long mapX, long mapY,
		long mapW, long mapH,
		bool flgForce = false
	);
	void drawTurn( bool flgForce = false );
	void flush( long mapX, long mapY, long mapW, long mapH );

	void setFlgUpdateRequest( bool flg );

	bool drawTitle();

	Pcg *getChrPcg( chr_t *chr );
	long getChrDrawLeft( chr_t *chr, Pcg *pPcg, bool flagPre );
	long getChrDrawRight( chr_t *chr, Pcg *pPcg, bool flagPre );
	long getChrDrawTop( chr_t *chr, Pcg *pPcg, bool flagPre );
	long getChrDrawBottom( chr_t *chr, Pcg *pPcg, bool flagPre );
	long getObjDrawLeft( long mapX, Pcg *pPcg );
	long getObjDrawRight( long mapX, Pcg *pPcg );
	long getObjDrawWidth( long mapX, Pcg *pPcg );
	long getObjDrawTop( long mapY, Pcg *pPcg );
	long getObjDrawBottom( long mapY, Pcg *pPcg );
	long getObjDrawHeight( long mapY, Pcg *pPcg );

	PcgTab *getPcgTabMbr();

	void drawRectangle(
		long x, long y, long w, long h,
		long r, long g, long b
	);

private:
/*
	void initTitle();
	void init( GraphConf *cnf );
*/
	void initPcgLsRandm( GraphConf *cnf, Pcg *ls, PcgTab tab[] );
	void initGraphConf( GraphConf *cnf );
/*
	void reset();
*/
	void resetSignboardFont();
	bool setSignboardFont( long pnt, WSCstring *pFontName );
/*
	long getTileSizeX( bool flgText = false );
	long getTileSizeY( bool flgText = false );
*/
	long getTextModePoint();
	void resetMap();
/*
	WSDmwindowDev *getWBuf();
*/
	WSDmwindowDev *ReNewWBuf();
/*
	void scrollTile( long mapX, long mapY );
	void scrollMap( long x, long y );
	bool chkScroll( long x, long y, long w, long h );
	bool drawScroll( long x, long y, long w, long h );
*/
#ifdef D_MFC
	void getScrollInfo( SCROLLINFO *info, int sb );
	void setScrollInfoPos( int sb, int pos );
#endif // D_MFC
/*
	long getScrollBarX();
	long getScrollBarY();
	long getScrollBarW();
	long getScrollBarH();
	long getScrollBarMaxX();
	long getScrollBarMaxY();
	void setScrollBarX( long x );
	void setScrollBarY( long y );
	bool clipWin( long mapX, long mapY );
	bool clipWinX( long mapX );
	bool clipWinY( long mapY );
	void redraw( bool flgForce = false );
	bool draw(
		long mapX, long mapY,
		long mapW, long mapH,
		bool flgForce = false
	);
	void drawTurn( bool flgForce = false );
*/
	bool drawSub( long mapX, long mapY, long mapW, long mapH );
/*
	void flush( long mapX, long mapY, long mapW, long mapH );
*/
	void initText();
	bool drawText( long mapX, long mapY, long mapW, long mapH );
#ifdef D_GTK
	bool user_select_font( GdkFont **font );
#endif // D_GTK
/*
	void setFlgUpdateRequest( bool flg );
*/
	bool getFlgUpdateRequest();
	void resetUpdateFlg();
	void setUpdateFlgRange(
		long mapX, long mapY,
		long mapW, long mapH,
		bool flg
	);
	void setUpdateFlg( long mapX, long mapY, bool flg );
	bool getUpdateFlg( long mapX, long mapY );
/*
	bool drawTitle();
*/
	void drawTitle0( long frame );
	void drawTitle1( long frame );
	void drawTitleCharStd( long x, long y, char c );
#ifdef D_GTK
	void drawTitleChar( GdkColor color, long x, long y, char c );
#endif // D_GTK
#ifdef D_MFC
	void drawTitleChar( D3DCOLOR color, long x, long y, char c );
#endif // D_MFC
	bool drawTile( long mapX, long mapY, bool flgFlush );
	bool drawObj( long mapX, long mapY );
	bool drawItemAll( long mapX, long mapY );
	bool drawNull( long mapX, long mapY );
	bool drawFloor( long mapX, long mapY );
	bool drawObjFix( long mapX, long mapY, Pcg *lsTown, Pcg *lsDun );
	Pcg *srchPcgLsMap( long mapX, long mapY, Pcg *lsTown, Pcg *lsDun );
	bool drawWall( long mapX, long mapY );
	bool drawWallTypeTile( long mapX, long mapY );
	bool drawWallTypeA( long mapX, long mapY );
	bool drawWallTypeB( long mapX, long mapY );
	bool drawWallTypeBRoof( long mapX, long mapY );
	bool drawWallTypeBCommon(
		long mapX, long mapY,
		long idxX, long idxY,
		bool flagHalfX, bool flagHalfY
	);
	bool drawStatue( long mapX, long mapY );
	bool drawSignboard( long mapX, long mapY );
	bool drawStairsUp( long mapX, long mapY );
	bool drawStairsDown( long mapX, long mapY );
	bool drawDoorClose( long mapX, long mapY );
	bool drawDoorOpen( long mapX, long mapY );
	bool drawDoorIdx( long mapX, long mapY, bool flagOpen );
	bool drawWindowClose( long mapX, long mapY );
	bool drawWindowOpen( long mapX, long mapY );
	bool drawTrap( long mapX, long mapY );
	Pcg *srchPcgLsFace( char mjr, char mnr, Pcg *lsTown, Pcg *lsDun );
	bool drawTrapSanctuary( long mapX, long mapY, trap_t *trap, Pcg *p );
	bool drawCrsrAll( long mapX, long mapY );
	bool drawCrsr( long mapX, long mapY );
	bool drawCrsrSub( long mapX, long mapY );
	bool drawCrsrOffset( long mapX, long mapY, bool flagSub );
	bool drawSquare( long mapX, long mapY );
	Pcg *srchPcgLsSquare();
	bool drawItem( long mapX, long mapY, char mjr, char mnr );
	void drawChrListAll( long x, long y, long w, long h );
	bool drawChrList( long mapX, long mapY, bool flagOneTile );
	bool drawChr(
		long mapX, long mapY,
		chr_t *chr, Pcg *pPcg,
		bool flagOneTile
	);
	void drawNight( long mapX, long mapY, long mapW, long mapH );
	bool getGlowColor( long *r, long *g, long *b, long *a );
/*
	Pcg *getChrPcg( chr_t *chr );
	long getChrDrawLeft( chr_t *chr, Pcg *pPcg, bool flagPre );
	long getChrDrawRight( chr_t *chr, Pcg *pPcg, bool flagPre );
	long getChrDrawTop( chr_t *chr, Pcg *pPcg, bool flagPre );
	long getChrDrawBottom( chr_t *chr, Pcg *pPcg, bool flagPre );
	long getObjDrawLeft( long mapX, Pcg *pPcg );
	long getObjDrawRight( long mapX, Pcg *pPcg );
	long getObjDrawWidth( long mapX, Pcg *pPcg );
	long getObjDrawTop( long mapY, Pcg *pPcg );
	long getObjDrawBottom( long mapY, Pcg *pPcg );
	long getObjDrawHeight( long mapY, Pcg *pPcg );
*/
	bool chkDrawWall( long mapX, long mapY );
	bool chkDrawStatue( long mapX, long mapY );
	bool chkDrawSignboard( long mapX, long mapY );
	bool chkDrawSanctuary( long mapX, long mapY, trap_t *trap );
	bool chkDrawCrsr( long mapX, long mapY );
	bool chkDrawCrsrSub( long mapX, long mapY );
	bool chkDrawCrsrCommon( long mapX, long mapY, bool flagSub );
	bool chkDrawSquare( long mapX, long mapY );
	bool chkDrawChr( long mapX, long mapY, chr_t *chr );
	long getWidthChr( chr_t *chr, Pcg *pPcg );
	long getHeightChr( chr_t *chr, Pcg *pPcg );
/*
	PcgTab *getPcgTabMbr();
*/
};

#endif /* PCG_DUN_H */
