/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2008 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: SelMbrGraph.cpp,v 1.3 2008/05/06 03:15:17 bowkenken Exp $
***************************************************************/

////////////////////////////////////////////////////////////////
// СΥեåѥ
////////////////////////////////////////////////////////////////

#include	"gmain.h"
//#include	"misc.h"
//#include	"turn.h"
//#include	"dun.h"
//#include	"town.h"
//#include	"item.h"
//#include	"spell.h"
//#include	"chr.h"
//#include	"party.h"
//#include	"mnstr.h"
//#include	"pet.h"
//#include	"fight.h"
//#include	"fx.h"
//#include	"trap.h"
//#include	"draw.h"
//#include	"curs.h"
//#include	"menu.h"
//#include	"amenu.h"
//#include	"request.h"
//#include	"gfile.h"
//#include	"msg.h"
//#include	"ver.h"
//#include	"gmain-prot.h"
//#include	"misc-prot.h"
//#include	"turn-prot.h"
//#include	"dun-prot.h"
//#include	"town-prot.h"
//#include	"item-prot.h"
//#include	"spell-prot.h"
//#include	"chr-prot.h"
//#include	"party-prot.h"
//#include	"mnstr-prot.h"
//#include	"pet-prot.h"
//#include	"fight-prot.h"
//#include	"fx-prot.h"
//#include	"trap-prot.h"
//#include	"draw-prot.h"
//#include	"curs-prot.h"
//#include	"menu-prot.h"
//#include	"mmenu-prot.h"
//#include	"imenu-prot.h"
//#include	"tmenu-prot.h"
//#include	"amenu-prot.h"
//#include	"request-prot.h"
//#include	"gfile-prot.h"
//#include	"msg-prot.h"

#include	"scene.h"
#include	"scene-prot.h"

#include "PcgDun.h"
#include "FileList.h"
#include "GlobalVar.h"

#ifdef D_WS
# include <WSCform.h>
# include <WSCvscrBar.h>
#endif // D_WS

#ifdef D_GTK
# include <gtk/gtk.h>
# include <gdk-pixbuf/gdk-pixbuf.h>
#endif // D_GTK

#ifdef D_MFC
# include "xlnl-dows/xlnl-dows.h"
# include "xlnl-dows/MainFrm.h"
#endif // D_GTK

#ifdef D_WS
extern WSCform *MapForm;
extern WSCvscrBar *MapScrollX;
extern WSCvscrBar *MapScrollY;
#endif // D_WS

////////////////////////////////////////////////////////////////

#define NAME_FONT_POINT	32
#define NAME_FONT_DOT	32

////////////////////////////////////////////////////////////////
// 󥹥ȥ饯
////////////////////////////////////////////////////////////////

SelMbrGraph::SelMbrGraph()
{
	pMbr = NULL;
	nPreScene = SCENE_N_NULL;
	pPtnHead = NULL;
	nPtnMaxN = 0;

#ifdef D_GTK
	font = NULL;
#endif // D_GTK

	nPreMapX = -1;
	nPreMapY = -1;
}

////////////////////////////////////////////////////////////////
// ǥȥ饯
////////////////////////////////////////////////////////////////

SelMbrGraph::~SelMbrGraph()
{
	if( nPreScene != SCENE_N_NULL )
		change_scene( nPreScene );

	if( nPreMapX > -1 )
		gPcgDun.setScrollBarX( nPreMapX );
	if( nPreMapY > -1 )
		gPcgDun.setScrollBarY( nPreMapY );
}

////////////////////////////////////////////////////////////////
// 򳫻
// mbr_t *mbr : С
// return : 򳫻ϤǤ?
////////////////////////////////////////////////////////////////

bool SelMbrGraph::exec( mbr_t *mbr )
{
	if( mbr == NULL )
		return false;
	if( pMbr != NULL )
		return false;
	if( gPcgDun.pGraphConf == NULL )
		return false;

	PcgTab *tab = gPcgDun.getPcgTabMbr();
	if( tab == NULL )
		return false;

	pMbr = mbr;

	// 롦С

	nPreMapX = gPcgDun.getScrollBarX();
	nPreMapY = gPcgDun.getScrollBarY();
	gPcgDun.setScrollBarX( 0 );
	gPcgDun.setScrollBarY( 0 );

	// 

	nPreScene = get_scene();
	change_scene( SCENE_N_SEL_MBR_GRAPH );

	// ѥ󸡺

	WSCstring path = gPcgDun.pGraphConf->getDir();
	long w = path.getWords( "/" );
	WSCstring dir = path.getWord( w - 1, "/" );

	WSCstring ext = STR_GRAPH_FILE_EXT;

	FileList::setStrDirSelGraph( dir );
	FileList ls;
	ls.reset( tab->sDir, ext );

	// ѥꥹȤϿ

	Pcg *pre = NULL;
	pPtnHead = NULL;
	long i;
	for( i = 0; i < LOOP_MAX_1000; i++ ){
		// 

		WSCstring file = ls.next();
		if( file.getChars() <= 0 )
			break;

		// ꡼

		Pcg *p;
		p = new Pcg;
		if( p == NULL )
			break;

		if( pre == NULL )
			pPtnHead = p;
		else
			pre->next = p;
		pre = p;

		// ɤ߹

		p->init( file );
	}
	nPtnMaxN = i;

	if( pre == NULL )
		pPtnHead = NULL;
	else
		pre->next = NULL;

	redraw();

	return true;
}

////////////////////////////////////////////////////////////////
// ѥ
////////////////////////////////////////////////////////////////

void SelMbrGraph::redraw()
{
	// 롦С
	if( nPreMapX <= -1 ){
		nPreMapX = gPcgDun.getScrollBarX();
		gPcgDun.setScrollBarX( 0 );
	}
	if( nPreMapY <= -1 ){
		nPreMapY = gPcgDun.getScrollBarY();
		gPcgDun.setScrollBarY( 0 );
	}

	long scrnW = gPcgDun.getScrollBarMaxX() + gPcgDun.getScrollBarW();
	long scrnH = gPcgDun.getScrollBarMaxY() + gPcgDun.getScrollBarH();
	gPcgDun.drawRectangle(
			0, 0, scrnW, scrnH,
			nBaseColorR, nBaseColorG, nBaseColorB );

	drawAllChr();
	gPcgDun.flush( 0, 0, MAP_MAX_X, MAP_MAX_Y );
}

////////////////////////////////////////////////////////////////
// ѥ
////////////////////////////////////////////////////////////////

void SelMbrGraph::draw()
{
#ifdef D_GTK
	drawAllChr();
#endif // D_GTK

#ifdef D_MFC
	redraw();
#endif // D_MFC
}

////////////////////////////////////////////////////////////////
// 饯
////////////////////////////////////////////////////////////////

void SelMbrGraph::drawAllChr()
{
	long sizeX = gPcgDun.getTileSizeX( false ) * 3;
	long sizeY = gPcgDun.getTileSizeY( false ) * 3 + 16;
	long sizeMaxX = gPcgDun.getScrollBarMaxX()
			+ gPcgDun.getScrollBarW();
	long sizeMaxY = gPcgDun.getScrollBarMaxY()
			+ gPcgDun.getScrollBarH();

	long x = 0;
	long y = 0;
	Pcg *p = pPtnHead;
	for( long i = 0; i < nPtnMaxN; i++ ){
		if( p == NULL )
			break;

		drawChr( x, y, sizeX, sizeY, p );

		x += sizeX;
		if( (x + sizeX) > sizeMaxX ){
			x = 0;
			y += sizeY;
			if( y >= sizeMaxY )
				break;
		}

		p = p->next;
	}
}

////////////////////////////////////////////////////////////////
// 饯
// long x : X ɸ
// long y : Y ɸ
// long w : 
// long h : ⤵
// Pcg *p : ѥ
////////////////////////////////////////////////////////////////

void SelMbrGraph::drawChr( long x, long y, long w, long h, Pcg *p )
{
	if( p == NULL )
		return;

	long bgnX = gPcgDun.getScrollBarX();
	long bgnY = gPcgDun.getScrollBarY();
	long endX = gPcgDun.getScrollBarX() + gPcgDun.getScrollBarW();
	long endY = gPcgDun.getScrollBarY() + gPcgDun.getScrollBarH();

	if( (x + w) < bgnX )
		return;
	if( (y + h) < bgnY )
		return;
	if( x > endX )
		return;
	if( y > endY )
		return;

	long ptnW = p->getWidth() / gPcgDun.nPtnDirMbr;
	long ptnH = p->getHeight() / gPcgDun.nPtnDirMbr;
	long xx = x + ((w - ptnW) / 2);
	long yy = y + h - ptnH;

	// α

	gPcgDun.drawRectangle(
			x, y,
			w, nSelBorderH,
			nHighColorR, nHighColorG, nHighColorB );
	gPcgDun.drawRectangle(
			x, y,
			nSelBorderW, h,
			nHighColorR, nHighColorG, nHighColorB );

	// Ƥα

	gPcgDun.drawRectangle(
			x, y + h - nSelBorderH,
			w, nSelBorderH,
			nLowColorR, nLowColorG, nLowColorB );
	gPcgDun.drawRectangle(
			x + w - nSelBorderW, y,
			nSelBorderW, h,
			nLowColorR, nLowColorG, nLowColorB );

	p->drawOffset( gPcgDun.getWBuf(),
			xx, yy, ptnW, ptnH, 0, 0 );
}
