/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2008 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: SelMbrGraph.h,v 1.2 2008/05/06 02:59:57 bowkenken Exp $
***************************************************************/

#ifndef SEL_MBR_GRAPH_H
#define SEL_MBR_GRAPH_H	1

////////////////////////////////////////////////////////////////
// СΥեåѥ
////////////////////////////////////////////////////////////////

#include "misc.h"
#include "party.h"
#include "scene.h"
#include "scene-prot.h"

#include "PcgDun.h"

#ifdef D_WS
# include <WSCstring.h>
#endif //D_WS

#ifdef D_GTK
# include "GtkWSCstring.h"
#endif //D_GTK

#ifdef D_MFC
# include "MfcWSCstring.h"
#endif //D_MFC

////////////////////////////////////////////////////////////////

class SelMbrGraph {

private:
	static const long nBaseColorR = 0xdddd;
	static const long nBaseColorG = 0xdddd;
	static const long nBaseColorB = 0xdddd;
	static const long nHighColorR = 0xffff;
	static const long nHighColorG = 0xffff;
	static const long nHighColorB = 0xffff;
	static const long nLowColorR = 0xbbbb;
	static const long nLowColorG = 0xbbbb;
	static const long nLowColorB = 0xbbbb;

	static const long nSelBorderW = 2;
	static const long nSelBorderH = 2;

	// ΥС
	mbr_t *pMbr;
	scene_n_t nPreScene;

	// ѥ󡦥ꥹȤƬ
	Pcg *pPtnHead;
	// ѥκ
	long nPtnMaxN;

	// ѥ̾Υե
#ifdef D_GTK
	GdkFont *font;
#endif // D_GTK

	long nPreMapX;
	long nPreMapY;

public:
	SelMbrGraph();
	~SelMbrGraph();

	bool exec( mbr_t *mbr );

	void redraw();
	void draw();

private:
	void drawAllChr();
	void drawChr( long x, long y, long w, long h, Pcg *p );
};

#endif /* SEL_MBR_GRAPH_H */
