/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2008 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: WinPos.cpp,v 1.3 2008/05/09 12:53:03 bowkenken Exp $
***************************************************************/

////////////////////////////////////////////////////////////////
// ɥκɸȥδ
////////////////////////////////////////////////////////////////

#include "gmain.h"

#include "WinPos.h"
#include "GlobalVar.h"

////////////////////////////////////////////////////////////////
// 󥹥ȥ饯
////////////////////////////////////////////////////////////////

WinPos::WinPos()
{
	pWin = NULL;
	bFlagEna = false;
	x = 0;
	y = 0;
	w = 16;
	h = 16;
}

////////////////////////////////////////////////////////////////
// ǥȥ饯
////////////////////////////////////////////////////////////////

WinPos::~WinPos()
{
}

////////////////////////////////////////////////////////////////
// 
////////////////////////////////////////////////////////////////

void *WinPos::getWin( win_kind_t kind )
{
#ifdef D_GTK
	switch( kind ){
	case WIN_KIND_NULL:
		break;
	case WIN_KIND_MAP:
		return gMapWin;
	case WIN_KIND_SEL_CONF:
		return gSelConf.mSelConfWin;
	case WIN_KIND_MENU:
		return gGuiMenu.mMenuWin;
	case WIN_KIND_MESSAGE:
		return gGuiMessage.mMessageWin;
	case WIN_KIND_STAT:
		return gGuiStat.mStatWin;
	case WIN_KIND_STAT_1:
	case WIN_KIND_STAT_2:
	case WIN_KIND_STAT_3:
	case WIN_KIND_STAT_4:
	case WIN_KIND_STAT_5:
	case WIN_KIND_STAT_6:
		break;
	case WIN_KIND_INPUT_NUM:
		return gGuiNum.mNumWin;
	case WIN_KIND_INPUT_STRING:
		return gGuiInpStr.mWin;
	case WIN_KIND_MAX_N:
		break;
	}
#endif //D_GTK

#ifdef D_MFC
	switch( kind ){
	case WIN_KIND_NULL:
		break;
	case WIN_KIND_MAP:
		return theApp.m_pMainWnd;
	case WIN_KIND_SEL_CONF:
		return gSelConf.mDlg;
	case WIN_KIND_MENU:
		return gGuiMenu.mMenuWin;
	case WIN_KIND_MESSAGE:
		return gGuiMessage.mMessageWin;
	case WIN_KIND_STAT:
		return gGuiStat.mStatWin;
	case WIN_KIND_STAT_1:
	case WIN_KIND_STAT_2:
	case WIN_KIND_STAT_3:
	case WIN_KIND_STAT_4:
	case WIN_KIND_STAT_5:
	case WIN_KIND_STAT_6:
		break;
	case WIN_KIND_INPUT_NUM:
		return gGuiNum.mNumWin;
	case WIN_KIND_INPUT_STRING:
		return gGuiInpStr.mInpStrWin;
	case WIN_KIND_MAX_N:
		break;
	}
#endif //D_MFC

	return NULL;
}

////////////////////////////////////////////////////////////////
// ɥκɸ
// long nx : X ɸ
// long ny : Y ɸ
// long nw : 
// long nh : ⤵
////////////////////////////////////////////////////////////////

void WinPos::set(
	win_kind_t kind,
	long *px, long *py,
	long *pw, long *ph,
	bool flagForce )
{
	bFlagEna = true;

	if( px != NULL )
		x = *px;
	if( py != NULL )
		y = *py;
	if( pw != NULL )
		w = *pw;
	if( ph != NULL )
		h = *ph;

	if( !g_flg_init && !flagForce )
		return;

	void *pWin = getWin( kind );
	if( pWin == NULL )
		return;

#ifdef D_GTK
	if( (px != NULL) || (py != NULL) )
		gtk_widget_set_uposition( GTK_WIDGET( pWin ), x, y );
# if 0
//@@@
	if( (pw != NULL) || (ph != NULL) ){
		gtk_widget_set_usize( GTK_WIDGET( pWin ), w, h );
		gtk_window_set_resizable( GTK_WINDOW( pWin ), TRUE );
	}
# elif 0
//@@@
	if( (pw != NULL) || (ph != NULL) ){
		gtk_widget_set_size_request( GTK_WIDGET( pWin ), w, h );
		gtk_window_set_resizable( GTK_WINDOW( pWin ), TRUE );
	}
# endif
#endif //D_GTK

#ifdef D_MFC
	((CWnd *)pWin)->MoveWindow( x, y, w, h );
#endif //D_MFC
}

////////////////////////////////////////////////////////////////
// ɥκɸμ
// long *px : X ɸ
// long *py : Y ɸ
// long *pw : 
// long *ph : ⤵
// bool flagFromWin : ɥƤФ줿?
////////////////////////////////////////////////////////////////

bool WinPos::get(
	win_kind_t kind,
	long *px, long *py,
	long *pw, long *ph,
	bool flagFromWin )
{
	if( !flagFromWin ){
		void *pWin = getWin( kind );
		if( pWin != NULL ){
#ifdef D_GTK
			gint gx, gy, gw, gh;
			gint bgnX, bgnY, endX, endY;

			// ɸ

			gdk_window_get_position(
					GTK_WIDGET( pWin )->window,
					&gx, &gy );
			gdk_window_get_root_origin(
					GTK_WIDGET( pWin )->window,
					&bgnX, &bgnY );
			gdk_window_get_origin(
					GTK_WIDGET( pWin )->window,
					&endX, &endY );

			gx -= endX - bgnX;
			gy -= endY - bgnY;

			// 

			gdk_window_get_size(
					GTK_WIDGET( pWin )->window,
					&gw, &gh );

			// 

			x = gx;
			y = gy;
			w = gw;
			h = gh;
#endif //D_GTK

#ifdef D_MFC
			CRect rect;
			((CWnd *)pWin)->GetWindowRect( &rect );

			x = rect.left;
			y = rect.top;
			w = rect.Width();
			h = rect.Height();
#endif //D_MFC

			bFlagEna = true;
		}
	}

	if( !bFlagEna )
		return false;

	if( px != NULL )
		*px = x;
	if( py != NULL )
		*py = y;
	if( pw != NULL )
		*pw = w;
	if( ph != NULL )
		*ph = h;

	return true;
}
