/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2008 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: call.cpp,v 1.70 2008/05/10 10:04:26 bowkenken Exp $
***************************************************************/

#define	CALL_CPP
#include	"inc.h"

#ifdef D_WS
extern WSCwindow *StatWin;
#endif

/***************************************************************
* ᥤ󡦥롼פΥåɤڤ
* void *(*func)( void * ) : 롦Хåؿ
* return : 顼̵ä
***************************************************************/

bool_t	call_game_thread_create( void *(*func)( void * ) )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( GameThreadCreate( func ) )
		return TRUE;
	else
		return FALSE;
#endif

	return TRUE;
}

/***************************************************************
* ᥤ󡦥롼פΥåɤλ
* void *(*func)( void * ) : 롦Хåؿ
* long code : λ
* return : 顼̵ä
***************************************************************/

bool_t	call_game_thread_exit(
	void *(*func)( void * ), long code
)
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( GameThreadExit( func, code ) )
		return TRUE;
	else
		return FALSE;
#endif

	return TRUE;
}

/***************************************************************
* ޥåסɥϢ³¹ԥܥΥå
* bool_t flagExec : 
***************************************************************/

void	call_gui_map_cont_exec_set( bool_t flagExec )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	if( flagExec ){
		set_label_text_button( GTK_BUTTON( gMapButtonContExec ),
				MSG_GUI_MAP_CONT_EXEC_ON, 0.5, 0.5 );
	} else {
		set_label_text_button( GTK_BUTTON( gMapButtonContExec ),
				MSG_GUI_MAP_CONT_EXEC_OFF, 0.5, 0.5 );
	}

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* ˥塼ɥ
* draw_menu_t *data : ˥塼ѥǡ
***************************************************************/

void	call_gui_menu_draw( draw_menu_t *data )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gGuiMenu.draw( data );

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiMenu.draw( data );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

#ifdef D_MFC
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gGuiMenu.draw( data );
#endif // D_MFC
}

/***************************************************************
* ˥塼ɥĤ
***************************************************************/

void	call_gui_menu_wipe( void )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gGuiMenu.wipe();

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiMenu.wipe();

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

#ifdef D_MFC
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gGuiMenu.wipe();
#endif // D_MFC
}

/***************************************************************
* ǥեȤܤ˥ޥư
* long sel_n : 
***************************************************************/

void	call_set_mouse_dflt_menu( long sel_n )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gGuiMenu.setMouseDfltMenu( sel_n );

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiMenu.setMouseDfltMenu( sel_n );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK
}

/***************************************************************
* å³ޡ
***************************************************************/

void	call_gui_message_set_flag_more( bool_t flag )
{
#ifdef D_WS
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiMessage.setFlagMore( flag );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

#ifdef D_MFC
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gGuiMessage.setFlagMore( (bool)(flag != FALSE) );
#endif // D_MFC
}

/***************************************************************
* åɥ
***************************************************************/

void	call_gui_message_draw( void )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

//@@@	gGuiMessage.draw();

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiMessage.draw( false );
	gGuiMessage.drawScrollBar();

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

#ifdef D_MFC
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gGuiMessage.draw( false );
	gGuiMessage.drawScrollBar();
#endif // D_MFC
}

/***************************************************************
* ϥɥ
***************************************************************/

void	call_gui_num_draw( long *n, long min, long max, long figure )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gGuiNum.draw( n, min, max, figure );

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiNum.draw( n, min, max, figure );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

#ifdef D_MFC
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gGuiNum.draw( n, min, max, figure );
#endif // D_MFC
}

/***************************************************************
* ϥɥĤ
***************************************************************/

void	call_gui_num_wipe( void )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gGuiNum.wipe();

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiNum.wipe();

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

#ifdef D_MFC
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gGuiNum.wipe();
#endif // D_MFC
}

/***************************************************************
* ʸϥɥ
***************************************************************/

void	call_gui_input_string_draw(
	const char *ttl, const char *str, long len
)
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gGuiInpStr.draw( ttl, str, len );

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

#if 0
//@@@
	gGuiInpStr.draw( ttl, str, len );
#endif

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

#ifdef D_MFC
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gGuiInpStr.draw( ttl, str, len );
#endif // D_MFC
}

/***************************************************************
* ʸϥɥĤ
***************************************************************/

void	call_gui_input_string_wipe( void )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gGuiInpStr.wipe();

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

#if 0
//@@@
	gGuiInpStr.wipe();
#endif

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

#ifdef D_MFC
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gGuiInpStr.wipe();
#endif // D_MFC
}

/***************************************************************
* եåǥ쥯ȥ
* char *dir : եåǥ쥯ȥ
***************************************************************/

void	set_str_dir_sel_graph( char *dir )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	FileList::setStrDirSelGraph( dir );
#endif
}

/***************************************************************
* եåΥ֥å򳫻
* return : 顼̵ä?
***************************************************************/

bool_t	call_sel_conf_eval_block_begin( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( gSelConf.evalBlockBegin() )
		return TRUE;
	else
		return FALSE;
#endif

	return TRUE;
}

/***************************************************************
* եåΥ֥åλ
* return : 顼̵ä?
***************************************************************/

bool_t	call_sel_conf_eval_block_end( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( gSelConf.evalBlockEnd() )
		return TRUE;
	else
		return FALSE;
#endif

	return TRUE;
}

/***************************************************************
* եåοͤ
* long token : ȡ
* long n : 
* return : 顼̵ä?
***************************************************************/

bool_t	call_sel_conf_eval_set_num( long token, long n )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( gSelConf.evalSetNum( (GraphConfToken)token, n ) )
		return TRUE;
	else
		return FALSE;
#endif

	return TRUE;
}

/***************************************************************
* եåʸ
* long token : ȡ
* WSCstring str : ʸ
* return : 顼̵ä?
***************************************************************/

bool_t	call_sel_conf_eval_set_str( long token, char *str )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( gSelConf.evalSetStr( (GraphConfToken)token, str ) )
		return TRUE;
	else
		return FALSE;
#endif

	return TRUE;
}

/***************************************************************
* СΥեåѥ򳫻
* mbr_t *mbr : С
***************************************************************/

bool_t	call_sel_mbr_graph_begin( mbr_t *mbr )
{
	bool_t flgWait = FALSE;

#ifdef D_WS
	if( !g_flg_gui )
		return FALSE;

	WSGIappDev()->lock();

	gSelMbrGraph = new SelMbrGraph;
	flgWait = gSelMbrGraph->exec( mbr );

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_gui )
		return FALSE;

	gdk_threads_enter();

	gSelMbrGraph = new SelMbrGraph;
	flgWait = gSelMbrGraph->exec( mbr );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

#ifdef D_MFC
	if( !g_flg_gui )
		return FALSE;

	TRY {
		gSelMbrGraph = new SelMbrGraph;
		flgWait = gSelMbrGraph->exec( mbr );
	} CATCH( CException, e ){
	} END_CATCH
#endif // D_MFC

	if( flgWait )
		return TRUE;
	else
		return FALSE;
}

/***************************************************************
* СΥեåѥλ
***************************************************************/

void	call_sel_mbr_graph_end( void )
{
#ifdef D_WS
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	delete gSelMbrGraph;

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	delete gSelMbrGraph;

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

#ifdef D_MFC
	if( !g_flg_gui )
		return;

	TRY {
		delete gSelMbrGraph;
	} CATCH( CException, e ){
	} END_CATCH
#endif // D_MFC
}

/***************************************************************
* եåѥΥꥻå
***************************************************************/

void	call_pcg_dun_reset( void )
{
#ifdef D_WS
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gPcgDun.reset();

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gPcgDun.reset();

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

#ifdef D_MFC
	if( !g_flg_gui )
		return;

	TRY {
		gPcgDun.reset();
	} CATCH( CException, e ){
	} END_CATCH
#endif // D_MFC
}

/***************************************************************
* Υޥåפ
***************************************************************/

void	call_pcg_dun_draw_turn( bool_t flg_first )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	if( flg_first )
		gPcgDun.setFlgUpdateRequest( true );

	WSGIappDev()->lock();

	gPcgDun.drawTurn();

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	if( flg_first )
		gPcgDun.setFlgUpdateRequest( true );

	gdk_threads_enter();

	gPcgDun.drawTurn();

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

#ifdef D_MFC
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	if( flg_first )
		gPcgDun.setFlgUpdateRequest( true );

	TRY {
		if( g_Dir3d.CheckRefreshFrameMode() )
			g_Dir3d.SetRefreshRequest( true );
		else
			gPcgDun.drawTurn();
	} CATCH( CException, e ){
	} END_CATCH
#endif // D_MFC
}

/***************************************************************
* ޥåפκ
***************************************************************/

void	call_pcg_dun_redraw( bool_t flgForce )
{
	bool bFlagForce;
	if( flgForce )
		bFlagForce = true;
	else
		bFlagForce = false;

#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gPcgDun.redraw( bFlagForce );

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gPcgDun.redraw( bFlagForce );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

#ifdef D_MFC
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	TRY {
		if( g_Dir3d.CheckRefreshFrameMode() )
			g_Dir3d.SetRefreshRequest( true );
		else
			gPcgDun.redraw( bFlagForce );
	} CATCH( CException, e ){
	} END_CATCH
#endif // D_MFC
}

/***************************************************************
* եåѥ
* long map_x : ޥåפ X ɸ
* long map_y : ޥåפ Y ɸ
* long map_w : ޥåפ
* long map_h : ޥåפι⤵
* bool_t flagForce : 
***************************************************************/

void	call_pcg_dun_draw(
	long map_x, long map_y,
	long map_w, long map_h,
	bool_t flagForce
)
{
	bool bFlagForce;
	if( flagForce )
		bFlagForce = true;
	else
		bFlagForce = false;

#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gPcgDun.draw( map_x, map_y, map_w, map_h, bFlagForce );

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gPcgDun.draw( map_x, map_y, map_w, map_h, bFlagForce );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

#ifdef D_MFC
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	TRY {
		if( g_Dir3d.CheckRefreshFrameMode() )
			g_Dir3d.SetRefreshRequest( true );
		else
			gPcgDun.draw( map_x, map_y, map_w, map_h, bFlagForce );
	} CATCH( CException, e ){
	} END_CATCH
#endif // D_MFC
}

/***************************************************************
* ޥåפΥ
* long map_x : ޥåפ X ɸ
* long map_y : ޥåפ Y ɸ
***************************************************************/

void	call_pcg_dun_scroll( long map_x, long map_y )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gPcgDun.scrollTile( map_x, map_y );

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gPcgDun.scrollTile( map_x, map_y );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

#ifdef D_MFC
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	TRY {
		gPcgDun.scrollTile( map_x, map_y );
	} CATCH( CException, e ){
	} END_CATCH
#endif // D_MFC
}

/***************************************************************
* 饯κüκɸ֤
* chr_t *chr : 饯
* bool_t flagPre : 1 κɸ
***************************************************************/

long	call_pcg_dun_get_chr_draw_left( chr_t *chr, bool_t flagPre )
{
	bool bFlagPre;
	if( flagPre )
		bFlagPre = true;
	else
		bFlagPre = false;

#ifdef D_WS
	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawLeft( chr, pPcg, bFlagPre );
	n = n / gPcgDun.getTileSizeX();

	return n;
#endif // D_WS

#ifdef D_GTK
	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawLeft( chr, pPcg, bFlagPre );
	n = n / gPcgDun.getTileSizeX();

	return n;
#endif // D_GTK

#ifdef D_MFC
	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawLeft( chr, pPcg, bFlagPre );
	n = n / gPcgDun.getTileSizeX();

	return n;
#endif // D_MFC

	if( flagPre )
		return get_chr_left( chr->pre_draw_x, chr->dx );
	else
		return get_chr_left( chr->x, chr->dx );
}

/***************************************************************
* 饯αüκɸ֤
* chr_t *chr : 饯
* bool_t flagPre : 1 κɸ
***************************************************************/

long	call_pcg_dun_get_chr_draw_right( chr_t *chr, bool_t flagPre )
{
	bool bFlagPre;
	if( flagPre )
		bFlagPre = true;
	else
		bFlagPre = false;

#ifdef D_WS
	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawRight( chr, pPcg, bFlagPre );
	n = (n + gPcgDun.getTileSizeX() - 1) / gPcgDun.getTileSizeX();

	return n;
#endif // D_WS

#ifdef D_GTK
	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawRight( chr, pPcg, bFlagPre );
	n = (n + gPcgDun.getTileSizeX() - 1) / gPcgDun.getTileSizeX();

	return n;
#endif // D_GTK

#ifdef D_MFC
	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawRight( chr, pPcg, bFlagPre );
	n = (n + gPcgDun.getTileSizeX() - 1) / gPcgDun.getTileSizeX();

	return n;
#endif // D_MFC

	if( flagPre )
		return get_chr_right( chr->pre_draw_x, chr->dx );
	else
		return get_chr_right( chr->x, chr->dx );
}

/***************************************************************
* 饯ξüκɸ֤
* chr_t *chr : 饯
* bool_t flagPre : 1 κɸ
***************************************************************/

long	call_pcg_dun_get_chr_draw_top( chr_t *chr, bool_t flagPre )
{
	bool bFlagPre;
	if( flagPre )
		bFlagPre = true;
	else
		bFlagPre = false;

#ifdef D_WS
	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawTop( chr, pPcg, bFlagPre );
	n = n / gPcgDun.getTileSizeY();

	return n;
#endif // D_WS

#ifdef D_GTK
	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawTop( chr, pPcg, bFlagPre );
	n = n / gPcgDun.getTileSizeY();

	return n;
#endif // D_GTK

#ifdef D_MFC
	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawTop( chr, pPcg, bFlagPre );
	n = n / gPcgDun.getTileSizeY();

	return n;
#endif // D_MFC

	if( flagPre )
		return get_chr_top( chr->pre_draw_y, chr->dy );
	else
		return get_chr_top( chr->y, chr->dy );
}

/***************************************************************
* 饯βüκɸ֤
* chr_t *chr : 饯
* bool_t flagPre : 1 κɸ
***************************************************************/

long	call_pcg_dun_get_chr_draw_bottom( chr_t *chr, bool_t flagPre )
{
	bool bFlagPre;
	if( flagPre )
		bFlagPre = true;
	else
		bFlagPre = false;

#ifdef D_WS
	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawBottom( chr, pPcg, bFlagPre );
	n = (n + gPcgDun.getTileSizeY() - 1) / gPcgDun.getTileSizeY();

	return n;
#endif // D_WS

#ifdef D_GTK
	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawBottom( chr, pPcg, bFlagPre );
	n = (n + gPcgDun.getTileSizeY() - 1) / gPcgDun.getTileSizeY();

	return n;
#endif // D_GTK

#ifdef D_MFC
	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawBottom( chr, pPcg, bFlagPre );
	n = (n + gPcgDun.getTileSizeY() - 1) / gPcgDun.getTileSizeY();

	return n;
#endif // D_MFC

	if( flagPre )
		return get_chr_bottom( chr->pre_draw_y, chr->dy );
	else
		return get_chr_bottom( chr->y, chr->dy );
}

/***************************************************************
* ɸޥåסɥɽϰ⤫Ĵ٤
* long mapX : Xɸ
* long mapY : Yɸ
* return : ޥåסɥɽϰ⤫?
***************************************************************/

bool_t	call_pcg_dun_clip_win( long mapX, long mapY )
{
#ifdef D_GTK
	return gPcgDun.clipWin( mapX, mapY );
#endif // D_GTK

#ifdef D_MFC
	return gPcgDun.clipWin( mapX, mapY );
#endif // D_MFC

	return true;
}

/***************************************************************
*  X ɸޥåסɥɽϰ⤫Ĵ٤
* long mapX : Xɸ
* return : ޥåסɥɽϰ⤫?
***************************************************************/

bool_t	call_pcg_dun_clip_win_x( long mapX )
{
#ifdef D_GTK
	return gPcgDun.clipWinX( mapX );
#endif // D_GTK

#ifdef D_MFC
	return gPcgDun.clipWinX( mapX );
#endif // D_MFC

	return true;
}

/***************************************************************
*  Y ɸޥåסɥɽϰ⤫Ĵ٤
* long mapY : Yɸ
* return : ޥåסɥɽϰ⤫?
***************************************************************/

bool_t	call_pcg_dun_clip_win_y( long mapY )
{
#ifdef D_GTK
	return gPcgDun.clipWinY( mapY );
#endif // D_GTK

#ifdef D_MFC
	return gPcgDun.clipWinY( mapY );
#endif // D_MFC

	return true;
}

/***************************************************************
* ơɥ
***************************************************************/

void	call_gui_stat_redraw( void )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	StatWin->redraw();

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiStat.redraw();

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

#ifdef D_MFC
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gGuiStat.redraw();
#endif // D_MFC
}

/***************************************************************
* ơɥ
* long n : СNo.
***************************************************************/

void	call_gui_stat_draw( long n )
{
#ifdef D_WS
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	StatWin->draw( n );

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gGuiStat.draw( n );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

#ifdef D_MFC
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gGuiStat.draw( n );
#endif // D_MFC
}

/***************************************************************
* ɥκɸ
* win_kind_t k : ɥμ
* long nx : X ɸ
* long ny : Y ɸ
* long nw : 
* long nh : ⤵
***************************************************************/

void	call_win_pos_set(
	win_kind_t k,
	long *px, long *py,
	long *pw, long *ph
)
{
	if( k < WIN_KIND_NULL )
		return;
	if( k >= WIN_KIND_MAX_N )
		return;

#ifdef D_WS
	if( !g_flg_gui )
		return;

	WSGIappDev()->lock();

	gWinPos[k].set( k, px, py, pw, ph, false );

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_gui )
		return;

	gdk_threads_enter();

	gWinPos[k].set( k, px, py, pw, ph, false );

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

#ifdef D_MFC
	if( !g_flg_gui )
		return;

	gWinPos[k].set( k, px, py, pw, ph, false );
#endif // D_MFC
}

/***************************************************************
* ɥκɸμ
* win_kind_t k : ɥμ
* long *px : X ɸ
* long *py : Y ɸ
* long *pw : 
* long *ph : ⤵
* return : Ǥ?
***************************************************************/

bool_t	call_win_pos_get(
	win_kind_t k,
	long *px, long *py,
	long *pw, long *ph
)
{
	if( k < WIN_KIND_NULL )
		return FALSE;
	if( k >= WIN_KIND_MAX_N )
		return FALSE;

	bool_t result = FALSE;

#ifdef D_WS
	if( !g_flg_gui )
		return TRUE;

	WSGIappDev()->lock();

	if( gWinPos[k].get( k, px, py, pw, ph, false ) )
		result = TRUE;

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_gui )
		return TRUE;

	gdk_threads_enter();

	if( gWinPos[k].get( k, px, py, pw, ph, false ) )
		result = TRUE;

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

#ifdef D_MFC
	if( !g_flg_gui )
		return TRUE;

	if( gWinPos[k].get( k, px, py, pw, ph, false ) )
		result = TRUE;
#endif // D_MFC

	return result;
}

/***************************************************************
* ʸ
* return : Ϥ줿
***************************************************************/

long	call_key_get_char( void )
{
	long	c = '\0';

#ifdef D_WS
	if( !g_flg_init )
		return c;
	if( !g_flg_gui )
		return c;

	WSGIappDev()->lock();

	c = gKey.getChar();

	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	if( !g_flg_init )
		return c;
	if( !g_flg_gui )
		return c;

	gdk_threads_enter();

	c = gKey.getChar();

	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

#ifdef D_MFC
	if( !g_flg_init )
		return c;
	if( !g_flg_gui )
		return c;

	c = gKey.getChar();
#endif // D_MFC

	return c;
}

/***************************************************************
* ϤΥ
* long n :  (ߥ)
***************************************************************/

void	call_sleep( long n )
{
#ifdef	D_MFC
	::Sleep( n );
#endif	/* D_MFC */
}
