/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2008 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: gf-outmap.c,v 1.1 2008/05/07 07:31:26 bowkenken Exp $
***************************************************************/

/***************************************************************
* ե (ޥåפ)
***************************************************************/

#define	GFILE_C
#include	"inc.h"

/***************************************************************
* ޥåפϤե̾桼Ϥ
* char *s : ե̾
* return : ե̾(󥻥ʤ NULL)
***************************************************************/

char	*get_out_map_file_name( char *s )
{
	long	i;
	const long	max_i = LOOP_MAX_1000;
	static char	fname[FILE_NAME_MAX_LEN + 1];
	static char	num_s[10 + 1];
	long	y;
	ask_t	ask;

	set_map_total( 0, 0, MAP_MAX_X, MAP_MAX_Y );
	wipe_all();

	/* ǥեȤΥե̾ */
	for( i = 0; i < max_i; i++ ){
		sprintf( num_s, STR_EXT_NAME_OUT_MAP, i );

		str_nz_cpy( fname, dir_name_game, FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, STR_SLASH,
				FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, STR_DIR_NAME_OUT_MAP,
				FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, STR_SLASH,
				FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, STR_FILE_NAME_OUT_MAP,
				FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, num_s,
				FILE_NAME_MAX_LEN );

		if( !chk_exist_file( fname ) )
			break;
	}
	if( i >= max_i )
		return NULL;

	y = 0;
	print_str( 0, y, MSG_OUT_MAP_FILE_1 );
	y++;
	print_str( 0, y, MSG_OUT_MAP_FILE_2, fname );
	y++;

	/* ե̾ */
	str_nz_cpy( s, fname, FILE_NAME_MAX_LEN );
	game_gets( -1, -1, MSG_OUT_MAP_FILE_1,
			s, FILE_NAME_MAX_LEN, TRUE );

	if( s[0] == '\0' ){
		str_nz_cpy( s, fname, FILE_NAME_MAX_LEN );
	} else if( (s[0] == '/') || (s[0] == '~') ){
		str_nz_cpy( fname, s, FILE_NAME_MAX_LEN );
	} else {
		str_nz_cpy( fname, dir_name_game, FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, STR_SLASH,
				FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, STR_DIR_NAME_OUT_MAP,
				FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, STR_SLASH,
				FILE_NAME_MAX_LEN );
		str_max_n_cat( fname, s,
				FILE_NAME_MAX_LEN );

		str_nz_cpy( s, fname, FILE_NAME_MAX_LEN );
	}

	print_str( 0, y, MSG_OUT_MAP_FILE_3, fname );
	y++;

	/* ˽Ϥ뤫ǧȤ */
	ask = exec_menu_ask( MSG_OUT_MAP_FILE_ASK_OK, ASK_NO, FALSE );

	wipe_menu();

	switch( ask ){
	case ASK_YES:
		return s;
	case ASK_NO:
	case ASK_CANCEL:
	case ASK_ERR:
		break;
	}

	return NULL;
}

/***************************************************************
* ޥåפե˽Ϥ
* return : 顼̵ä?
***************************************************************/

bool_t	out_map_file( void )
{
	static char	fname[FILE_NAME_MAX_LEN + 1];
	long	x, y;
	dun_t	*dun;
	FILE	*fp;

	if( get_out_map_file_name( fname ) == NULL )
		return FALSE;

	fp = fopen( fname, "w" );
	if( fp == NULL )
		return FALSE;

	reset_load_save( fname, TRUE );

	dun = get_dun();

	for( y = 0; y < MAP_MAX_Y; y++ ){
		for( x = 0; x < MAP_MAX_X; x++ ){
			fprintf( fp, "%c%c",
					dun->map.total.mjr[y][x],
					dun->map.total.mnr[y][x] );
		}
		fprintf( fp, "\n" );
	}

	if( fclose( fp ) == EOF )
		return FALSE;

	return TRUE;
}
