/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2009 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: call.cpp,v 1.107 2009/07/04 01:24:13 bowkenken Exp $
***************************************************************/

#define	CALL_CPP
#include	"inc.h"

#ifdef D_WS
extern WSCwindow *StatWin;
#endif

static long g_joy_n = 0;
static joy_kind_t g_joy_kind = JOY_KIND_PS;

static long g_win_x[WIN_KIND_MAX_N];
static long g_win_y[WIN_KIND_MAX_N];
static long g_win_w[WIN_KIND_MAX_N];
static long g_win_h[WIN_KIND_MAX_N];

/***************************************************************
* GUI åɤΥå
***************************************************************/

void	gui_begin( void )
{
#ifdef D_WS
	WSGIappDev()->lock();
#endif // D_WS

#ifdef D_GTK
	gdk_threads_enter();
#endif // D_GTK

#ifdef D_MFC
#endif // D_MFC
}

/***************************************************************
* GUI åɤΥå
***************************************************************/

void	gui_end( void )
{
#ifdef D_WS
	WSGIappDev()->unlock();
#endif // D_WS

#ifdef D_GTK
	gdk_flush();
	gdk_threads_leave();
#endif // D_GTK

#ifdef D_MFC
#endif // D_MFC
}

/***************************************************************
* ᥤ󡦥롼פΥåɤڤ
* void *(*func)( void * ) : 롦Хåؿ
* return : 顼̵ä
***************************************************************/

bool_t	call_game_thread_create( void *(*func)( void * ) )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( GameThreadCreate( func ) )
		return TRUE;
	else
		return FALSE;
#endif

	return TRUE;
}

/***************************************************************
* ᥤ󡦥롼פΥåɤλ
* void *(*func)( void * ) : 롦Хåؿ
* long code : λ
* return : 顼̵ä
***************************************************************/

bool_t	call_game_thread_exit(
	void *(*func)( void * ), long code
)
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( GameThreadExit( func, code ) )
		return TRUE;
	else
		return FALSE;
#endif

	return TRUE;
}

/***************************************************************
* ޡͭˤ
***************************************************************/

void	call_ena_timer( void )
{
#ifdef D_GTK
	ena_timer();
#endif // D_GTK
}

/***************************************************************
* ޥåסɥϢ³¹ԥܥΥå
* bool_t flagExec : 
***************************************************************/

void	call_gui_map_cont_exec_set( bool_t flagExec )
{
#ifdef D_GTK
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	if( flagExec ){
		set_label_text_button( GTK_BUTTON( gMapButtonContExec ),
				MSG_GUI_MAP_CONT_EXEC_ON, 0.5, 0.5 );
	} else {
		set_label_text_button( GTK_BUTTON( gMapButtonContExec ),
				MSG_GUI_MAP_CONT_EXEC_OFF, 0.5, 0.5 );
	}

	gui_end();
#endif // D_GTK
}

/***************************************************************
* ơС˥ҥȤɽ
***************************************************************/

void	call_gui_map_print_stat_bar_hint( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	guiMapPrintStatBarHint();

	gui_end();
#endif
}

/***************************************************************
* ˥塼ɥ
* draw_menu_t *data : ˥塼ѥǡ
***************************************************************/

void	call_gui_menu_draw( draw_menu_t *data )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiMenu.draw( data );

	gui_end();
#endif
}

/***************************************************************
* ˥塼ɥĤ
***************************************************************/

void	call_gui_menu_wipe( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiMenu.wipe();

	gui_end();
#endif
}

/***************************************************************
* ǥեȤܤ˥ޥư
* long sel_n : 
***************************************************************/

void	call_set_mouse_dflt_menu( long sel_n )
{
#ifndef D_MFC
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiMenu.setMouseDfltMenu( sel_n );

	gui_end();
#endif
#endif // ! D_MFC
}

/***************************************************************
* å³ޡ
***************************************************************/

void	call_gui_message_set_flag_more( bool_t flag )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiMessage.setFlagMore( (bool)(flag != FALSE) );

	gui_end();
#endif
}

/***************************************************************
* åɥ
***************************************************************/

void	call_gui_message_draw( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiMessage.draw( false );
	gGuiMessage.drawScrollBar();

	gui_end();
#endif
}

/***************************************************************
* ϥɥ
***************************************************************/

void	call_gui_num_draw(
	volatile long *n, long min, long max, long figure
)
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiNum.draw( n, min, max, figure );

	gui_end();
#endif
}

/***************************************************************
* ϥɥĤ
***************************************************************/

void	call_gui_num_wipe( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiNum.wipe();

	gui_end();
#endif
}

/***************************************************************
* ʸϥɥ
***************************************************************/

void	call_gui_input_string_draw(
	const char *ttl, const char *str, long len
)
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiInpStr.draw( ttl, str, len );

	gui_end();
#endif
}

/***************************************************************
* ʸϥɥĤ
***************************************************************/

void	call_gui_input_string_wipe( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiInpStr.wipe();

	gui_end();
#endif
}

/***************************************************************
* 쥦ɥ
* const char *name : ̾
* const char *str : 
***************************************************************/

void	call_gui_words_draw( const char *name, const char *str )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiWords.draw( name, str );

	gui_end();
#endif
}

/***************************************************************
* 쥦ɥ (ɽ)
* const char *name : ̾
* const char *str : 
* long w : ɽ
***************************************************************/

void	call_gui_words_draw_width(
	const char *name, const char *str,
	long w
)
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiWords.draw( name, str, w );

	gui_end();
#endif
}

/***************************************************************
* 쥦ɥĤ
***************************************************************/

void	call_gui_words_wipe( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiWords.wipe();

	gui_end();
#endif
}

/***************************************************************
* ץ쥤ɥ򳫻
***************************************************************/

void	call_gui_replay_bgn( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiReplay.bgn();

	gui_end();
#endif
}

/***************************************************************
* ץ쥤ɥλ
***************************************************************/

void	call_gui_replay_end( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiReplay.end();

	gui_end();
#endif
}

/***************************************************************
* ץ쥤ɥ
***************************************************************/

void	call_gui_replay_draw( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiReplay.draw();

	gui_end();
#endif
}

/***************************************************************
* ץ쥤ɥĤ
***************************************************************/

void	call_gui_replay_wipe( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiReplay.wipe();

	gui_end();
#endif
}

/***************************************************************
* 饹ǥɥ
* class_t *p : 饹
***************************************************************/

void	call_gui_class_edit_draw( class_t *p )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiClassEdit.draw( p );

	gui_end();
#endif
}

/***************************************************************
* 饹ǥɥĤ
***************************************************************/

void	call_gui_class_edit_wipe( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiClassEdit.wipe();

	gui_end();
#endif
}

/***************************************************************
* 롦ǥɥ
* class_t *p : 饹
***************************************************************/

void	call_gui_skill_edit_draw( class_t *p )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiSkillEdit.draw( p );

	gui_end();
#endif
}

/***************************************************************
* 롦ǥɥĤ
***************************************************************/

void	call_gui_skill_edit_wipe( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiSkillEdit.wipe();

	gui_end();
#endif
}

/***************************************************************
* 饯ȡɥ
***************************************************************/

void	call_gui_chr_sheet_draw( mbr_t *org, mbr_t *mbr )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiChrSheet.draw( org, mbr );

	gui_end();
#endif
}

/***************************************************************
* 饯ȡɥ
* mbr_t *org : Υ饯ǡ
* mbr_t *mbr : ԽΥ饯ǡ
***************************************************************/

void	call_gui_chr_sheet_redraw( mbr_t *org, mbr_t *mbr )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiChrSheet.redraw();

	gui_end();
#endif
}

/***************************************************************
* 饯ȡɥĤ
***************************************************************/

void	call_gui_chr_sheet_wipe()
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiChrSheet.wipe();

	gui_end();
#endif
}

/***************************************************************
* եåǥ쥯ȥ
* char *dir : եåǥ쥯ȥ
***************************************************************/

void	call_set_str_dir_sel_graph( char *dir )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	FileList::setStrDirSelGraph( dir );
#endif
}

/***************************************************************
* եåΥ֥å򳫻
* return : 顼̵ä?
***************************************************************/

bool_t	call_sel_conf_eval_block_begin( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( gSelConf.evalBlockBegin() )
		return TRUE;
	else
		return FALSE;
#endif

	return TRUE;
}

/***************************************************************
* եåΥ֥åλ
* return : 顼̵ä?
***************************************************************/

bool_t	call_sel_conf_eval_block_end( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( gSelConf.evalBlockEnd() )
		return TRUE;
	else
		return FALSE;
#endif

	return TRUE;
}

/***************************************************************
* եåοͤ
* long token : ȡ
* long n : 
* return : 顼̵ä?
***************************************************************/

bool_t	call_sel_conf_eval_set_num( long token, long n )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( gSelConf.evalSetNum( (GraphConfToken)token, n ) )
		return TRUE;
	else
		return FALSE;
#endif

	return TRUE;
}

/***************************************************************
* եåʸ
* long token : ȡ
* WSCstring str : ʸ
* return : 顼̵ä?
***************************************************************/

bool_t	call_sel_conf_eval_set_str( long token, char *str )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( gSelConf.evalSetStr( (GraphConfToken)token, str ) )
		return TRUE;
	else
		return FALSE;
#endif

	return TRUE;
}

/***************************************************************
* СΥեåѥ򳫻
* mbr_t *mbr : С
***************************************************************/

bool_t	call_sel_mbr_graph_begin( mbr_t *mbr )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	bool_t flgWait = FALSE;

	if( !g_flg_gui )
		return FALSE;

	gui_begin();

	if( gSelMbrGraph == NULL )
		gSelMbrGraph = new SelMbrGraph;
	flgWait = gSelMbrGraph->exec( mbr );

	gui_end();

	if( flgWait )
		return TRUE;
	else
		return FALSE;
#endif

	return FALSE;
}

/***************************************************************
* СΥեåѥλ
***************************************************************/

void	call_sel_mbr_graph_end( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_gui )
		return;

	gui_begin();

	delete gSelMbrGraph;
	gSelMbrGraph = NULL;

	gui_end();
#endif
}

/***************************************************************
* եåѥΥꥻå
***************************************************************/

void	call_pcg_dun_reset( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_gui )
		return;

	gui_begin();

	gPcgDun.reset();

	gui_end();
#endif
}

/***************************************************************
* СΥեåѥΥꥻå
***************************************************************/

void	call_pcg_dun_reload_all_mbr( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_gui )
		return;

	gui_begin();

	gPcgDun.reloadAllMbr();

	gui_end();
#endif
}

/***************************************************************
* Υޥåפ
***************************************************************/

void	call_pcg_dun_draw_turn( bool_t flg_first )
{
#if	defined( D_WS ) || defined( D_GTK )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	if( flg_first )
		gPcgDun.setFlgUpdateRequest( true );

	gui_begin();

	gPcgDun.drawTurn();

	gui_end();
#endif

#ifdef D_MFC
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	if( flg_first )
		gPcgDun.setFlgUpdateRequest( true );

	TRY {
		if( g_Dir3d.CheckRefreshFrameMode() )
			g_Dir3d.SetRefreshRequest( true );
		else
			gPcgDun.drawTurn();
	} CATCH( CException, e ){
	} END_CATCH
#endif // D_MFC
}

/***************************************************************
* ޥåפκ
***************************************************************/

void	call_pcg_dun_redraw( bool_t flgForce )
{
	bool bFlagForce;
	if( flgForce )
		bFlagForce = true;
	else
		bFlagForce = false;

#if	defined( D_WS ) || defined( D_GTK )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gPcgDun.redraw( bFlagForce );

	gui_end();
#endif

#ifdef D_MFC
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	TRY {
		if( g_Dir3d.CheckRefreshFrameMode() )
			g_Dir3d.SetRefreshRequest( true );
		else
			gPcgDun.redraw( bFlagForce );
	} CATCH( CException, e ){
	} END_CATCH
#endif // D_MFC
}

/***************************************************************
* եåѥ
* long map_x : ޥåפ X ɸ
* long map_y : ޥåפ Y ɸ
* long map_w : ޥåפ
* long map_h : ޥåפι⤵
* bool_t flagForce : 
***************************************************************/

void	call_pcg_dun_draw(
	long map_x, long map_y,
	long map_w, long map_h,
	bool_t flagForce
)
{
	bool bFlagForce;
	if( flagForce )
		bFlagForce = true;
	else
		bFlagForce = false;

#if	defined( D_WS ) || defined( D_GTK )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gPcgDun.draw( map_x, map_y, map_w, map_h, bFlagForce );

	gui_end();
#endif

#ifdef D_MFC
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	TRY {
		if( g_Dir3d.CheckRefreshFrameMode() )
			g_Dir3d.SetRefreshRequest( true );
		else
			gPcgDun.draw( map_x, map_y, map_w, map_h, bFlagForce );
	} CATCH( CException, e ){
	} END_CATCH
#endif // D_MFC
}

/***************************************************************
* XX ιǡ
* xx_act_kind_t kind : μ
* void *p : Υǡ
***************************************************************/

void	call_pcg_dun_set_xx_attack(
	long kind, void *p )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gPcgDun.setXxAttack( (xx_act_kind_t)kind, p );
#endif
}

/***************************************************************
* ƥȡ⡼ɤλޥåפʸ
* long scrn_x : X ɸ
* long scrn_y : Y ɸ
* const char *s : եޥåʸ
* ... : եޥåȤΰ
***************************************************************/

void	call_pcg_dun_draw_string(
	long scrn_x, long scrn_y,
	const char *s, ... )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	va_list	argptr;
	static char	buf[SCREEN_WIDTH * CHAR_MAX_LEN_UTF_8 + 1];
	const long	max_len = SCREEN_WIDTH * CHAR_MAX_LEN_UTF_8;

	va_start( argptr, s );
	vsn_printf( buf, max_len, s, argptr );
	va_end( argptr );

	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gPcgDun.drawString( scrn_x, scrn_y, MSG_S, buf );

	gui_end();
#endif
}

/***************************************************************
* VFX 
* long scrn_x : X ɸ
* long scrn_y : Y ɸ
* long scrn_w : 
* long scrn_h : ⤵
***************************************************************/

void	call_pcg_dun_draw_vfx(
	long scrn_x, long scrn_y,
	long scrn_w, long scrn_h )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gPcgDun.drawVfx( scrn_x, scrn_y, scrn_w, scrn_h, false );

	gui_end();
#endif
}

/***************************************************************
* ޥåפΥ
* long map_x : ޥåפ X ɸ
* long map_y : ޥåפ Y ɸ
***************************************************************/

void	call_pcg_dun_scroll( long map_x, long map_y )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gPcgDun.scrollTile( map_x, map_y );

	gui_end();
#endif
}

/***************************************************************
* 롦ѥ֤
* bool_t flagSub : ֡뤫?
* return : 
***************************************************************/

long	call_pcg_dun_get_crsr_width( bool_t flagSub )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	return gPcgDun.getCrsrWidth( !!flagSub );
#endif

	return 0;
}

/***************************************************************
* 롦ѥι⤵֤
* bool_t flagSub : ֡뤫?
* return : ⤵
***************************************************************/

long	call_pcg_dun_get_crsr_height( bool_t flagSub )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	return gPcgDun.getCrsrHeight( !!flagSub );
#endif

	return 0;
}

/***************************************************************
* 饯κüκɸ֤
* chr_t *chr : 饯
* bool_t flagPre : 1 κɸ
* return : üκɸ
***************************************************************/

long	call_pcg_dun_get_chr_draw_left( chr_t *chr, bool_t flagPre )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	bool bFlagPre;
	if( flagPre )
		bFlagPre = true;
	else
		bFlagPre = false;

	if( g_flg_text_mode ){
		if( flagPre )
			return get_chr_left( chr->pre_draw_x, chr->dx );
		else
			return get_chr_left( chr->x, chr->dx );
	}

	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawLeft( chr, pPcg, bFlagPre );
	n = n / gPcgDun.getTileSizeX();

	return n;
#endif

	if( flagPre )
		return get_chr_left( chr->pre_draw_x, chr->dx );
	else
		return get_chr_left( chr->x, chr->dx );
}

/***************************************************************
* 饯αüκɸ֤
* chr_t *chr : 饯
* bool_t flagPre : 1 κɸ
* return : üκɸ
***************************************************************/

long	call_pcg_dun_get_chr_draw_right( chr_t *chr, bool_t flagPre )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	bool bFlagPre;
	if( flagPre )
		bFlagPre = true;
	else
		bFlagPre = false;

	if( g_flg_text_mode ){
		if( flagPre )
			return get_chr_right( chr->pre_draw_x, chr->dx );
		else
			return get_chr_right( chr->x, chr->dx );
	}

	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawRight( chr, pPcg, bFlagPre );
	n = (n + gPcgDun.getTileSizeX() - 1) / gPcgDun.getTileSizeX();

	return n;
#endif

	if( flagPre )
		return get_chr_right( chr->pre_draw_x, chr->dx );
	else
		return get_chr_right( chr->x, chr->dx );
}

/***************************************************************
* 饯ξüκɸ֤
* chr_t *chr : 饯
* bool_t flagPre : 1 κɸ
* return : üκɸ
***************************************************************/

long	call_pcg_dun_get_chr_draw_top( chr_t *chr, bool_t flagPre )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	bool bFlagPre;
	if( flagPre )
		bFlagPre = true;
	else
		bFlagPre = false;

	if( g_flg_text_mode ){
		if( flagPre )
			return get_chr_top( chr->pre_draw_y, chr->dy );
		else
			return get_chr_top( chr->y, chr->dy );
	}

	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawTop( chr, pPcg, bFlagPre );
	n = n / gPcgDun.getTileSizeY();

	return n;
#endif

	if( flagPre )
		return get_chr_top( chr->pre_draw_y, chr->dy );
	else
		return get_chr_top( chr->y, chr->dy );
}

/***************************************************************
* 饯βüκɸ֤
* chr_t *chr : 饯
* bool_t flagPre : 1 κɸ
* return : üκɸ
***************************************************************/

long	call_pcg_dun_get_chr_draw_bottom( chr_t *chr, bool_t flagPre )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	bool bFlagPre;
	if( flagPre )
		bFlagPre = true;
	else
		bFlagPre = false;

	if( g_flg_text_mode ){
		if( flagPre )
			return get_chr_bottom( chr->pre_draw_y, chr->dy );
		else
			return get_chr_bottom( chr->y, chr->dy );
	}

	Pcg *pPcg = gPcgDun.getChrPcg( chr );

	long n = gPcgDun.getChrDrawBottom( chr, pPcg, bFlagPre );
	n = (n + gPcgDun.getTileSizeY() - 1) / gPcgDun.getTileSizeY();

	return n;
#endif

	if( flagPre )
		return get_chr_bottom( chr->pre_draw_y, chr->dy );
	else
		return get_chr_bottom( chr->y, chr->dy );
}

/***************************************************************
* ɸޥåסɥɽϰ⤫Ĵ٤
* long mapX : Xɸ
* long mapY : Yɸ
* return : ޥåסɥɽϰ⤫?
***************************************************************/

bool_t	call_pcg_dun_clip_win( long mapX, long mapY )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	return gPcgDun.clipWin( mapX, mapY );
#endif

	return TRUE;
}

/***************************************************************
*  X ɸޥåסɥɽϰ⤫Ĵ٤
* long mapX : Xɸ
* return : ޥåסɥɽϰ⤫?
***************************************************************/

bool_t	call_pcg_dun_clip_win_x( long mapX )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	return gPcgDun.clipWinX( mapX );
#endif

	return TRUE;
}

/***************************************************************
*  Y ɸޥåסɥɽϰ⤫Ĵ٤
* long mapY : Yɸ
* return : ޥåסɥɽϰ⤫?
***************************************************************/

bool_t	call_pcg_dun_clip_win_y( long mapY )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	return gPcgDun.clipWinY( mapY );
#endif

	return TRUE;
}

/***************************************************************
* 饹ܥΥǥ⤬äĴ٤
* return : ǥ⤬ä?
***************************************************************/

void	call_demo_last_boss_reset( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	if( gPcgDun.pDemoLastBoss == NULL )
		return;

	gPcgDun.pDemoLastBoss->reset();
#endif
}

/***************************************************************
* 饹ܥΥǥ⤬äĴ٤
* return : ǥ⤬ä?
***************************************************************/

bool_t	call_demo_last_boss_check_done( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return TRUE;
	if( !g_flg_gui )
		return TRUE;

	if( gPcgDun.pDemoLastBoss == NULL )
		return TRUE;

	if( gPcgDun.pDemoLastBoss->checkDone() )
		return TRUE;
	else
		return FALSE;
#endif

	return TRUE;
}

/***************************************************************
* ˹礻 BGM κ
* bool_t flg_gui : GUI ƤФ줿?
***************************************************************/

void	call_game_music_play_scene( bool_t flg_gui )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !flg_gui )
		gui_begin();

	gMusic.playScene();

	if( !flg_gui )
		gui_end();
#endif
}

/***************************************************************
* BGM κ
* music_kind_t kind : BGM μ
* long idx : BGM ꥹȤΥǥå
***************************************************************/

void	call_game_music_play( long kind, long idx )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	gui_begin();

	gMusic.play( (music_kind_t)kind, idx );

	gui_end();
#endif
}

/***************************************************************
* BGM κƺ
***************************************************************/

void	call_game_music_replay( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	gui_begin();

	gMusic.replay();

	gui_end();
#endif
}

/***************************************************************
* SE κ
* sound_kind_t kind : SE μ
* long n : 
***************************************************************/

void	call_game_sound_play( long kind, long n )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	gui_begin();

	gSound.play( (sound_kind_t)kind, n );

	gui_end();
#endif
}

/***************************************************************
* SE 
***************************************************************/

void	call_game_sound_stop( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	gui_begin();

	gSound.stop();

	gui_end();
#endif
}

/***************************************************************
* Υ祤ƥåֹ֤
* return : 祤ƥåֹ
***************************************************************/

long	call_game_joystick_get_joy( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	{
		long	n;

		gui_begin();

		n = gJoystick.getJoy();

		gui_end();

		return n;
	}
#endif

	return g_joy_n;
}

/***************************************************************
* 祤ƥå
* long n : 祤ƥåֹ
***************************************************************/

void	call_game_joystick_sel_joy( long n )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	gui_begin();

	gJoystick.selJoy( n );

	gui_end();
#endif

	g_joy_n = n;
}

/***************************************************************
* 祤ƥå֤̾
* long n : 祤ƥåֹ
* return : 祤ƥå̾
***************************************************************/

const char	*call_game_joystick_get_name( long n )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	{
		const char	*s;

		gui_begin();

		s = gJoystick.getName( n );

		gui_end();

		return s;
	}
#endif

	return NULL;
}

/***************************************************************
* 祤ƥåμ֤
* return : 祤ƥåμ
***************************************************************/

long	call_game_joystick_get_kind( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	{
		long	n;

		gui_begin();

		n = gJoystick.getKind();

		gui_end();

		return n;
	}
#endif

	return g_joy_kind;
}

/***************************************************************
* 祤ƥåμ
* joy_kind_t kind : 祤ƥåμ
***************************************************************/

void	call_game_joystick_set_kind( long kind )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	gui_begin();

	gJoystick.setKind( (joy_kind_t)kind );

	gui_end();
#endif

	g_joy_kind = (joy_kind_t)kind;
}

/***************************************************************
* ơɥ
***************************************************************/

void	call_gui_stat_redraw( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiStat.redraw();

	gui_end();
#endif
}

/***************************************************************
* ơɥ
* long n : СNo.
***************************************************************/

void	call_gui_stat_draw( long n )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gGuiStat.draw( n );

	gui_end();
#endif
}

/***************************************************************
* ɥκɸ
* win_kind_t k : ɥμ
* long nx : X ɸ
* long ny : Y ɸ
* long nw : 
* long nh : ⤵
***************************************************************/

void	call_win_pos_set(
	win_kind_t k,
	long *px, long *py,
	long *pw, long *ph
)
{
	if( k < WIN_KIND_NULL )
		return;
	if( k >= WIN_KIND_MAX_N )
		return;

#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( g_flg_gui ){
		gui_begin();

		gWinPos[k].set( k, px, py, pw, ph );

		gui_end();

		return;
	}
#endif

	if( px != NULL )
		g_win_x[k] = *px;
	if( py != NULL )
		g_win_y[k] = *py;
	if( pw != NULL )
		g_win_w[k] = *pw;
	if( ph != NULL )
		g_win_h[k] = *ph;
}

/***************************************************************
* ɥκɸμ
* win_kind_t k : ɥμ
* long *px : X ɸ
* long *py : Y ɸ
* long *pw : 
* long *ph : ⤵
* return : Ǥ?
***************************************************************/

bool_t	call_win_pos_get(
	win_kind_t k,
	long *px, long *py,
	long *pw, long *ph
)
{
	if( k < WIN_KIND_NULL )
		return FALSE;
	if( k >= WIN_KIND_MAX_N )
		return FALSE;

#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( g_flg_gui ){
		gui_begin();

		gWinPos[k].get( k, px, py, pw, ph );

		gui_end();

		return TRUE;
	}
#endif

	if( px != NULL )
		*px = g_win_x[k];
	if( py != NULL )
		*py = g_win_y[k];
	if( pw != NULL )
		*pw = g_win_w[k];
	if( ph != NULL )
		*ph = g_win_h[k];

	if( pw != NULL )
		if( *pw <= 0 )
			*pw = 256;
	if( ph != NULL )
		if( *ph <= 0 )
			*ph = 256;

	return TRUE;
}

/***************************************************************
* ʸ
* return : Ϥ줿
***************************************************************/

long	call_key_get_char( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	long	c = '\0';

	if( !g_flg_init )
		return c;
	if( !g_flg_gui )
		return c;

	gui_begin();

	c = gKey.getChar();

	gui_end();

	return c;
#endif

	return '\0';
}

/***************************************************************
* 뤬ư˥ޥåפ򥹥뤹
***************************************************************/

void	call_key_check_move_crsr( void )
{
#if	defined( D_WS ) || defined( D_GTK ) || defined( D_MFC )
	if( !g_flg_init )
		return;
	if( !g_flg_gui )
		return;

	gui_begin();

	gKey.CheckMoveCrsr();

	gui_end();
#endif
}

/***************************************************************
* ϤΥ
* long n :  (ߥ)
***************************************************************/

void	call_sleep( long n )
{
#ifdef	D_MFC
	::Sleep( n );
#endif	/* D_MFC */
}
