/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2009 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: DemoEnding.h,v 1.5 2009/07/31 19:03:01 bowkenken Exp $
***************************************************************/

#ifndef DEMO_ENDING_H
#define DEMO_ENDING_H	1

////////////////////////////////////////////////////////////////
// ǥ󥰡ǥ
////////////////////////////////////////////////////////////////

#ifdef D_GTK
# include <gtk/gtk.h>
#endif /* D_GTK */

#ifdef D_MFC
# include "xlnl-dows/stdafx.h"
# include "xlnl-dows/xlnl-dows.h"
# include "xlnl-dows/Dir3dText.h"
#endif // D_MFC

#include "Pcg.h"
#include "DemoSpace.h"

////////////////////////////////////////////////////////////////

#define	EPILOGUE_MAX_LEN	40
#define	EPILOGUE_LINE_MAX_N	16

////////////////////////////////////////////////////////////////

class DemoEnding {
public:
	DemoSpace space;

private:
	// Ф줿Υեֹ
	long nRandmSel;
	// Υե
	long nMaxFile;
	// 
	Pcg pcgEpilogue;
	Pcg pcgSpace;

	long frame;
	time_t wait_time;

	// ˥Ѻɸ
	long len;
	long w, h;
	long baseX[EPILOGUE_LINE_MAX_N];
	long baseY[EPILOGUE_LINE_MAX_N];
	long mx[EPILOGUE_LINE_MAX_N][EPILOGUE_MAX_LEN];
	long my[EPILOGUE_LINE_MAX_N][EPILOGUE_MAX_LEN];
	long x[EPILOGUE_LINE_MAX_N][EPILOGUE_MAX_LEN];
	long y[EPILOGUE_LINE_MAX_N][EPILOGUE_MAX_LEN];

#ifdef D_GTK
	// եȤΥ
	GtkStyle *pStyle;
#endif // D_GTK

#ifdef D_MFC
	// եȤΥ
	void *pStyle;
	LOGFONT mFontDesc;
	CFont *pFont;

	CDir3dText mD3;
#endif // D_MFC

public:
	DemoEnding();
	~DemoEnding();
	void init();

	bool draw();

private:
	void initAnime();

	bool drawEpilogue();
	bool drawSpace( bool flagDrawTheEnd );
	void drawEpilogueStory( long frame );

	void drawString();
	void drawCharStd( long x, long y, const char *str );
	void drawChar(
		long r, long g, long b,
		long x, long y, const char *str );
};

#endif // DEMO_ENDING_H
