/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2009 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: DemoSpace.cpp,v 1.15 2009/07/31 19:03:01 bowkenken Exp $
***************************************************************/

////////////////////////////////////////////////////////////////
// ǥ
////////////////////////////////////////////////////////////////

#define DEMO_SPACE_CPP
#include "inc.h"

////////////////////////////////////////////////////////////////
// 
////////////////////////////////////////////////////////////////

// طʲΥǥ쥯ȥ
#define STR_ENDING_SPACE_DIR_NAME	"ending/space/"
#define STR_ENDING_NEBULA_DIR_NAME	"ending/nebula/"

static const long XR = 16384;
static const long YR = 16384;
static const long ZR = 256;
static const long NXR = 1024;
static const long NYR = 1024;
static const long NZR = 128;
static const long Z_SPEED = -1;

////////////////////////////////////////////////////////////////
// åա
////////////////////////////////////////////////////////////////

#define STAFF_ROLL_SPEED_CUI	2
#define STAFF_ROLL_SPEED	1

#define SPACE_FONT_POINT	14
#define SPACE_FONT_DOT	14

// ʸֳ
static const long nStaffRollIntervalWidth = SPACE_FONT_DOT;
static const long nStaffRollIntervalHeight = SPACE_FONT_DOT * 2;

#define gStrStaffRoll	g_str_staff_roll
#define gStrTheEnd	g_str_the_end

////////////////////////////////////////////////////////////////
// 󥹥ȥ饯
////////////////////////////////////////////////////////////////

DemoSpace::DemoSpace()
{
	pcgNebula.next = NULL;

	pStyle = NULL;

#ifdef D_MFC
	for( long i = 0; i < COLOR_TAB_MAX_N; i++ ){
		texture[i] = NULL;
		img[i] = NULL;
	}
#endif // D_MFC
}

////////////////////////////////////////////////////////////////
// ǥȥ饯
////////////////////////////////////////////////////////////////

DemoSpace::~DemoSpace()
{
}

////////////////////////////////////////////////////////////////
// 
////////////////////////////////////////////////////////////////

void DemoSpace::init()
{
	// طʲθ

	WSCstring dir = STR_DEFAULT_GRAPH_DIR_NAME;
	WSCstring ext = STR_GRAPH_FILE_EXT;

	FileList::setStrDirSelGraph( dir );
	FileList ls;

	// طʲ򸡺

	nMaxFile = 0;
	ls.reset( STR_ENDING_SPACE_DIR_NAME, ext );
	long j = 0;
	for( j = 0; j < LOOP_MAX_1000; j++ ){
		WSCstring path = ls.next();
		if( path.getChars() <= 0 )
			break;
	}
	nMaxFile = j;

	// طʲ

	if( nMaxFile > 0 )
		nRandmSel = randm( nMaxFile );
	else
		nRandmSel = -1;

	// طʲɤ߹

	if( nRandmSel > -1 ){
		ls.reset( STR_ENDING_SPACE_DIR_NAME, ext );
		long j = 0;
		for( j = 0; j < LOOP_MAX_1000; j++ ){
			WSCstring path = ls.next();
			if( path.getChars() <= 0 )
				break;
			if( j == nRandmSel ){
				pcgSpace.init( path );
				break;
			}
		}
	}

#ifdef D_MFC
	// β򸡺ɤ߹

	Pcg *p = &pcgNebula;
	ls.reset( STR_ENDING_NEBULA_DIR_NAME, ext );
	for( long i = 0; i < NEBULA_MAX_N; i++ ){
		WSCstring path = ls.next();
		if( path.getChars() <= 0 )
			break;
		p->next = new Pcg;
		p = p->next;
		p->next = NULL;
		p->init( path );
	}
#endif // D_MFC

	// åա

#ifdef	D_MFC
	staffRollY = -gPcgDun.getScrollBarH() * 10 / 16;
#else
	staffRollY = -gPcgDun.getScrollBarH();
#endif

	nStaffRollMaxLen = 1;
	for( long i = 0; i < LOOP_MAX_1000; i++ ){
		if( gStrStaffRoll[i] == NULL )
			break;
		if( gStrStaffRoll[i][0] == '\0' )
			break;

		long len = str_len_draw( gStrStaffRoll[i] );
		if( nStaffRollMaxLen < len )
			nStaffRollMaxLen = len;
	}

#ifdef D_GTK
	// ǥեȤΥ

	if( pStyle == NULL ){
		pStyle = gtk_style_copy(
				gtk_widget_get_default_style() );
	}
	if( pStyle->fg_gc[GTK_STATE_NORMAL] == NULL ){
		pStyle->fg_gc[GTK_STATE_NORMAL]
				= gdk_gc_new( gMapDrawingArea->window );
	}
	if( pStyle->bg_gc[GTK_STATE_NORMAL] == NULL ){
		pStyle->bg_gc[GTK_STATE_NORMAL]
				= gdk_gc_new( gMapDrawingArea->window );
	}

	// եȤ

	WSCstring sFontPoint = SPACE_FONT_POINT * 10;
	WSCstring sFontName = "";
	sFontName += "-*-*-*-i-normal--*-";
	sFontName += sFontPoint;
	sFontName += "-*,-*";

	gtk_style_set_font( pStyle, gdk_fontset_load( sFontName ) );
#endif // D_GTK

#ifdef D_MFC
	// ǥեȤΥ

	if( pStyle == NULL )
		pStyle = (void *)1;

	// եȤ

	LONG h = SPACE_FONT_DOT;
	mFontDesc.lfHeight = h;
	mFontDesc.lfWidth = 0;
	mFontDesc.lfEscapement = 0;
	mFontDesc.lfOrientation = 0;
	mFontDesc.lfWeight = FW_NORMAL;
	mFontDesc.lfItalic = FALSE;
	mFontDesc.lfUnderline = FALSE;
	mFontDesc.lfStrikeOut = FALSE;
	mFontDesc.lfCharSet = SHIFTJIS_CHARSET;
	mFontDesc.lfOutPrecision = OUT_DEFAULT_PRECIS;
	mFontDesc.lfClipPrecision = CLIP_DEFAULT_PRECIS;
	mFontDesc.lfQuality = DEFAULT_QUALITY;
	mFontDesc.lfPitchAndFamily = (FIXED_PITCH | FF_MODERN);
	strcpy( mFontDesc.lfFaceName, "Pica" );

	pFont = new CFont;
	pFont->CreateFontIndirect( &mFontDesc );

	mD3.Create( &mFontDesc );

	staffRollIdx = 0;
#endif // D_MFC

	initAnime();
}

////////////////////////////////////////////////////////////////
// ˥᡼ν
////////////////////////////////////////////////////////////////

void DemoSpace::initAnime()
{
#ifdef D_GTK
	w = gMapDrawingArea->allocation.width;
	h = gMapDrawingArea->allocation.height;

	// ơ֥

	for( long i = 0; i < COLOR_TAB_MAX_N; i++ ){
		long col = 64 + (192 * i / COLOR_TAB_MAX_N);
		colorTab[i].red = ((col << 8) | col);
		colorTab[i].green = ((col << 8) | col);
		colorTab[i].blue = ((col << 8) | col);
	}
	gdk_colormap_alloc_colors(
			gdk_colormap_get_system(),
			colorTab, COLOR_TAB_MAX_N,
			FALSE, TRUE, colorResult );
#endif // D_GTK

#ifdef D_MFC
	CXlnlView *view = theApp.m_pMainFrm->GetView();
	CRect rect;
	view->GetClientRect( &rect );

	w = rect.Width();
	h = rect.Height();

	// ơ֥

	const UINT txW = 1;
	const UINT txH = 1;
	for( long i = 0; i < COLOR_TAB_MAX_N; i++ ){
		long col = 64 + (192 * i / COLOR_TAB_MAX_N);

		// ƥ

		g_Dir3d.BeginDraw();
		HRESULT result = g_Dir3d.pDir3dDevice->CreateTexture(
				txW, txH, 0,
				D3DUSAGE_RENDERTARGET, D3DFMT_A8R8G8B8,
				D3DPOOL_DEFAULT,
				&(texture[i]), NULL );
		g_Dir3d.EndDraw();

		if( FAILED( result ) )
			continue;

		// ƥɤĤ֤

		D3DCOLOR clr = D3DCOLOR_XRGB( col, col, col );

		// ɤĤ֤

		g_Dir3d.BeginDraw();

		IDirect3DSurface9 *sf = NULL;
		texture[i]->GetSurfaceLevel( 0, &sf );

		IDirect3DSurface9 *preTrgt = NULL;
		g_Dir3d.pDir3dDevice->GetRenderTarget( 0, &preTrgt );
		g_Dir3d.pDir3dDevice->SetRenderTarget( 0, sf );

		// ɤĤ֤

		g_Dir3d.pDir3dDevice->Clear(
				0, NULL, D3DCLEAR_TARGET,
				clr, 1.0, 0 );

		// ɤĤ֤λ

		g_Dir3d.pDir3dDevice->SetRenderTarget( 0, preTrgt );

		g_Dir3d.EndDraw();

		// ᡼

		img[i] = new WSDimage( texture[i], txW, txH );
	}
#endif // D_MFC

	zv = Z_SPEED;
	for( long i = 0; i < STAR_MAX_N; i++ ){
		x[i] = randm( XR * 2 ) - XR;
		y[i] = randm( YR * 2 ) - YR;
		z[i] = randm( ZR );
	}
	for( long i = 0; i < NEBULA_MAX_N; i++ ){
		nx[i] = randm( NXR * 2 ) - NXR;
		ny[i] = randm( NYR * 2 ) - NYR;
		nz[i] = randm( NZR );
	}
}

////////////////////////////////////////////////////////////////
// ΰư
////////////////////////////////////////////////////////////////

void DemoSpace::move()
{
	for( long i = 0; i < STAR_MAX_N; i++ ){
		z[i] = ((z[i] - zv) % ZR + ZR) % ZR;
	}
	for( long i = 0; i < NEBULA_MAX_N; i++ ){
		nz[i] -= zv;
		if( (nz[i] < 0) || (nz[i] >= NZR)){
			nx[i] = randm( NXR * 2 ) - NXR;
			ny[i] = randm( NYR * 2 ) - NYR;
			nz[i] = (nz[i] % NZR + NZR) % NZR;
		}
	}
}

////////////////////////////////////////////////////////////////
// 
// bool flagDrawStaffRoll : åա褹뤫?
// return : 顼̵ä?
////////////////////////////////////////////////////////////////

bool DemoSpace::draw( bool flagDrawStaffRoll )
{
	move();

	// طʤɤĤ֤

#ifdef D_GTK
	GdkDrawable *d = gPcgDun.getWBuf()->getPixMap();
	GdkGC *gc = pStyle->bg_gc[GTK_STATE_NORMAL];
	gdk_draw_rectangle( d, gc, TRUE,
			0, 0,
			gMapDrawingArea->allocation.width,
			gMapDrawingArea->allocation.height );
#endif // D_GTK

	// طʲ

	long sx = gPcgDun.getScrollBarX();
	long sy = gPcgDun.getScrollBarY();
	long sw = w;
	long sh = h;

	if( nRandmSel > -1 ){
		long ww = pcgSpace.getWidth();
		long hh = pcgSpace.getHeight();
		long xx = sx + (sw - ww) / 2;
		long yy = sy + (sh - hh) / 2;

		pcgSpace.draw( gPcgDun.getWBuf(), xx, yy, ww, hh );
	}

	// 

	Pcg *p = pcgNebula.next;
	for( long i = 0; i < NEBULA_MAX_N; i++ ){
		if( p == NULL )
			break;

		long drx = sx + sw / 2;
		long dry = sy + sh / 2;
		long zz = nz[i] + 1;
		drx += nx[i] / zz;
		dry += ny[i] / zz;

		drawNebula( p, drx, dry, zz );

		p = p->next;
	}

	// 

	for( long i = 0; i < STAR_MAX_N; i++ ){
		long drx = sx + sw / 2;
		long dry = sy + sh / 2;
		long zz = z[i] + 1;
		drx += x[i] / zz;
		dry += y[i] / zz;

		drawStar( drx, dry, zz );
	}

	if( flagDrawStaffRoll ){
		if( get_scene() == SCENE_N_ENDING_END ){
			drawTheEnd();
		} else {
			drawStaffRoll();
		}
	}

	return true;
}

////////////////////////////////////////////////////////////////
// 
// long x : X ɸ
// long y : Y ɸ
// long z : Z ɸ
////////////////////////////////////////////////////////////////

void DemoSpace::drawStar( long x, long y, long z )
{
#ifdef D_GTK
	GdkDrawable *d = gPcgDun.getWBuf()->getPixMap();
	GdkGC *gc = pStyle->fg_gc[GTK_STATE_NORMAL];

	long idx = COLOR_TAB_MAX_N * (ZR - z) / ZR;
	if( idx < 0 )
		idx = 0;
	if( idx > COLOR_TAB_MAX_N - 1 )
		idx = COLOR_TAB_MAX_N - 1;
	gdk_gc_set_foreground( gc, &colorTab[idx] );

	gdk_draw_point( d, gc, x, y );
#endif // D_GTK

#ifdef D_MFC
	long idx = COLOR_TAB_MAX_N * (ZR - z) / ZR;
	if( idx < 0 )
		idx = 0;
	if( idx > COLOR_TAB_MAX_N - 1 )
		idx = COLOR_TAB_MAX_N - 1;

	if( img[idx] == NULL )
		return;

	g_Dir3d.BeginDraw();
	g_Dir3d.Draw( img[idx], 0, 0, x, y, 1, 1 );
	g_Dir3d.EndDraw();
#endif // D_MFC
}

////////////////////////////////////////////////////////////////
// 
// Pcg *p : β
// long x : X ɸ
// long y : Y ɸ
// long z : Z ɸ
////////////////////////////////////////////////////////////////

void DemoSpace::drawNebula( Pcg *p, long x, long y, long z )
{
#ifdef D_MFC
	if( p == NULL )
		return;

	long w = p->getWidth();
	long h = p->getHeight();

	long preSize = g_Dir3d.nSizeRate;
	g_Dir3d.nSizeRate = 100 / z;

	long ww = w * g_Dir3d.nTileSizeRate / 100;
	long hh = h * g_Dir3d.nTileSizeRate / 100;
	if( g_Dir3d.nTileSizeRate > 0 ){
		long xx = x - (ww / 2);
		long yy = y - (hh / 2);

		p->draw( gPcgDun.getWBuf(), xx, yy, ww, hh );
	}

	g_Dir3d.nSizeRate = preSize;
#endif // D_MFC
}

////////////////////////////////////////////////////////////////
// åա
////////////////////////////////////////////////////////////////

void DemoSpace::drawStaffRoll()
{
	long sx = gPcgDun.getScrollBarX();
	long sw = gPcgDun.getScrollBarW();
	long sh = gPcgDun.getScrollBarH();

	long x = (sw - (nStaffRollIntervalWidth * nStaffRollMaxLen))
			/ 2 + sx;
	long y = 0;

	if( g_flg_cui )
		staffRollY += STAFF_ROLL_SPEED_CUI;
	else
		staffRollY += STAFF_ROLL_SPEED;

	for( long i = 0; i < LOOP_MAX_1000; i++ ){
		if( gStrStaffRoll[i] == NULL )
			break;
		if( gStrStaffRoll[i][0] == '\0' )
			break;

		y = (i * nStaffRollIntervalHeight) - staffRollY;

		if( y < (-1 * SPACE_FONT_DOT) )
			continue;
		if( y > sh )
			break;

#ifdef	D_MFC
		if( y < (sh * 6 / 16) )
			continue;
		if( y > (sh * 10 / 16) )
			continue;
#endif

		drawStaffRollLine( x, y, gStrStaffRoll[i] );
	}

	if( y < (sh / 2) )
		if( get_scene() != SCENE_N_ENDING_END )
			change_scene_gui( SCENE_N_ENDING_END );
}

////////////////////////////////////////////////////////////////
// The End 
////////////////////////////////////////////////////////////////

void DemoSpace::drawTheEnd()
{
	long sx = gPcgDun.getScrollBarX();
	long sw = gPcgDun.getScrollBarW();
	long sh = gPcgDun.getScrollBarH();

	long x = (sw - (nStaffRollIntervalWidth * nStaffRollMaxLen))
			/ 2 + sx;
	long y = sh / 2;

	drawStaffRollLine( x, y, gStrTheEnd );
}

////////////////////////////////////////////////////////////////
// åա 1 Ԥ
// long x : X ɸ
// long y : Y ɸ
// const char *str : 1 ʬΥåա
////////////////////////////////////////////////////////////////

void DemoSpace::drawStaffRollLine( long x, long y, const char *str )
{
	if( str == NULL )
		return;

	long sw = gPcgDun.getScrollBarW();
	long sh = gPcgDun.getScrollBarH();

	if( x > sw )
		return;
	if( y > sh )
		return;
	if( y < (-1 * SPACE_FONT_DOT) )
		return;

#ifdef D_MFC
	mD3.Begin();
#endif

	long k = 0;
	for( long j = 0; j < LOOP_MAX_100; j++ ){
		const char *p = &(str[k]);
		if( *p == '\0' )
			break;

		drawCharStd( x, y, get_next_char_str( p ) );

		x += nStaffRollIntervalWidth;
		k += get_next_char_len( p );
	}

#ifdef D_MFC
	mD3.End();
#endif
}

////////////////////////////////////////////////////////////////
// ʸ(դ)
// long x : X ɸ
// long y : Y ɸ
// const char *str : ʸ
////////////////////////////////////////////////////////////////

void DemoSpace::drawCharStd( long x, long y, const char *str )
{
#ifndef D_MFC
	drawChar( 0x00, 0x00, 0x00, x + 1, y + 1, str );
	drawChar( 0x00, 0x00, 0x00, x - 1, y - 1, str );
#endif
	drawChar( 0xff, 0xff, 0xff, x, y, str );
}

////////////////////////////////////////////////////////////////
// ʸ
// long r : r 
// long g : g 
// long b : b 
// long x : X ɸ
// long y : Y ɸ
// const char *str : ʸ
////////////////////////////////////////////////////////////////

void DemoSpace::drawChar(
	long r, long g, long b,
	long x, long y, const char *str )
{
	r &= 0xff;
	g &= 0xff;
	b &= 0xff;

#ifdef D_GTK
	GdkColor color;
	color.pixel = 0;
	color.red = (r << 8) | r;
	color.green = (g << 8) | g;
	color.blue = (b << 8) | b;

	GdkDrawable *d = gPcgDun.getWBuf()->getPixMap();
	GdkFont *font = gtk_style_get_font( pStyle );
	GdkGC *gc = pStyle->fg_gc[GTK_STATE_NORMAL];

	gdk_color_alloc( gdk_colormap_get_system(), &color );
	gdk_gc_set_foreground( gc, &color );

	gdk_draw_string( d, font, gc, x, y, str );
#endif // D_GTK

#ifdef D_MFC
	if( str[0] == '&' )
		str = "&&";

	D3DCOLOR color = D3DCOLOR_XRGB( r, g, b );

	mD3.Draw( x, y, color, str );
#endif // D_MFC
}

////////////////////////////////////////////////////////////////
// Z ˲®
// long zav : ®
////////////////////////////////////////////////////////////////

void DemoSpace::addSpeedZ( long zav )
{
	zv += zav;
}
