/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2009 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: DemoSpace.h,v 1.8 2009/07/31 19:03:01 bowkenken Exp $
***************************************************************/

#ifndef DEMO_SPACE_H
#define DEMO_SPACE_H	1

////////////////////////////////////////////////////////////////
// ǥ
////////////////////////////////////////////////////////////////

#ifdef D_GTK
# include <gtk/gtk.h>
#endif /* D_GTK */

#ifdef D_MFC
# include "xlnl-dows/stdafx.h"
# include "xlnl-dows/xlnl-dows.h"
# include "xlnl-dows/Dir3dText.h"
#endif // D_MFC

#include "Pcg.h"

////////////////////////////////////////////////////////////////

#define	STAR_MAX_N	4096
#define NEBULA_MAX_N	16

#ifdef D_GTK
# define	COLOR_TAB_MAX_N	16
#endif // D_GTK

#ifdef D_MFC
# define	COLOR_TAB_MAX_N	16
#endif // D_MFC

////////////////////////////////////////////////////////////////

class DemoSpace {
public:

private:
	// Ф줿Υեֹ
	long nRandmSel;
	// Υե
	long nMaxFile;
	// 
	Pcg pcgSpace;
	Pcg pcgNebula;

	// ο

#ifdef D_GTK
	GdkColor colorTab[COLOR_TAB_MAX_N];
	gboolean colorResult[COLOR_TAB_MAX_N];
#endif // D_GTK

#ifdef D_MFC
	LPDIRECT3DTEXTURE9 texture[COLOR_TAB_MAX_N];
	WSDimage *img[COLOR_TAB_MAX_N];
#endif // D_MFC

	// κɸ

	long w, h;
	long zv;
	long x[STAR_MAX_N];
	long y[STAR_MAX_N];
	long z[STAR_MAX_N];
	long nx[NEBULA_MAX_N];
	long ny[NEBULA_MAX_N];
	long nz[NEBULA_MAX_N];

	// åա

	long staffRollY;
	long nStaffRollMaxLen;

#ifdef D_MFC
	long staffRollIdx;
#endif // D_MFC

#ifdef D_GTK
	// եȤΥ
	GtkStyle *pStyle;
#endif // D_GTK

#ifdef D_MFC
	// եȤΥ
	void *pStyle;
	LOGFONT mFontDesc;
	CFont *pFont;

	CDir3dText mD3;
#endif // D_MFC

public:
	DemoSpace();
	~DemoSpace();
	void init();

	bool draw( bool flagDrawStaffRoll );
	void addSpeedZ( long zav );

private:
	void initAnime();

	void move();

	void drawStar( long x, long y, long z );
	void drawNebula( Pcg *p, long x, long y, long z );

	void drawStaffRoll();
	void drawTheEnd();
	void drawStaffRollLine( long x, long y, const char *str );
	void drawCharStd( long x, long y, const char *str );
	void drawChar(
		long r, long g, long b,
		long x, long y, const char *str );
};

#endif // DEMO_SPACE_H
