/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2010 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: amenu.h,v 1.19 2010/01/07 07:12:21 bowkenken Exp $
***************************************************************/

#ifndef	AMENU_H
#define	AMENU_H

/***************************************************************
* ưޡ
***************************************************************/

/* ưޡκ */
#define	AUTO_MARK_N_PER_PAGE	10
#define	AUTO_MARK_PAGE_N	5
#define	AUTO_MARK_MAX_N	(AUTO_MARK_N_PER_PAGE * AUTO_MARK_PAGE_N)

/* ȥκʸ */
#define	MSG_TTL_AUTO_MARK_MAX_LEN	64
#define	MSG_TTL_AUTO_MARK_MAX_BYTE	\
	(MSG_TTL_AUTO_MARK_MAX_LEN * CHAR_MAX_LEN_UTF_8)
#define	MSG_TTL_AUTO_MARK_INFO_MAX_LEN	30
#define	MSG_TTL_AUTO_MARK_INFO_MAX_BYTE	\
	(MSG_TTL_AUTO_MARK_INFO_MAX_LEN * CHAR_MAX_LEN_UTF_8)
#define	MSG_TTL_AUTO_MARK_HINT_MAX_LEN	30
#define	MSG_TTL_AUTO_MARK_HINT_MAX_BYTE	\
	(MSG_TTL_AUTO_MARK_HINT_MAX_LEN * CHAR_MAX_LEN_UTF_8)

/* ƥμκ */
#define	AUTO_MARK_APPOINT_ITEM_MAX_N	64

/***************************************************************
* ե饰
* ֤Ѥϥ֡ǡ⽤
***************************************************************/

/* ޡ˺Ƥӥޡʤ */
#define	FLG_AUTO_MARK_EDIT_CONT	(1 << 0)

/* Ǥ˥ޡƤƤ⶯Ū˥ޡʤ */
#define	FLG_AUTO_MARK_EDIT_PRIORITY	(1 << 1)

/***************************************************************
* о
***************************************************************/

typedef enum {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_TRGT_ITEM,
	AUTO_MARK_TRGT_DOOR,
	AUTO_MARK_TRGT_TRAP,
	AUTO_MARK_TRGT_MBR,
	AUTO_MARK_TRGT_UNCHANGE,
	AUTO_MARK_TRGT_CLEAR,
} auto_mark_trgt_t;

/***************************************************************
* ֹ礤
***************************************************************/

typedef enum {
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_DIST_MEDIUM,
	AUTO_MARK_DIST_FAR,
} auto_mark_dist_t;

/***************************************************************
* 
***************************************************************/

typedef enum {
	AUTO_MARK_ACT_FIGHT,
	AUTO_MARK_ACT_THROW,
	AUTO_MARK_ACT_STEAL,
	AUTO_MARK_ACT_TAIL,
	AUTO_MARK_ACT_PICK_UP,
	AUTO_MARK_ACT_BREAK,
	AUTO_MARK_ACT_OPEN,
	AUTO_MARK_ACT_CLOSE,
	AUTO_MARK_ACT_JAM,
	AUTO_MARK_ACT_DISARM,
	AUTO_MARK_ACT_PEEP,
	AUTO_MARK_ACT_CHK,
} auto_mark_act_t;

/***************************************************************
* 
***************************************************************/

typedef enum {
	/* äȤᤤʪ */
	AUTO_MARK_COND_NEAREST,

	/* Ф餱 */
	AUTO_MARK_COND_DISPERSE,

	/* ƤС */
	AUTO_MARK_COND_STAGGER,

	/* ƱʪäƤ */
	AUTO_MARK_COND_OWN,

	/* ̺ */
	AUTO_MARK_COND_IDENTIFIED,

	/* ̤ */
	AUTO_MARK_COND_UN_IDENTIFIED,

	/* 1  HP ξʤ */
	AUTO_MARK_COND_HP_MIN,

	/* 1  HP ¿ */
	AUTO_MARK_COND_HP_MAX,

	/* 1  MP ξʤ */
	AUTO_MARK_COND_MP_MIN,

	/* 1  MP ¿ */
	AUTO_MARK_COND_MP_MAX,
} auto_mark_cond_t;

/***************************************************************
* ưޡ
***************************************************************/

typedef struct {
	auto_mark_trgt_t	trgt;
	auto_mark_dist_t	dist;
	auto_mark_act_t	act;
	auto_mark_cond_t	cond;
	char	macro[MACRO_MAX_LEN + 1];
	unsigned long	flg;
} auto_mark_t;

#endif	/* AMENU_H */
