/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2010 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* 本プログラムはフリー・ソフトウェアです。
* あなたは、 Free Software Foundation が公表した
*  GNU 一般公有使用許諾の「バージョン２」
* 或はそれ以降の各バージョンの中からいずれかを選択し、
* そのバージョンが定める条項に従って本プログラムを
* 再頒布または変更することができます。
* 
* 本プログラムは有用とは思いますが、頒布にあたっては、
* 市場性及び特定目的適合性についての暗黙の保証を含めて,
* いかなる保証も行ないません。
* 詳細については GNU 一般公有使用許諾書をお読みください。
* 
* あなたは、本プログラムと一緒に GNU 一般公有使用許諾書
* の写しを受け取っているはずです。そうでない場合は、
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* へ手紙を書いてください。
* 
* $Id: msg-jpn.h,v 1.264 2010/01/13 05:30:11 bowkenken Exp $
***************************************************************/

#include	"ver.h"

/* "GREDIT", "GRUSH", "GASH" */
#define	STR_GOLD	"GENAMA"
#define	STR_GOLD_SHORT	"G"
#define	STR_GOLD_FMT	"%s " STR_GOLD
#define	STR_GOLD_FMT_MAX	"%12s " STR_GOLD
#define	STR_GOLD_SHORT_FMT	"%s " STR_GOLD_SHORT
#define	STR_GOLD_SHORT_FMT_MAX	"%12s " STR_GOLD_SHORT

#define	STR_SQUARE	"アンカー"

#define	STR_EQUIP_WIELDING	"武器"
#define	STR_EQUIP_SHIELD	"盾"
#define	STR_EQUIP_BOW	"弓"
#define	STR_EQUIP_ARW	"矢"
#define	STR_EQUIP_HEAD	"頭"
#define	STR_EQUIP_NECK	"首"
#define	STR_EQUIP_BODY	"体"
#define	STR_EQUIP_ARM	"腕"
#define	STR_EQUIP_RIGHT_HAND	"右手指"
#define	STR_EQUIP_LEFT_HAND	"左手指"
#define	STR_EQUIP_FEET	"足"
#define	STR_EQUIP_ABOUT_BODY	"背中"
#define	STR_EQUIP_LIGHT_SOURCE	"明かり"

#define	STR_DISARM	"解除"

#define	STR_FIG	"戦闘技能"
#define	STR_MON	"格闘技能"
#define	STR_HUN	"射撃技能"
#define	STR_THI	"シーフ技能"

#define	STR_MAG	"基本魔法"
#define	STR_SOR	"戦闘魔法"
#define	STR_ENC	"支援魔法"
#define	STR_SUM	"召喚魔法"

#define	STR_PRI	"祈り"
#define	STR_SHA	"精霊術"
#define	STR_BAR	"呪歌"
#define	STR_NIN	"忍術"

#define	STR_LAST_STAGE	"「星界」"

#ifdef	SEL_MSG_BLOCK_0

	{ N_MSG_NULL,
		"" },
	{ N_MSG_NOT_NULL,
		" " },

	{ N_MSG_S,
		"%s" },

	{ N_MSG_GAME_NAME,
		STR_FILE_NAME_GAME },

	{ N_MSG_CANCEL,
		"キャンセルしました" },
	{ N_MSG_HIT_ANY_KEY,
		"- 何かキーを押して下さい -" },
	{ N_MSG_HIT_ENTER_KEY,
		"- [ENTER] キーを押して下さい -" },
	{ N_MSG_HINT_CANCEL_MENU_1,
		"[ESC], [BACK-SPACE], [DELETE], [0] の"
		"どれかのキーを押すと"
	},
	{ N_MSG_HINT_CANCEL_MENU_2,
		"メニューを閉じます"
	},

	{ N_MSG_H_LINE,
		"-" },
	{ N_MSG_V_LINE,
		"|" },
	{ N_MSG_CROSS,
		"+" },
	{ N_MSG_H_FRAME,
		"----------------------------------------"
		"+--------------------------------------" },
	{ N_MSG_STAT_FRAME,
		"--------------------------------------" },

	{ N_MSG_SQUARE,
		STR_SQUARE },

	{ N_MSG_MORE,
		"-more-" },
	{ N_MSG_MORE_CLEAR,
		"      " },

	{ N_MSG_WAIT_KEY,
		"[ENTER] キーを押して下さい" },

	{ N_MSG_INCOMPLETE,
		"この機能は,まだ出来ていません" },

	{ N_MSG_GAME_OVER,
		"パーティが全滅しました"
		" [CTRL]+[Q] を押して終了して下さい" },

	{ N_MSG_CHILD_PS,
		"%s を呼び出します\n" },

	{ N_MSG_OUT_MAP_FILE_1,
		"マップを出力するファイル名を入力して下さい" },
	{ N_MSG_OUT_MAP_FILE_2,
		"デフォルト '%s'" },
	{ N_MSG_OUT_MAP_FILE_3,
		"出力ファイル名 '%s'" },
	{ N_MSG_OUT_MAP_FILE_ASK_OK,
		"出力しますか？" },

	{ N_MSG_ECHO_KEY,
		"['%c': 0x%04lx]" },
	{ N_MSG_MEASURE_CLK_TCK,
		"フレーム・レートを計測中です (%ld 秒間)..." },
	{ N_MSG_MEASURE_CLK_TCK_FINISH,
		"(%ld - %ld) / %ld == %ld" },

	{ N_MSG_MAIN_RACE_HUMAN,
		"ヒューマン" },
	{ N_MSG_MAIN_RACE_HALF_ELF,
		"ハーフ・エルフ" },
	{ N_MSG_MAIN_RACE_ELF,
		"エルフ" },
	{ N_MSG_MAIN_RACE_DWARF,
		"ドワーフ" },
	{ N_MSG_MAIN_RACE_VIVID,
		"ビビッド" },

	{ N_MSG_SUB_RACE_NULL,
		"無し" },
	{ N_MSG_SUB_RACE_CAT,
		"猫" },
	{ N_MSG_SUB_RACE_DOG,
		"犬" },
	{ N_MSG_SUB_RACE_MOUSE,
		"ネズミ" },
	{ N_MSG_SUB_RACE_RABBIT,
		"ウサギ" },
	{ N_MSG_SUB_RACE_MONKEY,
		"猿" },
	{ N_MSG_SUB_RACE_PIG,
		"豚" },
	{ N_MSG_SUB_RACE_BIRD,
		"鳥" },
	{ N_MSG_SUB_RACE_LIZARD,
		"ワニ" },

	{ N_MSG_RACE_NAME_VEGE,
		"ヴェジ" },
	{ N_MSG_RACE_NAME_NEKOMIMI,
		"ネコミミ" },

	{ N_MSG_MALE,
		"男" },
	{ N_MSG_FEMALE,
		"女" },

	{ N_MSG_EQUIP_WIELDING,
		STR_EQUIP_WIELDING },
	{ N_MSG_EQUIP_SHIELD,
		STR_EQUIP_SHIELD },
	{ N_MSG_EQUIP_BOW,
		STR_EQUIP_BOW },
	{ N_MSG_EQUIP_ARW,
		STR_EQUIP_ARW },
	{ N_MSG_EQUIP_HEAD,
		STR_EQUIP_HEAD },
	{ N_MSG_EQUIP_NECK,
		STR_EQUIP_NECK },
	{ N_MSG_EQUIP_BODY,
		STR_EQUIP_BODY },
	{ N_MSG_EQUIP_ARM,
		STR_EQUIP_ARM },
	{ N_MSG_EQUIP_RIGHT_HAND,
		STR_EQUIP_RIGHT_HAND },
	{ N_MSG_EQUIP_LEFT_HAND,
		STR_EQUIP_LEFT_HAND },
	{ N_MSG_EQUIP_FEET,
		STR_EQUIP_FEET },
	{ N_MSG_EQUIP_ABOUT_BODY,
		STR_EQUIP_ABOUT_BODY },
	{ N_MSG_EQUIP_LIGHT_SOURCE,
		STR_EQUIP_LIGHT_SOURCE },

	{ N_MSG_STAT_DEAD,
		"死亡" },
	{ N_MSG_STAT_STONE,
		"石化" },
	{ N_MSG_STAT_PARALYZE,
		"麻痺" },
	{ N_MSG_STAT_POISON,
		"毒" },
	{ N_MSG_STAT_CONFUSION,
		"混乱" },
	{ N_MSG_STAT_BLIND,
		"盲目" },
	{ N_MSG_STAT_SLEEP,
		"眠り" },
	{ N_MSG_STAT_SILENCE,
		"沈黙" },
	{ N_MSG_STAT_CAUGHT,
		"拘束" },
	{ N_MSG_STAT_FEAR,
		"恐怖" },
	{ N_MSG_STAT_HALLUCINATION,
		"幻覚" },
	{ N_MSG_STAT_CHARM,
		"魅了" },
	{ N_MSG_STAT_FLY,
		"浮遊" },
	{ N_MSG_STAT_HUNGRY,
		"空腹" },
	{ N_MSG_STAT_STARVATION,
		"飢餓" },
	{ N_MSG_STAT_FAINT,
		"めまい" },
	{ N_MSG_STAT_DRUNK,
		"酔い" },
	{ N_MSG_STAT_VANISH,
		"透明化" },
	{ N_MSG_STAT_IRON_BODY,
		"鋼鉄化" },
	{ N_MSG_STAT_PASSWALL,
		"壁抜け" },
	{ N_MSG_STAT_SENSE_INVISIBLE,
		"不可視感知" },

	{ N_MSG_ABL_NAME_HP,
		"HP" },
	{ N_MSG_ABL_NAME_MP,
		"MP" },
	{ N_MSG_ABL_NAME_DEX,
		"DEX" },
	{ N_MSG_ABL_NAME_STR,
		"STR" },
	{ N_MSG_ABL_NAME_AGI,
		"AGI" },
	{ N_MSG_ABL_NAME_INT,
		"INT" },
	{ N_MSG_ABL_NAME_WIS,
		"WIS" },
	{ N_MSG_ABL_NAME_CHA,
		"CHA" },
	{ N_MSG_ABL_NAME_FIG,
		"FIG" },
	{ N_MSG_ABL_NAME_MON,
		"MON" },
	{ N_MSG_ABL_NAME_HUN,
		"HUN" },
	{ N_MSG_ABL_NAME_THI,
		"THI" },
	{ N_MSG_ABL_NAME_MAG,
		"MAG" },
	{ N_MSG_ABL_NAME_SOR,
		"SOR" },
	{ N_MSG_ABL_NAME_ENC,
		"ENC" },
	{ N_MSG_ABL_NAME_SUM,
		"SUM" },
	{ N_MSG_ABL_NAME_PRI,
		"PRI" },
	{ N_MSG_ABL_NAME_SHA,
		"SHA" },
	{ N_MSG_ABL_NAME_BAR,
		"BAR" },
	{ N_MSG_ABL_NAME_NIN,
		"NIN" },
	{ N_MSG_ABL_NAME_NULL,
		"NULL" },
	{ N_MSG_ABL_NAME_ATTACKER,
		"ATTACKER" },
	{ N_MSG_ABL_NAME_BERSERKER,
		"BERSERKER" },
	{ N_MSG_ABL_NAME_DEFENDER,
		"DEFENDER" },
	{ N_MSG_ABL_NAME_SENTINEL,
		"SENTINEL" },
	{ N_MSG_ABL_NAME_ASSASSIN,
		"ASSASSIN" },
	{ N_MSG_ABL_NAME_AEGIS,
		"AEGIS" },
	{ N_MSG_ABL_NAME_SIEGE,
		"SIEGE" },
	{ N_MSG_ABL_NAME_PHALANX,
		"PHALANX" },
	{ N_MSG_ABL_NAME_DOUBLE_ATTACK,
		"DOUBLE_ATTACK" },
	{ N_MSG_ABL_NAME_COMBO,
		"COMBO" },
	{ N_MSG_ABL_NAME_RAPID_SHOOT,
		"RAPID_SHOOT" },
	{ N_MSG_ABL_NAME_COUNTER,
		"COUNTER" },
	{ N_MSG_ABL_NAME_TWO_SWORD_FENCING,
		"TWO_SWORD_FENCING" },
	{ N_MSG_ABL_NAME_DAM_KNOC,
		"DAM_KNOC" },
	{ N_MSG_ABL_NAME_DAM_SLAS,
		"DAM_SLAS" },
	{ N_MSG_ABL_NAME_DAM_STIN,
		"DAM_STIN" },
	{ N_MSG_ABL_NAME_DAM_HEAT,
		"DAM_HEAT" },
	{ N_MSG_ABL_NAME_DAM_COLD,
		"DAM_COLD" },
	{ N_MSG_ABL_NAME_DAM_MIND,
		"DAM_MIND" },
	{ N_MSG_ABL_NAME_DAM_ACID,
		"DAM_ACID" },
	{ N_MSG_ABL_NAME_DAM_ELEC,
		"DAM_ELEC" },
	{ N_MSG_ABL_NAME_DAM_POIS,
		"DAM_POIS" },
	{ N_MSG_ABL_NAME_RESI_KNOC,
		"RESI_KNOC" },
	{ N_MSG_ABL_NAME_RESI_SLAS,
		"RESI_SLAS" },
	{ N_MSG_ABL_NAME_RESI_STIN,
		"RESI_STIN" },
	{ N_MSG_ABL_NAME_RESI_HEAT,
		"RESI_HEAT" },
	{ N_MSG_ABL_NAME_RESI_COLD,
		"RESI_COLD" },
	{ N_MSG_ABL_NAME_RESI_MIND,
		"RESI_MIND" },
	{ N_MSG_ABL_NAME_RESI_ACID,
		"RESI_ACID" },
	{ N_MSG_ABL_NAME_RESI_ELEC,
		"RESI_ELEC" },
	{ N_MSG_ABL_NAME_RESI_POIS,
		"RESI_POIS" },
	{ N_MSG_ABL_NAME_STAT_DEAD,
		"STAT_DEAD" },
	{ N_MSG_ABL_NAME_STAT_STONE,
		"STAT_STONE" },
	{ N_MSG_ABL_NAME_STAT_PARALYZE,
		"STAT_PARALYZE" },
	{ N_MSG_ABL_NAME_STAT_POISON,
		"STAT_POISON" },
	{ N_MSG_ABL_NAME_STAT_CONFUSION,
		"STAT_CONFUSION" },
	{ N_MSG_ABL_NAME_STAT_BLIND,
		"STAT_BLIND" },
	{ N_MSG_ABL_NAME_STAT_SLEEP,
		"STAT_SLEEP" },
	{ N_MSG_ABL_NAME_STAT_SILENCE,
		"STAT_SILENCE" },
	{ N_MSG_ABL_NAME_STAT_CAUGHT,
		"STAT_CAUGHT" },
	{ N_MSG_ABL_NAME_STAT_FEAR,
		"STAT_FEAR" },
	{ N_MSG_ABL_NAME_STAT_HALLUCINATION,
		"STAT_HALLUCINATION" },
	{ N_MSG_ABL_NAME_STAT_CHARM,
		"STAT_CHARM" },
	{ N_MSG_ABL_NAME_STAT_FLY,
		"STAT_FLY" },
	{ N_MSG_ABL_NAME_STAT_HUNGRY,
		"STAT_HUNGRY" },
	{ N_MSG_ABL_NAME_STAT_STARVATION,
		"STAT_STARVATION" },
	{ N_MSG_ABL_NAME_STAT_FAINT,
		"STAT_FAINT" },
	{ N_MSG_ABL_NAME_STAT_DRUNK,
		"STAT_DRUNK" },
	{ N_MSG_ABL_NAME_STAT_VANISH,
		"STAT_VANISH" },
	{ N_MSG_ABL_NAME_STAT_IRON_BODY,
		"STAT_IRON_BODY" },
	{ N_MSG_ABL_NAME_STAT_PASSWALL,
		"STAT_PASSWALL" },
	{ N_MSG_ABL_NAME_STAT_SENSE_INVISIBLE,
		"STAT_SENSE_INVISIBLE" },
	{ N_MSG_ABL_NAME_RUN_AWAY,
		"RUN_AWAY" },

	{ N_MSG_SKILL_GROUP_NAME_NULL,
		"----" },
	{ N_MSG_SKILL_GROUP_NAME_FIGHT,
		"戦闘系" },
	{ N_MSG_SKILL_GROUP_NAME_COMBO,
		"連続攻撃系" },
	{ N_MSG_SKILL_GROUP_NAME_DAM,
		"ダメージ強化系" },
	{ N_MSG_SKILL_GROUP_NAME_RESI,
		"耐性系" },
	{ N_MSG_SKILL_GROUP_NAME_RESI_STAT_1,
		"ステータス耐性系 1" },
	{ N_MSG_SKILL_GROUP_NAME_RESI_STAT_2,
		"ステータス耐性系 2" },
	{ N_MSG_SKILL_GROUP_NAME_MISC,
		"その他" },

	/* SKILL_GROUP_KIND_NULL, */
	{ N_MSG_SKILL_NAME_NULL,
		"----" },

	/* SKILL_GROUP_KIND_FIGHT, */
	{ N_MSG_SKILL_NAME_ATTACKER,
		"アタッカー" },
	{ N_MSG_SKILL_NAME_BERSERKER,
		"バーサーカ" },
	{ N_MSG_SKILL_NAME_DEFENDER,
		"ディフェンダー" },
	{ N_MSG_SKILL_NAME_SENTINEL,
		"センチネル" },
	{ N_MSG_SKILL_NAME_ASSASSIN,
		"アサッシン" },
	{ N_MSG_SKILL_NAME_AEGIS,
		"イージス" },
	{ N_MSG_SKILL_NAME_SIEGE,
		"シージ" },
	{ N_MSG_SKILL_NAME_PHALANX,
		"ファランクス" },

	/* SKILL_GROUP_KIND_COMBO, */
	{ N_MSG_SKILL_NAME_DOUBLE_ATTACK,
		"ダブル・アタック" },
	{ N_MSG_SKILL_NAME_COMBO,
		"百烈拳" },
	{ N_MSG_SKILL_NAME_RAPID_SHOOT,
		"ラピッド・シュート" },
	{ N_MSG_SKILL_NAME_COUNTER,
		"カウンター" },
	{ N_MSG_SKILL_NAME_TWO_SWORD_FENCING,
		"二刀流" },

	/* SKILL_GROUP_KIND_DAM, */
	{ N_MSG_SKILL_NAME_DAM_KNOC,
		"殴打ダメージ強化" },
	{ N_MSG_SKILL_NAME_DAM_SLAS,
		"斬撃ダメージ強化" },
	{ N_MSG_SKILL_NAME_DAM_STIN,
		"刺突ダメージ強化" },
	{ N_MSG_SKILL_NAME_DAM_HEAT,
		"火熱ダメージ強化" },
	{ N_MSG_SKILL_NAME_DAM_COLD,
		"水冷ダメージ強化" },
	{ N_MSG_SKILL_NAME_DAM_MIND,
		"風心ダメージ強化" },
	{ N_MSG_SKILL_NAME_DAM_ACID,
		"土酸ダメージ強化" },
	{ N_MSG_SKILL_NAME_DAM_ELEC,
		"光雷ダメージ強化" },
	{ N_MSG_SKILL_NAME_DAM_POIS,
		"闇毒ダメージ強化" },

	/* SKILL_GROUP_KIND_RESI, */
	{ N_MSG_SKILL_NAME_RESI_KNOC,
		"殴打耐性" },
	{ N_MSG_SKILL_NAME_RESI_SLAS,
		"斬撃耐性" },
	{ N_MSG_SKILL_NAME_RESI_STIN,
		"刺突耐性" },
	{ N_MSG_SKILL_NAME_RESI_HEAT,
		"火熱耐性" },
	{ N_MSG_SKILL_NAME_RESI_COLD,
		"水冷耐性" },
	{ N_MSG_SKILL_NAME_RESI_MIND,
		"風心耐性" },
	{ N_MSG_SKILL_NAME_RESI_ACID,
		"土酸耐性" },
	{ N_MSG_SKILL_NAME_RESI_ELEC,
		"光雷耐性" },
	{ N_MSG_SKILL_NAME_RESI_POIS,
		"闇毒耐性" },

	/* SKILL_GROUP_KIND_RESI_STAT, */
	{ N_MSG_SKILL_NAME_STAT_DEAD,
		"死亡耐性" },
	{ N_MSG_SKILL_NAME_STAT_STONE,
		"石化耐性" },
	{ N_MSG_SKILL_NAME_STAT_PARALYZE,
		"麻痺耐性" },
	{ N_MSG_SKILL_NAME_STAT_POISON,
		"毒耐性" },
	{ N_MSG_SKILL_NAME_STAT_CONFUSION,
		"混乱耐性" },
	{ N_MSG_SKILL_NAME_STAT_BLIND,
		"盲目耐性" },
	{ N_MSG_SKILL_NAME_STAT_SLEEP,
		"眠り耐性" },
	{ N_MSG_SKILL_NAME_STAT_SILENCE,
		"沈黙耐性" },
	{ N_MSG_SKILL_NAME_STAT_CAUGHT,
		"拘束耐性" },
	{ N_MSG_SKILL_NAME_STAT_FEAR,
		"恐怖耐性" },
	{ N_MSG_SKILL_NAME_STAT_HALLUCINATION,
		"幻覚耐性" },
	{ N_MSG_SKILL_NAME_STAT_CHARM,
		"魅了耐性" },
	{ N_MSG_SKILL_NAME_STAT_FLY,
		"浮遊耐性" },
	{ N_MSG_SKILL_NAME_STAT_HUNGRY,
		"空腹耐性" },
	{ N_MSG_SKILL_NAME_STAT_STARVATION,
		"飢餓耐性" },
	{ N_MSG_SKILL_NAME_STAT_FAINT,
		"めまい耐性" },
	{ N_MSG_SKILL_NAME_STAT_DRUNK,
		"酔い耐性" },
	{ N_MSG_SKILL_NAME_STAT_VANISH,
		"透明化耐性" },
	{ N_MSG_SKILL_NAME_STAT_IRON_BODY,
		"鋼鉄化耐性" },
	{ N_MSG_SKILL_NAME_STAT_PASSWALL,
		"壁抜け耐性" },
	{ N_MSG_SKILL_NAME_STAT_SENSE_INVISIBLE,
		"不可視感知耐性" },

	/* SKILL_GROUP_KIND_MISC, */
	{ N_MSG_SKILL_NAME_RUN_AWAY,
		"とんずら" },

	{ N_MSG_CLASS_FIGHTER,
		"戦士" },
	{ N_MSG_CLASS_MONK,
		"武闘家" },
	{ N_MSG_CLASS_HUNTER,
		"狩人" },
	{ N_MSG_CLASS_THIEF,
		"盗賊" },
	{ N_MSG_CLASS_WIZARD,
		"魔術師" },
	{ N_MSG_CLASS_SUMMONER,
		"召喚師" },
	{ N_MSG_CLASS_PRIEST,
		"僧侶" },
	{ N_MSG_CLASS_SHAMAN,
		"精霊使い" },
	{ N_MSG_CLASS_BARD,
		"吟遊詩人" },
	{ N_MSG_CLASS_NINJA,
		"忍者" },
	{ N_MSG_CLASS_BISHOP,
		"賢者" },
	{ N_MSG_ERR_CLASS_NOT_100_PERCENT,
		"%s は能力値の合計が 100%% で有りません" },

	{ N_MSG_DIE_CHR,
		"*** %s は死んだ ***" },

	{ N_MSG_EXP_PARTY,
		"各メンバーは %s の経験値を得た" },
	{ N_MSG_EXP_MBR,
		"%s は %s の経験値を得た" },
	{ N_MSG_VFX_LEV_UP,
		"LEVEL UP" },
	{ N_MSG_VFX_LEV_DOWN,
		"LEVEL DOWN" },
	{ N_MSG_LEV_UP,
		"*** %s は %s のレベルが %3ld に上がった ***" },
	{ N_MSG_LEV_DOWN,
		"*** %s は %s のレベルが %3ld に下がった ***" },
	{ N_MSG_ERR_EXP_MBR_SKILL,
		"%s の経験値が %ld 捨てられた" },
	{ N_MSG_ERR_EXP_MBR_SKILL_HINT,
		"スキルの設定を調整して下さい" },

	{ N_MSG_ADD_PARTY_GOLD,
		"パーティは " STR_GOLD_FMT " を山分けした" },
	{ N_MSG_SUB_PARTY_GOLD,
		"パーティは " STR_GOLD_FMT " を分担して支払った" },

	{ N_MSG_JOIN_CHR,
		"%s が仲間に加わった" },
	{ N_MSG_NOT_JOIN_CHR,
		"%s が仲間から外れた" },

	{ N_MSG_FLOOR,
		"地上" },
	{ N_MSG_BASE,
		"地下" },
	{ N_MSG_GROUND,
		"街" },
	{ N_MSG_STORY,
		"階" },

	{ N_MSG_FLOOR_FMT,
		"地上 %ld 階" },
	{ N_MSG_BASE_FMT,
		"地下 %ld 階" },

	{ N_MSG_STAT_DUN_LEV_LAST_STAGE,
		"星界  :     " },
	{ N_MSG_STAT_DUN_LEV_FLOOR,
		"地上  : %4ld" },
	{ N_MSG_STAT_DUN_LEV_BASE,
		"地下  : %4ld" },
	{ N_MSG_STAT_DUN_LEV_GROUND,
		"街    : %4ld" },

	{ N_MSG_STAT_TIME,
		"%02ld時%02ld分" },

	{ N_MSG_NAME_BAR,
		"酒場" },
	{ N_MSG_NAME_INN,
		"宿屋" },
	{ N_MSG_NAME_WPN,
		"武器屋" },
	{ N_MSG_NAME_ARMOR,
		"防具屋" },
	{ N_MSG_NAME_MAGIC,
		"魔法ギルド" },
	{ N_MSG_NAME_TEMPLE,
		"寺院" },
	{ N_MSG_NAME_ALCHEMY,
		"錬金術の店" },
	{ N_MSG_NAME_MUSIC,
		"音楽院" },
	{ N_MSG_NAME_GROCERY,
		"雑貨屋" },
	{ N_MSG_NAME_RESTAURANT,
		"レストラン" },
	{ N_MSG_NAME_TEAROOM,
		"ティールーム" },
	{ N_MSG_NAME_TOBACCO,
		"タバコ屋" },
	{ N_MSG_NAME_PET_SHOP,
		"ペット・ショップ" },

	{ N_MSG_DAY_OF_WEEK_ELEC,
		"光" },
	{ N_MSG_DAY_OF_WEEK_PHYS,
		"月" },
	{ N_MSG_DAY_OF_WEEK_HEAT,
		"火" },
	{ N_MSG_DAY_OF_WEEK_COLD,
		"水" },
	{ N_MSG_DAY_OF_WEEK_MIND,
		"風" },
	{ N_MSG_DAY_OF_WEEK_ACID,
		"土" },
	{ N_MSG_DAY_OF_WEEK_POIS,
		"闇" },

	{ N_MSG_STAR_DROP_ELEC,
		"光の雫" },
	{ N_MSG_STAR_DROP_PHYS,
		"月の雫" },
	{ N_MSG_STAR_DROP_HEAT,
		"火の雫" },
	{ N_MSG_STAR_DROP_COLD,
		"水の雫" },
	{ N_MSG_STAR_DROP_MIND,
		"風の雫" },
	{ N_MSG_STAR_DROP_ACID,
		"土の雫" },
	{ N_MSG_STAR_DROP_POIS,
		"闇の雫" },
	{ N_MSG_HAVE_KEY_ITEM,
		"「%s」を持っている" },
	{ N_MSG_NOT_HAVE_KEY_ITEM,
		"重要アイテムは持っていない" },
	{ N_MSG_GET_KEY_ITEM,
		"「%s」を手に入れた" },
	{ N_MSG_DRIVE_BOOT_UNIT,
		"「%s」が起動した" },

	{ N_MSG_AUTO_RELOAD,
		"%s は %s を自動装填しました" },

	{ N_MSG_ATTACK_PUNCH,
		"%s は %s を殴った" },
	{ N_MSG_ATTACK_KICK,
		"%s は %s を蹴った" },
	{ N_MSG_ATTACK_KNOCK,
		"%s は %s に叩きつけた" },
	{ N_MSG_ATTACK_SLASH,
		"%s は %s に切りつけた" },
	{ N_MSG_ATTACK_STING,
		"%s は %s を刺した" },
	{ N_MSG_ATTACK_MOW,
		"%s は %s を薙払った" },
	{ N_MSG_ATTACK_SHOOT,
		"%s は %s を射った" },
	{ N_MSG_ATTACK_THROW,
		"%s は %s に投げつけた" },
	{ N_MSG_ATTACK_BITE,
		"%s は %s に噛みついた" },
	{ N_MSG_ATTACK_PECK,
		"%s は %s を突いた" },
	{ N_MSG_ATTACK_CLAW,
		"%s は %s を引っ掻いた" },
	{ N_MSG_ATTACK_NIP,
		"%s は %s を挟んだ" },
	{ N_MSG_ATTACK_STRANGLE,
		"%s は %s を締めつけた" },
	{ N_MSG_ATTACK_TACKLE,
		"%s は %s に体当りした" },
	{ N_MSG_ATTACK_TOUCH,
		"%s は %s に触れた" },
	{ N_MSG_ATTACK_INDICATE,
		"%s は %s を指さした" },
	{ N_MSG_ATTACK_KISS,
		"%s は %s にキスをした" },
	{ N_MSG_ATTACK_SEDUCE,
		"%s は %s を誘惑した" },
	{ N_MSG_ATTACK_CARESS_BUST,
		"%s は %s の胸を触った" },
	{ N_MSG_ATTACK_CARESS_HIP,
		"%s は %s の腰を撫でた" },
	{ N_MSG_ATTACK_CARESS_CROTCH,
		"%s は %s の股間を撫でた" },
	{ N_MSG_ATTACK_CYBERN_PUNCH,
		"%s は %s に光子パンチを食らわせた" },
	{ N_MSG_ATTACK_CYBERN_KICK,
		"%s は %s に光子キックを当てた" },
	{ N_MSG_ATTACK_XX_SLAP,
		"%s は %s に平手打ち攻撃" },
	{ N_MSG_FIGHT_RESI_KIND,
		"%s 属性の攻撃" },
	{ N_MSG_FIGHT_CRTCL_STD,
		"%s のクリティカル・ヒット" },
	{ N_MSG_FIGHT_CRTCL_NINJA,
		"%s の首斬り" },
	{ N_MSG_FIGHT_HIT_STD,
		"%s に %d のダメージを与えた" },
	{ N_MSG_FIGHT_MISS_STD,
		"%s の攻撃が %s を外した" },
	{ N_MSG_FIGHT_COMBO,
		"%s の x%d 回攻撃" },
	{ N_MSG_FIGHT_COUNTER,
		"%s の反撃 x%d 回" },
	{ N_MSG_FIGHT_TWO_SWORD_FENCING,
		"%s の二刀流 x%d 回" },
	{ N_MSG_FIGHT_KILL_STD,
		"++XX %s が %s を倒した XX++" },
	{ N_MSG_FIGHT_KILL_BOSS,
		"強敵 %s を倒した" },
	{ N_MSG_FIGHT_MAGIC_PROTECT,
		"%s には、この武器は効かない" },
	{ N_MSG_FIGHT_SUBSTITUTE,
		"それは %s の身代わりだった" },
	{ N_MSG_REPEL_ATTACK,
		"%s は %s の攻撃を弾いた" },

	{ N_MSG_SPELL,
		"%s は %s の呪文を唱えた" },
	{ N_MSG_FAIL_SPELL,
		"%s は %s の呪文を失敗した" },
	{ N_MSG_FAIL_SPELL_SANCTUARY,
		"%s の呪文を聖なる力が打ち消した" },
	{ N_MSG_RESI_SPELL,
		"%s は %s の呪文に抵抗した" },
	{ N_MSG_RESI_SPELL_SKILL,
		"%s は %s の呪文にスキルで抵抗した" },
	{ N_MSG_REPEL_SPELL,
		"%s は %s の呪文を弾いた" },

	{ N_MSG_TRGT_POS,
		"位置指定" },

	{ N_MSG_ACT_NULL,
		"" },
	{ N_MSG_ACT_MNSTR_FIGHT,
		"戦う" },
	{ N_MSG_ACT_MNSTR_THROW,
		"射撃" },
	{ N_MSG_ACT_MNSTR_STEAL,
		"盗む" },
	{ N_MSG_ACT_MNSTR_TAIL,
		"追う" },
	{ N_MSG_ACT_MBR_FIGHT,
		"メンバーと戦う" },
	{ N_MSG_ACT_MBR_THROW,
		"メンバーに射撃" },
	{ N_MSG_ACT_MBR_STEAL,
		"メンバーから盗む" },
	{ N_MSG_ACT_MBR_TAIL,
		"メンバーを追う" },
	{ N_MSG_ACT_DOOR_OPEN,
		"ドアを開ける" },
	{ N_MSG_ACT_DOOR_CLOSE,
		"ドアを閉じる" },
	{ N_MSG_ACT_DOOR_JAM,
		"ドアを固定する" },
	{ N_MSG_ACT_DOOR_DISARM,
		"ドアの固定を" STR_DISARM },
	{ N_MSG_ACT_DOOR_BREAK,
		"ドアを壊す" },
	{ N_MSG_ACT_DOOR_PEEP,
		"鍵穴をのぞく" },
	{ N_MSG_ACT_DOOR_CHK,
		"ドアを調べる" },
	{ N_MSG_ACT_TRAP_DISARM,
		"罠を" STR_DISARM },
	{ N_MSG_ACT_TRAP_BREAK,
		"罠を壊す" },
	{ N_MSG_ACT_TRAP_CHK,
		"罠を調べる" },
	{ N_MSG_ACT_ITEM_PICK_UP,
		"アイテムをひろう" },
	{ N_MSG_ACT_ITEM_OPEN,
		"アイテムを開ける" },
	{ N_MSG_ACT_ITEM_DISARM,
		"アイテムを" STR_DISARM "する" },
	{ N_MSG_ACT_ITEM_BREAK,
		"アイテムを壊す" },
	{ N_MSG_ACT_ITEM_CHK,
		"アイテムを調べる" },
	{ N_MSG_ACT_ITEM_SEND,
		"アイテムを渡す" },
	{ N_MSG_ACT_ITEM_DROP,
		"アイテムを落とす" },
	{ N_MSG_ACT_ITEM_RECEIVE,
		"アイテムをもらう" },
	{ N_MSG_ACT_POTION_QUAFF,
		"薬を飲む" },
	{ N_MSG_ACT_POTION_FILL,
		"ランタンに補給" },
	{ N_MSG_ACT_SCROLL_READ,
		"巻物を読む" },
	{ N_MSG_ACT_STICK_ZAP,
		"杖を使う" },
	{ N_MSG_ACT_LAMP_RUB,
		"ランプをこする" },
	{ N_MSG_ACT_FOOD_EAT,
		"食べ物を食べる" },
	{ N_MSG_ACT_TOBACCO_SMOKE,
		"タバコを一服する" },
	{ N_MSG_ACT_TOBACCO_DISPOSE,
		"吸い殻を入れる" },
	{ N_MSG_ACT_EQUIP,
		"装備する" },
	{ N_MSG_ACT_TAKE_OFF,
		"装備を外す" },
	{ N_MSG_ACT_EQUIP_MBR,
		"装備させる" },
	{ N_MSG_ACT_TAKE_OFF_MBR,
		"装備を外させる" },
	{ N_MSG_ACT_SRCH,
		"探す" },

	{ N_MSG_INC_DISCOUNT_QUEUE,
		"%s は行列に列んだ" },

/* アイテム */
	{ N_MSG_ITEM_NO_SEL,
		"----" },
	{ N_MSG_ITEM_UNKNOWN,
		"謎のアイテム" },

	{ N_MSG_ITEM_MJR_NAME_WEAPON,
		"武器" },
	{ N_MSG_ITEM_MJR_NAME_ARMOR,
		"鎧" },
	{ N_MSG_ITEM_MJR_NAME_POTION,
		"薬" },
	{ N_MSG_ITEM_MJR_NAME_SCROLL,
		"巻物" },
	{ N_MSG_ITEM_MJR_NAME_STICK,
		"杖" },
	{ N_MSG_ITEM_MJR_NAME_ACCESSORY,
		"アクセサリ" },
	{ N_MSG_ITEM_MJR_NAME_FOOD,
		"食糧" },
	{ N_MSG_ITEM_MJR_NAME_CHEST,
		"宝箱" },
	{ N_MSG_ITEM_MJR_NAME_COIN,
		"金貨" },
	{ N_MSG_ITEM_MJR_NAME_GEM,
		"宝石" },
	{ N_MSG_ITEM_MJR_NAME_MISC,
		"その他のアイテム" },
	{ N_MSG_ITEM_MJR_NAME_ERR,
		"謎のアイテム" },

	{ N_MSG_ITEM_MNR_NAME_KNIFE,
		"ナイフ系" },
	{ N_MSG_ITEM_MNR_NAME_SHORT_SWORD,
		"ショート・ソード系" },
	{ N_MSG_ITEM_MNR_NAME_LONG_SWORD,
		"ロング・ソード系" },
	{ N_MSG_ITEM_MNR_NAME_SABRE,
		"サーベル系" },
	{ N_MSG_ITEM_MNR_NAME_RAPIER,
		"レイピア系" },
	{ N_MSG_ITEM_MNR_NAME_HAND_AXE,
		"ハンド・アックス系" },
	{ N_MSG_ITEM_MNR_NAME_BATTLE_AXE,
		"バトル・アックス系" },
	{ N_MSG_ITEM_MNR_NAME_SPEAR,
		"スピア系" },
	{ N_MSG_ITEM_MNR_NAME_LANCE,
		"ランス系" },
	{ N_MSG_ITEM_MNR_NAME_FLAIL,
		"フレイル系" },
	{ N_MSG_ITEM_MNR_NAME_MACE,
		"メイス系" },
	{ N_MSG_ITEM_MNR_NAME_HAMMER,
		"ハンマー系" },
	{ N_MSG_ITEM_MNR_NAME_GLAIVE,
		"グレイヴ系" },
	{ N_MSG_ITEM_MNR_NAME_KNUCKLE,
		"ナックル系" },
	{ N_MSG_ITEM_MNR_NAME_BOW,
		"弓" },
	{ N_MSG_ITEM_MNR_NAME_ARW,
		"矢" },
	{ N_MSG_ITEM_MNR_NAME_STONE,
		"石" },
	{ N_MSG_ITEM_MNR_NAME_DAGGER,
		"ダガー系" },
	{ N_MSG_ITEM_MNR_NAME_ARMOR_HEAD,
		"兜" },
	{ N_MSG_ITEM_MNR_NAME_ARMOR_BODY,
		"鎧" },
	{ N_MSG_ITEM_MNR_NAME_ARMOR_ABOUT_BODY,
		"マント" },
	{ N_MSG_ITEM_MNR_NAME_ARMOR_ARM,
		"小手" },
	{ N_MSG_ITEM_MNR_NAME_ARMOR_SHIELD,
		"盾" },
	{ N_MSG_ITEM_MNR_NAME_ARMOR_FEET,
		"ブーツ" },
	{ N_MSG_ITEM_MNR_NAME_POTION,
		"薬" },
	{ N_MSG_ITEM_MNR_NAME_SCROLL,
		"巻物" },
	{ N_MSG_ITEM_MNR_NAME_WAND,
		"ワンド" },
	{ N_MSG_ITEM_MNR_NAME_ROD,
		"ロッド" },
	{ N_MSG_ITEM_MNR_NAME_STAFF,
		"スタッフ" },
	{ N_MSG_ITEM_MNR_NAME_RING,
		"リング" },
	{ N_MSG_ITEM_MNR_NAME_AMULET,
		"魔除け" },
	{ N_MSG_ITEM_MNR_NAME_NECKLACE,
		"ネックレス" },
	{ N_MSG_ITEM_MNR_NAME_FOOD,
		"食糧" },
	{ N_MSG_ITEM_MNR_NAME_CHEST,
		"宝箱" },
	{ N_MSG_ITEM_MNR_NAME_COIN,
		"金貨" },
	{ N_MSG_ITEM_MNR_NAME_GEM,
		"宝石" },
	{ N_MSG_ITEM_MNR_NAME_INST,
		"楽器" },
	{ N_MSG_ITEM_MNR_NAME_INST_STRINGED,
		"弦楽器" },
	{ N_MSG_ITEM_MNR_NAME_INST_WOODWIND,
		"木管楽器" },
	{ N_MSG_ITEM_MNR_NAME_INST_BRASS,
		"金管楽器" },
	{ N_MSG_ITEM_MNR_NAME_INST_PERCUSSION,
		"打楽器" },
	{ N_MSG_ITEM_MNR_NAME_INST_MISC,
		"その他の楽器" },
	{ N_MSG_ITEM_MNR_NAME_ANTHOLOGY,
		"伝説の詩集" },
	{ N_MSG_ITEM_MNR_NAME_LIGHT,
		"明かり" },
	{ N_MSG_ITEM_MNR_NAME_SPIKE,
		"釘" },
	{ N_MSG_ITEM_MNR_NAME_TOBACCO,
		"タバコ" },
	{ N_MSG_ITEM_MNR_NAME_PIPE,
		"パイプ" },
	{ N_MSG_ITEM_MNR_NAME_DISPOSAL,
		"吸い殻入れ" },
	{ N_MSG_ITEM_MNR_NAME_RARE_GOODS,
		"レア・グッズ" },
	{ N_MSG_ITEM_MNR_NAME_BONE_GOOD,
		"誰かの骨" },
	{ N_MSG_ITEM_MNR_NAME_BONE_EVIL,
		"モンスターの骨" },
	{ N_MSG_ITEM_MNR_NAME_JUNK,
		"ゴミ屑" },
	{ N_MSG_ITEM_MNR_NAME_ERR,
		"謎のアイテム" },

/* Check Item Data */

	{ N_MSG_CHK_ITEM_DATA_NAME,
		"%s を調べた" },
	{ N_MSG_CHK_ITEM_DATA_KIND,
		"これは %s の類だ" },

	{ N_MSG_CHK_ITEM_DATA_CAN_USE_MON,
		"装備すると" STR_MON "(MON)で戦う" },

	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_FIG,
		"装備すると" STR_FIG "(FIG)が制限される" },
	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_MON,
		"装備すると" STR_MON "(MON)が制限される" },
	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_HUN,
		"装備すると" STR_HUN "(HUN)が制限される" },
	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_THI,
		"装備すると" STR_THI "(THI)が制限される" },

	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_MAG,
		"装備すると" STR_MAG "(MAG)が制限される" },
	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_SOR,
		"装備すると" STR_SOR "(SOR)が制限される" },
	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_ENC,
		"装備すると" STR_ENC "(ENC)が制限される" },
	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_SUM,
		"装備すると" STR_SUM "(SUM)が制限される" },

	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_PRI,
		"装備すると" STR_PRI "(PRI)が制限される" },
	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_SHA,
		"装備すると" STR_SHA "(SHA)が制限される" },
	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_BAR,
		"装備すると" STR_BAR "(BAR)が制限される" },
	{ N_MSG_CHK_ITEM_DATA_CAN_NOT_USE_NIN,
		"装備すると" STR_NIN "(NIN)が制限される" },

	{ N_MSG_CHK_ITEM_DATA_TWO_HANDED,
		"両手で扱う(楯装備不可)" },
	{ N_MSG_CHK_ITEM_DATA_CAN_TWO_HANDED,
		"両手でも扱える(楯の装備時は片手)" },

	{ N_MSG_CHK_ITEM_DATA_WPN_RANDM_ART_BANE,
		"{%c%c} %s ベーン" },
	{ N_MSG_CHK_ITEM_DATA_WPN_RANDM_ART_KILLER,
		"{%c%c} %s キラー" },
	{ N_MSG_CHK_ITEM_DATA_WPN_RANDM_ART_SLAYER,
		"{%c%c} %s スレイヤー" },
	{ N_MSG_CHK_ITEM_DATA_WPN_RANDM_ART_ADD_STAT,
		"{%c%c} %s 効果" },
	{ N_MSG_CHK_ITEM_DATA_WPN_RANDM_ART_DRAIN,
		"{%c%c} %s 吸収" },

	{ N_MSG_WPN_RANDM_ART_MNR_DRAIN_HP,
		"生命力" },
	{ N_MSG_WPN_RANDM_ART_MNR_DRAIN_MP,
		"精神力" },
	{ N_MSG_WPN_RANDM_ART_MNR_DRAIN_EXP,
		"経験値" },

	{ N_MSG_CHK_ITEM_DATA_ARMOR_RANDM_ART_GUARD,
		"{%c%c} %s ガード" },
	{ N_MSG_CHK_ITEM_DATA_ARMOR_RANDM_ART_BLOCK,
		"{%c%c} %s ブロック" },
	{ N_MSG_CHK_ITEM_DATA_ARMOR_RANDM_ART_PROTECT,
		"{%c%c} %s プロテクト" },
	{ N_MSG_CHK_ITEM_DATA_ARMOR_RANDM_ART_RESI_STAT,
		"{%c%c} %s 耐性" },
	{ N_MSG_CHK_ITEM_DATA_ARMOR_RANDM_ART_HEALING,
		"{%c%c} %s ヒーリング" },

	{ N_MSG_ARMOR_RANDM_ART_MNR_HEALING_HP,
		"生命力" },
	{ N_MSG_ARMOR_RANDM_ART_MNR_HEALING_MP,
		"精神力" },
	{ N_MSG_ARMOR_RANDM_ART_MNR_HEALING_EXP,
		"経験値" },

/* 武器 */

	{ N_MSG_WPN_KNIFE,
		"ナイフ" },
	{ N_MSG_WPN_KRIS_KNIFE,
		"クリス・ナイフ" },
	{ N_MSG_WPN_MAIN_GAUCHE,
		"マン＝ゴーシュ" },
	{ N_MSG_WPN_SWORD_BREAKER,
		"ソード・ブレーカ" },
	{ N_MSG_WPN_KATAR,
		"カタール" },
	{ N_MSG_WPN_JAMADHAR,
		"ジャマダハル" },
	{ N_MSG_WPN_KUKRI,
		"ククリ" },

	{ N_MSG_WPN_SHORT_SWORD,
		"ショート・ソード" },
	{ N_MSG_WPN_GLADIUS,
		"グラディウス" },

	{ N_MSG_WPN_LONG_SWORD,
		"ロング・ソード" },
	{ N_MSG_WPN_BROAD_SWORD,
		"ブロード・ソード" },
	{ N_MSG_WPN_CLAYMORE,
		"クレイモア" },
	{ N_MSG_WPN_BASTARD_SWORD,
		"バスタード・ソード" },
	{ N_MSG_WPN_GREAT_SWORD,
		"グレート・ソード" },
	{ N_MSG_WPN_EXCALIBUR,
		"エクスカリバー" },

	{ N_MSG_WPN_SABRE,
		"サーベル" },
	{ N_MSG_WPN_SHAMSHIR,
		"シャムシール" },
	{ N_MSG_WPN_TALWAR,
		"タルワール" },
	{ N_MSG_WPN_FALCHION,
		"ファルシオン" },
	{ N_MSG_WPN_CUTLASS,
		"カットラス" },
	{ N_MSG_WPN_SHOTEL,
		"ショテル" },
	{ N_MSG_WPN_KATANA,
		"カタナ" },
	{ N_MSG_WPN_WAKIZASHI,
		"ワキザシ" },

	{ N_MSG_WPN_RAPIER,
		"レイピア" },
	{ N_MSG_WPN_ESTOC,
		"エストック" },

	{ N_MSG_WPN_HAND_AXE,
		"ハンド・アックス" },
	{ N_MSG_WPN_FRANCISCA,
		"フランキスカ" },
	{ N_MSG_WPN_BHUJ,
		"ブージ" },

	{ N_MSG_WPN_BATTLE_AXE,
		"バトル・アックス" },
	{ N_MSG_WPN_BROAD_AXE,
		"ブロード・アックス" },
	{ N_MSG_WPN_GREAT_AXE,
		"グレート・アックス" },

	{ N_MSG_WPN_SPEAR,
		"スピア" },
	{ N_MSG_WPN_PILUM,
		"ピルム" },
	{ N_MSG_WPN_PIKE,
		"パイク" },
	{ N_MSG_WPN_JAVELIN,
		"ジャベリン" },
	{ N_MSG_WPN_TRIDENT,
		"トライデント" },

	{ N_MSG_WPN_LANCE,
		"ランス" },
	{ N_MSG_WPN_LANCE_OF_LONGINUS,
		"ロンギヌスの槍" },

	{ N_MSG_WPN_LIGHT_FLAIL,
		"ライト・フレイル" },
	{ N_MSG_WPN_HEAVY_FLAIL,
		"ヘビー・フレイル" },
	{ N_MSG_WPN_MORNINGSTAR,
		"モーニング・スター" },
	{ N_MSG_WPN_NUNCHAKUS,
		"ヌンチャク" },

	{ N_MSG_WPN_WOODEN_CLUB,
		"クラブ" },
	{ N_MSG_WPN_QUARTER_STAFF,
		"棒" },
	{ N_MSG_WPN_LIGHT_MACE,
		"ライト・メイス" },
	{ N_MSG_WPN_HEAVY_MACE,
		"ヘビー・メイス" },

	{ N_MSG_WPN_WAR_HAMMER,
		"ウォー・ハンマー" },
	{ N_MSG_WPN_WAR_PICK,
		"ウォー・ピック" },
	{ N_MSG_WPN_ZAGHNOL,
		"ザグナル" },
	{ N_MSG_WPN_BEC_DE_CORBIN,
		"ベク・ド・コルバン" },

	{ N_MSG_WPN_PARTIZAN,
		"パルチザン" },
	{ N_MSG_WPN_POLEAXE,
		"ポール・アックス" },
	{ N_MSG_WPN_GLAIVE,
		"グレイヴ" },
	{ N_MSG_WPN_HALBERD,
		"ハルベルト" },
	{ N_MSG_WPN_CHAUVE_SOURIS,
		"ショヴスリ" },
	{ N_MSG_WPN_CORSESCA,
		"コルセスカ" },
	{ N_MSG_WPN_SCYTHE,
		"サイズ" },
	{ N_MSG_WPN_FAUCHARD,
		"フォチャード" },
	{ N_MSG_WPN_GUISARME,
		"ギサルメ" },

	{ N_MSG_WPN_BRASS_KNUCKLE,
		"ブラス・ナックル" },
	{ N_MSG_WPN_BAGH_NAKH,
		"バグ・ナウ" },

	{ N_MSG_WPN_SLING,
		"スリング" },
	{ N_MSG_WPN_SHORT_BOW,
		"ショート・ボウ" },
	{ N_MSG_WPN_LONG_BOW,
		"ロング・ボウ" },
	{ N_MSG_WPN_COMPOSITE_BOW,
		"コンポジット・ボウ" },
	{ N_MSG_WPN_LIGHT_CROSS_BOW,
		"ライト・クロス・ボウ" },
	{ N_MSG_WPN_HEAVY_CROSS_BOW,
		"ヘビー・クロス・ボウ" },
	{ N_MSG_WPN_BLOW_GUN,
		"吹き矢" },

	{ N_MSG_WPN_STONE,
		"石" },
	{ N_MSG_WPN_BULLET,
		"スリングの弾" },
	{ N_MSG_WPN_ARW,
		"弓矢の矢" },
	{ N_MSG_WPN_BOLT,
		"クロス・ボウの矢" },
	{ N_MSG_WPN_NEEDLE,
		"吹き矢の矢" },

	{ N_MSG_WPN_DAGGER,
		"ダガー" },
	{ N_MSG_WPN_DARTS,
		"ダーツ" },
	{ N_MSG_WPN_SHURIKEN,
		"手裏剣" },
	{ N_MSG_WPN_BOOMERANG,
		"ブーメラン" },

/* 防具 */

	{ N_MSG_ARMOR_LEATHER_CAP,
		"レザー・キャップ" },
	{ N_MSG_ARMOR_METAL_CAP,
		"メタル・キャップ" },
	{ N_MSG_ARMOR_SALLET,
		"サーリット" },
	{ N_MSG_ARMOR_CLOSE_HELMET,
		"クロス・ヘルム" },
	{ N_MSG_ARMOR_SILVER_CROWN,
		"シルバー・クラウン" },
	{ N_MSG_ARMOR_GOLDEN_CROWN,
		"ゴールデン・クラウン" },
	{ N_MSG_ARMOR_JEWELED_CROWN,
		"ジュエルド・クラウン" },

	{ N_MSG_ARMOR_ROBE,
		"ローブ" },
	{ N_MSG_ARMOR_SOFT_LEATHER_ARMOR,
		"ソフト・レザー・アーマ" },
	{ N_MSG_ARMOR_HARD_LEATHER_ARMOR,
		"ハード・レザー・アーマ" },
	{ N_MSG_ARMOR_RING_MAIL,
		"リング・メイル" },
	{ N_MSG_ARMOR_SCALE_MAIL,
		"スケイル・メイル" },
	{ N_MSG_ARMOR_RED_DRAGON_SCALE,
		"レッド・ドラゴン・スケイル" },
	{ N_MSG_ARMOR_BLUE_DRAGON_SCALE,
		"ブルー・ドラゴン・スケイル" },
	{ N_MSG_ARMOR_YELLOW_DRAGON_SCALE,
		"イエロー・ドラゴン・スケイル" },
	{ N_MSG_ARMOR_GREEN_DRAGON_SCALE,
		"グリーン・ドラゴン・スケイル" },
	{ N_MSG_ARMOR_WHITE_DRAGON_SCALE,
		"ホワイト・ドラゴン・スケイル" },
	{ N_MSG_ARMOR_BLACK_DRAGON_SCALE,
		"ブラック・ドラゴン・スケイル" },
	{ N_MSG_ARMOR_COPPER_DRAGON_SCALE,
		"カッパー・ドラゴン・スケイル" },
	{ N_MSG_ARMOR_SILVER_DRAGON_SCALE,
		"シルバー・ドラゴン・スケイル" },
	{ N_MSG_ARMOR_GOLD_DRAGON_SCALE,
		"ゴールド・ドラゴン・スケイル" },
	{ N_MSG_ARMOR_LAMELLAR_ARMOR,
		"ラメラー・アーマ" },
	{ N_MSG_ARMOR_CHAIN_MAIL,
		"チェイン・メイル" },
	{ N_MSG_ARMOR_MITHRIL_CHAIN,
		"ミスリル・チェイン" },
	{ N_MSG_ARMOR_PLATE_ARMOR,
		"プレート・アーマ" },

	{ N_MSG_ARMOR_CLOAK,
		"クローク" },

	{ N_MSG_ARMOR_LEATHER_GLOVES,
		"レザー・グローブ" },
	{ N_MSG_ARMOR_GAUNTLETS,
		"ゴーントレット" },
	{ N_MSG_ARMOR_GAUNTLETS_OF_POW_UP_HIT,
		"ゴーントレット (攻撃力+)" },
	{ N_MSG_ARMOR_GAUNTLETS_OF_POW_DOWN_HIT,
		"ゴーントレット (攻撃力-)" },
	{ N_MSG_ARMOR_GAUNTLETS_OF_POW_UP_WPN_CRTCL,
		"ゴーントレット (クリティカル+)" },
	{ N_MSG_ARMOR_GAUNTLETS_OF_POW_DOWN_WPN_CRTCL,
		"ゴーントレット (クリティカル-)" },
	{ N_MSG_ARMOR_GAUNTLETS_OF_POW_UP_DAM,
		"ゴーントレット (ダメージ+)" },
	{ N_MSG_ARMOR_GAUNTLETS_OF_POW_DOWN_DAM,
		"ゴーントレット (ダメージ-)" },

	{ N_MSG_ARMOR_LEATHER_BOOTS,
		"レザー・ブーツ" },
	{ N_MSG_ARMOR_GREAVE,
		"グリーブ" },
	{ N_MSG_ARMOR_SPEED_BOOTS,
		"スピード・ブーツ" },
	{ N_MSG_ARMOR_SLOW_BOOTS,
		"スロー・ブーツ" },

	{ N_MSG_ARMOR_BUCKLER_SHIELD,
		"バックラー" },
	{ N_MSG_ARMOR_ROUND_SHIELD,
		"ラウンド・シールド" },
	{ N_MSG_ARMOR_KITE_SHIELD,
		"カイト・シールド" },
	{ N_MSG_ARMOR_HEATER_SHIELD,
		"ヒーター・シールド" },

/* Potion */

	{ N_MSG_POTION_WATER,
		"水" },
	{ N_MSG_POTION_MILK,
		"ミルク" },
	{ N_MSG_POTION_WHITE_WINE,
		"白ワイン" },
	{ N_MSG_POTION_RED_WINE,
		"赤ワイン" },
	{ N_MSG_POTION_ROSE_WINE,
		"ロゼ・ワイン" },
	{ N_MSG_POTION_ALE,
		"エール" },
	{ N_MSG_POTION_BRANDY,
		"ブランデー" },
	{ N_MSG_POTION_RUM,
		"ラム酒" },
	{ N_MSG_POTION_COFFE,
		"コーヒー" },
	{ N_MSG_POTION_ICE_COFFE,
		"アイス・コーヒー" },
	{ N_MSG_POTION_TEA,
		"ストレート・ティー" },
	{ N_MSG_POTION_MILK_TEA,
		"ミルク・ティー" },
	{ N_MSG_POTION_LEMON_TEA,
		"レモン・ティー" },
	{ N_MSG_POTION_ICE_TEA,
		"アイス・ティー" },
	{ N_MSG_POTION_ICE_MILK_TEA,
		"アイス・ミルク・ティー" },
	{ N_MSG_POTION_ICE_LEMON_TEA,
		"アイス・レモン・ティー" },
	{ N_MSG_POTION_APPLE_JUICE,
		"アップル・ジュース" },
	{ N_MSG_POTION_GRAPE_JUICE,
		"グレープ・ジュース" },
	{ N_MSG_POTION_ORANGE_JUICE,
		"オレンジ・ジュース" },
	{ N_MSG_POTION_BLACK_BERRY_JUICE,
		"ブラックベリー・ジュース" },
	{ N_MSG_POTION_CRAN_BERRY_JUICE,
		"クランベリー・ジュース" },
	{ N_MSG_POTION_RASP_BERRY_JUICE,
		"ラズベリー・ジュース" },
	{ N_MSG_POTION_STRAW_BERRY_JUICE,
		"ストロベリー・ジュース" },
	{ N_MSG_POTION_OIL,
		"油" },
	{ N_MSG_POTION_STONE,
		"石化の薬" },
	{ N_MSG_POTION_PARALYZE,
		"麻痺の薬" },
	{ N_MSG_POTION_POISON,
		"毒薬" },
	{ N_MSG_POTION_CONFUSION,
		"混乱の薬" },
	{ N_MSG_POTION_BLIND,
		"盲目の薬" },
	{ N_MSG_POTION_SLEEP,
		"睡眠薬" },
	{ N_MSG_POTION_SILENCE,
		"沈黙の薬" },
	{ N_MSG_POTION_FEAR,
		"恐怖の薬" },
	{ N_MSG_POTION_HALLUCINATION,
		"幻覚の薬" },
	{ N_MSG_POTION_CHARM,
		"魅了の薬" },
	{ N_MSG_POTION_FLY,
		"空中浮遊の薬" },
	{ N_MSG_POTION_VANISH,
		"透明化の薬" },
	{ N_MSG_POTION_IRON_BODY,
		"鋼鉄化の薬" },
	{ N_MSG_POTION_PASSWALL,
		"壁抜けの薬" },
	{ N_MSG_POTION_SENSE_INVISIBLE,
		"不可視感知の薬" },
	{ N_MSG_POTION_CURE_LEV,
		"レベル回復の薬" },
	{ N_MSG_POTION_CURE_HP_LIGHT,
		"体力小回復の薬" },
	{ N_MSG_POTION_CURE_HP_MODERATE,
		"体力中回復の薬" },
	{ N_MSG_POTION_CURE_HP_SERIOUS,
		"体力大回復の薬" },
	{ N_MSG_POTION_CURE_HP_MAX,
		"体力完全回復の薬" },
	{ N_MSG_POTION_CURE_POISON,
		"解毒の薬" },
	{ N_MSG_POTION_CURE_STATUS,
		"状態回復の薬" },
	{ N_MSG_POTION_RESI_PHYS,
		"物理抵抗の薬" },
	{ N_MSG_POTION_RESI_HEAT,
		"火熱抵抗の薬" },
	{ N_MSG_POTION_RESI_COLD,
		"水冷抵抗の薬" },
	{ N_MSG_POTION_RESI_MIND,
		"風心抵抗の薬" },
	{ N_MSG_POTION_RESI_ACID,
		"土酸抵抗の薬" },
	{ N_MSG_POTION_RESI_ELEC,
		"光雷抵抗の薬" },
	{ N_MSG_POTION_RESI_POIS,
		"闇毒抵抗の薬" },
	{ N_MSG_POTION_SHARPNESS,
		"器用度増強の薬" },
	{ N_MSG_POTION_DULLNESS,
		"器用度減退の薬" },
	{ N_MSG_POTION_STRENGTH,
		"筋力増強の薬" },
	{ N_MSG_POTION_WEAKNESS,
		"筋力減退の薬" },
	{ N_MSG_POTION_QUICKNESS,
		"敏捷度増強の薬" },
	{ N_MSG_POTION_SLOWNESS,
		"敏捷度減退の薬" },
	{ N_MSG_POTION_BRAINY,
		"知力増強の薬" },
	{ N_MSG_POTION_BRAINLESS,
		"知力減退の薬" },
	{ N_MSG_POTION_WISE,
		"判断力増強の薬" },
	{ N_MSG_POTION_FOOLISH,
		"判断力減退の薬" },
	{ N_MSG_POTION_ATTRACTIVE,
		"魅力増強の薬" },
	{ N_MSG_POTION_UNATTRACTIVE,
		"魅力減退の薬" },
	{ N_MSG_POTION_POW_UP_HP,
		"体力増強の薬" },
	{ N_MSG_POTION_SPEED_UP,
		"加速の薬" },
	{ N_MSG_POTION_SPEED_DOWN,
		"減速の薬" },
	{ N_MSG_POTION_DETECT_MNSTR,
		"モンスター探知の薬" },

	{ N_MSG_POTION_COLOR_CRYSTAL,
		"透明" },
	{ N_MSG_POTION_COLOR_CRYSTAL_WHITE,
		"半透明な白色" },
	{ N_MSG_POTION_COLOR_CRYSTAL_BLACK,
		"半透明な黒色" },
	{ N_MSG_POTION_COLOR_CRYSTAL_RED,
		"半透明な赤色" },
	{ N_MSG_POTION_COLOR_CRYSTAL_GREEN,
		"半透明な緑色" },
	{ N_MSG_POTION_COLOR_CRYSTAL_BLUE,
		"半透明な青色" },
	{ N_MSG_POTION_COLOR_CRYSTAL_YELLOW,
		"半透明な黄色" },
	{ N_MSG_POTION_COLOR_CRYSTAL_RED_PURPLE,
		"半透明な赤紫色" },
	{ N_MSG_POTION_COLOR_CRYSTAL_BLUE_PURPLE,
		"半透明な青紫色" },
	{ N_MSG_POTION_COLOR_CRYSTAL_ORANGE,
		"半透明なオレンジ色" },
	{ N_MSG_POTION_COLOR_CRYSTAL_PINK,
		"半透明なピンク色" },
	{ N_MSG_POTION_COLOR_CRYSTAL_BROWN,
		"半透明な茶色" },
	{ N_MSG_POTION_COLOR_WHITE,
		"白色" },
	{ N_MSG_POTION_COLOR_BLACK,
		"黒色" },
	{ N_MSG_POTION_COLOR_RED,
		"赤色" },
	{ N_MSG_POTION_COLOR_GREEN,
		"緑色" },
	{ N_MSG_POTION_COLOR_BLUE,
		"青色" },
	{ N_MSG_POTION_COLOR_YELLOW,
		"黄色" },
	{ N_MSG_POTION_COLOR_RED_PURPLE,
		"赤紫色" },
	{ N_MSG_POTION_COLOR_BLUE_PURPLE,
		"青紫色" },
	{ N_MSG_POTION_COLOR_ORANGE,
		"オレンジ色" },
	{ N_MSG_POTION_COLOR_PINK,
		"ピンク色" },
	{ N_MSG_POTION_COLOR_BROWN,
		"茶色" },
	{ N_MSG_POTION_COLOR_LUMINOUS_WHITE,
		"蛍光の白色" },
	{ N_MSG_POTION_COLOR_LUMINOUS_BLACK,
		"蛍光の黒色" },
	{ N_MSG_POTION_COLOR_LUMINOUS_RED,
		"蛍光の赤色" },
	{ N_MSG_POTION_COLOR_LUMINOUS_GREEN,
		"蛍光の緑色" },
	{ N_MSG_POTION_COLOR_LUMINOUS_BLUE,
		"蛍光の青色" },
	{ N_MSG_POTION_COLOR_LUMINOUS_YELLOW,
		"蛍光の黄色" },
	{ N_MSG_POTION_COLOR_LUMINOUS_RED_PURPLE,
		"蛍光の赤紫色" },
	{ N_MSG_POTION_COLOR_LUMINOUS_BLUE_PURPLE,
		"蛍光の青紫色" },
	{ N_MSG_POTION_COLOR_LUMINOUS_ORANGE,
		"蛍光のオレンジ色" },
	{ N_MSG_POTION_COLOR_LUMINOUS_PINK,
		"蛍光のピンク色" },
	{ N_MSG_POTION_COLOR_LUMINOUS_BROWN,
		"蛍光の茶色" },
	{ N_MSG_POTION_COLOR_SPOTTED_WHITE,
		"斑の白色" },
	{ N_MSG_POTION_COLOR_SPOTTED_BLACK,
		"斑の黒色" },
	{ N_MSG_POTION_COLOR_SPOTTED_RED,
		"斑の赤色" },
	{ N_MSG_POTION_COLOR_SPOTTED_GREEN,
		"斑の緑色" },
	{ N_MSG_POTION_COLOR_SPOTTED_BLUE,
		"斑の青色" },
	{ N_MSG_POTION_COLOR_SPOTTED_YELLOW,
		"斑の黄色" },
	{ N_MSG_POTION_COLOR_SPOTTED_RED_PURPLE,
		"斑の赤紫色" },
	{ N_MSG_POTION_COLOR_SPOTTED_BLUE_PURPLE,
		"斑の青紫色" },
	{ N_MSG_POTION_COLOR_SPOTTED_ORANGE,
		"斑のオレンジ色" },
	{ N_MSG_POTION_COLOR_SPOTTED_PINK,
		"斑のピンク色" },
	{ N_MSG_POTION_COLOR_SPOTTED_BROWN,
		"斑の茶色" },
	{ N_MSG_POTION_COLOR_MILK,
		"ミルク色" },
	{ N_MSG_POTION_COLOR_WHITE_WINE,
		"白ワイン色" },
	{ N_MSG_POTION_COLOR_RED_WINE,
		"赤ワイン色" },
	{ N_MSG_POTION_COLOR_ROSE_WINE,
		"ロゼワイン色" },
	{ N_MSG_POTION_COLOR_ALE,
		"エール色" },
	{ N_MSG_POTION_COLOR_BRANDY,
		"ブランデー色" },
	{ N_MSG_POTION_COLOR_RUM,
		"ラム酒色" },
	{ N_MSG_POTION_COLOR_COFFE,
		"コーヒー色" },
	{ N_MSG_POTION_COLOR_ICE_COFFE,
		"アイス・コーヒー色" },
	{ N_MSG_POTION_COLOR_TEA,
		"ストレート・ティー色" },
	{ N_MSG_POTION_COLOR_MILK_TEA,
		"ミルク・ティー色" },
	{ N_MSG_POTION_COLOR_LEMON_TEA,
		"レモン・ティー色" },
	{ N_MSG_POTION_COLOR_ICE_TEA,
		"アイス・ティー色" },
	{ N_MSG_POTION_COLOR_ICE_MILK_TEA,
		"アイス・ミルク・ティー色" },
	{ N_MSG_POTION_COLOR_ICE_LEMON_TEA,
		"アイス・レモン・ティー色" },
	{ N_MSG_POTION_COLOR_APPLE_JUICE,
		"アップル・ジュース色" },
	{ N_MSG_POTION_COLOR_GRAPE_JUICE,
		"グレープ・ジュース色" },
	{ N_MSG_POTION_COLOR_ORANGE_JUICE,
		"オレンジ・ジュース色" },
	{ N_MSG_POTION_COLOR_BLACK_BERRY_JUICE,
		"ブラックベリー・ジュース色" },
	{ N_MSG_POTION_COLOR_CRAN_BERRY_JUICE,
		"クランベリー・ジュース色" },
	{ N_MSG_POTION_COLOR_RASP_BERRY_JUICE,
		"ラズベリー・ジュース色" },
	{ N_MSG_POTION_COLOR_STRAW_BERRY_JUICE,
		"ストロベリー・ジュース色" },

/* Scroll */

	{ N_MSG_SCROLL_SLEEP,
		"睡眠の巻物" },
	{ N_MSG_SCROLL_IDENTIFY_ITEM,
		"アイテム識別の巻物" },
	{ N_MSG_SCROLL_IDENTIFY_ALL_ITEM,
		"全アイテム識別の巻物" },
	{ N_MSG_SCROLL_DETECT_ITEM,
		"アイテム探知の巻物" },
	{ N_MSG_SCROLL_TELEPORT,
		"瞬間移動の巻物" },
	{ N_MSG_SCROLL_POW_UP_WPN_HIT,
		"武器の攻撃力強化の巻物" },
	{ N_MSG_SCROLL_POW_UP_WPN_CRTCL,
		"武器のクリティカル強化の巻物" },
	{ N_MSG_SCROLL_POW_UP_WPN_DAM,
		"武器のダメージ強化の巻物" },
	{ N_MSG_SCROLL_POW_UP_ARMOR_DEF,
		"防具の防御力強化の巻物" },
	{ N_MSG_SCROLL_POW_UP_ARMOR_CRTCL,
		"防具のクリティカル強化の巻物" },
	{ N_MSG_SCROLL_POW_UP_ARMOR_AC,
		"防具の装甲値強化の巻物" },
	{ N_MSG_SCROLL_PROTECT_ARMOR,
		"防具の保護の巻物" },
	{ N_MSG_SCROLL_BOOMERANG,
		"ブーメランの巻物" },
	{ N_MSG_SCROLL_REMOVE_CURSE,
		"解呪の巻物" },
	{ N_MSG_SCROLL_RECALL,
		"帰還の巻物" },
	{ N_MSG_SCROLL_TYPHOON,
		"台風の術 (木遁)の巻物" },
	{ N_MSG_SCROLL_CONFLAGRATION,
		"火災の術 (火遁)の巻物" },
	{ N_MSG_SCROLL_EARTHQUAKE,
		"地震の術 (土遁)の巻物" },
	{ N_MSG_SCROLL_THUNDERCLOUD,
		"雷雲の術 (金遁)の巻物" },
	{ N_MSG_SCROLL_INUNDATION,
		"洪水の術 (水遁)の巻物" },
	{ N_MSG_SCROLL_SUBSTITUTE,
		"空蝉の術 (木遁)の巻物" },
	{ N_MSG_SCROLL_BURNING_HANDS,
		"炎指の術 (火遁)の巻物" },
	{ N_MSG_SCROLL_RALLY,
		"捲土重来の術 (土遁)の巻物" },
	{ N_MSG_SCROLL_IRON_MAN,
		"鉄人の術 (金遁)の巻物" },
	{ N_MSG_SCROLL_MIND_READING,
		"明鏡止水の術 (水遁)の巻物" },

	{ N_MSG_READ_SCROLL_FAILURE,
		"周りが暗くて %s は巻物を読めません" },

	{ N_MSG_SCROLL_TTL_SYLLABLE_DIV,
		"・" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_000,
		"ア" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_001,
		"イン" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_002,
		"ザ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_010,
		"オン" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_011,
		"キリキリ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_012,
		"バサラ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_013,
		"ンハッタ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_020,
		"アブラ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_021,
		"カダブラ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_030,
		"ビビデ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_031,
		"バビデ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_032,
		"ブゥ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_040,
		"ショ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_041,
		"ギョウ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_042,
		"ムジョウ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_050,
		"ナム" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_051,
		"アミダ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_052,
		"ブツ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_060,
		"ケセラン" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_061,
		"パサラン" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_070,
		"エロ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_071,
		"イム" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_072,
		"エッサイム" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_080,
		"ミノ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_081,
		"モン" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_082,
		"タ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_090,
		"クック" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_091,
		"ドゥドゥル" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_092,
		"ドゥー" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_101,
		"ユーナ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_102,
		"ダブ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_103,
		"トライ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_104,
		"テト" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_110,
		"ヘキ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_111,
		"レキ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_120,
		"ケセラ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_121,
		"セラ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_130,
		"エンヤ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_131,
		"コリャ" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_140,
		"アン" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_141,
		"ポン" },
	{ N_MSG_SCROLL_TTL_SYLLABLE_142,
		"タン" },

/* Stick */

	{ N_MSG_STICK_FAILURE,
		"なにも起こらなかった" },

	{ N_MSG_STICK_MATERIAL_APPLEWOOD,
		"リンゴの木" },
	{ N_MSG_STICK_MATERIAL_ASHEN,
		"とねりこの木" },
	{ N_MSG_STICK_MATERIAL_ASPEN,
		"ポプラ" },
	{ N_MSG_STICK_MATERIAL_AVOCADO_WOOD,
		"アボカドの木" },
	{ N_MSG_STICK_MATERIAL_BALSA,
		"バルサ" },
	{ N_MSG_STICK_MATERIAL_BANYAN,
		"バンヤンの木" },
	{ N_MSG_STICK_MATERIAL_BIRCH,
		"かばの木" },
	{ N_MSG_STICK_MATERIAL_CEDAR,
		"杉の木" },
	{ N_MSG_STICK_MATERIAL_CHERRYWOOD,
		"桜の木" },
	{ N_MSG_STICK_MATERIAL_COTTONWOOD,
		"はひろはこやなぎの木" },
	{ N_MSG_STICK_MATERIAL_CYPRESS,
		"いとすぎの木" },
	{ N_MSG_STICK_MATERIAL_DOGWOOD,
		"みずきの木" },
	{ N_MSG_STICK_MATERIAL_DRIFTWOOD,
		"流木" },
	{ N_MSG_STICK_MATERIAL_EBONY,
		"黒檀" },
	{ N_MSG_STICK_MATERIAL_ELM_WOOD,
		"にれの木" },
	{ N_MSG_STICK_MATERIAL_EUCALYPTUS,
		"ユーカリの木" },
	{ N_MSG_STICK_MATERIAL_GRAPEVINE,
		"ぶどうの木" },
	{ N_MSG_STICK_MATERIAL_HAWTHORN,
		"さんざしの木" },
	{ N_MSG_STICK_MATERIAL_HEMLOCK,
		"つがの木" },
	{ N_MSG_STICK_MATERIAL_HICKORY,
		"ヒッコリーの木" },
	{ N_MSG_STICK_MATERIAL_JUNIPER,
		"西洋ねずの木" },
	{ N_MSG_STICK_MATERIAL_LOCUST,
		"にせアカシアの木" },
	{ N_MSG_STICK_MATERIAL_MAHOGANY,
		"マホガニーの木" },
	{ N_MSG_STICK_MATERIAL_MAGNOLIA,
		"もくれんの木" },
	{ N_MSG_STICK_MATERIAL_MAPLE,
		"かえでの木" },
	{ N_MSG_STICK_MATERIAL_MULBERRY,
		"くわの木" },
	{ N_MSG_STICK_MATERIAL_OAK,
		"オークの木" },
	{ N_MSG_STICK_MATERIAL_PECAN,
		"ぺかんの木" },
	{ N_MSG_STICK_MATERIAL_PERSIMMON,
		"かきの木" },
	{ N_MSG_STICK_MATERIAL_PINE,
		"松の木" },
	{ N_MSG_STICK_MATERIAL_REDWOOD,
		"セコイヤの木" },
	{ N_MSG_STICK_MATERIAL_ROSEWOOD,
		"紫檀の木" },
	{ N_MSG_STICK_MATERIAL_SPRUCE,
		"とうひの木" },
	{ N_MSG_STICK_MATERIAL_SUMAC,
		"うるしの木" },
	{ N_MSG_STICK_MATERIAL_SYCAMORE,
		"大かえでの木" },
	{ N_MSG_STICK_MATERIAL_TEAK,
		"チークの木" },
	{ N_MSG_STICK_MATERIAL_WALNUT,
		"胡桃の木" },

/* Accecery */

	{ N_MSG_RING_SLOW_DIGESTION,
		"消化を遅くする指輪" },
	{ N_MSG_RING_TELEPORT_PARTY,
		"パーティ瞬間移動の指輪" },
	{ N_MSG_RING_TELEPORT,
		"瞬間移動の指輪" },
	{ N_MSG_RING_SHARPNESS,
		"器用度増強の指輪" },
	{ N_MSG_RING_DULLNESS,
		"器用度減退の指輪" },
	{ N_MSG_RING_STRENGTH,
		"筋力増強の指輪" },
	{ N_MSG_RING_WEAKNESS,
		"筋力減退の指輪" },
	{ N_MSG_RING_QUICKNESS,
		"敏捷度増強の指輪" },
	{ N_MSG_RING_SLOWNESS,
		"敏捷度減退の指輪" },
	{ N_MSG_RING_BRAINY,
		"知力増強の指輪" },
	{ N_MSG_RING_BRAINLESS,
		"知力減退の指輪" },
	{ N_MSG_RING_WISE,
		"判断力増強の指輪" },
	{ N_MSG_RING_FOOLISH,
		"判断力減退の指輪" },
	{ N_MSG_RING_ATTRACTIVE,
		"魅力増強の指輪" },
	{ N_MSG_RING_UNATTRACTIVE,
		"魅力減退の指輪" },
	{ N_MSG_RING_CURE_HP,
		"HP回復の指輪" },
	{ N_MSG_RING_CURE_MP,
		"MP回復の指輪" },
	{ N_MSG_RING_DRAIN_HP,
		"HP消耗の指輪" },
	{ N_MSG_RING_DRAIN_MP,
		"MP消耗の指輪" },

	{ N_MSG_AMULET_RESI_STAT_DEAD,
		"死亡抵抗の魔除け" },
	{ N_MSG_AMULET_RESI_STAT_STONE,
		"石化抵抗の魔除け" },
	{ N_MSG_AMULET_RESI_STAT_PARALYZE,
		"石化抵抗の魔除け" },
	{ N_MSG_AMULET_RESI_STAT_POISON,
		"麻痺抵抗の魔除け" },
	{ N_MSG_AMULET_RESI_STAT_CONFUSION,
		"混乱抵抗の魔除け" },
	{ N_MSG_AMULET_RESI_STAT_BLIND,
		"盲目抵抗の魔除け" },
	{ N_MSG_AMULET_RESI_STAT_SLEEP,
		"睡眠抵抗の魔除け" },
	{ N_MSG_AMULET_RESI_STAT_SILENCE,
		"沈黙抵抗の魔除け" },
	{ N_MSG_AMULET_RESI_STAT_FEAR,
		"恐怖抵抗の魔除け" },
	{ N_MSG_AMULET_RESI_STAT_HALLUCINATION,
		"幻覚抵抗の魔除け" },
	{ N_MSG_AMULET_RESI_STAT_CHARM,
		"魅了抵抗の魔除け" },
	{ N_MSG_AMULET_RESI_STAT_FLY,
		"空中浮遊抵抗の魔除け" },
	{ N_MSG_AMULET_RESI_STAT_DRUNK,
		"酔い抵抗の魔除け" },
	{ N_MSG_AMULET_RESI_STAT_VANISH,
		"透明化抵抗の魔除け" },
	{ N_MSG_AMULET_RESI_STAT_IRON_BODY,
		"鋼鉄化抵抗の魔除け" },
	{ N_MSG_AMULET_RESI_STAT_PASSWALL,
		"壁抜け抵抗の魔除け" },
	{ N_MSG_AMULET_RESI_STAT_SENSE_INVISIBLE,
		"不可視感知抵抗の魔除け" },

	{ N_MSG_NECKLACE_RESI_PHYS,
		"物理抵抗の首飾り" },
	{ N_MSG_NECKLACE_RESI_HEAT,
		"火熱抵抗の首飾り" },
	{ N_MSG_NECKLACE_RESI_COLD,
		"水冷抵抗の首飾り" },
	{ N_MSG_NECKLACE_RESI_MIND,
		"風心抵抗の首飾り" },
	{ N_MSG_NECKLACE_RESI_ACID,
		"土酸抵抗の首飾り" },
	{ N_MSG_NECKLACE_RESI_ELEC,
		"光雷抵抗の首飾り" },
	{ N_MSG_NECKLACE_RESI_POIS,
		"闇毒抵抗の首飾り" },

	{ N_MSG_NECKLACE_CURSE_PHYS,
		"物理抵抗弱体の首飾り" },
	{ N_MSG_NECKLACE_CURSE_HEAT,
		"火熱抵抗弱体の首飾り" },
	{ N_MSG_NECKLACE_CURSE_COLD,
		"水冷抵抗弱体の首飾り" },
	{ N_MSG_NECKLACE_CURSE_MIND,
		"風心抵抗弱体の首飾り" },
	{ N_MSG_NECKLACE_CURSE_ACID,
		"土酸抵抗弱体の首飾り" },
	{ N_MSG_NECKLACE_CURSE_ELEC,
		"光雷抵抗弱体の首飾り" },
	{ N_MSG_NECKLACE_CURSE_POIS,
		"闇毒抵抗弱体の首飾り" },

	{ N_MSG_ACCE_MATERIAL_BONE,
		"骨" },
	{ N_MSG_ACCE_MATERIAL_GOLD,
		"金" },
	{ N_MSG_ACCE_MATERIAL_SILVER,
		"銀" },

	{ N_MSG_ACCE_GEM_AMBER,
		"こはく" },
	{ N_MSG_ACCE_GEM_AGATE,
		"めのう" },
	{ N_MSG_ACCE_GEM_ALEXANDRITE,
		"アレキサンドライト" },
	{ N_MSG_ACCE_GEM_AMETHYST,
		"紫水晶" },
	{ N_MSG_ACCE_GEM_ANTLERITE,
		"アントレライト" },
	{ N_MSG_ACCE_GEM_AQUAMARINE,
		"藍玉" },
	{ N_MSG_ACCE_GEM_ARGENTITE,
		"アージェンタイト" },
	{ N_MSG_ACCE_GEM_AZURITE,
		"アズライト" },
	{ N_MSG_ACCE_GEM_BERYL,
		"緑柱石" },
	{ N_MSG_ACCE_GEM_BLOODSTONE,
		"ブロッドストーン" },
	{ N_MSG_ACCE_GEM_CALCITE,
		"カルサイト" },
	{ N_MSG_ACCE_GEM_CARNELIAN,
		"紅玉髄" },
	{ N_MSG_ACCE_GEM_CORAL,
		"さんご" },
	{ N_MSG_ACCE_GEM_CORUNDUM,
		"銅玉" },
	{ N_MSG_ACCE_GEM_CRYOLITE,
		"クリオライト" },
	{ N_MSG_ACCE_GEM_DIAMOND,
		"ダイヤモンド" },
	{ N_MSG_ACCE_GEM_DIORITE,
		"ダイオライト" },
	{ N_MSG_ACCE_GEM_EMERALD,
		"エメラルド" },
	{ N_MSG_ACCE_GEM_FLINT,
		"火打ち石" },
	{ N_MSG_ACCE_GEM_FLUORITE,
		"蛍石" },
	{ N_MSG_ACCE_GEM_GABBRO,
		"ギャブロ" },
	{ N_MSG_ACCE_GEM_GARNET,
		"ざくろ石" },
	{ N_MSG_ACCE_GEM_GRANITE,
		"みかげ石" },
	{ N_MSG_ACCE_GEM_GYPSUM,
		"石こう" },
	{ N_MSG_ACCE_GEM_HEMATITE,
		"ヘマタイト" },
	{ N_MSG_ACCE_GEM_JADE,
		"ひすい" },
	{ N_MSG_ACCE_GEM_JASPER,
		"碧玉" },
	{ N_MSG_ACCE_GEM_KRYPTONITE,
		"クリプトナイト" },
	{ N_MSG_ACCE_GEM_LAPIS_LAZULI,
		"るり" },
	{ N_MSG_ACCE_GEM_LIMESTONE,
		"石灰岩" },
	{ N_MSG_ACCE_GEM_MALACHITE,
		"孔雀石" },
	{ N_MSG_ACCE_GEM_MANGANITE,
		"マンガナイト" },
	{ N_MSG_ACCE_GEM_MARBLE,
		"大理石" },
	{ N_MSG_ACCE_GEM_MOONSTONE,
		"月長石" },
	{ N_MSG_ACCE_GEM_NEPTUNITE,
		"ネプチュナイト" },
	{ N_MSG_ACCE_GEM_OBSIDIAN,
		"黒曜岩" },
	{ N_MSG_ACCE_GEM_ONYX,
		"しまめのう" },
	{ N_MSG_ACCE_GEM_OPAL,
		"オパール" },
	{ N_MSG_ACCE_GEM_PEARL,
		"真珠" },
	{ N_MSG_ACCE_GEM_PYRITES,
		"硫化鉄鉱" },
	{ N_MSG_ACCE_GEM_QUARTZ,
		"石英" },
	{ N_MSG_ACCE_GEM_QUARTZITE,
		"クオーツァイト" },
	{ N_MSG_ACCE_GEM_RHODONITE,
		"ルードナイト" },
	{ N_MSG_ACCE_GEM_RHYOLITE,
		"リョーライト" },
	{ N_MSG_ACCE_GEM_RUBY,
		"ルビー" },
	{ N_MSG_ACCE_GEM_SAPPHIRE,
		"サファイア" },
	{ N_MSG_ACCE_GEM_SPHALERITE,
		"スフェラーライト" },
	{ N_MSG_ACCE_GEM_STAUROLITE,
		"スタロライト" },
	{ N_MSG_ACCE_GEM_TIGER_EYE,
		"タイガーアイ" },
	{ N_MSG_ACCE_GEM_TOPAZ,
		"トパーズ" },
	{ N_MSG_ACCE_GEM_TURQUOISE,
		"トルコ石" },
	{ N_MSG_ACCE_GEM_ZIRCON,
		"ジルコン" },

/* Musical Instrument */

/* STRINGED - 回復 */
	{ N_MSG_INST_VIOLIN,
		"バイオリン" },
	{ N_MSG_INST_VIOLA,
		"ビオラ" },
	{ N_MSG_INST_CELLO,
		"チェロ" },
	{ N_MSG_INST_DOUBLEBASS,
		"コントラバス" },
	{ N_MSG_INST_HARP,
		"ハープ" },
	{ N_MSG_INST_MANDOLIN,
		"マンドリン" },
	{ N_MSG_INST_BANJO,
		"バンジョー" },
	{ N_MSG_INST_SITAR,
		"シタール" },

/* WOODWIND - 能力値強化 */
	{ N_MSG_INST_FLUTE,
		"フルート" },
	{ N_MSG_INST_CLARINET,
		"クラリネット" },
	{ N_MSG_INST_BASS_CLARINET,
		"バスクラリネット" },
	{ N_MSG_INST_PICCOLO,
		"ピッコロ" },
	{ N_MSG_INST_OBOE,
		"オーボエ" },
	{ N_MSG_INST_BASSOON,
		"バスーン" },
	{ N_MSG_INST_SAXOPHONE,
		"サキソフォン" },

/* BRASS - 能力値弱体 */
	{ N_MSG_INST_TRUMPET,
		"トランペット" },
	{ N_MSG_INST_TROMBONE,
		"トロンボーン" },
	{ N_MSG_INST_FLUGELHORN,
		"フリューゲルホーン" },
	{ N_MSG_INST_CORNET,
		"コルネット" },
	{ N_MSG_INST_HORN,
		"ホルン" },
	{ N_MSG_INST_TUBA,
		"チューバ" },
	{ N_MSG_INST_SOUSAPHONE,
		"スーザフォン" },
	{ N_MSG_INST_BUGLE,
		"ビューグル" },

/* PERCUSSION - 状態抵抗 */
	{ N_MSG_INST_BASS_DRUM,
		"バスドラム" },
	{ N_MSG_INST_TENOR_DRUM,
		"テナードラム" },
	{ N_MSG_INST_SNARE_DRUM,
		"スネアドラム" },
	{ N_MSG_INST_TOMTOM,
		"トムトム" },
	{ N_MSG_INST_CONGAS,
		"コンガ" },
	{ N_MSG_INST_TIMPANI,
		"ティンパニ" },
	{ N_MSG_INST_CYMBAL,
		"シンバル" },
	{ N_MSG_INST_GONG,
		"ゴング" },
	{ N_MSG_INST_MARACA,
		"マラカス" },
	{ N_MSG_INST_TRIANGLE,
		"トライアングル" },
	{ N_MSG_INST_CASTANETS,
		"カスタネット" },
	{ N_MSG_INST_TUBULAR_BELLS,
		"チューブラーベルズ" },
	{ N_MSG_INST_XYLOPHONE,
		"シロフォン" },

/* MISC - 全て */
	{ N_MSG_INST_ACCORDION,
		"アコーディオン" },
	{ N_MSG_INST_BAGPIPE,
		"バグパイプ" },
	{ N_MSG_INST_HARMONICA,
		"ハーモニカ" },
	{ N_MSG_INST_KAZOO,
		"カズー" },

/* Anthology */

	{ N_MSG_ANTHOLOGY_CURE,
		"愛の詩集 (回復)" },
	{ N_MSG_ANTHOLOGY_STRENGTHEN_ABL,
		"勇者の詩集 (能力値強化)" },
	{ N_MSG_ANTHOLOGY_WEAKEN_ABL,
		"魔物の詩集 (能力値弱体)" },
	{ N_MSG_ANTHOLOGY_RESI_STAT,
		"賢者の詩集 (状態抵抗)" },

/* Light */

	{ N_MSG_LIGHT_TORCH,
		"たいまつ" },
	{ N_MSG_LIGHT_LANTERN,
		"ランタン" },
	{ N_MSG_LIGHT_LAMP,
		"ランプ" },
	{ N_MSG_LIGHT_LAMP_ARMAGEDDON,
		"ハルマゲドンのランプ" },
	{ N_MSG_LIGHT_LAMP_DAEMON,
		"悪魔のランプ" },
	{ N_MSG_LIGHT_LAMP_DJINNI,
		"魔神のランプ" },

/* Spike */

	{ N_MSG_SPIKE,
		"釘" },

/* Food */

	{ N_MSG_FOOD_PRESERVED,
		"保存食" },
	{ N_MSG_FOOD_SAUSAGE,
		"ソーセージ" },
	{ N_MSG_FOOD_BACON,
		"ベーコン" },
	{ N_MSG_FOOD_CHIPPED_BEEF,
		"干し肉" },
	{ N_MSG_FOOD_CORNED_BEEF,
		"コンビーフ" },
	{ N_MSG_FOOD_BREAD,
		"パン" },
	{ N_MSG_FOOD_BROWN_BREAD,
		"黒パン" },
	{ N_MSG_FOOD_TOAST,
		"トースト" },
	{ N_MSG_FOOD_PANCAKE,
		"パンケーキ" },
	{ N_MSG_FOOD_SALAD,
		"サラダ" },
	{ N_MSG_FOOD_POTATO_SALAD,
		"ポテト・サラダ" },
	{ N_MSG_FOOD_SCRAMBLED_EGGS,
		"スクランブル・エッグ" },
	{ N_MSG_FOOD_FRIED_EGGS,
		"目玉焼" },
	{ N_MSG_FOOD_HARD_BOILED_EGGS,
		"ゆで卵" },
	{ N_MSG_FOOD_SOFT_BOILED_EGGS,
		"半熟卵" },
	{ N_MSG_FOOD_BEEF_STEAK,
		"ビーフ・ステーキ" },
	{ N_MSG_FOOD_PORK_SAUTE,
		"ポーク・ソテー" },
	{ N_MSG_FOOD_FRIED_CHICKEN,
		"フライド・チキン" },
	{ N_MSG_FOOD_FRIED_FISH,
		"フライド・フィッシュ" },
	{ N_MSG_FOOD_FRIED_POTATO,
		"フライド・ポテト" },
	{ N_MSG_FOOD_STEWED_BEEF,
		"ビーフ・シチュー" },
	{ N_MSG_FOOD_CONSOMME,
		"コンソメ・スープ" },
	{ N_MSG_FOOD_POTAGE,
		"ポタージュ" },
	{ N_MSG_FOOD_SOUP_OF_TURNIP,
		"かぶのスープ" },
	{ N_MSG_FOOD_APPLE_PIE,
		"アップル・パイ" },
	{ N_MSG_FOOD_APPLE,
		"りんご" },
	{ N_MSG_FOOD_GRAPE,
		"ぶどう" },
	{ N_MSG_FOOD_ORANGE,
		"オレンジ" },
	{ N_MSG_FOOD_PEAR,
		"梨" },
	{ N_MSG_FOOD_GRAPEFRUIT,
		"グレープフルーツ" },
	{ N_MSG_FOOD_PLUM,
		"プラム" },
	{ N_MSG_FOOD_PEACH,
		"桃" },
	{ N_MSG_FOOD_APRICOT,
		"アプリコット" },
	{ N_MSG_FOOD_BLACK_BERRY,
		"ブラックベリー" },
	{ N_MSG_FOOD_CRAN_BERRY,
		"クランベリー" },
	{ N_MSG_FOOD_RASP_BERRY,
		"ラズベリー" },
	{ N_MSG_FOOD_STRAW_BERRY,
		"ストロベリー" },

/* Chest */

	{ N_MSG_CHEST,
		"宝箱" },

/* Tobacco */

	{ N_MSG_TOBACCO_CIGARET,
		"紙巻タバコ" },
	{ N_MSG_TOBACCO_CIGAR,
		"葉巻" },
	{ N_MSG_TOBACCO_CUT_TOBACCO,
		"パイプ用刻みタバコ" },
	{ N_MSG_TOBACCO_SNUFF_TOBACCO,
		"かぎタバコ" },
	{ N_MSG_TOBACCO_CHEWING_TOBACCO,
		"噛みタバコ" },
	{ N_MSG_TOBACCO_ABSTAIN_GUM,
		"禁煙ガム" },

/* CIGARET */
	{ N_MSG_TOBACCO_BRAND_HELLO,
		"HELLO" },
	{ N_MSG_TOBACCO_BRAND_SUN_SHINE,
		"SUN SHINE" },
	{ N_MSG_TOBACCO_BRAND_CHERRY_TREE,
		"CHERRY TREE" },
	{ N_MSG_TOBACCO_BRAND_GOLDEN_RAT,
		"GOLDEN RAT" },
	{ N_MSG_TOBACCO_BRAND_AIR_SHIT,
		"AIR SHIT" },
	{ N_MSG_TOBACCO_BRAND_HOP,
		"HOP" },
	{ N_MSG_TOBACCO_BRAND_PIECE,
		"PIECE" },
	{ N_MSG_TOBACCO_BRAND_HARPY,
		"HARPY" },
	{ N_MSG_TOBACCO_BRAND_HIGH_LIGHT,
		"HIGH LIGHT" },
	{ N_MSG_TOBACCO_BRAND_SHOOTING_STARS,
		"SHOOTING STARS" },
	{ N_MSG_TOBACCO_BRAND_WILD_NINE,
		"WILD NINE" },
	{ N_MSG_TOBACCO_BRAND_WILD_NINE_MENTHOL,
		"WILD NINE MENTHOL" },
	{ N_MSG_TOBACCO_BRAND_LODGE,
		"LODGE" },
	{ N_MSG_TOBACCO_BRAND_LODGE_MENTHOL,
		"LODGE MENTHOL" },
	{ N_MSG_TOBACCO_BRAND_CANCER,
		"CANCER" },
	{ N_MSG_TOBACCO_BRAND_CANCER_MENTHOL,
		"CANCER MENTHOL" },
	{ N_MSG_TOBACCO_BRAND_FRONT_LINE,
		"FRONT LINE" },
	{ N_MSG_TOBACCO_BRAND_FRONT_LINE_MENTHOL,
		"FRONT LINE MENTHOL" },
	{ N_MSG_TOBACCO_BRAND_MARCO_POLO,
		"MARCO POLO" },
	{ N_MSG_TOBACCO_BRAND_CAMELLIA,
		"CAMELLIA" },
	{ N_MSG_TOBACCO_BRAND_GOOD_LUCK,
		"GOOD LUCK" },
	{ N_MSG_TOBACCO_BRAND_BAD_GUY,
		"BAD GUY" },

/* CIGAR */
	{ N_MSG_TOBACCO_BRAND_ARCADIA,
		"ARCADIA" },
	{ N_MSG_TOBACCO_BRAND_GLORIA,
		"GLORIA" },
	{ N_MSG_TOBACCO_BRAND_VULCAN,
		"VULCAN" },
	{ N_MSG_TOBACCO_BRAND_PONY,
		"PONY" },
	{ N_MSG_TOBACCO_BRAND_KEITH,
		"KEITH" },
	{ N_MSG_TOBACCO_BRAND_LUMBERJACK,
		"LUMBERJACK" },
	{ N_MSG_TOBACCO_BRAND_CORONA,
		"CORONA" },
	{ N_MSG_TOBACCO_BRAND_HALF_CORONA,
		"HALF CORONA" },
	{ N_MSG_TOBACCO_BRAND_CRYSTAL,
		"CRYSTAL" },

/* CUT TOBACCO */
	{ N_MSG_TOBACCO_BRAND_FOREST_BRANDY,
		"FOREST BRANDY" },
	{ N_MSG_TOBACCO_BRAND_SILK_ROAD,
		"SILK ROAD" },
	{ N_MSG_TOBACCO_BRAND_PROMENADE,
		"PROMENADE" },
	{ N_MSG_TOBACCO_BRAND_BIG_HORN,
		"BIG HORN" },
	{ N_MSG_TOBACCO_BRAND_ROCKING_CHAIR,
		"ROCKING CHAIR" },
	{ N_MSG_TOBACCO_BRAND_VANILLA,
		"VANILLA" },
	{ N_MSG_TOBACCO_BRAND_WILD_MANGO,
		"WILD MANGO" },
	{ N_MSG_TOBACCO_BRAND_KENTUCKY_BIRD,
		"KENTUCKY BIRD" },
	{ N_MSG_TOBACCO_BRAND_ORIENT,
		"ORIENT" },
	{ N_MSG_TOBACCO_BRAND_FUJI,
		"FUJI" },

/* SNUFF TOBACCO */
	{ N_MSG_TOBACCO_BRAND_DOGGY_APRICOT,
		"DOGGY APRICOT" },
	{ N_MSG_TOBACCO_BRAND_DOGGY_WHISKY,
		"DOGGY WHISKY" },
	{ N_MSG_TOBACCO_BRAND_DOGGY_HONEY,
		"DOGGY HONEY" },
	{ N_MSG_TOBACCO_BRAND_DOGGY_SPEARMINT,
		"DOGGY SPEARMINT" },
	{ N_MSG_TOBACCO_BRAND_DOGGY_PEPPERMINT,
		"DOGGY PEPPERMINT" },
	{ N_MSG_TOBACCO_BRAND_DOGGY_VANILLA,
		"DOGGY VANILLA" },
	{ N_MSG_TOBACCO_BRAND_DOGGY_MENTHOL,
		"DOGGY MENTHOL" },
	{ N_MSG_TOBACCO_BRAND_DOGGY_CITRUS,
		"DOGGY CITRUS" },
	{ N_MSG_TOBACCO_BRAND_DOGGY_SHERRY,
		"DOGGY SHERRY" },

/* CHEWING TOBACCO */
	{ N_MSG_TOBACCO_BRAND_ROSE_PREMIUM,
		"ROSE PREMIUM" },
	{ N_MSG_TOBACCO_BRAND_ROSE_VANILLA,
		"ROSE VANILLA" },
	{ N_MSG_TOBACCO_BRAND_ROSE_MENTHOL,
		"ROSE MENTHOL" },

/* ABSTAIN GUM */
	{ N_MSG_TOBACCO_BRAND_NICOTIME,
		"NICOTIME" },

/* STUB */
	{ N_MSG_TOBACCO_STUB,
		"タバコの吸い殻" },

/* PIPE */
	{ N_MSG_PIPE_PIPE,
		"パイプ" },
	{ N_MSG_PIPE_KISEL,
		"キセル" },
	{ N_MSG_PIPE_CIGARET_HOLDER,
		"紙巻タバコ用パイプ" },
	{ N_MSG_PIPE_STUB,
		"使用済みパイプ" },

	{ N_MSG_SMOKE_FAILURE,
		"パイプを装備して下さい" },

/* RARE_GOODS */
	{ N_MSG_RARE_GOODS_DAEMON_SCORE,
		"悪魔の楽譜" },
	{ N_MSG_RARE_GOODS_VAMPIRES_CROSS,
		"ヴァンパイアの十字架" },
	{ N_MSG_RARE_GOODS_SCHWARZSCHILD_DAEMON,
		"シュワルツシルトのデーモン" },
	{ N_MSG_RARE_GOODS_REASON_OF_DECLINE,
		"盛者必衰の理り" },
	{ N_MSG_RARE_GOODS_GARGOYLES_TEARS,
		"ガーゴイルの涙" },
	{ N_MSG_RARE_GOODS_FLUTE_OF_MADONNA,
		"聖母の横笛" },
	{ N_MSG_RARE_GOODS_THE_ART_OF_WAR,
		"天下泰平の兵法書" },
	{ N_MSG_RARE_GOODS_TICKET_TO_PARADISE,
		"楽園への切符" },
	{ N_MSG_RARE_GOODS_CALL_OF_HADES,
		"冥界からの呼び声" },
	{ N_MSG_RARE_GOODS_MEMORIES_OF_THE_GOLDEN_AGE,
		"黄金時代の記憶" },
	{ N_MSG_RARE_GOODS_ISNT_REALIZED,
		"届かない想い" },

/* GOLD */
	{ N_MSG_COIN_GOLD,
		STR_GOLD },
	{ N_MSG_COIN_SILVER,
		"銀貨" },
	{ N_MSG_COIN_COPPER,
		"銅貨" },

/* MISC */
	{ N_MSG_JUNK,
		"ゴミ屑" },

/**/

	{ N_MSG_TRGT,
		"目標" },

/* mbr act */

	{ N_MSG_UP_DUN,
		"階段を上った" },
	{ N_MSG_DOWN_DUN,
		"階段を下りた" },
	{ N_MSG_DOWN_DUN_LAST_BOSS,
		STR_LAST_STAGE "への階段を下りた" },
	{ N_MSG_UP_DOWN_DUN_FLOOR,
		"地上 %ld 階に着いた" },
	{ N_MSG_UP_DOWN_DUN_BASE,
		"地下 %ld 階に着いた" },
	{ N_MSG_UP_DOWN_DUN_GROUND,
		"街に着いた" },
	{ N_MSG_UP_DOWN_DUN_LAST_BOSS,
		STR_LAST_STAGE "に到達した" },
	{ N_MSG_FEEL_BOSS,
		"強敵の気配を感じる" },
	{ N_MSG_BOSS_FIND_MBR,
		"強敵 %s に見つかった！" },
	{ N_MSG_FEEL_LAST_BOSS,
		"これを下ると二度と戻れない気がする" },

	{ N_MSG_COLLECT_GOLD,
		"%s は " STR_GOLD_FMT " 集めた" },
	{ N_MSG_DIVIDE_GOLD,
		"各メンバーは " STR_GOLD_FMT " ずつ分けあった" },
	{ N_MSG_GIVE_GOLD,
		"%s は " STR_GOLD_FMT " を %s に渡した" },
	{ N_MSG_NOT_FRIEND_GOLD,
		"%s は" STR_GOLD "のやりとりを断わった" },

	{ N_MSG_GIVE_MBR_ITEM,
		"%s は %s を手に入れた" },
	{ N_MSG_DROP_MBR_ITEM,
		"%s は %s を落した" },

	{ N_MSG_STOMACH_FULL,
		"%s はお腹がいっぱいになった" },

	{ N_MSG_STEAL_ITEM_1,
		"%s は %s からアイテムを盗んだ" },
	{ N_MSG_STEAL_ITEM_2,
		"%s は %s を手に入れた" },
	{ N_MSG_STEAL_ITEM_FAILURE,
		"%s はアイテムを盗めなかった" },

	{ N_MSG_DOOR_OPEN,
		"%s はドアを開けた" },
	{ N_MSG_DOOR_CLOSE,
		"%s はドアを閉じた" },
	{ N_MSG_DOOR_JAM,
		"%s はドアを固定した" },
	{ N_MSG_DOOR_DISARM,
		"%s はドアの固定を" STR_DISARM "した" },
	{ N_MSG_DOOR_BREAK,
		"%s はドアを壊した" },
	{ N_MSG_DOOR_SRCH,
		"%s はドアを発見した" },

	{ N_MSG_CHK_DOOR_SHOP,
		"%s のドアだ" },
	{ N_MSG_CHK_DOOR_OPEN,
		"このドアは開いている" },
	{ N_MSG_CHK_DOOR_CLOSE,
		"このドアは閉じている" },
	{ N_MSG_CHK_DOOR_JAMMED,
		"このドアは固定されている" },
	{ N_MSG_CHK_DOOR_BROKEN,
		"このドアは壊れている" },

	{ N_MSG_TRAP_DISARM,
		"%s は罠を" STR_DISARM "した" },
	{ N_MSG_TRAP_BREAK,
		"%s は罠を壊した" },
	{ N_MSG_TRAP_SRCH,
		"%s は罠を発見した" },

	{ N_MSG_CHK_TRAP,
		"これは %s だ" },

	{ N_MSG_ITEM_PICK_UP,
		"%s は %s を拾った" },
	{ N_MSG_ITEM_OPEN,
		"%s は %s を開けた" },
	{ N_MSG_ITEM_DISARM,
		"%s は %s のカギを" STR_DISARM "した" },
	{ N_MSG_ITEM_DISARM_ALREADY,
		"%s のカギは既に開いている" },
	{ N_MSG_ITEM_BREAK,
		"%s は %s を壊した" },

	{ N_MSG_CHK_ITEM,
		"これは %s だ" },

	{ N_MSG_READY_THROW_CHEST,
		"%s は中に何か入っている" },

	{ N_MSG_DONT_EXHIBIT_ABL_EQUIP,
		"%s は装備のせいで %s の能力を発揮できない" },

	{ N_MSG_ERR_HP_SHORT,
		"%s は HP が %ld 足りない" },
	{ N_MSG_ERR_MP_SHORT,
		"%s は MP が %ld 足りない" },
	{ N_MSG_ERR_GOLD_SHORT,
		"%s は " STR_GOLD " が %ld 足りない" },
	{ N_MSG_ERR_RESI_SHORT,
		"%s は耐性値が %ld 足りない" },
	{ N_MSG_ERR_EXP_SHORT,
		"%s は経験値が %ld 足りない" },
	{ N_MSG_ERR_CONTRIBUTION_SHORT,
		"%s は寄付が %ld 足りない" },
	{ N_MSG_ERR_CONTRIBUTION_DAY,
		"%s の声は神に届かなかった" },

/* FX */

	{ N_MSG_FX_QUAFF_POTION,
		"%s は %s を飲んだ" },
	{ N_MSG_FX_READ_SCROLL,
		"%s は %s を読んだ" },
	{ N_MSG_FX_ZAP_STICK,
		"%s は %s を撃った" },
	{ N_MSG_RUB_LAMP,
		"%s は %s をこすった" },
	{ N_MSG_EAT_FOOD,
		"%s は %s を食べた" },
	{ N_MSG_MNSTR_CATCH_FOOD,
		"%s は餌に食いついた" },
	{ N_MSG_FILL_LAMP_OIL,
		"%s は %s に給油した" },

	{ N_MSG_FX_STONE,
		"%s は石になってしまった" },
	{ N_MSG_FX_PARALYZE,
		"%s は麻痺してしまった" },
	{ N_MSG_FX_POISON,
		"%s は毒に冒された" },
	{ N_MSG_FX_CONFUSION,
		"%s は混乱してしまった" },
	{ N_MSG_FX_BLIND,
		"%s は目が見えなくなってしまった" },
	{ N_MSG_FX_SLEEP,
		"%s は眠ってしまった" },
	{ N_MSG_FX_SILENCE,
		"%s は喋れなくなった" },
	{ N_MSG_FX_FEAR,
		"%s は恐怖に取りつかれた" },
	{ N_MSG_FX_HALLUCINATION,
		"%s は幻覚に襲われた" },
	{ N_MSG_FX_CHARM,
		"%s は魅了された" },
	{ N_MSG_FX_FLY,
		"%s は身体が浮かび上がった" },
	{ N_MSG_FX_FAINT,
		"%s はめまいがした" },
	{ N_MSG_FX_DRUNK,
		"%s は酔っぱらった" },
	{ N_MSG_FX_VANISH,
		"%s は身体が透明になった" },
	{ N_MSG_FX_IRON_BODY,
		"%s は身体が鋼鉄になった" },
	{ N_MSG_FX_PASSWALL,
		"%s は地面がやわらかく感じる" },
	{ N_MSG_FX_POLYMORPH,
		"%s は化け物と化した" },
	{ N_MSG_FX_SENSE_INVISIBLE,
		"%s は目が良くなった様だ" },
	{ N_MSG_FX_RESI_STAT,
		"%s には効かなかった" },

	{ N_MSG_FX_WEAK_HEAT,
		"%s は熱気につつまれた" },
	{ N_MSG_FX_WEAK_COLD,
		"%s は冷気につつまれた" },
	{ N_MSG_FX_WEAK_MIND,
		"%s は竜巻につつまれた" },
	{ N_MSG_FX_WEAK_ACID,
		"%s は酸につつまれた" },
	{ N_MSG_FX_WEAK_ELEC,
		"%s は稲光につつまれた" },
	{ N_MSG_FX_WEAK_POIS,
		"%s は毒につつまれた" },

	{ N_MSG_FX_RESI_PHYS,
		"%s は筋肉痛がとれた" },
	{ N_MSG_FX_RESI_HEAT,
		"%s は涼しくなった" },
	{ N_MSG_FX_RESI_COLD,
		"%s は暖かくなった" },
	{ N_MSG_FX_RESI_MIND,
		"%s は心地よい風を感じた" },
	{ N_MSG_FX_RESI_ACID,
		"%s は肌がスベスベになった" },
	{ N_MSG_FX_RESI_ELEC,
		"%s は静電気が消えた" },
	{ N_MSG_FX_RESI_POIS,
		"%s は気持ちが良くなった" },

	{ N_MSG_FX_SHARPNESS,
		"%s は身体が思い通りに動く" },
	{ N_MSG_FX_DULLNESS,
		"%s は身体が思い通りに動かない" },
	{ N_MSG_FX_STRENGTH,
		"%s は力がみなぎった" },
	{ N_MSG_FX_WEAKNESS,
		"%s は力が抜けた" },
	{ N_MSG_FX_QUICKNESS,
		"%s は身体が軽い" },
	{ N_MSG_FX_SLOWNESS,
		"%s は身体が重い" },
	{ N_MSG_FX_BRAINY,
		"%s は頭が良くなった" },
	{ N_MSG_FX_BRAINLESS,
		"%s は頭が悪くなってしまった" },
	{ N_MSG_FX_WISE,
		"%s は賢くなった" },
	{ N_MSG_FX_FOOLISH,
		"%s は愚かになってしまった" },
	{ N_MSG_FX_ATTRACTIVE,
		"%s は美しくなった" },
	{ N_MSG_FX_UNATTRACTIVE,
		"%s は醜くなってしまった" },

	{ N_MSG_FX_WATER,
		"%s は喉がうるおった" },
	{ N_MSG_FX_OIL,
		"これは油だ" },
	{ N_MSG_FX_CREATE_FOOD,
		"%s は %s を生成した" },
	{ N_MSG_FX_DETECT_MNSTR,
		"%s はモンスターの気配を感じた" },
	{ N_MSG_FX_DETECT_ITEM,
		"%s はアイテムの位置を感じた" },
	{ N_MSG_FX_POW_UP_HP,
		"%s はタフになった" },
	{ N_MSG_FX_MAGIC_SHIELD,
		"%s は腕に見えない盾が付いた様だ" },
	{ N_MSG_FX_MAGE_ARMOR,
		"%s は見えない鎧を着た様だ" },
	{ N_MSG_FX_COUNTER_MAGIC,
		"%s の周りを小さな鉄球が回り始めた" },
	{ N_MSG_FX_SUBSTITUTE,
		"%s は身代わりを仕込んだ" },
	{ N_MSG_FX_BURNING_HANDS,
		"%s の手が紅く燃え上がった" },
	{ N_MSG_FX_RALLY,
		"%s は巻き返しを図った" },
	{ N_MSG_FX_IRON_MAN,
		"%s は鉄人と化した" },
	{ N_MSG_FX_MIND_READING,
		"%s は敵の心が読める様になった" },
	{ N_MSG_FX_SPEED_UP,
		"%s は動きが速くなった" },
	{ N_MSG_FX_SPEED_DOWN,
		"%s は動きが遅くなった" },
	{ N_MSG_FX_TELEPORT_PARTY_CHARGE,
		"パーティ瞬間移動のチャージ中.." },
	{ N_MSG_FX_TELEPORT_PARTY,
		"周りの景色が急に変った" },
	{ N_MSG_FX_TELEPORT,
		"%s の周りの景色が急に変った" },
	{ N_MSG_FX_BLESS,
		"%s は救われた様な気持ちがした" },
	{ N_MSG_FX_STORE_LIGHT,
		"%s は口から光を吸い込んだ" },

	{ N_MSG_FX_SHELTER_ERR,
		"邪魔な物があってシェルターを造れません" },

	{ N_MSG_FX_RECALL,
		"帰還のチャージ中.." },
	{ N_MSG_FX_READ_SCROLL_NIN,
		"「この忍術の巻物を口にくわえて、集中し、念じろ」"
		"と書いてある"
	},
	{ N_MSG_FX_TOBACCO_ABSTAIN,
		"%s はタバコが吸いたくて、イライラする" },
	{ N_MSG_FX_SMOKE_TOBACCO,
		"健康のため吸い過ぎに注意しましょう" },
	{ N_MSG_FX_SMOKE_END,
		"%s はタバコを吸い終った" },
	{ N_MSG_FX_BREAK_PIPE,
		"%s の %s は使い終った" },

	{ N_MSG_FX_IDENTIFY_ITEM,
		"どのアイテムを識別しますか？ ([ESC]:キャンセル)" },
	{ N_MSG_FX_RECALL_ASK,
		"何階へ行きたいのか？" },

	{ N_MSG_FX_SLEEP_SUCCESS,
		"%s の周囲のモンスターが眠ってしまった" },
	{ N_MSG_FX_SLEEP_FAILURE,
		"%s は損をした様な気になった" },

	{ N_MSG_FX_POW_UP_WPN_HIT_SUCCESS,
		"%s の武器が当たり易くなった" },
	{ N_MSG_FX_POW_UP_WPN_HIT_FAILURE,
		"%s の両手が青く光った" },
	{ N_MSG_FX_POW_UP_WPN_CRTCL_SUCCESS,
		"%s の武器のクリティカルが出やすくなった" },
	{ N_MSG_FX_POW_UP_WPN_CRTCL_FAILURE,
		"%s の両手が青く光った" },
	{ N_MSG_FX_POW_UP_WPN_DAM_SUCCESS,
		"%s の武器のダメージが大きくなった" },
	{ N_MSG_FX_POW_UP_WPN_DAM_FAILURE,
		"%s の両手が青く光った" },

	{ N_MSG_FX_POW_UP_ARMOR_DEF_SUCCESS,
		"%s の防具が避け易くなった" },
	{ N_MSG_FX_POW_UP_ARMOR_DEF_FAILURE,
		"%s の身体が赤く光った" },
	{ N_MSG_FX_POW_UP_ARMOR_CRTCL_SUCCESS,
		"%s の防具のクリティカルが避け易くなった" },
	{ N_MSG_FX_POW_UP_ARMOR_CRTCL_FAILURE,
		"%s の身体が赤く光った" },
	{ N_MSG_FX_POW_UP_ARMOR_AC_SUCCESS,
		"%s の防具がダメージを減らす様になった" },
	{ N_MSG_FX_POW_UP_ARMOR_AC_FAILURE,
		"%s の身体が赤く光った" },

	{ N_MSG_FX_PROTECT_ARMOR_SUCCESS,
		"%s の防具が保護された" },
	{ N_MSG_FX_PROTECT_ARMOR_FAILURE,
		"%s は背中がムズムズする" },
	{ N_MSG_FX_BOOMERANG_SUCCESS,
		"%s の投げる物は戻ってくる様になった" },
	{ N_MSG_FX_BOOMERANG_FAILURE,
		"%s の両手が緑色に光った" },
	{ N_MSG_FX_REMOVE_CURSE_SUCCESS,
		"%s の呪いが解けた" },
	{ N_MSG_FX_REMOVE_CURSE_FAILURE,
		"%s は特に変わりはない" },

	{ N_MSG_FX_POW_DOWN_ARMOR,
		"%s の防具が溶けた" },
	{ N_MSG_FX_PROTECTED_ARMOR,
		"%s の防具は保護されている" },

	{ N_MSG_FX_SUMMON_MONSTER,
		"%s が召喚された" },
	{ N_MSG_FX_DISMISSAL,
		"%s は本来の次元に送還された" },
	{ N_MSG_FX_SUMMON_BONE_SEL_ERR,
		"%s は骨を持っていない" },

	{ N_MSG_FX_CURE_HP_LIGHT,
		"%s は傷が少し治った" },
	{ N_MSG_FX_CURE_HP_MODERATE,
		"%s は傷がだいぶ治った" },
	{ N_MSG_FX_CURE_HP_SERIOUS,
		"%s は傷がかなり治った" },
	{ N_MSG_FX_CURE_HP_MAX,
		"%s は傷が完全に治った" },
	{ N_MSG_FX_CURE_HP,
		"%s の体力が %ld 回復した" },
	{ N_MSG_FX_CURE_MP_MAX,
		"%s は魔力が完全に癒された" },
	{ N_MSG_FX_CURE_MP,
		"%s の魔力が %ld 回復した" },
	{ N_MSG_FX_TRANSFER_MP,
		"%s に魔力が %ld 転送された" },
	{ N_MSG_FX_CURE_LEV,
		"%s は昔を思い出した" },
	{ N_MSG_FX_CURE_EXP,
		"%s は記憶を取り戻した" },

	{ N_MSG_FX_RESURRECTION,
		"%s は生き返った" },
	{ N_MSG_FX_RESURRECTION_FAILURE,
		"%s は生き返られなかった" },
	{ N_MSG_FX_SAVE_LIFE,
		"%s の命は助かった" },

	{ N_MSG_FX_RUB_LAMP_SUCCESS,
		"%s から煙と共に魔神が出て来た" },
	{ N_MSG_FX_RUB_LAMP_FAILURE,
		"%s はピカピカになった" },

	{ N_MSG_TTL_MENU_WISH_ARMAGEDDON,
		"準備は良いか？" },
	{ N_MSG_TTL_MENU_WISH,
		"望みを選んで下さい" },
	{ N_MSG_TTL_MENU_WISH_ASK_CANCEL,
		"望みを取り下げますか？" },
	{ N_MSG_MENU_WISH_CURE_HP,
		"体力を回復して欲しい" },
	{ N_MSG_MENU_WISH_CURE_MP,
		"魔力を回復して欲しい" },
	{ N_MSG_MENU_WISH_RESURRECTION,
		"死者を復活して欲しい" },
	{ N_MSG_MENU_WISH_ARTIFACT,
		"強力なアイテムが欲しい" },

	{ N_MSG_GIVE_WISH_ARTIFACT_1,
		"%s はアーティファクトを手に入れた" },
	{ N_MSG_GIVE_WISH_ARTIFACT_2,
		"%s" },

	{ N_MSG_FX_WPN_RANDM_ART_DRAIN_HP,
		"%s は HP を %ld 吸収した" },
	{ N_MSG_FX_WPN_RANDM_ART_DRAIN_MP,
		"%s は MP を %ld 吸収した" },
	{ N_MSG_FX_WPN_RANDM_ART_DRAIN_EXP,
		"%s は EXP を %ld 吸収した" },

/* FX CLR */

	{ N_MSG_CLR_FX_STONE,
		"%s は生身の身体に戻った" },
	{ N_MSG_CLR_FX_PARALYZE,
		"%s はしびれが治った" },
	{ N_MSG_CLR_FX_POISON,
		"%s は吐き気が治まった" },
	{ N_MSG_CLR_FX_CONFUSION,
		"%s は混乱が治まった" },
	{ N_MSG_CLR_FX_BLIND,
		"%s は目が見える様になった" },
	{ N_MSG_CLR_FX_SLEEP,
		"%s は目が覚めた" },
	{ N_MSG_CLR_FX_SILENCE,
		"%s は喋れる様になった" },
	{ N_MSG_CLR_FX_FEAR,
		"%s は恐くなくなった" },
	{ N_MSG_CLR_FX_HALLUCINATION,
		"%s は幻覚がおさまった" },
	{ N_MSG_CLR_FX_CHARM,
		"%s は失恋した" },
	{ N_MSG_CLR_FX_FLY,
		"%s は着地した" },
	{ N_MSG_CLR_FX_DRUNK,
		"%s は酔いがさめた" },
	{ N_MSG_CLR_FX_VANISH,
		"%s は身体が見える様になった" },
	{ N_MSG_CLR_FX_IRON_BODY,
		"%s は身体が生身になった" },
	{ N_MSG_CLR_FX_PASSWALL,
		"%s は足もとがしっかりした" },
	{ N_MSG_CLR_FX_POLYMORPH,
		"%s は元の姿に戻った" },
	{ N_MSG_CLR_FX_SENSE_INVISIBLE,
		"%s は目が悪くなった様だ" },

	{ N_MSG_CLR_FX_WEAK_HEAT,
		"%s は熱気から逃れた" },
	{ N_MSG_CLR_FX_WEAK_COLD,
		"%s は冷気から逃れた" },
	{ N_MSG_CLR_FX_WEAK_MIND,
		"%s は竜巻から逃れた" },
	{ N_MSG_CLR_FX_WEAK_ACID,
		"%s は酸から逃れた" },
	{ N_MSG_CLR_FX_WEAK_ELEC,
		"%s は稲光から逃れた" },
	{ N_MSG_CLR_FX_WEAK_POIS,
		"%s は毒から逃れた" },

	{ N_MSG_CLR_FX_RESI_KNOC,
		"%s は節々が痛い" },
	{ N_MSG_CLR_FX_RESI_SLAS,
		"%s は節々が痛い" },
	{ N_MSG_CLR_FX_RESI_STIN,
		"%s は節々が痛い" },
	{ N_MSG_CLR_FX_RESI_HEAT,
		"%s は蒸し暑い" },
	{ N_MSG_CLR_FX_RESI_COLD,
		"%s は寒気がする" },
	{ N_MSG_CLR_FX_RESI_MIND,
		"%s は息苦しくなった" },
	{ N_MSG_CLR_FX_RESI_ACID,
		"%s は身体がヒリヒリする" },
	{ N_MSG_CLR_FX_RESI_ELEC,
		"%s は静電気がパチパチする" },
	{ N_MSG_CLR_FX_RESI_POIS,
		"%s は気持ちが悪くなった" },

	{ N_MSG_CLR_FX_SHARPNESS,
		"%s は身体が思い通りに動かない" },
	{ N_MSG_CLR_FX_DULLNESS,
		"%s は身体が思い通りに動く" },
	{ N_MSG_CLR_FX_STRENGTH,
		"%s は力が抜けた" },
	{ N_MSG_CLR_FX_WEAKNESS,
		"%s は力がみなぎった" },
	{ N_MSG_CLR_FX_QUICKNESS,
		"%s は身体が重い" },
	{ N_MSG_CLR_FX_SLOWNESS,
		"%s は身体が軽い" },
	{ N_MSG_CLR_FX_BRAINY,
		"%s は頭が悪くなってしまった" },
	{ N_MSG_CLR_FX_BRAINLESS,
		"%s は頭が良くなった" },
	{ N_MSG_CLR_FX_WISE,
		"%s は愚かになってしまった" },
	{ N_MSG_CLR_FX_FOOLISH,
		"%s は賢くなった" },
	{ N_MSG_CLR_FX_ATTRACTIVE,
		"%s は醜くなってしまった" },
	{ N_MSG_CLR_FX_UNATTRACTIVE,
		"%s は美しくなった" },

	{ N_MSG_CLR_FX_POW_UP_HP,
		"%s はひ弱になった" },
	{ N_MSG_CLR_FX_MAGIC_SHIELD,
		"%s は見えない盾が無くなった様だ" },
	{ N_MSG_CLR_FX_MAGE_ARMOR,
		"%s は見えない鎧を脱いだ様だ" },
	{ N_MSG_CLR_FX_COUNTER_MAGIC,
		"%s の周りの鉄球がどこかへ飛び去った" },
	{ N_MSG_CLR_FX_SUBSTITUTE,
		"%s の身代わりがバレた" },
	{ N_MSG_CLR_FX_BURNING_HANDS,
		"%s の手の炎が消えた" },
	{ N_MSG_CLR_FX_RALLY,
		"%s の巻き返しが終った" },
	{ N_MSG_CLR_FX_IRON_MAN,
		"%s は常人にもどった" },
	{ N_MSG_CLR_FX_MIND_READING,
		"%s は敵の心が読めなくなった" },
	{ N_MSG_CLR_FX_SPEED_UP,
		"%s は動きが遅くなった" },
	{ N_MSG_CLR_FX_SPEED_DOWN,
		"%s は動きが速くなった" },
	{ N_MSG_CLR_FX_BLESS,
		"%s は後悔した" },
	{ N_MSG_CLR_FX_STORE_LIGHT,
		"%s は溜め息が出た" },

/* 美味い飲み物 */

	{ N_MSG_FX_DRINK_A00,
		"これは美味い %s だ" },
	{ N_MSG_FX_DRINK_A01,
		"この %s は、のどごしが良い" },
	{ N_MSG_FX_DRINK_A02,
		"この %s は上品な香りがする" },
	{ N_MSG_FX_DRINK_A03,
		"この %s は上品な味がする" },
	{ N_MSG_FX_DRINK_A04,
		"この %s は後味が良い" },
	{ N_MSG_FX_DRINK_A05,
		"これはまろやかな %s だ" },

/* まずい飲み物 */

	{ N_MSG_FX_DRINK_B00,
		"これはまずい %s だ" },

/* 美味い食べ物 */

	{ N_MSG_FX_EAT_FOOD_A00,
		"これは美味い %s だ" },
	{ N_MSG_FX_EAT_FOOD_A01,
		"まったりとした %s だ" },
	{ N_MSG_FX_EAT_FOOD_A02,
		"こくがある %s だ" },
	{ N_MSG_FX_EAT_FOOD_A03,
		"あっさりとした %s だ" },
	{ N_MSG_FX_EAT_FOOD_A04,
		"こってりとした %s だ" },
	{ N_MSG_FX_EAT_FOOD_A05,
		"しつこくない味の %s だ" },
	{ N_MSG_FX_EAT_FOOD_A06,
		"これは深い味わいのある %s だ" },
	{ N_MSG_FX_EAT_FOOD_A07,
		"これは究極の %s だ" },
	{ N_MSG_FX_EAT_FOOD_A08,
		"これは至高の %s だ" },

/* まずい食べ物 */

	{ N_MSG_FX_EAT_FOOD_B00,
		"これはまずい %s だ" },
	{ N_MSG_FX_EAT_FOOD_B01,
		"この %s は、しつこいお味だ" },
	{ N_MSG_FX_EAT_FOOD_B02,
		"なんだこの %s は！ 料理長を呼べ！" },

/**/

	{ N_MSG_FX_PICK_GOLD,
		"%s は %s の財布をすった" },

/* モンスター */

/* モンスターの系統 */
	{ N_MSG_MNSTR_MJR_NAME_UNKNOWN,
		"正体不明" },
	{ N_MSG_MNSTR_MJR_NAME_GOD,
		"神" },
	{ N_MSG_MNSTR_MJR_NAME_DRAGON,
		"龍" },
	{ N_MSG_MNSTR_MJR_NAME_ILLUSORY,
		"幻獣" },
	{ N_MSG_MNSTR_MJR_NAME_FAIRY,
		"妖精" },
	{ N_MSG_MNSTR_MJR_NAME_ELEMENTAL,
		"精霊" },
	{ N_MSG_MNSTR_MJR_NAME_PLANT,
		"植物" },
	{ N_MSG_MNSTR_MJR_NAME_ANIMAL,
		"動物" },
	{ N_MSG_MNSTR_MJR_NAME_INSECT,
		"昆虫" },
	{ N_MSG_MNSTR_MJR_NAME_HUMAN,
		"人間" },
	{ N_MSG_MNSTR_MJR_NAME_HYBRID,
		"半人" },
	{ N_MSG_MNSTR_MJR_NAME_GIANT,
		"巨人" },
	{ N_MSG_MNSTR_MJR_NAME_HUGE,
		"巨大生物" },
	{ N_MSG_MNSTR_MJR_NAME_AQUATIC,
		"水棲生物" },
	{ N_MSG_MNSTR_MJR_NAME_MAGICAL,
		"魔法生物" },
	{ N_MSG_MNSTR_MJR_NAME_COMPOUND,
		"合成獣" },
	{ N_MSG_MNSTR_MJR_NAME_UNDEAD,
		"不死者" },
	{ N_MSG_MNSTR_MJR_NAME_EVIL,
		"妖魔" },
	{ N_MSG_MNSTR_MJR_NAME_EVIL_BEAST,
		"魔獣" },
	{ N_MSG_MNSTR_MJR_NAME_DEVIL,
		"悪魔" },
	{ N_MSG_MNSTR_MJR_NAME_BOSS,
		"ボス" },

/* 正体不明 */
	{ N_MSG_MNSTR_UNKNOWN,
		"正体不明のモンスター" },
/* 神 */
/* ドラゴン */
	{ N_MSG_MNSTR_A_GOLD_DRAGON,
		"エンシェント・ゴールド・ドラゴン" },
	{ N_MSG_MNSTR_A_SILVER_DRAGON,
		"エンシェント・シルバー・ドラゴン" },
	{ N_MSG_MNSTR_A_COPPER_DRAGON,
		"エンシェント・カッパー・ドラゴン" },
	{ N_MSG_MNSTR_A_RED_DRAGON,
		"エンシェント・レッド・ドラゴン" },
	{ N_MSG_MNSTR_A_BLUE_DRAGON,
		"エンシェント・ブルー・ドラゴン" },
	{ N_MSG_MNSTR_A_YELLOW_DRAGON,
		"エンシェント・イエロー・ドラゴン" },
	{ N_MSG_MNSTR_A_GREEN_DRAGON,
		"エンシェント・グリーン・ドラゴン" },
	{ N_MSG_MNSTR_A_WHITE_DRAGON,
		"エンシェント・ホワイト・ドラゴン" },
	{ N_MSG_MNSTR_A_BLACK_DRAGON,
		"エンシェント・ブラック・ドラゴン" },
	{ N_MSG_MNSTR_M_GOLD_DRAGON,
		"マイナー・ゴールド・ドラゴン" },
	{ N_MSG_MNSTR_M_SILVER_DRAGON,
		"マイナー・シルバー・ドラゴン" },
	{ N_MSG_MNSTR_M_COPPER_DRAGON,
		"マイナー・カッパー・ドラゴン" },
	{ N_MSG_MNSTR_M_RED_DRAGON,
		"マイナー・レッド・ドラゴン" },
	{ N_MSG_MNSTR_M_BLUE_DRAGON,
		"マイナー・ブルー・ドラゴン" },
	{ N_MSG_MNSTR_M_YELLOW_DRAGON,
		"マイナー・イエロー・ドラゴン" },
	{ N_MSG_MNSTR_M_GREEN_DRAGON,
		"マイナー・グリーン・ドラゴン" },
	{ N_MSG_MNSTR_M_WHITE_DRAGON,
		"マイナー・ホワイト・ドラゴン" },
	{ N_MSG_MNSTR_M_BLACK_DRAGON,
		"マイナー・ブラック・ドラゴン" },
/* 幻獣 */
	{ N_MSG_MNSTR_PHOENIX,
		"フェニックス" },
	{ N_MSG_MNSTR_UNICORN,
		"ユニコーン" },
/* 妖精 */
	{ N_MSG_MNSTR_LEPRECHAUN,
		"レプラコーン" },
/* 精霊 */
	{ N_MSG_MNSTR_FIRE_ELEMENTAL,
		"ファイアー・エレメンタル" },
	{ N_MSG_MNSTR_SALAMANDER,
		"サラマンダー" },
	{ N_MSG_MNSTR_WATER_ELEMENTAL,
		"ウォーター・エレメンタル" },
	{ N_MSG_MNSTR_UNDINE,
		"ウンディーネ" },
	{ N_MSG_MNSTR_AIR_ELEMENTAL,
		"エアー・エレメンタル" },
	{ N_MSG_MNSTR_SYLPH,
		"シルフ" },
	{ N_MSG_MNSTR_EARTH_ELEMENTAL,
		"アース・エレメンタル" },
	{ N_MSG_MNSTR_GNOME,
		"ノーム" },
	{ N_MSG_MNSTR_WILL_O_WISP,
		"ウィル・オー・ウィスプ" },
	{ N_MSG_MNSTR_SHADE,
		"シェイド" },
/* 植物 */
	{ N_MSG_MNSTR_VENUS_FLY_TRAP,
		"ヴィーナス・フライ・トラップ" },
	{ N_MSG_MNSTR_SLIME,
		"スライム" },
	{ N_MSG_MNSTR_SPORE,
		"スポア" },
/* 動物 */
	{ N_MSG_MNSTR_GIANT_BAT,
		"ジャイアント・バット" },
	{ N_MSG_MNSTR_GIANT_RAT,
		"ジャイアント・ラット" },
	{ N_MSG_MNSTR_GIANT_SNAKE,
		"ジャイアント・スネーク" },
	{ N_MSG_MNSTR_VIPER_SNAKE,
		"ヴァイパー・スネーク" },
	{ N_MSG_MNSTR_CAT,
		"キャット" },
	{ N_MSG_MNSTR_DOG,
		"ドッグ" },
	{ N_MSG_MNSTR_WOLF,
		"ウルフ" },
	{ N_MSG_MNSTR_PYON_PYON,
		"ピョンピョン" },
/* 昆虫 */
	{ N_MSG_MNSTR_GIANT_CENTIPEDE,
		"ジャイアント・センティピード" },
	{ N_MSG_MNSTR_GIANT_BEE,
		"ジャイアント・ビー" },
	{ N_MSG_MNSTR_ACID_FLY,
		"アシッド・フライ" },
	{ N_MSG_MNSTR_GIANT_SCORPION,
		"ジャイアント・スコーピオン" },
	{ N_MSG_MNSTR_GIANT_ANT,
		"ジャイアント・アント" },
	{ N_MSG_MNSTR_GIANT_SPIDER,
		"ジャイアント・スパイダー" },
	{ N_MSG_MNSTR_GIANT_BEETLE,
		"ジャイアント・ビートル" },
/* 人間 */
	{ N_MSG_MNSTR_FIGHTER,
		"戦士" },
	{ N_MSG_MNSTR_MONK,
		"武闘家" },
	{ N_MSG_MNSTR_HUNTER,
		"狩人" },
	{ N_MSG_MNSTR_THIEF,
		"盗賊" },
	{ N_MSG_MNSTR_WIZARD,
		"魔術師" },
	{ N_MSG_MNSTR_SUMMONER,
		"召喚師" },
	{ N_MSG_MNSTR_PRIEST,
		"僧侶" },
	{ N_MSG_MNSTR_SHAMAN,
		"精霊使い" },
	{ N_MSG_MNSTR_BARD,
		"吟遊詩人" },
	{ N_MSG_MNSTR_NINJA,
		"忍者" },
	{ N_MSG_MNSTR_BISHOP,
		"賢者" },
	{ N_MSG_MNSTR_FARMER,
		"農夫" },
	{ N_MSG_MNSTR_CRAFTSMAN,
		"職人" },
	{ N_MSG_MNSTR_MERCHANT,
		"商人" },
/* 半人 */
	{ N_MSG_MNSTR_HARPY,
		"ハーピー" },
	{ N_MSG_MNSTR_ANDRO_SCORPION,
		"アンドロ・スコーピオン" },
	{ N_MSG_MNSTR_LAMIA,
		"ラミア" },
	{ N_MSG_MNSTR_CENTAUR,
		"ケンタウロス" },
	{ N_MSG_MNSTR_BIRD_MAN,
		"バードマン" },
	{ N_MSG_MNSTR_WEREWOLF,
		"ワー・ウルフ" },
	{ N_MSG_MNSTR_MINOTAUR,
		"ミノタウロス" },
	{ N_MSG_MNSTR_MEDUSA,
		"メデューサ" },
/* 巨人 */
	{ N_MSG_MNSTR_YETI,
		"イェティ" },
	{ N_MSG_MNSTR_OGRE,
		"オーガ" },
	{ N_MSG_MNSTR_TROLL,
		"トロール" },
	{ N_MSG_MNSTR_MORMIN_TROLL,
		"モーミン・トロール" },
	{ N_MSG_MNSTR_FIRE_GIANT,
		"ファイアー・ジャイアント" },
	{ N_MSG_MNSTR_FROST_GIANT,
		"フロスト・ジャイアント" },
	{ N_MSG_MNSTR_CLOUD_GIANT,
		"クラウド・ジャイアント" },
	{ N_MSG_MNSTR_MOUNTAIN_GIANT,
		"マウンテン・ジャイアント" },
	{ N_MSG_MNSTR_CYCLOPS,
		"サイクロプス" },
/* 巨大生物 */
/* 水棲生物 */
/* 魔法生物 */
	{ N_MSG_MNSTR_INVISIBLE_STALKER,
		"インヴィジブル・ストーカー" },
	{ N_MSG_MNSTR_GARGOYLE,
		"ガーゴイル" },
	{ N_MSG_MNSTR_MIMIC,
		"ミミック" },
	{ N_MSG_MNSTR_WOOD_GOLEM,
		"ウッド・ゴーレム" },
	{ N_MSG_MNSTR_BONE_GOLEM,
		"ボーン・ゴーレム" },
	{ N_MSG_MNSTR_FLESH_GOLEM,
		"フレッシュ・ゴーレム" },
	{ N_MSG_MNSTR_STONE_GOLEM,
		"ストーン・ゴーレム" },
	{ N_MSG_MNSTR_IRON_GOLEM,
		"アイアン・ゴーレム" },
	{ N_MSG_MNSTR_GAS_CLOUD,
		"ガス・クラウド" },
/* 合成獣 */
	{ N_MSG_MNSTR_HIPPOGRIFF,
		"ヒポグリフ" },
	{ N_MSG_MNSTR_GRIFFON,
		"グリフォン" },
	{ N_MSG_MNSTR_MANTICORE,
		"マンティコア" },
	{ N_MSG_MNSTR_CHIMERA,
		"キマイラ" },
/* アンデッド */
	{ N_MSG_MNSTR_POLTERGEIST,
		"ポルターガイスト" },
	{ N_MSG_MNSTR_SKELETON,
		"スケルトン" },
	{ N_MSG_MNSTR_ZOMBIE,
		"ゾンビ" },
	{ N_MSG_MNSTR_GHOUL,
		"グール" },
	{ N_MSG_MNSTR_GHOST,
		"ゴースト" },
	{ N_MSG_MNSTR_WIGHT,
		"ワイト" },
	{ N_MSG_MNSTR_MUMMY,
		"マミー" },
	{ N_MSG_MNSTR_DURAHAN,
		"デュラハン" },
	{ N_MSG_MNSTR_BANSHEE,
		"バンシー" },
	{ N_MSG_MNSTR_WRAITH,
		"レイス" },
	{ N_MSG_MNSTR_VAMPIRE,
		"ヴァンパイア" },
	{ N_MSG_MNSTR_SPIRIT,
		"スピリット" },
/* 妖魔 */
	{ N_MSG_MNSTR_KOBOLD,
		"コボルド" },
	{ N_MSG_MNSTR_GOBLIN,
		"ゴブリン" },
	{ N_MSG_MNSTR_GREMLIN,
		"グレムリン" },
	{ N_MSG_MNSTR_HOBGOBLIN,
		"ホブゴブリン" },
	{ N_MSG_MNSTR_ORK,
		"オーク" },
	{ N_MSG_MNSTR_GNOLL,
		"ノール" },
	{ N_MSG_MNSTR_INCUBUS,
		"インキュバス" },
	{ N_MSG_MNSTR_SUCCUBUS,
		"サキュバス" },
	{ N_MSG_MNSTR_EFREET,
		"イフリート" },
	{ N_MSG_MNSTR_DJINNI,
		"ジン" },
/* 魔獣 */
	{ N_MSG_MNSTR_RUST_MONSTER,
		"ラスト・モンスター" },
	{ N_MSG_MNSTR_HELLHOUND,
		"ヘル・ハウンド" },
	{ N_MSG_MNSTR_HYDRA,
		"ヒドラ" },
	{ N_MSG_MNSTR_COCKATRICE,
		"コカトリス" },
	{ N_MSG_MNSTR_WYVERN,
		"ワイバーン" },
	{ N_MSG_MNSTR_CERBERUS,
		"ケルベロス" },
	{ N_MSG_MNSTR_GORGON,
		"ゴルゴン" },
	{ N_MSG_MNSTR_BASILISK,
		"バジリスク" },
/* 悪魔 */
	{ N_MSG_MNSTR_IMP,
		"インプ" },
	{ N_MSG_MNSTR_JACK_O_LANTERN,
		"ジャック・オー・ランタン" },
	{ N_MSG_MNSTR_LESSER_DAEMON,
		"レッサー・デーモン" },
	{ N_MSG_MNSTR_GREATER_DAEMON,
		"グレーター・デーモン" },
/* 中ボス */
	{ N_MSG_MNSTR_HIGH_RE_HOO,
		"ハイ・リ・ホー" },
	{ N_MSG_MNSTR_GREAT_MINOTAUR,
		"グレート・ミノタウロス" },
	{ N_MSG_MNSTR_BILLION_ELEMENTAL,
		"ビリオン・エレメンタル" },
	{ N_MSG_MNSTR_CYBERN,
		"サイバーン" },
	{ N_MSG_MNSTR_GIGANTIC_CENTIPEDE,
		"ジャイガンティック・センティピード" },
	{ N_MSG_MNSTR_MEDUSA_ZOMBIE,
		"メデューサ・ゾンビ" },
	{ N_MSG_MNSTR_BLACK_UNICORN,
		"ブラック・ユニコーン" },
	{ N_MSG_MNSTR_VAMPIRE_LORD,
		"ヴァンパイア・ロード" },
	{ N_MSG_MNSTR_RELATIVISTIC_DAEMON,
		"リラティビスティック・デーモン" },
	{ N_MSG_MNSTR_ETERNAL_DRAGON,
		"エターナル・ドラゴン" },
/* ラスボス */
	{ N_MSG_MNSTR_EXEL,
		"エクセル" },
	{ N_MSG_MNSTR_EXELER,
		"エクセラー" },
	{ N_MSG_MNSTR_XEX,
		"ゼクス" },
	{ N_MSG_MNSTR_XX,
		"トゥエニィース" },
/**/
	{ N_MSG_MBR_FIND_INVISIBLE,
		"待て！それは %s だ！！" },
	{ N_MSG_MNSTR_DISAPPEAR,
		"%s は、姿をくらました" },

/* trap */

	{ N_MSG_TRAP_SLEEP,
		"眠りの罠" },
	{ N_MSG_TRAP_ARW,
		"弓矢の罠" },
	{ N_MSG_TRAP_POISON_DARTS,
		"毒ダーツの罠" },
	{ N_MSG_TRAP_BOMB,
		"爆弾の罠" },
	{ N_MSG_TRAP_TELEPORT_PARTY,
		"パーティ瞬間移動の罠" },
	{ N_MSG_TRAP_TELEPORT,
		"瞬間移動の罠" },
	{ N_MSG_TRAP_PIT,
		"落し穴" },
	{ N_MSG_TRAP_CHUTE,
		"シュート" },
	{ N_MSG_TRAP_SANCTUARY,
		"聖域" },

	{ N_MSG_TRAPPED,
		"%s は %s にかかった" },
	{ N_MSG_NOT_TRAPPED,
		"%s は罠を作動させなかった" },

/* spell begin */

	{ N_MSG_MAG,
		STR_MAG },
	{ N_MSG_SOR,
		STR_SOR },
	{ N_MSG_ENC,
		STR_ENC },
	{ N_MSG_SUM,
		STR_SUM },

	{ N_MSG_PRI,
		STR_PRI },
	{ N_MSG_SHA,
		STR_SHA },
	{ N_MSG_BAR,
		STR_BAR },
	{ N_MSG_NIN,
		STR_NIN },

	{ N_MSG_MAG_MISC,
		STR_MAG " - 一般" },
	{ N_MSG_MAG_DETECT,
		STR_MAG " - 探知" },
	{ N_MSG_MAG_CHANGE_STAT,
		STR_MAG " - 状態変化" },
	{ N_MSG_MAG_CHANGE_SPECIAL,
		STR_MAG " - 特殊変化" },
	{ N_MSG_SOR_ATTACK,
		STR_SOR " - 攻撃" },
	{ N_MSG_SOR_DEFENSE,
		STR_SOR " - 防御" },
	{ N_MSG_SOR_WEAKEN_STAT,
		STR_SOR " - 状態異常" },
	{ N_MSG_ENC_STRENGTHEN_ABL,
		STR_ENC " - 能力値強化" },
	{ N_MSG_ENC_STRENGTHEN_MISC,
		STR_ENC " - 強化" },
	{ N_MSG_ENC_WEAKEN_ABL,
		STR_ENC " - 能力値弱体" },
	{ N_MSG_ENC_WEAKEN_MISC,
		STR_ENC " - 弱体" },
	{ N_MSG_SUM_SUMMON,
		STR_SUM " - 召喚" },
	{ N_MSG_PRI_CURE,
		STR_PRI " - 回復" },
	{ N_MSG_PRI_CURE_STAT,
		STR_PRI " - 状態回復" },
	{ N_MSG_PRI_RESIST,
		STR_PRI " - 抵抗" },
	{ N_MSG_PRI_HOLY,
		STR_PRI " - 神聖" },
	{ N_MSG_SHA_WEAK,
		STR_SHA " - 攻撃" },
	{ N_MSG_SHA_SUMMON,
		STR_SHA " - 召喚" },
	{ N_MSG_BAR_CURE,
		STR_BAR " - 回復" },
	{ N_MSG_BAR_STRENGTHEN_ABL,
		STR_BAR " - 能力値強化" },
	{ N_MSG_BAR_WEAKEN_ABL,
		STR_BAR " - 能力値弱体" },
	{ N_MSG_BAR_RESI_STAT,
		STR_BAR " - 状態抵抗" },
	{ N_MSG_NIN_DISASTER,
		STR_NIN " - 天変地異" },
	{ N_MSG_NIN_MISC,
		STR_NIN " - 体術" },

	{ N_MSG_ERR_SPELL,
		"%s は呪文が使えない" },
	{ N_MSG_SPELL_NO_LEARN,
		"無し" },
	{ N_MSG_CAN_NOT_LEARN_SPELL,
		"%s は %s の呪文をまだおぼえられない" },
	{ N_MSG_LEARN_SPELL,
		"%s は %s の呪文をおぼえた" },
	{ N_MSG_FORGET_SPELL,
		"%s は %s の呪文を忘れた" },
	{ N_MSG_ERR_SPELL_NIN_LEARNED,
		"%s の忍術はおぼえられません。内部データが異常です" },

/* [基本魔法] */

/* 一般 */

	{ N_MSG_SPELL_LIGHT,
		"明り" },
	{ N_MSG_SPELL_DARKNESS,
		"暗闇" },
	{ N_MSG_SPELL_STORE_LIGHT,
		"明りを貯める" },
	{ N_MSG_SPELL_KNOCK,
		"解錠" },
	{ N_MSG_SPELL_LOCK,
		"施錠" },
	{ N_MSG_SPELL_DISARM_TRAP,
		"罠解除" },
	{ N_MSG_SPELL_DISPEL_MAGIC,
		"魔法解呪" },
	{ N_MSG_SPELL_TELEPORT_PARTY,
		"パーティ瞬間移動" },
	{ N_MSG_SPELL_TELEPORT,
		"瞬間移動" },
	{ N_MSG_SPELL_RECALL,
		"帰還" },
	{ N_MSG_SPELL_MIRROR_IMAGE,
		"鏡像" },
	{ N_MSG_SPELL_ANIMATE_OBJECTS,
		"物体操り" },
	{ N_MSG_SPELL_SHELTER,
		"シェルター" },
	{ N_MSG_SPELL_CREATE_FOOD,
		"食料生成" },

/* 探知 */

	{ N_MSG_SPELL_IDENTIFY_ITEM,
		"アイテム識別" },
	{ N_MSG_SPELL_IDENTIFY_ALL_ITEM,
		"全アイテム識別" },
	{ N_MSG_SPELL_SEARCHING,
		"探索" },
	{ N_MSG_SPELL_ANALYZE_DWEOMER,
		"魔力分析" },
	{ N_MSG_SPELL_DETECT_ITEM,
		"アイテム探知" },
	{ N_MSG_SPELL_DETECT_DOORS,
		"ドア探知" },
	{ N_MSG_SPELL_DETECT_TRAPS,
		"罠探知" },
	{ N_MSG_SPELL_DETECT_MAGIC,
		"魔法感知" },
	{ N_MSG_SPELL_DETECT_MONSTER,
		"モンスター感知" },
	{ N_MSG_SPELL_SENSE_INVISIBLE,
		"不可視感知" },

/* 状態変化 */

	{ N_MSG_SPELL_FLY,
		"空中浮遊" },
	{ N_MSG_SPELL_FEATHER_FALL,
		"軟着陸" },
	{ N_MSG_SPELL_VANISH,
		"不可視" },
	{ N_MSG_SPELL_DARKVISION,
		"暗視" },
	{ N_MSG_SPELL_PASSWALL,
		"壁抜け" },
	{ N_MSG_SPELL_POLYMORPH_OTHER,
		"他者変身" },
	{ N_MSG_SPELL_POLYMORPH_SELF,
		"自己変身" },
	{ N_MSG_SPELL_STEALTH,
		"隠密" },

/* [戦闘魔法] */

/* 攻撃 */

	{ N_MSG_SPELL_MAGIC_MISSILE,
		"魔法のミサイル" },
	{ N_MSG_SPELL_FIRE_BALL,
		"火の球" },
	{ N_MSG_SPELL_ICE_BLIZZARD,
		"氷の吹雪" },
	{ N_MSG_SPELL_MIND_STORM,
		"精神の嵐" },
	{ N_MSG_SPELL_ACID_RAIN,
		"酸の雨" },
	{ N_MSG_SPELL_LIGHTNING_BOLT,
		"電撃の矢" },
	{ N_MSG_SPELL_POISON_CLOUD,
		"毒の雲" },
	{ N_MSG_SPELL_DEATH_SPELL,
		"死の呪い" },
	{ N_MSG_SPELL_WORD_OF_DESTRUCTION,
		"破壊" },

/* 防御 */

	{ N_MSG_SPELL_MAGIC_SHIELD,
		"魔法の盾" },
	{ N_MSG_SPELL_MAGE_ARMOR,
		"魔法の鎧" },
	{ N_MSG_SPELL_STONESKIN,
		"石の皮膚" },
	{ N_MSG_SPELL_IRON_BODY,
		"鋼鉄の身体" },
	{ N_MSG_SPELL_SPELL_RESISTANCE,
		"呪文抵抗" },
	{ N_MSG_SPELL_COUNTER_MAGIC,
		"呪文反射" },

/* 状態異常 */

	{ N_MSG_SPELL_STONE,
		"石化" },
	{ N_MSG_SPELL_PARALYZE,
		"麻痺" },
	{ N_MSG_SPELL_POISON,
		"毒" },
	{ N_MSG_SPELL_CONFUSION,
		"混乱" },
	{ N_MSG_SPELL_BLINDNESS,
		"盲目" },
	{ N_MSG_SPELL_SLEEP,
		"睡眠" },
	{ N_MSG_SPELL_SILENCE,
		"沈黙" },
	{ N_MSG_SPELL_FEAR,
		"恐怖" },
	{ N_MSG_SPELL_HALLUCINATION,
		"幻覚" },
	{ N_MSG_SPELL_CHARM,
		"魅了" },

/* [援護魔法] */

/* 能力値強化 */

	{ N_MSG_SPELL_SHARPNESS,
		"器用度増強" },
	{ N_MSG_SPELL_STRENGTH,
		"筋力度増強" },
	{ N_MSG_SPELL_QUICKNESS,
		"敏捷度増強" },
	{ N_MSG_SPELL_BRAINY,
		"知力増強" },
	{ N_MSG_SPELL_WISE,
		"判断力増強" },
	{ N_MSG_SPELL_ATTRACTIVE,
		"魅力増強" },

/* 強化 */

	{ N_MSG_SPELL_POWER_UP_HP,
		"体力増強" },
	{ N_MSG_SPELL_HASTE,
		"加速" },

/* 能力値弱体 */

	{ N_MSG_SPELL_DULLNESS,
		"器用度減退" },
	{ N_MSG_SPELL_WEAKNESS,
		"筋力度減退" },
	{ N_MSG_SPELL_SLOWNESS,
		"敏捷度減退" },
	{ N_MSG_SPELL_BRAINLESS,
		"知力減退" },
	{ N_MSG_SPELL_FOOLISH,
		"判断力減退" },
	{ N_MSG_SPELL_UNATTRACTIVE,
		"魅力減退" },

/* 弱体 */

	{ N_MSG_SPELL_ENERGY_DRAIN,
		"生命力吸収" },
	{ N_MSG_SPELL_SLOW,
		"減速" },
	{ N_MSG_SPELL_HUNGER,
		"飢餓" },
	{ N_MSG_SPELL_CANCELLATION,
		"特殊能力封じ" },

/* [召喚魔法] */

/* 召喚 */
	{ N_MSG_SPELL_SKELETON_WARRIOR,
		"スケルトン召喚" },
	{ N_MSG_SPELL_SUMMON_UNICORN,
		"ユニコーン召喚" },
	{ N_MSG_SPELL_SUMMON_EFREET,
		"イフリート召喚" },
	{ N_MSG_SPELL_SUMMON_DJINNI,
		"ジン召喚" },
	{ N_MSG_SPELL_SUMMON_PHOENIX,
		"フェニックス召喚" },
	{ N_MSG_SPELL_SUMMON_BONE,
		"骨からの召喚" },
	{ N_MSG_SPELL_SUMMON_RANDOM,
		"ランダム召喚" },
	{ N_MSG_SPELL_CREATE_UNDEAD,
		"アンデッド創造" },
	{ N_MSG_SPELL_DISMISSAL,
		"送還" },

/* [祈り] */

/* 回復 */

	{ N_MSG_SPELL_CURE_HP_LIGHT,
		"体力小回復" },
	{ N_MSG_SPELL_CURE_HP_MODERATE,
		"体力中回復" },
	{ N_MSG_SPELL_CURE_HP_SERIOUS,
		"体力大回復" },
	{ N_MSG_SPELL_CURE_HP_MAX,
		"体力全回復" },
	{ N_MSG_SPELL_CURE_MP,
		"魔力回復" },
	{ N_MSG_SPELL_TRANSFER_MP,
		"魔力転送" },
	{ N_MSG_SPELL_REGENERATION,
		"再生" },
	{ N_MSG_SPELL_RESTORE_EXPERIENCE,
		"経験値回復" },
	{ N_MSG_SPELL_RESURRECTION,
		"蘇生" },
	{ N_MSG_SPELL_HEAL,
		"完全回復" },

/* 状態回復 */

	{ N_MSG_SPELL_CURE_STATUS,
		"状態回復" },

	{ N_MSG_SPELL_CURE_STONE,
		"石化回復" },
	{ N_MSG_SPELL_CURE_PARALYZE,
		"麻痺回復" },
	{ N_MSG_SPELL_CURE_POISON,
		"毒回復" },
	{ N_MSG_SPELL_CURE_CONFUSION,
		"混乱回復" },
	{ N_MSG_SPELL_CURE_BLINDNESS,
		"盲目回復" },
	{ N_MSG_SPELL_CURE_SLEEP,
		"睡眠回復" },
	{ N_MSG_SPELL_CURE_SILENCE,
		"沈黙回復" },
	{ N_MSG_SPELL_CURE_FEAR,
		"恐怖回復" },
	{ N_MSG_SPELL_CURE_HALLUCINATION,
		"幻覚回復" },
	{ N_MSG_SPELL_CURE_CHARM,
		"魅了回復" },

/* 抵抗 */

	{ N_MSG_SPELL_PROTECTION,
		"防御" },
	{ N_MSG_SPELL_RESIST_PHYSICAL,
		"物理抵抗" },
	{ N_MSG_SPELL_RESIST_HEAT,
		"火熱抵抗" },
	{ N_MSG_SPELL_RESIST_COLD,
		"水冷抵抗" },
	{ N_MSG_SPELL_RESIST_MIND,
		"風心抵抗" },
	{ N_MSG_SPELL_RESIST_ACID,
		"土酸抵抗" },
	{ N_MSG_SPELL_RESIST_ELECTRICITY,
		"光雷抵抗" },
	{ N_MSG_SPELL_RESIST_POISON,
		"闇毒抵抗" },

/* 神聖 */

	{ N_MSG_SPELL_BLESS,
		"祝福" },
	{ N_MSG_SPELL_REMOVE_CURSE,
		"呪い除去" },
	{ N_MSG_SPELL_DISPEL_UNDEAD,
		"不死者退散" },
	{ N_MSG_SPELL_ESCAPE,
		"脱出" },
	{ N_MSG_SPELL_SANCTUARY,
		"聖域" },
	{ N_MSG_SPELL_WISH,
		"望み" },

/* [精霊術] */

/* 攻撃 */

	{ N_MSG_SPELL_WEAK_FIRE_ELEMENTAL,
		"火精霊攻撃" },
	{ N_MSG_SPELL_WEAK_WATER_ELEMENTAL,
		"水精霊攻撃" },
	{ N_MSG_SPELL_WEAK_AIR_ELEMENTAL,
		"風精霊攻撃" },
	{ N_MSG_SPELL_WEAK_EARTH_ELEMENTAL,
		"土精霊攻撃" },
	{ N_MSG_SPELL_WEAK_LIGHT_ELEMENTAL,
		"光精霊攻撃" },
	{ N_MSG_SPELL_WEAK_DARK_ELEMENTAL,
		"闇精霊攻撃" },

/* 召喚 */

	{ N_MSG_SPELL_SUMMON_FIRE_ELEMENTAL,
		"火精霊召喚" },
	{ N_MSG_SPELL_SUMMON_SALAMANDER,
		"サラマンダー召喚" },
	{ N_MSG_SPELL_SUMMON_WATER_ELEMENTAL,
		"水精霊召喚" },
	{ N_MSG_SPELL_SUMMON_UNDINE,
		"ウンディーネ召喚" },
	{ N_MSG_SPELL_SUMMON_AIR_ELEMENTAL,
		"風精霊召喚" },
	{ N_MSG_SPELL_SUMMON_SYLPH,
		"シルフ召喚" },
	{ N_MSG_SPELL_SUMMON_EARTH_ELEMENTAL,
		"土精霊召喚" },
	{ N_MSG_SPELL_SUMMON_GNOME,
		"ノーム召喚" },
	{ N_MSG_SPELL_SUMMON_WILL_O_WISP,
		"光精霊召喚" },
	{ N_MSG_SPELL_SUMMON_SHADE,
		"闇精霊召喚" },
	{ N_MSG_SPELL_DISMISSAL_ELEMENTAL,
		"精霊送還" },

/* [呪歌] */

/* 回復 */

	{ N_MSG_SPELL_SONG_CURE_HP,
		"体力回復の詩" },
	{ N_MSG_SPELL_SONG_CURE_MP,
		"精神力回復の詩" },

/* 能力値強化 */

	{ N_MSG_SPELL_SONG_SHARPNESS,
		"器用度増強の詩" },
	{ N_MSG_SPELL_SONG_STRENGTH,
		"筋力度増強の詩" },
	{ N_MSG_SPELL_SONG_QUICKNESS,
		"敏捷度増強の詩" },
	{ N_MSG_SPELL_SONG_BRAINY,
		"知力増強の詩" },
	{ N_MSG_SPELL_SONG_WISE,
		"判断力増強の詩" },
	{ N_MSG_SPELL_SONG_ATTRACTIVE,
		"魅力増強の詩" },

/* 能力値弱体 */

	{ N_MSG_SPELL_SONG_DULLNESS,
		"器用度減退の詩" },
	{ N_MSG_SPELL_SONG_WEAKNESS,
		"筋力度減退の詩" },
	{ N_MSG_SPELL_SONG_SLOWNESS,
		"敏捷度減退の詩" },
	{ N_MSG_SPELL_SONG_BRAINLESS,
		"知力減退の詩" },
	{ N_MSG_SPELL_SONG_FOOLISH,
		"判断力減退の詩" },
	{ N_MSG_SPELL_SONG_UNATTRACTIVE,
		"魅力減退の詩" },

/* 状態抵抗 */

	{ N_MSG_SPELL_SONG_RESI_STAT_STONE,
		"石化抵抗の詩" },
	{ N_MSG_SPELL_SONG_RESI_STAT_PARALYZE,
		"麻痺抵抗の詩" },
	{ N_MSG_SPELL_SONG_RESI_STAT_POISON,
		"毒抵抗の詩" },
	{ N_MSG_SPELL_SONG_RESI_STAT_CONFUSION,
		"混乱抵抗の詩" },
	{ N_MSG_SPELL_SONG_RESI_STAT_BLIND,
		"盲目抵抗の詩" },
	{ N_MSG_SPELL_SONG_RESI_STAT_SLEEP,
		"睡眠抵抗の詩" },
	{ N_MSG_SPELL_SONG_RESI_STAT_SILENCE,
		"沈黙抵抗の詩" },
	{ N_MSG_SPELL_SONG_RESI_STAT_FEAR,
		"恐怖抵抗の詩" },
	{ N_MSG_SPELL_SONG_RESI_STAT_HALLUCINATION,
		"幻覚抵抗の詩" },
	{ N_MSG_SPELL_SONG_RESI_STAT_CHARM,
		"魅了抵抗の詩" },
	{ N_MSG_SPELL_SONG_RESI_STAT_DRUNK,
		"酔い抵抗の詩" },

/* [忍術] */

/* 天変地異 */

	{ N_MSG_SPELL_TYPHOON,
		"台風の術 (木遁)" },
	{ N_MSG_SPELL_CONFLAGRATION,
		"火災の術 (火遁)" },
	{ N_MSG_SPELL_EARTHQUAKE,
		"地震の術 (土遁)" },
	{ N_MSG_SPELL_THUNDERCLOUD,
		"雷雲の術 (金遁)" },
	{ N_MSG_SPELL_INUNDATION,
		"洪水の術 (水遁)" },

/* 体術 */

	{ N_MSG_SPELL_SUBSTITUTE,
		"空蝉の術     (木遁)" },
	{ N_MSG_SPELL_BURNING_HANDS,
		"炎指の術     (火遁)" },
	{ N_MSG_SPELL_RALLY,
		"捲土重来の術 (土遁)" },
	{ N_MSG_SPELL_IRON_MAN,
		"鉄人の術     (金遁)" },
	{ N_MSG_SPELL_MIND_READING,
		"明鏡止水の術 (水遁)" },

/* [古代魔法] */

	{ N_MSG_SPELL_NOTHING,
		"無効果" },
	{ N_MSG_SPELL_POLTERGEIST,
		"ポルターガイスト" },

/* spell end */

/* spell format begin */

	{ N_MSG_FMT_SPELL_SPORE,
		"%s は胞子を撒き散らした" },
	{ N_MSG_FMT_SPELL_ACID,
		"%s は酸を吐いた" },
	{ N_MSG_FMT_SPELL_ENERGY_DRAIN,
		"%s は生命力を吸収した" },
	{ N_MSG_FMT_SPELL_CRY,
		"%s は恐ろしい泣き声を出した" },
	{ N_MSG_FMT_SPELL_FEAR,
		"%s は恐怖に満ちた表情をうかべた" },
	{ N_MSG_FMT_SPELL_HEAT_BREATH,
		"%s は炎の息を吐いた" },
	{ N_MSG_FMT_SPELL_COLD_BREATH,
		"%s は氷の息を吐いた" },
	{ N_MSG_FMT_SPELL_MIND_BREATH,
		"%s は風の息を吐いた" },
	{ N_MSG_FMT_SPELL_ACID_BREATH,
		"%s は酸の息を吐いた" },
	{ N_MSG_FMT_SPELL_ELEC_BREATH,
		"%s は雷の息を吐いた" },
	{ N_MSG_FMT_SPELL_POIS_BREATH,
		"%s は毒の息を吐いた" },
	{ N_MSG_FMT_SPELL_STONE_EYE,
		"%s は石化の視線を向けた" },
	{ N_MSG_FMT_SPELL_CYBERN_LIGHT,
		"%s は光子レーザーを飛ばした" },
	{ N_MSG_FMT_SPELL_XX_HEAT,
		"%s は火熱攻撃" },
	{ N_MSG_FMT_SPELL_XX_COLD,
		"%s は水冷攻撃" },
	{ N_MSG_FMT_SPELL_XX_MIND,
		"%s は風心攻撃" },
	{ N_MSG_FMT_SPELL_XX_ACID,
		"%s は土酸攻撃" },
	{ N_MSG_FMT_SPELL_XX_PARALYZE,
		"%s は麻痺攻撃" },
	{ N_MSG_FMT_SPELL_XX_POISON,
		"%s は毒攻撃" },
	{ N_MSG_FMT_SPELL_XX_SLEEP,
		"%s は睡眠攻撃" },

/* spell format end */

/* color begin */

	{ N_MSG_ATTR_NORMAL,
		"通常の色" },
	{ N_MSG_ATTR_REV,
		"反転の色" },
	{ N_MSG_ATTR_ERR,
		"エラーの色" },
	{ N_MSG_ATTR_MENU_NORMAL,
		"通常のメニュー項目の色" },
	{ N_MSG_ATTR_MENU_DIS,
		"無効なメニュー項目の色" },
	{ N_MSG_ATTR_MENU_SEL,
		"選択中のメニュー項目の色" },
	{ N_MSG_ATTR_MAP_ITEM,
		"アイテムの色" },
	{ N_MSG_ATTR_MAP_SQUARE,
		STR_SQUARE "の色" },
	{ N_MSG_ATTR_MAP_MNSTR,
		"モンスターの色" },
	{ N_MSG_ATTR_MAP_NPC,
		"NPCの色" },
	{ N_MSG_ATTR_MAP_CRSR,
		"カーソルの色" },
	{ N_MSG_ATTR_FX_MBR_PLUS,
		"メンバーの回復の色" },
	{ N_MSG_ATTR_FX_MBR_MINUS,
		"メンバーへのダメージの色" },
	{ N_MSG_ATTR_FX_MBR_CRTCL,
		"メンバーへのクリティカルの色" },
	{ N_MSG_ATTR_FX_MNSTR_PLUS,
		"モンスターの回復の色" },
	{ N_MSG_ATTR_FX_MNSTR_MINUS,
		"モンスターへのダメージの色" },
	{ N_MSG_ATTR_FX_MNSTR_CRTCL,
		"モンスターへのクリティカルの色" },
	{ N_MSG_ATTR_VFX,
		"エフェクトの色" },
	{ N_MSG_ATTR_MBR_1,
		"メンバーの色 1" },
	{ N_MSG_ATTR_MBR_2,
		"メンバーの色 2" },
	{ N_MSG_ATTR_MBR_3,
		"メンバーの色 3" },
	{ N_MSG_ATTR_MBR_4,
		"メンバーの色 4" },
	{ N_MSG_ATTR_MBR_5,
		"メンバーの色 5" },
	{ N_MSG_ATTR_MBR_6,
		"メンバーの色 6" },
	{ N_MSG_ATTR_HEAT,
		"火熱の色" },
	{ N_MSG_ATTR_COLD,
		"水冷の色" },
	{ N_MSG_ATTR_MIND,
		"風心の色" },
	{ N_MSG_ATTR_ACID,
		"土酸の色" },

/* color end */

	{ N_MSG_REPLAY_KIND_KEY,
		"key" },
	{ N_MSG_REPLAY_KIND_GETS,
		"gets" },
	{ N_MSG_CHK_REG_REPLAY_ERR,
		"リプレイは記録していません" },
	{ N_MSG_BGN_REG_REPLAY,
		"リプレイの記録を開始します" },
	{ N_MSG_END_REG_REPLAY,
		"リプレイの記録を終了しました" },
	{ N_MSG_LOAD_GAME_REPLAY_SUCCESS,
		"リプレイをスロット %ld 番からロードしました" },
	{ N_MSG_SAVE_GAME_REPLAY_SUCCESS,
		"リプレイをスロット %ld 番へセーブしました" },
	{ N_MSG_END_PLAY_REPLAY,
		"リプレイが終了しました。" },
	{ N_MSG_END_PLAY_REPLAY_WAIT_KEY,
		"キャンセル・キーを押して下さい。" },

	{ N_MSG__MSG_BLOCK_0_END_,
		"" },
#endif	/* SEL_MSG_BLOCK_0 */
#ifdef	SEL_MSG_BLOCK_1

/* menu begin */

	{ N_MSG_MENU_FRAME,
		"----------------------------------------"
		"----------------------------------------" },
	{ N_MSG_MENU_CLR_FMT,
		"% *s" },
	{ N_MSG_MENU_SELECT_FMT,
		"*%s%s%-*s" },
	{ N_MSG_MENU_NOT_SELECT_FMT,
		" %s%s%-*s" },
	{ N_MSG_MENU_SELECT_GUI_LEFT,
		"*" },
	{ N_MSG_MENU_NOT_SELECT_GUI_LEFT,
		" " },
	{ N_MSG_MENU_SELECT_GUI_RIGHT,
		"*" },
	{ N_MSG_MENU_NOT_SELECT_GUI_RIGHT,
		" " },
	{ N_MSG_MENU_SELECT_SHORT_CUT_FMT,
		"%*s%*s*" },
	{ N_MSG_MENU_NOT_SELECT_SHORT_CUT_FMT,
		"%*s%*s " },
	{ N_MSG_MENU_CONTENTS_FMT,
		"%s%*s" },
	{ N_MSG_MENU_FLG_LS_CHK_ON,
		"[*]" },
	{ N_MSG_MENU_FLG_LS_CHK_OFF,
		"[ ]" },
	{ N_MSG_MENU_FLG_LS_CHK_NULL,
		"   " },
	{ N_MSG_MENU_ACCEL_KEY_FMT,
		"%c)" },
	{ N_MSG_MENU_SHORT_CUT_KEY_FMT,
		"(%s)" },
	{ N_MSG_MENU_H_LINE,
		"-" },
	{ N_MSG_MENU_V_LINE,
		"|" },
	{ N_MSG_MENU_LEFT,
		"+---" },
	{ N_MSG_MENU_LEFT_PREV,
		"+<<=" },
	{ N_MSG_MENU_RIGHT,
		"---+" },
	{ N_MSG_MENU_RIGHT_NEXT,
		"=>>+" },
	{ N_MSG_MENU_PAGE_FMT,
		"-%2ld/%2ld-" },
	{ N_MSG_MENU_CORNER,
		"+" },
	{ N_MSG_MENU_KIND_BRANCH,
		" >" },
	{ N_MSG_MENU_KIND_OPEN_WIN_ITEM,
		"..." },
	{ N_MSG_MENU_KIND_ITEM,
		"" },

	{ N_MSG_MENU_YES,
		"はい" },
	{ N_MSG_MENU_NO,
		"いいえ" },

	{ N_MSG_MENU_MIN,
		"[min]" },
	{ N_MSG_MENU_MAX,
		"[max]" },
	{ N_MSG_MENU_CLR,
		"[clear]" },
	{ N_MSG_MENU_OK,
		"[ok]" },

	{ N_MSG_TTL_MENU_SEL_ABL,
		"能力値を選択" },

	{ N_MSG_TTL_MENU_MAIN_RACE,
		"種族" },
	{ N_MSG_TTL_MENU_SUB_RACE,
		"掛け合わせ" },
	{ N_MSG_TTL_MENU_SEX,
		"性別" },
	{ N_MSG_TTL_MENU_CLASS,
		"クラス" },

/* main menu */

	{ N_MSG_MENU_MARK,
		"マーク" },
	{ N_MSG_MENU_MOVE,
		"移動" },
	{ N_MSG_MENU_EXEC,
		"実行" },
	{ N_MSG_MENU_ITEM,
		"アイテム" },
	{ N_MSG_MENU_EQUIP,
		"装備" },
	{ N_MSG_MENU_FIGHT,
		"戦闘" },
	{ N_MSG_MENU_SPELL,
		"呪文" },
	{ N_MSG_MENU_TOWN,
		"街" },
	{ N_MSG_MENU_MISC,
		"その他" },

	{ N_MSG_STAT,
		"ステータス" },
	{ N_MSG_ABL,
		"能力値" },
	{ N_MSG_SKILL_A,
		"スキルA" },
	{ N_MSG_SKILL_B,
		"スキルB" },
	{ N_MSG_ITEM,
		"アイテム" },
	{ N_MSG_EQUIP,
		"装備" },

/* menu mark begin */

	{ N_MSG_MENU_POINT_CRSR,
		"マークするものを選んで下さい" },

	{ N_MSG_MENU_SEL_OBJ_MBR,
		"メンバー" },
	{ N_MSG_MENU_SEL_OBJ_SQUARE,
		STR_SQUARE },
	{ N_MSG_MENU_SEL_OBJ_ITEM,
		"アイテム" },
	{ N_MSG_MENU_SEL_OBJ_MNSTR,
		"モンスター" },
	{ N_MSG_MENU_SEL_OBJ_DOOR,
		"ドア" },
	{ N_MSG_MENU_SEL_OBJ_TRAP,
		"罠" },
	{ N_MSG_MENU_SEL_OBJ_POS,
		"位置指定" },
	{ N_MSG_MENU_SEL_OBJ_CLEAR,
		"マーク解除" },
	{ N_MSG_MENU_SEL_OBJ_AUTO,
		"作戦" },

	{ N_MSG_MENU_DIST_NEAR,
		"近接" },
	{ N_MSG_MENU_DIST_MEDIUM,
		"中間" },
	{ N_MSG_MENU_DIST_FAR,
		"遠隔" },

	{ N_MSG_MENU_MARK_FIGHT,
		"戦う" },
	{ N_MSG_MENU_MARK_THROW,
		"射撃" },
	{ N_MSG_MENU_MARK_STEAL,
		"盗む" },
	{ N_MSG_MENU_MARK_TAIL,
		"追う" },

	{ N_MSG_MENU_MARK_ITEM_PICK_UP,
		"ひろう" },
	{ N_MSG_MENU_MARK_ITEM_OPEN,
		"開ける" },
	{ N_MSG_MENU_MARK_ITEM_DISARM,
		STR_DISARM "する" },
	{ N_MSG_MENU_MARK_ITEM_BREAK,
		"壊す" },
	{ N_MSG_MENU_MARK_ITEM_CHK,
		"調べる" },

	{ N_MSG_MENU_MARK_DOOR_OPEN,
		"開く" },
	{ N_MSG_MENU_MARK_DOOR_CLOSE,
		"閉じる" },
	{ N_MSG_MENU_MARK_DOOR_JAM,
		"固定する" },
	{ N_MSG_MENU_MARK_DOOR_DISARM,
		STR_DISARM "する" },
	{ N_MSG_MENU_MARK_DOOR_BREAK,
		"壊す" },
	{ N_MSG_MENU_MARK_DOOR_PEEP,
		"鍵穴を覗く" },
	{ N_MSG_MENU_MARK_DOOR_CHK,
		"調べる" },

	{ N_MSG_MENU_MARK_TRAP_DISARM,
		STR_DISARM "する" },
	{ N_MSG_MENU_MARK_TRAP_BREAK,
		"壊す" },
	{ N_MSG_MENU_MARK_TRAP_CHK,
		"調べる" },

	{ N_MSG_MENU_MARK_SQUARE_POS,
		"向きを指定して下さい" },

/* menu mark end */

/* menu select item begin */

	{ N_MSG_MENU_ITEM_LS_EQUIP,
		"装備一覧" },

	{ N_MSG_MENU_ITEM_QUAFF,
		"飲む" },
	{ N_MSG_MENU_ITEM_READ,
		"読む" },
	{ N_MSG_MENU_ITEM_ZAP,
		"撃つ" },
	{ N_MSG_MENU_ITEM_EAT,
		"食べる" },
	{ N_MSG_MENU_ITEM_SMOKE,
		"一服する" },
	{ N_MSG_MENU_ITEM_DISPOSE,
		"吸い殻を入れる" },
	{ N_MSG_MENU_ITEM_FILL_LAMP,
		"ランプに補給" },
	{ N_MSG_MENU_ITEM_RUB,
		"こする" },
	{ N_MSG_MENU_ITEM_EQUIP,
		"装備" },
	{ N_MSG_MENU_ITEM_READY_THROW,
		"投げる用意" },
	{ N_MSG_MENU_ITEM_SEND,
		"渡しに行く" },
	{ N_MSG_TTL_MENU_ITEM_SEND,
		"誰に渡しに行く？" },
	{ N_MSG_MENU_ITEM_RECEIVE,
		"もらいに来る" },
	{ N_MSG_TTL_MENU_ITEM_RECEIVE,
		"誰がもらいに来る？" },
	{ N_MSG_MENU_ITEM_PUT_IN_CHEST,
		"宝箱にしまう" },
	{ N_MSG_MENU_ITEM_LS_CHEST,
		"宝箱から取り出す" },
	{ N_MSG_MENU_ITEM_DROP,
		"落とす" },
	{ N_MSG_MENU_ITEM_ALIAS,
		"名付ける" },
	{ N_MSG_MENU_ITEM_CHK,
		"調べる" },

/* menu select item end */

/* menu select equipment begin */

	{ N_MSG_MENU_SEL_EQUIP_WIELDING,
		STR_EQUIP_WIELDING },
	{ N_MSG_MENU_SEL_EQUIP_SHIELD,
		STR_EQUIP_SHIELD },
	{ N_MSG_MENU_SEL_EQUIP_BOW,
		STR_EQUIP_BOW },
	{ N_MSG_MENU_SEL_EQUIP_ARW,
		STR_EQUIP_ARW },
	{ N_MSG_MENU_SEL_EQUIP_HEAD,
		STR_EQUIP_HEAD },
	{ N_MSG_MENU_SEL_EQUIP_NECK,
		STR_EQUIP_NECK },
	{ N_MSG_MENU_SEL_EQUIP_BODY,
		STR_EQUIP_BODY },
	{ N_MSG_MENU_SEL_EQUIP_ARM,
		STR_EQUIP_ARM },
	{ N_MSG_MENU_SEL_EQUIP_RIGHT_HAND,
		STR_EQUIP_RIGHT_HAND },
	{ N_MSG_MENU_SEL_EQUIP_LEFT_HAND,
		STR_EQUIP_LEFT_HAND },
	{ N_MSG_MENU_SEL_EQUIP_FEET,
		STR_EQUIP_FEET },
	{ N_MSG_MENU_SEL_EQUIP_ABOUT_BODY,
		STR_EQUIP_ABOUT_BODY },
	{ N_MSG_MENU_SEL_EQUIP_LIGHT_SOURCE,
		STR_EQUIP_LIGHT_SOURCE },
	{ N_MSG_MENU_EQUIP_LS_ITEM,
		"アイテム一覧" },

	{ N_MSG_MENU_EQUIP_WEAR_SELF,
		"装備する" },
	{ N_MSG_MENU_EQUIP_WEAR_OTHER,
		"装備させる" },
	{ N_MSG_MENU_EQUIP_TAKE_OFF_SELF,
		"外す" },
	{ N_MSG_MENU_EQUIP_TAKE_OFF_OTHER,
		"外させる" },

	{ N_MSG_TTL_MENU_EQUIP_WEAR_OTHER,
		"誰に装備させますか？" },
	{ N_MSG_TTL_MENU_EQUIP_TAKE_OFF_OTHER,
		"誰に外させますか？" },

/* menu select equipment end */

/* menu town begin */

	{ N_MSG_MENU_NAVI,
		"ナビ" },
	{ N_MSG_MENU_AUTO_SALE,
		"アイテムをまとめて売る" },

/* menu town end */

/* menu navi begin */

	{ N_MSG_TTL_MENU_NAVI,
		"何処へ移動しますか？" },
	{ N_MSG_NAVI_PARTY,
		"%s へ移動しました" },
	{ N_MSG_NAVI_PARTY_STAIRS,
		"迷宮への階段" },

/* menu navi end */

/* menu auto sale begin */

	{ N_MSG_TTL_MENU_AUTO_SALE_SEL_MBR,
		"誰のアイテムを売りますか？" },
	{ N_MSG_TTL_MENU_AUTO_SALE,
		"どのアイテムを売りますか？ (%s)" },
	{ N_MSG_MENU_AUTO_SALE_EXEC,
		"チェックしたアイテムを売る" },
	{ N_MSG_TTL_MENU_AUTO_SALE_ASK,
		"本当に売りますか？" },

/* menu auto sale end */

/* menu misc begin */

	{ N_MSG_MENU_INFO,
		"情報" },
	{ N_MSG_MENU_CONTINUE_EXEC,
		"連続実行" },
	{ N_MSG_MENU_STAIRS,
		"階段" },
	{ N_MSG_MENU_SRCH,
		"探す" },
	{ N_MSG_MENU_MAP_HINT,
		"カーソル位置のキャラクタ" },
	{ N_MSG_MENU_CHR_DATA,
		"能力値" },
	{ N_MSG_MENU_GOLD,
		STR_GOLD },
	{ N_MSG_MENU_COLLECT_GOLD,
		STR_GOLD " を集める" },
	{ N_MSG_MENU_DIVIDE_GOLD,
		STR_GOLD " を分配する" },
	{ N_MSG_MENU_GIVE_GOLD,
		STR_GOLD " を渡す" },
	{ N_MSG_MENU_FORMATION,
		"隊列の変更" },
	{ N_MSG_MENU_LS_MSG,
		"メッセージ履歴" },
	{ N_MSG_MENU_LS_KEY_ITEM,
		"重要アイテム一覧" },
	{ N_MSG_MENU_LS_MNSTR,
		"モンスター一覧" },
	{ N_MSG_MENU_LS_REQUEST,
		"依頼一覧" },
	{ N_MSG_MENU_CNF,
		"設定" },
	{ N_MSG_MENU_SYS,
		"システム" },

	{ N_MSG_MENU_STAIRS_UP,
		"上る" },
	{ N_MSG_MENU_STAIRS_DOWN,
		"下る" },
	{ N_MSG_MENU_STAIRS_LAST_BOSS,
		STR_LAST_STAGE "へ下る" },
	{ N_MSG_TTL_MENU_ASK_DOWN_STAIRS_LAST_BOSS,
		"本当に" STR_LAST_STAGE "への階段を下りますか？" },

	{ N_MSG_TTL_MENU_SRCH,
		"探す" },
	{ N_MSG_MENU_SRCH_EXEC,
		"実行" },
	{ N_MSG_MENU_SRCH_EXEC_ALL,
		"実行 (全員)" },
	{ N_MSG_MENU_SRCH_CANCEL_ALL,
		"中止 (全員)" },
	{ N_MSG_MENU_SRCH_AUTO_OFF,
		"自動解除" },

	{ N_MSG_MAP_HINT_FMT_CHR,
		"X:%2ld, Y:%2ld [%c%c] %s" },
	{ N_MSG_MAP_HINT_FMT_CHR_SUB,
		"X:%2ld, Y:%2ld [%c%c] %s: %s" },
	{ N_MSG_MAP_HINT_MBR,
		"メンバー" },
	{ N_MSG_MAP_HINT_MNSTR,
		"モンスター" },
	{ N_MSG_MAP_HINT_PET,
		"仲間またはペット" },
	{ N_MSG_MAP_HINT_NPC,
		"NPC" },

	{ N_MSG_MAP_HINT_FMT_OBJ,
		"X:%2ld, Y:%2ld [%c%c] %s" },
	{ N_MSG_MAP_HINT_FMT_OBJ_SUB,
		"X:%2ld, Y:%2ld [%c%c] %s: %s" },
	{ N_MSG_MAP_HINT_FLOOR,
		"床" },
	{ N_MSG_MAP_HINT_HOLE,
		"奈落" },
	{ N_MSG_MAP_HINT_WALL,
		"壁" },
	{ N_MSG_MAP_HINT_STATUE,
		"像" },
	{ N_MSG_MAP_HINT_STREETLAMP,
		"街灯" },
	{ N_MSG_MAP_HINT_WATER,
		"水" },
	{ N_MSG_MAP_HINT_PUDDLE,
		"水たまり" },
	{ N_MSG_MAP_HINT_SHALLOWS,
		"浅瀬" },
	{ N_MSG_MAP_HINT_OFFING,
		"海" },
	{ N_MSG_MAP_HINT_LAVA,
		"溶岩" },
	{ N_MSG_MAP_HINT_ITEM,
		"アイテム" },
	{ N_MSG_MAP_HINT_TRAP,
		"罠" },
	{ N_MSG_MAP_HINT_DOOR,
		"ドア" },
	{ N_MSG_MAP_HINT_GATE,
		"ゲート" },
	{ N_MSG_MAP_HINT_WINDOW,
		"窓" },
	{ N_MSG_MAP_HINT_SHOP,
		"店" },
	{ N_MSG_MAP_HINT_STAIRS_UP,
		"上り階段" },
	{ N_MSG_MAP_HINT_STAIRS_DOWN,
		"下り階段" },
	{ N_MSG_MAP_HINT_STAIRS_LAST_BOSS,
		STR_LAST_STAGE "への階段" },

	{ N_MSG_MNSTR_DATA_NAME,
		"%c%c は %s だ" },
	{ N_MSG_MNSTR_DATA_MJR_NAME,
		"%c は %s の系統だ" },
	{ N_MSG_MNSTR_DATA_MAX_LEV,
		"%s の最高レベルは %4ld だ" },
	{ N_MSG_MNSTR_DATA_MIN_LEV,
		"%s の最低レベルは %4ld だ" },
	{ N_MSG_MNSTR_DATA_AVE_LEV,
		"%s の平均レベルは %4ld だ" },
	{ N_MSG_MNSTR_DATA_HP,
		"%s の HP は %6ld/%6ld だ" },
	{ N_MSG_MNSTR_DATA_MP,
		"%s の MP は %6ld/%6ld だ" },
	{ N_MSG_MNSTR_DATA_DRUNK,
		"%s は酔っ払っている" },

	{ N_MSG_TTL_MENU_GIVE_GOLD,
		"誰に" STR_GOLD "を渡す？" },

	{ N_MSG_TTL_MENU_FORMATION_SEL_MBR,
		"どのメンバー？" },
	{ N_MSG_TTL_MENU_FORMATION_SEL_N,
		"何番目に列ぶ？" },

/* menu cursor begin */

	{ N_MSG_MENU_CRSR,
		"カーソル" },

/* menu cursor move begin */

	{ N_MSG_MENU_CRSR_MOVE,
		"移動" },
	{ N_MSG_MENU_CRSR_MOVE_UP,
		"北" },
	{ N_MSG_MENU_CRSR_MOVE_DOWN,
		"南" },
	{ N_MSG_MENU_CRSR_MOVE_LEFT,
		"西" },
	{ N_MSG_MENU_CRSR_MOVE_RIGHT,
		"東" },
	{ N_MSG_MENU_CRSR_MOVE_UP_LEFT,
		"北西" },
	{ N_MSG_MENU_CRSR_MOVE_UP_RIGHT,
		"北東" },
	{ N_MSG_MENU_CRSR_MOVE_DOWN_LEFT,
		"南西" },
	{ N_MSG_MENU_CRSR_MOVE_DOWN_RIGHT,
		"南東" },
	{ N_MSG_MENU_CRSR_MOVE_ABS,
		"座標指定" },
	{ N_MSG_MENU_CRSR_MOVE_STOP,
		"その場" },

/* menu cursor move end */

/* menu cursor quick move begin */

	{ N_MSG_MENU_CRSR_QUICK_MOVE,
		"何かの隣に来るまで移動" },
	{ N_MSG_MENU_CRSR_QUICK_MOVE_UP,
		"北" },
	{ N_MSG_MENU_CRSR_QUICK_MOVE_DOWN,
		"南" },
	{ N_MSG_MENU_CRSR_QUICK_MOVE_LEFT,
		"西" },
	{ N_MSG_MENU_CRSR_QUICK_MOVE_RIGHT,
		"東" },
	{ N_MSG_MENU_CRSR_QUICK_MOVE_UP_LEFT,
		"北西" },
	{ N_MSG_MENU_CRSR_QUICK_MOVE_UP_RIGHT,
		"北東" },
	{ N_MSG_MENU_CRSR_QUICK_MOVE_DOWN_LEFT,
		"南西" },
	{ N_MSG_MENU_CRSR_QUICK_MOVE_DOWN_RIGHT,
		"南東" },

/* menu cursor quick move end */

/* menu cursor individual square begin */

	{ N_MSG_MENU_CRSR_IND_SQUARE,
		"メンバー・アンカーを設定" },
	{ N_MSG_MENU_CRSR_IND_SQUARE_NUM,
		"数字キーで設定" },
	{ N_MSG_MENU_CRSR_IND_SQUARE_PARTY,
		"パーティ・アンカーを設定" },

/* menu cursor individual square end */

/* menu cursor scroll begin */

	{ N_MSG_MENU_CRSR_SCROLL,
		"スクロール" },
	{ N_MSG_MENU_CRSR_SCROLL_UP,
		"北" },
	{ N_MSG_MENU_CRSR_SCROLL_DOWN,
		"南" },
	{ N_MSG_MENU_CRSR_SCROLL_LEFT,
		"西" },
	{ N_MSG_MENU_CRSR_SCROLL_RIGHT,
		"東" },
	{ N_MSG_MENU_CRSR_SCROLL_UP_LEFT,
		"北西" },
	{ N_MSG_MENU_CRSR_SCROLL_UP_RIGHT,
		"北東" },
	{ N_MSG_MENU_CRSR_SCROLL_DOWN_LEFT,
		"南西" },
	{ N_MSG_MENU_CRSR_SCROLL_DOWN_RIGHT,
		"南東" },

/* menu cursor scroll end */

	{ N_MSG_MENU_CRSR_MOVE_MBR,
		"指定したメンバー" },
	{ N_MSG_MENU_CRSR_CENTER,
		"センタリング" },

/* menu cursor next position begin */

	{ N_MSG_MENU_CRSR_NEXT_POS,
		"次の位置" },
	{ N_MSG_MENU_CRSR_NEXT_POS_MBR,
		"次のメンバー" },
	{ N_MSG_MENU_CRSR_NEXT_POS_MNSTR,
		"次のモンスター" },
	{ N_MSG_MENU_CRSR_NEXT_POS_ITEM,
		"次のアイテム" },
	{ N_MSG_MENU_CRSR_NEXT_POS_DOOR,
		"次のドア" },
	{ N_MSG_MENU_CRSR_NEXT_POS_OBJ,
		"次の物体" },
	{ N_MSG_MENU_CRSR_NEXT_POS_SQUARE,
		STR_SQUARE },
	{ N_MSG_MENU_CRSR_NEXT_POS_ALL,
		"次" },
	{ N_MSG_MENU_CRSR_PREV_POS,
		"前" },

/* menu cursor next position end */

/* menu cursor end */

	{ N_MSG_LS_MNSTR,
		"%3ld 階から %3ld 階 : %s" },

/* menu config begin */

	{ N_MSG_MENU_AUTO_FIGHT,
		"モンスターにぶつかったら攻撃する" },
	{ N_MSG_MENU_AUTO_DOOR,
		"ドアを自動的に開ける" },
	{ N_MSG_MENU_AVOID_TRAP,
		"罠を避ける" },
	{ N_MSG_MENU_AUTO_RELOAD,
		"矢を自動装填する" },
	{ N_MSG_MENU_ACTUAL_FIGHTING,
		"味方に手加減しない" },
	{ N_MSG_MENU_SPACE_SELECT,
		"スペース・バーでメニューを選択する" },
	{ N_MSG_MENU_RESET_FILE,
		"設定の初期化" },
	{ N_MSG_MENU_RESET_FILE_CONFIG,
		"設定ファイルの初期化" },
	{ N_MSG_MENU_RESET_FILE_TOWN_PTN,
		"街のマップ・ファイルの初期化" },
	{ N_MSG_TTL_MENU_RESET_FILE_ASK,
		"本当に初期化しますか？" },
	{ N_MSG_RESET_FILE,
		"初期化しました" },
	{ N_MSG_MENU_LANG,
		"言語" },
	{ N_MSG_MENU_LANG_LS,
		"言語一覧" },
	{ N_MSG_MENU_LANG_LS_PRIORITY,
		"この設定を環境変数より優先する" },
	{ N_MSG_SET_LANG,
		"言語を \"%s\" に設定しました" },
	{ N_MSG_MENU_SCREEN,
		"画面" },
	{ N_MSG_MENU_WINDOW,
		"ウィンドウ" },
	{ N_MSG_MENU_SCROLL_MODE,
		"スクロール" },
	{ N_MSG_MENU_REDRAW_EVERY_TURN,
		"毎ターン画面を再描画する" },
	{ N_MSG_MENU_MUL_MSG_LINE,
		"メッセージ行を複数化" },
	{ N_MSG_MENU_SCREEN_SIZE,
		"画面サイズ" },
	{ N_MSG_MENU_SCREEN_SIZE_AUTO,
		"自動設定" },
	{ N_MSG_MENU_SCREEN_SIZE_COL,
		"横文字数" },
	{ N_MSG_MENU_SCREEN_SIZE_ROW,
		"縦行数" },
	{ N_MSG_MENU_SCREEN_SIZE_MESSAGE,
		"メッセージ行数" },
	{ N_MSG_MENU_SCREEN_SIZE_MAP,
		"マップのサイズ可変" },
	{ N_MSG_MENU_VFX,
		"視覚効果" },
	{ N_MSG_MENU_COLOR,
		"表示色" },
	{ N_MSG_MENU_CRSR_PTN,
		"カーソルの形状" },
	{ N_MSG_MENU_DEMO,
		"デモ" },
	{ N_MSG_MENU_SKIP_CUT_IN,
		"カット・インをスキップ" },
	{ N_MSG_MENU_STAR,
		"星の数" },
	{ N_MSG_MENU_STAR_CUI,
		"テキスト版" },
	{ N_MSG_MENU_STAR_GUI,
		"タイル版" },
	{ N_MSG_MENU_KEY,
		"キー・ボード" },
	{ N_MSG_MENU_CLR_KEY_BUF,
		"キー・バッファをクリアする" },
	{ N_MSG_MENU_CLR_KEY_BUF_EVERY,
		"通常時" },
	{ N_MSG_MENU_CLR_KEY_BUF_MENU,
		"メニュー選択時" },
	{ N_MSG_MENU_ECHO_KEY,
		"入力されたキーを表示する" },
	{ N_MSG_MENU_KEY_BIND,
		"キー割り当て" },
	{ N_MSG_MENU_FUNC,
		"ファンクション・キー" },
	{ N_MSG_MENU_GUI,
		"GUI" },
	{ N_MSG_MENU_MOVE_CRSR_DFLT,
		"メニュー項目にカーソルを自動移動" },
	{ N_MSG_MENU_SOUND,
		"音響" },
	{ N_MSG_MENU_SOUND_VOLUME,
		"効果音の音量 (%ld)" },
	{ N_MSG_MENU_MUSIC_VOLUME,
		"楽曲の音量 (%ld)" },
	{ N_MSG_MENU_MUTE_SOUND,
		"ミュート(消音)" },
	{ N_MSG_MENU_REPLAY_MUSIC,
		"楽曲を再生しなおす" },
	{ N_MSG_MENU_MOUSE,
		"マウス" },
	{ N_MSG_MENU_JOYSTICK,
		"ジョイスティック" },
	{ N_MSG_MENU_JOYSTICK_SEL_N,
		"ジョイスティックを選択" },
	{ N_MSG_MENU_JOYSTICK_SEL_KIND,
		"ジョイスティックのタイプを切り替え" },
	{ N_MSG_MENU_JOYSTICK_PS,
		"プレイ・ステーション・タイプ" },
	{ N_MSG_MENU_JOYSTICK_SATURN,
		"サターン・タイプ" },
	{ N_MSG_MENU_JOYSTICK_RAP3,
		"リアル・アーケード・プロ３・タイプ" },
	{ N_MSG_MENU_JOYSTICK_MACRO,
		"ボタン割り当て" },
	{ N_MSG_MENU_USER,
		"ユーザ・メニュー" },

	{ N_MSG_REG_MACRO_BGN,
		"マクロ開始" },
	{ N_MSG_REG_MACRO_END,
		"マクロ終了 [%s]" },

	{ N_MSG_MENU_SCROLL_PAGE,
		"ページ・スクロール" },
	{ N_MSG_MENU_SCROLL_SMOOTH,
		"スムース・スクロール" },
	{ N_MSG_MENU_SCROLL_CENTER,
		"スムース・スクロール (カーソル中心)" },

	{ N_MSG_MENU_VFX_MBR_CURE,
		"メンバーの回復" },
	{ N_MSG_MENU_VFX_MBR_DAM,
		"メンバーへのダメージ" },
	{ N_MSG_MENU_VFX_MBR_CRTCL,
		"メンバーへのクリティカル" },
	{ N_MSG_MENU_VFX_MBR_ARW,
		"メンバーの飛び道具" },
	{ N_MSG_MENU_VFX_MNSTR_CURE,
		"モンスターの回復" },
	{ N_MSG_MENU_VFX_MNSTR_DAM,
		"モンスターへのダメージ" },
	{ N_MSG_MENU_VFX_MNSTR_CRTCL,
		"モンスターへのクリティカル" },
	{ N_MSG_MENU_VFX_MNSTR_ARW,
		"モンスターの飛び道具" },
	{ N_MSG_MENU_VFX_WAIT,
		"ウェイト (%ld)" },
	{ N_MSG_MENU_VFX_MEASURE_CLK_TCK,
		"フレーム・レートを計測する" },

	{ N_MSG_MENU_FG,
		"前景色" },
	{ N_MSG_MENU_BG,
		"背景色" },
	{ N_MSG_MENU_COLOR_BLACK,
		"黒" },
	{ N_MSG_MENU_COLOR_RED,
		"赤" },
	{ N_MSG_MENU_COLOR_GREEN,
		"緑" },
	{ N_MSG_MENU_COLOR_YELLOW,
		"黄色" },
	{ N_MSG_MENU_COLOR_BLUE,
		"青" },
	{ N_MSG_MENU_COLOR_MAGENTA,
		"紫" },
	{ N_MSG_MENU_COLOR_CYAN,
		"水色" },
	{ N_MSG_MENU_COLOR_WHITE,
		"白" },

	{ N_MSG_MENU_ATTR,
		"属性" },
	{ N_MSG_MENU_UNDERLINE,
		"下線" },
	{ N_MSG_MENU_REVERSE,
		"反転" },
	{ N_MSG_MENU_BLINK,
		"点滅" },
	{ N_MSG_MENU_BOLD,
		"強調" },

	{ N_MSG_MENU_SET_KEY,
		"キーに割り当てる" },
	{ N_MSG_MENU_SET_KEY_REG_MACRO,
		"記録したマクロをキーに割り当てる" },
	{ N_MSG_MENU_UNSET_KEY,
		"キーの割り当てを解除する" },
	{ N_MSG_GETS_SET_KEY_KEY,
		"割り当てるキーを入力して下さい : " },
	{ N_MSG_GETS_SET_KEY_PREV,
		"現在のコマンド : \"%s\"" },
	{ N_MSG_GETS_SET_KEY_CMD,
		"コマンドを入力して下さい (%ld 文字以内) : " },
	{ N_MSG_MENU_SET_KEY_DONE,
		"マクロを割り当てました : \'%s\' \"%s\"" },
	{ N_MSG_GETS_UNSET_KEY_KEY,
		"割り当てを解除するキーを入力して下さい : " },

	{ N_MSG_MENU_FUNC_KEY,
		"ファンクション・キー F%ld" },
	{ N_MSG_MENU_FUNC_EXEC,
		"実行" },
	{ N_MSG_MENU_FUNC_EDIT,
		"編集" },
	{ N_MSG_MENU_FUNC_SET_REG_MACRO,
		"記録したマクロを割り当てる" },
	{ N_MSG_GETS_FUNC_PREV,
		"現在のコマンド : \"%s\"" },
	{ N_MSG_GETS_FUNC_EDIT,
		"コマンドを入力して下さい (%ld 文字以内) : " },
	{ N_MSG_TTL_MENU_FUNC_SET_REG_MACRO,
		"ファンクション・キー F%ld に割り当てますか？" },
	{ N_MSG_MENU_FUNC_KEY_DONE,
		"マクロを割り当てました : F%ld \"%s\"" },

	{ N_MSG_MENU_MOUSE_CLICK,
		"マウス・ボタン %ld のクリック" },
	{ N_MSG_MENU_MOUSE_D_CLICK,
		"マウス・ボタン %ld のダブル・クリック" },
	{ N_MSG_MENU_MOUSE_P_CLICK,
		"マウス・ボタン %ld のプレスと %ld のクリック" },
	{ N_MSG_MENU_MOUSE_PRESS,
		"マウス・ボタン %ld のプレス" },
	{ N_MSG_MENU_MOUSE_RELEASE,
		"マウス・ボタン %ld のリリース" },
	{ N_MSG_MENU_MOUSE_MOTION_LEFT,
		"マウス・ボタン右の左方向へのドラッグ" },
	{ N_MSG_MENU_MOUSE_MOTION_RIGHT,
		"マウス・ボタン右の右方向へのドラッグ" },
	{ N_MSG_MENU_MOUSE_MOTION_UP,
		"マウス・ボタン右の上方向へのドラッグ" },
	{ N_MSG_MENU_MOUSE_MOTION_DOWN,
		"マウス・ボタン右の下方向へのドラッグ" },
	{ N_MSG_MENU_MOUSE_EXEC,
		"実行" },
	{ N_MSG_MENU_MOUSE_EDIT,
		"編集" },
	{ N_MSG_MENU_MOUSE_SET_REG_MACRO,
		"記録したマクロを割り当てる" },
	{ N_MSG_GETS_MOUSE_PREV,
		"現在のコマンド : \"%s\"" },
	{ N_MSG_GETS_MOUSE_EDIT,
		"コマンドを入力して下さい (%ld 文字以内) : " },
	{ N_MSG_TTL_MENU_MOUSE_SET_REG_MACRO,
		"マウス・ボタン %ld に割り当てますか？" },
	{ N_MSG_MENU_MOUSE_KEY_DONE,
		"マクロを割り当てました : %ld \"%s\"" },

	{ N_MSG_MENU_JOYSTICK_KEY,
		"ジョイスティック・ボタン %ld" },
	{ N_MSG_MENU_JOYSTICK_EXEC,
		"実行" },
	{ N_MSG_MENU_JOYSTICK_EDIT,
		"編集" },
	{ N_MSG_MENU_JOYSTICK_SET_REG_MACRO,
		"記録したマクロを割り当てる" },
	{ N_MSG_GETS_JOYSTICK_PREV,
		"現在のコマンド : \"%s\"" },
	{ N_MSG_GETS_JOYSTICK_EDIT,
		"コマンドを入力して下さい (%ld 文字以内) : " },
	{ N_MSG_TTL_MENU_JOYSTICK_SET_REG_MACRO,
		"ジョイスティック・ボタン %ld に割り当てますか？" },
	{ N_MSG_MENU_JOYSTICK_KEY_DONE,
		"マクロを割り当てました : %ld \"%s\"" },

	{ N_MSG_MENU_USER_NEW,
		"新規" },
	{ N_MSG_MENU_USER_NEW_REG_MACRO,
		"記録したマクロから新規" },
	{ N_MSG_MENU_USER_ARRANGE_UP,
		"1 つ上へ並べ換える" },
	{ N_MSG_MENU_USER_ARRANGE_DOWN,
		"1 つ下へ並べ換える" },
	{ N_MSG_MENU_USER_ARRANGE_TOP,
		"先頭へ並べ換える" },
	{ N_MSG_MENU_USER_ARRANGE_BOTTOM,
		"末尾へ並べ換える" },
	{ N_MSG_MENU_USER_REMOVE,
		"削除" },
	{ N_MSG_GETS_USER_MENU_NAME,
		"メニュー名を入力して下さい : " },
	{ N_MSG_GETS_USER_MENU_CMD,
		"コマンドを入力して下さい (%ld 文字以内) : " },
	{ N_MSG_MENU_USER_NEW_DONE_1,
		"マクロを割り当てました : \"%s\"" },
	{ N_MSG_MENU_USER_NEW_DONE_2,
		"\"%s\"" },

	{ N_MSG_GETS_AUTO_MARK_INFO_TTL,
		"現在の作戦の詳細名 : \"%s\"" },
	{ N_MSG_GETS_AUTO_MARK_INFO_NAME,
		"作戦の詳細名を入力して下さい : " },
	{ N_MSG_GETS_AUTO_MARK_HINT_TTL,
		"現在の作戦のかけ声 : \"%s\"" },
	{ N_MSG_GETS_AUTO_MARK_HINT_NAME,
		"作戦のかけ声を入力して下さい : " },

	{ N_MSG_GETS_AUTO_MARK_EDIT_MACRO_TTL,
		"現在のコマンド : \"%s\"" },
	{ N_MSG_GETS_AUTO_MARK_EDIT_MACRO_CMD,
		"コマンドを入力して下さい (%ld 文字以内) : " },
	{ N_MSG_TTL_MENU_AUTO_MARK_EDIT_MACRO_REG_MACRO,
		"記録したマクロを割り当てますか？" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_MACRO_DONE,
		"マクロを割り当てました : \"%s\"" },

/* menu config end */

/* menu system begin */

	{ N_MSG_MENU_REPLAY,
		"リプレイ" },
	{ N_MSG_MENU_COMMAND,
		"コマンド入力" },
	{ N_MSG_MENU_WIZARD,
		"ウィザード" },
	{ N_MSG_MENU_OUT_MAP_FILE,
		"マップをファイルへ出力" },
	{ N_MSG_MENU_SHELL,
		"シェル" },
	{ N_MSG_MENU_ABOUT_GAME,
		STR_FILE_NAME_GAME " について" },
	{ N_MSG_MENU_EXIT,
		"終了する" },

/* menu replay begin */

	{ N_MSG_MENU_REPLAY_LOAD,
		"リプレイをロード" },
	{ N_MSG_MENU_REPLAY_SAVE,
		"リプレイをセーブ" },
	{ N_MSG_MENU_REPLAY_DEBUG,
		"デバッグ" },
	{ N_MSG_MENU_REPLAY_BUG_REPO,
		"バグ報告" },
	{ N_MSG_REPLAY_BUG_REPO_1,
		"以下のディレクトリを添付して" },
	{ N_MSG_REPLAY_BUG_REPO_2,
		"バグ報告のメールを送って下さい" },

/* menu replay end */

	{ N_MSG_GETS_MENU_COMMAND,
		"メニュー・パスを入力して下さい : " },

/* menu wizard begin */

	{ N_MSG_TTL_MENU_WIZARD,
		"限定解除" },
	{ N_MSG_MENU_WIZARD_TELEPORT_PARTY,
		"パーティ瞬間移動" },
	{ N_MSG_MENU_WIZARD_RECALL,
		"帰還" },
	{ N_MSG_MENU_WIZARD_ON_LIGHT,
		"明りを点ける" },
	{ N_MSG_MENU_WIZARD_OFF_LIGHT,
		"明りを消す" },
	{ N_MSG_MENU_WIZARD_ADD_TURN,
		"ターンを進める" },
	{ N_MSG_MENU_WIZARD_UP_EXP,
		"経験値アップ" },
	{ N_MSG_MENU_WIZARD_UP_LEV,
		"レベル・アップ" },
	{ N_MSG_MENU_WIZARD_SCENE,
		"シーン切り替え" },
	{ N_MSG_MENU_WIZARD_TEXT_LOAD,
		"テキスト・ロード" },
	{ N_MSG_MENU_WIZARD_TEXT_SAVE,
		"テキスト・セーブ" },

	{ N_MSG_TTL_MENU_WIZARD_ADD_TURN,
		"ターンを進める" },
	{ N_MSG_MENU_WIZARD_ADD_TURN_HOUR,
		"時間を進める" },
	{ N_MSG_MENU_WIZARD_ADD_TURN_MINUTE,
		"分を進める" },
	{ N_MSG_MENU_WIZARD_ADD_TURN_TURN,
		"ターンを進める" },

	{ N_MSG_MENU_WIZARD_SCENE_LAST_BOSS,
		"ラスボス" },
	{ N_MSG_MENU_WIZARD_SCENE_GAME_OVER,
		"ゲーム・オーバー" },
	{ N_MSG_MENU_WIZARD_SCENE_ENDING,
		"エンディング" },

	{ N_MSG_MENU_WIZARD_LAST_SCENE_ENTER,
		STR_LAST_STAGE "へ突入" },
	{ N_MSG_MENU_WIZARD_LAST_SCENE_ENCOUNTER,
		"遭遇" },
	{ N_MSG_MENU_WIZARD_LAST_SCENE_EXEL,
		"Exel (エクセル)" },
	{ N_MSG_MENU_WIZARD_LAST_SCENE_EXELER,
		"Exeler (エクセラー)" },
	{ N_MSG_MENU_WIZARD_LAST_SCENE_XEX,
		"Xex (ゼクス)" },
	{ N_MSG_MENU_WIZARD_LAST_SCENE_XX,
		"XX (トゥエニィース)" },

/* menu wizard end */

	{ N_MSG_TTL_MENU_EXIT,
		"本当に終了しますか？" },

/* menu system end */

/* menu misc end */

/* menu auto mark begin */

	{ N_MSG_TTL_MENU_AUTO_MARK,
		"作戦" },
	{ N_MSG_MENU_AUTO_MARK_EXEC,
		"実行" },
	{ N_MSG_MENU_AUTO_MARK_EDIT,
		"編集" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_NAME,
		"名前の編集" },
	{ N_MSG_MENU_AUTO_MARK_COPY_L,
		"大コピー" },
	{ N_MSG_MENU_AUTO_MARK_PASTE_L,
		"大ペースト" },
	{ N_MSG_MENU_AUTO_MARK_REMOVE,
		"削除" },
	{ N_MSG_MENU_AUTO_MARK_ARRANGE_UP,
		"1 つ上へ並べ換える" },
	{ N_MSG_MENU_AUTO_MARK_ARRANGE_DOWN,
		"1 つ下へ並べ換える" },
	{ N_MSG_MENU_AUTO_MARK_ARRANGE_TOP,
		"先頭へ並べ換える" },
	{ N_MSG_MENU_AUTO_MARK_ARRANGE_BOTTOM,
		"末尾へ並べ換える" },
	{ N_MSG_MENU_AUTO_MARK_NULL,
		"----" },
	{ N_MSG_MENU_AUTO_MARK_INVALID,
		"----" },

	{ N_MSG_TTL_MENU_AUTO_MARK_ASK_REMOVE,
		"削除しますか？" },

	{ N_MSG_MENU_AUTO_MARK_DONE_COPY,
		"コピーしました" },
	{ N_MSG_MENU_AUTO_MARK_DONE_PASTE,
		"ペーストしました" },
	{ N_MSG_MENU_AUTO_MARK_DONE_REMOVE,
		"削除しました" },
	{ N_MSG_MENU_AUTO_MARK_DONE_ARRANGE_UP,
		"1 つ上へ並べ換えました" },
	{ N_MSG_MENU_AUTO_MARK_DONE_ARRANGE_DOWN,
		"1 つ下へ並べ換えました" },
	{ N_MSG_MENU_AUTO_MARK_DONE_ARRANGE_TOP,
		"先頭へ並べ換えました" },
	{ N_MSG_MENU_AUTO_MARK_DONE_ARRANGE_BOTTOM,
		"末尾へ並べ換えました" },

	{ N_MSG_TTL_MENU_AUTO_MARK_EDIT,
		"設定 (%s) - %s" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_TRGT,
		"対象   : %s" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_DIST,
		"間合い : %s" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_ACT,
		"行動   : %s" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_COND,
		"条件   : %s" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_APPOINT_ITEM,
		"アイテム種類別" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_MACRO,
		"マクロ" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_CONT,
		"連続マーク" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_PRIORITY,
		"現在の設定より優先" },
	{ N_MSG_MENU_AUTO_MARK_COPY_S,
		"小コピー" },
	{ N_MSG_MENU_AUTO_MARK_PASTE_S,
		"小ペースト" },

	{ N_MSG_TTL_MENU_AUTO_MARK_TRGT,
		"対象 (%s) - %s" },
	{ N_MSG_MENU_AUTO_MARK_TRGT_MNSTR,
		"モンスター" },
	{ N_MSG_MENU_AUTO_MARK_TRGT_ITEM,
		"アイテム" },
	{ N_MSG_MENU_AUTO_MARK_TRGT_DOOR,
		"ドア" },
	{ N_MSG_MENU_AUTO_MARK_TRGT_TRAP,
		"罠" },
	{ N_MSG_MENU_AUTO_MARK_TRGT_MBR,
		"メンバー" },
	{ N_MSG_MENU_AUTO_MARK_TRGT_UNCHANGE,
		"変更しない" },
	{ N_MSG_MENU_AUTO_MARK_TRGT_CLEAR,
		"マーク解除" },

	{ N_MSG_TTL_MENU_AUTO_MARK_DIST,
		"間合い (%s) - %s" },
	{ N_MSG_MENU_AUTO_MARK_DIST_NEAR,
		"近接" },
	{ N_MSG_MENU_AUTO_MARK_DIST_MEDIUM,
		"中間" },
	{ N_MSG_MENU_AUTO_MARK_DIST_FAR,
		"遠距離" },

	{ N_MSG_TTL_MENU_AUTO_MARK_ACT,
		"行動 (%s) - %s" },
	{ N_MSG_MENU_AUTO_MARK_ACT_FIGHT,
		"戦う" },
	{ N_MSG_MENU_AUTO_MARK_ACT_THROW,
		"射撃" },
	{ N_MSG_MENU_AUTO_MARK_ACT_STEAL,
		"盗む" },
	{ N_MSG_MENU_AUTO_MARK_ACT_TAIL,
		"追う" },
	{ N_MSG_MENU_AUTO_MARK_ACT_CHK,
		"調べる" },
	{ N_MSG_MENU_AUTO_MARK_ACT_PICK_UP,
		"ひろう" },
	{ N_MSG_MENU_AUTO_MARK_ACT_BREAK,
		"壊す" },
	{ N_MSG_MENU_AUTO_MARK_ACT_OPEN,
		"開ける" },
	{ N_MSG_MENU_AUTO_MARK_ACT_CLOSE,
		"閉じる" },
	{ N_MSG_MENU_AUTO_MARK_ACT_JAM,
		"固定する" },
	{ N_MSG_MENU_AUTO_MARK_ACT_DISARM,
		STR_DISARM "する" },
	{ N_MSG_MENU_AUTO_MARK_ACT_PEEP,
		"鍵穴をのぞく" },

	{ N_MSG_TTL_MENU_AUTO_MARK_COND,
		"条件 (%s) - %s" },
	{ N_MSG_MENU_AUTO_MARK_COND_NEAREST,
		"一番近い" },
	{ N_MSG_MENU_AUTO_MARK_COND_DISPERSE,
		"ばらける" },
	{ N_MSG_MENU_AUTO_MARK_COND_STAGGER,
		"よろけている" },
	{ N_MSG_MENU_AUTO_MARK_COND_OWN,
		"持っている" },
	{ N_MSG_MENU_AUTO_MARK_COND_IDENTIFIED,
		"識別済" },
	{ N_MSG_MENU_AUTO_MARK_COND_UN_IDENTIFIED,
		"未識別" },
	{ N_MSG_MENU_AUTO_MARK_COND_HP_MIN,
		"HP の少ない" },
	{ N_MSG_MENU_AUTO_MARK_COND_HP_MAX,
		"HP の多い" },
	{ N_MSG_MENU_AUTO_MARK_COND_MP_MIN,
		"MP の少ない" },
	{ N_MSG_MENU_AUTO_MARK_COND_MP_MAX,
		"MP の多い" },

	{ N_MSG_TTL_MENU_AUTO_MARK_APPOINT_ITEM_MJR,
		"アイテム種類別 (%s) - %s" },
	{ N_MSG_TTL_MENU_AUTO_MARK_APPOINT_ITEM_MNR,
		"アイテム詳細 (%s) - %s" },

	{ N_MSG_MENU_AUTO_MARK_EDIT_MACRO_BIND,
		"マクロを編集" },
	{ N_MSG_MENU_AUTO_MARK_EDIT_MACRO_REG_MACRO,
		"記録したマクロを割り当てる" },

	{ N_MSG_NAME_DFLT_AUTO_MARK_FIGHT,
		"戦闘 (追加)\nみんなガンバレ" },
	{ N_MSG_NAME_DFLT_AUTO_MARK_FIGHT_PRIO,
		"戦闘 (全員)\nみんなガンバレ" },
	{ N_MSG_NAME_DFLT_AUTO_MARK_FIGHT_NO_THROW,
		"接近戦闘 (追加)\n弓矢使うな" },
	{ N_MSG_NAME_DFLT_AUTO_MARK_FIGHT_NO_THROW_PRIO,
		"接近戦闘 (全員)\n弓矢使うな" },
	{ N_MSG_NAME_DFLT_AUTO_MARK_FIGHT_ALL,
		"殲滅戦 (追加)\n相手は雑魚だ" },
	{ N_MSG_NAME_DFLT_AUTO_MARK_FIGHT_ALL_PRIO,
		"殲滅戦 (全員)\n相手は雑魚だ" },
	{ N_MSG_NAME_DFLT_AUTO_MARK_ITEM_ALL,
		"全てのアイテム\n早いとこひろえ" },
	{ N_MSG_NAME_DFLT_AUTO_MARK_ITEM_OWN,
		"持っているアイテム\n落ちた矢ひろえ" },
	{ N_MSG_NAME_DFLT_AUTO_MARK_RETREAT,
		"解除\n退却だ" },
	{ N_MSG_NAME_DFLT_AUTO_MARK_CLEAR,
		"解除" },

/* menu auto mark end */

/* menu town begin */

	{ N_MSG_MENU_SHOP_SEL_MBR,
		"%s に誰が入る？" },

	{ N_MSG_BUY,
		"買う" },
	{ N_MSG_SALE_ITEM,
		"アイテムを売る" },
	{ N_MSG_SALE_EQUIP,
		"装備を売る" },

	{ N_MSG_MENU_BUY,
		"%s を買いますか？" },
	{ N_MSG_MENU_SALE,
		"%s を売りますか？" },
	{ N_MSG_TTL_MENU_BUY,
		"買いますか？" },
	{ N_MSG_TTL_MENU_SALE,
		"売りますか？" },
	{ N_MSG_MENU_REACHED_BUY,
		"%s を買いました" },
	{ N_MSG_MENU_REACHED_SALE,
		"%s を売りました" },
	{ N_MSG_NO_DEAL,
		"%s は引き取れません" },

	{ N_MSG_FMT_MENU_SHOP,
		"%s %s %s " STR_GOLD_FMT_MAX },
	{ N_MSG_FMT_MENU_MAGIC_GUILD,
		"%-*s レベル %3ld, " STR_GOLD_FMT_MAX },
	{ N_MSG_FMT_MENU_PET_SHOP,
		"%-*s " STR_GOLD_FMT_MAX },

	{ N_MSG_MENU_SHOP_DATA,
		"能力値" },
	{ N_MSG_MENU_SHOP_COLLECT_GOLD,
		STR_GOLD " を集める" },
	{ N_MSG_MENU_SHOP_DIVIDE_GOLD,
		STR_GOLD " を分配する" },
	{ N_MSG_MENU_SHOP_GIVE_GOLD,
		STR_GOLD " を渡す" },
	{ N_MSG_MENU_SHOP_BUY,
		"買う" },
	{ N_MSG_MENU_SHOP_SALE_ITEM,
		"アイテムを売る" },
	{ N_MSG_MENU_SHOP_SALE_EQUIP,
		"装備を売る" },

	{ N_MSG_TTL_MENU_TEMPLE,
		"%s %s " STR_GOLD_FMT },
	{ N_MSG_FMT_MENU_TEMPLE,
		"%-*s " STR_GOLD_FMT_MAX },
	{ N_MSG_MENU_TEMPLE_REMOVE_CURSE,
		"解呪" },
	{ N_MSG_MENU_TEMPLE_CURE_STATUS,
		"状態回復" },
	{ N_MSG_MENU_TEMPLE_RESURRECTION,
		"蘇生" },
	{ N_MSG_MENU_TEMPLE_CONTRIBUTION,
		"寄付" },

	{ N_MSG_TTL_MENU_TEMPLE_REMOVE_CURSE,
		"解呪しますか？" },
	{ N_MSG_TTL_MENU_TEMPLE_CURE_STATUS,
		"状態回復しますか？" },
	{ N_MSG_TTL_MENU_TEMPLE_RESURRECTION,
		"蘇生しますか？" },
	{ N_MSG_TTL_MENU_TEMPLE_CONTRIBUTION,
		"寄付しますか？" },

	{ N_MSG_MENU_REMOVE_CURSE,
		"%s の呪いは解けた" },
	{ N_MSG_MENU_REMOVE_CURSE_ERR,
		"%s は呪われていません" },
	{ N_MSG_MENU_CURE_STATUS,
		"%s の状態は回復した" },
	{ N_MSG_MENU_CURE_STATUS_ERR,
		"%s の状態は悪くありません" },
	{ N_MSG_TTL_MENU_RESURRECTION,
		"誰を蘇生しますか？" },
	{ N_MSG_MENU_RESURRECTION_ERR_ALL_MBR,
		"誰も死んでいません" },
	{ N_MSG_MENU_RESURRECTION_ERR,
		"%s は死んでいません" },
	{ N_MSG_MENU_CONTRIBUTION,
		"%s は " STR_GOLD_FMT " 寄付した" },

	{ N_MSG_TTL_MENU_ORDER,
		"何を注文しますか？" },
	{ N_MSG_MENU_ORDER_MBR,
		"%s : %s" },
	{ N_MSG_MENU_ORDER_CHOSE,
		"注文する" },
	{ N_MSG_MENU_ORDER_NULL,
		"頼まない" },

	{ N_MSG_MENU_BAR_ORDER,
		"飲み喰いする" },
	{ N_MSG_MENU_BAR_REQUEST,
		"依頼" },
	{ N_MSG_MENU_BAR_FORM,
		"パーティ編成" },

	{ N_MSG_MENU_REQUEST_REFRESH,
		"---------- " STR_GOLD_FMT " 支払って他を見る ----------" },
	{ N_MSG_TTL_MENU_REQUEST_REFRESH_ASK,
		"手数料を支払いますか？" },
	{ N_MSG_TTL_MENU_REQUEST_MBR_CONTRACT,
		"この依頼を引き受けますか？" },
	{ N_MSG_TTL_MENU_REQUEST_MBR_CANCEL,
		STR_GOLD_FMT " を支払って、この依頼を辞退しますか？" },

	{ N_MSG_MENU_BAR_EDIT_MBR,
		"メンバーを編集" },
	{ N_MSG_MENU_BAR_NEW_MBR,
		"新しいメンバーを登録" },
	{ N_MSG_MENU_BAR_REMOVE_MBR,
		"メンバーを削除" },

	{ N_MSG_MENU_BAR_EDIT_CLASS,
		"クラスを編集" },
	{ N_MSG_MENU_BAR_EDIT_SKILL,
		"スキルを編集" },
	{ N_MSG_MENU_BAR_NEW_CLASS,
		"新しいクラスを登録" },
	{ N_MSG_MENU_BAR_REMOVE_CLASS,
		"クラスを削除" },

	{ N_MSG_MENU_BAR_LOAD,
		"ロード" },
	{ N_MSG_MENU_BAR_SAVE,
		"セーブ" },
	{ N_MSG_TTL_MENU_ASK_LOAD,
		"本当にロードしますか？" },
	{ N_MSG_TTL_MENU_ASK_SAVE,
		"本当にセーブしますか？" },
	{ N_MSG_SAVE_LOAD_TTL_FMT,
		"%2ld: %s" },
	{ N_MSG_SAVE_LOAD_TTL_NULL,
		"---------- 空き ----------" },
	{ N_MSG_SAVE_LOAD_TTL_NEW_GAME,
		"    ----- 最初から始める -----" },
	{ N_MSG_MENU_LOAD_SUCCESS,
		"データをスロット %ld 番からロードしました" },
	{ N_MSG_MENU_SAVE_SUCCESS_BIN,
		"データをスロット %ld 番にセーブしました" },
	{ N_MSG_MENU_SAVE_SUCCESS_TXT,
		"ウィザード・モードでスロット %ld 番にセーブしました" },

	{ N_MSG_TTL_MENU_BAR_FORM,
		"パーティ編成" },
	{ N_MSG_MENU_BAR_JOIN,
		"パーティに加える" },
	{ N_MSG_MENU_BAR_NOT_JOIN,
		"パーティから外す" },

	{ N_MSG_TTL_MENU_BAR_EDIT_MBR,
		"メンバーを編集" },
	{ N_MSG_TTL_MENU_BAR_EDIT_MBR_SUB,
		"%s を編集" },
	{ N_MSG_MENU_BAR_ARRANGE_UP,
		"1 つ上へ並べ換える" },
	{ N_MSG_MENU_BAR_ARRANGE_DOWN,
		"1 つ下へ並べ換える" },
	{ N_MSG_MENU_BAR_ARRANGE_TOP,
		"先頭へ並べ換える" },
	{ N_MSG_MENU_BAR_ARRANGE_BOTTOM,
		"末尾へ並べ換える" },
	{ N_MSG_TTL_MENU_BAR_REMOVE_MBR,
		"メンバーを削除" },

	{ N_MSG_TTL_MENU_ASK_EDIT_MBR,
		"変更を保存しますか？" },
	{ N_MSG_TTL_MENU_ASK_NEW_MBR,
		"この設定でメンバーを登録しますか？" },
	{ N_MSG_TTL_MENU_ASK_REMOVE_MBR,
		"本当にメンバーを削除しますか？" },

	{ N_MSG_MENU_REMOVE_MBR_NAME,
		"%s を削除します" },
	{ N_MSG_MENU_REMOVE_MBR_LEV,
		"最高レベルは %4ld です" },
	{ N_MSG_MENU_REMOVE_MBR_GOLD,
		STR_GOLD_FMT " 所持しています" },
	{ N_MSG_MENU_REMOVE_MBR,
		"%s を削除しました" },
	{ N_MSG_MENU_REMOVE_MBR_CANCEL,
		"%s を削除しませんでした" },

	{ N_MSG_TTL_MENU_ASK_EDIT_CLASS,
		"変更を保存しますか？" },
	{ N_MSG_TTL_MENU_ASK_NEW_CLASS,
		"この設定でクラスを登録しますか？" },
	{ N_MSG_TTL_MENU_ASK_REMOVE_CLASS,
		"本当にクラスを削除しますか？" },

	{ N_MSG_TTL_MENU_SEL_EDIT_CLASS,
		"クラスを編集" },
	{ N_MSG_MENU_BAR_ARRANGE_UP_CLASS,
		"1 つ上へ並べ換える" },
	{ N_MSG_MENU_BAR_ARRANGE_DOWN_CLASS,
		"1 つ下へ並べ換える" },
	{ N_MSG_MENU_BAR_ARRANGE_TOP_CLASS,
		"先頭へ並べ換える" },
	{ N_MSG_MENU_BAR_ARRANGE_BOTTOM_CLASS,
		"末尾へ並べ換える" },

	{ N_MSG_MENU_NEW_MBR,
		"New Character" },
	{ N_MSG_MENU_NEW_CLASS,
		"New Class" },

	{ N_MSG_MENU_INN_STAY,
		"泊まる         " STR_GOLD_FMT_MAX },
	{ N_MSG_MENU_INN_SHORT_STAY,
		"休む           " STR_GOLD_FMT_MAX },
	{ N_MSG_MENU_INN_STAY_IN_MEWS,
		"馬小屋に泊まる " STR_GOLD_FMT_MAX },
	{ N_MSG_MENU_INN_BATH,
		"風呂に入る" },
	{ N_MSG_MENU_INN_DO_STAY,
		"一泊して朝になった" },
	{ N_MSG_MENU_INN_DO_SHORT_STAY,
		"しばらく休んだ" },
	{ N_MSG_TTL_MENU_INN_BATH,
		"誰が風呂に入りますか？" },
	{ N_MSG_TAKE_BATH,
		"%s は風呂に入った" },
	{ N_MSG_CHR_IS_MOLESTED,
		"%s は風呂をのぞかれた" },
	{ N_MSG_MENU_INN_CALENDAR,
		"%s になった" },

	{ N_MSG_TTL_MENU_MAGIC_GUILD,
		"%s %s " STR_GOLD_FMT },

/* menu pet shop begin */

	{ N_MSG_TTL_MENU_PET_SHOP,
		"%s %s " STR_GOLD_FMT },
	{ N_MSG_TTL_MENU_PET_SHOP_TAKE,
		"%s %s 引き取る" },
	{ N_MSG_TTL_MENU_PET_SHOP_LEAVE,
		"%s %s 預ける" },
	{ N_MSG_TTL_MENU_PET_SHOP_NAME,
		"%s %s 名前をつける" },
	{ N_MSG_TTL_MENU_PET_SHOP_REMOVE,
		"%s %s 削除する" },

	{ N_MSG_MENU_PET_SHOP_BUY,
		"飼う" },
	{ N_MSG_MENU_PET_SHOP_TAKE,
		"引き取る" },
	{ N_MSG_MENU_PET_SHOP_LEAVE,
		"預ける" },
	{ N_MSG_MENU_PET_SHOP_NAME,
		"名前をつける" },
	{ N_MSG_MENU_PET_SHOP_REMOVE,
		"削除する" },

	{ N_MSG_MENU_PET_SHOP_NAME_LS,
		"%s (%s)" },

	{ N_MSG_MENU_PET_SHOP_ASK_BUY,
		"%s を飼いますか？" },
	{ N_MSG_TTL_MENU_PET_SHOP_ASK_BUY,
		"飼いますか？" },

	{ N_MSG_MENU_PET_SHOP_ASK_REMOVE,
		"本当に %s を削除しますか？" },
	{ N_MSG_TTL_MENU_PET_SHOP_ASK_REMOVE,
		"本当にペットを削除しますか？" },

	{ N_MSG_MENU_PET_SHOP_BUY_SUCCESS,
		"%s を飼いました" },
	{ N_MSG_MENU_PET_SHOP_TAKE_SUCCESS,
		"%s を引き取りました" },
	{ N_MSG_MENU_PET_SHOP_LEAVE_SUCCESS,
		"%s を預けました" },
	{ N_MSG_MENU_PET_SHOP_NAME_SUCCESS,
		"%s に名前をつけました" },
	{ N_MSG_MENU_PET_SHOP_REMOVE_SUCCESS,
		"%s を削除しました" },

/* menu pet shop end */

/* menu town end */

/* menu spell begin */

	{ N_MSG_MENU_REG_SPELL_NULL,
		"----" },
	{ N_MSG_MENU_REG_SPELL,
		"%s" },
	{ N_MSG_MENU_REG_SPELL_REMARK,
		"%s (マーク指定)" },

	{ N_MSG_MENU_SPELL_LS,
		"%-*s MP:%3ld HP:%3ld " STR_GOLD ":%3ld" },

	{ N_MSG_MENU_SPELL_EXTENT_NORMAL,
		"通常" },
	{ N_MSG_MENU_SPELL_EXTENT_SPREAD,
		"拡散 (X 2)" },
	{ N_MSG_MENU_SPELL_EXTENT_MASS,
		"全体 (X 3)" },
	{ N_MSG_MENU_SPELL_EXTENT_LIMIT,
		"限定" },
	{ N_MSG_MENU_SPELL_EXTENT_HALF,
		"半減 (/ 2)" },
	{ N_MSG_MENU_SPELL_EXTENT_DOUBLE,
		"倍増 (X 2)" },

/* menu spell end */

/* menu end */

/* GUI begin */

	{ N_MSG_SEL_CONF_LABEL,
		"グラフィック設定を選んで下さい" },
	{ N_MSG_SEL_CONF_OK,
		"ゲーム開始" },
	{ N_MSG_SEL_CONF_CANCEL,
		"ゲーム終了" },

	{ N_MSG_GUI_CANCEL,
		"キャンセル" },
	{ N_MSG_GUI_OK,
		"OK" },

	{ N_MSG_GUI_MAP_EXEC,
		"  実行  " },
	{ N_MSG_GUI_MAP_CONT_EXEC_ON,
		"  停止  " },
	{ N_MSG_GUI_MAP_CONT_EXEC_OFF,
		"連続実行" },
	{ N_MSG_GUI_MAP_AUTO_MARK,
		"   作戦  (/)" },
	{ N_MSG_GUI_MAP_USER_MENU,
		" ユーザ  (*)" },
	{ N_MSG_GUI_MAP_SPELL,
		"   呪文  (-)" },
	{ N_MSG_GUI_MAP_SQUARE,
		"アンカー (+)" },
	{ N_MSG_GUI_MAP_CANCEL,
		" X " },
	{ N_MSG_GUI_MAP_OK,
		" O " },

	{ N_MSG_GUI_MAP_TOOL_TIP_EXEC,
		"ターンを 1 回実行します。" },
	{ N_MSG_GUI_MAP_TOOL_TIP_CONT_EXEC,
		"ターンを連続して実行します。" },
	{ N_MSG_GUI_MAP_TOOL_TIP_AUTO_MARK,
		"作戦メニューを表示します。" },
	{ N_MSG_GUI_MAP_TOOL_TIP_USER_MENU,
		"ユーザ・メニューを表示します。" },
	{ N_MSG_GUI_MAP_TOOL_TIP_SPELL,
		"呪文メニューを表示します。" },
	{ N_MSG_GUI_MAP_TOOL_TIP_SQUARE,
		STR_SQUARE "を設定します。" },
	{ N_MSG_GUI_MAP_TOOL_TIP_CANCEL,
		"キャンセル" },
	{ N_MSG_GUI_MAP_TOOL_TIP_OK,
		"OK" },

	{ N_MSG_GUI_MENU_PREV_PAGE_ON,
		" << " },
	{ N_MSG_GUI_MENU_PREV_PAGE_OFF,
		"    " },
	{ N_MSG_GUI_MENU_NEXT_PAGE_ON,
		" >> " },
	{ N_MSG_GUI_MENU_NEXT_PAGE_OFF,
		"    " },
	{ N_MSG_GUI_MENU_CANCEL_ON,
		" 戻る " },
	{ N_MSG_GUI_MENU_CANCEL_OFF,
		"      " },
	{ N_MSG_GUI_MENU_CANCEL_ALL_ON,
		"閉じる" },
	{ N_MSG_GUI_MENU_CANCEL_ALL_OFF,
		"      " },

	{ N_MSG_GUI_MENU_TOOL_TIP_PREV_PAGE,
		"前のページ" },
	{ N_MSG_GUI_MENU_TOOL_TIP_NEXT_PAGE,
		"次のページ" },
	{ N_MSG_GUI_MENU_TOOL_TIP_CANCEL,
		"1 つ前のメニューへ戻ります" },
	{ N_MSG_GUI_MENU_TOOL_TIP_CANCEL_ALL,
		"メニューを閉じます" },
	{ N_MSG_GUI_MENU_TOOL_TIP_PAGE_N,
		"ページ数" },

	{ N_MSG_GUI_INPUT_STRING_CANCEL,
		"キャンセル" },
	{ N_MSG_GUI_INPUT_STRING_OK,
		"OK" },

	{ N_MSG_GUI_REPLAY_TITLE,
		"リプレイ" },
	{ N_MSG_GUI_REPLAY_TURN,
		"1 ターン実行" },
	{ N_MSG_GUI_REPLAY_KEY_1,
		"1 キー実行" },
	{ N_MSG_GUI_REPLAY_KEY_10,
		"10 キー実行" },
	{ N_MSG_GUI_REPLAY_CONT,
		"連続実行" },
	{ N_MSG_GUI_REPLAY_EXIT,
		"終了" },

	{ N_MSG_GUI_CLASS_EDIT_TITLE,
		"クラス編集" },
	{ N_MSG_GUI_SKILL_EDIT_TITLE,
		"スキル編集" },

/* GUI end */

	{ N_MSG_MBR_DATA_SEL,
		"*%s*" },
	{ N_MSG_MBR_DATA_NOT_SEL,
		" %s " },

	{ N_MSG_GETS_MBR_NAME,
		"名前を入力して下さい (%ld 文字以内)" },
	{ N_MSG_GETS_MBR_FACE,
		"顔文字を１文字入力して下さい" },
	{ N_MSG_GETS_RACE_NAME,
		"種族名を入力して下さい (%ld 文字以内)" },

	{ N_MSG_RACE_STR_PUREBRED,
		"%sの純血種" },
	{ N_MSG_RACE_STR_MIXED,
		"%s & %s" },

	{ N_MSG_MBR_DATA_NAME_TTL,
		"名前  : " },
	{ N_MSG_MBR_DATA_FACE_TTL,
		"顔    : " },
	{ N_MSG_MBR_DATA_RACE_STR_TTL,
		"種族  : " },
	{ N_MSG_MBR_DATA_RACE_NAME_TTL,
		"種族名: " },
	{ N_MSG_MBR_DATA_SEX_TTL,
		"性別  : " },

	{ N_MSG_MBR_DATA_HP_VAL,
		"HP: " },
	{ N_MSG_MBR_DATA_MP_VAL,
		"MP: " },

	{ N_MSG_MBR_DATA_VAL_TTL,
		"                    近接 (遠隔)" },
	{ N_MSG_MBR_DATA_VAL_BASH_TTL,
		"近接" },
	{ N_MSG_MBR_DATA_VAL_THROW_TTL,
		"遠隔" },
	{ N_MSG_MBR_DATA_HIT_TTL,
		"攻撃力            : " },
	{ N_MSG_MBR_DATA_HIT,
		"%s%4ld (%4ld)" },
	{ N_MSG_MBR_DATA_WPN_CRTCL_TTL,
		"クリティカル攻撃力: " },
	{ N_MSG_MBR_DATA_WPN_CRTCL,
		"%s%4ld (%4ld)" },
	{ N_MSG_MBR_DATA_DAM_TTL,
		"ダメージ          : " },
	{ N_MSG_MBR_DATA_DAM,
		"%s%4ld (%4ld)" },
	{ N_MSG_MBR_DATA_DEF_TTL,
		"防御力            : " },
	{ N_MSG_MBR_DATA_DEF,
		"%s%4ld" },
	{ N_MSG_MBR_DATA_ARMOR_CRTCL_TTL,
		"クリティカル防御力: " },
	{ N_MSG_MBR_DATA_ARMOR_CRTCL,
		"%s%4ld" },
	{ N_MSG_MBR_DATA_AC_TTL,
		"装甲値            : " },
	{ N_MSG_MBR_DATA_AC,
		"%s%4ld" },

	{ N_MSG_MBR_DATA_GOLD_TTL,
		STR_GOLD ": " },
	{ N_MSG_CALENDAR,
		"%4ld年%02ld月%02ld日 (%s曜日)%02ld時%02ld分" },

	{ N_MSG_MBR_DATA_STAT_TTL,
		"状態:" },
	{ N_MSG_MBR_DATA_STAT_NULL,
		"[          ]" },
	{ N_MSG_MBR_DATA_STAT_DEAD,
		"[死亡      ]" },
	{ N_MSG_MBR_DATA_STAT_STONE,
		"[石化      ]" },
	{ N_MSG_MBR_DATA_STAT_POISON,
		"[毒        ]" },
	{ N_MSG_MBR_DATA_STAT_PARALYZE,
		"[麻痺      ]" },
	{ N_MSG_MBR_DATA_STAT_CONFUSION,
		"[混乱      ]" },
	{ N_MSG_MBR_DATA_STAT_BLIND,
		"[盲目      ]" },
	{ N_MSG_MBR_DATA_STAT_SLEEP,
		"[眠り      ]" },
	{ N_MSG_MBR_DATA_STAT_SILENCE,
		"[沈黙      ]" },
	{ N_MSG_MBR_DATA_STAT_CAUGHT,
		"[拘束      ]" },
	{ N_MSG_MBR_DATA_STAT_FEAR,
		"[恐怖      ]" },
	{ N_MSG_MBR_DATA_STAT_HALLUCINATION,
		"[幻覚      ]" },
	{ N_MSG_MBR_DATA_STAT_CHARM,
		"[魅了      ]" },
	{ N_MSG_MBR_DATA_STAT_FLY,
		"[浮遊      ]" },
	{ N_MSG_MBR_DATA_STAT_VANISH,
		"[透明化    ]" },
	{ N_MSG_MBR_DATA_STAT_IRON_BODY,
		"[鋼鉄化    ]" },
	{ N_MSG_MBR_DATA_STAT_PASSWALL,
		"[壁抜け    ]" },
	{ N_MSG_MBR_DATA_STAT_SENSE_INVISIBLE,
		"[不可視感知]" },
	{ N_MSG_MBR_DATA_STAT_HUNGRY,
		"[空腹      ]" },
	{ N_MSG_MBR_DATA_STAT_STARVATION,
		"[飢餓      ]" },
	{ N_MSG_MBR_DATA_STAT_FAINT,
		"[めまい    ]" },
	{ N_MSG_MBR_DATA_STAT_DRUNK,
		"[酔い      ]" },

	{ N_MSG_FMT_MBR_DATA_STORE_LIGHT,
		"%s : %ld" },
	{ N_MSG_MBR_DATA_STORE_LIGHT_TTL,
		"貯めている明かり" },
	{ N_MSG_FMT_MBR_DATA_GRAPH_FILE,
		"%s : %s" },
	{ N_MSG_MBR_DATA_GRAPH_FILE_TTL,
		"タイル" },

	{ N_MSG_MBR_DATA_LEV_TTL,
		"レベル" },
	{ N_MSG_MBR_DATA_EXP_TTL,
		"経験値" },
	{ N_MSG_MBR_DATA_NEED_EXP_TTL,
		"必要経験値" },

	{ N_MSG_FMT_MBR_DATA_ABL,
		"%4s%s%4ld%5s%10ld/%10ld%s" },
	{ N_MSG_FMT_MBR_DATA_VALUE,
		"%4ld" },
	{ N_MSG_FMT_MBR_DATA_ADD_LEV,
		"(%+2ld)" },
	{ N_MSG_MBR_DATA_HP_TTL,
		"HP :" },
	{ N_MSG_MBR_DATA_MP_TTL,
		"MP :" },
	{ N_MSG_MBR_DATA_DEX_TTL,
		"DEX:" },
	{ N_MSG_MBR_DATA_STR_TTL,
		"STR:" },
	{ N_MSG_MBR_DATA_AGI_TTL,
		"AGI:" },
	{ N_MSG_MBR_DATA_INT_TTL,
		"INT:" },
	{ N_MSG_MBR_DATA_WIS_TTL,
		"WIS:" },
	{ N_MSG_MBR_DATA_CHA_TTL,
		"CHA:" },
	{ N_MSG_MBR_DATA_FIG_TTL,
		"FIG:" },
	{ N_MSG_MBR_DATA_MON_TTL,
		"MON:" },
	{ N_MSG_MBR_DATA_HUN_TTL,
		"HUN:" },
	{ N_MSG_MBR_DATA_THI_TTL,
		"THI:" },
	{ N_MSG_MBR_DATA_MAG_TTL,
		"MAG:" },
	{ N_MSG_MBR_DATA_SOR_TTL,
		"SOR:" },
	{ N_MSG_MBR_DATA_ENC_TTL,
		"ENC:" },
	{ N_MSG_MBR_DATA_SUM_TTL,
		"SUM:" },
	{ N_MSG_MBR_DATA_PRI_TTL,
		"PRI:" },
	{ N_MSG_MBR_DATA_SHA_TTL,
		"SHA:" },
	{ N_MSG_MBR_DATA_BAR_TTL,
		"BAR:" },
	{ N_MSG_MBR_DATA_NIN_TTL,
		"NIN:" },

	{ N_MSG_MBR_DATA_RESI_TTL,
		"-耐性-" },
	{ N_MSG_MBR_DATA_RESI_TTL_LAWFUL,
		"秩序" },
	{ N_MSG_MBR_DATA_RESI_TTL_NEUTRAL_1,
		"中立" },
	{ N_MSG_MBR_DATA_RESI_TTL_CHAOTIC,
		"混沌" },
	{ N_MSG_MBR_DATA_RESI_TTL_GOOD,
		"善" },
	{ N_MSG_MBR_DATA_RESI_TTL_NEUTRAL_2,
		"中立" },
	{ N_MSG_MBR_DATA_RESI_TTL_EVIL,
		"悪" },

	{ N_MSG_FMT_MBR_DATA_RESI,
		"%s:%4ld" },
	{ N_MSG_MBR_DATA_RESI_KNOC_TTL,
		"殴打" },
	{ N_MSG_MBR_DATA_RESI_SLAS_TTL,
		"斬撃" },
	{ N_MSG_MBR_DATA_RESI_STIN_TTL,
		"刺突" },
	{ N_MSG_MBR_DATA_RESI_HEAT_TTL,
		"火熱" },
	{ N_MSG_MBR_DATA_RESI_COLD_TTL,
		"水冷" },
	{ N_MSG_MBR_DATA_RESI_MIND_TTL,
		"風心" },
	{ N_MSG_MBR_DATA_RESI_ACID_TTL,
		"土酸" },
	{ N_MSG_MBR_DATA_RESI_ELEC_TTL,
		"光雷" },
	{ N_MSG_MBR_DATA_RESI_POIS_TTL,
		"闇毒" },

	{ N_MSG_MBR_DATA_CLASS_TTL,
		"クラス: " },
	{ N_MSG_MBR_DATA_CLASS,
		"%s%s" },

	{ N_MSG_MBR_DATA_SKILL_NAME_A_TTL,
		" - スキルA - " },
	{ N_MSG_MBR_DATA_SKILL_NAME_B_TTL,
		" - スキルB - " },
	{ N_MSG_MBR_DATA_SKILL_LEV_TTL,
		"レベル" },
	{ N_MSG_MBR_DATA_SKILL_EXP_TTL,
		"経験値" },
	{ N_MSG_MBR_DATA_SKILL_NEED_EXP_TTL,
		"必要経験値" },
	{ N_MSG_FMT_MBR_DATA_SKILL_NAME,
		"%-*s" },

	{ N_MSG_MBR_DATA_SWAP_MBR,
		"メンバー" },
	{ N_MSG_MBR_DATA_SWAP_PAGE,
		"ページ" },
	{ N_MSG_MBR_DATA_PREV_MBR,
		"前のメンバー" },
	{ N_MSG_MBR_DATA_NEXT_MBR,
		"次のメンバー" },
	{ N_MSG_MBR_DATA_PREV_PAGE,
		"前のページ" },
	{ N_MSG_MBR_DATA_NEXT_PAGE,
		"次のページ" },

	{ N_MSG_LEV_UP_LEFT_OFF,
		" " },
	{ N_MSG_LEV_UP_RIGHT_OFF,
		" " },
	{ N_MSG_LEV_UP_LEFT_ON,
		"*" },
	{ N_MSG_LEV_UP_RIGHT_ON,
		"*" },

/* edit class begin */

	{ N_MSG_EDIT_CLASS_TTL,
		"%s%3ld%%" },
	{ N_MSG_EDIT_CLASS_ADD_SEL,
		"<+>" },
	{ N_MSG_EDIT_CLASS_ADD_NOT_SEL,
		" + " },
	{ N_MSG_EDIT_CLASS_SUB_SEL,
		"<->" },
	{ N_MSG_EDIT_CLASS_SUB_NOT_SEL,
		" - " },
	{ N_MSG_EDIT_CLASS_TOTAL_SEL,
		"*TOTAL: %3ld*" },
	{ N_MSG_EDIT_CLASS_TOTAL_NOT_SEL,
		" TOTAL: %3ld " },
	{ N_MSG_EDIT_CLASS_NAME_SEL,
		"*%s%-*s*" },
	{ N_MSG_EDIT_CLASS_NAME_NOT_SEL,
		" %s%-*s " },
	{ N_MSG_EDIT_CLASS_PREV,
		"前のクラス" },
	{ N_MSG_EDIT_CLASS_NEXT,
		"次のクラス" },
	{ N_MSG_EDIT_CLASS_EXIT,
		"終了" },

/* edit class end */

/* edit skill begin */
	{ N_MSG_EDIT_SKILL_SEL,
		"*%-*s %3ld%%*" },
	{ N_MSG_EDIT_SKILL_NOT_SEL,
		" %-*s %3ld%% " },

	/* SKILL_GROUP_KIND_FIGHT, */
	{ N_MSG_SKILL_HINT_ATTACKER,
		"攻撃力を %ld%%+ に上げ、ダメージと防御力を %ld%% に下げる。" },
	{ N_MSG_SKILL_HINT_BERSERKER,
		"ダメージを %ld%%+ に上げ、攻撃力と防御力を %ld%% に下げる。" },
	{ N_MSG_SKILL_HINT_DEFENDER,
		"防御力を %ld%%+ に上げ、攻撃力とダメージを %ld%% に下げる。" },
	{ N_MSG_SKILL_HINT_SENTINEL,
		"装甲値を %ld%%+ に上げる。" },
	{ N_MSG_SKILL_HINT_ASSASSIN,
		"クリティカル攻撃力を %ld%%+ に上げる。" },
	{ N_MSG_SKILL_HINT_AEGIS,
		"クリティカル防御力を %ld%%+ に上げる。" },
	{ N_MSG_SKILL_HINT_SIEGE,
		"包囲攻撃。参戦人数分 %ld%%+ 攻撃力とダメージを上げる。" },
	{ N_MSG_SKILL_HINT_PHALANX,
		"防御陣形。密集人数分 %ld%%+ 防御力と装甲値を上げる。" },

	/* SKILL_GROUP_KIND_COMBO, */
	{ N_MSG_SKILL_HINT_DOUBLE_ATTACK,
		"時々 2 回近接攻撃する。 (%ld%%+)" },
	{ N_MSG_SKILL_HINT_COMBO,
		"時々 3 回格闘攻撃する。 (%ld%%+)" },
	{ N_MSG_SKILL_HINT_RAPID_SHOOT,
		"時々 2 回遠隔攻撃する。 (%ld%%+)" },
	{ N_MSG_SKILL_HINT_COUNTER,
		"敵の攻撃を受けた時、格闘で反撃する。 (%ld%%+)" },
	{ N_MSG_SKILL_HINT_TWO_SWORD_FENCING,
		"武器を 2 つ装備している時、"
		"攻撃が外れたら追加攻撃する。 (%ld%%+)" },

	/* SKILL_GROUP_KIND_DAM, */
	{ N_MSG_SKILL_HINT_DAM,
		"各属性攻撃のダメージを %ld%%+ 上げる。" },

	/* SKILL_GROUP_KIND_RESI, */
	{ N_MSG_SKILL_HINT_RESI,
		"各属性の耐性値を %ld%%+ 上げる。" },

	/* SKILL_GROUP_KIND_RESI_STAT, */
	{ N_MSG_SKILL_HINT_STAT,
		"各ステータス異常を受ける確率を 1/N+ に下げる。" },

	/* SKILL_GROUP_KIND_MISC, */
	{ N_MSG_SKILL_HINT_RUN_AWAY,
		"移動速度を %ld%%+ 速くする。" },
/* edit skill end */

/* edit pet name begin */

	{ N_MSG_PET_DATA_NAME_TTL,
		"名前を入力して下さい: " },

/* edit pet name end */

	{ N_MSG_CLR_ITEM_ALIAS,
		"空白文字を入力すると別名をクリアします" },
	{ N_MSG_GETS_ITEM_ALIAS,
		"名前: " },

/* words begin */

	{ N_MSG_OKURI_00,
		"(" },
	{ N_MSG_OKURI_01,
		"[" },
	{ N_MSG_OKURI_02,
		"{" },
	{ N_MSG_OKURI_03,
		"" },
	{ N_MSG_OKURI_04,
		"" },
	{ N_MSG_OKURI_05,
		"" },
	{ N_MSG_OKURI_06,
		"" },
	{ N_MSG_OKURI_07,
		"" },
	{ N_MSG_OKURI_08,
		"" },
	{ N_MSG_OKURI_09,
		"" },
	{ N_MSG_OKURI_10,
		"（" },
	{ N_MSG_OKURI_11,
		"〔" },
	{ N_MSG_OKURI_12,
		"［" },
	{ N_MSG_OKURI_13,
		"｛" },
	{ N_MSG_OKURI_14,
		"〈" },
	{ N_MSG_OKURI_15,
		"《" },
	{ N_MSG_OKURI_16,
		"「" },
	{ N_MSG_OKURI_17,
		"『" },
	{ N_MSG_OKURI_18,
		"【" },
	{ N_MSG_OKURI_19,
		"" },
	{ N_MSG_OKURI_20,
		"" },
	{ N_MSG_OKURI_21,
		"" },
	{ N_MSG_OKURI_22,
		"" },
	{ N_MSG_OKURI_23,
		"" },
	{ N_MSG_OKURI_24,
		"" },
	{ N_MSG_OKURI_25,
		"" },
	{ N_MSG_OKURI_26,
		"" },
	{ N_MSG_OKURI_27,
		"" },
	{ N_MSG_OKURI_28,
		"" },
	{ N_MSG_OKURI_29,
		"" },

	{ N_MSG_KIN_SOKU_00,
		")" },
	{ N_MSG_KIN_SOKU_01,
		"]" },
	{ N_MSG_KIN_SOKU_02,
		"}" },
	{ N_MSG_KIN_SOKU_03,
		"" },
	{ N_MSG_KIN_SOKU_04,
		"" },
	{ N_MSG_KIN_SOKU_05,
		"," },
	{ N_MSG_KIN_SOKU_06,
		"." },
	{ N_MSG_KIN_SOKU_07,
		"!" },
	{ N_MSG_KIN_SOKU_08,
		"?" },
	{ N_MSG_KIN_SOKU_09,
		"" },
	{ N_MSG_KIN_SOKU_10,
		"）" },
	{ N_MSG_KIN_SOKU_11,
		"〕" },
	{ N_MSG_KIN_SOKU_12,
		"］" },
	{ N_MSG_KIN_SOKU_13,
		"｝" },
	{ N_MSG_KIN_SOKU_14,
		"〉" },
	{ N_MSG_KIN_SOKU_15,
		"》" },
	{ N_MSG_KIN_SOKU_16,
		"」" },
	{ N_MSG_KIN_SOKU_17,
		"』" },
	{ N_MSG_KIN_SOKU_18,
		"】" },
	{ N_MSG_KIN_SOKU_19,
		"" },
	{ N_MSG_KIN_SOKU_20,
		"、" },
	{ N_MSG_KIN_SOKU_21,
		"。" },
	{ N_MSG_KIN_SOKU_22,
		"" },
	{ N_MSG_KIN_SOKU_23,
		"" },
	{ N_MSG_KIN_SOKU_24,
		"" },
	{ N_MSG_KIN_SOKU_25,
		"" },
	{ N_MSG_KIN_SOKU_26,
		"" },
	{ N_MSG_KIN_SOKU_27,
		"" },
	{ N_MSG_KIN_SOKU_28,
		"" },
	{ N_MSG_KIN_SOKU_29,
		"" },

	{ N_MSG_WORDS_BEGIN,
		"「" },
	{ N_MSG_WORDS_END,
		"」" },
	{ N_MSG_WORDS_NEXT,
		"  " },

	{ N_MSG_FMT_DRAW_WORDS_NAME,
		"%s:" },

/* welcome */
	{ N_MSG_WORDS_WELCOME_SHOP_INN_FEMALE,
		"さぞや御疲れでしょう。フカフカのベッドでお休み下さいませ。" },
	{ N_MSG_WORDS_WELCOME_SHOP_INN_MALE,
		"さぞや御疲れでしょう。フカフカのベッドでお休み下さい。" },
	{ N_MSG_WORDS_WELCOME_SHOP_BAR_FEMALE,
		"お客さん。うちのエールは最高でしょ？" },
	{ N_MSG_WORDS_WELCOME_SHOP_BAR_MALE,
		"お客さん。うちのエールは最高だよ！" },
	{ N_MSG_WORDS_WELCOME_SHOP_WPN_FEMALE,
		"いかなる防具も貫く武器はどう？" },
	{ N_MSG_WORDS_WELCOME_SHOP_WPN_MALE,
		"いかなる防具も貫く武器はどうだい？" },
	{ N_MSG_WORDS_WELCOME_SHOP_ARMOR_FEMALE,
		"どんな攻撃も防ぐ防具はいかが？" },
	{ N_MSG_WORDS_WELCOME_SHOP_ARMOR_MALE,
		"どんな攻撃も防ぐ防具はいかがかな？" },
	{ N_MSG_WORDS_WELCOME_SHOP_MAGIC_FEMALE,
		"新たな魔法を伝授しましょう。" },
	{ N_MSG_WORDS_WELCOME_SHOP_MAGIC_MALE,
		"新たな魔法を伝授しよう。" },
	{ N_MSG_WORDS_WELCOME_SHOP_TEMPLE_FEMALE,
		"さあ、祈りましょう。" },
	{ N_MSG_WORDS_WELCOME_SHOP_TEMPLE_MALE,
		"さあ、祈りなさい。" },
	{ N_MSG_WORDS_WELCOME_SHOP_ALCHEMY_FEMALE,
		"これらの魔道具は、きっと役に立つことでしょう。" },
	{ N_MSG_WORDS_WELCOME_SHOP_ALCHEMY_MALE,
		"これらの魔道具は、きっと役に立つでしょう。" },
	{ N_MSG_WORDS_WELCOME_SHOP_MUSIC_FEMALE,
		"芸術は戦いです！" },
	{ N_MSG_WORDS_WELCOME_SHOP_MUSIC_MALE,
		"芸術は戦いだ！" },
	{ N_MSG_WORDS_WELCOME_SHOP_GROCERY_FEMALE,
		"ハイ、いらっしゃい！" },
	{ N_MSG_WORDS_WELCOME_SHOP_GROCERY_MALE,
		"ヘイ、いらっしゃい！" },
	{ N_MSG_WORDS_WELCOME_SHOP_RESTAURANT_FEMALE,
		"いらっしゃいませ。最高級の料理を御用意しております。" },
	{ N_MSG_WORDS_WELCOME_SHOP_RESTAURANT_MALE,
		"いらっしゃいませ。最高級の料理を御用意しております。" },
	{ N_MSG_WORDS_WELCOME_SHOP_TEAROOM_FEMALE,
		"いらっしゃい。何になさいますか？" },
	{ N_MSG_WORDS_WELCOME_SHOP_TEAROOM_MALE,
		"いらっしゃい。何になさいます？" },
	{ N_MSG_WORDS_WELCOME_SHOP_TOBACCO_FEMALE,
		"いらっしゃい。いつものですね？" },
	{ N_MSG_WORDS_WELCOME_SHOP_TOBACCO_MALE,
		"いらっしゃい。いつものだね？" },
	{ N_MSG_WORDS_WELCOME_SHOP_PET_SHOP_FEMALE,
		"冒険のお共に頼もしい相棒を連れましょう。" },
	{ N_MSG_WORDS_WELCOME_SHOP_PET_SHOP_MALE,
		"冒険のお共に頼もしい相棒を連れては？" },

/* REQUEST */
	{ N_MSG_WORDS_REQUEST_CONTRACT_FEMALE,
		"それじゃあ、しっかり頼んだわよ。"
	},
	{ N_MSG_WORDS_REQUEST_CONTRACT_MALE,
		"それじゃあ、しっかり頼んだぜ。"
	},
	{ N_MSG_WORDS_REQUEST_CANCEL_FEMALE,
		"ふぅ…。仕方ないわね。次はちゃんとやってちょうだいよ。"
	},
	{ N_MSG_WORDS_REQUEST_CANCEL_MALE,
		"チッ！仕方がねぇな。次はちゃんとやってくれよ。"
	},
	{ N_MSG_WORDS_REQUEST_CLOSE_1_FEMALE,
		"依頼を達成してくれた様ね。"
		"報酬よ、受け取ってちょうだい。"
	},
	{ N_MSG_WORDS_REQUEST_CLOSE_1_MALE,
		"依頼を達成してくれた様だな。"
		"報酬だ、受け取ってくれ。"
	},
	{ N_MSG_WORDS_REQUEST_CLOSE_2_FEMALE,
		"また、頼むわね。"
	},
	{ N_MSG_WORDS_REQUEST_CLOSE_2_MALE,
		"また、頼むぜ。"
	},

/* REQUEST_TAME_MNSTR */
	{ N_MSG_WORDS_REQUEST_TAME_MNSTR_FIND_FEMALE,
		"あの子が良さそうね。"
	},
	{ N_MSG_WORDS_REQUEST_TAME_MNSTR_FIND_MALE,
		"あの子が良さそうだな。"
	},
	{ N_MSG_WORDS_REQUEST_TAME_MNSTR_JOIN_FEMALE,
		"キャプモン %s ！"
	},
	{ N_MSG_WORDS_REQUEST_TAME_MNSTR_JOIN_MALE,
		"キャプモン %s ！"
	},
/* REQUEST_RESCUE */
	{ N_MSG_WORDS_REQUEST_RESCUE_FIND_FEMALE,
		"助けに来たわ！もう大丈夫よ。"
	},
	{ N_MSG_WORDS_REQUEST_RESCUE_FIND_MALE,
		"助けに来たぞ！もう大丈夫だ。"
	},
	{ N_MSG_WORDS_REQUEST_RESCUE_JOIN_FEMALE,
		"私は %s です。助けに来てくれたのね？"
		"良かったぁ！もう駄目かと思ったわ。"
	},
	{ N_MSG_WORDS_REQUEST_RESCUE_JOIN_MALE,
		"俺は %s だ。助けに来てくれたのか？"
		"良かった！もう駄目かと思ったよ。"
	},
	{ N_MSG_WORDS_REQUEST_RESCUE_FINISH_FEMALE,
		"おかげで命拾いしたわ。"
		"本当に有難う。"
	},
	{ N_MSG_WORDS_REQUEST_RESCUE_FINISH_MALE,
		"おかげで命拾いしたよ。"
		"本当に有難う。"
	},
	{ N_MSG_WORDS_REQUEST_RESCUE_LIMIT_FEMALE,
		"もう耐えられないわ。一人で帰ります。"
	},
	{ N_MSG_WORDS_REQUEST_RESCUE_LIMIT_MALE,
		"もう耐えられない。一人で帰る。"
	},
/* REQUEST_TOUR_GUIDE */
	{ N_MSG_WORDS_REQUEST_TOUR_GUIDE_JOIN_FEMALE,
		"%s よ。初めてだったかしら。"
		"今回の観光、楽しみにしてるわよ。"
	},
	{ N_MSG_WORDS_REQUEST_TOUR_GUIDE_JOIN_MALE,
		"%s だ。初めてだったかな。"
		"今回の観光、楽しみにしているよ。"
	},
	{ N_MSG_WORDS_REQUEST_TOUR_GUIDE_FINISH_FEMALE,
		"んまぁ、今回は大変楽しかったわ。"
		"そのうち、また頼むわね。"
	},
	{ N_MSG_WORDS_REQUEST_TOUR_GUIDE_FINISH_MALE,
		"いやぁ、今回は大変楽しかった。"
		"そのうち、また頼むよ。"
	},
	{ N_MSG_WORDS_REQUEST_TOUR_GUIDE_LIMIT_FEMALE,
		"んもう、つまらないわね！帰らしてもらうわ。"
	},
	{ N_MSG_WORDS_REQUEST_TOUR_GUIDE_LIMIT_MALE,
		"つまらん！もう帰る。"
	},
/* REQUEST_REVENGE */
	{ N_MSG_WORDS_REQUEST_REVENGE_JOIN_FEMALE,
		"初めまして、%s です。"
		"仇討ちの手伝いよろしくお願いします。"
	},
	{ N_MSG_WORDS_REQUEST_REVENGE_JOIN_MALE,
		"初めまして、%s です。"
		"仇討ちの手伝いよろしくお願いします。"
	},
	{ N_MSG_WORDS_REQUEST_REVENGE_FIND_FEMALE,
		"ついに見つけたわ %s ！"
		"憎きかたき覚悟しなさい！！",
	},
	{ N_MSG_WORDS_REQUEST_REVENGE_FIND_MALE,
		"ついに見つけたぞ %s ！"
		"憎きかたき覚悟しろ！！",
	},
	{ N_MSG_WORDS_REQUEST_REVENGE_FINISH_FEMALE,
		"おかげで仇討ちが果たせました。有難う御座いました。"
	},
	{ N_MSG_WORDS_REQUEST_REVENGE_FINISH_MALE,
		"おかげで仇討ちが果たせた。有難う。"
	},
	{ N_MSG_WORDS_REQUEST_REVENGE_LIMIT_FEMALE,
		"もう結構です。自分一人でやります。"
	},
	{ N_MSG_WORDS_REQUEST_REVENGE_LIMIT_MALE,
		"もう結構。自分一人でやるよ。"
	},
/* REQUEST WANTED CRIMINAL */
	{ N_MSG_WORDS_REQUEST_WANTED_CRIMINAL_FIND_FEMALE,
		"見つけた！あいつが犯人の %s に間違いないわ"
	},
	{ N_MSG_WORDS_REQUEST_WANTED_CRIMINAL_FIND_MALE,
		"見つけた！あいつが犯人の %s に間違いない"
	},

/* bar */
	{ N_MSG_WORDS_ORDER_MILK_FEMALE,
		"まあ、ミルクですって。うふふ。"
	},
	{ N_MSG_WORDS_ORDER_MILK_MALE,
		"ミルクだとよ。はっはは。"
	},
	{ N_MSG_WORDS_ORDER_MILK_HIGH_LEV_FEMALE,
		"し！笑っちゃだめ。あの人はミルクで良いのよ。"
	},
	{ N_MSG_WORDS_ORDER_MILK_HIGH_LEV_MALE,
		"馬鹿、笑うな！あの方はミルクと決ってるんだよ。"
	},

/* inn */
	{ N_MSG_WORDS_DISCOUNT_DAY_FEMALE,
		"今日は %s で、割り引きセールをやっていますよ。"
	},
	{ N_MSG_WORDS_DISCOUNT_DAY_MALE,
		"今日は %s で、割り引きセールをやっていますよ。"
	},

/* rumor */
	{ N_MSG_RUMOR_001_FEMALE,
		"ブレイン先生の話では、混沌とした世界にいた神様が"
		"単純で限りある物として、この世界を創ったんだそうね。"
	},
	{ N_MSG_RUMOR_001_MALE,
		"ブレイン先生の話では、混沌とした世界にいた神様が"
		"単純で限りある物として、この世界を創ったんだそうだ。"
	},
	{ N_MSG_RUMOR_002_FEMALE,
		"世界中の寺院で戦闘不能者の回復を出来る様になった亊で、"
		"世は正に大冒険時代よね。"
	},
	{ N_MSG_RUMOR_002_MALE,
		"世界中の寺院で戦闘不能者の回復を出来る様になった亊で、"
		"世は正に大冒険時代だな。"
	},
	{ N_MSG_RUMOR_003_FEMALE,
		"最近は犯罪者が迷宮を隠れ家に利用する亊が"
		"増えて来ているらしいわね。"
	},
	{ N_MSG_RUMOR_003_MALE,
		"最近は犯罪者が迷宮を隠れ家に利用する亊が"
		"増えて来ているらしいな。"
	},
	{ N_MSG_RUMOR_004_FEMALE,
		"私の近所の家で仔犬が産まれたので、"
		"飼ってくれる人を探してるそうよ。"
	},
	{ N_MSG_RUMOR_004_MALE,
		"俺の近所の家で仔犬が産まれたので、"
		"飼ってくれる人を探してるそうだ。"
	},
	{ N_MSG_RUMOR_005_FEMALE,
		"私の近所の家で可愛い小猫が産まれたので、"
		"飼ってくれる人を探してるそうよ。"
	},
	{ N_MSG_RUMOR_005_MALE,
		"俺の近所の家で可愛い小猫が産まれたので、"
		"飼ってくれる人を探してるそうだ。"
	},
	{ N_MSG_RUMOR_006_FEMALE,
		"生まれつき邪悪な者は死んだら地獄へ落ちるには落ちるけど、"
		"地獄の番人になるそうよ。"
	},
	{ N_MSG_RUMOR_006_MALE,
		"生まれつき邪悪な者は死んだら地獄へ落ちるには落ちるが、"
		"地獄の番人になるそうだ。"
	},
	{ N_MSG_RUMOR_007_FEMALE,
		"家のお祖父ちゃんは去年亡くなってしまったんだけど、"
		"寺院でも老衰では生き返らせなくて…。"
		"寿命には勝てないって事かしら。"
	},
	{ N_MSG_RUMOR_007_MALE,
		"家のじっちゃんは去年亡くなっちまったんだが、"
		"寺院でも老衰では生き返らせなくてな…。"
		"寿命には勝てないってこった。"
	},
	{ N_MSG_RUMOR_008_FEMALE,
		"どんなにでたらめに見える事柄でも"
		"必ず何らかの法則が働いていて、"
		"意味や理由が有るんだと私は思うわ。"
	},
	{ N_MSG_RUMOR_008_MALE,
		"どんなにでたらめに見える事柄でも"
		"必ず何らかの法則が働いていて、"
		"意味や理由が有るんだと俺は思うよ。"
	},
/* bath */
	{ N_MSG_WORDS_TAKE_BATH_FAMALE,
		"ふぅぅ。"
	},
	{ N_MSG_WORDS_TAKE_BATH_MALE,
		"ふぇぇ。"
	},
	{ N_MSG_WORDS_CHR_IS_MOLESTED_FAMALE,
		"キャア！！のぞき！"
	},
	{ N_MSG_WORDS_CHR_IS_MOLESTED_MALE,
		"いやあ！！ちかん！"
	},
/* wish */
	{ N_MSG_WORDS_WISH_ARMAGEDDON,
		"ハルマゲドンの準備は整ったか？" },
	{ N_MSG_WORDS_WISH_ARMAGEDDON_YES,
		"では決戦の地へ" },
	{ N_MSG_WORDS_WISH_ARMAGEDDON_NO,
		"急ぐのだ" },
	{ N_MSG_WORDS_WISH_DAEMON,
		"ヘイ、ご主人様、どの望みを叶えやしょう？ヘッヘ。" },
	{ N_MSG_WORDS_WISH_DJINNI,
		"望みを叶えてやろう‥‥。さあ選べ。" },
	{ N_MSG_WORDS_WISH_GOD,
		"望め。さすれば与えられん。" },
/* last boss */
	{ N_MSG_WORDS_LAST_BOSS_ENCOUNTER_XEX_1,
		"これはこれは良くいらっしゃいました。お待ちしていましたよ。" },
	{ N_MSG_WORDS_LAST_BOSS_ENCOUNTER_XEX_2,
		"六つの星の雫、集めてくれたようで手間が省けました。ご苦労様です。" },
	{ N_MSG_WORDS_LAST_BOSS_ENCOUNTER_XEX_3,
		"七つ目を探している様ですが、心配には及びません。" },
	{ N_MSG_WORDS_LAST_BOSS_ENCOUNTER_XEX_4,
		"ほれこのとおり。闇の雫はすでに私が手に入れているんです。"
		"ヒィヒッ。" },
	{ N_MSG_WORDS_LAST_BOSS_ENCOUNTER_XEX_5,
		"ところで星の雫の力、みなさん今一つ理解していない様ですね。" },
	{ N_MSG_WORDS_LAST_BOSS_ENCOUNTER_XEX_6,
		"よろしい、手短に説明して差し上げましょう。" },
	{ N_MSG_WORDS_LAST_BOSS_ENCOUNTER_XEX_7,
		"星の雫とは、この世界を統べる七つの力、その源。"
		"その力を手に入れた者は王となることが出来ると言われています。" },
	{ N_MSG_WORDS_LAST_BOSS_ENCOUNTER_XEX_8,
		"そして、ここ" STR_LAST_STAGE "において、"
		"この装置を用い最後に起動した力が、"
		"この世界を一千年にわたって支配するのです。" },
	{ N_MSG_WORDS_LAST_BOSS_ENCOUNTER_XEX_9,
		"さて、私がこの装置を前にして「闇」の雫を手にしている‥‥。"
		"その意味がそろそろ飲込めて来た頃でしょうか？"
		"ヒィヒィヒッ。" },
	{ N_MSG_WORDS_LAST_BOSS_ENCOUNTER_XEX_10,
		"そういうわけで皆さんは、もう用済みということでして、"
		"消えていただくとしましょうか。"
		"それでは御二方、御任せしましたよ。" },
	{ N_MSG_WORDS_LAST_BOSS_ENCOUNTER_EXEL_1,
		"御意。" },
	{ N_MSG_WORDS_LAST_BOSS_ENCOUNTER_EXELER_1,
		"御意かしらねぇ。" },
	{ N_MSG_WORDS_LAST_BOSS_EXEL_1,
		"このエクセルが貴様達を奈落の底へ引きずり下してやろう。" },
	{ N_MSG_WORDS_LAST_BOSS_EXEL_DIE_1,
		"無念‥‥。" },
	{ N_MSG_WORDS_LAST_BOSS_EXELER_1,
		"あらぁ。エクセル君、倒されちゃったのねぇ。" },
	{ N_MSG_WORDS_LAST_BOSS_EXELER_2,
		"面倒だけど、このあたしエクセラーの出番かしらねぇ。" },
	{ N_MSG_WORDS_LAST_BOSS_EXELER_DIE_1,
		"あぁ‥‥いいわぁ。" },
	{ N_MSG_WORDS_LAST_BOSS_XEX_1,
		"王手を掛けたつもりかも知れませんが‥‥。" },
	{ N_MSG_WORDS_LAST_BOSS_XEX_2,
		"残念。私の方が一手早かった様です。"
		"装置はもう起動してしまいました。" },
	{ N_MSG_WORDS_LAST_BOSS_XEX_3,
		"さぁ、死になさい。" },
	{ N_MSG_WORDS_LAST_BOSS_XX_1,
		"我が名は「トゥエニィース」。"
		"世界の破壊と再生を司る者。" },
	{ N_MSG_WORDS_LAST_BOSS_XX_2,
		"世界を次の千年期に導く為に目覚めた。" },
	{ N_MSG_WORDS_LAST_BOSS_XX_DIE_1,
		"我が救済を不要とする世界の意思を確認した‥‥。"
		"創世は二十一番目の眷属へ引き継がれた。" },

/* words end */

	{ N_MSG_EPILOGUE,
		"六人と一匹は別れ旅立ち\n"
		"星の雫の力をかりて\n"
		"それぞれに国を築いた。\n"
		"そして人々は彼らを\n"
		"  ……  \n"
		"七星王と呼んだ。\n"
	},

/* NPC name begin */

	{ N_MSG_NPC_NAME_YOU_ANATA,
		"あなた" },
	{ N_MSG_NPC_NAME_YOU_ANATARA,
		"あなたら" },
	{ N_MSG_NPC_NAME_YOU_KIMI,
		"きみ" },
	{ N_MSG_NPC_NAME_YOU_KIMIRA,
		"きみら" },
	{ N_MSG_NPC_NAME_YOU_OMAE,
		"おまえ" },
	{ N_MSG_NPC_NAME_YOU_OMAERA,
		"おまえら" },

	{ N_MSG_NPC_NAME_FAMILY,
		"家族" },
	{ N_MSG_NPC_NAME_GRAND_MOTHER,
		"祖母" },
	{ N_MSG_NPC_NAME_GRAND_FATHER,
		"祖父" },
	{ N_MSG_NPC_NAME_MOTHER,
		"母" },
	{ N_MSG_NPC_NAME_FATHER,
		"父" },
	{ N_MSG_NPC_NAME_OLDER_SISTER,
		"姉" },
	{ N_MSG_NPC_NAME_OLDER_BROTHER,
		"兄" },
	{ N_MSG_NPC_NAME_YOUNGER_SISTER,
		"妹" },
	{ N_MSG_NPC_NAME_YOUNGER_BROTHER,
		"弟" },
	{ N_MSG_NPC_NAME_DAUGHTER,
		"娘" },
	{ N_MSG_NPC_NAME_SON,
		"息子" },
	{ N_MSG_NPC_NAME_WIFE,
		"妻" },
	{ N_MSG_NPC_NAME_HUSBAND,
		"夫" },
	{ N_MSG_NPC_NAME_GIRL_FRIEND,
		"彼女" },
	{ N_MSG_NPC_NAME_BOY_FRIEND,
		"彼氏" },

	{ N_MSG_NPC_NAME_SHOP_NULL_FEMALE,
		"店の女主人" },
	{ N_MSG_NPC_NAME_SHOP_NULL_MALE,
		"店の主人" },
	{ N_MSG_NPC_NAME_SHOP_INN_FEMALE,
		"宿屋の女将" },
	{ N_MSG_NPC_NAME_SHOP_INN_MALE,
		"宿屋の主人" },
	{ N_MSG_NPC_NAME_SHOP_BAR_FEMALE,
		"酒場の女マスター" },
	{ N_MSG_NPC_NAME_SHOP_BAR_MALE,
		"酒場のマスター" },
	{ N_MSG_NPC_NAME_SHOP_WPN_FEMALE,
		"武器屋の女主人" },
	{ N_MSG_NPC_NAME_SHOP_WPN_MALE,
		"武器屋の主人" },
	{ N_MSG_NPC_NAME_SHOP_ARMOR_FEMALE,
		"防具屋の女主人" },
	{ N_MSG_NPC_NAME_SHOP_ARMOR_MALE,
		"防具屋の主人" },
	{ N_MSG_NPC_NAME_SHOP_MAGIC_FEMALE,
		"魔法ギルドの女性担当" },
	{ N_MSG_NPC_NAME_SHOP_MAGIC_MALE,
		"魔法ギルドの担当" },
	{ N_MSG_NPC_NAME_SHOP_TEMPLE_FEMALE,
		"寺院の尼さん" },
	{ N_MSG_NPC_NAME_SHOP_TEMPLE_MALE,
		"寺院の高僧" },
	{ N_MSG_NPC_NAME_SHOP_ALCHEMY_FEMALE,
		"錬金術の店の女主人" },
	{ N_MSG_NPC_NAME_SHOP_ALCHEMY_MALE,
		"錬金術の店の主人" },
	{ N_MSG_NPC_NAME_SHOP_MUSIC_FEMALE,
		"音楽院の女性理事長" },
	{ N_MSG_NPC_NAME_SHOP_MUSIC_MALE,
		"音楽院の理事長" },
	{ N_MSG_NPC_NAME_SHOP_GROCERY_FEMALE,
		"雑貨屋の女主人" },
	{ N_MSG_NPC_NAME_SHOP_GROCERY_MALE,
		"雑貨屋の主人" },
	{ N_MSG_NPC_NAME_SHOP_RESTAURANT_FEMALE,
		"レストランの女店員" },
	{ N_MSG_NPC_NAME_SHOP_RESTAURANT_MALE,
		"レストランの店員" },
	{ N_MSG_NPC_NAME_SHOP_TEAROOM_FEMALE,
		"ティールームの女店員" },
	{ N_MSG_NPC_NAME_SHOP_TEAROOM_MALE,
		"ティールームの店員" },
	{ N_MSG_NPC_NAME_SHOP_TOBACCO_FEMALE,
		"タバコ屋の看板娘" },
	{ N_MSG_NPC_NAME_SHOP_TOBACCO_MALE,
		"タバコ屋の看板親父" },
	{ N_MSG_NPC_NAME_SHOP_PET_SHOP_FEMALE,
		"ペット・ショップの女主人" },
	{ N_MSG_NPC_NAME_SHOP_PET_SHOP_MALE,
		"ペット・ショップの主人" },

	{ N_MSG_NPC_NAME_BAR_CUSTOMER,
		"酒場の客" },

/* NPC name female begin */

	{ N_MSG_NPC_NAME_ABIGAIL,
		"アビゲイル" },
	{ N_MSG_NPC_NAME_ADA,
		"アダ" },
	{ N_MSG_NPC_NAME_ADELA,
		"アデラ" },
	{ N_MSG_NPC_NAME_ADELAIDE,
		"アダレード" },
	{ N_MSG_NPC_NAME_ADELE,
		"アデル" },
	{ N_MSG_NPC_NAME_ADELINE,
		"アデリン" },
	{ N_MSG_NPC_NAME_AGATHA,
		"アガサ" },
	{ N_MSG_NPC_NAME_AGGIE,
		"アギー" },
	{ N_MSG_NPC_NAME_AGNES,
		"アグネス" },
	{ N_MSG_NPC_NAME_ALBERTA,
		"アルバータ" },
	{ N_MSG_NPC_NAME_ALDA,
		"アルダ" },
	{ N_MSG_NPC_NAME_ALETHEA,
		"アレシア" },
	{ N_MSG_NPC_NAME_ALEXANDRA,
		"アレグザンドラ" },
	{ N_MSG_NPC_NAME_ALICE,
		"アリス" },
	{ N_MSG_NPC_NAME_ALISON,
		"アリスン" },
	{ N_MSG_NPC_NAME_ALMA,
		"アルマ" },
	{ N_MSG_NPC_NAME_ALPHA,
		"アルファ" },
	{ N_MSG_NPC_NAME_ALTHEA,
		"アルシア" },
	{ N_MSG_NPC_NAME_AMANDA,
		"アマンダ" },
	{ N_MSG_NPC_NAME_AMELIA,
		"アメリア" },
	{ N_MSG_NPC_NAME_AMY,
		"エーミー" },
	{ N_MSG_NPC_NAME_ANABEL,
		"アナベル" },
	{ N_MSG_NPC_NAME_ANASTASIA,
		"アナスタシア" },
	{ N_MSG_NPC_NAME_ANGELA,
		"アンジェラ" },
	{ N_MSG_NPC_NAME_ANGELIA,
		"アンジェリア" },
	{ N_MSG_NPC_NAME_ANGELICA,
		"アンジェリカ" },
	{ N_MSG_NPC_NAME_ANGELINA,
		"アンジェリナ" },
	{ N_MSG_NPC_NAME_ANGELINE,
		"アンジェリン" },
	{ N_MSG_NPC_NAME_ANITA,
		"アニータ" },
	{ N_MSG_NPC_NAME_ANN,
		"アン" },
	{ N_MSG_NPC_NAME_ANNA,
		"アナ" },
	{ N_MSG_NPC_NAME_ANNABELLA,
		"アナベラ" },
	{ N_MSG_NPC_NAME_ANNIE,
		"アニー" },
	{ N_MSG_NPC_NAME_ANTOINETTE,
		"アントワネット" },
	{ N_MSG_NPC_NAME_ANTONIA,
		"アントーニア" },
	{ N_MSG_NPC_NAME_APOLLONIA,
		"アポロニア" },
	{ N_MSG_NPC_NAME_APRIL,
		"エイプリル" },
	{ N_MSG_NPC_NAME_ARABELLA,
		"アラベラ" },
	{ N_MSG_NPC_NAME_ARLENE,
		"アーリン" },
	{ N_MSG_NPC_NAME_ARTEMISIA,
		"アルテミシア" },
	{ N_MSG_NPC_NAME_AUDREY,
		"オードリー" },
	{ N_MSG_NPC_NAME_AUGUSTA,
		"オーガスタ" },
	{ N_MSG_NPC_NAME_AURELIA,
		"オーレリア" },
	{ N_MSG_NPC_NAME_AVERIL,
		"エーヴリル" },
	{ N_MSG_NPC_NAME_AZALEA,
		"アゼイリア" },
	{ N_MSG_NPC_NAME_BAB,
		"バッブ" },
	{ N_MSG_NPC_NAME_BABETTE,
		"バベット" },
	{ N_MSG_NPC_NAME_BARBARA,
		"バーバラ" },
	{ N_MSG_NPC_NAME_BEATRICE,
		"ベアトリス" },
	{ N_MSG_NPC_NAME_BEATRIX,
		"ベアトリックス" },
	{ N_MSG_NPC_NAME_BECKY,
		"ベッキー" },
	{ N_MSG_NPC_NAME_BELINDA,
		"ベリンダ" },
	{ N_MSG_NPC_NAME_BELL,
		"ベル" },
	{ N_MSG_NPC_NAME_BELLA,
		"べラ" },
	{ N_MSG_NPC_NAME_BERNICE,
		"バーニス" },
	{ N_MSG_NPC_NAME_BERTHA,
		"バーサ" },
	{ N_MSG_NPC_NAME_BERYL,
		"ベリル" },
	{ N_MSG_NPC_NAME_BETTINA,
		"ベティーナ" },
	{ N_MSG_NPC_NAME_BIANCA,
		"ビアンカ" },
	{ N_MSG_NPC_NAME_BLANCHE,
		"ブランチ" },
	{ N_MSG_NPC_NAME_BONNIE,
		"ボニー" },
	{ N_MSG_NPC_NAME_BRENDA,
		"ブレンダ" },
	{ N_MSG_NPC_NAME_BRIDGET,
		"ブリジット" },
	{ N_MSG_NPC_NAME_CAMILLA,
		"カミラ" },
	{ N_MSG_NPC_NAME_CANDICE,
		"キャンディス" },
	{ N_MSG_NPC_NAME_CARMELLA,
		"カルメラ" },
	{ N_MSG_NPC_NAME_CAROLINA,
		"キャロライナ" },
	{ N_MSG_NPC_NAME_CAROLINE,
		"キャロライン" },
	{ N_MSG_NPC_NAME_CATHERINE,
		"キャサリン" },
	{ N_MSG_NPC_NAME_CECILIA,
		"セシリア" },
	{ N_MSG_NPC_NAME_CECILY,
		"セシリー" },
	{ N_MSG_NPC_NAME_CELESTE,
		"セレステ" },
	{ N_MSG_NPC_NAME_CELIA,
		"セリア" },
	{ N_MSG_NPC_NAME_CHARITY,
		"チャリティ" },
	{ N_MSG_NPC_NAME_CHARLEEN,
		"チャーリーン" },
	{ N_MSG_NPC_NAME_CHARLOTTE,
		"シャーロット" },
	{ N_MSG_NPC_NAME_CHARMIAN,
		"チャーミアン" },
	{ N_MSG_NPC_NAME_CHERE,
		"シェアー" },
	{ N_MSG_NPC_NAME_CHERRY,
		"チェリー" },
	{ N_MSG_NPC_NAME_CHERYL,
		"シェリル" },
	{ N_MSG_NPC_NAME_CHLOE,
		"クローイ" },
	{ N_MSG_NPC_NAME_CHRISTIANA,
		"クリスティアナ" },
	{ N_MSG_NPC_NAME_CHRISTINE,
		"クリスティン" },
	{ N_MSG_NPC_NAME_CINDY,
		"シンディー" },
	{ N_MSG_NPC_NAME_CLAIRE,
		"クレア" },
	{ N_MSG_NPC_NAME_CLARA,
		"クララ" },
	{ N_MSG_NPC_NAME_CLARISSA,
		"クラリッサ" },
	{ N_MSG_NPC_NAME_CLAUDIA,
		"クローディア" },
	{ N_MSG_NPC_NAME_COLLEEN,
		"コリーン" },
	{ N_MSG_NPC_NAME_CONNIE,
		"コニー" },
	{ N_MSG_NPC_NAME_CONSTANCE,
		"コンスタンス" },
	{ N_MSG_NPC_NAME_CONSUELO,
		"コンスエロー" },
	{ N_MSG_NPC_NAME_CORA,
		"コーラ" },
	{ N_MSG_NPC_NAME_CORDELIA,
		"コーデリア" },
	{ N_MSG_NPC_NAME_CORINNA,
		"コリンナ" },
	{ N_MSG_NPC_NAME_CORINNE,
		"コリン" },
	{ N_MSG_NPC_NAME_CORNELIA,
		"コーネリア" },
	{ N_MSG_NPC_NAME_CYNTHIA,
		"シンシア" },
	{ N_MSG_NPC_NAME_DAISY,
		"デージー" },
	{ N_MSG_NPC_NAME_DAMARIS,
		"ダマリス" },
	{ N_MSG_NPC_NAME_DANA,
		"ダーナ" },
	{ N_MSG_NPC_NAME_DAPHNE,
		"ダフネ" },
	{ N_MSG_NPC_NAME_DARLA,
		"ダーラ" },
	{ N_MSG_NPC_NAME_DARLENE,
		"ダーリーン" },
	{ N_MSG_NPC_NAME_DARYL,
		"ダリル" },
	{ N_MSG_NPC_NAME_DAWN,
		"ドーン" },
	{ N_MSG_NPC_NAME_DEANNA,
		"ディアナ" },
	{ N_MSG_NPC_NAME_DEBORAH,
		"デボラ" },
	{ N_MSG_NPC_NAME_DEIRDRE,
		"デイルドレ" },
	{ N_MSG_NPC_NAME_DELIA,
		"デリア" },
	{ N_MSG_NPC_NAME_DELLA,
		"デラ" },
	{ N_MSG_NPC_NAME_DELORIS,
		"デロリス" },
	{ N_MSG_NPC_NAME_DENISE,
		"デニーズ" },
	{ N_MSG_NPC_NAME_DIANA,
		"ダイアナ" },
	{ N_MSG_NPC_NAME_DIANE,
		"ダイアン" },
	{ N_MSG_NPC_NAME_DINAH,
		"ダイナ" },
	{ N_MSG_NPC_NAME_DIXIE,
		"ディクシー" },
	{ N_MSG_NPC_NAME_DOLL,
		"ドル" },
	{ N_MSG_NPC_NAME_DOLLY,
		"ドリー" },
	{ N_MSG_NPC_NAME_DONNA,
		"ドナ" },
	{ N_MSG_NPC_NAME_DORA,
		"ドーラ" },
	{ N_MSG_NPC_NAME_DOREEN,
		"ドリーン" },
	{ N_MSG_NPC_NAME_DORIS,
		"ドリス" },
	{ N_MSG_NPC_NAME_DOROTHY,
		"ドロシー" },
	{ N_MSG_NPC_NAME_DOTTY,
		"ドッティ" },
	{ N_MSG_NPC_NAME_DRUSILLA,
		"ドゥルシラ" },
	{ N_MSG_NPC_NAME_DULCIE,
		"ダルシー" },
	{ N_MSG_NPC_NAME_EDITH,
		"イーディス" },
	{ N_MSG_NPC_NAME_EDNA,
		"エドナ" },
	{ N_MSG_NPC_NAME_EFFIE,
		"エフィ" },
	{ N_MSG_NPC_NAME_EILEEN,
		"アイリーン" },
	{ N_MSG_NPC_NAME_ELAINE,
		"エレイン" },
	{ N_MSG_NPC_NAME_ELEANOR,
		"エレアノール" },
	{ N_MSG_NPC_NAME_ELEANORA,
		"エレアノーラ" },
	{ N_MSG_NPC_NAME_ELIZA,
		"イライザ" },
	{ N_MSG_NPC_NAME_ELIZABETH,
		"エリザベス" },
	{ N_MSG_NPC_NAME_ELLEN,
		"エレン" },
	{ N_MSG_NPC_NAME_ELMA,
		"エルマ" },
	{ N_MSG_NPC_NAME_ELOISE,
		"エロイーズ" },
	{ N_MSG_NPC_NAME_ELSIE,
		"エルシー" },
	{ N_MSG_NPC_NAME_ELVIRA,
		"エルヴィラ" },
	{ N_MSG_NPC_NAME_EM,
		"エム" },
	{ N_MSG_NPC_NAME_EMANUEL,
		"エマニュエル" },
	{ N_MSG_NPC_NAME_EMILY,
		"エミリー" },
	{ N_MSG_NPC_NAME_EMMA,
		"エマ" },
	{ N_MSG_NPC_NAME_EMMELINA,
		"エメリナ" },
	{ N_MSG_NPC_NAME_EMMELINE,
		"エメリン" },
	{ N_MSG_NPC_NAME_EMMY,
		"エミー" },
	{ N_MSG_NPC_NAME_ENID,
		"イーニッド" },
	{ N_MSG_NPC_NAME_ENOLA,
		"イノーラ" },
	{ N_MSG_NPC_NAME_EPPIE,
		"エピー" },
	{ N_MSG_NPC_NAME_ERICA,
		"エリカ" },
	{ N_MSG_NPC_NAME_ERMENTRUDE,
		"アーマントゥルード" },
	{ N_MSG_NPC_NAME_ERNESTINE,
		"アーネスティン" },
	{ N_MSG_NPC_NAME_ESTELLE,
		"エステル" },
	{ N_MSG_NPC_NAME_ESTHER,
		"エスター" },
	{ N_MSG_NPC_NAME_ETHEL,
		"エセル" },
	{ N_MSG_NPC_NAME_ETTA,
		"エッタ" },
	{ N_MSG_NPC_NAME_EUNICE,
		"ユーニス" },
	{ N_MSG_NPC_NAME_EUPHEMIA,
		"ユーフェミア" },
	{ N_MSG_NPC_NAME_EVA,
		"イヴァ" },
	{ N_MSG_NPC_NAME_EVADNE,
		"エヴァドニ" },
	{ N_MSG_NPC_NAME_EVANGELINE,
		"エヴァンジェリン" },
	{ N_MSG_NPC_NAME_EVE,
		"イヴ" },
	{ N_MSG_NPC_NAME_EVELYN,
		"イブリン" },
	{ N_MSG_NPC_NAME_FAITH,
		"フェイス" },
	{ N_MSG_NPC_NAME_FANNIE,
		"ファニー" },
	{ N_MSG_NPC_NAME_FAY,
		"フェイ" },
	{ N_MSG_NPC_NAME_FIONA,
		"フィオナ" },
	{ N_MSG_NPC_NAME_FLORA,
		"フローラ" },
	{ N_MSG_NPC_NAME_FLORENCE,
		"フローレンス" },
	{ N_MSG_NPC_NAME_FRANCES,
		"フランシス" },
	{ N_MSG_NPC_NAME_FRANCINE,
		"フランシン" },
	{ N_MSG_NPC_NAME_FREDA,
		"フリーダ" },
	{ N_MSG_NPC_NAME_GAIL,
		"ゲール" },
	{ N_MSG_NPC_NAME_GENEVIEVE,
		"ジェネヴィーブ" },
	{ N_MSG_NPC_NAME_GEORGIANA,
		"ジョージアーナ" },
	{ N_MSG_NPC_NAME_GEORGIE,
		"ジョージー" },
	{ N_MSG_NPC_NAME_GEORGINA,
		"ジョージナ" },
	{ N_MSG_NPC_NAME_GERALDINE,
		"ジェラルダイン" },
	{ N_MSG_NPC_NAME_GERDA,
		"ゲルダ" },
	{ N_MSG_NPC_NAME_GERTIE,
		"ガーティー" },
	{ N_MSG_NPC_NAME_GERTRUDE,
		"ガートルード" },
	{ N_MSG_NPC_NAME_GILLIAN,
		"ジリアン" },
	{ N_MSG_NPC_NAME_GINEVRA,
		"シネブラ" },
	{ N_MSG_NPC_NAME_GLADYS,
		"グラディス" },
	{ N_MSG_NPC_NAME_GLORIA,
		"グローリア" },
	{ N_MSG_NPC_NAME_GLORIANA,
		"グロリアーナ" },
	{ N_MSG_NPC_NAME_GRACE,
		"グレース" },
	{ N_MSG_NPC_NAME_GRETA,
		"グレタ" },
	{ N_MSG_NPC_NAME_GRETCHEN,
		"グレッチェン" },
	{ N_MSG_NPC_NAME_GRISELDA,
		"グリゼルダ" },
	{ N_MSG_NPC_NAME_GRIZEL,
		"グリゼル" },
	{ N_MSG_NPC_NAME_GUENDOLEN,
		"グエンドリン" },
	{ N_MSG_NPC_NAME_GUINEVERE,
		"ギネビア" },
	{ N_MSG_NPC_NAME_GWENEVERE,
		"グエナヴィア" },
	{ N_MSG_NPC_NAME_HANNAH,
		"ハナ" },
	{ N_MSG_NPC_NAME_HARRIET,
		"ハリエット" },
	{ N_MSG_NPC_NAME_HAZEL,
		"ヘーゼル" },
	{ N_MSG_NPC_NAME_HEATHER,
		"ヘザー" },
	{ N_MSG_NPC_NAME_HELEN,
		"ヘレン" },
	{ N_MSG_NPC_NAME_HELOISE,
		"ヘロイーズ" },
	{ N_MSG_NPC_NAME_HENRIETTA,
		"ヘンリエッタ" },
	{ N_MSG_NPC_NAME_HENRIETTE,
		"ヘンリエット" },
	{ N_MSG_NPC_NAME_HERMIONE,
		"ハーマイアニ" },
	{ N_MSG_NPC_NAME_HESTER,
		"ヘスター" },
	{ N_MSG_NPC_NAME_HETTIE,
		"ヘティー" },
	{ N_MSG_NPC_NAME_HILDA,
		"ヒルダ" },
	{ N_MSG_NPC_NAME_HILDEGARD,
		"ヒルデガード" },
	{ N_MSG_NPC_NAME_HOLLY,
		"ホリー" },
	{ N_MSG_NPC_NAME_HONOR,
		"オナー" },
	{ N_MSG_NPC_NAME_IDA,
		"アイダ" },
	{ N_MSG_NPC_NAME_IMOGEN,
		"イモジェン" },
	{ N_MSG_NPC_NAME_INA,
		"アイナ" },
	{ N_MSG_NPC_NAME_INEZ,
		"アイネズ" },
	{ N_MSG_NPC_NAME_INGRID,
		"イングリッド" },
	{ N_MSG_NPC_NAME_IONE,
		"アイオネ" },
	{ N_MSG_NPC_NAME_IRIS,
		"アイリス" },
	{ N_MSG_NPC_NAME_IRMA,
		"イルマ" },
	{ N_MSG_NPC_NAME_ISABEL,
		"イザベル" },
	{ N_MSG_NPC_NAME_ISADORA,
		"イサドラ" },
	{ N_MSG_NPC_NAME_JACQUELINE,
		"ジャクリーン" },
	{ N_MSG_NPC_NAME_JAEL,
		"ジェール" },
	{ N_MSG_NPC_NAME_JANE,
		"ジェーン" },
	{ N_MSG_NPC_NAME_JANET,
		"ジャネット" },
	{ N_MSG_NPC_NAME_JANICE,
		"ジャニス" },
	{ N_MSG_NPC_NAME_JANIE,
		"ジェイニー" },
	{ N_MSG_NPC_NAME_JASMINE,
		"ジャスミン" },
	{ N_MSG_NPC_NAME_JEAN,
		"ジーン" },
	{ N_MSG_NPC_NAME_JEMIMA,
		"ジェマイマ" },
	{ N_MSG_NPC_NAME_JENNIFER,
		"ジェニファー" },
	{ N_MSG_NPC_NAME_JENNY,
		"ジェニー" },
	{ N_MSG_NPC_NAME_JESSAMINE,
		"ジェサミン" },
	{ N_MSG_NPC_NAME_JESSICA,
		"ジェシカ" },
	{ N_MSG_NPC_NAME_JESSIE,
		"ジェシー" },
	{ N_MSG_NPC_NAME_JILL,
		"ジル" },
	{ N_MSG_NPC_NAME_JOAN,
		"ジョーン" },
	{ N_MSG_NPC_NAME_JOANNA,
		"ジョアナ" },
	{ N_MSG_NPC_NAME_JOHANNA,
		"ジョーハナ" },
	{ N_MSG_NPC_NAME_JOSEPHINE,
		"ジョーセフィン" },
	{ N_MSG_NPC_NAME_JOY,
		"ジョイ" },
	{ N_MSG_NPC_NAME_JOYCE,
		"ジョイス" },
	{ N_MSG_NPC_NAME_JUDITH,
		"ジュディス" },
	{ N_MSG_NPC_NAME_JULIA,
		"ジュリア" },
	{ N_MSG_NPC_NAME_JULIANA,
		"ジュリアナ" },
	{ N_MSG_NPC_NAME_JULIET,
		"ジュリエット" },
	{ N_MSG_NPC_NAME_JUNE,
		"ジューン" },
	{ N_MSG_NPC_NAME_JUSTINA,
		"ジャスティーナ" },
	{ N_MSG_NPC_NAME_JUSTINE,
		"ジャスティン" },
	{ N_MSG_NPC_NAME_KAREN,
		"カレン" },
	{ N_MSG_NPC_NAME_KATE,
		"ケート" },
	{ N_MSG_NPC_NAME_KATHLEEN,
		"キャスリーン" },
	{ N_MSG_NPC_NAME_KATHLYN,
		"キャスリン" },
	{ N_MSG_NPC_NAME_KATHY,
		"キャシー" },
	{ N_MSG_NPC_NAME_KATINA,
		"カティーナ" },
	{ N_MSG_NPC_NAME_KATRINA,
		"カトリーナ" },
	{ N_MSG_NPC_NAME_KAY,
		"ケイ" },
	{ N_MSG_NPC_NAME_KEZIA,
		"キザイア" },
	{ N_MSG_NPC_NAME_KITTY,
		"キティ" },
	{ N_MSG_NPC_NAME_LAETITIA,
		"ラティーシャ" },
	{ N_MSG_NPC_NAME_LAILA,
		"レーラ" },
	{ N_MSG_NPC_NAME_LANA,
		"ラナ" },
	{ N_MSG_NPC_NAME_LAURA,
		"ローラ" },
	{ N_MSG_NPC_NAME_LAUREL,
		"ローレル" },
	{ N_MSG_NPC_NAME_LAUREN,
		"ローレン" },
	{ N_MSG_NPC_NAME_LAVINIA,
		"ラヴィニア" },
	{ N_MSG_NPC_NAME_LEAH,
		"リア" },
	{ N_MSG_NPC_NAME_LEILA,
		"リーラ" },
	{ N_MSG_NPC_NAME_LENA,
		"レーナ" },
	{ N_MSG_NPC_NAME_LENORE,
		"レノール" },
	{ N_MSG_NPC_NAME_LEONOR,
		"レオノール" },
	{ N_MSG_NPC_NAME_LEONORA,
		"レオノーラ" },
	{ N_MSG_NPC_NAME_LETITIA,
		"レティーシャ" },
	{ N_MSG_NPC_NAME_LIB,
		"リブ" },
	{ N_MSG_NPC_NAME_LIBBY,
		"リビー" },
	{ N_MSG_NPC_NAME_LILLIAN,
		"リリアン" },
	{ N_MSG_NPC_NAME_LILY,
		"リリー" },
	{ N_MSG_NPC_NAME_LINDA,
		"リンダ" },
	{ N_MSG_NPC_NAME_LISA,
		"ライザ" },
	{ N_MSG_NPC_NAME_LOLA,
		"ローラ" },
	{ N_MSG_NPC_NAME_LOLITA,
		"ロリータ" },
	{ N_MSG_NPC_NAME_LORETTA,
		"ローレッタ" },
	{ N_MSG_NPC_NAME_LORNA,
		"ローナ" },
	{ N_MSG_NPC_NAME_LOTTIE,
		"ロッティ" },
	{ N_MSG_NPC_NAME_LOUISA,
		"ルイザ" },
	{ N_MSG_NPC_NAME_LOUISE,
		"ルイーズ" },
	{ N_MSG_NPC_NAME_LUANA,
		"ルアナ" },
	{ N_MSG_NPC_NAME_LUCILLE,
		"ルシール" },
	{ N_MSG_NPC_NAME_LUCINDA,
		"ルシンダ" },
	{ N_MSG_NPC_NAME_LUCRETIA,
		"ルクレーシャ" },
	{ N_MSG_NPC_NAME_LUCY,
		"ルーシー" },
	{ N_MSG_NPC_NAME_LUDMILLA,
		"ルドミラ" },
	{ N_MSG_NPC_NAME_LULU,
		"ルル" },
	{ N_MSG_NPC_NAME_LYDIA,
		"リディア" },
	{ N_MSG_NPC_NAME_LYNETTE,
		"リネット" },
	{ N_MSG_NPC_NAME_MABEL,
		"メーベル" },
	{ N_MSG_NPC_NAME_MADELEINE,
		"マダリーン" },
	{ N_MSG_NPC_NAME_MADELYN,
		"マデリン" },
	{ N_MSG_NPC_NAME_MAGDALEN,
		"マグダリン" },
	{ N_MSG_NPC_NAME_MAISIE,
		"メージー" },
	{ N_MSG_NPC_NAME_MAL,
		"マール" },
	{ N_MSG_NPC_NAME_MALVINA,
		"マルヴィナ" },
	{ N_MSG_NPC_NAME_MARCIA,
		"マーシャ" },
	{ N_MSG_NPC_NAME_MARGARET,
		"マーガレット" },
	{ N_MSG_NPC_NAME_MARGERY,
		"マージェリー" },
	{ N_MSG_NPC_NAME_MARGO,
		"マーゴ" },
	{ N_MSG_NPC_NAME_MARGOT,
		"マーゴット" },
	{ N_MSG_NPC_NAME_MARIA,
		"マリア" },
	{ N_MSG_NPC_NAME_MARIAN,
		"マリアン" },
	{ N_MSG_NPC_NAME_MARIE,
		"マリー" },
	{ N_MSG_NPC_NAME_MARILYN,
		"マリリン" },
	{ N_MSG_NPC_NAME_MARION,
		"マリオン" },
	{ N_MSG_NPC_NAME_MARJORIE,
		"マージョリー" },
	{ N_MSG_NPC_NAME_MARLENE,
		"マーリーン" },
	{ N_MSG_NPC_NAME_MARTHA,
		"マーサ" },
	{ N_MSG_NPC_NAME_MARTINA,
		"マルティナ" },
	{ N_MSG_NPC_NAME_MARY,
		"メアリー" },
	{ N_MSG_NPC_NAME_MATILDA,
		"マティルダ" },
	{ N_MSG_NPC_NAME_MAUD,
		"モード" },
	{ N_MSG_NPC_NAME_MAUDLIN,
		"モードリン" },
	{ N_MSG_NPC_NAME_MAUREEN,
		"モーリーン" },
	{ N_MSG_NPC_NAME_MAVIS,
		"メーヴィス" },
	{ N_MSG_NPC_NAME_MAXINE,
		"マクシーン" },
	{ N_MSG_NPC_NAME_MAY,
		"メイ" },
	{ N_MSG_NPC_NAME_MELINDA,
		"メリンダ" },
	{ N_MSG_NPC_NAME_MELISSA,
		"メリサ" },
	{ N_MSG_NPC_NAME_MELODY,
		"メロディ" },
	{ N_MSG_NPC_NAME_MELVINA,
		"メルヴィナ" },
	{ N_MSG_NPC_NAME_MERCEDES,
		"メルセデス" },
	{ N_MSG_NPC_NAME_MERCY,
		"マーシー" },
	{ N_MSG_NPC_NAME_MERIEL,
		"メリエル" },
	{ N_MSG_NPC_NAME_MICHELLE,
		"ミシェル" },
	{ N_MSG_NPC_NAME_MILDRED,
		"ミルドレッド" },
	{ N_MSG_NPC_NAME_MILLICENT,
		"ミリセント" },
	{ N_MSG_NPC_NAME_MINNIE,
		"ミニー" },
	{ N_MSG_NPC_NAME_MIRABEL,
		"ミラベル" },
	{ N_MSG_NPC_NAME_MIRANDA,
		"ミランダ" },
	{ N_MSG_NPC_NAME_MIRIAM,
		"ミリアム" },
	{ N_MSG_NPC_NAME_MOIRA,
		"モイラ" },
	{ N_MSG_NPC_NAME_MOLLY,
		"モーリー" },
	{ N_MSG_NPC_NAME_MONA,
		"モーナ" },
	{ N_MSG_NPC_NAME_MONICA,
		"モニカ" },
	{ N_MSG_NPC_NAME_MURIEL,
		"ミュリエル" },
	{ N_MSG_NPC_NAME_MYRA,
		"マイラ" },
	{ N_MSG_NPC_NAME_MYRTLE,
		"マートル" },
	{ N_MSG_NPC_NAME_NADINE,
		"ナディーン" },
	{ N_MSG_NPC_NAME_NAN,
		"ナン" },
	{ N_MSG_NPC_NAME_NANCY,
		"ナンシー" },
	{ N_MSG_NPC_NAME_NATALIA,
		"ナタリア" },
	{ N_MSG_NPC_NAME_NATALIE,
		"ナタリー" },
	{ N_MSG_NPC_NAME_NATASHA,
		"ナターシャ" },
	{ N_MSG_NPC_NAME_NELLIE,
		"ネリー" },
	{ N_MSG_NPC_NAME_NINA,
		"ニーナ" },
	{ N_MSG_NPC_NAME_NORA,
		"ノーラ" },
	{ N_MSG_NPC_NAME_NOREEN,
		"ノーリーン" },
	{ N_MSG_NPC_NAME_NORMA,
		"ノーマ" },
	{ N_MSG_NPC_NAME_OLIVE,
		"オリーヴ" },
	{ N_MSG_NPC_NAME_OLIVIA,
		"オリビア" },
	{ N_MSG_NPC_NAME_OLYMPIA,
		"オリンピア" },
	{ N_MSG_NPC_NAME_OPHELIA,
		"オーフェリア" },
	{ N_MSG_NPC_NAME_ORIANA,
		"オリアーナ" },
	{ N_MSG_NPC_NAME_PAMELA,
		"パメラ" },
	{ N_MSG_NPC_NAME_PANSY,
		"パンジー" },
	{ N_MSG_NPC_NAME_PATRICIA,
		"パトリシア" },
	{ N_MSG_NPC_NAME_PATSY,
		"パッツィー" },
	{ N_MSG_NPC_NAME_PATTY,
		"パティ" },
	{ N_MSG_NPC_NAME_PEARL,
		"パール" },
	{ N_MSG_NPC_NAME_PENELOPE,
		"ペネロペー" },
	{ N_MSG_NPC_NAME_PERSIS,
		"パーシス" },
	{ N_MSG_NPC_NAME_PHILIPPA,
		"フィリッパ" },
	{ N_MSG_NPC_NAME_PHOEBE,
		"フィービー" },
	{ N_MSG_NPC_NAME_PHYLLIS,
		"フィリス" },
	{ N_MSG_NPC_NAME_POLL,
		"ポール" },
	{ N_MSG_NPC_NAME_POLLY,
		"ポリー" },
	{ N_MSG_NPC_NAME_PRISCILLA,
		"プリシラ" },
	{ N_MSG_NPC_NAME_PRISSY,
		"プリシー" },
	{ N_MSG_NPC_NAME_RACHEL,
		"レーチェル" },
	{ N_MSG_NPC_NAME_RACHELLE,
		"ラシェル" },
	{ N_MSG_NPC_NAME_RAMONA,
		"ラモーナ" },
	{ N_MSG_NPC_NAME_REBECCA,
		"レベッカ" },
	{ N_MSG_NPC_NAME_REGINA,
		"レジナ" },
	{ N_MSG_NPC_NAME_RHODA,
		"ローダ" },
	{ N_MSG_NPC_NAME_RITA,
		"リタ" },
	{ N_MSG_NPC_NAME_ROBERTA,
		"ロバータ" },
	{ N_MSG_NPC_NAME_ROMY,
		"ロミー" },
	{ N_MSG_NPC_NAME_ROSE,
		"ローズ" },
	{ N_MSG_NPC_NAME_ROSEMARY,
		"ローズマリー" },
	{ N_MSG_NPC_NAME_ROWENA,
		"ローウェーナ" },
	{ N_MSG_NPC_NAME_RUBY,
		"ルビー" },
	{ N_MSG_NPC_NAME_RUTH,
		"ルース" },
	{ N_MSG_NPC_NAME_SADIE,
		"セイディ" },
	{ N_MSG_NPC_NAME_SALLIE,
		"サリー" },
	{ N_MSG_NPC_NAME_SAMANTHA,
		"サマンサ" },
	{ N_MSG_NPC_NAME_SARAH,
		"サラ" },
	{ N_MSG_NPC_NAME_SELINA,
		"セリーナ" },
	{ N_MSG_NPC_NAME_SELMA,
		"セルマ" },
	{ N_MSG_NPC_NAME_SERAPHINA,
		"セラフィーナ" },
	{ N_MSG_NPC_NAME_SHARON,
		"シャロン" },
	{ N_MSG_NPC_NAME_SHEILA,
		"シーラ" },
	{ N_MSG_NPC_NAME_SIBYL,
		"シビル" },
	{ N_MSG_NPC_NAME_SILVIA,
		"シルビア" },
	{ N_MSG_NPC_NAME_SONIA,
		"ソーニャ" },
	{ N_MSG_NPC_NAME_SOPHIA,
		"ソフィア" },
	{ N_MSG_NPC_NAME_SOPHIE,
		"ソフィー" },
	{ N_MSG_NPC_NAME_STELLA,
		"ステラ" },
	{ N_MSG_NPC_NAME_STEPHANIE,
		"ステファニー" },
	{ N_MSG_NPC_NAME_SUKEY,
		"スーキー" },
	{ N_MSG_NPC_NAME_SUSAN,
		"スーザン" },
	{ N_MSG_NPC_NAME_SUSANNA,
		"スザンナ" },
	{ N_MSG_NPC_NAME_SUSIE,
		"スージー" },
	{ N_MSG_NPC_NAME_SUZANNE,
		"スザンヌ" },
	{ N_MSG_NPC_NAME_TABITHA,
		"タバサ" },
	{ N_MSG_NPC_NAME_TALIA,
		"タリア" },
	{ N_MSG_NPC_NAME_TALLULAH,
		"タルラー" },
	{ N_MSG_NPC_NAME_TAMAR,
		"タマル" },
	{ N_MSG_NPC_NAME_THELMA,
		"セルマ" },
	{ N_MSG_NPC_NAME_THERESA,
		"テレサ" },
	{ N_MSG_NPC_NAME_TIFFANY,
		"ティファニー" },
	{ N_MSG_NPC_NAME_TRIXIE,
		"トリクシー" },
	{ N_MSG_NPC_NAME_UNA,
		"ウナ" },
	{ N_MSG_NPC_NAME_URSULA,
		"アーシュラ" },
	{ N_MSG_NPC_NAME_VALERIA,
		"ヴァレリア" },
	{ N_MSG_NPC_NAME_VALERIE,
		"ヴァレリー" },
	{ N_MSG_NPC_NAME_VENUS,
		"ヴィーナス" },
	{ N_MSG_NPC_NAME_VERA,
		"ヴェラ" },
	{ N_MSG_NPC_NAME_VERONICA,
		"ヴェロニカ" },
	{ N_MSG_NPC_NAME_VICTORIA,
		"ビクトリア" },
	{ N_MSG_NPC_NAME_VIOLA,
		"ヴァイオラ" },
	{ N_MSG_NPC_NAME_VIOLET,
		"ヴァイオレット" },
	{ N_MSG_NPC_NAME_VIRGINIA,
		"ヴァージニア" },
	{ N_MSG_NPC_NAME_VIVIEN,
		"ヴィヴィアン" },
	{ N_MSG_NPC_NAME_WANDA,
		"ワンダ" },
	{ N_MSG_NPC_NAME_WENDY,
		"ウェンディ" },
	{ N_MSG_NPC_NAME_WINIFRED,
		"ウィニフレッド" },
	{ N_MSG_NPC_NAME_XANTHIPPE,
		"クサンティッペ" },
	{ N_MSG_NPC_NAME_YOLANDA,
		"ヨーランダ" },
	{ N_MSG_NPC_NAME_YVONNE,
		"イヴォンヌ" },
	{ N_MSG_NPC_NAME_ZELDA,
		"ゼルダ" },
	{ N_MSG_NPC_NAME_ZENOBIA,
		"ゼノビア" },
	{ N_MSG_NPC_NAME_ZILLAH,
		"ジラ" },

/* NPC name female end */

/* NPC name male begin */

	{ N_MSG_NPC_NAME_AARON,
		"アロン" },
	{ N_MSG_NPC_NAME_ABNER,
		"アブナー" },
	{ N_MSG_NPC_NAME_ABRAHAM,
		"エイブラハム" },
	{ N_MSG_NPC_NAME_ABRAM,
		"エイブラム" },
	{ N_MSG_NPC_NAME_ADALBERT,
		"アダルバート" },
	{ N_MSG_NPC_NAME_ADAM,
		"アダム" },
	{ N_MSG_NPC_NAME_ADLAI,
		"アドレー" },
	{ N_MSG_NPC_NAME_ADOLF,
		"アドルフ" },
	{ N_MSG_NPC_NAME_ADOLPHUS,
		"アドルファス" },
	{ N_MSG_NPC_NAME_AENEAS,
		"アイネアス" },
	{ N_MSG_NPC_NAME_ALAN,
		"アラン" },
	{ N_MSG_NPC_NAME_ALBERT,
		"アルバート" },
	{ N_MSG_NPC_NAME_ALBIN,
		"アルビン" },
	{ N_MSG_NPC_NAME_ALDHELM,
		"アルドヘルム" },
	{ N_MSG_NPC_NAME_ALDO,
		"アルドー" },
	{ N_MSG_NPC_NAME_ALDOUS,
		"アルダス" },
	{ N_MSG_NPC_NAME_ALEC,
		"アレク" },
	{ N_MSG_NPC_NAME_ALEX,
		"アレックス" },
	{ N_MSG_NPC_NAME_ALEXANDER,
		"アレクサンダー" },
	{ N_MSG_NPC_NAME_ALEXIS,
		"アレクシス" },
	{ N_MSG_NPC_NAME_ALFRED,
		"アルフレッド" },
	{ N_MSG_NPC_NAME_ALGERNON,
		"アルジャーノン" },
	{ N_MSG_NPC_NAME_ALLEN,
		"アレン" },
	{ N_MSG_NPC_NAME_ALMON,
		"アルマン" },
	{ N_MSG_NPC_NAME_ALVAH,
		"アルヴァ" },
	{ N_MSG_NPC_NAME_ALVIN,
		"アルヴィン" },
	{ N_MSG_NPC_NAME_AMBROSE,
		"アムブローズ" },
	{ N_MSG_NPC_NAME_ANDREW,
		"アンドリュー" },
	{ N_MSG_NPC_NAME_ANDY,
		"アンディ" },
	{ N_MSG_NPC_NAME_ANGUS,
		"アンガス" },
	{ N_MSG_NPC_NAME_ANSEL,
		"アンセル" },
	{ N_MSG_NPC_NAME_ANSELM,
		"アンセルム" },
	{ N_MSG_NPC_NAME_ANTHONY,
		"アンソニー" },
	{ N_MSG_NPC_NAME_ARCHIBALD,
		"アーチボルド" },
	{ N_MSG_NPC_NAME_ARCHIE,
		"アーチー" },
	{ N_MSG_NPC_NAME_ARNOLD,
		"アーノルド" },
	{ N_MSG_NPC_NAME_ARTHUR,
		"アーサー" },
	{ N_MSG_NPC_NAME_ASA,
		"アーサ" },
	{ N_MSG_NPC_NAME_AUBREY,
		"オーブリー" },
	{ N_MSG_NPC_NAME_AUGUST,
		"オーガスト" },
	{ N_MSG_NPC_NAME_AUGUSTUS,
		"オーガスタス" },
	{ N_MSG_NPC_NAME_AYLMER,
		"エイルマー" },
	{ N_MSG_NPC_NAME_BARNABAS,
		"バーナバス" },
	{ N_MSG_NPC_NAME_BARNABY,
		"バーナビー" },
	{ N_MSG_NPC_NAME_BARRY,
		"バリー" },
	{ N_MSG_NPC_NAME_BARTHOLOMEW,
		"バーソロミュ" },
	{ N_MSG_NPC_NAME_BASIL,
		"バジル" },
	{ N_MSG_NPC_NAME_BENJAMIN,
		"ベンジャミン" },
	{ N_MSG_NPC_NAME_BENNET,
		"ベネット" },
	{ N_MSG_NPC_NAME_BERNARD,
		"バーナード" },
	{ N_MSG_NPC_NAME_BERNHARD,
		"バーンハード" },
	{ N_MSG_NPC_NAME_BERT,
		"バート" },
	{ N_MSG_NPC_NAME_BERTRAM,
		"バートラム" },
	{ N_MSG_NPC_NAME_BERTRAND,
		"バートランド" },
	{ N_MSG_NPC_NAME_BOB,
		"ボブ" },
	{ N_MSG_NPC_NAME_BORIS,
		"ボリス" },
	{ N_MSG_NPC_NAME_BRENDAN,
		"ブレンダン" },
	{ N_MSG_NPC_NAME_BRIAN,
		"ブライアン" },
	{ N_MSG_NPC_NAME_BRUCE,
		"ブルース" },
	{ N_MSG_NPC_NAME_BUD,
		"バッド" },
	{ N_MSG_NPC_NAME_BUDDY,
		"バディ" },
	{ N_MSG_NPC_NAME_CALVIN,
		"カルヴィン" },
	{ N_MSG_NPC_NAME_CAMERON,
		"キャメロン" },
	{ N_MSG_NPC_NAME_CARL,
		"カール" },
	{ N_MSG_NPC_NAME_CASSANDRA,
		"カサンドラ" },
	{ N_MSG_NPC_NAME_CASSIUS,
		"キャシアス" },
	{ N_MSG_NPC_NAME_CECIL,
		"セシル" },
	{ N_MSG_NPC_NAME_CEDRIC,
		"セドリック" },
	{ N_MSG_NPC_NAME_CEPHAS,
		"セーファス" },
	{ N_MSG_NPC_NAME_CHAD,
		"チャド" },
	{ N_MSG_NPC_NAME_CHARLES,
		"チャールズ" },
	{ N_MSG_NPC_NAME_CHESTER,
		"チェスター" },
	{ N_MSG_NPC_NAME_CHRISTOPHER,
		"クリストファー" },
	{ N_MSG_NPC_NAME_CLARENCE,
		"クラレンス" },
	{ N_MSG_NPC_NAME_CLARK,
		"クラーク" },
	{ N_MSG_NPC_NAME_CLAUD,
		"クロード" },
	{ N_MSG_NPC_NAME_CLEMENT,
		"クレメント" },
	{ N_MSG_NPC_NAME_CLIFFORD,
		"クリフォード" },
	{ N_MSG_NPC_NAME_CLYDE,
		"クライド" },
	{ N_MSG_NPC_NAME_COLIN,
		"コリン" },
	{ N_MSG_NPC_NAME_CONRAD,
		"コンラッド" },
	{ N_MSG_NPC_NAME_CONSTANT,
		"コンスタント" },
	{ N_MSG_NPC_NAME_CORNELIUS,
		"コーネリアス" },
	{ N_MSG_NPC_NAME_CURTIS,
		"カーチス" },
	{ N_MSG_NPC_NAME_CYRIL,
		"シリル" },
	{ N_MSG_NPC_NAME_CYRUS,
		"サイラス" },
	{ N_MSG_NPC_NAME_DALE,
		"デール" },
	{ N_MSG_NPC_NAME_DAMON,
		"ダモン" },
	{ N_MSG_NPC_NAME_DAN,
		"ダン" },
	{ N_MSG_NPC_NAME_DANIEL,
		"ダニエル" },
	{ N_MSG_NPC_NAME_DARIUS,
		"ダリウス" },
	{ N_MSG_NPC_NAME_DATUS,
		"データス" },
	{ N_MSG_NPC_NAME_DAVID,
		"デーヴィッド" },
	{ N_MSG_NPC_NAME_DEAN,
		"ディーン" },
	{ N_MSG_NPC_NAME_DENNIS,
		"デニス" },
	{ N_MSG_NPC_NAME_DEREK,
		"デリク" },
	{ N_MSG_NPC_NAME_DICK,
		"ディック" },
	{ N_MSG_NPC_NAME_DONALD,
		"ドナルド" },
	{ N_MSG_NPC_NAME_DOUGAL,
		"ドゥーガル" },
	{ N_MSG_NPC_NAME_DOUGLAS,
		"ダグラス" },
	{ N_MSG_NPC_NAME_DUANE,
		"ドゥエイン" },
	{ N_MSG_NPC_NAME_DUDLEY,
		"ダッドリー" },
	{ N_MSG_NPC_NAME_DUGALD,
		"ドゥーガルド" },
	{ N_MSG_NPC_NAME_DUKE,
		"デューク" },
	{ N_MSG_NPC_NAME_DUNCAN,
		"ダンカン" },
	{ N_MSG_NPC_NAME_DWAYNE,
		"ドゥエイン" },
	{ N_MSG_NPC_NAME_DWIGHT,
		"ドゥワイト" },
	{ N_MSG_NPC_NAME_EARL,
		"アール" },
	{ N_MSG_NPC_NAME_EDGAR,
		"エドガー" },
	{ N_MSG_NPC_NAME_EDMUND,
		"エドマンド" },
	{ N_MSG_NPC_NAME_EDWARD,
		"エドワード" },
	{ N_MSG_NPC_NAME_EDWIN,
		"エドウィン" },
	{ N_MSG_NPC_NAME_EGBERT,
		"エグバート" },
	{ N_MSG_NPC_NAME_ELBERT,
		"エルバート" },
	{ N_MSG_NPC_NAME_ELIAS,
		"エリアス" },
	{ N_MSG_NPC_NAME_ELIPHALET,
		"エリファレット" },
	{ N_MSG_NPC_NAME_ELLA,
		"エラ" },
	{ N_MSG_NPC_NAME_ELMER,
		"エルマー" },
	{ N_MSG_NPC_NAME_ENOCH,
		"イーノック" },
	{ N_MSG_NPC_NAME_ENOS,
		"イーノス" },
	{ N_MSG_NPC_NAME_ERIC,
		"エリック" },
	{ N_MSG_NPC_NAME_ERNEST,
		"アーネスト" },
	{ N_MSG_NPC_NAME_ETHELBERT,
		"エセルバート" },
	{ N_MSG_NPC_NAME_EUGENE,
		"ユージン" },
	{ N_MSG_NPC_NAME_EWEN,
		"ユーイン" },
	{ N_MSG_NPC_NAME_EZRA,
		"エズラ" },
	{ N_MSG_NPC_NAME_FABIAN,
		"フェビアン" },
	{ N_MSG_NPC_NAME_FELIX,
		"フェリックス" },
	{ N_MSG_NPC_NAME_FRANCIS,
		"フランシス" },
	{ N_MSG_NPC_NAME_FRANK,
		"フランク" },
	{ N_MSG_NPC_NAME_FRANKLIN,
		"フランクリン" },
	{ N_MSG_NPC_NAME_FREDERICK,
		"フレデリック" },
	{ N_MSG_NPC_NAME_GABRIEL,
		"ガブリエル" },
	{ N_MSG_NPC_NAME_GAD,
		"ガッド" },
	{ N_MSG_NPC_NAME_GAMALIEL,
		"ガマリエル" },
	{ N_MSG_NPC_NAME_GARY,
		"ゲーリー" },
	{ N_MSG_NPC_NAME_GEOFFREY,
		"ジェフリー" },
	{ N_MSG_NPC_NAME_GEORGE,
		"ジョージ" },
	{ N_MSG_NPC_NAME_GERALD,
		"ジェラルド" },
	{ N_MSG_NPC_NAME_GERARD,
		"ジェラード" },
	{ N_MSG_NPC_NAME_GERRY,
		"ジェリー" },
	{ N_MSG_NPC_NAME_GILBERT,
		"ギルバート" },
	{ N_MSG_NPC_NAME_GILES,
		"ジャイルズ" },
	{ N_MSG_NPC_NAME_GLENN,
		"グレン" },
	{ N_MSG_NPC_NAME_GODFREY,
		"ガドフリー" },
	{ N_MSG_NPC_NAME_GORDON,
		"ゴードン" },
	{ N_MSG_NPC_NAME_GREGORY,
		"グレゴリー" },
	{ N_MSG_NPC_NAME_GRIFFIN,
		"グリフィン" },
	{ N_MSG_NPC_NAME_GRIFFITH,
		"グリフィス" },
	{ N_MSG_NPC_NAME_GUS,
		"ガス" },
	{ N_MSG_NPC_NAME_GUSTAVUS,
		"グスタヴス" },
	{ N_MSG_NPC_NAME_GUY,
		"ガイ" },
	{ N_MSG_NPC_NAME_HAMILTON,
		"ハミルトン" },
	{ N_MSG_NPC_NAME_HANNIBAL,
		"ハンニバル" },
	{ N_MSG_NPC_NAME_HAROLD,
		"ハロルド" },
	{ N_MSG_NPC_NAME_HARRY,
		"ハリー" },
	{ N_MSG_NPC_NAME_HARVEY,
		"ハーヴィー" },
	{ N_MSG_NPC_NAME_HECTOR,
		"ヘクター" },
	{ N_MSG_NPC_NAME_HENRY,
		"ヘンリー" },
	{ N_MSG_NPC_NAME_HERBERT,
		"ハーバート" },
	{ N_MSG_NPC_NAME_HERCULES,
		"ハーキュリーズ" },
	{ N_MSG_NPC_NAME_HERMAN,
		"ハーマン" },
	{ N_MSG_NPC_NAME_HIRAM,
		"ハイラム" },
	{ N_MSG_NPC_NAME_HOMER,
		"ホーマー" },
	{ N_MSG_NPC_NAME_HORACE,
		"ホリス" },
	{ N_MSG_NPC_NAME_HORATIO,
		"ホレーショ" },
	{ N_MSG_NPC_NAME_HOSEA,
		"ホゼア" },
	{ N_MSG_NPC_NAME_HOWARD,
		"ハワード" },
	{ N_MSG_NPC_NAME_HOWELL,
		"ハウエル" },
	{ N_MSG_NPC_NAME_HUBERT,
		"ヒューバート" },
	{ N_MSG_NPC_NAME_HUGH,
		"ヒュー" },
	{ N_MSG_NPC_NAME_HUGO,
		"ヒューゴー" },
	{ N_MSG_NPC_NAME_HUMPHREY,
		"ハンフリー" },
	{ N_MSG_NPC_NAME_IAN,
		"イアン" },
	{ N_MSG_NPC_NAME_ION,
		"アイオン" },
	{ N_MSG_NPC_NAME_IRA,
		"アイラ" },
	{ N_MSG_NPC_NAME_IRVINE,
		"アーヴィン" },
	{ N_MSG_NPC_NAME_IRVING,
		"アーヴィング" },
	{ N_MSG_NPC_NAME_ISAAC,
		"アイザック" },
	{ N_MSG_NPC_NAME_ISADOR,
		"イザドル" },
	{ N_MSG_NPC_NAME_ISHMAEL,
		"イシュメル" },
	{ N_MSG_NPC_NAME_IVAN,
		"アイヴァン" },
	{ N_MSG_NPC_NAME_IVY,
		"アイヴィー" },
	{ N_MSG_NPC_NAME_JABEZ,
		"ジェービズ" },
	{ N_MSG_NPC_NAME_JACK,
		"ジャック" },
	{ N_MSG_NPC_NAME_JACKSON,
		"ジャクソン" },
	{ N_MSG_NPC_NAME_JACOB,
		"ジェーコブ" },
	{ N_MSG_NPC_NAME_JAIR,
		"ジェイル" },
	{ N_MSG_NPC_NAME_JAIRUS,
		"ジェイラス" },
	{ N_MSG_NPC_NAME_JAMES,
		"ジェームズ" },
	{ N_MSG_NPC_NAME_JAMIE,
		"ジェイミー" },
	{ N_MSG_NPC_NAME_JASON,
		"ジェーソン" },
	{ N_MSG_NPC_NAME_JASPER,
		"ジャスパー" },
	{ N_MSG_NPC_NAME_JEDIDIAH,
		"ジェディディア" },
	{ N_MSG_NPC_NAME_JEHU,
		"ジェヒュー" },
	{ N_MSG_NPC_NAME_JEREMIAH,
		"ジェレマイア" },
	{ N_MSG_NPC_NAME_JEREMY,
		"ジェレミー" },
	{ N_MSG_NPC_NAME_JEROBOAM,
		"ジェロボーム" },
	{ N_MSG_NPC_NAME_JEROME,
		"ジェローム" },
	{ N_MSG_NPC_NAME_JESSE,
		"ジェシー" },
	{ N_MSG_NPC_NAME_JIM,
		"ジム" },
	{ N_MSG_NPC_NAME_JIMMY,
		"ジミー" },
	{ N_MSG_NPC_NAME_JOB,
		"ジョブ" },
	{ N_MSG_NPC_NAME_JOEL,
		"ジョーエル" },
	{ N_MSG_NPC_NAME_JOHN,
		"ジョン" },
	{ N_MSG_NPC_NAME_JOHNNY,
		"ジョニー" },
	{ N_MSG_NPC_NAME_JONAS,
		"ジョナス" },
	{ N_MSG_NPC_NAME_JONATHAN,
		"ジョナサン" },
	{ N_MSG_NPC_NAME_JOSEPH,
		"ジョーセフ" },
	{ N_MSG_NPC_NAME_JOSHUA,
		"ジョシュア" },
	{ N_MSG_NPC_NAME_JUDE,
		"ジュード" },
	{ N_MSG_NPC_NAME_JULIUS,
		"ジュリアス" },
	{ N_MSG_NPC_NAME_JUNIUS,
		"ジュニアス" },
	{ N_MSG_NPC_NAME_JUSTIN,
		"ジャスティン" },
	{ N_MSG_NPC_NAME_KENNETH,
		"ケネス" },
	{ N_MSG_NPC_NAME_KEVIN,
		"ケヴィン" },
	{ N_MSG_NPC_NAME_LAURENCE,
		"ローレンス" },
	{ N_MSG_NPC_NAME_LAZARUS,
		"ラザラス" },
	{ N_MSG_NPC_NAME_LEO,
		"レオ" },
	{ N_MSG_NPC_NAME_LEON,
		"レオン" },
	{ N_MSG_NPC_NAME_LEONARD,
		"レオナルド" },
	{ N_MSG_NPC_NAME_LEOPOLD,
		"レオポルド" },
	{ N_MSG_NPC_NAME_LESTER,
		"レスター" },
	{ N_MSG_NPC_NAME_LEVI,
		"レヴィー" },
	{ N_MSG_NPC_NAME_LEWIS,
		"ルイス" },
	{ N_MSG_NPC_NAME_LINUS,
		"ライナス" },
	{ N_MSG_NPC_NAME_LIONEL,
		"ライオネル" },
	{ N_MSG_NPC_NAME_LLOYD,
		"ロイド" },
	{ N_MSG_NPC_NAME_LUKE,
		"ルーク" },
	{ N_MSG_NPC_NAME_LUTHER,
		"ルーサー" },
	{ N_MSG_NPC_NAME_MALACHI,
		"マラカイ" },
	{ N_MSG_NPC_NAME_MANFRED,
		"マンフレッド" },
	{ N_MSG_NPC_NAME_MARK,
		"マーク" },
	{ N_MSG_NPC_NAME_MARMADUKE,
		"マーマデューク" },
	{ N_MSG_NPC_NAME_MARTIN,
		"マーティン" },
	{ N_MSG_NPC_NAME_MATTHEW,
		"マシュー" },
	{ N_MSG_NPC_NAME_MAURICE,
		"モーリス" },
	{ N_MSG_NPC_NAME_MAX,
		"マックス" },
	{ N_MSG_NPC_NAME_MELVIN,
		"メルヴィン" },
	{ N_MSG_NPC_NAME_MICHAEL,
		"マイケル" },
	{ N_MSG_NPC_NAME_MICK,
		"ミック" },
	{ N_MSG_NPC_NAME_MICKY,
		"ミッキー" },
	{ N_MSG_NPC_NAME_MILES,
		"マイルズ" },
	{ N_MSG_NPC_NAME_MILTON,
		"ミルトン" },
	{ N_MSG_NPC_NAME_MORGAN,
		"モーガン" },
	{ N_MSG_NPC_NAME_MOSES,
		"モーゼズ" },
	{ N_MSG_NPC_NAME_NAAMAN,
		"ナーマン" },
	{ N_MSG_NPC_NAME_NAHUM,
		"ナフム" },
	{ N_MSG_NPC_NAME_NATHAN,
		"ネイサン" },
	{ N_MSG_NPC_NAME_NATHANIEL,
		"ナサニエル" },
	{ N_MSG_NPC_NAME_NEAL,
		"ニール" },
	{ N_MSG_NPC_NAME_NICHOLAS,
		"ニコラス" },
	{ N_MSG_NPC_NAME_NOAH,
		"ノア" },
	{ N_MSG_NPC_NAME_NOEL,
		"ノエル" },
	{ N_MSG_NPC_NAME_NORMAN,
		"ノーマン" },
	{ N_MSG_NPC_NAME_OLIVER,
		"オリバー" },
	{ N_MSG_NPC_NAME_ONESIMUS,
		"オネシマス" },
	{ N_MSG_NPC_NAME_ONESIPHORUS,
		"オネシファラス" },
	{ N_MSG_NPC_NAME_OSBORN,
		"オズボーン" },
	{ N_MSG_NPC_NAME_OSCAR,
		"オスカー" },
	{ N_MSG_NPC_NAME_OSWALD,
		"オズワルド" },
	{ N_MSG_NPC_NAME_OTTO,
		"オットー" },
	{ N_MSG_NPC_NAME_OWEN,
		"オーウェン" },
	{ N_MSG_NPC_NAME_OZIAS,
		"オージアス" },
	{ N_MSG_NPC_NAME_PATRICK,
		"パトリック" },
	{ N_MSG_NPC_NAME_PAUL,
		"ポール" },
	{ N_MSG_NPC_NAME_PENUEL,
		"ペニュエル" },
	{ N_MSG_NPC_NAME_PERCEVAL,
		"パーシヴァル" },
	{ N_MSG_NPC_NAME_PERCY,
		"パーシー" },
	{ N_MSG_NPC_NAME_PETER,
		"ピーター" },
	{ N_MSG_NPC_NAME_PHILANDER,
		"フィランダー" },
	{ N_MSG_NPC_NAME_PHILIP,
		"フィリップ" },
	{ N_MSG_NPC_NAME_QUENTIN,
		"クェンテイン" },
	{ N_MSG_NPC_NAME_QUINCY,
		"クインシー" },
	{ N_MSG_NPC_NAME_RAFE,
		"レイフ" },
	{ N_MSG_NPC_NAME_RALPH,
		"ラルフ" },
	{ N_MSG_NPC_NAME_RANDAL,
		"ランダル" },
	{ N_MSG_NPC_NAME_RANDOLPH,
		"ランドルフ" },
	{ N_MSG_NPC_NAME_RAYMOND,
		"レイモンド" },
	{ N_MSG_NPC_NAME_REGGIE,
		"レジー" },
	{ N_MSG_NPC_NAME_REGINALD,
		"レジナルド" },
	{ N_MSG_NPC_NAME_REX,
		"レックス" },
	{ N_MSG_NPC_NAME_RICHARD,
		"リチャード" },
	{ N_MSG_NPC_NAME_RICK,
		"リック" },
	{ N_MSG_NPC_NAME_ROB,
		"ロブ" },
	{ N_MSG_NPC_NAME_ROBERT,
		"ロバート" },
	{ N_MSG_NPC_NAME_RODERICK,
		"ロデリック" },
	{ N_MSG_NPC_NAME_ROGER,
		"ロジャー" },
	{ N_MSG_NPC_NAME_ROLAND,
		"ローランド" },
	{ N_MSG_NPC_NAME_RONALD,
		"ロナルド" },
	{ N_MSG_NPC_NAME_ROSS,
		"ロス" },
	{ N_MSG_NPC_NAME_ROY,
		"ロイ" },
	{ N_MSG_NPC_NAME_RUDOLF,
		"ルドルフ" },
	{ N_MSG_NPC_NAME_RUFUS,
		"ルーファス" },
	{ N_MSG_NPC_NAME_RUPERT,
		"ルパート" },
	{ N_MSG_NPC_NAME_RUSSEL,
		"ラッセル" },
	{ N_MSG_NPC_NAME_SAM,
		"サム" },
	{ N_MSG_NPC_NAME_SAMMY,
		"サミー" },
	{ N_MSG_NPC_NAME_SAMUEL,
		"サミュエル" },
	{ N_MSG_NPC_NAME_SANDY,
		"サンディー" },
	{ N_MSG_NPC_NAME_SAUL,
		"ソール" },
	{ N_MSG_NPC_NAME_SCOTT,
		"スコット" },
	{ N_MSG_NPC_NAME_SHERRY,
		"シェリー" },
	{ N_MSG_NPC_NAME_SI,
		"サイ" },
	{ N_MSG_NPC_NAME_SILAS,
		"サイラス" },
	{ N_MSG_NPC_NAME_SIMON,
		"サイモン" },
	{ N_MSG_NPC_NAME_STANLEY,
		"スタンレー" },
	{ N_MSG_NPC_NAME_STEPHEN,
		"スティーブン" },
	{ N_MSG_NPC_NAME_STEVE,
		"スティーブ" },
	{ N_MSG_NPC_NAME_STEVIE,
		"スティービー" },
	{ N_MSG_NPC_NAME_STEWART,
		"スチュアート" },
	{ N_MSG_NPC_NAME_TED,
		"テッド" },
	{ N_MSG_NPC_NAME_TEDDY,
		"テディー" },
	{ N_MSG_NPC_NAME_TERENCE,
		"テレンス" },
	{ N_MSG_NPC_NAME_THADDEUS,
		"サディアス" },
	{ N_MSG_NPC_NAME_THEODORE,
		"シオドア" },
	{ N_MSG_NPC_NAME_THEOPHILUS,
		"セオフィラス" },
	{ N_MSG_NPC_NAME_THERON,
		"セロン" },
	{ N_MSG_NPC_NAME_THOMAS,
		"トーマス" },
	{ N_MSG_NPC_NAME_TIMOTHY,
		"ティモシー" },
	{ N_MSG_NPC_NAME_TITUS,
		"タイタス" },
	{ N_MSG_NPC_NAME_TOBIAS,
		"トーバイアス" },
	{ N_MSG_NPC_NAME_TOBY,
		"トービー" },
	{ N_MSG_NPC_NAME_TOM,
		"トム" },
	{ N_MSG_NPC_NAME_TONY,
		"トニー" },
	{ N_MSG_NPC_NAME_TRISTRAM,
		"トリストラム" },
	{ N_MSG_NPC_NAME_TROY,
		"トロイ" },
	{ N_MSG_NPC_NAME_ULYSSES,
		"ユリシーズ" },
	{ N_MSG_NPC_NAME_URIAH,
		"ユリア" },
	{ N_MSG_NPC_NAME_URIAN,
		"ユーリアン" },
	{ N_MSG_NPC_NAME_URIEL,
		"ユリエル" },
	{ N_MSG_NPC_NAME_VICTOR,
		"ヴィクター" },
	{ N_MSG_NPC_NAME_VINCENT,
		"ヴィンセント" },
	{ N_MSG_NPC_NAME_WALLACE,
		"ウォーレス" },
	{ N_MSG_NPC_NAME_WALT,
		"ウォルト" },
	{ N_MSG_NPC_NAME_WALTER,
		"ウォルター" },
	{ N_MSG_NPC_NAME_WARREN,
		"ウォレン" },
	{ N_MSG_NPC_NAME_WAT,
		"ワット" },
	{ N_MSG_NPC_NAME_WILFRED,
		"ウィルフレッド" },
	{ N_MSG_NPC_NAME_WILLAM,
		"ウィリアム" },
	{ N_MSG_NPC_NAME_ZANTIPPY,
		"ザンティピー" },
	{ N_MSG_NPC_NAME_ZURIEL,
		"ズリエル" },

/* NPC name male end */

/* NPC name male or female begin */

	{ N_MSG_NPC_NAME_ADRIAN,
		"エイドリアン" },
	{ N_MSG_NPC_NAME_ARIEL,
		"エーリアル" },
	{ N_MSG_NPC_NAME_CAROL,
		"キャロル" },
	{ N_MSG_NPC_NAME_CHRISTIAN,
		"クリスチャン" },
	{ N_MSG_NPC_NAME_FREDDIE,
		"フレディ" },
	{ N_MSG_NPC_NAME_HILARY,
		"ヒラリー" },
	{ N_MSG_NPC_NAME_JACKIE,
		"ジャッキー" },
	{ N_MSG_NPC_NAME_JODY,
		"ジョーディー" },
	{ N_MSG_NPC_NAME_JULIAN,
		"ジュリアン" },
	{ N_MSG_NPC_NAME_KIM,
		"キム" },
	{ N_MSG_NPC_NAME_PAT,
		"パット" },
	{ N_MSG_NPC_NAME_RAY,
		"レイ" },
	{ N_MSG_NPC_NAME_SIDNEY,
		"シドニー" },
	{ N_MSG_NPC_NAME_TERRY,
		"テリー" },
	{ N_MSG_NPC_NAME_VIVIAN,
		"ヴィヴィアン" },

	{ N_MSG_NPC_NAME_ANDREA,
		"アンドレア" },
	{ N_MSG_NPC_NAME_CLAIR,
		"クレア" },
	{ N_MSG_NPC_NAME_SHIRLEY,
		"シャーリー" },
	{ N_MSG_NPC_NAME_JOCELYN,
		"ジョスリン" },
	{ N_MSG_NPC_NAME_BEVERLY,
		"ビヴァリー" },
	{ N_MSG_NPC_NAME_HOPE,
		"ホープ" },
	{ N_MSG_NPC_NAME_MERLE,
		"マール" },
	{ N_MSG_NPC_NAME_LEE,
		"リー" },
	{ N_MSG_NPC_NAME_LYNN,
		"リン" },
	{ N_MSG_NPC_NAME_LINDSAY,
		"リンジー" },
	{ N_MSG_NPC_NAME_LESLIE,
		"レスリー" },
	{ N_MSG_NPC_NAME_ROBIN,
		"ロビン" },

/* NPC name male or female end */

/* NPC name end */

/* request begin */

	{ N_MSG_REQUEST_KIND_RARE_GOODS,
		"アイテム探索" },
	{ N_MSG_REQUEST_KIND_TAME_MNSTR,
		"キャプモン" },
	{ N_MSG_REQUEST_KIND_RESCUE,
		"救助" },
	{ N_MSG_REQUEST_KIND_TOUR_GUIDE,
		"観光案内" },
	{ N_MSG_REQUEST_KIND_EXTERMINATE,
		"モンスター退治" },
	{ N_MSG_REQUEST_KIND_REVENGE,
		"仇討ち" },
	{ N_MSG_REQUEST_KIND_WANTED_CRIMINAL,
		"賞金首" },

	{ N_MSG_REQUEST_CONTRACT_STILL,
		"    " },
	{ N_MSG_REQUEST_CONTRACT_YOU,
		"引受" },
	{ N_MSG_REQUEST_CONTRACT_OTHER,
		"  他" },
	{ N_MSG_REQUEST_CONTRACT_FINISH,
		"達成" },

	{ N_MSG_REQUEST_LIMIT,
		"%s の依頼は期限が切れた" },
	{ N_MSG_REQUEST_FINISH,
		"%s の依頼を達成した" },

	{ N_MSG_REQUEST_CONTRACT_FMT,
		"この依頼を引き受けたのは %s だ" },
	{ N_MSG_REQUEST_DO_NOT_CONTRACT,
		"この依頼を引き受けてくれないか？" },

	{ N_MSG_REQUEST_HEADING_FMT,
		"%s:%-*s:%4ld階:期限%3ld日間:"
		"報酬" STR_GOLD_SHORT_FMT_MAX },

	{ N_MSG_REQUEST_VAR_QUOTE,
		"「%s」" },

	{ N_MSG_REQUEST_DUN_LEV,
		"%s" },
	{ N_MSG_REQUEST_DUN_LEV_RANGE,
		"%sから%sの間" },

	{ N_MSG_REQUEST_MNSTR_N,
		" %ld 匹" },

	{ N_MSG_WHEN_A00,
		"寝ている間" },
	{ N_MSG_WHEN_A01,
		"買い物に出かけている間" },
	{ N_MSG_WHEN_A02,
		"外出してる間" },
	{ N_MSG_WHEN_A03,
		"旅行に行っている間" },

	{ N_MSG_WHEN_B00,
		"短い間だけ" },
	{ N_MSG_WHEN_B01,
		"長いこと" },
	{ N_MSG_WHEN_B02,
		"こないだまで" },
	{ N_MSG_WHEN_B03,
		"前々から" },
	{ N_MSG_WHEN_B04,
		"最近" },
	{ N_MSG_WHEN_B05,
		"時々" },
	{ N_MSG_WHEN_B06,
		"毎日" },

	{ N_MSG_WEAPON_00,
		"果物ナイフ" },
	{ N_MSG_WEAPON_01,
		"花瓶" },
	{ N_MSG_WEAPON_02,
		"家宝の剣" },

/* rare goods */
	{ N_MSG_REQUEST_RARE_GOODS_00,
		"${client}は${when:b}${rare_goods}"
		"の収集をしているのだが、"
		"どうしても手に入らない${rare_goods}が有るそうだ。"
		"その${rare_goods}は${monster}が持っているらしい。"
		"${monster}は${dungeon_level_range}の何処かに居るはずだ。"
		"${client}の代わりに、${rare_goods}を探して来て欲しい。"
	},

	{ N_MSG_REQUEST_RARE_GOODS_01,
		"${client}は${when:b}不幸な亊が続いているので、"
		"占い師に相談したそうだ。"
		"その占いによると${rare_goods}を手に入れれば、"
		"厄払いが出来て運が良くなるのだそうだ。"
		"${rare_goods}は${dungeon_level_range}の何処かに居る"
		"${monster}が持っている。"
		"${client}のために、${rare_goods}を探して来て欲しい。"
	},

	{ N_MSG_REQUEST_RARE_GOODS_02,
		"${client}は${when:b}迷宮を探険していたんだが、"
		"一寸油断した隙に、${monster}に${rare_goods}を"
		"奪われてしまったそうだ。"
		"${client}はその${rare_goods}を"
		"たいへん大事にしていたらしい。"
		"${monster}は${dungeon_level_range}の何処かに居るはずだ。"
		"「もう、迷宮にはもぐりたくない」と言う"
		"${client}の代わりに、"
		"${rare_goods}を探して来て欲しい。"
	},
/* tame mnstr */
	{ N_MSG_REQUEST_TAME_MNSTR_00,
		"${client}は${monster}のブリーダーをやっていて、"
		"${when:b}珍しい${monster}を探しているのだそうだ。"
		"ブリーダーギルドの噂では、変った${monster}が"
		"${dungeon_level_range}に居るとの亊だ。"
		"そこで君らに、その${monster}を探して"
		"連れ帰って来てもらいたい。"
	},

	{ N_MSG_REQUEST_TAME_MNSTR_01,
		"${client}は${monster}を使って、ある実験をしているそうだ。"
		"${when:b}${monster}の数が足りないので、"
		"君らに${monster}を探して連れ帰って来てもらいたい。"
		"${monster}は、よく${dungeon_level_range}に出るらしい。"
		"${monster}に危害を加える実験ではないそうなので、"
		"安心してくれ。"
	},
/* rescue */
	{ N_MSG_REQUEST_RESCUE_00,
		"${client}と${rescue_target}達は"
		"${when:b}一緒に迷宮を探険をしていたのだが、"
		"${rescue_target}が、${dungeon_level_range}で"
		"はぐれてしまったそうだ。"
		"${client}達の代わりに、${rescue_target}を"
		"探して連れ帰って欲しい。"
	},
/* tour guide */
	{ N_MSG_REQUEST_TOUR_GUIDE_00,
		"${client}は商売が当たって大富豪になったそうで、"
		"相当裕福な生活をしているらしい。"
		"有り余る金でありとあらゆる道楽をやり尽くした。"
		"最近はもっと刺激が欲しくなり、"
		"ついには迷宮に興味を示した。"
		"そこで、${client}を連れて迷宮に入り、"
		"${dungeon_level_range}に居る"
		"${monster}を${monster_number}ほど倒すところを"
		"観せてやって欲しい。"
		"${client}を満足させれば報酬はタップリだ。"
	},
/* exterminate */
	{ N_MSG_REQUEST_EXTERMINATE_00,
		"${client}と、その仲間達は"
		"${when:b}一緒に冒険をしていたのだが、"
		"迷宮で${monster}に仲間達が"
		"全滅させられてしまったそうだ。"
		"それ以来${client}は、"
		"恐怖のあまり迷宮に近寄れなくなってしまった。"
		"${monster}は${dungeon_level_range}の何処かに居るはずだ。"
		"どうしても復讐がしたいと言う${client}に代って、"
		"${monster}を${monster_number}倒して来て欲しい。"
	},

	{ N_MSG_REQUEST_EXTERMINATE_01,
		"錬金術師の${client}は"
		"${when:b}ある実験をしているのだが、"
		"それには${monster}の心臓が沢山必要らしい。"
		"実験で手が離せない${client}の代りに、"
		"${monster}を${monster_number}倒して来て欲しい。"
		"${monster}は${dungeon_level_range}の何処かに居るはずだ。"
	},
/* revenge */
	{ N_MSG_REQUEST_REVENGE_00,
		"${client}が${when:a}に${client_family}が"
		"強盗に殺されたそうだ。"
		"目撃者の情報によると犯人は${monster}だ。"
		"${client}は自分の手で${monster}に復讐したいそうだ。"
		"${monster}は${dungeon_level_range}の何処かに居るはずだ。"
		"${client}を連れて迷宮に潜ってくれ。"
		"${monster}を殺してくれれば報酬を渡そう。"
	},

	{ N_MSG_REQUEST_REVENGE_01,
		"${monster}と${client}の${client_family}は${when:b}"
		"${client}に内緒で不倫をしていたんだが、"
		"別れ話のもつれから${monster}が"
		"${client}の${client_family}を${weapon}で、"
		"勢い余って殺しちまったらしい。"
		"${client}は${monster}に罪を償わせたいそうだ。"
		"${monster}は${dungeon_level_range}の何処かに居るはずだ。"
		"あんたらは${client}の手助けをして、"
		"${monster}を倒してくれれば良い。"
	},

	{ N_MSG_REQUEST_REVENGE_02,
		"${client}は高利貸しの${monster}に${when:b}"
		"大金を借りていたんだが、"
		"借金のかたに大事な一人娘が売られちまった。"
		"しまいには家族バラバラになったそうだ。"
		"${monster}は${dungeon_level_range}の何処かに居るはずだ。"
		"${monster}は生かしておいては世のためにならねぇ。"
		"${client}と協力して${monster}を仕掛けて、"
		"恨みを晴らしてやってくれ。"
	},

	{ N_MSG_REQUEST_REVENGE_03,
		"${client}と${client_mate}はとても仲が良かったそうだ。"
		"しかし、${client}が${when:b}"
		"ヤバい仕事に手を出したばっかりに、"
		"${client_mate}が${monster}に暗殺されたそうだ。"
		"${client}は悔やんでも悔やみ切れないだろう……。"
		"${monster}は${dungeon_level_range}の何処かに居るはずだ。"
		"${client}と一緒に、${monster}を殺してくれれば"
		"${client}の気持ちも少しは晴れるだろう。"
	},
/* wanted criminal */
	{ N_MSG_REQUEST_WANTED_CRIMINAL_00,
		"${client}が${when:a}に${client_family}が"
		"強盗に殺されたそうだ。"
		"目撃者の情報によると犯人は${monster}だ。"
		"${monster}は${dungeon_level_range}の何処かに居るはずだ。"
		"${monster}を殺してくれれば報酬を渡そう。"
	},

	{ N_MSG_REQUEST_WANTED_CRIMINAL_01,
		"${monster}と${client}は${when:b}"
		"家族に内緒で不倫をしていたんだが、"
		"別れ話のもつれから${monster}が${client}を${weapon}で、"
		"勢い余って殺しちまったらしい。"
		"${monster}に罪を償わせなけりゃならない。"
		"${monster}は${dungeon_level_range}の何処かに居るはずだ。"
		"あんたらは${monster}を倒してくれれば良い。"
	},

	{ N_MSG_REQUEST_WANTED_CRIMINAL_02,
		"${client}は高利貸しの${monster}に${when:b}"
		"大金を借りていたんだが、"
		"借金のかたに大事な一人娘が売られちまった。"
		"しまいには家族バラバラになったそうだ。"
		"${monster}は${dungeon_level_range}の何処かに居るはずだ。"
		"${monster}は生かしておいては世のためにならねぇ。"
		"${monster}を仕掛けて、${client}の恨みを晴らしてやってくれ。"
	},

	{ N_MSG_REQUEST_WANTED_CRIMINAL_03,
		"${client}と${client_mate}はとても仲が良かったそうだ。"
		"しかし、${client}が${when:b}"
		"ヤバい仕事に手を出したばっかりに、"
		"${client_mate}が${monster}に暗殺されたそうだ。"
		"${client}は悔やんでも悔やみ切れないだろう……。"
		"${monster}は${dungeon_level_range}の何処かに居るはずだ。"
		"${monster}を殺してくれれば、"
		"${client}の気持ちも少しは晴れるだろう。"
	},
/**/

/* request end */

	{ N_MSG_FMT_MSG,
		"%-*s" },

	{ N_MSG_FMT_WPN_IDENTIFIED,
		"%c%c %2ld %s (%+ld,%+ld,%+ld)%s%s" },
	{ N_MSG_FMT_WPN_SLAYER,
		"%c%c %2ld %s %c スレイヤー"
		" (%+ld,%+ld,%+ld)%s%s" },
	{ N_MSG_FMT_WPN_NOT_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FLG_BOOMERANG,
		"(戻る)" },
	{ N_MSG_FMT_ARMOR_IDENTIFIED,
		"%c%c %2ld %s [%+ld,%+ld,%+ld]%s%s" },
	{ N_MSG_PROTECTED_ARMOR,
		" [保護]" },
	{ N_MSG_FMT_ARMOR_NOT_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_POTION_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_POTION_NOT_IDENTIFIED,
		"%c%c %2ld %sの薬" },
	{ N_MSG_FMT_SCROLL_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_SCROLL_NOT_IDENTIFIED,
		"%c%c %2ld %sの巻物" },
	{ N_MSG_FMT_SCROLL_NIN,
		"%c%c %2ld %s (レベル %ld)" },
	{ N_MSG_FMT_WAND_IDENTIFIED,
		"%c%c %2ld %sのワンド (%ld回)" },
	{ N_MSG_FMT_ROD_IDENTIFIED,
		"%c%c %2ld %sのロッド (%ld回)" },
	{ N_MSG_FMT_STAFF_IDENTIFIED,
		"%c%c %2ld %sのスタッフ (%ld回)" },
	{ N_MSG_FMT_WAND_NOT_IDENTIFIED,
		"%c%c %2ld %sのワンド" },
	{ N_MSG_FMT_ROD_NOT_IDENTIFIED,
		"%c%c %2ld %sのロッド" },
	{ N_MSG_FMT_STAFF_NOT_IDENTIFIED,
		"%c%c %2ld %sのスタッフ" },
	{ N_MSG_FMT_ACCE_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_RING_NOT_IDENTIFIED,
		"%c%c %2ld %sの指輪" },
	{ N_MSG_FMT_AMULET_NOT_IDENTIFIED,
		"%c%c %2ld %sの護符" },
	{ N_MSG_FMT_NECKLACE_NOT_IDENTIFIED,
		"%c%c %2ld %sの首飾り" },
	{ N_MSG_FMT_INST_IDENTIFIED,
		"%c%c %2ld %s%s%s" },
	{ N_MSG_FMT_INST_NOT_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_ANTHOLOGY_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_ANTHOLOGY_NOT_IDENTIFIED,
		"%c%c %2ld 伝説の詩集" },
	{ N_MSG_FMT_LIGHT_IDENTIFIED,
		"%c%c %2ld %s (%ldターン)" },
	{ N_MSG_FMT_LIGHT_NOT_IDENTIFIED,
		"%c%c %2ld %s (%ldターン)" },
	{ N_MSG_FMT_SPIKE_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_SPIKE_NOT_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_FOOD_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_FOOD_NOT_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_CHEST_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_CHEST_NOT_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_TOBACCO_IDENTIFIED,
		"%c%c %2ld %s (%s: %ld)" },
	{ N_MSG_FMT_TOBACCO_NOT_IDENTIFIED,
		"%c%c %2ld %s (%s)" },
	{ N_MSG_FMT_TOBACCO_STUB_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_PIPE_IDENTIFIED,
		"%c%c %2ld %s (%ld)" },
	{ N_MSG_FMT_PIPE_NOT_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_PIPE_STUB_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_DISPOSAL_IDENTIFIED,
		"%c%c %2ld 吸い殻入れ (%ld/%ld)" },
	{ N_MSG_FMT_RARE_GOODS_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_BONE_IDENTIFIED,
		"%c%c %2ld %sの骨" },
	{ N_MSG_FMT_COIN_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_COIN_NOT_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_JUNK_IDENTIFIED,
		"%c%c %2ld %s" },
	{ N_MSG_FMT_JUNK_NOT_IDENTIFIED,
		"%c%c %2ld %s" },

	{ N_MSG_INST_LIMIT,
		"(限定可)" },
	{ N_MSG_INST_SPELL,
		"(+%s)" },

	{ N_MSG_FMT_EQUIP_NULL,
		"%-*s:" },
	{ N_MSG_FMT_EQUIP,
		"%-*s: %s" },

	{ N_MSG_FMT_ART_NAME,
		" %-*s " STR_GOLD_SHORT_FMT_MAX },
	{ N_MSG_FMT_ART_NAME_EQUIP,
		"%-*s: %s" },

	{ N_MSG_FMT_IDENTIFY_ITEM,
		"これは %s だ" },
	{ N_MSG_FMT_MARK_MNSTR,
		"%s は %s をマークした" },

	{ N_MSG_ERR_ALLOC_MEM,
		"%ld byte のメモリーが確保出来ませんでした" },

	{ N_MSG_ERR_DOOR_OPEN_JAMMED,
		"ドアが固定されていて開けません" },
	{ N_MSG_ERR_DOOR_CLOSE_JAMMED,
		"ドアが固定されていて閉じられません" },
	{ N_MSG_ERR_DOOR_CLOSE_BROKEN,
		"ドアが壊れていて閉じられません" },
	{ N_MSG_ERR_DOOR_JAM_SPIKE,
		"%s を持っていません" },
	{ N_MSG_ERR_DOOR_JAM_BROKEN,
		"ドアが壊れていて固定出来ません" },
	{ N_MSG_ERR_DOOR_JAM_JAMMED,
		"ドアは固定されています" },
	{ N_MSG_ERR_DOOR_DISARM_NOT_JAM,
		"ドアは固定されていません" },
	{ N_MSG_ERR_DOOR_DISARM_BROKEN,
		"ドアは壊れています" },
	{ N_MSG_ERR_DOOR_DISARM_LEV,
		"ドアの" STR_DISARM "に失敗した" },
	{ N_MSG_ERR_DOOR_BREAK_SHOP,
		"そんなことをしたら怒られますよ" },
	{ N_MSG_ERR_DOOR_BREAK_BROKEN,
		"ドアは既に壊れています" },
	{ N_MSG_ERR_DOOR_BREAK_LEV,
		"%s はドアを壊せませんでした" },
	{ N_MSG_ERR_DOOR_GATE,
		"街の外には出られません" },

	{ N_MSG_ERR_TRAP_DISARM_LEV,
		"罠の" STR_DISARM "に失敗した" },
	{ N_MSG_ERR_TRAP_BREAK_LEV,
		"罠が壊せませんでした" },

	{ N_MSG_ERR_ITEM_DISARM_LEV,
		"アイテムの" STR_DISARM "に失敗した" },

	{ N_MSG_ERR_STAIRS,
		"全メンバーが階段の側にいません" },
	{ N_MSG_ERR_STAIRS_UP,
		"全メンバーが上り階段の側にいません" },
	{ N_MSG_ERR_STAIRS_DOWN,
		"全メンバーが下り階段の側にいません" },
	{ N_MSG_ERR_STAIRS_DOWN_LAST_BOSS_1,
		"見えない力に、はばまれた" },
	{ N_MSG_ERR_STAIRS_DOWN_LAST_BOSS_2,
		"何かが足りない様だ" },

	{ N_MSG_ERR_EQUIP_SEL_ITEM,
		"装備するアイテムが見つかりませんでした" },
	{ N_MSG_ERR_CHK_KEY,
		"['%c': 0x%04lx] は無効なキーです" },
	{ N_MSG_ERR_REG_MACRO_BUF_OVERFLOW,
		"マクロのキー入力が最大数を超えました" },
	{ N_MSG_ERR_NOT_EXIST_ALL_MBR,
		"メンバーが1人もいないので出れません" },

	{ N_MSG_ERR_MENU_SEL_ITEM,
		"%s の今の状態では選択出来ません" },
	{ N_MSG_ERR_MENU_SEL_EQUIP,
		"%s の今の状態では選択出来ません" },
	{ N_MSG_ERR_MENU_LS_CHEST_TRAP,
		"%s はまだ開けていません" },
	{ N_MSG_ERR_MENU_MARK_BLIND,
		"%s は目が見えないのでマーク出来ません" },
	{ N_MSG_ERR_MENU_NOT_EXIST_MBR,
		"メンバーが1人もいません" },
	{ N_MSG_ERR_MENU_WANTING,
		"%s は " STR_GOLD_FMT "足りません" },
	{ N_MSG_ERR_MENU_DATA_LEV_UP,
		"%s は経験値が足りません" },
	{ N_MSG_ERR_MENU_SPELL_LEV,
		"%s はレベルが足りません" },
	{ N_MSG_ERR_MENU_SPELL_INST_LIMIT,
		"%s は限定可能な楽器を装備していません" },
	{ N_MSG_ERR_MENU_SPELL_LAST_BOSS,
		STR_LAST_STAGE "では、この呪文は使えません" },

	{ N_MSG_ERR_MENU_SEL_JOYSTICK,
		"ジョイスティックが見つかりません" },

	{ N_MSG_ERR_SHOP_CLOSE,
		"%s の営業時間は %ld 時から %ld 時までです" },

	{ N_MSG_ERR_MENU_REQUEST,
		"依頼は有りません" },
	{ N_MSG_ERR_MENU_REQUEST_MBR_CANCEL,
		"依頼を辞退するのに、後 " STR_GOLD_FMT " 足りません" },
	{ N_MSG_ERR_MENU_REQUEST_CAN_NOT_JOIN_PET,
		"これ以上仲間を増やせません" },

	{ N_MSG_ERR_MENU_NO_SAVE,
		"ウィザード・メニューを使用したのでセーブ出来ません" },
	{ N_MSG_ERR_MENU_SAVE_N_SEL_AUTO,
		"自動セーブのスロットにはセーブ出来ません" },

	{ N_MSG_ERR_MENU_EDIT_CLASS,
		"合計を 100% にして下さい" },
	{ N_MSG_ERR_MENU_NEW_CLASS,
		"これ以上クラスを作れません" },

	{ N_MSG_ERR_MENU_PET_SHOP_BUY,
		"これ以上ペットを飼えません" },
	{ N_MSG_ERR_MENU_PET_SHOP_TAKE,
		"これ以上ペットを引き取れません" },
	{ N_MSG_ERR_MENU_PET_SHOP_LEAVE,
		"これ以上ペットを預けられません" },
	{ N_MSG_ERR_MENU_PET_SHOP_NAME,
		"ペットは飼っていません" },
	{ N_MSG_ERR_MENU_PET_SHOP_REMOVE,
		"ペットは飼っていません" },

	{ N_MSG_ERR_MENU_PAGE_OVER,
		"メニューのページが多すぎます" },
	{ N_MSG_ERR_MENU_SRCH_PATH,
		"メニューの検索が失敗しました '%s'" },
	{ N_MSG_ERR_MENU_KIND,
		"メニューの項目の種類が異常です '%s'" },
	{ N_MSG_ERR_MENU_ACCEL_KEY,
		"アクセラレータ・キーが重複しています '%c':'%s'" },
	{ N_MSG_ERR_MENU_SHORT_CUT_KEY,
		"ショートカット・キーが重複しています '%s':'%s'" },

	{ N_MSG_ERR_FILL_LAMP,
		"ランプ等を装備していません" },
	{ N_MSG_ERR_FILL_LAMP_NON_OIL,
		"%s は %s に油以外を補給した" },
	{ N_MSG_ERR_ATTACK_RANGE,
		"%s の攻撃はとどかない" },
	{ N_MSG_ERR_THROW,
		"%s の投げる物が無くなりました" },
	{ N_MSG_ERR_THROW_RANGE,
		"%s の投げる物はとどかない" },
	{ N_MSG_ERR_MNSTR_NULL,
		"そこにはモンスターはいません" },
	{ N_MSG_ERR_NOT_FIND,
		"%s からは %s が見えません" },
	{ N_MSG_ERR_ITEM_CURSE,
		"%s は呪われていて外せません" },
	{ N_MSG_ERR_ITEM_FULL,
		"%s は持ち物がいっぱいです" },
	{ N_MSG_ERR_ITEM_FLY,
		"%s は浮かんでいるのでアイテムを拾えません" },
	{ N_MSG_ERR_GIVE_MBR_ITEM,
		"%s は持ち物がいっぱいでアイテムを持てません" },
	{ N_MSG_ERR_GIVE_MBR_CHEST,
		"%s は重くてこれ以上アイテムを持てません" },
	{ N_MSG_ERR_HAVE_NOT_CHEST,
		"%s は宝箱を持っていません" },
	{ N_MSG_ERR_CHEST_IS_FULL,
		"%s は宝箱にこれ以上アイテムを入れられません" },
	{ N_MSG_ERR_ITEM_BREAK_BROKEN,
		"%s は既に壊れています" },
	{ N_MSG_ERR_ITEM_BREAK_LEV,
		"%s は壊せませんでした" },
	{ N_MSG_ERR_ITEM_BREAK,
		"%s は壊せませんでした" },
	{ N_MSG_ERR_EQUIP_TWO_HANDED_WPN,
		"%s は両手持ち武器と盾を同時に装備出来ません" },
	{ N_MSG_ERR_EQUIP_TWO_SWORD_FENCING,
		"%s は両手持ち武器で二刀流を出来ません" },

	{ N_MSG_ERR_REMOVE_CLASS,
		"これ以上クラスを削除出来ません" },
	{ N_MSG_ERR_INIT_SKILL_GROUP,
		"スキル・テーブルに異常があります %ld/%ld" },

	{ N_MSG_ERR_ITEM_RATIO,
		"アイテムの出現数データが異常です %ld/%ld" },
	{ N_MSG_ERR_POTION_COLOR,
		"薬の色名データが異常です" },
	{ N_MSG_ERR_STICK_MATERIAL,
		"杖の材質名データが異常です" },
	{ N_MSG_ERR_ACCE_MATERIAL,
		"アクセサリの材質名データが異常です" },
	{ N_MSG_ERR_WPN_RATE_TAB,
		"武器データが異常です" },
	{ N_MSG_ERR_MNSTR_LEV_TAB,
		"モンスターのレベル・データが異常です" },
	{ N_MSG_ERR_MNSTR_LEV_TAB_DUP,
		"モンスターのレベル・データに重複があります [%s]" },
	{ N_MSG_ERR_MNSTR_LEV_TAB_NOT_DEF,
		"レベル・データに定義されていないモンスターがあります [%s]" },
	{ N_MSG_ERR_SET_TTY,
		"端末の設定が出来ませんでした" },
	{ N_MSG_ERR_HOME_DIR,
		"ホーム・ディレクトリ '%s' の設定が"
		"出来ませんでした" },
	{ N_MSG_ERR_GAME_DIR_SAVE,
		"'%s'に書き込めませんでした" },
	{ N_MSG_ERR_FILE_VER_A,
		"データ・ファイルのバージョン %ld.%ld.%ld は"
		"対応していません" },
	{ N_MSG_ERR_FILE_VER_B,
		"ゲーム本体を最新版にアップデートして下さい" },

	{ N_MSG_ERR_TOWN_MAP,
		"マップ・データが異常です" },
	{ N_MSG_ERR_TOWN_MAP_X_SIZE,
		"マップ・データの水平サイズが違います %ld/%ld" },
	{ N_MSG_ERR_TOWN_MAP_Y_SIZE,
		"マップ・データの垂直サイズが違います %ld/%ld" },
	{ N_MSG_ERR_TOWN_MAP_STR_LEN,
		"マップ・データの色を表す文字列の長さは"
		"1か2文字にして下さい %ld" },
	{ N_MSG_ERR_TOWN_MAP_SHOP,
		"マップ・データに入っていないショップが有ります" },

	{ N_MSG_ERR_CHK_CUI,
		"テキスト・モードでなければ出来ません。" },
	{ N_MSG_ERR_CHK_GUI,
		"グラフィック・モードでなければ出来ません。" },
	{ N_MSG_ERR_RC,
		"設定ファイルにエラーが有りました" },

	/* Lex */

	{ N_MSG_ERR_RC_LEX,
		"異常なトークンです ['%c', 0x%04lx]" },
	{ N_MSG_ERR_RC_LEX_CHAR,
		"文字が閉じていません" },
	{ N_MSG_ERR_RC_LEX_STR,
		"文字列が閉じていません" },

	/* Parse */

	{ N_MSG_ERR_RC_PARSE,
		"構文が間違っています" },
	{ N_MSG_ERR_RC_PARSE_DEF_ID,
		"変数名が間違っています" },
	{ N_MSG_ERR_RC_PARSE_NUM,
		"数値を指定して下さい" },
	{ N_MSG_ERR_RC_PARSE_STR,
		"文字列を指定して下さい" },
	{ N_MSG_ERR_RC_PARSE_CHAR,
		"文字を指定して下さい" },
	{ N_MSG_ERR_RC_PARSE_COMMA,
		"','が有りません" },
	{ N_MSG_ERR_RC_PARSE_SKIP_CHAR,
		"'%c'が有りません" },
	{ N_MSG_ERR_RC_PARSE_CHR_ID,
		"キャラクターが不正にコピーされました" },

	/* Data Load */

	{ N_MSG_ERR_LOAD_BIN,
		"データ・ファイルが壊れています" },
	{ N_MSG_ERR_LOAD_WQUOTE,
		"'\"' が有りません" },
	{ N_MSG_ERR_LOAD_LINE_LEN,
		"１行の文字数が合いません %ld/%ld" },
	{ N_MSG_ERR_LOAD_EOF,
		"ファイルが途中で途切れています" },
	{ N_MSG_ERR_LOAD_GAME_HEAD,
		"ヘッダが異常です" },

	/* Data Save */

	{ N_MSG_ERR_SAVE_TOWN_PTN,
		"マップ・データがセーブ出来ませんでした" },
	{ N_MSG_ERR_SAVE_CRSR_PTN,
		"カーソル・パターンがセーブ出来ませんでした" },

	/* Graph Conf Load */

	{ N_MSG_ERR_LOAD_GRAPH_CONF_HEAD,
		"ヘッダが異常です" },

	/* file */

	{ N_MSG_WRN_RENAME,
		"ファイル名を変更しました\n\t'%s' ->\n\t'%s'" },
	{ N_MSG_WRN_CHK_ID,
		"ID:\n'%s'\n'%s'" },

	/* dows */

	{ N_MSG_ERR_DOWS_CREATE_VIEW,
		"ビュー ウィンドウを作成できませんでした。\n" },
	{ N_MSG_ERR_DOWS_CREATE_TOOL_BAR,
		"ツール バーの作成に失敗しました。\n" },
	{ N_MSG_ERR_DOWS_CREATE_STATUS_BAR,
		"ステータス バーの作成に失敗しました。\n" },
	{ N_MSG_ERR_DOWS_CREATE_TIMER,
		"マルチ・メディア・タイマーが設定できませんでした。" },
	{ N_MSG_ERR_DOWS_CREATE_DIRECT3D,
		"Direct3D の初期化に失敗しました。"
		"DirectX 9.0 がインストールされているか確認してください。" },
	{ N_MSG_ERR_DOWS_GET_DISPLAY_MODE,
		"ディスプレイモードの取得に失敗しました。" },
	{ N_MSG_ERR_DOWS_CREATE_DEVICE,
		"デバイスの作成に失敗しました。"
		"画面モードが 16 ビットあるいは 32 ビットに"
		"なっていることを確認して下さい。" },

	/* Copyright */

	{ N_MSG_FMT_COPYRIGHT,
		STR_FMT_COPYRIGHT },

	{ N_MSG_ABOUT_GAME,
		"本プログラムはフリー・ソフトウェアです。\n"
		"あなたは、 Free Software Foundation が公表した"
		" GNU 一般公有使用許諾の「バージョン２」"
		"或はそれ以降の各バージョンの中からいずれかを選択し、"
		"そのバージョンが定める条項に従って本プログラムを"
		"再頒布または変更することができます。\n"
		"\n"
		"本プログラムは有用とは思いますが、頒布にあたっては、"
		"市場性及び特定目的適合性についての暗黙の保証を含めて,"
		"いかなる保証も行ないません。\n"
		"詳細については GNU 一般公有使用許諾書をお読みください。\n"
		"\n"
		"あなたは、本プログラムと一緒に GNU 一般公有使用許諾書"
		"の写しを受け取っているはずです。そうでない場合は、\n"
		"  Free Software Foundation, Inc.,\n"
		"  59 Temple Place, Suite 330, Boston, MA 02111-1307, USA\n"
		"へ手紙を書いてください。\n"
	},

	{ N_MSG__MSG_BLOCK_1_END_,
		"" },
#endif	/* SEL_MSG_BLOCK_1 */

#undef	STR_GOLD
#undef	STR_GOLD_FMT
#undef	STR_GOLD_FMT_MAX

#undef	STR_SQUARE

#undef	STR_EQUIP_WIELDING
#undef	STR_EQUIP_SHIELD
#undef	STR_EQUIP_BOW
#undef	STR_EQUIP_ARW
#undef	STR_EQUIP_HEAD
#undef	STR_EQUIP_NECK
#undef	STR_EQUIP_BODY
#undef	STR_EQUIP_ARM
#undef	STR_EQUIP_RIGHT_HAND
#undef	STR_EQUIP_LEFT_HAND
#undef	STR_EQUIP_FEET
#undef	STR_EQUIP_ABOUT_BODY
#undef	STR_EQUIP_LIGHT_SOURCE

#undef	STR_DISARM
#undef	STR_GOLD

#undef	STR_FIG
#undef	STR_MON
#undef	STR_HUN
#undef	STR_THI

#undef	STR_MAG
#undef	STR_SOR
#undef	STR_ENC
#undef	STR_SUM
#undef	STR_PRI
#undef	STR_SHA
#undef	STR_BAR
#undef	STR_NIN

#undef	STR_LAST_STAGE
