/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2010 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: play-rep.c,v 1.1 2010/05/29 14:46:53 bowkenken Exp $
***************************************************************/

/***************************************************************
* ץǡ
***************************************************************/

#define	PLAY_REP_C
#include	"inc.h"

playing_report_t	playing_report_ls_mbr[LS_MBR_MAX_N + 1];
check_memory_def( check_memory_play_rep_c_playing_report_ls_mbr )

playing_report_t	playing_report_party;
check_memory_def( check_memory_play_rep_c_playing_report_party )

void	init_playing_report( void )
{
	playing_report_t	*rep;
	long	i, j;

	/* Сץǡ */

	for( i = 0; i < LS_MBR_MAX_N + 1; i++ ){
		rep = &(playing_report_ls_mbr[i]);

		rep->paying_gold = 0;
		for( j = 0; j < STAY_INN_KIND_MAX_N; j++ ){
			rep->staying_inn[j] = 0;
		}
		for( j = 0; j < EQUIP_KIND_MAX_N; j++ ){
			rep->wearing_equip[j] = 0;
		}
		for( j = 0; j < RESI_KIND_MAX_N; j++ ){
			rep->making_dam[j] = 0;
			rep->made_dam[j] = 0;
		}
		for( j = 0; j < SPELL_KIND_MAX_N; j++ ){
			rep->using_spell[j] = 0;
			rep->used_spell[j] = 0;
		}
	}

	/* ѡƥץǡ */

	rep = &playing_report_party;

	rep->paying_gold = 0;
	for( j = 0; j < STAY_INN_KIND_MAX_N; j++ ){
		rep->staying_inn[j] = 0;
	}
	for( j = 0; j < EQUIP_KIND_MAX_N; j++ ){
		rep->wearing_equip[j] = 0;
	}
	for( j = 0; j < RESI_KIND_MAX_N; j++ ){
		rep->making_dam[j] = 0;
		rep->made_dam[j] = 0;
	}
	for( j = 0; j < SPELL_KIND_MAX_N; j++ ){
		rep->using_spell[j] = 0;
		rep->used_spell[j] = 0;
	}
}

/***************************************************************
* ץǡΡֻʧפ򹹿
* long ls_mbr_n : Сꥹֹ
* gold_t gold : 
***************************************************************/

void	update_playing_report_paying_gold(
	long ls_mbr_n, gold_t gold
)
{
	if( ls_mbr_n < 0 )
		return;
	if( ls_mbr_n >= LS_MBR_MAX_N )
		return;

	playing_report_ls_mbr[ls_mbr_n].paying_gold += gold;
	playing_report_party.paying_gold += gold;
}

/***************************************************************
* ץǡΡֽɲפ򹹿 (С)
* long ls_mbr_n : Сꥹֹ
* stay_inn_kind_t kind : μ
***************************************************************/

void	update_playing_report_staying_inn_mbr(
	long ls_mbr_n, stay_inn_kind_t kind
)
{
	if( ls_mbr_n < 0 )
		return;
	if( ls_mbr_n >= LS_MBR_MAX_N )
		return;
	if( kind < 0 )
		return;
	if( kind >= STAY_INN_KIND_MAX_N )
		return;

	playing_report_ls_mbr[ls_mbr_n].staying_inn[kind]++;
}

/***************************************************************
* ץǡΡֽɲפ򹹿 (ѡƥ)
* stay_inn_kind_t kind : μ
***************************************************************/

void	update_playing_report_staying_inn_party(
	stay_inn_kind_t kind
)
{
	if( kind < 0 )
		return;
	if( kind >= STAY_INN_KIND_MAX_N )
		return;

	playing_report_party.staying_inn[kind]++;
}

/***************************************************************
* ץǡΡפ򹹿
* long ls_mbr_n : Сꥹֹ
* equip_kind_t kind : μ
***************************************************************/

void	update_playing_report_wearing_equip(
	long ls_mbr_n, equip_kind_t kind
)
{
	if( ls_mbr_n < 0 )
		return;
	if( ls_mbr_n >= LS_MBR_MAX_N )
		return;
	if( kind < 0 )
		return;
	if( kind >= EQUIP_KIND_MAX_N )
		return;

	playing_report_ls_mbr[ls_mbr_n].wearing_equip[kind]++;
	playing_report_party.wearing_equip[kind]++;
}

/***************************************************************
* ץǡΡͿ᡼פ򹹿
* long ls_mbr_n : Сꥹֹ
* resi_kind_t kind : ͤ°μ
***************************************************************/

void	update_playing_report_making_dam(
	long ls_mbr_n, resi_kind_t kind, long dam
)
{
	if( ls_mbr_n < 0 )
		return;
	if( ls_mbr_n >= LS_MBR_MAX_N )
		return;
	if( kind < 0 )
		return;
	if( kind >= RESI_KIND_MAX_N )
		return;

	playing_report_ls_mbr[ls_mbr_n].making_dam[kind] += dam;
	playing_report_party.making_dam[kind] += dam;
}

/***************************************************************
* ץǡΡ᡼פ򹹿
* long ls_mbr_n : Сꥹֹ
* resi_kind_t kind : ͤ°μ
***************************************************************/

void	update_playing_report_made_dam(
	long ls_mbr_n, resi_kind_t kind, long dam
)
{
	if( ls_mbr_n < 0 )
		return;
	if( ls_mbr_n >= LS_MBR_MAX_N )
		return;
	if( kind < 0 )
		return;
	if( kind >= RESI_KIND_MAX_N )
		return;

	playing_report_ls_mbr[ls_mbr_n].made_dam[kind] += dam;
	playing_report_party.made_dam[kind] += dam;
}

/***************************************************************
* ץǡΡֻѤʸפ򹹿
* long ls_mbr_n : Сꥹֹ
* spell_kind_t kind : ʸμ
***************************************************************/

void	update_playing_report_using_spell(
	long ls_mbr_n, spell_kind_t kind
)
{
	if( ls_mbr_n < 0 )
		return;
	if( ls_mbr_n >= LS_MBR_MAX_N )
		return;
	if( kind < 0 )
		return;
	if( kind >= SPELL_KIND_MAX_N )
		return;

	playing_report_ls_mbr[ls_mbr_n].using_spell[kind]++;
	playing_report_party.using_spell[kind]++;
}

/***************************************************************
* ץǡΡֻѤ줿ʸפ򹹿
* long ls_mbr_n : Сꥹֹ
* spell_kind_t kind : ʸμ
***************************************************************/

void	update_playing_report_used_spell(
	long ls_mbr_n, spell_kind_t kind
)
{
	if( ls_mbr_n < 0 )
		return;
	if( ls_mbr_n >= LS_MBR_MAX_N )
		return;
	if( kind < 0 )
		return;
	if( kind >= SPELL_KIND_MAX_N )
		return;

	playing_report_ls_mbr[ls_mbr_n].used_spell[kind]++;
	playing_report_party.used_spell[kind]++;
}

/***************************************************************
* Сץǡ֤
* long ls_mbr_n : Сꥹֹ
* return : ץǡ
***************************************************************/

playing_report_t	*get_playing_report_mbr( long ls_mbr_n )
{
	if( ls_mbr_n < 0 )
		return NULL;
	if( ls_mbr_n >= LS_MBR_MAX_N )
		return NULL;

	return &(playing_report_ls_mbr[ls_mbr_n]);
}

/***************************************************************
* ѡƥץǡ֤
* return : ץǡ
***************************************************************/

playing_report_t	*get_playing_report_party( void )
{
	return &playing_report_party;
}

/***************************************************************
* ꡼å
***************************************************************/

void	check_memory_play_rep_c( void )
{
	check_memory( check_memory_play_rep_c_playing_report_ls_mbr,
			"play-rep.c: playing_report_ls_mbr" );
	check_memory( check_memory_play_rep_c_playing_report_party,
			"play-rep.c: playing_report_party" );
}
