/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2010 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: Pcg.cpp,v 1.28 2010/01/07 07:22:37 bowkenken Exp $
***************************************************************/

#include <time.h>

#ifdef D_MFC
# include "xlnl-dows/stdafx.h"
# include "xlnl-dows/MainFrm.h"
# include "xlnl-dows/xlnl-dows.h"
# include "xlnl-dows/Dir3d.h"
#endif // D_MFC

#include "gmain.h"
#include "misc.h"
#include "draw.h"
#include "town.h"
#include "amenu.h"
#include "spell.h"
#include "gfile.h"
#include "gmain-prot.h"
#include "misc-prot.h"
#include "draw-prot.h"
#include "gfile-prot.h"

#include "Pcg.h"
#include "GlobalVar.h"

////////////////////////////////////////////////////////////////
// 
// WSCstring path : եåեХѥ
////////////////////////////////////////////////////////////////

void Pcg::init( WSCstring path )
{
	load( path );
}

////////////////////////////////////////////////////////////////
// եåեɤ߹
// WSCstring path : եåեХѥ
////////////////////////////////////////////////////////////////

void Pcg::load( WSCstring path )
{
	if( pImage != NULL ){
		pImage->destroyImage();
		delete pImage;
		pImage = NULL;
	}

	dis();

	sPath = path;

	WSCstring dir = path;
	long pos = dir.getWordCharPos(
			dir.getWords( "/" ), "/" ) - 1;
	if( pos > 0 ){
		dir.cutString( pos );
		make_dir( dir );
	}

#ifdef D_WS
	pImage = WSGIappImageSet()->getImage( path );
#endif // D_WS

#ifdef D_GTK
	GdkPixbuf *buf = gdk_pixbuf_new_from_file( path, NULL );
	long w = gdk_pixbuf_get_width( buf );
	long h = gdk_pixbuf_get_height( buf );
	w = w * gPcgDun.nTileSizeRate / _100_PERCENT;
	h = h * gPcgDun.nTileSizeRate / _100_PERCENT;
	buf = gdk_pixbuf_scale_simple( buf, w, h, GDK_INTERP_BILINEAR );

	pImage = new WSDimage( buf );

	// Ѥοȴˤ

	WSCstring ext = FileList::getExt( path );
	do {
		if( (ext != "bmp") && (ext != "BMP") )
			break;

		guchar *pix = gdk_pixbuf_get_pixels( buf );
		if( pix == NULL )
			break;
		guchar r = pix[0];
		guchar g = pix[1];
		guchar b = pix[2];

		GdkPixbuf *oldBuf = buf;
		buf = gdk_pixbuf_add_alpha( buf, TRUE, r, g, b );
		if( buf == NULL )
			break;
		pImage->setPixbuf( buf );
		gdk_pixbuf_unref( oldBuf );

		break;
	} while( 0 );
#endif // D_GTK

#ifdef D_MFC
	pImage = NULL;

	LPDIRECT3DDEVICE9 pDev = g_Dir3d.pDir3dDevice;
	if( pDev == NULL )
		return;

	D3DXIMAGE_INFO info;
	pImage = new WSDimage();
	LPDIRECT3DTEXTURE9 *ppPixbuf = pImage->getPixbufPtr();
	D3DCOLOR color = 0;

	// *.bmp ɤߤƺѤοȴˤ

	WSCstring ext = FileList::getExt( path );
	do {
		if( (ext != "bmp") && (ext != "BMP") )
			break;

		HRESULT hResult = ::D3DXCreateTextureFromFileEx(
				pDev, path, D3DX_DEFAULT, D3DX_DEFAULT,
				1, 0,
				D3DFMT_UNKNOWN, D3DPOOL_MANAGED,
				D3DX_FILTER_NONE, D3DX_DEFAULT,
				0, &info, 0, ppPixbuf );
		if( FAILED( hResult ) )
			break;

		LPDIRECT3DTEXTURE9 pPixbuf = pImage->getPixbuf();
		D3DSURFACE_DESC desc;
		if( pPixbuf->GetLevelDesc( 0, &desc ) != D3D_OK )
			break;

		// å
		D3DLOCKED_RECT rect;
		pPixbuf->LockRect( 0, &rect, NULL, 0 );

		// ԥ
		DWORD *buf = (DWORD *)(rect.pBits);
		color = CDir3d::CvDwordToColor( buf[0] );

		// å
		pPixbuf->UnlockRect( 0 );
		pPixbuf->Release();

		break;
	} while( 0 );

	// ɤ
	HRESULT hResult = ::D3DXCreateTextureFromFileEx(
			pDev, path, D3DX_DEFAULT, D3DX_DEFAULT,
			1, 0,
			D3DFMT_UNKNOWN, D3DPOOL_MANAGED,
			D3DX_FILTER_NONE, D3DX_DEFAULT,
			color, &info, 0, ppPixbuf );
	if( FAILED( hResult ) ){
		delete pImage;
		pImage = NULL;

		return;
	}
	pImage->setTextureSize();
	pImage->setImageSize( info.Width, info.Height );
#endif // D_MFC

#ifdef D_WS
	nWidth = pImage->getImageWidth();
	nHeight = pImage->getImageHeight();
#endif // D_WS

#ifdef D_GTK
	nWidth = pImage->getImageWidth();
	nHeight = pImage->getImageHeight();
#endif // D_GTK

#ifdef D_MFC
	nWidth = pImage->getImageWidth();
	nHeight = pImage->getImageHeight();
#endif // D_MFC
}

////////////////////////////////////////////////////////////////
// եåǡͭ
////////////////////////////////////////////////////////////////

void Pcg::ena()
{
}

////////////////////////////////////////////////////////////////
// եåǡ̵
////////////////////////////////////////////////////////////////

void Pcg::dis()
{
return;//@@@
	if( pImage != NULL ){
		pImage->destroyImage();
	}
}

////////////////////////////////////////////////////////////////
// եåѥΥѥ֤̾
// return : ѥ̾
////////////////////////////////////////////////////////////////

WSCstring Pcg::getPath()
{
	return sPath;
}

////////////////////////////////////////////////////////////////
// եåѥΥե֤̾
// return : ե̾
////////////////////////////////////////////////////////////////

WSCstring Pcg::getName()
{
	return( FileList::getFileName( sPath ) );
}

////////////////////////////////////////////////////////////////
// եåѥ֤
// return : 
////////////////////////////////////////////////////////////////

long Pcg::getWidth()
{
	if( pImage == NULL )
		return 0;

	return nWidth;
}

////////////////////////////////////////////////////////////////
// եåѥι⤵֤
// return : ⤵
////////////////////////////////////////////////////////////////

long Pcg::getHeight()
{
	if( pImage == NULL )
		return 0;

	return nHeight;
}

////////////////////////////////////////////////////////////////
// ǽԤ
// WSDmwindowDev *mDev : ե졼ࡦХåեʥɥ
// return : false ʤڤ
////////////////////////////////////////////////////////////////

bool Pcg::waitReady( WSDmwindowDev *mDev )
{
return true;//@@@
	if( mDev == NULL )
		return false;

	double frame = (double)*get_clk_tck();
	frame = frame * (double)nWaitReadyMSec / 1000.0;
	clock_t end_clock = clock() + (clock_t)frame;

	while( clock() < end_clock ){
		if( mDev->getReady() )
			return true;
	}

//@@@	mDev->endDraw();

	return false;
}

////////////////////////////////////////////////////////////////
// ե֥ɤγ
// return : ե֥ɤɬפͭѥ󤫡
////////////////////////////////////////////////////////////////

bool Pcg::beginAlpha()
{
#ifdef D_MFC
	g_Dir3d.BeginAlpha();
#endif // D_MFC

	return true;
}

////////////////////////////////////////////////////////////////
// ե֥ɤνλ
// return : ե֥ɤɬפͭѥ󤫡
////////////////////////////////////////////////////////////////

bool Pcg::endAlpha()
{
#ifdef D_MFC
	g_Dir3d.EndAlpha();
#endif // D_MFC

	return true;
}

////////////////////////////////////////////////////////////////
// եåѥ
// WSDmwindowDev *mDev : ե졼ࡦХåեʥɥ
// long x : X ɸ
// long y : Y ɸ
// long w : W 
// long h : H ⤵
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool Pcg::draw( WSDmwindowDev *mDev,
		long x, long y, long w, long h )
{
	ena();

	if( mDev == NULL )
		return false;
	if( pImage == NULL )
		return false;
	if( w < 1 )
		return true;
	if( h < 1 )
		return true;

	beginAlpha();

#ifdef D_WS
	mDev->beginDraw( x, y, w, h );
	mDev->drawImage( x, y, w, h, pImage, WS_LEFT_TOP );
	mDev->endDraw();
#endif // D_WS

#ifdef D_GTK
	GdkGC *gc = gMapDrawingArea->style->fg_gc[GTK_STATE_NORMAL];

	gdk_pixbuf_render_to_drawable(
			pImage->getPixbuf(),
			mDev->getPixMap(),
			gc,
			0, 0,
			x, y,
			w, h,
			GDK_RGB_DITHER_NONE,
			0, 0 );
#endif // D_GTK

#ifdef D_MFC
	g_Dir3d.Draw(
			pImage,
			0, 0,
			x, y,
			w, h );
#endif // D_MFC

	endAlpha();

	return true;
}

////////////////////////////////////////////////////////////////
// եåѥ
// ʥѥкɸ
// WSDmwindowDev *mDev : ե졼ࡦХåեʥɥ
// long x : X ɸ
// long y : Y ɸ
// long w : W 
// long h : H ⤵
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool Pcg::drawFix( WSDmwindowDev *mDev,
		long x, long y, long w, long h )
{
	ena();

	if( mDev == NULL )
		return false;
	if( pImage == NULL )
		return false;
	if( w < 1 )
		return true;
	if( h < 1 )
		return true;

	long iw = pImage->getImageWidth();
	long ih = pImage->getImageHeight();
	if( iw < 1 )
		return false;
	if( ih < 1 )
		return false;
	long bgnX = (x / iw) * iw;
	long bgnY = (y / ih) * ih;

	beginAlpha();

	long drawH = ih - (y - bgnY);
	for( long yy = bgnY; yy < y + h; yy += ih ){
		if( drawH > (y + h - yy) )
			drawH = (y + h - yy);

		long drawW = iw - (x - bgnX);
		for( long xx = bgnX; xx < x + w; xx += iw ){
			if( drawW > (x + w - xx) )
				drawW = (x + w - xx);

			if( !waitReady( mDev ) ){
				endAlpha();

				return false;
			}

#ifdef D_WS
			mDev->beginDraw( xx, yy, drawW, drawH );
			mDev->drawImage( xx, yy, drawW, drawH,
					pImage, WS_LEFT_TOP );
			mDev->endDraw();
#endif // D_WS

#ifdef D_GTK
			GdkGC	*gc;
			gc = gMapDrawingArea->style->fg_gc
					[GTK_STATE_NORMAL];

			gdk_pixbuf_render_to_drawable(
					pImage->getPixbuf(),
					mDev->getPixMap(),
					gc,
					0, 0,
					xx, yy,
					drawW, drawH,
					GDK_RGB_DITHER_NONE,
					0, 0 );
#endif // D_GTK

#ifdef D_MFC
			g_Dir3d.Draw(
					pImage,
					0, 0,
					xx, yy,
					drawW, drawH );
#endif // D_MFC

			drawW = iw;
		}

		drawH = ih;
	}

	endAlpha();

	return true;
}

////////////////////////////////////////////////////////////////
// եåѥ
// ʥѥΥǥåդ
// WSDmwindowDev *mDev : ե졼ࡦХåեʥɥ
// long x : X ɸ
// long y : Y ɸ
// long w : W 
// long h : H ⤵
// long idxX : X ΥѥΥǥå
// long idxY : Y ΥѥΥǥå
// long sizeX : X ΥѥΥ
// long sizeY : Y ΥѥΥ
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool Pcg::drawIdx( WSDmwindowDev *mDev,
		long x, long y, long w, long h,
		long idxX, long idxY,
		long sizeX, long sizeY )
{
	ena();

	if( mDev == NULL )
		return false;
	if( pImage == NULL )
		return false;
	if( w < 1 )
		return true;
	if( h < 1 )
		return true;

	long iw = pImage->getImageWidth();
	long ih = pImage->getImageHeight();
	if( iw < 1 )
		return false;
	if( ih < 1 )
		return false;

	beginAlpha();

#ifdef D_WS
	mDev->beginDraw( x, y, sizeX, sizeY );
	mDev->drawImage(
			x - (idxX * sizeX),
			y - (idxY * sizeY),
			iw, ih,
			pImage, WS_LEFT_TOP );
	mDev->endDraw();
#endif // D_WS

#ifdef D_GTK
	GdkGC	*gc = gMapDrawingArea->style->fg_gc[GTK_STATE_NORMAL];

	gdk_pixbuf_render_to_drawable(
			pImage->getPixbuf(),
			mDev->getPixMap(),
			gc,
			idxX * sizeX,
			idxY * sizeY,
			x, y,
			sizeX, sizeY,
			GDK_RGB_DITHER_NONE,
			0, 0 );
#endif // D_GTK

#ifdef D_MFC
	g_Dir3d.Draw(
			pImage,
			idxX * sizeX,
			idxY * sizeY,
			x, y,
			sizeX, sizeY );
#endif // D_MFC

	endAlpha();

	return true;
}

////////////////////////////////////////////////////////////////
// 饯
// WSDmwindowDev *mDev : ե졼ࡦХåեʥɥ
// long x : X ɸ
// long y : Y ɸ
// long w : W 
// long h : H ⤵
// long offsetX : X եå
// long offsetY : Y եå
// return : 顼̵ä
////////////////////////////////////////////////////////////////

bool Pcg::drawOffset( WSDmwindowDev *mDev,
		long x, long y, long w, long h,
		long offsetX, long offsetY )
{
	ena();

	if( mDev == NULL )
		return false;
	if( pImage == NULL )
		return false;
	if( w < 1 )
		return true;
	if( h < 1 )
		return true;

	beginAlpha();

#ifdef D_WS
	long xx = x - offsetX;
	long yy = y - offsetY;
	long ww = w + offsetX;
	long hh = h + offsetY;
	if( ww > pImage->getImageWidth() )
		ww = pImage->getImageWidth();
	if( hh > pImage->getImageHeight() )
		hh = pImage->getImageHeight();

	mDev->beginDraw( x, y, w, h );
	mDev->drawImage( xx, yy, ww, hh, pImage, WS_LEFT_TOP );
	mDev->endDraw();
#endif // D_WS

#ifdef D_GTK
	if( x < 0 )
		x = 0;
	if( y < 0 )
		y = 0;
	if( w > pImage->getImageWidth() )
		w = pImage->getImageWidth();
	if( h > pImage->getImageHeight() )
		h = pImage->getImageHeight();

	GdkGC	*gc = gMapDrawingArea->style->fg_gc[GTK_STATE_NORMAL];

	gdk_pixbuf_render_to_drawable(
			pImage->getPixbuf(),
			mDev->getPixMap(),
			gc,
			offsetX, offsetY,
			x, y,
			w, h,
			GDK_RGB_DITHER_NONE,
			0, 0 );
#endif // D_GTK

#ifdef D_MFC
	if( w > pImage->getImageWidth() )
		w = pImage->getImageWidth();
	if( h > pImage->getImageHeight() )
		h = pImage->getImageHeight();

	g_Dir3d.Draw(
			pImage,
			offsetX, offsetY,
			x, y,
			w, h );
#endif // D_MFC

	endAlpha();

	return true;
}
