/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2010 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: SelConf.h,v 1.14 2010/07/08 18:16:24 bowkenken Exp $
***************************************************************/

#ifndef SEL_CONF_H
#define SEL_CONF_H	1

////////////////////////////////////////////////////////////////
// եå
////////////////////////////////////////////////////////////////

#if HAVE_UNISTD_H
# include <unistd.h>
#endif // HAVE_UNISTD_H

#include <stdlib.h>
#include <stdio.h>

#if defined( D_WS ) || defined( D_GTK ) || defined( D_IPHONE )
# include <dirent.h>
# include <sys/stat.h>
#endif

#ifdef D_WS
# include <WSCvbtn.h>
# include <WSCstring.h>
#endif // D_WS

#ifdef D_GTK
# include <gtk/gtk.h>
# include "GtkWSCstring.h"
#endif // D_GTK

#ifdef D_MFC
# include "xlnl-dows/stdafx.h"
# include "xlnl-dows/xlnl-dows.h"
# include "xlnl-dows/SelConfDlg.h"
# include "MfcWSCstring.h"
#endif // D_GTK

#include	"GraphConfToken.h"
#include	"GraphConf.h"

////////////////////////////////////////////////////////////////

#define STR_WORD_SEP_SEL_CONF	" : "

////////////////////////////////////////////////////////////////

class SelConf {

	// ץ饤١ȡСѿ
private:

	GraphConf mGraphConfHead;
	GraphConf *pGraphConfCur;

	WSCstring sDir;
	WSCstring sDirName;
#ifdef D_MFC
	// ե롦

	bool bFlagUseWin32ApiFind;

	WIN32_FIND_DATA findData;
	HANDLE hFindFile;

	CFileFind finder;

	bool bFlagOpen;
#else // D_MFC
	// Υǥ쥯ȥ
	DIR *dpFile;
#endif // D_MFC

#ifdef D_GTK
	GtkWidget *vBox;
	GtkWidget *hBox;
	GtkWidget *labelList;
	GtkWidget *scrollWin;
	GtkWidget *lsList;
	GtkWidget *btnSelConfOk;
	GtkWidget *btnSelConfCancel;
#endif // D_GTK

#ifdef D_MFC
#endif // D_MFC

	// ѥ֥åСѿ
public:

#ifdef D_GTK
	GtkWidget *mSelConfWin;
#endif // D_GTK

#ifdef D_MFC
	CSelConfDlg mDlg;
#endif // D_MFC

	GraphConf *pGraphConfSel;

	// ѥ֥åСؿ
public:

	SelConf();
	~SelConf();

	void init();
	void destroy();

	void draw();
	void wipe();

	void setListGui();

	void select( long n );

	bool evalBlockBegin();
	bool evalBlockEnd();
	bool evalSetNum( GraphConfToken token, long n );
	bool evalSetStr( GraphConfToken token, WSCstring str );

	// ץ饤١ȡСؿ
private:

	void newWin();

	void makeList();

	bool openDir();
	bool closeDir();
	WSCstring nextDir();
};

#endif /* SEL_CONF_H */
