#ifndef	__CHR_H__
#define	__CHR_H__

#include	"dun.h"
#include	"fx.h"

#define	MBR_MAX_N	6
#define	MBR_NO_POS	(-1)

#define	ROLL_BASE	0

#define	MBR_NAME_MAX_LEN	16
#define	MNSTR_NAME_MAX_LEN	80
#define	CHR_NAME_MAX_LEN	80

#define	RACE_STR_MAX_LEN	32
#define	RACE_NAME_MAX_LEN	16

#define	ABL_RATE_MIN_N	0
#define	ABL_RATE_MAX_N	20

#define	FLG_CHR_AUTO_FIGHT	(1 << 0)
#define	FLG_CHR_AUTO_DOOR	(1 << 1)
#define	FLG_CHR_AVOID_TRAP	(1 << 2)
#define	FLG_CHR_AUTO_RELOAD	(1 << 3)
#define	FLG_CHR_AUTO_MARK_CONT	(1 << 8)
#define	FLG_CHR_AUTO_CLR_ACT	(1 << 9)

#define	FLG_STAT_NULL	0
#define	FLG_STAT_NOT_EXIST	(1 << 0)
#define	FLG_STAT_DEAD	(1 << 1)
#define	FLG_STAT_STONE	(1 << 2)
#define	FLG_STAT_PARALYZE	(1 << 3)
#define	FLG_STAT_POISON	(1 << 4)
#define	FLG_STAT_CONFUSION	(1 << 5)
#define	FLG_STAT_BLIND	(1 << 6)
#define	FLG_STAT_SLEEP	(1 << 7)
#define	FLG_STAT_SILENCE	(1 << 8)
#define	FLG_STAT_FEAR	(1 << 9)
#define	FLG_STAT_HALLUCINATION	(1 << 10)
#define	FLG_STAT_CHARM	(1 << 11)
#define	FLG_STAT_FLY	(1 << 12)
#define	FLG_STAT_HUNGRY	(1 << 13)
#define	FLG_STAT_STARVATION	(1 << 14)
#define	FLG_STAT_FAINT	(1 << 15)
#define	FLG_STAT_DRUNK	(1 << 16)
#define	FLG_STAT_CAUGHT	(1 << 17)

#define	FLG_WORK_FIND_MBR	(1 << 0)
#define	FLG_WORK_ADJOIN	(1 << 1)

#define	CLASS_MAX_N	99
#define	CLASS_NAME_MAX_LEN	20

#define	SQUARE_WIDTH	3
#define	SQUARE_HEIGHT	3

#define	ACT_MSG_MAX_LEN	64

#define	STAGGER_RATE_CHR_CONFUSION	30
#define	STAGGER_RATE_CHR_BLIND	50
#define	STAGGER_RATE_CHR_DRUNK	50

typedef unsigned long	flg_chr_t;
typedef unsigned long	flg_stat_t;
typedef unsigned long	flg_work_t;

typedef enum {
	CHR_KIND_NULL,
	CHR_KIND_MBR,
	CHR_KIND_MNSTR,
} chr_kind_t;

/* $B<oB2(B */
typedef enum {
	MAIN_RACE_HUMAN,
	MAIN_RACE_HALF_ELF,
	MAIN_RACE_ELF,
	MAIN_RACE_DWARF,
	MAIN_RACE_VIVID,
	MAIN_RACE_MAX_N,
} main_race_t;

typedef enum {
	SUB_RACE_NULL,
	SUB_RACE_CAT,
	SUB_RACE_DOG,
	SUB_RACE_MOUSE,
	SUB_RACE_RABBIT,
	SUB_RACE_MONKEY,
	SUB_RACE_PIG,
	SUB_RACE_BIRD,
	SUB_RACE_LIZARD,
	SUB_RACE_MAX_N,
} sub_race_t;

typedef struct {
	main_race_t	main;
	sub_race_t	sub;
	char	name[RACE_NAME_MAX_LEN + 1];
} race_t;

/* $B@-JL(B */
typedef enum {
	MALE,
	FEMALE,
} sex_t;

/* $BG=NOCM(B */
typedef enum {
	ABL_KIND_HP,
	ABL_KIND_MP,
	ABL_KIND_DEX,
	ABL_KIND_STR,
	ABL_KIND_AGI,
	ABL_KIND_WIS,
	ABL_KIND_INT,
	ABL_KIND_CHA,
	ABL_KIND_FIG,
	ABL_KIND_MON,
	ABL_KIND_HUN,
	ABL_KIND_THI,
	ABL_KIND_MAG,
	ABL_KIND_SOR,
	ABL_KIND_ENC,
	ABL_KIND_SUM,
	ABL_KIND_PRI,
	ABL_KIND_SHA,
	ABL_KIND_BAR,
	ABL_KIND_NIN,
	ABL_KIND_MAX_N,
} abl_kind_t;

typedef struct {
	long	n;
	long	max;
} abl_exp_t;

typedef struct {
	long	n;
	long	max;
} abl_lev_t;

typedef struct {
	long	n;
	long	max;
} abl_val_t;

typedef struct {
	abl_exp_t	exp[ABL_KIND_MAX_N];
	abl_lev_t	lev[ABL_KIND_MAX_N];
	abl_val_t	hp, mp;
} abl_t;

typedef struct {
	long	mul_lev, add_lev;
} lev_to_exp_t;

typedef struct {
	long	mul_lev, add_lev;
} lev_to_val_t;

/* $BBQ@-CM(B */

typedef enum {
	RESI_KIND_KNOC,
	RESI_KIND_SLAS,
	RESI_KIND_STIN,
	RESI_KIND_HEAT,
	RESI_KIND_COLD,
	RESI_KIND_WIND,
	RESI_KIND_ACID,
	RESI_KIND_ELEC,
	RESI_KIND_POIS,
	RESI_KIND_MAX_N,
} resi_kind_t;

typedef struct {
	rate_t	n, max;
} resi_t;

/* $B%"%/%7%g%s(B */
typedef enum {
	ACT_KIND_NULL,
	ACT_KIND_MNSTR_FIGHT,
	ACT_KIND_MNSTR_THROW,
	ACT_KIND_MNSTR_TAIL,
	ACT_KIND_MBR_FIGHT,
	ACT_KIND_MBR_THROW,
	ACT_KIND_MBR_TAIL,
	ACT_KIND_DOOR_OPEN,
	ACT_KIND_DOOR_CLOSE,
	ACT_KIND_DOOR_JAM,
	ACT_KIND_DOOR_DISARM,
	ACT_KIND_DOOR_BREAK,
	ACT_KIND_DOOR_PEEP,
	ACT_KIND_DOOR_SRCH,
	ACT_KIND_TRAP_DISARM,
	ACT_KIND_TRAP_BREAK,
	ACT_KIND_TRAP_SRCH,
	ACT_KIND_ITEM_PICK_UP,
	ACT_KIND_ITEM_OPEN,
	ACT_KIND_ITEM_DISARM,
	ACT_KIND_ITEM_BREAK,
	ACT_KIND_ITEM_SRCH,
	ACT_KIND_ITEM_SEND,
	ACT_KIND_ITEM_DROP,
	ACT_KIND_ITEM_RECEIVE,
	ACT_KIND_EQUIP_SEL,
	ACT_KIND_EQUIP,
	ACT_KIND_TAKE_OFF,
	ACT_KIND_EQUIP_MBR,
	ACT_KIND_TAKE_OFF_MBR,
	ACT_KIND_POTION_QUAFF,
	ACT_KIND_POTION_FILL,
	ACT_KIND_SCROLL_READ,
	ACT_KIND_STICK_ZAP,
	ACT_KIND_FOOD_EAT,
	ACT_KIND_SRCH,
	ACT_KIND_SPELL,

	/* $B%Q!<%F%#$N%"%/%7%g%s(B*/
	ACT_KIND_SHOP,
	ACT_KIND_RECALL,
	ACT_KIND_MAX_N,
} act_kind_t;

typedef struct {
	act_kind_t	kind;
	void	*p, *p2;
	long	n, n2;
	char	msg[ACT_MSG_MAX_LEN + 1];
	act_kind_t	dflt_kind_mnstr;
	char	dflt_msg_mnstr[ACT_MSG_MAX_LEN + 1];
} act_t;

/* $B%?!<%2%C%H(B */
typedef enum {
	TRGT_KIND_NULL,
	TRGT_KIND_MBR,
	TRGT_KIND_MNSTR,
	TRGT_KIND_MNSTR_NULL,
	TRGT_KIND_ITEM,
	TRGT_KIND_DOOR,
	TRGT_KIND_TRAP,
	TRGT_KIND_SQUARE,
	TRGT_KIND_POS,
	TRGT_KIND_AUTO,
	TRGT_KIND_MAX_N,
} trgt_kind_t;

/* $B4V9g$$(B */
typedef enum {
	DIST_NEAR,
	DIST_MEDIUM,
	DIST_FAR,
} dist_t;

typedef struct {
	trgt_kind_t	kind;
	void	*p;
	long	n;
	long	x, y;
	long	true_x, true_y;
	dist_t	dist, dflt_dist_mnstr;
} trgt_t;

/* $B<+F0%^!<%/(B */
#define	AUTO_MARK_MAX_N	12

#define	FLG_AUTO_MARK_EDIT_CONT	(1 << 0)
#define	FLG_AUTO_MARK_EDIT_PRIORITY	(1 << 1)

typedef enum {
	AUTO_MARK_TRGT_MNSTR,
	AUTO_MARK_TRGT_ITEM,
	AUTO_MARK_TRGT_DOOR,
	AUTO_MARK_TRGT_TRAP,
	AUTO_MARK_TRGT_MBR,
	AUTO_MARK_TRGT_UNCHANGE,
	AUTO_MARK_TRGT_CLEAR,
} auto_mark_trgt_t;

typedef enum {
	AUTO_MARK_DIST_NEAR,
	AUTO_MARK_DIST_MEDIUM,
	AUTO_MARK_DIST_FAR,
} auto_mark_dist_t;

typedef enum {
	AUTO_MARK_ACT_FIGHT,
	AUTO_MARK_ACT_THROW,
	AUTO_MARK_ACT_TAIL,
	AUTO_MARK_ACT_PICK_UP,
	AUTO_MARK_ACT_BREAK,
	AUTO_MARK_ACT_OPEN,
	AUTO_MARK_ACT_CLOSE,
	AUTO_MARK_ACT_JAM,
	AUTO_MARK_ACT_DISARM,
	AUTO_MARK_ACT_PEEP,
	AUTO_MARK_ACT_SRCH,
} auto_mark_act_t;

typedef enum {
	AUTO_MARK_COND_NEAREST,
	AUTO_MARK_COND_DISPERSE,
	AUTO_MARK_COND_STAGGER,
	AUTO_MARK_COND_OWN,
} auto_mark_cond_t;

typedef struct {
	auto_mark_trgt_t	trgt;
	auto_mark_dist_t	dist;
	auto_mark_act_t	act;
	auto_mark_cond_t	cond;
	unsigned long	flg;
} auto_mark_t;

typedef enum {
	MOVE_KIND_NULL,
	MOVE_KIND_STD,
	MOVE_KIND_STAGGER,
	MOVE_KIND_MAX_N,
} move_kind_t;

/* $B%o!<%/(B */

typedef struct {
	flg_work_t	flg;
	long	caught;
	struct chr_t	*catch_chr;
} chr_work_t;

#include	"fight.h"

typedef enum {
	MNSTR_KIND_NULL,
	MNSTR_KIND_GIANT_BAT,
	MNSTR_KIND_GIANT_RAT,
	MNSTR_KIND_MIMIC,
	MNSTR_KIND_MAX_N
} mnstr_kind_t;

typedef struct mnstr_tab_t {
	mnstr_kind_t	mnstr_kind;
	char	*name;
	n_msg_t	name_n;
	long	min_lev, max_lev, sgn_lev;
	short	group;
	char	face_mjr, face_mnr;
	long	abl_lev_max[ABL_KIND_MAX_N];
	rate_t	resi[RESI_KIND_MAX_N];
	attack_t	attack[CHR_ATACK_MAX_N + 1];
	rate_t	def, armor_crtcl, ac;
	rate_t	move_rate;
	flg_map_t	flg;
} mnstr_tab_t;

typedef struct {
	long	x, y;
	long	pre_x, pre_y;
	long	dir_x, dir_y;	/* $B8~$$$F$$$kJ}8~(B */

	/* $B>e$r8~$$$F$$$k;~$N@_Dj>e$N8~$-(B */
	short	chr_pos_n[SQUARE_HEIGHT][SQUARE_WIDTH];

	/* $B<B:]$N8~$-(B */
	short	chr_dir[SQUARE_HEIGHT][SQUARE_WIDTH];

	/*  */
	pos_t	chr_pos[MBR_MAX_N];
} square_t;

typedef struct chr_t {
	struct chr_t	*prev, *next;
	chr_kind_t	kind;
	char	name[CHR_NAME_MAX_LEN + 1];
	long	mbr_n, ls_mbr_n;
	char	face_mjr, face_mnr;
	race_t	race;
	sex_t	sex;
	long	x, y;
	long	pre_x, pre_y;
	rate_t	move_rate;
	long	gold;
	long	max_dun_lev_floor, max_dun_lev_base;
	trgt_t	trgt;
	act_t	act;
	auto_mark_t	auto_mark[AUTO_MARK_MAX_N];
	flg_chr_t	flg_chr;
	flg_map_t	flg_map;
	flg_stat_t	stat;
	abl_t	abl;
	long	class_n;
	resi_t	resi[RESI_KIND_MAX_N];
	long	ac;
	fx_t	fx;
	fx_data_t	fx_data;
	mnstr_kind_t	mnstr_kind;
	struct mnstr_tab_t	*mnstr_tab;
	chr_work_t	work;
} chr_t;

#endif	/* __CHR_H__ */
