/*#include	<stddef.h>*/
/*#include	<stdio.h>*/
#include	<string.h>
/*#include	<ctype.h>*/
/*#include	<time.h>*/
/*#include	<sys/stat.h>*/

#include	"gmain.h"
/*#include	"dun.h"*/
/*#include	"town.h"*/
/*#include	"item.h"*/
/*#include	"spell.h"*/
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
/*#include	"fight.h"*/
/*#include	"fx.h"*/
/*#include	"trap.h"*/
#include	"draw.h"
#include	"curs.h"
/*#include	"menu.h"*/
/*#include	"msg.h"*/
/*#include	"ver.h"*/
#include	"gmain_prot.h"
/*#include	"dun_prot.h"*/
/*#include	"town_prot.h"*/
/*#include	"item_prot.h"*/
/*#include	"spell_prot.h"*/
/*#include	"chr_prot.h"*/
/*#include	"party_prot.h"*/
/*#include	"mnstr_prot.h"*/
/*#include	"fight_prot.h"*/
/*#include	"fx_prot.h"*/
/*#include	"trap_prot.h"*/
/*#include	"draw_prot.h"*/
#include	"curs_prot.h"
/*#include	"menu_prot.h"*/
/*#include	"tmenu_prot.h"*/
/*#include	"amenu_prot.h"*/
/*#include	"gfile_prot.h"*/
/*#include	"msg_prot.h"*/

/**/

curs_attr_t	g_curs_attr[CURS_ATTR_MAX_N] = {
	{ 0, N_MSG_ATTR_NORMAL,
		COLOR_WHITE, COLOR_BLACK, A_NORMAL, },

	{ 0, N_MSG_ATTR_ERR,
		COLOR_RED, COLOR_BLACK, A_BOLD, },

	{ 0, N_MSG_ATTR_MENU_DIS,
		COLOR_YELLOW, COLOR_BLACK, A_NORMAL, },

	{ 0, N_MSG_ATTR_MENU_SEL,
		COLOR_WHITE, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_MAP_ITEM,
		COLOR_CYAN, COLOR_BLACK, A_NORMAL, },

	{ 0, N_MSG_ATTR_MAP_SQUARE,
		COLOR_GREEN, COLOR_BLACK, A_BOLD, },

	{ 0, N_MSG_ATTR_MAP_MNSTR,
		COLOR_RED, COLOR_BLACK, A_BOLD, },

	{ 0, N_MSG_ATTR_MAP_CRSR,
		COLOR_GREEN, COLOR_BLACK, A_NORMAL, },

	{ 0, N_MSG_ATTR_FX_MBR_PLUS,
		COLOR_CYAN, COLOR_BLACK, A_BOLD, },

	{ 0, N_MSG_ATTR_FX_MBR_MINUS,
		COLOR_RED, COLOR_BLACK, A_BOLD, },

	{ 0, N_MSG_ATTR_FX_MBR_CRTCL,
		COLOR_RED, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_FX_MNSTR_PLUS,
		COLOR_RED, COLOR_BLACK, A_NORMAL, },

	{ 0, N_MSG_ATTR_FX_MNSTR_MINUS,
		COLOR_CYAN, COLOR_BLACK, A_NORMAL, },

	{ 0, N_MSG_ATTR_FX_MNSTR_CRTCL,
		COLOR_CYAN, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_VFX,
		COLOR_YELLOW, COLOR_BLACK, A_BOLD, },

	{ 0, N_MSG_ATTR_MBR_1,
		COLOR_RED, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_MBR_2,
		COLOR_GREEN, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_MBR_3,
		COLOR_BLUE, COLOR_BLACK, A_BOLD | A_REVERSE, },

	{ 0, N_MSG_ATTR_MBR_4,
		COLOR_CYAN, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_MBR_5,
		COLOR_MAGENTA, COLOR_BLACK, A_REVERSE, },

	{ 0, N_MSG_ATTR_MBR_6,
		COLOR_YELLOW, COLOR_BLACK, A_REVERSE, },
};

/**/

long	flg_curs, flg_curs_draw;
bool_t	flg_color;

/**/

void	init_curs( void )
{
	flg_curs = 0;
	flg_curs_draw = 0;
}

/**/

bool_t	init_curs_color( void )
{
#ifdef	D_USE_CURSES
	curs_attr_n_t	n;

	flg_color = TRUE;

	if( !has_colors() ){
		flg_color = FALSE;
		return FALSE;
	}
	if( start_color() != OK ){
		flg_color = FALSE;
		return FALSE;
	}

	for( n = 0; n < CURS_ATTR_MAX_N; n++ ){
		short	pair_n;

		pair_n = n + 1;
		init_curs_color_pair( &(g_curs_attr[n]), pair_n );
		g_curs_attr[n].color_pair_n = pair_n;
	}
#endif

	return TRUE;
}

/**/

bool_t	init_curs_color_pair( curs_attr_t *p, short pair_n )
{
#ifdef	D_USE_CURSES
	if( !flg_color )
		return FALSE;

	init_pair( pair_n, p->fg, p->bg );
	p->color_pair_n = pair_n;
#endif

	return TRUE;
}

/**/

bool_t	chk_curs_draw( void )
{
	return( flg_curs_draw > 0 );
}

/**/

void	ena_curs_draw( void )
{
	flg_curs_draw++;
}

/**/

void	dis_curs_draw( void )
{
	flg_curs_draw--;
}

/**/

bool_t	chk_curs( void )
{
	return( flg_curs > 0 );
}

/**/

void	ena_curs( void )
{
#ifdef	D_USE_CURSES
	if( chk_curs() ){
		noecho();
		cbreak();
		raw();
	}
#endif	/* D_USE_CURSES */
}

/**/

void	dis_curs( void )
{
#ifdef	D_USE_CURSES
	if( chk_curs() ){
		noraw();
		nocbreak();
		echo();
	}
#endif	/* D_USE_CURSES */
}

/**/

void	curs_clearok( WINDOW *win, bool_t bf )
{
	flg_curs++;

#ifdef	D_USE_CURSES
	if( flg_curs == 1 ){
		clearok( win, bf );
		ena_curs();
	}
#endif	/* D_USE_CURSES */
}

/**/

void	curs_initscr( void )
{
	flg_curs++;

#ifdef	D_USE_CURSES
	if( flg_curs == 1 ){
		initscr();
		ena_curs();
		init_curs_color();
	}
#endif	/* D_USE_CURSES */
}

/**/

void	curs_endwin( void )
{
#ifdef	D_USE_CURSES
	if( flg_curs == 1 ){
		dis_curs();
		endwin();
	}
#endif	/* D_USE_CURSES */

	flg_curs--;
}

/**/

void	curs_keypad( WINDOW *win, bool_t bf )
{
#ifdef	D_USE_CURSES
	if( g_flg_use_keypad )
		keypad( win, bf );
#endif	/* D_USE_CURSES */
}

/**/

void	curs_refresh( void )
{
	if( !chk_curs_draw() )
		return;

#ifdef	D_USE_CURSES
	if( chk_curs() ){
		refresh();
		return;
	}
#endif	/* D_USE_CURSES */

	fflush( OUT_FP );
}

/**/

void	curs_attrset_n( curs_attr_n_t n )
{
	curs_attrset_dir( &(g_curs_attr[n]) );
}

/**/

void	curs_attrset_dir( curs_attr_t *attr )
{
	int	tmp_attr;

	if( !chk_curs_draw() )
		return;

	tmp_attr = 0;

#ifdef	D_USE_CURSES
	tmp_attr = COLOR_PAIR( attr->color_pair_n );
#endif	/* D_USE_CURSES */

	tmp_attr |= attr->attr;

	curs_attrset( tmp_attr );
}

/**/

void	curs_attrset( int at )
{
	if( !chk_curs_draw() )
		return;

#ifdef	D_USE_CURSES
	if( chk_curs() ){
		attrset( at );
		return;
	}
#endif	/* D_USE_CURSES */

	if( chk_flg( at, A_REVERSE ) )
		fprintf( OUT_FP, "\033[43m" );
	else
		fprintf( OUT_FP, "\033[m" );
}

/**/

void	curs_attron( int at )
{
	if( !chk_curs_draw() )
		return;

#ifdef	D_USE_CURSES
	if( chk_curs() ){
		attron( at );
		return;
	}
#endif	/* D_USE_CURSES */

	if( chk_flg( at, A_REVERSE ) )
		fprintf( OUT_FP, "\033[43m" );
}

/**/

void	curs_attroff( int at )
{
	if( !chk_curs_draw() )
		return;

#ifdef	D_USE_CURSES
	if( chk_curs() ){
		attroff( at );
		return;
	}
#endif	/* D_USE_CURSES */

	if( chk_flg( at, A_REVERSE ) )
		fprintf( OUT_FP, "\033[m" );
}

/**/

void	curs_move( int scrn_y, int scrn_x )
{
	if( !chk_curs_draw() )
		return;

#ifdef	D_USE_CURSES
	if( chk_curs() ){
		move( scrn_y, scrn_x );
		return;
	}
#endif	/* D_USE_CURSES */

	fprintf( OUT_FP, "\033[%d;%dH", scrn_y + 1, scrn_x + 1 );
}

/**/

void	curs_printw( char *s, ... )
{
	va_list	argptr;

	if( !chk_curs_draw() )
		return;

	va_start( argptr, s );

#ifdef	D_USE_CURSES
	if( chk_curs() ){
		vwprintw( stdscr, s, argptr );
		va_end( argptr );
		return;
	}
#endif	/* D_USE_CURSES */

	vfprintf( OUT_FP, s, argptr );

	va_end( argptr );
}

/**/

void	curs_clear( void )
{
	if( !chk_curs_draw() )
		return;

#ifdef	D_USE_CURSES
	if( chk_curs() ){
		clear();
		return;
	}
#endif	/* D_USE_CURSES */

	fprintf( OUT_FP, "\032" );
}

/**/

int	curs_getch( void )
{
#ifdef	D_USE_CURSES
	if( chk_curs() )
		return getch();
#endif

	return getchar();
}

/**/

void	curs_getnstr( char *s, int len )
{
	static char	buf[255 + 1];

	s[0] = '\0';

	if( !chk_curs_draw() )
		return;

#ifdef	D_USE_CURSES
	if( chk_curs() ){
		getnstr( s, len );
		return;
	}
#endif

	fgets( buf, sizeof( buf ) - 1, stdin );
	strncpy( s, buf, len );
}

/**/

curs_attr_t	*get_curs_attr( void )
{
	return g_curs_attr;
}

/**/

bool_t	chk_color( void )
{
	return flg_color;
}

