#ifndef	__FX_H__
#define	__FX_H__

#define	DOOR_DISARM_RATE_MUL_N	4
#define	DOOR_DISARM_RATE_ADD_N	20
#define	TRAP_DISARM_FAILURE_RATE	40
#define	ITEM_DISARM_FAILURE_RATE	40

#define	RESURRECTION_MIN_RATE	30
#define	RESURRECTION_MAX_RATE	90

/* Turn begin */

#define	FX_TURN_INFINITE_N	(-1)

#define	FX_AVE_TURN_POISON_DEC	48

#define	FX_AVE_TURN_STONE	FX_TURN_INFINITE_N
#define	FX_AVE_TURN_PARALYZE	16
#define	FX_AVE_TURN_POISON	512
#define	FX_AVE_TURN_CONFUSION	16
#define	FX_AVE_TURN_BLIND	128
#define	FX_AVE_TURN_SLEEP	32
#define	FX_AVE_TURN_SILENCE	32
#define	FX_AVE_TURN_FEAR	32
#define	FX_AVE_TURN_HALLUCINATION	32
#define	FX_AVE_TURN_CHARM	32
#define	FX_AVE_TURN_FLY	128

#define	FX_AVE_TURN_POW_UP_HP	64
#define	FX_AVE_TURN_POW_UP_ABL	64
#define	FX_AVE_TURN_POW_DOWN_ABL	64
#define	FX_AVE_TURN_POW_UP_RESI	64
#define	FX_AVE_TURN_SPEED_UP	256
#define	FX_AVE_TURN_SPEED_DOWN	256

#define	FX_AVE_TURN_DARKVISION	128

#define	FX_AVE_TURN_RECALL	32

#define	FX_AVE_TURN_FAINT	16
#define	FX_TURN_DRUNK	1024

/* Turn end */

typedef enum {
	FX_KIND_NULL,
	FX_KIND_STONE,
	FX_KIND_PARALYZE,
	FX_KIND_POISON,
	FX_KIND_CONFUSION,
	FX_KIND_BLIND,
	FX_KIND_SLEEP,
	FX_KIND_SILENCE,
	FX_KIND_FEAR,
	FX_KIND_HALLUCINATION,
	FX_KIND_CHARM,
	FX_KIND_FLY,
	FX_KIND_FAINT,
	FX_KIND_DRUNK,
	FX_KIND_VANISH,
	FX_KIND_RESI_KNOC,
	FX_KIND_RESI_SLAS,
	FX_KIND_RESI_STIN,
	FX_KIND_RESI_HEAT,
	FX_KIND_RESI_COLD,
	FX_KIND_RESI_WIND,
	FX_KIND_RESI_ACID,
	FX_KIND_RESI_ELEC,
	FX_KIND_RESI_POIS,
	FX_KIND_SHARPNESS,
	FX_KIND_DULLNESS,
	FX_KIND_STRENGTH,
	FX_KIND_WEAKNESS,
	FX_KIND_QUICKNESS,
	FX_KIND_SLOWNESS,
	FX_KIND_WISE,
	FX_KIND_FOOLISH,
	FX_KIND_BRAINY,
	FX_KIND_BRAINLESS,
	FX_KIND_ATTRACTIVE,
	FX_KIND_UNATTRACTIVE,
	FX_KIND_SENSE_INVISIBLE,
	FX_KIND_POW_UP_HP,
	FX_KIND_SPEED,
	FX_KIND_MAX_N,
} fx_kind_t;

/* $B6uJ"EY(B */

typedef struct {
	rate_t	rate;
	rate_t	full_rate;
	long	digest_p_day;
	rate_t	hungry_rate, starvation_rate;
} stomach_t;

/* $B%K%3%A%s0MB8EY(B */

typedef struct {
	rate_t	rate;
	rate_t	poisoning_rate;
} nicotine_t;

typedef struct fx {
	struct fx	*next, *prev;
	fx_kind_t	kind;
	long	turn;
	long	n;
	struct chr_t	*chr;
} fx_t;

typedef struct fx_data {
	long	infra_vision;
	stomach_t	stomach;
	rate_t	drunk_rate;
	nicotine_t	nicotine;
	long	friend_turn;
} fx_data_t;

typedef enum {
	LIQUOR_KIND_RED_WINE,
	LIQUOR_KIND_WHITE_WINE,
	LIQUOR_KIND_ROSE_WINE,
	LIQUOR_KIND_ALE,
	LIQUOR_KIND_BRANDY,
	LIQUOR_KIND_RUM,
	LIQUOR_KIND_MAX_N
} liquor_kind_t;

#define	BLAST_MAX_X	32
#define	BLAST_MAX_Y	32

typedef struct {
	long	xl, yl;
	long	xr, yr;
	char	ptn[BLAST_MAX_Y][BLAST_MAX_X];;
} blast_t;

#endif	/*__FX_H__*/

