#ifndef	__ITEM_TAB_H__
#define	__ITEM_TAB_H__

ratio_t	item_ratio_tab[ITEM_KIND_MAX_N] = {
	10,	/* ITEM_KIND_NULL */
	80,	/* ITEM_KIND_WPN */
	60,	/* ITEM_KIND_ARMOR */
	80,	/* ITEM_KIND_POTION */
	80,	/* ITEM_KIND_SCROLL */
	80,	/* ITEM_KIND_STICK */
	80,	/* ITEM_KIND_ACCE */
	30,	/* ITEM_KIND_LIGHT */
	30,	/* ITEM_KIND_SPIKE */
	80,	/* ITEM_KIND_FOOD */
	20,	/* ITEM_KIND_CHEST */
	50,	/* ITEM_KIND_TOBACCO */
	20,	/* ITEM_KIND_PIPE */
	80,	/* ITEM_KIND_COIN */
	20,	/* ITEM_KIND_JUNK */
};

wpn_tab_t	wpn_tab[] = {
#if	0
typedef struct {
	char	*name;
	n_msg_t	name_n;
	wpn_kind_t	kind;
	rate_t	rate;
	long	ave_n;
	attack_t	attack[WPN_ATTACK_MAX_N + 1];
	rate_t	rate_price;
	long	add_price;
	char	mnr;
	long	min_lev, max_lev, sgn_lev;
	bow_kind_t	bow_kind;
	flg_wpn_tab_t	flg;
	flg_item_abl	flg_abl;
} wpn_tab_t;

typedef struct {
	attack_kind_t	kind;
	ratio_t	ratio;
	bool_t	flg_throw, flg_monk;
	rate_t	hit, wpn_crtcl, dam;
	resi_kind_t	resi_kind;
} attack_t;

typedef enum {
	RESI_KIND_KNOC,
	RESI_KIND_STIN,
	RESI_KIND_SLAS,
	RESI_KIND_WIND,
	RESI_KIND_HEAT,
	RESI_KIND_COLD,
	RESI_KIND_ELEC,
	RESI_KIND_ACID,
	RESI_KIND_POIS,
	RESI_KIND_MAX_N,
} resi_kind_t;
#endif

	{ NULL, N_MSG_ITEM_UNKNOWN, WPN_KIND_NULL, 0, 0,
		{
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				0, 0, 0, RESI_KIND_MAX_N },
		},
		0, +0, FACE_MNR_NULL, DUN_MAX_LEV, DUN_MAX_LEV, 0,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_KNIFE, WPN_KIND_KNIFE, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				30, 30, 30, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_KRIS_KNIFE, WPN_KIND_KRIS_KNIFE, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				30, 30, 50, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_MAIN_GAUCHE, WPN_KIND_MAIN_GAUCHE, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				30, 30, 30, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_SWORD_BREAKER, WPN_KIND_SWORD_BREAKER, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				30, 100, 30, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_KATAR, WPN_KIND_KATAR, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				30, 30, 30, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_JAMADHAR, WPN_KIND_JAMADHAR, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				30, 30, 30, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_KUKRI, WPN_KIND_KUKRI, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				30, 30, 30, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_SHORT_SWORD, WPN_KIND_SHORT_SWORD, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				40, 40, 40, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_GLADIUS, WPN_KIND_GLADIUS, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				40, 40, 40, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_LONG_SWORD, WPN_KIND_LONG_SWORD, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_BROAD_SWORD, WPN_KIND_BROAD_SWORD, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_CLAYMORE, WPN_KIND_CLAYMORE, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_BASTARD_SWORD, WPN_KIND_BASTARD_SWORD, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				80, 80, 80, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_GREAT_SWORD, WPN_KIND_GREAT_SWORD, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				80, 80, 100, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_SABRE, WPN_KIND_SABRE, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				100, 50, 50, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_SHAMSHIR, WPN_KIND_SHAMSHIR, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				100, 50, 50, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_TALWAR, WPN_KIND_TALWAR, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				100, 50, 50, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_FALCHION, WPN_KIND_FALCHION, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				100, 50, 50, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_CUTLASS, WPN_KIND_CUTLASS, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				100, 50, 50, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_SHOTEL, WPN_KIND_SHOTEL, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				100, 50, 50, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_KATANA, WPN_KIND_KATANA, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				100, 70, 70, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_RAPIER, WPN_KIND_RAPIER, 80, 1,
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				70, 50, 50, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_ESTOC, WPN_KIND_ESTOC, 80, 1,
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				70, 50, 50, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_HAND_AXE, WPN_KIND_HAND_AXE, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				50, 80, 50, RESI_KIND_SLAS },
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				50, 80, 50, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_DAGGER, FLG_WPN_TAB_THROW,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_FRANCISCA, WPN_KIND_FRANCISCA, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				50, 80, 50, RESI_KIND_SLAS },
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				50, 80, 50, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_DAGGER, FLG_WPN_TAB_THROW,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_BATTLE_AXE, WPN_KIND_BATTLE_AXE, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				80, 90, 60, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_BHUJ, WPN_KIND_BHUJ, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				80, 90, 60, RESI_KIND_SLAS },
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				80, 90, 60, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_BROAD_AXE, WPN_KIND_BROAD_AXE, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				80, 100, 70, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_GREAT_AXE, WPN_KIND_GREAT_AXE, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				80, 100, 80, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_SPEAR, WPN_KIND_SPEAR, 80, 1,
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_STIN },
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				50, 50, 50, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_DAGGER, FLG_WPN_TAB_THROW,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_PILUM, WPN_KIND_PILUM, 80, 1,
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_STIN },
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				50, 50, 50, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_DAGGER, FLG_WPN_TAB_THROW,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_PIKE, WPN_KIND_PIKE, 80, 1,
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_JAVELIN, WPN_KIND_JAVELIN, 80, 1,
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_STIN },
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				50, 50, 50, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_DAGGER, FLG_WPN_TAB_THROW,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_TRIDENT, WPN_KIND_TRIDENT, 80, 1,
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_LANCE, WPN_KIND_LANCE, 80, 1,
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_WOODEN_CLUB, WPN_KIND_WOODEN_CLUB, 80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				30, 30, 30, RESI_KIND_KNOC },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_ITEM_ABL_PRI,
	},

	{ NULL, N_MSG_WPN_LIGHT_FLAIL, WPN_KIND_LIGHT_FLAIL, 80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_KNOC },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_ITEM_ABL_PRI,
	},

	{ NULL, N_MSG_WPN_HEAVY_FLAIL, WPN_KIND_HEAVY_FLAIL, 80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				50, 50, 60, RESI_KIND_KNOC },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_ITEM_ABL_PRI,
	},

	{ NULL, N_MSG_WPN_MORNINGSTAR, WPN_KIND_MORNINGSTAR, 80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_KNOC },
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_LIGHT_MACE, WPN_KIND_LIGHT_MACE, 80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				50, 50, 40, RESI_KIND_KNOC },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_ITEM_ABL_PRI,
	},

	{ NULL, N_MSG_WPN_HEAVY_MACE, WPN_KIND_HEAVY_MACE, 80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_KNOC },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_ITEM_ABL_PRI,
	},
/**/
	{ NULL, N_MSG_WPN_WAR_HAMMER, WPN_KIND_WAR_HAMMER, 80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_ITEM_ABL_PRI,
	},

	{ NULL, N_MSG_WPN_WAR_PICK, WPN_KIND_WAR_PICK, 80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_ITEM_ABL_PRI,
	},

	{ NULL, N_MSG_WPN_ZAGHNOL, WPN_KIND_ZAGHNOL, 80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_ITEM_ABL_PRI,
	},

	{ NULL, N_MSG_WPN_BEC_DE_CORBIN, WPN_KIND_BEC_DE_CORBIN, 80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_KNOC },
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				50, 50, 50, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_PARTIZAN, WPN_KIND_PARTIZAN, 80, 1,
		{
			{ ATTACK_KIND_MOW, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_POLEAXE, WPN_KIND_POLEAXE, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS },
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_STIN },
			{ ATTACK_KIND_MOW, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_GLAIVE, WPN_KIND_GLAIVE, 80, 1,
		{
			{ ATTACK_KIND_MOW, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_HALBERD, WPN_KIND_HALBERD, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS },
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_STIN },
			{ ATTACK_KIND_MOW, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_CHAUVE_SOURIS, WPN_KIND_CHAUVE_SOURIS, 80, 1,
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_CORSESCA, WPN_KIND_CORSESCA, 80, 1,
		{
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_SCYTHE, WPN_KIND_SCYTHE, 80, 1,
		{
			{ ATTACK_KIND_MOW, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_FAUCHARD, WPN_KIND_FAUCHARD, 80, 1,
		{
			{ ATTACK_KIND_MOW, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_GUISARME, WPN_KIND_GUISARME, 80, 1,
		{
			{ ATTACK_KIND_SLASH, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS },
			{ ATTACK_KIND_STING, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_STIN },
			{ ATTACK_KIND_MOW, 1, FALSE, FALSE,
				70, 70, 70, RESI_KIND_SLAS },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_BRASS_KNUCKLE, WPN_KIND_BRASS_KNUCKLE, 80, 1,
		{
			{ ATTACK_KIND_PUNCH, 1, FALSE, FALSE,
				30, 30, 30, RESI_KIND_KNOC },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_ITEM_ABL_MON,
	},

	{ NULL, N_MSG_WPN_BAGH_NAKH, WPN_KIND_BAGH_NAKH, 80, 1,
		{
			{ ATTACK_KIND_PUNCH, 1, FALSE, FALSE,
				30, 30, 30, RESI_KIND_KNOC },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_ITEM_ABL_MON,
	},

	{ NULL, N_MSG_WPN_QUARTER_STAFF, WPN_KIND_QUARTER_STAFF, 80, 1,
		{
			{ ATTACK_KIND_KNOCK, 1, FALSE, FALSE,
				30, 30, 30, RESI_KIND_KNOC },
		},
		100, +0, FACE_MNR_SWORD, 0, DUN_MAX_LEV, -1,
		BOW_KIND_NULL, FLG_NULL,
		FLG_ITEM_ABL_MON | FLG_ITEM_ABL_PRI,
	},
/**/
	{ NULL, N_MSG_WPN_SLING, WPN_KIND_SLING, 80, 1,
		{
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				30, 30, 30, RESI_KIND_KNOC },
		},
		100, +0, FACE_MNR_BOW, 0, DUN_MAX_LEV, -1,
		BOW_KIND_SLING, FLG_WPN_TAB_BOW,
		FLG_ITEM_ABL_PRI,
	},

	{ NULL, N_MSG_WPN_SHORT_BOW, WPN_KIND_SHORT_BOW, 80, 1,
		{
			{ ATTACK_KIND_SHOOT, 1, TRUE, FALSE,
				40, 40, 50, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_BOW, 0, DUN_MAX_LEV, -1,
		BOW_KIND_BOW, FLG_WPN_TAB_BOW | FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_LONG_BOW, WPN_KIND_LONG_BOW, 80, 1,
		{
			{ ATTACK_KIND_SHOOT, 1, TRUE, FALSE,
				60, 60, 70, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_BOW, 0, DUN_MAX_LEV, -1,
		BOW_KIND_BOW, FLG_WPN_TAB_BOW | FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_COMPOSITE_BOW, WPN_KIND_COMPOSITE_BOW, 80, 1,
		{
			{ ATTACK_KIND_SHOOT, 1, TRUE, FALSE,
				80, 80, 90, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_BOW, 0, DUN_MAX_LEV, -1,
		BOW_KIND_BOW, FLG_WPN_TAB_BOW | FLG_WPN_TAB_TWO_HANDED,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_LIGHT_CROSS_BOW, WPN_KIND_LIGHT_CROSS_BOW, 80, 1,
		{
			{ ATTACK_KIND_SHOOT, 1, TRUE, FALSE,
				70, 60, 60, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_BOW, 0, DUN_MAX_LEV, -1,
		BOW_KIND_CROSS_BOW, FLG_WPN_TAB_BOW,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_HEAVY_CROSS_BOW, WPN_KIND_HEAVY_CROSS_BOW, 80, 1,
		{
			{ ATTACK_KIND_SHOOT, 1, TRUE, FALSE,
				90, 80, 80, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_BOW, 0, DUN_MAX_LEV, -1,
		BOW_KIND_CROSS_BOW, FLG_WPN_TAB_BOW,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_BLOW_GUN, WPN_KIND_BLOW_GUN, 80, 1,
		{
			{ ATTACK_KIND_SHOOT, 1, TRUE, FALSE,
				30, 30, 30, RESI_KIND_STIN },
		},
		100, +0, FACE_MNR_BOW, 0, DUN_MAX_LEV, -1,
		BOW_KIND_BLOW_GUN, FLG_WPN_TAB_BOW,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_STONE, WPN_KIND_STONE, 80, 24,
		{
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				+0, +0, +0, RESI_KIND_KNOC },
		},
		0, +0, FACE_MNR_STONE, 0, DUN_MAX_LEV, -1,
		BOW_KIND_SLING, FLG_WPN_TAB_ARW | FLG_WPN_TAB_BUNDLE,
		FLG_ITEM_ABL_PRI,
	},

	{ NULL, N_MSG_WPN_BULLET, WPN_KIND_BULLET, 80, 24,
		{
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				+5, +0, +5, RESI_KIND_KNOC },
		},
		1, +0, FACE_MNR_STONE, 0, DUN_MAX_LEV, -1,
		BOW_KIND_SLING, FLG_WPN_TAB_ARW | FLG_WPN_TAB_BUNDLE,
		FLG_ITEM_ABL_PRI,
	},

	{ NULL, N_MSG_WPN_ARW, WPN_KIND_ARW, 80, 24,
		{
			{ ATTACK_KIND_SHOOT, 1, TRUE, FALSE,
				+10, +0, +10, RESI_KIND_STIN },
		},
		1, +0, FACE_MNR_ARW, 0, DUN_MAX_LEV, -1,
		BOW_KIND_BOW, FLG_WPN_TAB_ARW | FLG_WPN_TAB_BUNDLE,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_BOLT, WPN_KIND_BOLT, 80, 24,
		{
			{ ATTACK_KIND_SHOOT, 1, TRUE, FALSE,
				+10, +0, +10, RESI_KIND_STIN },
		},
		1, +0, FACE_MNR_ARW, 0, DUN_MAX_LEV, -1,
		BOW_KIND_CROSS_BOW, FLG_WPN_TAB_ARW | FLG_WPN_TAB_BUNDLE,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_NEEDLE, WPN_KIND_NEEDLE, 80, 24,
		{
			{ ATTACK_KIND_SHOOT, 1, TRUE, FALSE,
				+5, +0, +5, RESI_KIND_STIN },
		},
		1, +0, FACE_MNR_ARW, 0, DUN_MAX_LEV, -1,
		BOW_KIND_BLOW_GUN, FLG_WPN_TAB_ARW | FLG_WPN_TAB_BUNDLE,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_WPN_DAGGER, WPN_KIND_DAGGER, 80, 24,
		{
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				30, 30, 30, RESI_KIND_STIN },
		},
		10, +0, FACE_MNR_DAGGER, 0, DUN_MAX_LEV, -1,
		BOW_KIND_DAGGER, FLG_WPN_TAB_ARW | FLG_WPN_TAB_BUNDLE,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_DARTS, WPN_KIND_DARTS, 80, 24,
		{
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				30, 30, 30, RESI_KIND_STIN },
		},
		10, +0, FACE_MNR_DAGGER, 0, DUN_MAX_LEV, -1,
		BOW_KIND_DAGGER, FLG_WPN_TAB_ARW | FLG_WPN_TAB_BUNDLE,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_SHURIKEN, WPN_KIND_SHURIKEN, 80, 24,
		{
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				30, 40, 40, RESI_KIND_STIN },
		},
		10, +0, FACE_MNR_DAGGER, 0, DUN_MAX_LEV, -1,
		BOW_KIND_DAGGER, FLG_WPN_TAB_ARW | FLG_WPN_TAB_BUNDLE,
		FLG_NULL,
	},

	{ NULL, N_MSG_WPN_BOOMERANG, WPN_KIND_BOOMERANG, 80, 24,
		{
			{ ATTACK_KIND_THROW, 1, TRUE, FALSE,
				30, 30, 30, RESI_KIND_KNOC },
		},
		10, +0, FACE_MNR_DAGGER, 0, DUN_MAX_LEV, -1,
		BOW_KIND_DAGGER, FLG_WPN_TAB_BOOMERANG,
		FLG_ITEM_ABL_PRI,
	},
/**/
	{ NULL, N_MSG_NULL, WPN_KIND_NULL, 0, 0,
		{
			{ ATTACK_KIND_NULL, 0, FALSE, FALSE,
				0, 0, 0, RESI_KIND_MAX_N },
		},
		0, +0, FACE_MNR_NULL, DUN_MAX_LEV, DUN_MAX_LEV, 0,
		BOW_KIND_NULL, FLG_NULL,
		FLG_NULL,
	},
};

armor_tab_t	armor_tab[] = {
#if	0
typedef struct {
	char	*name;
	n_msg_t	name_n;
	armor_kind_t	kind;
	long	price;
	char	mnr;
	equip_kind_t	equip_kind;
	rate_t	up_resi[RESI_KIND_MAX_N];
	rate_t	def;
	rate_t	crtcl;
	rate_t	ac;
	long	min_lev, max_lev, sgn_lev;
	rate_t	rate;
	flg_item_abl	flg_abl;
} armor_tab_t;
#endif

	{ NULL, N_MSG_ITEM_UNKNOWN,
		ARMOR_KIND_NULL,
		100, +0, FACE_MNR_NULL, EQUIP_KIND_HEAD,
		{ 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		0, 0, 0,
		DUN_MAX_LEV, DUN_MAX_LEV, 0, 0,
		FLG_NULL,
	},

	{ NULL, N_MSG_ARMOR_LEATHER_CAP,
		ARMOR_KIND_LEATHER_CAP,
		100, +0, FACE_MNR_ARMOR_HEAD, EQUIP_KIND_HEAD,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		0, 40, 0,
		1, DUN_MAX_LEV, -1, 80,
		FLG_ITEM_ABL_MON | FLG_ITEM_ABL_THI | FLG_ITEM_ABL_MAG_SHA,
	},

	{ NULL, N_MSG_ARMOR_METAL_CAP,
		ARMOR_KIND_METAL_CAP,
		100, +0, FACE_MNR_ARMOR_HEAD, EQUIP_KIND_HEAD,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		0, 60, 0,
		1, DUN_MAX_LEV, -1, 80,
		FLG_ITEM_ABL_MON | FLG_ITEM_ABL_THI | FLG_ITEM_ABL_ALL_MAG,
	},

	{ NULL, N_MSG_ARMOR_SALLET,
		ARMOR_KIND_SALLET,
		100, +0, FACE_MNR_ARMOR_HEAD, EQUIP_KIND_HEAD,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		0, 80, 0,
		1, DUN_MAX_LEV, -1, 80,
		FLG_NULL,
	},

	{ NULL, N_MSG_ARMOR_CLOSE_HELMET,
		ARMOR_KIND_CLOSE_HELMET,
		100, +0, FACE_MNR_ARMOR_HEAD, EQUIP_KIND_HEAD,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		0, 100, 0,
		1, DUN_MAX_LEV, -1, 80,
		FLG_NULL,
	},

	{ NULL, N_MSG_ARMOR_SILVER_CROWN,
		ARMOR_KIND_SILVER_CROWN,
		0, +10000, FACE_MNR_ARMOR_HEAD, EQUIP_KIND_HEAD,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		0, 10, 0,
		1, DUN_MAX_LEV, -1, 80,
		FLG_ITEM_ABL_THI | FLG_ITEM_ABL_ALL_MAG,
	},

	{ NULL, N_MSG_ARMOR_GOLDEN_CROWN,
		ARMOR_KIND_GOLDEN_CROWN,
		0, +20000, FACE_MNR_ARMOR_HEAD, EQUIP_KIND_HEAD,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		0, 10, 0,
		1, DUN_MAX_LEV, -1, 80,
		FLG_ITEM_ABL_THI | FLG_ITEM_ABL_ALL_MAG,
	},

	{ NULL, N_MSG_ARMOR_JEWELED_CROWN,
		ARMOR_KIND_JEWELED_CROWN,
		0, +30000, FACE_MNR_ARMOR_HEAD, EQUIP_KIND_HEAD,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		0, 10, 0,
		1, DUN_MAX_LEV, -1, 80,
		FLG_ITEM_ABL_THI | FLG_ITEM_ABL_ALL_MAG,
	},
/**/
	{ NULL, N_MSG_ARMOR_ROBE,
		ARMOR_KIND_ROBE,
		100, +0, FACE_MNR_ARMOR_BODY, EQUIP_KIND_BODY,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		0, 0, 10,
		1, DUN_MAX_LEV, -1, 80,
		FLG_ITEM_ABL_MON | FLG_ITEM_ABL_THI | FLG_ITEM_ABL_MAG_SHA,
	},

	{ NULL, N_MSG_ARMOR_SOFT_LEATHER_ARMOR,
		ARMOR_KIND_SOFT_LEATHER_ARMOR,
		100, +0, FACE_MNR_ARMOR_BODY, EQUIP_KIND_BODY,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		0, 0, 20,
		1, DUN_MAX_LEV, -1, 80,
		FLG_ITEM_ABL_THI | FLG_ITEM_ABL_MAG_SHA,
	},

	{ NULL, N_MSG_ARMOR_HARD_LEATHER_ARMOR,
		ARMOR_KIND_HARD_LEATHER_ARMOR,
		100, +0, FACE_MNR_ARMOR_BODY, EQUIP_KIND_BODY,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		0, 0, 30,
		1, DUN_MAX_LEV, -1, 80,
		FLG_ITEM_ABL_THI | FLG_ITEM_ABL_SHA,
	},

	{ NULL, N_MSG_ARMOR_RING_MAIL,
		ARMOR_KIND_RING_MAIL,
		100, +0, FACE_MNR_ARMOR_BODY, EQUIP_KIND_BODY,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		0, 0, 50,
		1, DUN_MAX_LEV, -1, 80,
		FLG_NULL,
	},

	{ NULL, N_MSG_ARMOR_SCALE_MAIL,
		ARMOR_KIND_SCALE_MAIL,
		100, +0, FACE_MNR_ARMOR_BODY, EQUIP_KIND_BODY,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		0, 0, 60,
		1, DUN_MAX_LEV, -1, 80,
		FLG_NULL,
	},

	{ NULL, N_MSG_ARMOR_DRAGON_SCALE,
		ARMOR_KIND_DRAGON_SCALE,
		100, +0, FACE_MNR_ARMOR_BODY, EQUIP_KIND_BODY,
		{ 100, 100, 100, 200, 200, 200, 200, 200, 200 },
		0, 0, 80,
		1, DUN_MAX_LEV, -1, 80,
		FLG_NULL | FLG_ITEM_ABL_SHA,
	},

	{ NULL, N_MSG_ARMOR_LAMELLAR_ARMOR,
		ARMOR_KIND_LAMELLAR_ARMOR,
		100, +0, FACE_MNR_ARMOR_BODY, EQUIP_KIND_BODY,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		0, 0, 70,
		1, DUN_MAX_LEV, -1, 80,
		FLG_NULL,
	},

	{ NULL, N_MSG_ARMOR_CHAIN_MAIL,
		ARMOR_KIND_CHAIN_MAIL,
		100, +0, FACE_MNR_ARMOR_BODY, EQUIP_KIND_BODY,
		{ 90, 100, 100, 100, 100, 100, 100, 100, 100 },
		0, 0, 80,
		1, DUN_MAX_LEV, -1, 80,
		FLG_NULL,
	},

	{ NULL, N_MSG_ARMOR_MITHRIL_CHAIN,
		ARMOR_KIND_MITHRIL_CHAIN,
		100, +0, FACE_MNR_ARMOR_BODY, EQUIP_KIND_BODY,
		{ 90, 100, 100, 180, 180, 180, 180, 180, 180 },
		0, 0, 100,
		1, DUN_MAX_LEV, -1, 80,
		FLG_NULL | FLG_ITEM_ABL_SHA,
	},

	{ NULL, N_MSG_ARMOR_PLATE_ARMOR,
		ARMOR_KIND_PLATE_ARMOR,
		100, +0, FACE_MNR_ARMOR_BODY, EQUIP_KIND_BODY,
		{ 150, 50, 150, 100, 100, 100, 100, 100, 100 },
		0, 0, 100,
		1, DUN_MAX_LEV, -1, 80,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_ARMOR_CLOAK,
		ARMOR_KIND_CLOAK,
		100, +0, FACE_MNR_ARMOR_ABOUT_BODY, EQUIP_KIND_ABOUT_BODY,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		0, 0, 10,
		1, DUN_MAX_LEV, -1, 80,
		FLG_ITEM_ABL_THI | FLG_ITEM_ABL_MAG_SHA,
	},
/**/
	{ NULL, N_MSG_ARMOR_LEATHER_GLOVES,
		ARMOR_KIND_LEATHER_GLOVES,
		100, +0, FACE_MNR_ARMOR_ARM, EQUIP_KIND_ARM,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		0, 0, 10,
		1, DUN_MAX_LEV, -1, 80,
		FLG_ITEM_ABL_MON | FLG_ITEM_ABL_THI | FLG_ITEM_ABL_SHA,
	},

	{ NULL, N_MSG_ARMOR_GAUNTLETS,
		ARMOR_KIND_GAUNTLETS,
		100, +0, FACE_MNR_ARMOR_ARM, EQUIP_KIND_ARM,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		0, 0, 20,
		1, DUN_MAX_LEV, -1, 80,
		FLG_NULL,
	},

	{ NULL, N_MSG_ARMOR_BUCKLER_SHIELD,
		ARMOR_KIND_BUCKLER_SHIELD,
		100, +0, FACE_MNR_ARMOR_SHIELD, EQUIP_KIND_ARM,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		40, 0, 0,
		1, DUN_MAX_LEV, -1, 80,
		FLG_ITEM_ABL_MON,
	},
/**/
	{ NULL, N_MSG_ARMOR_LEATHER_BOOTS,
		ARMOR_KIND_LEATHER_BOOTS,
		100, +0, FACE_MNR_ARMOR_FEET, EQUIP_KIND_FEET,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		0, 0, 10,
		1, DUN_MAX_LEV, -1, 80,
		FLG_ITEM_ABL_MON | FLG_ITEM_ABL_THI | FLG_ITEM_ABL_MAG_SHA,
	},

	{ NULL, N_MSG_ARMOR_GREAVE,
		ARMOR_KIND_GREAVE,
		100, +0, FACE_MNR_ARMOR_FEET, EQUIP_KIND_FEET,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		0, 0, 20,
		1, DUN_MAX_LEV, -1, 80,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_ARMOR_ROUND_SHIELD,
		ARMOR_KIND_ROUND_SHIELD,
		100, +0, FACE_MNR_ARMOR_SHIELD, EQUIP_KIND_SHIELD,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		40, 0, 0,
		1, DUN_MAX_LEV, -1, 80,
		FLG_NULL,
	},

	{ NULL, N_MSG_ARMOR_KITE_SHIELD,
		ARMOR_KIND_KITE_SHIELD,
		100, +0, FACE_MNR_ARMOR_SHIELD, EQUIP_KIND_SHIELD,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		70, 0, 0,
		1, DUN_MAX_LEV, -1, 80,
		FLG_NULL,
	},

	{ NULL, N_MSG_ARMOR_HEATER_SHIELD,
		ARMOR_KIND_HEATER_SHIELD,
		100, +0, FACE_MNR_ARMOR_SHIELD, EQUIP_KIND_SHIELD,
		{ 100, 100, 100, 100, 100, 100, 100, 100, 100 },
		100, 0, 0,
		1, DUN_MAX_LEV, -1, 80,
		FLG_NULL,
	},
/**/
	{ NULL, N_MSG_NULL,
		ARMOR_KIND_NULL,
		100, +0, FACE_MNR_NULL, EQUIP_KIND_HEAD,
		{ 0, 0, 0, 0, 0, 0, 0, 0, 0 },
		0, 0, 0,
		DUN_MAX_LEV, DUN_MAX_LEV, 0, 0,
		FLG_NULL,
	},
};

potion_tab_t	potion_tab[] = {
#if	0
typedef struct {
	char	*name;
	n_msg_t	name_n;
	potion_kind_t	kind;
	rate_t	rate;
	long	min_lev, max_lev, sgn_lev;
	char	*color;
	n_msg_t	color_n;
	bool_t	flg_identified;
	bool_t	flg_change_color;
} potion_tab_t;
#endif

	{ NULL, N_MSG_ITEM_UNKNOWN,
		POTION_KIND_NULL, 0,
		DUN_MAX_LEV, DUN_MAX_LEV, 0, NULL, N_MSG_NULL,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_WATER,
		POTION_KIND_WATER, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_CRYSTAL,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_MILK,
		POTION_KIND_MILK, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_MILK,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_RED_WINE,
		POTION_KIND_RED_WINE, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_RED_WINE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_WHITE_WINE,
		POTION_KIND_WHITE_WINE, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_WHITE_WINE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_ROSE_WINE,
		POTION_KIND_ROSE_WINE, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_ROSE_WINE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_ALE,
		POTION_KIND_ALE, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_ALE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_BRANDY,
		POTION_KIND_BRANDY, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_BRANDY,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_RUM,
		POTION_KIND_RUM, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_RUM,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_COFFE,
		POTION_KIND_COFFE, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_COFFE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_ICE_COFFE,
		POTION_KIND_ICE_COFFE, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_ICE_COFFE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_TEA,
		POTION_KIND_TEA, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_TEA,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_MILK_TEA,
		POTION_KIND_MILK_TEA, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_MILK_TEA,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_LEMON_TEA,
		POTION_KIND_LEMON_TEA, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_LEMON_TEA,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_ICE_TEA,
		POTION_KIND_ICE_TEA, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_ICE_TEA,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_ICE_MILK_TEA,
		POTION_KIND_ICE_MILK_TEA, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_ICE_MILK_TEA,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_ICE_LEMON_TEA,
		POTION_KIND_ICE_LEMON_TEA, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_ICE_LEMON_TEA,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_APPLE_JUICE,
		POTION_KIND_APPLE_JUICE, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_APPLE_JUICE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_GRAPE_JUICE,
		POTION_KIND_GRAPE_JUICE, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_GRAPE_JUICE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_ORANGE_JUICE,
		POTION_KIND_ORANGE_JUICE, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_ORANGE_JUICE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_BLACK_BERRY_JUICE,
		POTION_KIND_BLACK_BERRY_JUICE, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_BLACK_BERRY_JUICE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_CRAN_BERRY_JUICE,
		POTION_KIND_CRAN_BERRY_JUICE, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_CRAN_BERRY_JUICE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_RASP_BERRY_JUICE,
		POTION_KIND_RASP_BERRY_JUICE, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_RASP_BERRY_JUICE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_STRAW_BERRY_JUICE,
		POTION_KIND_STRAW_BERRY_JUICE, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_STRAW_BERRY_JUICE,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_OIL,
		POTION_KIND_OIL, 80,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_POTION_COLOR_CRYSTAL_YELLOW,
		FALSE, FALSE },

	{ NULL, N_MSG_POTION_STONE,
		POTION_KIND_STONE, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_PARALYZE,
		POTION_KIND_PARALYZE, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_POISON,
		POTION_KIND_POISON, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_CONFUSION,
		POTION_KIND_CONFUSION, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_BLIND,
		POTION_KIND_BLIND, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_SLEEP,
		POTION_KIND_SLEEP, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_SILENCE,
		POTION_KIND_SILENCE, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_FEAR,
		POTION_KIND_FEAR, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_HALLUCINATION,
		POTION_KIND_HALLUCINATION, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_CHARM,
		POTION_KIND_CHARM, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_CURE_LEV,
		POTION_KIND_CURE_LEV, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_CURE_HP_LIGHT,
		POTION_KIND_CURE_HP_LIGHT, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_CURE_HP_MODERATE,
		POTION_KIND_CURE_HP_MODERATE, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_CURE_HP_SERIOUS,
		POTION_KIND_CURE_HP_SERIOUS, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_CURE_HP_MAX,
		POTION_KIND_CURE_HP_MAX, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_CURE_POISON,
		POTION_KIND_CURE_POISON, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_CURE_STATUS,
		POTION_KIND_CURE_STATUS, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_DETECT_MNSTR,
		POTION_KIND_DETECT_MNSTR, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_DULLNESS,
		POTION_KIND_DULLNESS, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_FLY,
		POTION_KIND_FLY, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_POW_UP_HP,
		POTION_KIND_POW_UP_HP, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_SPEED_UP,
		POTION_KIND_SPEED_UP, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_SPEED_DOWN,
		POTION_KIND_SPEED_DOWN, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_QUICKNESS,
		POTION_KIND_QUICKNESS, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_RESI_PHYS,
		POTION_KIND_RESI_PHYS, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_RESI_WIND,
		POTION_KIND_RESI_WIND, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_RESI_HEAT,
		POTION_KIND_RESI_HEAT, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_RESI_COLD,
		POTION_KIND_RESI_COLD, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_RESI_ELEC,
		POTION_KIND_RESI_ELEC, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_RESI_ACID,
		POTION_KIND_RESI_ACID, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_RESI_POIS,
		POTION_KIND_RESI_POIS, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_SENSE_INVISIBLE,
		POTION_KIND_SENSE_INVISIBLE, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_SHARPNESS,
		POTION_KIND_SHARPNESS, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_SLOWNESS,
		POTION_KIND_SLOWNESS, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_STRENGTH,
		POTION_KIND_STRENGTH, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_VANISH,
		POTION_KIND_VANISH, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_POTION_WEAKNESS,
		POTION_KIND_WEAKNESS, 80,
		1, DUN_MAX_LEV, -1, NULL,
		FALSE, TRUE },

	{ NULL, N_MSG_NULL,
		POTION_KIND_NULL, 0,
		DUN_MAX_LEV, DUN_MAX_LEV, 0, NULL, N_MSG_NULL,
		FALSE, FALSE },
};

long	color_tab_max_n;
color_tab_t	color_tab[] = {
	{ N_MSG_POTION_COLOR_CRYSTAL, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_WHITE, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_BLACK, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_RED, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_GREEN, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_BLUE, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_YELLOW, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_RED_PURPLE, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_BLUE_PURPLE, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_ORANGE, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_PINK, FALSE },
	{ N_MSG_POTION_COLOR_CRYSTAL_BROWN, FALSE },
	{ N_MSG_POTION_COLOR_WHITE, FALSE },
	{ N_MSG_POTION_COLOR_BLACK, FALSE },
	{ N_MSG_POTION_COLOR_RED, FALSE },
	{ N_MSG_POTION_COLOR_GREEN, FALSE },
	{ N_MSG_POTION_COLOR_BLUE, FALSE },
	{ N_MSG_POTION_COLOR_YELLOW, FALSE },
	{ N_MSG_POTION_COLOR_RED_PURPLE, FALSE },
	{ N_MSG_POTION_COLOR_BLUE_PURPLE, FALSE },
	{ N_MSG_POTION_COLOR_ORANGE, FALSE },
	{ N_MSG_POTION_COLOR_PINK, FALSE },
	{ N_MSG_POTION_COLOR_BROWN, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_WHITE, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_BLACK, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_RED, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_GREEN, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_BLUE, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_YELLOW, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_RED_PURPLE, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_BLUE_PURPLE, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_ORANGE, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_PINK, FALSE },
	{ N_MSG_POTION_COLOR_LUMINOUS_BROWN, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_WHITE, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_BLACK, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_RED, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_GREEN, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_BLUE, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_YELLOW, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_RED_PURPLE, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_BLUE_PURPLE, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_ORANGE, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_PINK, FALSE },
	{ N_MSG_POTION_COLOR_SPOTTED_BROWN, FALSE },
	{ N_MSG_POTION_COLOR_MILK, FALSE },
	{ N_MSG_POTION_COLOR_RED_WINE, FALSE },
	{ N_MSG_POTION_COLOR_WHITE_WINE, FALSE },
	{ N_MSG_POTION_COLOR_ROSE_WINE, FALSE },
	{ N_MSG_POTION_COLOR_ALE, FALSE },
	{ N_MSG_POTION_COLOR_BRANDY, FALSE },
	{ N_MSG_POTION_COLOR_RUM, FALSE },
	{ N_MSG_POTION_COLOR_COFFE, FALSE },
	{ N_MSG_POTION_COLOR_ICE_COFFE, FALSE },
	{ N_MSG_POTION_COLOR_TEA, FALSE },
	{ N_MSG_POTION_COLOR_MILK_TEA, FALSE },
	{ N_MSG_POTION_COLOR_LEMON_TEA, FALSE },
	{ N_MSG_POTION_COLOR_ICE_TEA, FALSE },
	{ N_MSG_POTION_COLOR_ICE_MILK_TEA, FALSE },
	{ N_MSG_POTION_COLOR_ICE_LEMON_TEA, FALSE },
	{ N_MSG_POTION_COLOR_APPLE_JUICE, FALSE },
	{ N_MSG_POTION_COLOR_GRAPE_JUICE, FALSE },
	{ N_MSG_POTION_COLOR_ORANGE_JUICE, FALSE },
	{ N_MSG_POTION_COLOR_BLACK_BERRY_JUICE, FALSE },
	{ N_MSG_POTION_COLOR_CRAN_BERRY_JUICE, FALSE },
	{ N_MSG_POTION_COLOR_RASP_BERRY_JUICE, FALSE },
	{ N_MSG_POTION_COLOR_STRAW_BERRY_JUICE, FALSE },
	{ N_MSG_NULL, FALSE },
};

scroll_tab_t	scroll_tab[] = {
#if	0
typedef struct {
	char	*name;
	n_msg_t	name_n;
	scroll_kind_t	kind;
	rate_t	rate;
	long	min_lev, max_lev, sgn_lev;
	char	ttl[SCROLL_TTL_MAX_LEN + 1];
	bool_t	flg_identified;
} scroll_tab_t;
#endif

	{ NULL, N_MSG_ITEM_UNKNOWN, SCROLL_KIND_NULL, 0,
		DUN_MAX_LEV, DUN_MAX_LEV, 0, "", FALSE },

	{ NULL, N_MSG_SCROLL_SLEEP, SCROLL_KIND_SLEEP, 80,
		1, DUN_MAX_LEV, -1, "", FALSE },

	{ NULL, N_MSG_SCROLL_IDENTIFY_ITEM, SCROLL_KIND_IDENTIFY_ITEM, 80,
		1, DUN_MAX_LEV, -1, "", FALSE },

	{ NULL, N_MSG_SCROLL_DETECT_ITEM, SCROLL_KIND_DETECT_ITEM, 80,
		1, DUN_MAX_LEV, -1, "", FALSE },

	{ NULL, N_MSG_SCROLL_TELEPORT, SCROLL_KIND_TELEPORT, 80,
		1, DUN_MAX_LEV, -1, "", FALSE },

	{ NULL, N_MSG_SCROLL_POW_UP_WPN_HIT, SCROLL_KIND_POW_UP_WPN_HIT, 80,
		1, DUN_MAX_LEV, -1, "", FALSE },

	{ NULL, N_MSG_SCROLL_POW_UP_WPN_DAM, SCROLL_KIND_POW_UP_WPN_DAM, 80,
		1, DUN_MAX_LEV, -1, "", FALSE },

	{ NULL, N_MSG_SCROLL_REMOVE_CURSE, SCROLL_KIND_REMOVE_CURSE, 80,
		1, DUN_MAX_LEV, -1, "", FALSE },

	{ NULL, N_MSG_SCROLL_RECALL, SCROLL_KIND_RECALL, 80,
		1, DUN_MAX_LEV, -1, "", FALSE },

	{ NULL, N_MSG_NULL, SCROLL_KIND_NULL, 0,
		DUN_MAX_LEV, DUN_MAX_LEV, 0, "", FALSE },
};

long	ttl_syllable_tab_max_n;
ttl_syllable_tab_t	ttl_syllable_tab[] = {
	N_MSG_SCROLL_TTL_SYLLABLE_000,
	N_MSG_SCROLL_TTL_SYLLABLE_001,
	N_MSG_SCROLL_TTL_SYLLABLE_002,
	N_MSG_SCROLL_TTL_SYLLABLE_010,
	N_MSG_SCROLL_TTL_SYLLABLE_011,
	N_MSG_SCROLL_TTL_SYLLABLE_012,
	N_MSG_SCROLL_TTL_SYLLABLE_013,
	N_MSG_SCROLL_TTL_SYLLABLE_020,
	N_MSG_SCROLL_TTL_SYLLABLE_021,
	N_MSG_SCROLL_TTL_SYLLABLE_030,
	N_MSG_SCROLL_TTL_SYLLABLE_031,
	N_MSG_SCROLL_TTL_SYLLABLE_032,
	N_MSG_SCROLL_TTL_SYLLABLE_040,
	N_MSG_SCROLL_TTL_SYLLABLE_041,
	N_MSG_SCROLL_TTL_SYLLABLE_042,
	N_MSG_SCROLL_TTL_SYLLABLE_050,
	N_MSG_SCROLL_TTL_SYLLABLE_051,
	N_MSG_SCROLL_TTL_SYLLABLE_052,
	N_MSG_SCROLL_TTL_SYLLABLE_060,
	N_MSG_SCROLL_TTL_SYLLABLE_061,
	N_MSG_SCROLL_TTL_SYLLABLE_070,
	N_MSG_SCROLL_TTL_SYLLABLE_071,
	N_MSG_SCROLL_TTL_SYLLABLE_072,
	N_MSG_SCROLL_TTL_SYLLABLE_080,
	N_MSG_SCROLL_TTL_SYLLABLE_081,
	N_MSG_SCROLL_TTL_SYLLABLE_082,
	N_MSG_SCROLL_TTL_SYLLABLE_090,
	N_MSG_SCROLL_TTL_SYLLABLE_091,
	N_MSG_SCROLL_TTL_SYLLABLE_092,
	N_MSG_SCROLL_TTL_SYLLABLE_101,
	N_MSG_SCROLL_TTL_SYLLABLE_102,
	N_MSG_SCROLL_TTL_SYLLABLE_103,
	N_MSG_SCROLL_TTL_SYLLABLE_104,
	N_MSG_SCROLL_TTL_SYLLABLE_110,
	N_MSG_SCROLL_TTL_SYLLABLE_111,
	N_MSG_SCROLL_TTL_SYLLABLE_120,
	N_MSG_SCROLL_TTL_SYLLABLE_121,
	N_MSG_SCROLL_TTL_SYLLABLE_130,
	N_MSG_SCROLL_TTL_SYLLABLE_131,
	N_MSG_NULL,
};

stick_tab_t	stick_tab[] = {
#if	0
typedef struct {
	char	*name;
	n_msg_t	name_n;
	rate_t	rate;
	long	use_n;
	wand_kind_t	wand_kind;
	staff_kind_t	staff_kind;
	long	min_lev, max_lev, sgn_lev;
	char	*material;
	n_msg_t	material_n;
	bool_t	flg_identified;
} stick_tab_t;
#endif

	{ NULL, N_MSG_ITEM_UNKNOWN, 0, 0,
		STICK_KIND_NULL, SPELL_KIND_NULL,
		DUN_MAX_LEV, DUN_MAX_LEV, 0, NULL, N_MSG_NULL, FALSE },
/* wand */
	{ NULL, N_MSG_SPELL_NOTHING, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_NOTHING,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_TELEPORT, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_TELEPORT,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_TELEPORT_PARTY, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_TELEPORT_PARTY,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_FIRE_BALL, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_FIRE_BALL,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_ICE_BLIZZARD, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_ICE_BLIZZARD,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_MIND_STORM, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_MIND_STORM,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_ACID_RAIN, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_ACID_RAIN,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_LIGHTNING_BOLT, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_LIGHTNING_BOLT,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_POISON_CLOUD, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_POISON_CLOUD,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_STONE, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_STONE,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_PARALYZE, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_PARALYZE,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_POISON, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_POISON,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_CONFUSION, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_CONFUSION,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_BLINDNESS, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_BLINDNESS,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SLEEP, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_SLEEP,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SILENCE, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_SILENCE,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_FEAR, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_FEAR,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_HALLUCINATION, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_HALLUCINATION,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_CHARM, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_CHARM,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SHARPNESS, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_SHARPNESS,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_DULLNESS, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_DULLNESS,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_STRENGTH, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_STRENGTH,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_WEAKNESS, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_WEAKNESS,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_QUICKNESS, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_QUICKNESS,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SLOWNESS, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_SLOWNESS,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_WISE, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_WISE,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_FOOLISH, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_FOOLISH,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_BRAINY, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_BRAINY,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_BRAINLESS, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_BRAINLESS,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_ATTRACTIVE, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_ATTRACTIVE,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_UNATTRACTIVE, 80, 16,
		STICK_KIND_WAND, SPELL_KIND_UNATTRACTIVE,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },
/* rod */
	{ NULL, N_MSG_SPELL_NOTHING, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_NOTHING,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_TELEPORT, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_TELEPORT,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_TELEPORT_PARTY, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_TELEPORT_PARTY,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_FIRE_BALL, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_FIRE_BALL,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_ICE_BLIZZARD, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_ICE_BLIZZARD,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_MIND_STORM, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_MIND_STORM,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_ACID_RAIN, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_ACID_RAIN,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_LIGHTNING_BOLT, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_LIGHTNING_BOLT,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_POISON_CLOUD, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_POISON_CLOUD,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_STONE, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_STONE,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_PARALYZE, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_PARALYZE,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_POISON, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_POISON,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_CONFUSION, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_CONFUSION,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_BLINDNESS, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_BLINDNESS,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SLEEP, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_SLEEP,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SILENCE, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_SILENCE,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_FEAR, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_FEAR,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_HALLUCINATION, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_HALLUCINATION,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_CHARM, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_CHARM,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SHARPNESS, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_SHARPNESS,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_DULLNESS, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_DULLNESS,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_STRENGTH, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_STRENGTH,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_WEAKNESS, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_WEAKNESS,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_QUICKNESS, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_QUICKNESS,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SLOWNESS, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_SLOWNESS,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_WISE, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_WISE,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_FOOLISH, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_FOOLISH,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_BRAINY, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_BRAINY,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_BRAINLESS, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_BRAINLESS,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_ATTRACTIVE, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_ATTRACTIVE,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_UNATTRACTIVE, 80, 12,
		STICK_KIND_ROD, SPELL_KIND_UNATTRACTIVE,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },
/* staff */
	{ NULL, N_MSG_SPELL_NOTHING, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_NOTHING,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_TELEPORT, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_TELEPORT,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_TELEPORT_PARTY, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_TELEPORT_PARTY,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_FIRE_BALL, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_FIRE_BALL,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_ICE_BLIZZARD, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_ICE_BLIZZARD,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_MIND_STORM, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_MIND_STORM,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_ACID_RAIN, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_ACID_RAIN,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_LIGHTNING_BOLT, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_LIGHTNING_BOLT,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_POISON_CLOUD, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_POISON_CLOUD,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_STONE, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_STONE,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_PARALYZE, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_PARALYZE,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_POISON, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_POISON,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_CONFUSION, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_CONFUSION,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_BLINDNESS, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_BLINDNESS,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SLEEP, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_SLEEP,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SILENCE, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_SILENCE,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_FEAR, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_FEAR,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_HALLUCINATION, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_HALLUCINATION,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_CHARM, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_CHARM,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SHARPNESS, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_SHARPNESS,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_DULLNESS, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_DULLNESS,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_STRENGTH, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_STRENGTH,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_WEAKNESS, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_WEAKNESS,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_QUICKNESS, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_QUICKNESS,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_SLOWNESS, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_SLOWNESS,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_WISE, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_WISE,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_FOOLISH, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_FOOLISH,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_BRAINY, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_BRAINY,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_BRAINLESS, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_BRAINLESS,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_ATTRACTIVE, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_ATTRACTIVE,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },

	{ NULL, N_MSG_SPELL_UNATTRACTIVE, 80, 8,
		STICK_KIND_STAFF, SPELL_KIND_UNATTRACTIVE,
		1, DUN_MAX_LEV, -1, NULL, N_MSG_NULL, FALSE },
/* end */
	{ NULL, N_MSG_NULL, 0, 0,
		STICK_KIND_NULL, SPELL_KIND_NULL,
		DUN_MAX_LEV, DUN_MAX_LEV, 0, NULL, N_MSG_NULL, FALSE },
};

long	wand_material_tab_max_n;
material_tab_t	wand_material_tab[] = {
	{ N_MSG_STICK_MATERIAL_APPLEWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_ASHEN, FALSE },
	{ N_MSG_STICK_MATERIAL_ASPEN, FALSE },
	{ N_MSG_STICK_MATERIAL_AVOCADO_WOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_BALSA, FALSE },
	{ N_MSG_STICK_MATERIAL_BANYAN, FALSE },
	{ N_MSG_STICK_MATERIAL_BIRCH, FALSE },
	{ N_MSG_STICK_MATERIAL_CEDAR, FALSE },
	{ N_MSG_STICK_MATERIAL_CHERRYWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_COTTONWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_CYPRESS, FALSE },
	{ N_MSG_STICK_MATERIAL_DOGWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_DRIFTWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_EBONY, FALSE },
	{ N_MSG_STICK_MATERIAL_ELM_WOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_EUCALYPTUS, FALSE },
	{ N_MSG_STICK_MATERIAL_GRAPEVINE, FALSE },
	{ N_MSG_STICK_MATERIAL_HAWTHORN, FALSE },
	{ N_MSG_STICK_MATERIAL_HEMLOCK, FALSE },
	{ N_MSG_STICK_MATERIAL_HICKORY, FALSE },
	{ N_MSG_STICK_MATERIAL_JUNIPER, FALSE },
	{ N_MSG_STICK_MATERIAL_LOCUST, FALSE },
	{ N_MSG_STICK_MATERIAL_MAHOGANY, FALSE },
	{ N_MSG_STICK_MATERIAL_MAGNOLIA, FALSE },
	{ N_MSG_STICK_MATERIAL_MAPLE, FALSE },
	{ N_MSG_STICK_MATERIAL_MULBERRY, FALSE },
	{ N_MSG_STICK_MATERIAL_OAK, FALSE },
	{ N_MSG_STICK_MATERIAL_PECAN, FALSE },
	{ N_MSG_STICK_MATERIAL_PERSIMMON, FALSE },
	{ N_MSG_STICK_MATERIAL_PINE, FALSE },
	{ N_MSG_STICK_MATERIAL_REDWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_ROSEWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_SPRUCE, FALSE },
	{ N_MSG_STICK_MATERIAL_SUMAC, FALSE },
	{ N_MSG_STICK_MATERIAL_SYCAMORE, FALSE },
	{ N_MSG_STICK_MATERIAL_TEAK, FALSE },
	{ N_MSG_STICK_MATERIAL_WALNUT, FALSE },
	{ N_MSG_NULL, FALSE },
};

long	rod_material_tab_max_n;
material_tab_t	rod_material_tab[] = {
	{ N_MSG_STICK_MATERIAL_APPLEWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_ASHEN, FALSE },
	{ N_MSG_STICK_MATERIAL_ASPEN, FALSE },
	{ N_MSG_STICK_MATERIAL_AVOCADO_WOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_BALSA, FALSE },
	{ N_MSG_STICK_MATERIAL_BANYAN, FALSE },
	{ N_MSG_STICK_MATERIAL_BIRCH, FALSE },
	{ N_MSG_STICK_MATERIAL_CEDAR, FALSE },
	{ N_MSG_STICK_MATERIAL_CHERRYWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_COTTONWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_CYPRESS, FALSE },
	{ N_MSG_STICK_MATERIAL_DOGWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_DRIFTWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_EBONY, FALSE },
	{ N_MSG_STICK_MATERIAL_ELM_WOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_EUCALYPTUS, FALSE },
	{ N_MSG_STICK_MATERIAL_GRAPEVINE, FALSE },
	{ N_MSG_STICK_MATERIAL_HAWTHORN, FALSE },
	{ N_MSG_STICK_MATERIAL_HEMLOCK, FALSE },
	{ N_MSG_STICK_MATERIAL_HICKORY, FALSE },
	{ N_MSG_STICK_MATERIAL_JUNIPER, FALSE },
	{ N_MSG_STICK_MATERIAL_LOCUST, FALSE },
	{ N_MSG_STICK_MATERIAL_MAHOGANY, FALSE },
	{ N_MSG_STICK_MATERIAL_MAGNOLIA, FALSE },
	{ N_MSG_STICK_MATERIAL_MAPLE, FALSE },
	{ N_MSG_STICK_MATERIAL_MULBERRY, FALSE },
	{ N_MSG_STICK_MATERIAL_OAK, FALSE },
	{ N_MSG_STICK_MATERIAL_PECAN, FALSE },
	{ N_MSG_STICK_MATERIAL_PERSIMMON, FALSE },
	{ N_MSG_STICK_MATERIAL_PINE, FALSE },
	{ N_MSG_STICK_MATERIAL_REDWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_ROSEWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_SPRUCE, FALSE },
	{ N_MSG_STICK_MATERIAL_SUMAC, FALSE },
	{ N_MSG_STICK_MATERIAL_SYCAMORE, FALSE },
	{ N_MSG_STICK_MATERIAL_TEAK, FALSE },
	{ N_MSG_STICK_MATERIAL_WALNUT, FALSE },
	{ N_MSG_NULL, FALSE },
};

long	staff_material_tab_max_n;
material_tab_t	staff_material_tab[] = {
	{ N_MSG_STICK_MATERIAL_APPLEWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_ASHEN, FALSE },
	{ N_MSG_STICK_MATERIAL_ASPEN, FALSE },
	{ N_MSG_STICK_MATERIAL_AVOCADO_WOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_BALSA, FALSE },
	{ N_MSG_STICK_MATERIAL_BANYAN, FALSE },
	{ N_MSG_STICK_MATERIAL_BIRCH, FALSE },
	{ N_MSG_STICK_MATERIAL_CEDAR, FALSE },
	{ N_MSG_STICK_MATERIAL_CHERRYWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_COTTONWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_CYPRESS, FALSE },
	{ N_MSG_STICK_MATERIAL_DOGWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_DRIFTWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_EBONY, FALSE },
	{ N_MSG_STICK_MATERIAL_ELM_WOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_EUCALYPTUS, FALSE },
	{ N_MSG_STICK_MATERIAL_GRAPEVINE, FALSE },
	{ N_MSG_STICK_MATERIAL_HAWTHORN, FALSE },
	{ N_MSG_STICK_MATERIAL_HEMLOCK, FALSE },
	{ N_MSG_STICK_MATERIAL_HICKORY, FALSE },
	{ N_MSG_STICK_MATERIAL_JUNIPER, FALSE },
	{ N_MSG_STICK_MATERIAL_LOCUST, FALSE },
	{ N_MSG_STICK_MATERIAL_MAHOGANY, FALSE },
	{ N_MSG_STICK_MATERIAL_MAGNOLIA, FALSE },
	{ N_MSG_STICK_MATERIAL_MAPLE, FALSE },
	{ N_MSG_STICK_MATERIAL_MULBERRY, FALSE },
	{ N_MSG_STICK_MATERIAL_OAK, FALSE },
	{ N_MSG_STICK_MATERIAL_PECAN, FALSE },
	{ N_MSG_STICK_MATERIAL_PERSIMMON, FALSE },
	{ N_MSG_STICK_MATERIAL_PINE, FALSE },
	{ N_MSG_STICK_MATERIAL_REDWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_ROSEWOOD, FALSE },
	{ N_MSG_STICK_MATERIAL_SPRUCE, FALSE },
	{ N_MSG_STICK_MATERIAL_SUMAC, FALSE },
	{ N_MSG_STICK_MATERIAL_SYCAMORE, FALSE },
	{ N_MSG_STICK_MATERIAL_TEAK, FALSE },
	{ N_MSG_STICK_MATERIAL_WALNUT, FALSE },
	{ N_MSG_NULL, FALSE },
};

acce_tab_t	acce_tab[] = {
#if	0
	char	*name;
	n_msg_t	name_n;
	acce_kind_t	kind;
	ring_kind_t	ring_kind;
	amulet_kind_t	amulet_kind;
	necklace_kind_t	necklace_kind;
	rate_t	rate;
	long	min_lev, max_lev, sgn_lev;
	char	mnr;
	equip_kind_t	equip_kind;
	char	*material;
	n_msg_t	material_n;
	bool_t	flg_identified;
	rate_t	rate_curse;
#endif

	{ NULL, N_MSG_ITEM_UNKNOWN,
		ACCE_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		0, DUN_MAX_LEV, DUN_MAX_LEV, 0, FACE_MNR_NULL,
		EQUIP_KIND_MAX_N, NULL, N_MSG_NULL, FALSE, 0 },

	{ NULL, N_MSG_RING_SLOW_DIGESTION,
		ACCE_KIND_RING,
		RING_KIND_SLOW_DIGESTION,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		80, 1, DUN_MAX_LEV, -1, FACE_MNR_RING,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, 10 },

	{ NULL, N_MSG_RING_TELEPORT_PARTY,
		ACCE_KIND_RING,
		RING_KIND_TELEPORT_PARTY,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		80, 1, DUN_MAX_LEV, -1, FACE_MNR_RING,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, 10 },

	{ NULL, N_MSG_RING_TELEPORT,
		ACCE_KIND_RING,
		RING_KIND_TELEPORT,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		80, 1, DUN_MAX_LEV, -1, FACE_MNR_RING,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, 10 },

	{ NULL, N_MSG_AMULET_RESI_PHYS,
		ACCE_KIND_AMULET,
		RING_KIND_NULL,
		AMULET_KIND_RESI_PHYS,
		NECKLACE_KIND_NULL,
		80, 1, DUN_MAX_LEV, -1, FACE_MNR_AMULET,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, 10 },

	{ NULL, N_MSG_AMULET_RESI_WIND,
		ACCE_KIND_AMULET,
		RING_KIND_NULL,
		AMULET_KIND_RESI_WIND,
		NECKLACE_KIND_NULL,
		80, 1, DUN_MAX_LEV, -1, FACE_MNR_AMULET,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, 10 },

	{ NULL, N_MSG_AMULET_RESI_HEAT,
		ACCE_KIND_AMULET,
		RING_KIND_NULL,
		AMULET_KIND_RESI_HEAT,
		NECKLACE_KIND_NULL,
		80, 1, DUN_MAX_LEV, -1, FACE_MNR_AMULET,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, 10 },

	{ NULL, N_MSG_AMULET_RESI_COLD,
		ACCE_KIND_AMULET,
		RING_KIND_NULL,
		AMULET_KIND_RESI_COLD,
		NECKLACE_KIND_NULL,
		80, 1, DUN_MAX_LEV, -1, FACE_MNR_AMULET,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, 10 },

	{ NULL, N_MSG_AMULET_RESI_ELEC,
		ACCE_KIND_AMULET,
		RING_KIND_NULL,
		AMULET_KIND_RESI_ELEC,
		NECKLACE_KIND_NULL,
		80, 1, DUN_MAX_LEV, -1, FACE_MNR_AMULET,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, 10 },

	{ NULL, N_MSG_AMULET_RESI_ACID,
		ACCE_KIND_AMULET,
		RING_KIND_NULL,
		AMULET_KIND_RESI_ACID,
		NECKLACE_KIND_NULL,
		80, 1, DUN_MAX_LEV, -1, FACE_MNR_AMULET,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, 10 },

	{ NULL, N_MSG_AMULET_RESI_POIS,
		ACCE_KIND_AMULET,
		RING_KIND_NULL,
		AMULET_KIND_RESI_POIS,
		NECKLACE_KIND_NULL,
		80, 1, DUN_MAX_LEV, -1, FACE_MNR_AMULET,
		EQUIP_KIND_RIGHT_HAND, NULL, N_MSG_NULL, FALSE, 10 },

	{ NULL, N_MSG_NULL,
		ACCE_KIND_NULL,
		RING_KIND_NULL,
		AMULET_KIND_NULL,
		NECKLACE_KIND_NULL,
		0, DUN_MAX_LEV, DUN_MAX_LEV, 0, FACE_MNR_NULL,
		EQUIP_KIND_MAX_N, NULL, N_MSG_NULL, FALSE, 0 },
};

long	ring_material_tab_max_n;
ring_material_tab_t	ring_material_tab[] = {
	{ N_MSG_RING_MATERIAL_ALUMINUM, FALSE },
	{ N_MSG_RING_MATERIAL_BONE, FALSE },
	{ N_MSG_RING_MATERIAL_BRASS, FALSE },
	{ N_MSG_RING_MATERIAL_BRONZE, FALSE },
	{ N_MSG_RING_MATERIAL_CAST_IRON, FALSE },
	{ N_MSG_RING_MATERIAL_CHROMIUM, FALSE },
	{ N_MSG_RING_MATERIAL_COPPER, FALSE },
	{ N_MSG_RING_MATERIAL_GOLD, FALSE },
	{ N_MSG_RING_MATERIAL_IRON, FALSE },
	{ N_MSG_RING_MATERIAL_LEAD, FALSE },
	{ N_MSG_RING_MATERIAL_MAGNESIUM, FALSE },
	{ N_MSG_RING_MATERIAL_MOLYBDENUM, FALSE },
	{ N_MSG_RING_MATERIAL_NICKEL, FALSE },
	{ N_MSG_RING_MATERIAL_PEWTER, FALSE },
	{ N_MSG_RING_MATERIAL_SILVER, FALSE },
	{ N_MSG_RING_MATERIAL_STEEL, FALSE },
	{ N_MSG_RING_MATERIAL_TIN, FALSE },
	{ N_MSG_RING_MATERIAL_TITANIUM, FALSE },
	{ N_MSG_RING_MATERIAL_TUNGSTEN, FALSE },
	{ N_MSG_RING_MATERIAL_ZINC, FALSE },
	{ N_MSG_NULL, FALSE },
};

light_tab_t	light_tab[] = {
#if	0
typedef struct {
	char	*name;
	n_msg_t	name_n;
	light_kind_t	kind;
	rate_t	rate;
	long	min_lev, max_lev, sgn_lev;
	long	max_turn;
	bool_t	flg_fill;
} light_tab_t;
#endif

	{ NULL, N_MSG_ITEM_UNKNOWN, LIGHT_KIND_NULL, 0,
		DUN_MAX_LEV, DUN_MAX_LEV, 0, 0, 0 },

	{ NULL, N_MSG_LIGHT_TORCH, LIGHT_KIND_TORCH, 80,
		0, DUN_MAX_LEV, -1, LIGHT_MAX_TURN_TORCH, FALSE },

	{ NULL, N_MSG_LIGHT_LANTERN, LIGHT_KIND_LANTERN, 80,
		0, DUN_MAX_LEV, -1, LIGHT_MAX_TURN_LANTERN, TRUE },

	{ NULL, N_MSG_LIGHT_LAMP, LIGHT_KIND_LAMP, 80,
		0, DUN_MAX_LEV, -1, LIGHT_MAX_TURN_LAMP, TRUE },

	{ NULL, N_MSG_NULL, LIGHT_KIND_NULL, 0,
		DUN_MAX_LEV, DUN_MAX_LEV, 0, 0, 0 },
};

food_tab_t	food_tab[] = {
#if	0
typedef struct {
	char	*name;
	n_msg_t	name_n;
	food_kind_t	kind;
	rate_t	rate;
	long	ave_n;
	rate_t	fill_rate;
} food_tab_t;
#endif

	{ NULL, N_MSG_ITEM_UNKNOWN, FOOD_KIND_NULL,
		0, 0, 0 },
	{ NULL, N_MSG_FOOD_PRESERVED, FOOD_KIND_PRESERVED,
		80, 1, 50 },
	{ NULL, N_MSG_FOOD_CHIPPED_BEEF, FOOD_KIND_CHIPPED_BEEF,
		80, 3, 20 },
	{ NULL, N_MSG_FOOD_CORNED_BEEF, FOOD_KIND_CORNED_BEEF,
		80, 3, 20 },
	{ NULL, N_MSG_FOOD_BREAD, FOOD_KIND_BREAD,
		80, 2, 20 },
	{ NULL, N_MSG_FOOD_BROWN_BREAD, FOOD_KIND_BROWN_BREAD,
		80, 2, 20 },
	{ NULL, N_MSG_FOOD_TOAST, FOOD_KIND_TOAST,
		10, 2, 20 },
	{ NULL, N_MSG_FOOD_PANCAKE, FOOD_KIND_PANCAKE,
		80, 2, 30 },
	{ NULL, N_MSG_FOOD_SALAD, FOOD_KIND_SALAD,
		10, 2, 20 },
	{ NULL, N_MSG_FOOD_POTATO_SALAD, FOOD_KIND_POTATO_SALAD,
		10, 2, 20 },
	{ NULL, N_MSG_FOOD_SCRAMBLED_EGGS, FOOD_KIND_SCRAMBLED_EGGS,
		10, 2, 10 },
	{ NULL, N_MSG_FOOD_FRIED_EGGS, FOOD_KIND_FRIED_EGGS,
		10, 2, 10 },
	{ NULL, N_MSG_FOOD_HARD_BOILED_EGGS, FOOD_KIND_HARD_BOILED_EGGS,
		10, 2, 10 },
	{ NULL, N_MSG_FOOD_SOFT_BOILED_EGGS, FOOD_KIND_SOFT_BOILED_EGGS,
		10, 2, 10 },
	{ NULL, N_MSG_FOOD_BEEF_STEAK, FOOD_KIND_BEEF_STEAK,
		10, 2, 50 },
	{ NULL, N_MSG_FOOD_PORK_SAUTE, FOOD_KIND_PORK_SAUTE,
		10, 2, 50 },
	{ NULL, N_MSG_FOOD_FRIED_CHICKEN, FOOD_KIND_FRIED_CHICKEN,
		10, 2, 40 },
	{ NULL, N_MSG_FOOD_FRIED_FISH, FOOD_KIND_FRIED_FISH,
		10, 2, 30 },
	{ NULL, N_MSG_FOOD_FRIED_POTATO, FOOD_KIND_FRIED_POTATO,
		10, 2, 30 },
	{ NULL, N_MSG_FOOD_STEWED_BEEF, FOOD_KIND_STEWED_BEEF,
		10, 2, 50 },
	{ NULL, N_MSG_FOOD_CONSOMME, FOOD_KIND_CONSOMME,
		10, 2, 30 },
	{ NULL, N_MSG_FOOD_POTAGE, FOOD_KIND_POTAGE,
		10, 2, 40 },
	{ NULL, N_MSG_FOOD_APPLE_PIE, FOOD_KIND_APPLE_PIE,
		10, 2, 30 },
	{ NULL, N_MSG_FOOD_APPLE, FOOD_KIND_APPLE,
		10, 2, 10 },
	{ NULL, N_MSG_FOOD_GRAPE, FOOD_KIND_GRAPE,
		10, 2, 10 },
	{ NULL, N_MSG_FOOD_ORANGE, FOOD_KIND_ORANGE,
		10, 2, 10 },
	{ NULL, N_MSG_FOOD_PEAR, FOOD_KIND_PEAR,
		10, 2, 10 },
	{ NULL, N_MSG_FOOD_GRAPEFRUIT, FOOD_KIND_GRAPEFRUIT,
		10, 2, 10 },
	{ NULL, N_MSG_FOOD_PLUM, FOOD_KIND_PLUM,
		10, 2, 10 },
	{ NULL, N_MSG_FOOD_PEACH, FOOD_KIND_PEACH,
		10, 2, 10 },
	{ NULL, N_MSG_FOOD_APRICOT, FOOD_KIND_APRICOT,
		10, 2, 10 },
	{ NULL, N_MSG_FOOD_BLACK_BERRY, FOOD_KIND_BLACK_BERRY,
		10, 6, 10 },
	{ NULL, N_MSG_FOOD_CRAN_BERRY, FOOD_KIND_CRAN_BERRY,
		10, 6, 10 },
	{ NULL, N_MSG_FOOD_RASP_BERRY, FOOD_KIND_RASP_BERRY,
		10, 6, 10 },
	{ NULL, N_MSG_FOOD_STRAW_BERRY, FOOD_KIND_STRAW_BERRY,
		10, 6, 10 },
	{ NULL, N_MSG_NULL, FOOD_KIND_NULL,
		0, 0, 0 },
};

#define	TOBACCO_PRICE_CIGARET	2
#define	TOBACCO_PRICE_CIGAR	10
#define	TOBACCO_PRICE_CUT_TOBACCO	2
#define	TOBACCO_PRICE_SNUFF_TOBACCO	3
#define	TOBACCO_PRICE_CHEWING_TOBACCO	4
#define	TOBACCO_PRICE_ABSTAIN_GUM	8

# define	TOBACCO_AVE_TURN_CIGARET	(5 * TURN_PER_MINUTE)
# define	TOBACCO_AVE_TURN_CIGAR	(10 * TURN_PER_MINUTE)
# define	TOBACCO_AVE_TURN_CUT_TOBACCO	(5 * TURN_PER_MINUTE)
# define	TOBACCO_AVE_TURN_SNUFF_TOBACCO	(10 * TURN_PER_MINUTE)
# define	TOBACCO_AVE_TURN_CHEWING_TOBACCO	(15 * TURN_PER_MINUTE)
# define	TOBACCO_AVE_TURN_ABSTAIN_GUM	(15 * TURN_PER_MINUTE)

#if	0
typedef struct {
	char	*name;
	n_msg_t	name_n;
	tobacco_kind_t	kind;
	char	*brand_name;
	n_msg_t	brand_name_n;
	tobacco_brand_t	brand;
	rate_t	rate;
	long	ave_n;
	long	turn;
	long	price;
	flg_tobacco_t	flg;
} tobacco_tab_t;
#endif

tobacco_tab_t	tobacco_tab[] = {
	{ NULL, N_MSG_ITEM_UNKNOWN, TOBACCO_KIND_NULL,
		NULL, N_MSG_NULL,
		TOBACCO_BRAND_NULL,
		0, 0, 0,
		0, FLG_NULL },
/* CIGARET */
	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_HELLO,
		TOBACCO_BRAND_HELLO,
		80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_SUN_SHINE,
		TOBACCO_BRAND_SUN_SHINE,
		80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_CHERRY_TREE,
		TOBACCO_BRAND_CHERRY_TREE,
		80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_GOLDEN_RAT,
		TOBACCO_BRAND_GOLDEN_RAT,
		80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_AIR_SHIT,
		TOBACCO_BRAND_AIR_SHIT,
		80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_HOP,
		TOBACCO_BRAND_HOP,
		80, 10, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_PIECE,
		TOBACCO_BRAND_PIECE,
		80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_HARPY,
		TOBACCO_BRAND_HARPY,
		80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_HIGH_LIGHT,
		TOBACCO_BRAND_HIGH_LIGHT,
		80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_SHOOTING_STARS,
		TOBACCO_BRAND_SHOOTING_STARS,
		80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_WILD_NINE,
		TOBACCO_BRAND_WILD_NINE,
		80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_WILD_NINE_MENTHOL,
		TOBACCO_BRAND_WILD_NINE_MENTHOL,
		80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_LODGE,
		TOBACCO_BRAND_LODGE,
		80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_LODGE_MENTHOL,
		TOBACCO_BRAND_LODGE_MENTHOL,
		80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_CANCER,
		TOBACCO_BRAND_CANCER,
		80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_CANCER_MENTHOL,
		TOBACCO_BRAND_CANCER_MENTHOL,
		80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_FRONT_LINE,
		TOBACCO_BRAND_FRONT_LINE,
		80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_FRONT_LINE_MENTHOL,
		TOBACCO_BRAND_FRONT_LINE_MENTHOL,
		80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_MARCO_POLO,
		TOBACCO_BRAND_MARCO_POLO,
		80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET + 1, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_CAMELLIA,
		TOBACCO_BRAND_CAMELLIA,
		80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET + 1, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_GOOD_LUCK,
		TOBACCO_BRAND_GOOD_LUCK,
		80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET + 1, FLG_TOBACCO_CAN_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CIGARET, TOBACCO_KIND_CIGARET,
		NULL, N_MSG_TOBACCO_BRAND_BAD_GUY,
		TOBACCO_BRAND_BAD_GUY,
		80, 20, TOBACCO_AVE_TURN_CIGARET,
		TOBACCO_PRICE_CIGARET + 1, FLG_TOBACCO_CAN_USE_PIPE },
/* CIGAR */
	{ NULL, N_MSG_TOBACCO_CIGAR, TOBACCO_KIND_CIGAR,
		NULL, N_MSG_TOBACCO_BRAND_ARCADIA,
		TOBACCO_BRAND_ARCADIA,
		80, 5, TOBACCO_AVE_TURN_CIGAR,
		TOBACCO_PRICE_CIGAR, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_CIGAR, TOBACCO_KIND_CIGAR,
		NULL, N_MSG_TOBACCO_BRAND_GLORIA,
		TOBACCO_BRAND_GLORIA,
		80, 5, TOBACCO_AVE_TURN_CIGAR,
		TOBACCO_PRICE_CIGAR, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_CIGAR, TOBACCO_KIND_CIGAR,
		NULL, N_MSG_TOBACCO_BRAND_VULCAN,
		TOBACCO_BRAND_VULCAN,
		80, 5, TOBACCO_AVE_TURN_CIGAR,
		TOBACCO_PRICE_CIGAR, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_CIGAR, TOBACCO_KIND_CIGAR,
		NULL, N_MSG_TOBACCO_BRAND_PONY,
		TOBACCO_BRAND_PONY,
		80, 5, TOBACCO_AVE_TURN_CIGAR,
		TOBACCO_PRICE_CIGAR, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_CIGAR, TOBACCO_KIND_CIGAR,
		NULL, N_MSG_TOBACCO_BRAND_KEITH,
		TOBACCO_BRAND_KEITH,
		80, 5, TOBACCO_AVE_TURN_CIGAR,
		TOBACCO_PRICE_CIGAR, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_CIGAR, TOBACCO_KIND_CIGAR,
		NULL, N_MSG_TOBACCO_BRAND_LUMBERJACK,
		TOBACCO_BRAND_LUMBERJACK,
		80, 5, TOBACCO_AVE_TURN_CIGAR,
		TOBACCO_PRICE_CIGAR + 4, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_CIGAR, TOBACCO_KIND_CIGAR,
		NULL, N_MSG_TOBACCO_BRAND_CORONA,
		TOBACCO_BRAND_CORONA,
		80, 5, TOBACCO_AVE_TURN_CIGAR,
		TOBACCO_PRICE_CIGAR + 2, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_CIGAR, TOBACCO_KIND_CIGAR,
		NULL, N_MSG_TOBACCO_BRAND_HALF_CORONA,
		TOBACCO_BRAND_HALF_CORONA,
		80, 5, TOBACCO_AVE_TURN_CIGAR,
		TOBACCO_PRICE_CIGAR + 2, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_CIGAR, TOBACCO_KIND_CIGAR,
		NULL, N_MSG_TOBACCO_BRAND_CRYSTAL,
		TOBACCO_BRAND_CRYSTAL,
		80, 5, TOBACCO_AVE_TURN_CIGAR,
		TOBACCO_PRICE_CIGAR + 4, FLG_NULL },
/* CUT TOBACCO */
	{ NULL, N_MSG_TOBACCO_CUT_TOBACCO, TOBACCO_KIND_CUT_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_FOREST_BRANDY,
		TOBACCO_BRAND_FOREST_BRANDY,
		80, 30, TOBACCO_AVE_TURN_CUT_TOBACCO,
		TOBACCO_PRICE_CUT_TOBACCO, FLG_TOBACCO_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CUT_TOBACCO, TOBACCO_KIND_CUT_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_SILK_ROAD,
		TOBACCO_BRAND_SILK_ROAD,
		80, 30, TOBACCO_AVE_TURN_CUT_TOBACCO,
		TOBACCO_PRICE_CUT_TOBACCO, FLG_TOBACCO_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CUT_TOBACCO, TOBACCO_KIND_CUT_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_PROMENADE,
		TOBACCO_BRAND_PROMENADE,
		80, 30, TOBACCO_AVE_TURN_CUT_TOBACCO,
		TOBACCO_PRICE_CUT_TOBACCO, FLG_TOBACCO_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CUT_TOBACCO, TOBACCO_KIND_CUT_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_BIG_HORN,
		TOBACCO_BRAND_BIG_HORN,
		80, 30, TOBACCO_AVE_TURN_CUT_TOBACCO,
		TOBACCO_PRICE_CUT_TOBACCO, FLG_TOBACCO_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CUT_TOBACCO, TOBACCO_KIND_CUT_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_ROCKING_CHAIR,
		TOBACCO_BRAND_ROCKING_CHAIR,
		80, 30, TOBACCO_AVE_TURN_CUT_TOBACCO,
		TOBACCO_PRICE_CUT_TOBACCO, FLG_TOBACCO_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CUT_TOBACCO, TOBACCO_KIND_CUT_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_VANILLA,
		TOBACCO_BRAND_VANILLA,
		80, 30, TOBACCO_AVE_TURN_CUT_TOBACCO,
		TOBACCO_PRICE_CUT_TOBACCO, FLG_TOBACCO_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CUT_TOBACCO, TOBACCO_KIND_CUT_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_WILD_MANGO,
		TOBACCO_BRAND_WILD_MANGO,
		80, 30, TOBACCO_AVE_TURN_CUT_TOBACCO,
		TOBACCO_PRICE_CUT_TOBACCO, FLG_TOBACCO_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CUT_TOBACCO, TOBACCO_KIND_CUT_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_KENTUCKY_BIRD,
		TOBACCO_BRAND_KENTUCKY_BIRD,
		80, 30, TOBACCO_AVE_TURN_CUT_TOBACCO,
		TOBACCO_PRICE_CUT_TOBACCO, FLG_TOBACCO_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CUT_TOBACCO, TOBACCO_KIND_CUT_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_ORIENT,
		TOBACCO_BRAND_ORIENT,
		80, 30, TOBACCO_AVE_TURN_CUT_TOBACCO,
		TOBACCO_PRICE_CUT_TOBACCO, FLG_TOBACCO_USE_PIPE },

	{ NULL, N_MSG_TOBACCO_CUT_TOBACCO, TOBACCO_KIND_CUT_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_FUJI,
		TOBACCO_BRAND_FUJI,
		80, 30, TOBACCO_AVE_TURN_CUT_TOBACCO,
		TOBACCO_PRICE_CUT_TOBACCO, FLG_TOBACCO_USE_PIPE },
/* SNUFF TOBACCO */
	{ NULL, N_MSG_TOBACCO_SNUFF_TOBACCO, TOBACCO_KIND_SNUFF_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_DOGGY_APRICOT,
		TOBACCO_BRAND_DOGGY_APRICOT,
		50, 20, TOBACCO_AVE_TURN_SNUFF_TOBACCO,
		TOBACCO_PRICE_SNUFF_TOBACCO, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_SNUFF_TOBACCO, TOBACCO_KIND_SNUFF_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_DOGGY_WHISKY,
		TOBACCO_BRAND_DOGGY_WHISKY,
		50, 20, TOBACCO_AVE_TURN_SNUFF_TOBACCO,
		TOBACCO_PRICE_SNUFF_TOBACCO, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_SNUFF_TOBACCO, TOBACCO_KIND_SNUFF_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_DOGGY_HONEY,
		TOBACCO_BRAND_DOGGY_HONEY,
		50, 20, TOBACCO_AVE_TURN_SNUFF_TOBACCO,
		TOBACCO_PRICE_SNUFF_TOBACCO, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_SNUFF_TOBACCO, TOBACCO_KIND_SNUFF_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_DOGGY_SPEARMINT,
		TOBACCO_BRAND_DOGGY_SPEARMINT,
		50, 20, TOBACCO_AVE_TURN_SNUFF_TOBACCO,
		TOBACCO_PRICE_SNUFF_TOBACCO, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_SNUFF_TOBACCO, TOBACCO_KIND_SNUFF_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_DOGGY_PEPPERMINT,
		TOBACCO_BRAND_DOGGY_PEPPERMINT,
		50, 20, TOBACCO_AVE_TURN_SNUFF_TOBACCO,
		TOBACCO_PRICE_SNUFF_TOBACCO, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_SNUFF_TOBACCO, TOBACCO_KIND_SNUFF_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_DOGGY_VANILLA,
		TOBACCO_BRAND_DOGGY_VANILLA,
		50, 20, TOBACCO_AVE_TURN_SNUFF_TOBACCO,
		TOBACCO_PRICE_SNUFF_TOBACCO, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_SNUFF_TOBACCO, TOBACCO_KIND_SNUFF_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_DOGGY_MENTHOL,
		TOBACCO_BRAND_DOGGY_MENTHOL,
		50, 20, TOBACCO_AVE_TURN_SNUFF_TOBACCO,
		TOBACCO_PRICE_SNUFF_TOBACCO, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_SNUFF_TOBACCO, TOBACCO_KIND_SNUFF_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_DOGGY_CITRUS,
		TOBACCO_BRAND_DOGGY_CITRUS,
		50, 20, TOBACCO_AVE_TURN_SNUFF_TOBACCO,
		TOBACCO_PRICE_SNUFF_TOBACCO, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_SNUFF_TOBACCO, TOBACCO_KIND_SNUFF_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_DOGGY_SHERRY,
		TOBACCO_BRAND_DOGGY_SHERRY,
		50, 20, TOBACCO_AVE_TURN_SNUFF_TOBACCO,
		TOBACCO_PRICE_SNUFF_TOBACCO, FLG_NULL },
/* CHEWING TOBACCO */
	{ NULL, N_MSG_TOBACCO_CHEWING_TOBACCO, TOBACCO_KIND_CHEWING_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_ROSE_PREMIUM,
		TOBACCO_BRAND_ROSE_PREMIUM,
		50, 20, TOBACCO_AVE_TURN_CHEWING_TOBACCO,
		TOBACCO_PRICE_CHEWING_TOBACCO, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_CHEWING_TOBACCO, TOBACCO_KIND_CHEWING_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_ROSE_VANILLA,
		TOBACCO_BRAND_ROSE_VANILLA,
		50, 20, TOBACCO_AVE_TURN_CHEWING_TOBACCO,
		TOBACCO_PRICE_CHEWING_TOBACCO, FLG_NULL },

	{ NULL, N_MSG_TOBACCO_CHEWING_TOBACCO, TOBACCO_KIND_CHEWING_TOBACCO,
		NULL, N_MSG_TOBACCO_BRAND_ROSE_MENTHOL,
		TOBACCO_BRAND_ROSE_MENTHOL,
		50, 20, TOBACCO_AVE_TURN_CHEWING_TOBACCO,
		TOBACCO_PRICE_CHEWING_TOBACCO, FLG_NULL },
/* ABSTAIN GUM */
	{ NULL, N_MSG_TOBACCO_ABSTAIN_GUM, TOBACCO_KIND_ABSTAIN_GUM,
		NULL, N_MSG_TOBACCO_BRAND_NICOTIME,
		TOBACCO_BRAND_NICOTIME,
		50, 20, TOBACCO_AVE_TURN_ABSTAIN_GUM,
		TOBACCO_PRICE_ABSTAIN_GUM, FLG_NULL },
/* null */
	{ NULL, N_MSG_NULL, TOBACCO_KIND_NULL,
		NULL, N_MSG_NULL,
		TOBACCO_BRAND_NULL,
		0, 0, 0,
		0, FLG_NULL },
};

pipe_tab_t	pipe_tab[] = {
#if	0
typedef struct {
	char	*name;
	n_msg_t	name_n;
	pipe_kind_t	kind;
	rate_t	rate;
	long	ave_n;
	long	consume_turn;
	tobacco_kind_t	tobacco_kind;
	long	price;
	flg_pipe_t	flg;
} pipe_tab_t;
#endif

	{ NULL, N_MSG_ITEM_UNKNOWN, PIPE_KIND_NULL,
		0, 0, 0, TOBACCO_KIND_NULL,
		0, FLG_NULL },
	{ NULL, N_MSG_PIPE_PIPE, PIPE_KIND_PIPE,
		80, 1, 365 * TURN_A_DAY, TOBACCO_KIND_CUT_TOBACCO,
		500, FLG_NULL },
	{ NULL, N_MSG_PIPE_KISEL, PIPE_KIND_KISEL,
		80, 1, 365 * TURN_A_DAY, TOBACCO_KIND_CUT_TOBACCO,
		600, FLG_NULL },
	{ NULL, N_MSG_PIPE_CIGARET_HOLDER, PIPE_KIND_CIGARET_HOLDER,
		80, 20, (4 * 5 * TURN_PER_MINUTE), TOBACCO_KIND_CIGARET,
		2, FLG_PIPE_CONSUMPTION },
	{ NULL, N_MSG_NULL, PIPE_KIND_NULL,
		0, 0, 0, TOBACCO_KIND_NULL,
		0, FLG_NULL },
};

coin_tab_t	coin_tab[] = {
#if	0
typedef struct {
	char	*name;
	n_msg_t	name_n;
	coin_kind_t	kind;
	char	mnr;
	rate_t	rate;
	long	value;
} coin_tab_t;
#endif

	{ NULL, N_MSG_ITEM_UNKNOWN, COIN_KIND_NULL,
		FACE_MNR_NULL,
		0, 0 },
	{ NULL, N_MSG_COIN_GOLD, COIN_KIND_GOLD,
		FACE_MNR_NULL,
		80, 100 },
	{ NULL, N_MSG_COIN_SILVER, COIN_KIND_SILVER,
		FACE_MNR_NULL,
		0, 10 },
	{ NULL, N_MSG_COIN_COPPER, COIN_KIND_COPPER,
		FACE_MNR_NULL,
		0, 1 },
	{ NULL, N_MSG_NULL, COIN_KIND_NULL,
		FACE_MNR_NULL,
		0, 0 },
};

#endif	/* __ITEM_TAB_H__ */
