#ifndef	__PARTY_H__
#define	__PARTY_H__

#include	"chr.h"
typedef chr_t	mbr_t;

#define	LS_MBR_MAX_N	64
#define	MBR_N_NOT_JOIN	(-1)
#define	MSG_TTL_AUTO_MARK_MAX_LEN	32
#define	AUTO_MARK_APPOINT_ITEM_MAX_N	64

#define	FLG_PARTY_SRCH_AUTO_OFF	(1 << 0)
#define	FLG_PARTY_SCROLL_SMOOTH	(1 << 4)
#define	FLG_PARTY_SCROLL_CENTER	(1 << 5)

typedef unsigned long	flg_party_t;

typedef struct {
	mbr_t	*mbr[MBR_MAX_N];
	square_t	square;
	flg_party_t	flg;
	act_t	act;
} party_t;

/* $B%/%i%9(B */

typedef enum {
	CLASS_DFLT_NULL,
	CLASS_DFLT_FIGHTER,
	CLASS_DFLT_MONK,
	CLASS_DFLT_HUNTER,
	CLASS_DFLT_THIEF,
	CLASS_DFLT_WIZARD,
	CLASS_DFLT_SUMMONER,
	CLASS_DFLT_PRIEST,
	CLASS_DFLT_SHAMAN,
	CLASS_DFLT_BARD,
	CLASS_DFLT_BISHOP,
} class_dflt_t;

typedef struct {
	n_msg_t	n_name;
	char	name[CLASS_NAME_MAX_LEN + 1];
	class_dflt_t	dflt;
	rate_t	abl_rate[ABL_KIND_MAX_N];
} class_t;

#endif	/* __PARTY_H__ */

