/*#include	<stddef.h>*/
/*#include	<stdio.h>*/
#include	<string.h>
/*#include	<ctype.h>*/
/*#include	<time.h>*/
/*#include	<sys/stat.h>*/

/*#include	"gmain.h"*/
/*#include	"dun.h"*/
#include	"town.h"
#include	"item.h"
#include	"spell.h"
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
/*#include	"fight.h"*/
/*#include	"fx.h"*/
/*#include	"trap.h"*/
/*#include	"draw.h"*/
/*#include	"curs.h"*/
#include	"menu.h"
/*#include	"msg.h"*/
/*#include	"ver.h"*/
#include	"gmain_prot.h"
#include	"dun_prot.h"
#include	"town_prot.h"
#include	"item_prot.h"
/*#include	"spell_prot.h"*/
#include	"chr_prot.h"
#include	"party_prot.h"
/*#include	"mnstr_prot.h"*/
/*#include	"fight_prot.h"*/
#include	"fx_prot.h"
/*#include	"trap_prot.h"*/
#include	"draw_prot.h"
/*#include	"curs_prot.h"*/
/*#include	"menu_prot.h"*/
#include	"tmenu_prot.h"
/*#include	"amenu_prot.h"*/
#include	"gfile_prot.h"
/*#include	"msg_prot.h"*/

/**/

#define	ART_LEVEL_WPN	10
#define	ART_LEVEL_ARMOR	10
#define	ART_LEVEL_POTION	10
#define	ART_LEVEL_SCROLL	10
#define	ART_LEVEL_STICK	10
#define	ART_LEVEL_ACCE	10
#define	ART_LEVEL_LIGHT	10
#define	ART_LEVEL_FOOD	10
#define	ART_LEVEL_CHEST	10
#define	ART_LEVEL_TOBACCO	10
#define	ART_LEVEL_PIPE	10
#define	ART_LEVEL_SPIKE	10

/**/

#define	PRICE_WPN_BASE	300

#define	PRICE_WPN_HIT_MUL	20
#define	PRICE_WPN_CRTCL_MUL	20
#define	PRICE_WPN_DAM_MUL	20

#define	PRICE_WPN_HIT_BASE	-600
#define	PRICE_WPN_CRTCL_BASE	-600
#define	PRICE_WPN_DAM_BASE	-600

#define	PRICE_WPN_ADD_HIT_MUL	300
#define	PRICE_WPN_ADD_CRTCL_MUL	300
#define	PRICE_WPN_ADD_DAM_MUL	300

#define	PRICE_WPN_ADD_HIT_BASE	0
#define	PRICE_WPN_ADD_CRTCL_BASE	0
#define	PRICE_WPN_ADD_DAM_BASE	0

#define	PRICE_WPN_MUL_TYPE_MUL	500
#define	PRICE_WPN_MUL_TYPE_BASE	0

#define	PRICE_WPN_SLAYER	10000

#define	PRICE_DAGGER_DIV	60
#define	PRICE_WPN_NOT_SPEND	500

/**/

#define	PRICE_ARW_ADD_HIT_MUL	1
#define	PRICE_ARW_ADD_CRTCL_MUL	1
#define	PRICE_ARW_ADD_DAM_MUL	1

#define	PRICE_ARW_MUL_TYPE_MUL	1

#define	PRICE_ARW_SLAYER	2

/**/

#define	PRICE_ARMOR_BASE	100

#define	PRICE_ARMOR_DEF_MUL	20
#define	PRICE_ARMOR_CRTCL_MUL	20
#define	PRICE_ARMOR_AC_MUL	60

#define	PRICE_ARMOR_DEF_BASE	-600
#define	PRICE_ARMOR_CRTCL_BASE	-600
#define	PRICE_ARMOR_AC_BASE	-600

#define	PRICE_ARMOR_ADD_DEF_MUL	300
#define	PRICE_ARMOR_ADD_CRTCL_MUL	300
#define	PRICE_ARMOR_ADD_AC_MUL	300

#define	PRICE_ARMOR_ADD_DEF_BASE	0
#define	PRICE_ARMOR_ADD_CRTCL_BASE	0
#define	PRICE_ARMOR_ADD_AC_BASE	0

/**/

#define	PRICE_TEMPLE_REMOVE_CURSE	50
#define	PRICE_TEMPLE_CURE_STATUS_MUL	10
#define	PRICE_TEMPLE_CURE_STATUS_ADD	50
#define	PRICE_TEMPLE_RESURRECTION_MUL	20
#define	PRICE_TEMPLE_RESURRECTION_ADD	100
#define	PRICE_TEMPLE_SMOKER_ADD_RATE	100

/**/

#define	STR_XPM_COL_NONE	"None"

#include	"town_ptn.xpm"
#include	"town_tab.h"

town_ptn_t	town_ptn, town_ptn_trans;

long	g_morning_glow_n, g_evening_glow_n;
static bool_t	g_flg_night;

/**/

void	init_town( void )
{
	g_morning_glow_n = 4;
	g_evening_glow_n = 4;
	g_flg_night = chk_night();

	init_town_ptn_col_tab();

	load_town_ptn( &town_ptn );
	if( trans_town_ptn( &town_ptn_trans, &town_ptn ) )
		town_ptn = town_ptn_trans;
}

/**/

void	init_town_ptn_col_tab( void )
{
	long	i, max_i;

	max_i = 1024;

	for( i = 0; i < max_i; i++){
		if( town_ptn_col_tab[i].mjr != FACE_MJR_NULL )
			continue;
		if( town_ptn_col_tab[i].mnr != FACE_MNR_NULL )
			continue;
		break;
	}
	if( i < max_i )
		town_ptn_col_tab_max_n = i;
	else
		town_ptn_col_tab_max_n = 0;
}

/**/

bool_t	set_town_ptn_dflt( town_ptn_t *ptn )
{
	long	i;
	long	n;

	if( ptn == NULL )
		return FALSE;

	n = 0;

	if( !set_town_ptn_init( ptn ) )
		return FALSE;

	if( !set_town_ptn_head( ptn, town_ptn_xpm[n] ) )
		return FALSE;
	n++;

	for( i = 0; i < ptn->col_n; i++ ){
		if( !set_town_ptn_col( ptn, town_ptn_xpm[n] ) )
			return FALSE;
		n++;
	}

	if( !set_town_ptn_col_count( ptn ) )
		return FALSE;

	for( i = 0; i < MAP_MAX_Y; i++ ){
		if( !set_town_ptn_map( ptn, town_ptn_xpm[n], i ) )
			return FALSE;
		n++;
	}

	return TRUE;
}

/**/

bool_t	set_town_ptn_init( town_ptn_t *ptn )
{
	long	i;

	if( ptn == NULL )
		return FALSE;

	for( i = 0; i < TOWN_PTN_COL_MAX_N; i++){
		ptn->col_mjr[i] = '\0';
		ptn->col_mnr[i] = '\0';
	}

	return TRUE;
}

/**/

bool_t	set_town_ptn_head( town_ptn_t *ptn, char *s )
{
	long	x, y;
	long	col_n, col_str_len;

	if( ptn == NULL )
		return FALSE;
	if( s == NULL )
		return FALSE;

	sscanf( s, "%ld %ld %ld %ld", &x, &y, &col_n, &col_str_len );

	if( x != MAP_MAX_X ){
		print_err( MSG_ERR_TOWN_MAP_X_SIZE, x, MAP_MAX_X );
		return FALSE;
	}
	if( y != MAP_MAX_Y ){
		print_err( MSG_ERR_TOWN_MAP_Y_SIZE, y, MAP_MAX_Y );
		return FALSE;
	}
	if( (col_str_len != 1) && (col_str_len != 2) ){
		print_err( MSG_ERR_TOWN_MAP_STR_LEN, col_str_len );
		return FALSE;
	}

	ptn->col_n = col_n;
	ptn->col_str_len = col_str_len;

	return TRUE;
}

/**/

bool_t	set_town_ptn_col( town_ptn_t *ptn, char *s )
{
	unsigned long	col_code;
	unsigned char	col_chr, col_chr_dmy;
	town_ptn_col_tab_t	*col_tab;
	long	col_tab_max_n;
	long	i;

	if( ptn == NULL )
		return FALSE;
	if( s == NULL )
		return FALSE;

	col_tab = get_town_ptn_col_tab();
	col_tab_max_n = get_town_ptn_col_tab_max_n();

	if( strstr( s, STR_XPM_COL_NONE ) != NULL )
		return TRUE;

	if( ptn->col_str_len == 1 ){
		sscanf( s, "%c c #%lx", &col_chr, &col_code );
	} else if( ptn->col_str_len == 2 ){
		sscanf( s, "%c%c c #%lx",
				&col_chr, &col_chr_dmy, &col_code );
	} else {
		return FALSE;
	}
	if( col_chr > TOWN_PTN_COL_MAX_N )
		return FALSE;

	for( i = 0; i < col_tab_max_n; i++ )
		if( col_code == col_tab[i].col_code )
			break;
	if( i >= col_tab_max_n )
		return FALSE;

	if( ptn->col_str_len == 1 ){
		ptn->col_mjr[col_chr] = col_tab[i].mjr;
		ptn->col_mnr[col_chr] = col_tab[i].mnr;
	}

	return TRUE;
}

/**/

bool_t	set_town_ptn_col_count( town_ptn_t *ptn )
{
	long	i;
	long	n;

	if( ptn == NULL )
		return FALSE;

	n = 0;
	for( i = 0; i < TOWN_PTN_COL_MAX_N; i++ ){
		if( ptn->col_mjr[i] == '\0' )
			continue;
		if( ptn->col_mnr[i] == '\0' )
			continue;

		n++;
	}

	ptn->col_n = n;

	return TRUE;
}

/**/

bool_t	set_town_ptn_map( town_ptn_t *ptn, char *s, long y )
{
	long	x;

	if( ptn == NULL )
		return FALSE;
	if( s == NULL )
		return FALSE;

	if( (ptn->col_str_len != 1) && (ptn->col_str_len != 2) )
		return FALSE;

	for( x = 0; x < MAP_MAX_X; x++ ){
		if( ptn->col_str_len == 1 ){
			ptn->map_mjr[y][x] = s[x];
			ptn->map_mnr[y][x] = '\0';
		} else if( ptn->col_str_len == 2 ){
			ptn->map_mjr[y][x] = s[x * 2];
			ptn->map_mnr[y][x] = s[x * 2 + 1];
		}
	}

	return TRUE;
}

/**/

bool_t	trans_town_ptn( town_ptn_t *dst, town_ptn_t *src )
{
	town_ptn_col_tab_t	*col_tab;
	long	col_tab_max_n;
	long	x, y;

	if( dst == NULL )
		return FALSE;
	if( src == NULL )
		return FALSE;

	if( src->col_str_len == 2 )
		return FALSE;

	col_tab = get_town_ptn_col_tab();
	col_tab_max_n = get_town_ptn_col_tab_max_n();

	if( col_tab_max_n > TOWN_PTN_COL_MAX_N )
		return FALSE;

	set_town_ptn_init( dst );

	dst->col_str_len = 2;
	dst->col_n = 0;

	for( y = 0; y < MAP_MAX_Y; y++ ){
		for( x = 0; x < MAP_MAX_X; x++ ){
			unsigned char	c;

			c = src->map_mjr[y][x];
			dst->map_mjr[y][x] = src->col_mjr[c];
			dst->map_mnr[y][x] = src->col_mnr[c];
		}
	}

	return TRUE;
}

/**/

void	make_town( void )
{
	dun_t *dun;
	long	i, j;
	long	n;

	dun = get_dun();

	reset_dun();
	init_shop_face_ls();

	for( i = 0; i < MAP_MAX_Y; i++ )
		for( j = 0; j < MAP_MAX_X; j++ )
			make_field_town( &town_ptn, j, i );

	for( i = 0; i < MAP_MAX_Y; i++ ){
		for( j = 0; j < MAP_MAX_X; j++ ){
			char	mjr, mnr;

			mjr = dun->map.obj.mjr[i][j];
			if( mjr != FACE_MJR_DOOR_CLOSE )
				continue;
			mnr = dun->map.obj.mnr[i][j];

			make_door_town( j, i, mnr );

			set_shop_face_ls( mnr );
		}
	}

	if( !chk_shop_face_ls() ){
		print_err( MSG_S, MSG_ERR_TOWN_MAP_SHOP );
		exit_game( EXIT_FAILURE );
	}

	/* ޥåפüɤˤ */
	make_fence();

	/* ŹΤѰ */
	reset_item_town();

	for( n = 0; n < 1024; n++ )
		if( !make_art_town( SHOP_N_WPN,
				&(art_ls_wpn[n]) ) )
			break;
	for( n = 0; n < 1024; n++ )
		if( !make_art_town( SHOP_N_ARMOR,
				&(art_ls_armor[n]) ) )
			break;
	for( n = 0; n < 1024; n++ )
		if( !make_art_town( SHOP_N_MAGIC,
				&(art_ls_magic[n]) ) )
			break;
	for( n = 0; n < 1024; n++ )
		if( !make_art_town( SHOP_N_GROCERY,
				&(art_ls_grocery[n]) ) )
			break;
	for( n = 0; n < 1024; n++ )
		if( !make_art_town( SHOP_N_RESTAURANT,
				&(art_ls_restaurant[n]) ) )
			break;
	for( n = 0; n < 1024; n++ )
		if( !make_art_town( SHOP_N_TEAROOM,
				&(art_ls_tearoom[n]) ) )
			break;
	for( n = 0; n < 1024; n++ )
		if( !make_art_town( SHOP_N_TOBACCO,
				&(art_ls_tobacco[n]) ) )
			break;
}

/**/

void	make_field_town( town_ptn_t *ptn, long x, long y )
{
	dun_t *dun;
	char	mjr, mnr;
	flg_map_t	flg;
	bool_t	flg_light;
	unsigned char	idx;

	dun = get_dun();

	if( ptn->col_str_len == 1 ){
		idx = ptn->map_mjr[y][x];
		mjr = ptn->col_mjr[idx];
		mnr = ptn->col_mnr[idx];
	} else if( ptn->col_str_len == 2 ){
		mjr = ptn->map_mjr[y][x];
		mnr = ptn->map_mnr[y][x];
	} else {
		mjr = FACE_MJR_WALL;
		mnr = FACE_MNR_WALL;
	}
	flg = FLG_OBJ_FIND;
	flg_light = TRUE;

	switch( mjr ){
	case FACE_MJR_NULL:
		mjr = FACE_MJR_FLOOR;
		mnr = FACE_MNR_FLOOR;
		if( chk_night() ){
			flg &= ~(FLG_OBJ_FIND);
			flg_light = FALSE;
		}
		flg |= FLG_OBJ_PASS;
		break;
	case FACE_MJR_WALL:
		break;
	case FACE_MJR_FLOOR:
		if( chk_night() ){
			flg &= ~(FLG_OBJ_FIND);
			flg_light = FALSE;
		}
		flg |= FLG_OBJ_PASS;
		break;
	case FACE_MJR_DOOR_OPEN:
		mjr = FACE_MJR_DOOR_CLOSE;
		break;
	case FACE_MJR_DOOR_CLOSE:
		break;
	case FACE_MJR_STAIRS_UP:
	case FACE_MJR_STAIRS_DOWN:
		flg |= FLG_OBJ_PASS;
		break;
	default:
		print_msg( FLG_NULL, MSG_S, MSG_ERR_TOWN_MAP );
	}

	dun->map.obj.mjr[y][x] = mjr;
	dun->map.obj.mnr[y][x] = mnr;
	dun->map.obj.flg[y][x] = flg;
	if( flg_light )
		dun->map.light_depth[y][x] = 1;
	else
		dun->map.light_depth[y][x] = 0;
	dun->map.sect[y][x] = SECT_NULL;
}

/**/

bool_t	make_art_town( shop_n_t shop_n, void *art_ls )
{
	item_kind_t	item_kind;
	long	ave_stock;
	long	tab_n;
	item_t	*item, *asgn, dmy;
	wpn_kind_t	wpn_kind;
	armor_kind_t	armor_kind;
	potion_kind_t	potion_kind;
	scroll_kind_t	scroll_kind;
	stick_kind_t	stick_kind;
	spell_kind_t	spell_kind;
	ring_kind_t	ring_kind;
	amulet_kind_t	amulet_kind;
	necklace_kind_t	necklace_kind;
	light_kind_t	light_kind;
	food_kind_t	food_kind;
	tobacco_kind_t	tobacco_kind;
	tobacco_brand_t	tobacco_brand;
	pipe_kind_t	pipe_kind;
	art_ls_wpn_t	*art_wpn;
	art_ls_armor_t	*art_armor;
	art_ls_magic_t	*art_magic;
	art_ls_grocery_t	*art_grocery;
	art_ls_restaurant_t	*art_restaurant;
	art_ls_tearoom_t	*art_tearoom;
	art_ls_tobacco_t	*art_tobacco;

	/**/

	item_kind = ITEM_KIND_NULL;
	ave_stock = 0;
	tab_n = 0;

	wpn_kind = WPN_KIND_NULL;
	armor_kind = ARMOR_KIND_NULL;
	potion_kind = POTION_KIND_NULL;
	scroll_kind = SCROLL_KIND_NULL;
	stick_kind = STICK_KIND_NULL;
	spell_kind = SPELL_KIND_NULL;
	ring_kind = RING_KIND_NULL;
	amulet_kind = AMULET_KIND_NULL;
	necklace_kind = NECKLACE_KIND_NULL;
	light_kind = LIGHT_KIND_NULL;
	food_kind = FOOD_KIND_NULL;
	tobacco_kind = TOBACCO_KIND_NULL;
	tobacco_brand = TOBACCO_BRAND_NULL;
	pipe_kind = PIPE_KIND_NULL;

	switch( shop_n ){
	case SHOP_N_BAR:
	case SHOP_N_INN:
	case SHOP_N_TEMPLE:
		return FALSE;
	case SHOP_N_WPN:
		art_wpn = (art_ls_wpn_t *)art_ls;
		item_kind = art_wpn->kind;
		ave_stock = art_wpn->ave_stock;
		wpn_kind = art_wpn->wpn;
		break;
	case SHOP_N_ARMOR:
		art_armor = (art_ls_armor_t *)art_ls;
		item_kind = art_armor->kind;
		ave_stock = art_armor->ave_stock;
		armor_kind = art_armor->armor;
		break;
	case SHOP_N_MAGIC:
		art_magic = (art_ls_magic_t *)art_ls;
		item_kind = art_magic->kind;
		ave_stock = art_magic->ave_stock;
		potion_kind = art_magic->potion;
		scroll_kind = art_magic->scroll;
		stick_kind = art_magic->stick;
		spell_kind = art_magic->spell;
		ring_kind = art_magic->ring;
		amulet_kind = art_magic->amulet;
		necklace_kind = art_magic->necklace;
		break;
	case SHOP_N_GROCERY:
		art_grocery = (art_ls_grocery_t *)art_ls;
		item_kind = art_grocery->kind;
		ave_stock = art_grocery->ave_stock;
		potion_kind = art_grocery->potion;
		food_kind = art_grocery->food;
		tobacco_kind = art_grocery->tobacco;
		tobacco_brand = art_grocery->tobacco_brand;
		light_kind = art_grocery->light;
		break;
	case SHOP_N_RESTAURANT:
		art_restaurant = (art_ls_restaurant_t *)art_ls;
		item_kind = art_restaurant->kind;
		ave_stock = art_restaurant->ave_stock;
		food_kind = art_restaurant->food;
		potion_kind = art_restaurant->potion;
		break;
	case SHOP_N_TEAROOM:
		art_tearoom = (art_ls_tearoom_t *)art_ls;
		item_kind = art_tearoom->kind;
		ave_stock = art_tearoom->ave_stock;
		potion_kind = art_tearoom->potion;
		break;
	case SHOP_N_TOBACCO:
		art_tobacco = (art_ls_tobacco_t *)art_ls;
		item_kind = art_tobacco->kind;
		ave_stock = art_tobacco->ave_stock;
		tobacco_kind = art_tobacco->tobacco;
		tobacco_brand = art_tobacco->tobacco_brand;
		pipe_kind = art_tobacco->pipe;
		break;
	}

	if( item_kind == ITEM_KIND_NULL )
		return FALSE;

	item = alloc_item( &dmy );
	if( item == NULL )
		return FALSE;

	switch( item_kind ){
	case ITEM_KIND_NULL:
	case ITEM_KIND_MAX_N:
	case ITEM_KIND_COIN:
	case ITEM_KIND_JUNK:
		return TRUE;
	case ITEM_KIND_WPN:
		tab_n = get_wpn_tab_n( get_wpn_tab( wpn_kind ) );
		if( tab_n <= -1 )
			return TRUE;
		make_item_wpn( ART_LEVEL_WPN, item, tab_n, FALSE );
		item->n = item->tab.wpn->ave_n;
		break;
	case ITEM_KIND_ARMOR:
		tab_n = get_armor_tab_n( get_armor_tab( armor_kind ) );
		if( tab_n <= -1 )
			return TRUE;
		make_item_armor( ART_LEVEL_ARMOR, item, tab_n, FALSE );
		break;
	case ITEM_KIND_POTION:
		tab_n = get_potion_tab_n( get_potion_tab( potion_kind ) );
		if( tab_n <= -1 )
			return TRUE;
		make_item_potion( ART_LEVEL_POTION, item, tab_n );
		break;
	case ITEM_KIND_SCROLL:
		tab_n = get_scroll_tab_n( get_scroll_tab( scroll_kind ) );
		if( tab_n <= -1 )
			return TRUE;
		make_item_scroll( ART_LEVEL_SCROLL, item, tab_n );
		break;
	case ITEM_KIND_STICK:
		tab_n = get_stick_tab_n( get_stick_tab(
				stick_kind, spell_kind ) );
		if( tab_n <= -1 )
			return TRUE;
		make_item_stick( ART_LEVEL_STICK, item, tab_n );
		item->dat.stick.n = item->tab.stick->use_n;
		break;
	case ITEM_KIND_ACCE:
		tab_n = get_acce_tab_n( get_acce_tab(
				ring_kind,
				amulet_kind,
				necklace_kind ) );
		if( tab_n <= -1 )
			return TRUE;
		make_item_acce( ART_LEVEL_ACCE, item, tab_n );
		break;
	case ITEM_KIND_LIGHT:
		tab_n = get_light_tab_n( get_light_tab( light_kind ) );
		if( tab_n <= -1 )
			return TRUE;
		make_item_light( ART_LEVEL_LIGHT, item, tab_n );
		item->dat.light.turn = item->tab.light->max_turn;
		break;
	case ITEM_KIND_SPIKE:
		make_item_spike( ART_LEVEL_SPIKE, item );
		item->n = SPIKE_AVE_N;
		break;
	case ITEM_KIND_FOOD:
		tab_n = get_food_tab_n( get_food_tab( food_kind ) );
		if( tab_n <= -1 )
			return TRUE;
		make_item_food( ART_LEVEL_FOOD, item, tab_n );
		item->n = 1;
		break;
	case ITEM_KIND_CHEST:
		make_item_chest( ART_LEVEL_CHEST, item,
				get_chest_n( ART_LEVEL_CHEST ) );
		break;
	case ITEM_KIND_TOBACCO:
		tab_n = get_tobacco_tab_n( get_tobacco_tab(
				tobacco_kind, tobacco_brand ) );
		if( tab_n <= -1 )
			return TRUE;
		make_item_tobacco( ART_LEVEL_TOBACCO, item, tab_n );
		item->n = item->tab.tobacco->ave_n;
		break;
	case ITEM_KIND_PIPE:
		tab_n = get_pipe_tab_n( get_pipe_tab( pipe_kind ) );
		if( tab_n <= -1 )
			return TRUE;
		make_item_pipe( ART_LEVEL_PIPE, item, tab_n );
		if( chk_flg( item->tab.pipe->flg, FLG_PIPE_CONSUMPTION ) )
			item->n = item->tab.pipe->ave_n;
		break;
	}
	if( ave_stock == 1 )
		item->stock = 1;
	else
		item->stock = roll_dice( ave_stock );
	if( item->stock <= 0 ){
		del_item( item );
		return TRUE;
	}

	item->flg |= FLG_ITEM_DETECTED | FLG_ITEM_IDENTIFIED;
	item->flg &= ~(FLG_ITEM_CURSE);
	set_item_name( item );

	asgn = NULL;
	switch( shop_n ){
	case SHOP_N_INN:
	case SHOP_N_BAR:
		return TRUE;
	case SHOP_N_TEMPLE:
		asgn = get_shop_temple_item_asgn();
		break;
	case SHOP_N_WPN:
		asgn = get_shop_wpn_item_asgn();
		break;
	case SHOP_N_ARMOR:
		asgn = get_shop_armor_item_asgn();
		break;
	case SHOP_N_MAGIC:
		asgn = get_shop_magic_item_asgn();
		break;
	case SHOP_N_GROCERY:
		asgn = get_shop_grocery_item_asgn();
		break;
	case SHOP_N_RESTAURANT:
		asgn = get_shop_restaurant_item_asgn();
		break;
	case SHOP_N_TEAROOM:
		asgn = get_shop_tearoom_item_asgn();
		break;
	case SHOP_N_TOBACCO:
		asgn = get_shop_tobacco_item_asgn();
		break;
	}
	ins_ls_item( asgn, item );

	return TRUE;
}

/**/

void	make_door_town( long mx, long my, char mnr )
{
	dun_t *dun;
	long	dx, dy;
	long	i;

	dun = get_dun();

	/* ǤϿߤ */
	if( (mx - 1) >= 0 )
		if( dun->map.obj.mjr[my][mx - 1]
				== FACE_MJR_DOOR_CLOSE )
			return;
	if( (my - 1) >= 0 )
		if( dun->map.obj.mjr[my - 1][mx]
				== FACE_MJR_DOOR_CLOSE )
			return;


	for( i = 0; i < AREA_MAX_X; i++ ){
		if( dun->map.obj.mjr[my][mx + i]
				!= FACE_MJR_DOOR_CLOSE ){
			break;
		}
	}
	dx = i - 1;
	if( dx < 0 )
		return;

	for( i = 0; i < AREA_MAX_Y; i++ ){
		if( dun->map.obj.mjr[my + i][mx]
				!= FACE_MJR_DOOR_CLOSE ){
			break;
		}
	}
	dy = i - 1;
	if( dy < 0 )
		return;

	make_door( mx, my, mx + dx, my + dy, mnr );
}

/**/

void	init_shop_face_ls( void )
{
	long	i;

	for( i = 0; i < g_shop_face_ls_max_n; i++ )
		g_shop_face_ls[i].flg = FALSE;
}

/**/

bool_t	set_shop_face_ls( char mnr )
{
	long	i;

	for( i = 0; i < g_shop_face_ls_max_n; i++ ){
		if( g_shop_face_ls[i].mnr == mnr ){
			if( g_shop_face_ls[i].flg ){
				return FALSE;
			} else {
				g_shop_face_ls[i].flg = TRUE;
				return TRUE;
			}
		}
	}

	return FALSE;
}

/**/

bool_t	chk_shop_face_ls( void )
{
	long	i;

	for( i = 0; i < g_shop_face_ls_max_n; i++ )
		if( !g_shop_face_ls[i].flg )
			return FALSE;

	return TRUE;
}

/**/

bool_t	appear_party_town( void )
{
	dun_t *dun;
	long	i, j;
	bool_t	flg_find;
	party_t	*pty;
	long	n;

	dun = get_dun();
	pty = get_party();

	flg_find = FALSE;
	for( i = 0; i < MAP_MAX_Y; i++ ){
		for( j = 0; j < MAP_MAX_X; j++ ){
			if( dun->map.obj.mjr[i][j]
					== FACE_MJR_STAIRS_DOWN ){
				flg_find = TRUE;
				pty->square.x = j;
				pty->square.y = i;
				pty->square.pre_x = pty->square.x;
				pty->square.pre_y = pty->square.y;
				break;
			}
		}
		if( flg_find ){
			break;
		}
	}
	if( !flg_find )
		return FALSE;

	clr_map_all_mbr();

	for( n = 0; n < MBR_MAX_N; n++ ){
		long	nx, ny;

		if( chk_flg_or( pty->mbr[n]->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
			continue;

		nx = pty->square.x + pty->square.chr_pos[n].x;
		ny = pty->square.y + pty->square.chr_pos[n].y;
		pty->mbr[n]->x = nx;
		pty->mbr[n]->y = ny;
		pty->mbr[n]->pre_x = nx;
		pty->mbr[n]->pre_y = ny;
		if( !can_move_chr( pty->mbr[n], nx, ny ) ){
			/* ֤˰ưʤ */
			set_map_all_mbr();
			return FALSE;
		}
	}

	for( n = 0; n < MBR_MAX_N; n++ )
		clr_chr_trgt_act( pty->mbr[n], FALSE );

	set_map_all_mbr();

	return TRUE;
}

/**/

bool_t	open_door_shop( long n )
{
	dun_t	*dun;
	party_t	*pty;

	dun = get_dun();

	if( n < 0 )
		return FALSE;
	if( n >= dun->door_n )
		return FALSE;
	if( !chk_flg( dun->door[n].flg, FLG_DOOR_SHOP ) )
		return FALSE;

	pty = get_party();
	pty->act.kind = ACT_KIND_SHOP;
	pty->act.p = NULL;
	pty->act.n = dun->map.obj.mnr[dun->door[n].y][dun->door[n].x];
	pty->act.n2 = n;

	return TRUE;
}

/**/

bool_t	enter_shop( void )
{
	party_t	*pty;
	dun_t	*dun;
	char	face_mnr;
	long	dr_n;
	long	i;

	dun = get_dun();
	pty = get_party();

	if( pty->act.kind != ACT_KIND_SHOP )
		return FALSE;

	clr_map_all_mbr();

	face_mnr = (char)(pty->act.n);
	dr_n = (long)(pty->act.n2);
	clr_party_act();

	for( i = 0; i < MBR_MAX_N; i++ ){
		long	x, y;

		if( chk_flg_or( pty->mbr[i]->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
			continue;

		x = pty->mbr[i]->x;
		y = pty->mbr[i]->y;
		dun->map.chr.mjr[y][x] = FACE_MJR_NULL;
		dun->map.chr.mnr[y][x] = FACE_MNR_NULL;
	}
	switch( face_mnr ){
	case FACE_MNR_SHOP_INN:
		menu_inn();
		break;
	case FACE_MNR_SHOP_BAR:
		menu_bar();
		break;
	case FACE_MNR_SHOP_TEMPLE:
	case FACE_MNR_SHOP_WPN:
	case FACE_MNR_SHOP_ARMOR:
	case FACE_MNR_SHOP_MAGIC:
	case FACE_MNR_SHOP_GROCERY:
	case FACE_MNR_SHOP_RESTAURANT:
	case FACE_MNR_SHOP_TEAROOM:
	case FACE_MNR_SHOP_TOBACCO:
		menu_shop_sel_mbr( get_shop_n( face_mnr ) );
		break;
	default:
		return FALSE;
	}

	party_exit_shop( dr_n );

	redraw_all();
	clr_msg();

	return TRUE;
}

/**/

void	party_exit_shop( long dr_n )
{
	dun_t	*dun;
	party_t	*pty;
	long	x, y;
	long	dx, dy;
	bool_t	flg;
	long	i, j;

	dun = get_dun();
	pty = get_party();

	for( i = 0; i < MBR_MAX_N; i++ )
		clr_chr_trgt_act( pty->mbr[i], FALSE );

	set_map_sunshine();

	for( i = 0; i < 4; i++ ){
		switch( i ){
		default:
		case 0:
			x = dun->door[dr_n].x;
			y = dun->door[dr_n].y + dun->door[dr_n].dy;
			break;
		case 1:
			x = dun->door[dr_n].x - 3;
			y = dun->door[dr_n].y;
			break;
		case 2:
			x = dun->door[dr_n].x;
			y = dun->door[dr_n].y - 3;
			break;
		case 3:
			x = dun->door[dr_n].x + dun->door[dr_n].dx;
			y = dun->door[dr_n].y;
			break;
		}

		flg = TRUE;
		for( dy = 0; dy < 3; dy++ ){
			for( dx = 0; dx < 3; dx++ ){
				if( dun->map.chr.mjr[y + dy][x + dx]
						!= FACE_MJR_NULL ){
					flg = FALSE;
					break;
				}
				if( !chk_flg( dun->map.obj.flg
						[y + dy][x + dx],
						FLG_OBJ_PASS ) ){
					flg = FALSE;
					break;
				}
			}
			if( !flg )
				break;
		}

		if( !flg )
			continue;

		pty->square.x = x + 1;
		pty->square.y = y + 1;
		for( j = 0; j < MBR_MAX_N; j++ ){
			pty->mbr[j]->x = pty->square.x
					+ pty->square.chr_pos[j].x;
			pty->mbr[j]->y = pty->square.y
					+ pty->square.chr_pos[j].y;
		}

		set_map_all_mbr();

		return;
	}

	for( j = 0; j < MBR_MAX_N; j++ ){
		pty->mbr[j]->y = 0;
		pty->mbr[j]->y = 0;
	}
	set_map_all_mbr();
	if( !appear_party_town() )
		appear_party( TRUE );
}

/**/

bool_t	chk_package_item( item_t *item )
{
	if( item == NULL )
		return FALSE;

	switch( item->kind ){
	case ITEM_KIND_NULL:
	case ITEM_KIND_MAX_N:
		return FALSE;
	case ITEM_KIND_WPN:
		if( chk_flg( item->tab.wpn->flg, FLG_WPN_TAB_ARW ) )
			return TRUE;
		return FALSE;
	case ITEM_KIND_ARMOR:
	case ITEM_KIND_POTION:
	case ITEM_KIND_SCROLL:
	case ITEM_KIND_STICK:
	case ITEM_KIND_ACCE:
	case ITEM_KIND_LIGHT:
	case ITEM_KIND_FOOD:
	case ITEM_KIND_CHEST:
	case ITEM_KIND_COIN:
	case ITEM_KIND_JUNK:
		return FALSE;
	case ITEM_KIND_TOBACCO:
	case ITEM_KIND_SPIKE:
		return TRUE;
	case ITEM_KIND_PIPE:
		if( chk_flg( item->tab.pipe->flg, FLG_PIPE_CONSUMPTION ) )
			return TRUE;
		return FALSE;
	}
	return FALSE;
}

/**/

void	stay_inn( void )
{
	party_t	*pty;
	long	turn;
	long	i;

	pty = get_party();

	turn = TURN_A_DAY - (get_turn() % TURN_A_DAY);
	turn += 7 * TURN_PER_HOUR;

	dec_turn_fx_all_mbr( turn );

	for( i = 0; i < MBR_MAX_N; i++ ){
		mbr_t	*mbr;
		fx_t	*fx;

		mbr = pty->mbr[i];

		if( chk_flg_or( mbr->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
			continue;

		/* ǤˤƤϲʤ */
		fx = srch_fx( &(mbr->fx), FX_KIND_POISON );
		if( fx == NULL ){
			mbr->abl.hp.n = mbr->abl.hp.max;
			mbr->abl.mp.n = mbr->abl.mp.max;
		}

		mbr->fx_data.drunk_rate = 0;

		/* Ȥ */
		take_meal_fill_mbr( mbr );
	}

	set_turn( get_turn() + turn );

	make_town();
}

/**/

bool_t	set_art_name( mbr_t *mbr, item_t *art, deal_kind_t kind )
{
	party_t	*pty;

	if( mbr == NULL )
		return FALSE;
	if( art == NULL )
		return FALSE;

	pty = get_party();

	if( kind == DEAL_KIND_SALE_EQUIP ){
		long	i, j;

		for( i = 0; i < MBR_MAX_N; i++ ){
			item_t	*p;

			p = get_mbr_item_asgn_equip( pty->mbr[i] );
			if( p == NULL )
				continue;

			for( j = 0; j < EQUIP_KIND_MAX_N; j++ ){
				if( art == &(p[j]) ){
					set_art_name_equip( pty->mbr[i],
							art, j );
					return TRUE;
				}
			}
		}
	}

	strcpy( art->art_name, get_str_can_use_item( mbr, art ) );
	strcat( art->art_name, art->name );

	return TRUE;
}

/**/

bool_t	set_art_name_equip( mbr_t *mbr, item_t *art, equip_kind_t eq )
{
	char	*eq_name;

	if( mbr == NULL )
		return FALSE;
	if( art == NULL )
		return FALSE;

	switch( eq ){
	case EQUIP_KIND_WIELDING:
		eq_name = MSG_EQUIP_WIELDING;
		break;
	case EQUIP_KIND_SHIELD:
		eq_name = MSG_EQUIP_SHIELD;
		break;
	case EQUIP_KIND_BOW:
		eq_name = MSG_EQUIP_BOW;
		break;
	case EQUIP_KIND_ARW:
		eq_name = MSG_EQUIP_ARW;
		break;
	case EQUIP_KIND_HEAD:
		eq_name = MSG_EQUIP_HEAD;
		break;
	case EQUIP_KIND_NECK:
		eq_name = MSG_EQUIP_NECK;
		break;
	case EQUIP_KIND_BODY:
		eq_name = MSG_EQUIP_BODY;
		break;
	case EQUIP_KIND_ARM:
		eq_name = MSG_EQUIP_ARM;
		break;
	case EQUIP_KIND_RIGHT_HAND:
		eq_name = MSG_EQUIP_RIGHT_HAND;
		break;
	case EQUIP_KIND_LEFT_HAND:
		eq_name = MSG_EQUIP_LEFT_HAND;
		break;
	case EQUIP_KIND_FEET:
		eq_name = MSG_EQUIP_FEET;
		break;
	case EQUIP_KIND_ABOUT_BODY:
		eq_name = MSG_EQUIP_ABOUT_BODY;
		break;
	case EQUIP_KIND_LIGHT_SOURCE:
		eq_name = MSG_EQUIP_LIGHT_SOURCE;
		break;
	case EQUIP_KIND_MAX_N:
	default:
		eq_name = NULL;
		break;
	}
	if( eq_name != NULL ){
		sprintf( art->art_name, MSG_FMT_ART_NAME_EQUIP,
				get_str_can_use_item( mbr, art ),
				eq_name, art->name );
	} else {
		strcpy( art->art_name, get_str_can_use_item( mbr, art ) );
		strcat( art->art_name, art->name );
	}

	return TRUE;
}

/**/

bool_t	chk_pay( long price, mbr_t *mbr )
{
	long	gold;

	if( mbr == NULL )
		return FALSE;

	gold = get_chr_gold( mbr );

	if( gold < price ){
		print_msg( FLG_NULL, MSG_ERR_MENU_WANTING,
				mbr->name, price - gold );
		return FALSE;
	}

	return TRUE;
}

/**/

long	get_price( item_t *item, deal_kind_t kind )
{
	long	price;

	if( item == NULL )
		return 0;

	price = 0;

	switch( item->kind ){
	case ITEM_KIND_NULL:
	case ITEM_KIND_MAX_N:
		break;
	case ITEM_KIND_WPN:
		price = get_price_wpn( item );
		break;
	case ITEM_KIND_ARMOR:
		price = get_price_armor( item );
		break;
	case ITEM_KIND_POTION:
	case ITEM_KIND_SCROLL:
	case ITEM_KIND_STICK:
	case ITEM_KIND_ACCE:
	case ITEM_KIND_LIGHT:
	case ITEM_KIND_SPIKE:
	case ITEM_KIND_FOOD:
	case ITEM_KIND_CHEST:
		/*@@@*/
		break;
	case ITEM_KIND_TOBACCO:
		if( item->tab.tobacco != NULL )
			price = item->tab.tobacco->price;
		break;
	case ITEM_KIND_PIPE:
		if( item->tab.pipe != NULL )
			price = item->tab.pipe->price;
		break;
	case ITEM_KIND_COIN:
		break;
	case ITEM_KIND_JUNK:
		price = 0;
		break;
	}

	price *= item->n;

	switch( kind ){
	case DEAL_KIND_BUY:
		return price;
	case DEAL_KIND_SALE_ITEM:
	case DEAL_KIND_SALE_EQUIP:
		return( price / 2 );
	}

	return 0;
}

/**/

long	get_price_wpn( item_t *item )
{
	long	price;
	long	mul_type;
	rate_t	hit, crtcl, dam;
	ratio_t	ratio;
	rate_t	arw_hit, arw_crtcl, arw_dam;
	bool_t	flg_dag, flg_arw;
	long	i;

	if( item == NULL )
		return 0;
	if( item->kind != ITEM_KIND_WPN )
		return 0;
	if( item->tab.wpn == NULL )
		return 0;
	if( chk_flg( item->flg, FLG_ITEM_CURSE) )
		return 0;

	price = PRICE_WPN_BASE;

	/**/

	flg_dag = FALSE;
	flg_arw = FALSE;
	arw_hit = 0;
	arw_crtcl = 0;
	arw_dam = 0;
	if( item->tab.wpn->bow_kind == BOW_KIND_DAGGER ){
		if( chk_flg( item->tab.wpn->flg, FLG_WPN_TAB_NOT_SPEND ) )
			price += PRICE_WPN_NOT_SPEND;
		else
			flg_dag = TRUE;
	} else if( chk_flg( item->tab.wpn->flg, FLG_WPN_TAB_ARW ) ){
		flg_arw = TRUE;
		arw_hit = 30;
		arw_crtcl = 30;
		arw_dam = 30;
	}

	hit = 0;
	crtcl = 0;
	dam = 0;
	ratio = 0;
	mul_type = 0;
	for( i = 0; i < WPN_ATTACK_MAX_N; i++ ){
		if( item->tab.wpn->attack[i].kind == ATTACK_KIND_NULL )
			break;
		hit += (item->tab.wpn->attack[i].hit + arw_hit)
				* item->tab.wpn->attack[i].ratio;
		crtcl += (item->tab.wpn->attack[i].crtcl + arw_crtcl)
				* item->tab.wpn->attack[i].ratio;
		dam += (item->tab.wpn->attack[i].dam + arw_dam)
				* item->tab.wpn->attack[i].ratio;
		ratio += item->tab.wpn->attack[i].ratio;
		mul_type++;
	}
	if( ratio <= 0 )
		return 0;

	hit /= ratio;
	crtcl /= ratio;
	dam /= ratio;

	price += hit * PRICE_WPN_HIT_MUL;
	price += crtcl * PRICE_WPN_CRTCL_MUL;
	price += dam * PRICE_WPN_DAM_MUL;

	price += PRICE_WPN_HIT_BASE;
	price += PRICE_WPN_CRTCL_BASE;
	price += PRICE_WPN_DAM_BASE;

	if( flg_arw )
		price /= PRICE_WPN_BASE;

	/**/

	if( item->dat.wpn.add_hit < 0 )
		return 0;
	if( item->dat.wpn.add_crtcl < 0 )
		return 0;
	if( item->dat.wpn.add_dam < 0 )
		return 0;

	if( flg_arw ){
		price += item->dat.wpn.add_hit * PRICE_ARW_ADD_HIT_MUL;
		price += item->dat.wpn.add_crtcl * PRICE_ARW_ADD_CRTCL_MUL;
		price += item->dat.wpn.add_dam * PRICE_ARW_ADD_DAM_MUL;
	} else {
		price += item->dat.wpn.add_hit * PRICE_WPN_ADD_HIT_MUL;
		price += item->dat.wpn.add_crtcl * PRICE_WPN_ADD_CRTCL_MUL;
		price += item->dat.wpn.add_dam * PRICE_WPN_ADD_DAM_MUL;

		if( item->dat.wpn.add_hit > 0 )
			price += PRICE_WPN_ADD_HIT_BASE;
		if( item->dat.wpn.add_crtcl > 0 )
			price += PRICE_WPN_ADD_CRTCL_BASE;
		if( item->dat.wpn.add_dam > 0 )
			price += PRICE_WPN_ADD_DAM_BASE;
	}

	/**/

	if( mul_type >= 2 ){
		if( flg_arw ){
			price += (mul_type - 1) * PRICE_ARW_MUL_TYPE_MUL;
		} else {
			price += (mul_type - 1) * PRICE_WPN_MUL_TYPE_MUL
					+ PRICE_WPN_MUL_TYPE_BASE;
		}
	}

	/**/

	if( item->dat.wpn.slayer != FACE_MJR_NULL ){
		if( flg_arw ){
			price += PRICE_ARW_SLAYER;
		} else {
			price += PRICE_WPN_SLAYER;
		}
	}

	/**/

	if( flg_dag )
		price = price / PRICE_DAGGER_DIV;

	/**/

	return price;
}

/**/

long	get_price_armor( item_t *item )
{
	long	price;

	if( item == NULL )
		return 0;
	if( item->kind != ITEM_KIND_ARMOR )
		return 0;
	if( item->tab.armor == NULL )
		return 0;

	price = PRICE_ARMOR_BASE;

	/**/

	price += item->tab.armor->def * PRICE_ARMOR_DEF_MUL;
	price += item->tab.armor->crtcl * PRICE_ARMOR_CRTCL_MUL;
	price += item->tab.armor->ac * PRICE_ARMOR_AC_MUL;

	if( item->tab.armor->def > 0 )
		price += PRICE_ARMOR_DEF_BASE;
	if( item->tab.armor->crtcl > 0 )
		price += PRICE_ARMOR_CRTCL_BASE;
	if( item->tab.armor->ac > 0 )
		price += PRICE_ARMOR_AC_BASE;

	/**/

	if( item->dat.armor.add_def < 0 )
		return 0;
	if( item->dat.armor.add_crtcl < 0 )
		return 0;
	if( item->dat.armor.add_ac < 0 )
		return 0;

	price += item->dat.armor.add_def * PRICE_ARMOR_ADD_DEF_MUL;
	price += item->dat.armor.add_crtcl * PRICE_ARMOR_ADD_CRTCL_MUL;
	price += item->dat.armor.add_ac * PRICE_ARMOR_ADD_AC_MUL;

	if( item->dat.armor.add_def < 0 )
		price += PRICE_ARMOR_ADD_DEF_BASE;
	if( item->dat.armor.add_crtcl < 0 )
		price += PRICE_ARMOR_ADD_CRTCL_BASE;
	if( item->dat.armor.add_ac < 0 )
		price += PRICE_ARMOR_ADD_AC_BASE;

	/**/

	price = price * item->tab.armor->rate_price / _100_PERCENT;
	price += item->tab.armor->add_price;

	/**/

	return price;
}

/**/

long	get_price_temple_remove_curse( mbr_t *mbr )
{
	if( mbr == NULL )
		return 0;

	return PRICE_TEMPLE_REMOVE_CURSE;
}

/**/

long	get_price_temple_cure_status( mbr_t *mbr )
{
	long	price;
	rate_t	smoker;

	if( mbr == NULL )
		return 0;

	price = get_specialist_lev( mbr );
	price *= PRICE_TEMPLE_CURE_STATUS_MUL;
	price += PRICE_TEMPLE_CURE_STATUS_ADD;

	smoker = mbr->fx_data.nicotine.poisoning_rate;
	smoker *= PRICE_TEMPLE_SMOKER_ADD_RATE;
	smoker /= _100_PERCENT;

	price += price * smoker / _100_PERCENT;

	return price;
}

/**/

long	get_price_temple_resurrection( mbr_t *mbr )
{
	long	price;
	rate_t	smoker;

	if( mbr == NULL )
		return 0;

	price = get_specialist_lev( mbr );
	price *= PRICE_TEMPLE_RESURRECTION_MUL;
	price += PRICE_TEMPLE_RESURRECTION_ADD;

	smoker = mbr->fx_data.nicotine.poisoning_rate;
	smoker *= PRICE_TEMPLE_SMOKER_ADD_RATE;
	smoker /= _100_PERCENT;

	price += price * smoker / _100_PERCENT;

	return price;
}

shop_n_t	get_shop_n( char face_mnr )
{
	switch( face_mnr ){
	case FACE_MNR_SHOP_INN:
		return SHOP_N_INN;
	case FACE_MNR_SHOP_BAR:
		return SHOP_N_BAR;
	case FACE_MNR_SHOP_TEMPLE:
		return SHOP_N_TEMPLE;
	case FACE_MNR_SHOP_WPN:
		return SHOP_N_WPN;
	case FACE_MNR_SHOP_ARMOR:
		return SHOP_N_ARMOR;
	case FACE_MNR_SHOP_MAGIC:
		return SHOP_N_MAGIC;
	case FACE_MNR_SHOP_GROCERY:
		return SHOP_N_GROCERY;
	case FACE_MNR_SHOP_RESTAURANT:
		return SHOP_N_RESTAURANT;
	case FACE_MNR_SHOP_TEAROOM:
		return SHOP_N_TEAROOM;
	case FACE_MNR_SHOP_TOBACCO:
		return SHOP_N_TOBACCO;
	}

	return SHOP_N_INN;
}

/**/

char	*get_shop_name( shop_n_t shop_n )
{
	switch( shop_n ){
	case SHOP_N_BAR:
		return MSG_NAME_BAR;
	case SHOP_N_INN:
		return MSG_NAME_INN;
	case SHOP_N_TEMPLE:
		return MSG_NAME_TEMPLE;
	case SHOP_N_WPN:
		return MSG_NAME_WPN;
	case SHOP_N_ARMOR:
		return MSG_NAME_ARMOR;
	case SHOP_N_MAGIC:
		return MSG_NAME_MAGIC;
	case SHOP_N_GROCERY:
		return MSG_NAME_GROCERY;
	case SHOP_N_RESTAURANT:
		return MSG_NAME_RESTAURANT;
	case SHOP_N_TEAROOM:
		return MSG_NAME_TEAROOM;
	case SHOP_N_TOBACCO:
		return MSG_NAME_TOBACCO;
	}

	return MSG_NULL;
}

/**/

void	set_map_sunshine( void )
{
	dun_t	*dun = get_dun();
	bool_t	flg_on_light;
	long	x, y;

	if( dun->lev != 0 )
		return;
	if( g_flg_night && chk_night() )
		return;
	if( !g_flg_night && !chk_night() )
		return;

	g_flg_night = chk_night();

	flg_on_light = !g_flg_night;
	if( chk_morning() )
		flg_on_light = FALSE;
	if( chk_evening() )
		flg_on_light = TRUE;

	for( y = 0; y < MAP_MAX_Y; y++ ){
		for( x = 0; x < MAP_MAX_X; x++ ){
			if( dun->map.obj.mjr[y][x] != FACE_MJR_FLOOR )
				continue;

			if( flg_on_light ){
				dun->map.obj.flg[y][x] |= FLG_OBJ_FIND;
				dun->map.light_depth[y][x] = 1;
			} else {
				dun->map.obj.flg[y][x] &= ~(FLG_OBJ_FIND);
				dun->map.light_depth[y][x] = 0;
			}
		}
	}
}

/**/

void	chk_morning_glow( long turn )
{
	dun_t	*dun = get_dun();
	long	n, next_morning_glow_n;

	if( dun->lev != 0 )
		return;

	next_morning_glow_n = get_glow_n( turn, TRUE );

	if( g_morning_glow_n > (next_morning_glow_n + 1) )
		g_morning_glow_n = 0;

	for( n = g_morning_glow_n; n <= next_morning_glow_n; n++ ){
		switch( n ){
		case 0:
			set_map_glow( +0, +0, TRUE );
			g_morning_glow_n++;
			break;
		case 1:
			set_map_glow( +1, +1, TRUE );
			g_morning_glow_n++;
			break;
		case 2:
			set_map_glow( +1, +0, TRUE );
			g_morning_glow_n++;
			break;
		case 3:
			set_map_glow( +0, +1, TRUE );
			g_morning_glow_n++;
			break;
		case 4:
			break;
		}
	}
}

/**/

void	chk_evening_glow( long turn )
{
	dun_t	*dun = get_dun();
	long	n, next_evening_glow_n;

	if( dun->lev != 0 )
		return;

	next_evening_glow_n = get_glow_n( turn, FALSE );

	if( g_evening_glow_n > (next_evening_glow_n + 1) )
		g_evening_glow_n = 0;

	for( n = g_evening_glow_n; n <= next_evening_glow_n; n++ ){
		switch( n ){
		case 0:
			set_map_glow( +0, +0, FALSE );
			g_evening_glow_n++;
			break;
		case 1:
			set_map_glow( +1, +1, FALSE );
			g_evening_glow_n++;
			break;
		case 2:
			set_map_glow( +1, +0, FALSE );
			g_evening_glow_n++;
			break;
		case 3:
			set_map_glow( +0, +1, FALSE );
			g_evening_glow_n++;
			break;
		case 4:
			break;
		}
	}
}

/**/

long	get_glow_n( long turn, bool_t flg_morning )
{
	long	hour, n;
	long	i;

	if( flg_morning )
		hour = MORNING_HOUR * TURN_PER_HOUR;
	else
		hour = EVENING_HOUR * TURN_PER_HOUR;

	if( turn < hour )
		return 4;

	for( i = 0; i < 4; i++ ){
		n = hour + (TURN_PER_HOUR * (i + 1) / 4);
		if( turn < n )
			return i;
	}

	return 4;
}

/**/

void	set_map_glow( long dx, long dy, bool_t flg_morning )
{
	dun_t	*dun = get_dun();
	long	x, y;

	for( y = 0; y < MAP_MAX_Y; y += 2 ){
		for( x = 0; x < MAP_MAX_X; x += 2 ){
			long	xx, yy;

			xx = x + dx;
			yy = y + dy;

			if( dun->map.obj.mjr[yy][xx] != FACE_MJR_FLOOR )
				continue;

			if( flg_morning )
				dun->map.light_depth[yy][xx]++;
			else
				dun->map.light_depth[yy][xx]--;

			if( dun->map.light_depth[yy][xx] > 0 )
				dun->map.obj.flg[yy][xx] |= FLG_OBJ_FIND;
			else
				dun->map.obj.flg[yy][xx] &= ~(FLG_OBJ_FIND);
		}
	}

	redraw_map();
}

/**/

town_ptn_col_tab_t	*get_town_ptn_col_tab( void )
{
	return town_ptn_col_tab;
}

/**/

long	get_town_ptn_col_tab_max_n( void )
{
	return town_ptn_col_tab_max_n;
}

/**/

bool_t	save_town( void )
{
	if( !save_town_ptn( &town_ptn ) ){
		print_msg( FLG_NULL, MSG_S, MSG_ERR_SAVE_TOWN_PTN );
		return FALSE;
	}

	return TRUE;
}

/**/
