/*#include	<stddef.h>*/
/*#include	<stdio.h>*/
#include	<string.h>
/*#include	<ctype.h>*/
/*#include	<time.h>*/
/*#include	<sys/stat.h>*/

#include	"gmain.h"
/*#include	"dun.h"*/
/*#include	"town.h"*/
#include	"item.h"
#include	"spell.h"
#include	"chr.h"
#include	"party.h"
#include	"mnstr.h"
/*#include	"fight.h"*/
/*#include	"fx.h"*/
#include	"trap.h"
#include	"draw.h"
/*#include	"curs.h"*/
/*#include	"menu.h"*/
/*#include	"msg.h"*/
/*#include	"ver.h"*/
#include	"gmain_prot.h"
#include	"dun_prot.h"
/*#include	"town_prot.h"*/
#include	"item_prot.h"
#include	"spell_prot.h"
#include	"chr_prot.h"
#include	"party_prot.h"
#include	"mnstr_prot.h"
#include	"fight_prot.h"
#include	"fx_prot.h"
#include	"trap_prot.h"
#include	"draw_prot.h"
/*#include	"curs_prot.h"*/
/*#include	"menu_prot.h"*/
/*#include	"tmenu_prot.h"*/
#include	"amenu_prot.h"
/*#include	"gfile_prot.h"*/
/*#include	"msg_prot.h"*/

/**/

lev_to_exp_t	lev_to_exp_tab[ABL_KIND_MAX_N] = {
	{ 100, 0 },	/* ABL_KIND_HP, */
	{ 100, 0 },	/* ABL_KIND_MP, */
	{ 100, 0 },	/* ABL_KIND_DEX, */
	{ 100, 0 },	/* ABL_KIND_STR, */
	{ 100, 0 },	/* ABL_KIND_QUI, */
	{ 100, 0 },	/* ABL_KIND_WIS, */
	{ 100, 0 },	/* ABL_KIND_INT, */
	{ 100, 0 },	/* ABL_KIND_CHA, */
	{ 100, 0 },	/* ABL_KIND_FIG, */
	{ 100, 0 },	/* ABL_KIND_MON, */
	{ 100, 0 },	/* ABL_KIND_HUN, */
	{ 100, 0 },	/* ABL_KIND_THI, */
	{ 100, 0 },	/* ABL_KIND_MAG, */
	{ 100, 0 },	/* ABL_KIND_SOR, */
	{ 100, 0 },	/* ABL_KIND_ENC, */
	{ 100, 0 },	/* ABL_KIND_SUM, */
	{ 100, 0 },	/* ABL_KIND_PRI, */
	{ 100, 0 },	/* ABL_KIND_SHA, */
	{ 100, 0 },	/* ABL_KIND_BAR, */
	{ 100, 0 },	/* ABL_KIND_NIN, */
};
lev_to_exp_t	lev_to_exp_val = {
	1000, 0
};

lev_to_val_t	lev_to_val_tab[ABL_KIND_MAX_N] = {
	{ 400, 12 },	/* ABL_KIND_HP, */
	{ 400, 12 },	/* ABL_KIND_MP, */
	{ 100, 0 },	/* ABL_KIND_DEX, */
	{ 100, 0 },	/* ABL_KIND_STR, */
	{ 100, 0 },	/* ABL_KIND_QUI, */
	{ 100, 0 },	/* ABL_KIND_WIS, */
	{ 100, 0 },	/* ABL_KIND_INT, */
	{ 100, 0 },	/* ABL_KIND_CHA, */
	{ 100, 0 },	/* ABL_KIND_FIG, */
	{ 100, 0 },	/* ABL_KIND_MON, */
	{ 100, 0 },	/* ABL_KIND_HUN, */
	{ 100, 0 },	/* ABL_KIND_THI, */
	{ 100, 0 },	/* ABL_KIND_MAG, */
	{ 100, 0 },	/* ABL_KIND_SOR, */
	{ 100, 0 },	/* ABL_KIND_ENC, */
	{ 100, 0 },	/* ABL_KIND_SUM, */
	{ 100, 0 },	/* ABL_KIND_PRI, */
	{ 100, 0 },	/* ABL_KIND_SHA, */
	{ 100, 0 },	/* ABL_KIND_BAR, */
	{ 100, 0 },	/* ABL_KIND_NIN, */
};

mnstr_null_t	mnstr_null[MBR_MAX_N];
square_t	mnstr_square;

/**/

void	init_chr( void )
{
	init_mnstr();
	init_party();
	init_party_debug();
}

/**/

void	act_chr( chr_t *chr )
{
	dun_t	*dun;
	bool_t	flg;
	long	dx, dy;

	if( chr == NULL )
		return;

	if( chk_flg_or( chr->stat,
			FLG_STAT_NOT_EXIST | FLG_STAT_DEAD
			| FLG_STAT_STONE | FLG_STAT_PARALYZE
			| FLG_STAT_SLEEP | FLG_STAT_FAINT ) ){
		return;
	}

	move_chr_trgt( chr );

	if( chk_flg( chr->stat, FLG_STAT_SLEEP ) ){
		if( chk_assist_chr( chr ) ){
			fx_t	*fx;

			fx = srch_fx( &(chr->fx), FX_KIND_SLEEP );
			clr_fx( fx );
			print_msg_mbr( chr, FLG_NULL, MSG_CLR_FX_SLEEP,
					chr->name );
			lost_trgt( chr );
			draw_mbr_stat( chr );
		} else {
			return;
		}
	}

	dun = get_dun();
	flg = (chr->x == chr->trgt.x) && (chr->y == chr->trgt.y);

	switch( chr->act.kind ){
	case ACT_KIND_MAX_N:
	case ACT_KIND_SHOP:
	case ACT_KIND_RECALL:
		break;
	case ACT_KIND_NULL:
	case ACT_KIND_MNSTR_TAIL:
	case ACT_KIND_MBR_TAIL:
		move_chr( chr, MOVE_KIND_STD );
		break;
	case ACT_KIND_MNSTR_FIGHT:
		if( chr->trgt.kind == TRGT_KIND_MNSTR ){
			mnstr_t *p;

			p = (mnstr_t *)(chr->trgt.p);
			dx = abs( chr->x - p->x );
			dy = abs( chr->y - p->y );

			if( (dx <= 1) && (dy <= 1) ){
				bash( chr, (chr_t *)(chr->trgt.p), NULL );
			} else if( !flg ){
				move_chr( chr, MOVE_KIND_STD );
			}
		} else if( chr->trgt.kind == TRGT_KIND_MNSTR_NULL ){
			mnstr_null_t *p;
			long	c;

			p = (mnstr_null_t *)(chr->trgt.p);
			dx = abs( chr->x - p->x );
			dy = abs( chr->y - p->y );

			if( (dx > 1) || (dy > 1) ){
				move_chr( chr, MOVE_KIND_STD );
				break;
			}

			c = dun->map.chr.mjr[p->y][p->x];
			if( c == FACE_MJR_NULL ){
				print_msg_mbr( chr, FLG_NULL, MSG_S,
						MSG_ERR_MNSTR_NULL );
				clr_chr_trgt_act( chr, FALSE );
			} else if( c == FACE_MJR_MBR ){
				chr_t	*chr2;

				chr2 = get_mbr( p->x, p->y );
				if( chr2 == NULL )
					break;

				chr->act.kind = ACT_KIND_MBR_FIGHT;
				mark_mbr( chr, chr2, DIST_NEAR );
				bash( chr, chr2, NULL );
			} else {
				mnstr_t	*mns;

				mns = get_mnstr( p->x, p->y );
				if( mns == NULL )
					break;

				mark_mnstr_dflt( chr, mns );
				bash( chr, mns, NULL );
			}
		} else {
			clr_chr_trgt_act( chr, FALSE );
		}
		break;
	case ACT_KIND_MNSTR_THROW:
		if( chr->trgt.kind == TRGT_KIND_MNSTR ){
			if( flg )
				throw( chr, (mnstr_t *)(chr->trgt.p), NULL );
			else
				move_chr( chr, MOVE_KIND_STD );
		} else if( chr->trgt.kind == TRGT_KIND_MNSTR_NULL ){
			mnstr_null_t	*p;
			long	c;

			if( !flg ){
				move_chr( chr, MOVE_KIND_STD );
				break;
			}

			p = (mnstr_null_t *)(chr->trgt.p);
			c = dun->map.chr.mjr[p->y][p->x];
			if( c == FACE_MJR_NULL ){
				throw( chr, NULL, NULL );
				clr_chr_trgt_act( chr, FALSE );
			} else if( c == FACE_MJR_MBR ){
				chr_t	*chr2;

				chr2 = get_mbr( p->x, p->y );
				if( chr2 == NULL )
					break;

				chr->act.kind = ACT_KIND_MBR_THROW;
				mark_mbr( chr, chr2, DIST_NEAR );
				throw( chr, chr2, NULL );
			} else {
				mnstr_t	*mns;

				mns = get_mnstr( p->x, p->y );
				if( mns == NULL )
					break;

				mark_mnstr_dflt( chr, mns );
				throw( chr, mns, NULL );
			}
		} else {
			clr_chr_trgt_act( chr, FALSE );
		}
		break;
	case ACT_KIND_MBR_FIGHT:
		dx = chr->trgt.true_x;
		dx -= chr->x;
		dy = chr->trgt.true_y;
		dy -= chr->y;
		if( (abs( dx ) <= 1) && (abs( dy ) <= 1) ){
			bash( chr, chr->trgt.p, NULL );
		} else if( !flg ){
			move_chr( chr, MOVE_KIND_STD );
		}
		break;
	case ACT_KIND_MBR_THROW:
		if( flg ){
			if( chr->trgt.kind
					!= TRGT_KIND_MNSTR_NULL ){
				throw( chr, chr->trgt.p, NULL );
			} else {
				print_msg_mbr( chr, FLG_NULL, MSG_S,
						MSG_ERR_MNSTR_NULL );
				clr_chr_trgt_act( chr, FALSE );
			}
		} else {
			move_chr( chr, MOVE_KIND_STD );
		}
		break;
	case ACT_KIND_DOOR_OPEN:
		if( flg ){
			if( chr_open_door( chr, chr->trgt.n ) ){
				clr_chr_trgt_act( chr, FALSE );
			}
		} else {
			move_chr( chr, MOVE_KIND_STD );
		}
		break;
	case ACT_KIND_DOOR_CLOSE:
		if( flg ){
			if( chr_close_door( chr, chr->trgt.n ) ){
				clr_chr_trgt_act( chr, FALSE );
			}
		} else {
			move_chr( chr, MOVE_KIND_STD );
		}
		break;
	case ACT_KIND_DOOR_JAM:
		if( flg ){
			if( chr_jam_door( chr, chr->trgt.n ) ){
				clr_chr_trgt_act( chr, FALSE );
			}
		} else {
			move_chr( chr, MOVE_KIND_STD );
		}
		break;
	case ACT_KIND_DOOR_DISARM:
		if( flg ){
			if( chr_disarm_door( chr, chr->trgt.n ) ){
				clr_chr_trgt_act( chr, FALSE );
			}
		} else {
			move_chr( chr, MOVE_KIND_STD );
		}
		break;
	case ACT_KIND_DOOR_BREAK:
		if( flg ){
			if( chr_break_door( chr, chr->trgt.n ) ){
				clr_chr_trgt_act( chr, FALSE );
			}
		} else {
			move_chr( chr, MOVE_KIND_STD );
		}
		break;
	case ACT_KIND_DOOR_PEEP:
		if( flg ){
			chr_peep_door( chr, chr->trgt.n );
		} else {
			move_chr( chr, MOVE_KIND_STD );
		}
		break;
	case ACT_KIND_DOOR_SRCH:
		if( flg ){
			chr_srch_door( chr, chr->trgt.n );
			clr_chr_trgt_act( chr, FALSE );
		} else {
			move_chr( chr, MOVE_KIND_STD );
		}
		break;
	case ACT_KIND_TRAP_DISARM:
		if( flg ){
			if( chr_disarm_trap( chr, chr->trgt.p ) ){
				clr_chr_trgt_act( chr, FALSE );
			}
		} else {
			move_chr( chr, MOVE_KIND_STD );
		}
		break;
	case ACT_KIND_TRAP_BREAK:
		if( flg ){
			if( chr_break_trap( chr, chr->trgt.p ) ){
				clr_chr_trgt_act( chr, FALSE );
			}
		} else {
			move_chr( chr, MOVE_KIND_STD );
		}
		break;
	case ACT_KIND_TRAP_SRCH:
		if( flg ){
			chr_srch_trap( chr, chr->trgt.p );
			clr_chr_trgt_act( chr, FALSE );
		} else {
			move_chr( chr, MOVE_KIND_STD );
		}
		break;
	case ACT_KIND_ITEM_PICK_UP:
		if( flg ){
			pick_up_item( chr, chr->x, chr->y );
			clr_chr_trgt_act( chr, FALSE );
		} else {
			move_chr( chr, MOVE_KIND_STD );
		}
		break;
	case ACT_KIND_ITEM_BREAK:
		if( flg ){
			if( chr_break_item( chr, chr->trgt.p ) ){
				clr_chr_trgt_act( chr, FALSE );
			}
		} else {
			move_chr( chr, MOVE_KIND_STD );
		}
		break;
	case ACT_KIND_ITEM_SRCH:
		if( flg ){
			chr_srch_item( chr, chr->trgt.p );
			clr_chr_trgt_act( chr, FALSE );
		} else {
			move_chr( chr, MOVE_KIND_STD );
		}
		break;
	case ACT_KIND_ITEM_SEND:
		if( flg ){
			send_item( chr );
			clr_chr_trgt_act( chr, FALSE );
		} else {
			move_chr( chr, MOVE_KIND_STD );
		}
		break;
	case ACT_KIND_ITEM_RECEIVE:
		if( flg ){
			receive_item( chr );
			clr_chr_trgt_act( chr, FALSE );
		} else {
			move_chr( chr, MOVE_KIND_STD );
		}
		break;
	case ACT_KIND_ITEM_DROP:
		drop_item( chr->x, chr->y, (item_t *)(chr->act.p),
				chr->act.n );
		clr_chr_trgt_act( chr, FALSE );
		break;
	case ACT_KIND_ITEM_OPEN:
		if( flg ){
			if( chr_open_item( (item_t *)(chr->trgt.p), chr ) ){
				clr_chr_trgt_act( chr, FALSE );
			}
		} else {
			move_chr( chr, MOVE_KIND_STD );
		}
		break;
	case ACT_KIND_ITEM_DISARM:
		if( flg ){
			if( chr_disarm_item( (item_t *)(chr->trgt.p),
					chr ) ){
				clr_chr_trgt_act( chr, FALSE );
			}
		} else {
			move_chr( chr, MOVE_KIND_STD );
		}
		break;
	case ACT_KIND_EQUIP_SEL:
		equip_item_sel( chr, (item_t *)chr->act.p );
		break;
	case ACT_KIND_EQUIP:
		equip_item( chr, (item_t *)chr->act.p,
				(equip_kind_t)chr->act.n );
		clr_chr_trgt_act( chr, FALSE );
		break;
	case ACT_KIND_TAKE_OFF:
		take_off_item( chr, (equip_kind_t)chr->act.n );
		clr_chr_trgt_act( chr, FALSE );
		break;
	case ACT_KIND_EQUIP_MBR:
		if( flg ){
			equip_item( (chr_t *)chr->act.p2,
					(item_t *)chr->act.p,
					(equip_kind_t)chr->act.n );
			clr_chr_trgt_act( chr, FALSE );
		} else {
			move_chr( chr, MOVE_KIND_STD );
		}
		break;
	case ACT_KIND_TAKE_OFF_MBR:
		if( flg ){
			take_off_item( (chr_t *)chr->act.p2,
					(equip_kind_t)chr->act.n );
			clr_chr_trgt_act( chr, FALSE );
		} else {
			move_chr( chr, MOVE_KIND_STD );
		}
		break;
	case ACT_KIND_POTION_QUAFF:
		quaff_potion( chr, (item_t *)chr->act.p, TRUE );
		clr_chr_trgt_act( chr, FALSE );
		break;
	case ACT_KIND_POTION_FILL:
		fill_potion( chr, (item_t *)chr->act.p );
		clr_chr_trgt_act( chr, FALSE );
		break;
	case ACT_KIND_SCROLL_READ:
		read_scroll( chr, (item_t *)chr->act.p );
		clr_chr_trgt_act( chr, FALSE );
		break;
	case ACT_KIND_STICK_ZAP:
		zap_stick( chr, (item_t *)chr->act.p );
		stop_zapping( chr );
		break;
	case ACT_KIND_FOOD_EAT:
		eat_food( chr, (item_t *)chr->act.p );
		clr_chr_trgt_act( chr, FALSE );
		break;
	case ACT_KIND_SRCH:
		if( (get_turn() % 2) == chr->act.n ){
			chr_srch_obj( chr );
		} else {
			move_chr( chr, MOVE_KIND_STD );
			if( (chr->x == chr->pre_x)
					&& (chr->y == chr->pre_y) ){
				chr_srch_obj( chr );
			}
		}
	case ACT_KIND_SPELL:
		chr_cast_spell( chr, (spell_tab_t *)(chr->act.p) );
		clr_chr_trgt_act( chr, FALSE );
		break;
	}

	chk_trap( chr );
}

/**/

bool_t	chk_assist_chr( chr_t *chr )
{
	party_t	*pty = get_party();
	long	i;

	if( chr == NULL )
		return FALSE;
	if( chr->kind != CHR_KIND_MBR )
		return FALSE;

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg_or( pty->mbr[i]->stat,
				FLG_STAT_NOT_EXIST
				| FLG_STAT_DEAD
				| FLG_STAT_STONE
				| FLG_STAT_PARALYZE
				| FLG_STAT_CONFUSION
				| FLG_STAT_SLEEP
				| FLG_STAT_FAINT ) ){
			continue;
		}
		if( pty->mbr[i]->act.kind != ACT_KIND_MBR_TAIL )
			continue;
		if( pty->mbr[i]->trgt.kind != TRGT_KIND_MBR )
			continue;
		if( pty->mbr[i]->trgt.p != chr )
			continue;
		if( abs( pty->mbr[i]->x - chr->x ) > 1 )
			continue;
		if( abs( pty->mbr[i]->y - chr->y ) > 1 )
			continue;

		return TRUE;
	}
	return FALSE;
}

/**/

void	clr_map_chr( chr_t *chr )
{
	dun_t	*dun;
	long	nx, ny;

	if( chr == NULL )
		return;

	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	dun = get_dun();

	nx = chr->x;
	ny = chr->y;
	if( (nx < 0) || (ny < 0) )
		return;
	if( (nx >= MAP_MAX_X) || (ny >= MAP_MAX_Y) )
		return;

	dun->map.chr.mjr[ny][nx] = FACE_MJR_NULL;
	dun->map.chr.mnr[ny][nx] = FACE_MNR_NULL;
	dun->map.chr.flg[ny][nx] = FLG_NULL;

	chr_light_up( chr, nx, ny, FALSE );
}

/**/

void	set_map_chr( chr_t *chr )
{
	dun_t	*dun;
	long	nx, ny;

	if( chr == NULL )
		return;

	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	dun = get_dun();

	nx = chr->x;
	ny = chr->y;
	if( (nx < 0) || (ny < 0) )
		return;
	if( (nx >= MAP_MAX_X) || (ny >= MAP_MAX_Y) )
		return;

	dun->map.chr.mjr[ny][nx] = chr->face_mjr;
	dun->map.chr.mnr[ny][nx] = chr->face_mnr;
	dun->map.chr.flg[ny][nx] = FLG_CHR_FIND;

	if( chr->kind == CHR_KIND_MBR )
		find_obj( nx, ny );

	chr_light_up( chr, nx, ny, TRUE );
}

/**/

void	move_chr( chr_t *chr, move_kind_t kind )
{
	rate_t	rate;

	if( chr == NULL )
		return;

	chr->pre_x = chr->x;
	chr->pre_y = chr->y;

	for( rate = chr->move_rate; rate > _100_PERCENT;
			rate -= _100_PERCENT ){
		move_chr_sub( chr, kind );
	}

	if( rate_randm( chr->move_rate ) )
		move_chr_sub( chr, kind );
}

/**/

void	move_chr_sub( chr_t *chr, move_kind_t kind )
{
	switch( kind ){
	case MOVE_KIND_NULL:
	case MOVE_KIND_MAX_N:
		break;
	case MOVE_KIND_STD:
		if( chk_chr_stagger( chr ) )
			move_chr_stagger( chr );
		else
			move_chr_std( chr );
		break;
	case MOVE_KIND_STAGGER:
		move_chr_stagger( chr );
		break;
	}
}

/**/

void	move_chr_std( chr_t *chr )
{
	dun_t	*dun;
	long	*xp, *yp;
	long	nx, ny;
	long	dx, dy;
	long	pre_x, pre_y;

	if( chr == NULL )
		return;

	if( chk_flg( chr->stat, FLG_STAT_CAUGHT ) )
		return;

	dun = get_dun();

	xp = &(chr->x);
	yp = &(chr->y);
	pre_x = chr->x;
	pre_y = chr->y;

	/* $B855o$?>l=j$r%/%j%"(B */
	dun->map.chr.mjr[*yp][*xp] = FACE_MJR_NULL;
	dun->map.chr.mnr[*yp][*xp] = FACE_MNR_NULL;
	dun->map.chr.flg[*yp][*xp] = FLG_NULL;

	dx = chr->trgt.x - *xp;
	dy = chr->trgt.y - *yp;


	nx = *xp + sgn( dx );
	ny = *yp + sgn( dy );

	if( !can_move_chr( chr, nx, ny ) ){
		if( dx && dy ){
			if( abs( dx ) > abs( dy ) ){
				if( chk_auto_mnstr(
						chr, nx, *yp, *xp, ny ) ){
					dx = 0;
					dy = 0;
				} else if( can_move_chr( chr, nx, *yp ) ){
					dy = 0;
				} else if( can_move_chr( chr, *xp, ny ) ){
					dx = 0;
				} else if( chk_auto_door(
						chr, nx, *yp, *xp, ny ) ){
					dx = 0;
					dy = 0;
				}
			} else {
				if( chk_auto_mnstr(
						chr, *xp, ny, nx, *yp ) ){
					dx = 0;
					dy = 0;
				} else if( can_move_chr( chr, *xp, ny ) ){
					dx = 0;
				} else if( can_move_chr( chr, nx, *yp ) ){
					dy = 0;
				} else if( chk_auto_door(
						chr, *xp, ny, nx, *yp ) ){
					dx = 0;
					dy = 0;
				}
			}
		} else if( dx ){
			if( chk_auto_mnstr(
					chr, nx, *yp - 1, nx, *yp + 1 ) ){
				dx = 0;
				dy = 0;
			} else if( can_move_chr( chr, nx, *yp - 1 ) ){
				dy = -1;
			} else if( can_move_chr( chr, nx, *yp + 1 ) ){
				dy = +1;
			} else if( chk_auto_door(
					chr, nx, *yp - 1, nx, *yp + 1 ) ){
				dx = 0;
				dy = 0;
			}
		} else if( dy ){
			if( chk_auto_mnstr(
					chr, *xp - 1, ny, *xp + 1, ny ) ){
				dx = 0;
				dy = 0;
			} else if( can_move_chr( chr, *xp - 1, ny ) ){
				dx = -1;
			} else if( can_move_chr( chr, *xp + 1, ny ) ){
				dx = +1;
			} else if( chk_auto_door(
					chr, *xp - 1, ny, *xp + 1, ny ) ){
				dx = 0;
				dy = 0;
			}
		}
	}


	nx = *xp + sgn( dx );
	ny = *yp + sgn( dy );
	if( can_move_chr( chr, nx, ny ) ){
		*xp += sgn( dx );
		*yp += sgn( dy );
	}

	dun->map.chr.mjr[*yp][*xp] = chr->face_mjr;
	dun->map.chr.mnr[*yp][*xp] = chr->face_mnr;
	dun->map.chr.flg[*yp][*xp] = FLG_CHR_FIND;

	chr_light_up( chr, pre_x, pre_y, FALSE );
	if( chr->kind == CHR_KIND_MBR )
		find_obj( chr->x, chr->y );
	chr_light_up( chr, chr->x, chr->y, TRUE );
}

/**/

bool_t	chk_chr_stagger( chr_t *chr )
{
	if( chr == NULL )
		return FALSE;

	if( chk_chr_stagger_sub( chr, FLG_STAT_CONFUSION,
			STAGGER_RATE_CHR_CONFUSION ) )
		return TRUE;
	if( chk_chr_stagger_sub( chr, FLG_STAT_BLIND,
			STAGGER_RATE_CHR_BLIND ) )
		return TRUE;
	if( chk_chr_stagger_sub( chr, FLG_STAT_DRUNK,
			STAGGER_RATE_CHR_DRUNK ) )
		return TRUE;

	return FALSE;
}

/**/

bool_t	chk_chr_stagger_sub( chr_t *chr, flg_stat_t flg, long rate )
{
	if( chr == NULL )
		return FALSE;

	if( !chk_flg( chr->stat, flg ) )
		return FALSE;
	if( !rate_randm( rate ) )
		return FALSE;
	if( chk_assist_chr( chr ) )
		return FALSE;

	return TRUE;
}

/**/

void	move_chr_stagger( chr_t *chr )
{
	long	*xp, *yp;
	long	dx, dy;
	dun_t	*dun;
	long	pre_x, pre_y;
	long	i;

	if( chr == NULL )
		return;

	if( chk_flg( chr->stat, FLG_STAT_CAUGHT ) )
		return;

	dun = get_dun();
	xp = &(chr->x);
	yp = &(chr->y);
	pre_x = chr->x;
	pre_y = chr->y;

	/* $B855o$?>l=j$r%/%j%"(B */
	dun->map.chr.mjr[*yp][*xp] = FACE_MJR_NULL;
	dun->map.chr.mnr[*yp][*xp] = FACE_MNR_NULL;
	dun->map.chr.flg[*yp][*xp] = FLG_NULL;

	for( i = 0; i < 64; i++ ){
		dx = randm( 3 ) - 1;
		dy = randm( 3 ) - 1;
		if( can_move_chr( chr, *xp + dx, *yp + dy ) ){
			*xp += dx;
			*yp += dy;
			break;
		}
	}

	dun->map.chr.mjr[*yp][*xp] = chr->face_mjr;
	dun->map.chr.mnr[*yp][*xp] = chr->face_mnr;
	dun->map.chr.flg[*yp][*xp] = FLG_CHR_FIND;

	chr_light_up( chr, pre_x, pre_y, FALSE );
	if( chr->kind == CHR_KIND_MBR )
		find_obj( chr->x, chr->y );
	chr_light_up( chr, chr->x, chr->y, TRUE );
}

/**/

bool_t	chk_auto_door( chr_t *chr, long x1, long y1, long x2, long y2 )
{
	if( chr->kind == CHR_KIND_MBR )
		return chk_auto_door_mbr( chr, x1, y1, x2, y2 );
	if( chr->kind == CHR_KIND_MNSTR )
		return chk_auto_door_mnstr( chr, x1, y1, x2, y2 );

	return FALSE;
}

/**/

bool_t	can_move_chr( chr_t *chr, long x, long y )
{
	dun_t	*dun;

	dun = get_dun();

	do {
		if( dun->map.obj.mjr[y][x] != FACE_MJR_TRAP )
			break;
		if( dun->map.chr.mjr[y][x] != FACE_MJR_NULL )
			break;
		if( chr != NULL ){
			if( chr->trgt.kind != TRGT_KIND_POS )
				break;
			if( chr->trgt.true_x != x )
				break;
			if( chr->trgt.true_y != y )
				break;
		}

		/* $B$o$6$Hf+$K3]$+$j$K9T$/;~(B */
		return TRUE;
	} while( 0 );

	do {
		if( dun->map.obj.mjr[y][x] != FACE_MJR_TRAP )
			break;
		if( chk_flg( dun->map.obj.flg[y][x], FLG_OBJ_LOOK_FLOOR ) )
			break;
		if( chr != NULL ){
			if( chk_flg( chr->stat, FLG_STAT_FLY ) )
				break;
			if( !chk_flg( chr->flg_chr, FLG_CHR_AVOID_TRAP ) )
				break;
		}

		/* $B<+F0E*$Kf+$rHr$1$k;~(B */
		return FALSE;
	} while( 0 );

	do {
		if( !chk_flg( dun->map.obj.flg[y][x], FLG_OBJ_PASS ) )
			break;
		if( dun->map.chr.mjr[y][x] != FACE_MJR_NULL )
			break;

		/* $BIaDL$KDL$l$k;~(B */
		return TRUE;
	} while( 0 );

	if( chr != NULL )
		if( chr->kind == CHR_KIND_MBR )
			chk_adjoin_mnstr( x, y );

	return FALSE;
}

/**/

void	die_chr( chr_t *p, bool_t flg_add_exp )
{
	dun_t	*dun;
	long	x, y;

	if( p == NULL )
		return;
	if( flg_add_exp && (p->kind == CHR_KIND_MNSTR) )
		if( p->mnstr_tab != NULL )
			exp_party( p->mnstr_tab->exp, TRUE );

	x = p->x;
	y = p->y;
	chr_light_up( p, x, y, FALSE );

	p->stat |= FLG_STAT_DEAD;

	lost_trgt( p );
	clr_chr_trgt_act( p, TRUE );
	free_fx_all( &(p->fx) );

	/* $B855o$?>l=j$r%/%j%"(B */
	dun = get_dun();
	dun->map.chr.mjr[y][x] = FACE_MJR_NULL;
	dun->map.chr.mnr[y][x] = FACE_MNR_NULL;
	dun->map.chr.flg[y][x] = FLG_NULL;
	draw_map( x, y, 1, 1 );

	draw_mbr_stat( p );

	if( p->kind == CHR_KIND_MBR )
		die_mbr( p );
	else if( p->kind == CHR_KIND_MNSTR )
		die_mnstr( p );
}

/**/

void	act_chr_auto_door( chr_t *chr, long x, long y )
{
	door_t	*dr;

	if( chr == NULL )
		return;

	dr = get_door( x, y );
	if( dr == NULL )
		return;

	if( chr->x < (dr->x - 1) )
		return;
	if( (dr->x + dr->dx - 1 + 1) < chr->x )
		return;
	if( chr->y < (dr->y - 1) )
		return;
	if( (dr->y + dr->dy - 1 + 1) < chr->y )
		return;

	chr_open_door( chr, dr->n );
}

/**/

void	act_chr_auto_mnstr( chr_t *chr, long x, long y )
{
	if( chr->kind == CHR_KIND_MBR )
		act_mbr_auto_mnstr( chr, x, y );
}

/**/

bool_t	chr_open_door( chr_t *chr, long dr_n )
{
	dun_t	*dun = get_dun();

	if( chr == NULL )
		return FALSE;

	if( chk_flg( dun->door[dr_n].flg, FLG_DOOR_OPEN ) )
		return TRUE;

	open_door( dr_n );

	if( chk_flg( dun->door[dr_n].flg, FLG_DOOR_JAMMED )
			&& !chk_flg( dun->door[dr_n].flg,
			FLG_DOOR_OPEN ) ){
		print_msg_mbr( chr, FLG_NULL, MSG_ERR_DOOR_OPEN_JAMMED );
		return FALSE;
	} else if( !chk_flg( dun->door[dr_n].flg, FLG_DOOR_OPEN ) ){
		return FALSE;
	}
	print_msg_mbr( chr, FLG_NULL, MSG_DOOR_OPEN, chr->name );

	if( chr->kind == CHR_KIND_MNSTR )
		clr_chr_trgt_act( chr, FALSE );

	return TRUE;
}

/**/

bool_t	chr_close_door( chr_t *chr, long dr_n )
{
	dun_t	*dun = get_dun();

	if( chr == NULL )
		return FALSE;

	if( !chk_flg( dun->door[dr_n].flg, FLG_DOOR_OPEN ) )
		return TRUE;

	close_door( dr_n );

	if( chk_flg( dun->door[dr_n].flg, FLG_DOOR_BROKEN ) ){
		print_msg_mbr( chr, FLG_NULL, MSG_ERR_DOOR_CLOSE_BROKEN );
		return FALSE;
	} else if( chk_flg( dun->door[dr_n].flg, FLG_DOOR_JAMMED ) ){
		print_msg_mbr( chr, FLG_NULL, MSG_ERR_DOOR_CLOSE_JAMMED );
		return FALSE;
	} else if( chk_flg( dun->door[dr_n].flg, FLG_DOOR_OPEN ) ){
		return FALSE;
	}
	print_msg_mbr( chr, FLG_NULL, MSG_DOOR_CLOSE, chr->name );

	if( chr->kind == CHR_KIND_MNSTR )
		clr_chr_trgt_act( chr, FALSE );

	return TRUE;
}

/**/

bool_t	chr_jam_door( chr_t *chr, long dr_n )
{
	item_t	*item = NULL;

	if( chr == NULL )
		return FALSE;

	if( chr->kind == CHR_KIND_MBR ){
		item = get_item_mbr( chr->mbr_n, ITEM_KIND_SPIKE );
		if( item == NULL ){
			print_msg_mbr( chr, FLG_NULL, MSG_ERR_DOOR_JAM_SPIKE,
					MSG_SPIKE );
			return FALSE;
		}
	}

	if( !jam_door( dr_n ) )
		return FALSE;

	if( chr->kind == CHR_KIND_MBR ){
		print_msg_mbr( chr, FLG_NULL, MSG_DOOR_JAM, chr->name );
		inc_item( item, -1 );
	}

	return TRUE;
}

/**/

bool_t	chr_disarm_door( chr_t *chr, long dr_n )
{
	rate_t	rate;

	if( chr == NULL )
		return FALSE;

	rate = chr->abl.lev[ABL_KIND_THI].n * DOOR_DISARM_RATE_MUL_N;
	rate += DOOR_DISARM_RATE_ADD_N;
	if( !rate_randm( rate ) ){
		print_msg_mbr( chr, FLG_NULL, MSG_ERR_DOOR_DISARM_LEV );
		return FALSE;
	}

	if( !disarm_door( dr_n ) )
		return TRUE;

	print_msg_mbr( chr, FLG_NULL, MSG_DOOR_DISARM, chr->name );

	return TRUE;
}

/**/

void	chr_peep_door( chr_t *chr, long dr_n )
{
	if( chr->kind == CHR_KIND_MBR )
		mbr_peep_door( chr, dr_n );
}

/**/

void	chr_srch_door( chr_t *chr, long dr_n )
{
	if( chr->kind == CHR_KIND_MBR )
		mbr_srch_door( chr, dr_n );
}

/**/

bool_t	chr_disarm_trap( chr_t *chr, trap_t *trap )
{
	if( chr == NULL )
		return TRUE;
	if( trap == NULL )
		return TRUE;
	if( trap->tab == NULL )
		return TRUE;

	if( chr_roll( chr, ABL_KIND_THI, ABL_KIND_DEX, trap->difficulty ) ){
		disarm_trap( trap );
		print_msg_mbr( chr, FLG_NULL, MSG_TRAP_DISARM,
				chr->name, trap->tab->name );
		return TRUE;
	}

	if( !rate_randm( TRAP_DISARM_FAILURE_RATE ) ){
		print_msg_mbr( chr, FLG_NULL, MSG_ERR_TRAP_DISARM_LEV );
		return FALSE;
	}

	caught_trap( trap, chr );

	return TRUE;
}

/**/

void	chr_srch_trap( chr_t *chr, trap_t *trap )
{
	if( chr->kind == CHR_KIND_MBR )
		mbr_srch_trap( chr, trap );
}

/**/

bool_t	chr_open_item( item_t *item, chr_t *chr )
{
	if( item == NULL )
		return TRUE;
	if( chr == NULL )
		return TRUE;
	if( item->kind != ITEM_KIND_CHEST )
		return TRUE;

	open_item( item, chr );

	print_msg_mbr( chr, FLG_NULL, MSG_ITEM_OPEN, chr->name, item->name );

	return TRUE;
}

/**/

bool_t	chr_disarm_item( item_t *item, chr_t *chr )
{
	if( item == NULL )
		return TRUE;
	if( chr == NULL )
		return TRUE;
	if( item->kind != ITEM_KIND_CHEST )
		return TRUE;
	if( item->dat.chest.trap == NULL ){
		print_msg_mbr( chr, FLG_NULL, MSG_ITEM_DISARM,
				chr->name, item->name );
		return TRUE;
	}

	if( chr_roll( chr, ABL_KIND_THI, ABL_KIND_DEX,
			item->dat.chest.trap->difficulty ) ){
		if( disarm_item( item ) ){
			print_msg_mbr( chr, FLG_NULL, MSG_ITEM_DISARM,
					chr->name, item->name );
		}
		return TRUE;
	}

	if( !rate_randm( ITEM_DISARM_FAILURE_RATE ) ){
		print_msg_mbr( chr, FLG_NULL, MSG_ERR_ITEM_DISARM_LEV );
		return FALSE;
	}

	chk_trap_chest( item, chr, _100_PERCENT );
	return TRUE;
}

/**/

void	chr_srch_item( chr_t *chr, item_t *item )
{
	if( chr->kind == CHR_KIND_MBR )
		mbr_srch_item( chr, item );
}

/**/

void	chr_srch_obj( chr_t *chr )
{
	if( chr->kind == CHR_KIND_MBR )
		mbr_srch_obj( chr );
}

/**/

void	move_chr_trgt( chr_t *chr )
{
	party_t	*pty = get_party();
	square_t	*sq;
	long	mx, my;
	door_t	*dr;
	bool_t	flg_x, flg_y;
	long	x, y;
	long	trgt_n;
	long	trgt_x, trgt_y;

	if( chr == NULL )
		return;

	sq = get_square( chr );

	switch( chr->trgt.kind ){
	case TRGT_KIND_NULL:
	case TRGT_KIND_AUTO:
	case TRGT_KIND_MAX_N:
		return;
	case TRGT_KIND_SQUARE:
		chr->trgt.x = sq->x + sq->chr_pos[chr->mbr_n].x;
		chr->trgt.y = sq->y + sq->chr_pos[chr->mbr_n].y;
		chr->trgt.true_x = chr->trgt.x;
		chr->trgt.true_y = chr->trgt.y;
		break;
	case TRGT_KIND_MBR:
		if( chr->trgt.p == NULL )
			break;
		trgt_n = chr->trgt.n;

		if( chk_flg_or( ((chr_t *)(chr->trgt.p))->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			trgt_x = sq->x + sq->chr_pos[trgt_n].x;
			trgt_y = sq->y + sq->chr_pos[trgt_n].y;
		} else {
			trgt_x = pty->mbr[trgt_n]->x;
			trgt_y = pty->mbr[trgt_n]->y;
		}
		chr->trgt.true_x = trgt_x;
		chr->trgt.true_y = trgt_y;

		switch( chr->trgt.dist ){
		case DIST_NEAR:
			chr->trgt.x = trgt_x;
			chr->trgt.y = trgt_y;

			if( (abs( chr->trgt.x - chr->x ) <= 1)
					&& (abs( chr->trgt.y - chr->y )
					<= 1) ){
				chr->trgt.x = chr->x;
				chr->trgt.y = chr->y;
			}
			break;
		case DIST_MEDIUM:
			x = sq->x + sq->chr_pos[chr->mbr_n].x;
			x += trgt_x;
			x /= 2;
			y = sq->y + sq->chr_pos[chr->mbr_n].y;
			y += trgt_y;
			y /= 2;
			chr->trgt.x = x;
			chr->trgt.y = y;
			break;
		case DIST_FAR:
			chr->trgt.x = sq->x + sq->chr_pos[chr->mbr_n].x;
			chr->trgt.y = sq->y + sq->chr_pos[chr->mbr_n].y;
			break;
		}
		break;
	case TRGT_KIND_MNSTR:
		if( !chk_flg( ((mnstr_t *)chr->trgt.p)->flg_chr,
				FLG_CHR_FIND) )
			clr_chr_trgt_act( chr, FALSE );

		chr->trgt.true_x
				= ((mnstr_t *)chr->trgt.p)->x;
		chr->trgt.true_y
				= ((mnstr_t *)chr->trgt.p)->y;

		switch( chr->trgt.dist ){
		case DIST_NEAR:
			chr->trgt.x = ((mnstr_t *)chr->trgt.p)->x;
			chr->trgt.y = ((mnstr_t *)chr->trgt.p)->y;

			if( (abs( chr->trgt.x - chr->x ) <= 1)
					&& (abs( chr->trgt.y - chr->y )
					<= 1) ){
				chr->trgt.x = chr->x;
				chr->trgt.y = chr->y;
			}
			break;
		case DIST_MEDIUM:
			x = sq->x + sq->chr_pos[chr->mbr_n].x;
			x += ((mnstr_t *)chr->trgt.p)->x;
			x /= 2;
			y = sq->y + sq->chr_pos[chr->mbr_n].y;
			y += ((mnstr_t *)chr->trgt.p)->y;
			y /= 2;
			chr->trgt.x = x;
			chr->trgt.y = y;

			if( (abs( chr->trgt.x - chr->x ) <= 1)
					&& (abs( chr->trgt.y
					- chr->y ) <= 1) ){
				chr->trgt.x = chr->x;
				chr->trgt.y = chr->y;
			}
			break;
		case DIST_FAR:
			chr->trgt.x = sq->x + sq->chr_pos[chr->mbr_n].x;
			chr->trgt.y = sq->y + sq->chr_pos[chr->mbr_n].y;
			break;
		}
		break;
	case TRGT_KIND_MNSTR_NULL:
		chr->trgt.true_x = ((mnstr_null_t *)chr->trgt.p)->x;
		chr->trgt.true_y = ((mnstr_null_t *)chr->trgt.p)->y;

		switch( chr->trgt.dist ){
		case DIST_NEAR:
			chr->trgt.x = ((mnstr_null_t *)chr->trgt.p)->x;
			chr->trgt.y = ((mnstr_null_t *)chr->trgt.p)->y;

			if( (abs( chr->trgt.x - chr->x ) <= 1)
					&& (abs( chr->trgt.y - chr->y )
					<= 1) ){
				chr->trgt.x = chr->x;
				chr->trgt.y = chr->y;
			}
			break;
		case DIST_MEDIUM:
			x = sq->x + sq->chr_pos[chr->mbr_n].x;
			x += ((mnstr_null_t *)chr->trgt.p)->x;
			x /= 2;
			y = sq->y + sq->chr_pos[chr->mbr_n].y;
			y += ((mnstr_null_t *)chr->trgt.p)->y;
			y /= 2;
			chr->trgt.x = x;
			chr->trgt.y = y;

			if( (abs( chr->trgt.x - chr->x ) <= 1)
					&& (abs( chr->trgt.y - chr->y )
					<= 1) ){
				chr->trgt.x = chr->x;
				chr->trgt.y = chr->y;
			}
			break;
		case DIST_FAR:
			chr->trgt.x = sq->x + sq->chr_pos[chr->mbr_n].x;
			chr->trgt.y = sq->y + sq->chr_pos[chr->mbr_n].y;
			break;
		}
		break;
	case TRGT_KIND_TRAP:
		chr->trgt.true_x = ((trap_t *)chr->trgt.p)->x;
		chr->trgt.true_y = ((trap_t *)chr->trgt.p)->y;
		chr->trgt.x = chr->trgt.true_x;
		chr->trgt.y = chr->trgt.true_y;
		if( (abs( chr->trgt.x - chr->x ) <= 1)
				&& (abs( chr->trgt.y - chr->y ) <= 1) ){
			chr->trgt.x = chr->x;
			chr->trgt.y = chr->y;
		}
		break;
	case TRGT_KIND_ITEM:
		break;
	case TRGT_KIND_DOOR:
		mx = chr->x;
		my = chr->y;
		dr = chr->trgt.p;
		flg_x = FALSE;
		flg_y = FALSE;

		/* $B%I%"$N#1%V%m%C%/$H$J$j(B */
		if( mx < dr->x ){
			chr->trgt.x = dr->x - 1;
		} else if( (dr->x + dr->dx - 1) < mx ){
			chr->trgt.x = (dr->x + dr->dx - 1) + 1;
		} else {
			chr->trgt.x = chr->x;
			flg_x = TRUE;
		}
		if( my < dr->y ){
			chr->trgt.y = dr->y - 1;
		} else if( (dr->y + dr->dy - 1) < my ){
			chr->trgt.y = (dr->y + dr->dy - 1) + 1;
		} else {
			chr->trgt.y = chr->y;
			flg_y = TRUE;
		}
		if( flg_x && flg_y ){	/* $B%I%"$NCf$K5o$k;~(B */
			chr->trgt.x = dr->x - 1;
			chr->trgt.y = dr->y - 1;
		}
		break;
	case TRGT_KIND_POS:
		break;
	}
}

/**/

bool_t	chk_auto_mark_cont( chr_t *chr )
{
	if( chr == NULL )
		return FALSE;

	if( chk_flg( chr->flg_chr, FLG_CHR_AUTO_MARK_CONT ) ){
		exec_menu_auto_mark( chr );
		if( chr->act.kind == ACT_KIND_NULL )
			chr->flg_chr &= ~FLG_CHR_AUTO_MARK_CONT;

		return TRUE;
	}

	return FALSE;
}

/**/

void	clr_chr_trgt_act( chr_t *chr, bool_t flg_force )
{
	if( chr == NULL )
		return;

	if( flg_force || !chk_auto_mark_cont( chr ) ){
		clr_chr_trgt( chr );
		clr_chr_act( chr );
	}
}

/**/

void	clr_chr_trgt( chr_t *chr )
{
	if( chr == NULL )
		return;

	mark_square( chr );
}

/**/

bool_t	set_chr_act(
	chr_t *chr, act_kind_t kind,
	void *p, void *p2,
	long n, long n2
)
{
	char	*msg;
	item_t	*item;

	if( chr == NULL )
		return FALSE;

	msg = NULL;
	switch( kind ){
	case ACT_KIND_NULL:
		msg = MSG_ACT_NULL;
		break;
	case ACT_KIND_MNSTR_FIGHT:
		msg = MSG_ACT_MNSTR_FIGHT;
		break;
	case ACT_KIND_MNSTR_THROW:
		msg = MSG_ACT_MNSTR_THROW;
		break;
	case ACT_KIND_MNSTR_TAIL:
		msg = MSG_ACT_MNSTR_TAIL;
		break;
	case ACT_KIND_MBR_FIGHT:
		msg = MSG_ACT_MBR_FIGHT;
		break;
	case ACT_KIND_MBR_THROW:
		msg = MSG_ACT_MBR_THROW;
		break;
	case ACT_KIND_MBR_TAIL:
		msg = MSG_ACT_MBR_TAIL;
		break;
	case ACT_KIND_DOOR_OPEN:
		msg = MSG_ACT_DOOR_OPEN;
		break;
	case ACT_KIND_DOOR_CLOSE:
		msg = MSG_ACT_DOOR_CLOSE;
		break;
	case ACT_KIND_DOOR_JAM:
		msg = MSG_ACT_DOOR_JAM;
		break;
	case ACT_KIND_DOOR_DISARM:
		msg = MSG_ACT_DOOR_DISARM;
		break;
	case ACT_KIND_DOOR_BREAK:
		msg = MSG_ACT_DOOR_BREAK;
		break;
	case ACT_KIND_DOOR_PEEP:
		msg = MSG_ACT_DOOR_PEEP;
		break;
	case ACT_KIND_DOOR_SRCH:
		msg = MSG_ACT_DOOR_SRCH;
		break;
	case ACT_KIND_TRAP_DISARM:
		msg = MSG_ACT_TRAP_DISARM;
		break;
	case ACT_KIND_TRAP_BREAK:
		msg = MSG_ACT_TRAP_BREAK;
		break;
	case ACT_KIND_TRAP_SRCH:
		msg = MSG_ACT_TRAP_SRCH;
		break;
	case ACT_KIND_ITEM_PICK_UP:
		msg = MSG_ACT_ITEM_PICK_UP;
		break;
	case ACT_KIND_ITEM_BREAK:
		msg = MSG_ACT_ITEM_BREAK;
		break;
	case ACT_KIND_ITEM_SRCH:
		msg = MSG_ACT_ITEM_SRCH;
		break;
	case ACT_KIND_ITEM_SEND:
		msg = MSG_ACT_ITEM_SEND;
		break;
	case ACT_KIND_ITEM_DROP:
		msg = MSG_ACT_ITEM_DROP;
		break;
	case ACT_KIND_ITEM_RECEIVE:
		msg = MSG_ACT_ITEM_RECEIVE;
		break;
	case ACT_KIND_ITEM_OPEN:
		msg = MSG_ACT_ITEM_OPEN;
		break;
	case ACT_KIND_ITEM_DISARM:
		msg = MSG_ACT_ITEM_DISARM;
		break;
	case ACT_KIND_EQUIP_SEL:
		msg = MSG_ACT_EQUIP;
		item = (item_t *)p;
		if( chr->kind == CHR_KIND_MBR ){
			if( item == NULL )
				return FALSE;
			if( !chk_equip_two_handed_wpn( chr, item,
					item->equip_kind ) ){
				return FALSE;
			}
		}
		break;
	case ACT_KIND_EQUIP:
		msg = MSG_ACT_EQUIP;
		item = (item_t *)p;
		if( chr->kind == CHR_KIND_MBR ){
			if( !chk_equip_two_handed_wpn( chr, item,
					item->equip_kind ) ){
				return FALSE;
			}
		}
		break;
	case ACT_KIND_TAKE_OFF:
		msg = MSG_ACT_TAKE_OFF;
		break;
	case ACT_KIND_EQUIP_MBR:
		msg = MSG_ACT_EQUIP_MBR;
		item = (item_t *)p;
		if( chr->kind == CHR_KIND_MBR ){
			if( !chk_equip_two_handed_wpn( (chr_t *)p2, item,
					item->equip_kind ) ){
				return FALSE;
			}
		}
		break;
	case ACT_KIND_TAKE_OFF_MBR:
		msg = MSG_ACT_TAKE_OFF_MBR;
		break;
	case ACT_KIND_POTION_QUAFF:
		msg = MSG_ACT_POTION_QUAFF;
		break;
	case ACT_KIND_POTION_FILL:
		msg = MSG_ACT_POTION_FILL;
		break;
	case ACT_KIND_SCROLL_READ:
		msg = MSG_ACT_SCROLL_READ;
		break;
	case ACT_KIND_STICK_ZAP:
		msg = MSG_ACT_STICK_ZAP;
		break;
	case ACT_KIND_FOOD_EAT:
		msg = MSG_ACT_FOOD_EAT;
		break;
	case ACT_KIND_SRCH:
		msg = MSG_ACT_SRCH;
		break;
	case ACT_KIND_SPELL:
		msg = ((spell_tab_t *)p)->name;
		break;
	case ACT_KIND_SHOP:
	case ACT_KIND_RECALL:
	case ACT_KIND_MAX_N:
		return FALSE;
	}

	chr->act.kind = kind;
	strncpy( chr->act.msg, msg, ACT_MSG_MAX_LEN );
	chr->act.p = p;
	chr->act.p2 = p2;
	chr->act.n = n;
	chr->act.n2 = n2;

	switch( kind ){
	case ACT_KIND_MNSTR_FIGHT:
	case ACT_KIND_MNSTR_THROW:
	case ACT_KIND_MNSTR_TAIL:
		chr->act.dflt_kind_mnstr = chr->act.kind;
		strncpy( chr->act.dflt_msg_mnstr, chr->act.msg,
				ACT_MSG_MAX_LEN );
		break;
	default:
		break;
	}

	draw_mbr_stat( chr );

	return TRUE;
}

/**/

void	clr_chr_act( chr_t *chr )
{
	if( chr == NULL )
		return;

	chr->act.kind = ACT_KIND_NULL;
	strncpy( chr->act.msg, MSG_ACT_NULL, ACT_MSG_MAX_LEN );

	draw_mbr_stat( chr );
}

/**/

void	lost_trgt( void *p )
{
	party_t	*pty = get_party();
	mnstr_t	*head, *mns;
	long	i;

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( p != pty->mbr[i]->trgt.p )
			if( p != pty->mbr[i]->act.p )
				continue;

		clr_chr_trgt_act( pty->mbr[i], FALSE );
	}

	head = get_mnstr_used();
	if( head != NULL )
		for( mns = head->next; mns != head; mns = mns->next )
			clr_chr_trgt_act( mns, FALSE );
}

/**/

void	mark_mbr( chr_t *chr1, mbr_t *mbr2, dist_t dist )
{
	if( chr1 == NULL )
		return;
	if( mbr2 == NULL )
		return;

	chr1->trgt.kind = TRGT_KIND_MBR;
	chr1->trgt.p = mbr2;
	chr1->trgt.n = mbr2->mbr_n;
	chr1->trgt.x = mbr2->x;
	chr1->trgt.y = mbr2->y;
	chr1->trgt.true_x = mbr2->x;
	chr1->trgt.true_y = mbr2->y;
	chr1->trgt.dist = dist;
}

/**/

void	mark_mnstr_no_regist( chr_t *chr, mnstr_t *mnstr, dist_t dist )
{
	if( chr == NULL )
		return;
	if( mnstr == NULL )
		return;

	chr->trgt.kind = TRGT_KIND_MNSTR;
	chr->trgt.p = mnstr;
	chr->trgt.n = 0;
	chr->trgt.x = mnstr->x;
	chr->trgt.y = mnstr->y;
	chr->trgt.true_x = chr->trgt.x;
	chr->trgt.true_y = chr->trgt.y;
	chr->trgt.dist = dist;

	print_msg_mbr( chr, FLG_MSG_NO_MORE_PREV
			| FLG_MSG_NO_MORE_NEXT,
			MSG_FMT_MARK_MNSTR,
			chr->name, mnstr->name );
}

/**/

void	mark_mnstr_dflt( chr_t *chr, mnstr_t *mnstr )
{
	if( chr == NULL )
		return;
	if( mnstr == NULL )
		return;

	mark_mnstr_no_regist( chr, mnstr, chr->trgt.dflt_dist_mnstr );
}

/**/

void	mark_mnstr( chr_t *chr, mnstr_t *mnstr, dist_t dist )
{
	if( chr == NULL )
		return;
	if( mnstr == NULL )
		return;

	mark_mnstr_no_regist( chr, mnstr, dist );
	chr->trgt.dflt_dist_mnstr = dist;
}

/**/

void	mark_mnstr_null_no_regist( chr_t *chr, long x, long y, dist_t dist )
{
	if( chr == NULL )
		return;
	if( chr->kind != CHR_KIND_MBR )
		return;

	mnstr_null[chr->mbr_n].x = x;
	mnstr_null[chr->mbr_n].y = y;

	chr->trgt.kind = TRGT_KIND_MNSTR_NULL;
	chr->trgt.p = &(mnstr_null[chr->mbr_n]);
	chr->trgt.n = 0;
	chr->trgt.x = mnstr_null[chr->mbr_n].x;
	chr->trgt.y = mnstr_null[chr->mbr_n].y;
	chr->trgt.true_x = chr->trgt.x;
	chr->trgt.true_y = chr->trgt.y;
	chr->trgt.dist = dist;
}

/**/

void	mark_mnstr_null_dflt( chr_t *chr, long x, long y )
{
	if( chr == NULL )
		return;

	mark_mnstr_null_no_regist( chr, x, y, chr->trgt.dflt_dist_mnstr );
}

/**/

void	mark_mnstr_null( chr_t *chr, long x, long y, dist_t dist )
{
	if( chr == NULL )
		return;

	mark_mnstr_null_no_regist( chr, x, y, dist );
	chr->trgt.dflt_dist_mnstr = dist;
}

/**/

void	mark_item( chr_t *chr, item_t *item, dist_t dist )
{
	if( chr == NULL )
		return;
	if( item == NULL )
		return;

	chr->trgt.kind = TRGT_KIND_ITEM;
	chr->trgt.p = (void *)item;
	chr->trgt.n = 0;
	chr->trgt.x = item->x;
	chr->trgt.y = item->y;
	chr->trgt.true_x = chr->trgt.x;
	chr->trgt.true_y = chr->trgt.y;
	chr->trgt.dist = dist;
}

/**/

void	mark_door( chr_t *chr, door_t *dr, dist_t dist )
{
	if( chr == NULL )
		return;
	if( dr == NULL )
		return;

	chr->trgt.kind = TRGT_KIND_DOOR;
	chr->trgt.p = dr;
	chr->trgt.n = dr->n;
	chr->trgt.x = dr->x;
	chr->trgt.y = dr->y;
	chr->trgt.true_x = chr->trgt.x;
	chr->trgt.true_y = chr->trgt.y;
	chr->trgt.dist = dist;
}

/**/

void	mark_trap( chr_t *chr, trap_t *trap, dist_t dist )
{
	if( chr == NULL )
		return;
	if( trap == NULL )
		return;

	chr->trgt.kind = TRGT_KIND_TRAP;
	chr->trgt.p = trap;
	chr->trgt.n = 0;
	chr->trgt.x = trap->x;
	chr->trgt.y = trap->y;
	chr->trgt.true_x = chr->trgt.x;
	chr->trgt.true_y = chr->trgt.y;
	chr->trgt.dist = dist;
}

/**/

void	mark_square( chr_t *chr )
{
	party_t	*pty = get_party();
	if( chr == NULL )
		return;

	chr->trgt.kind = TRGT_KIND_SQUARE;
	chr->trgt.p = &(pty->square);
	chr->trgt.n = 0;
	chr->trgt.x = pty->square.x + pty->square.chr_pos[chr->mbr_n].x;
	chr->trgt.y = pty->square.y + pty->square.chr_pos[chr->mbr_n].y;
	chr->trgt.true_x = chr->trgt.x;
	chr->trgt.true_y = chr->trgt.y;
	chr->trgt.dist = DIST_NEAR;
}

/**/

void	mark_pos( chr_t *chr, long x, long y, dist_t dist )
{
	if( chr == NULL )
		return;

	chr->trgt.kind = TRGT_KIND_POS;
	chr->trgt.p = NULL;
	chr->trgt.n = 0;
	chr->trgt.x = x;
	chr->trgt.y = y;
	chr->trgt.true_x = chr->trgt.x;
	chr->trgt.true_y = chr->trgt.y;
	chr->trgt.dist = dist;
}

/**/

void	stop_zapping( chr_t *chr )
{
	if( chr == NULL )
		return;

	clr_chr_trgt_act( chr, FALSE );
}

/**/

void	chr_srch_begin( chr_t *chr )
{
	if( chr == NULL )
		return;

	chr->act.kind = ACT_KIND_SRCH;
	strncpy( chr->act.msg, MSG_ACT_SRCH,
			ACT_MSG_MAX_LEN );
	chr->act.p = NULL;
	chr->act.p2 = NULL;
	chr->act.n = get_turn() % 2;
	chr->act.n2 = 0;
	draw_mbr_stat( chr );
}

/**/

void	chr_srch_end( chr_t *chr )
{
	if( chr == NULL )
		return;

	if( chr->act.kind == ACT_KIND_SRCH )
		clr_chr_trgt_act( chr, FALSE );
}

/**/

bool_t	chk_infra_vision( chr_t *chr )
{
	if( chr == NULL )
		return FALSE;

	if( chr->fx_data.infra_vision > 0 )
		return TRUE;

	if( chr->kind == CHR_KIND_MBR ){
		switch( chr->race.main ){
		case MAIN_RACE_HUMAN:
		case MAIN_RACE_HALF_ELF:
		case MAIN_RACE_VIVID:
			return FALSE;
		case MAIN_RACE_ELF:
		case MAIN_RACE_DWARF:
			return TRUE;
		case MAIN_RACE_MAX_N:
			return FALSE;
		}
	}

	return FALSE;
}

/**/

bool_t	chr_light_up( chr_t *chr, long x, long y, bool_t flg_on )
{
	long	dx, dy;
	dun_t	*dun;

	dun = get_dun();

	if( flg_on && chk_flg_or( chr->stat,
			FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return FALSE;

	if( !chk_infra_vision( chr ) ){
		item_t	*lit;

		if( chr->kind != CHR_KIND_MBR )
			return FALSE;

		lit = &(get_mbr_item_asgn_equip( chr )
				[EQUIP_KIND_LIGHT_SOURCE]);
		if( lit->kind != ITEM_KIND_LIGHT )
			return FALSE;
		if( lit->dat.light.turn <= 0 )
			return FALSE;
	}

	for( dy = -1; dy <= +1; dy++ ){
		if( !clip_y( y + dy ) )
			continue;

		for( dx = -1; dx <= +1; dx++ ){
			bool_t	flg_find;

			if( !clip_x( x + dx ) )
				continue;

			flg_find = turn_light( x + dx, y + dy, flg_on );
			if( flg_on && flg_find ){
				if( chr->kind == CHR_KIND_MBR ){
					dun->map.obj.flg[y + dy][x + dx]
							|= FLG_OBJ_FIND;
				}
			}
		}
	}

	return TRUE;
}

/**/

void	exp_chr( chr_t *chr, long exp, bool_t flg_draw )
{
	long	i, n, mod_n;
	class_t	*class_tab;
	rate_t	rate;
	long	exp_add, exp_mod;

	if( chr == NULL )
		return;

	class_tab = get_class_tab();
	if( class_tab == NULL )
		return;

	exp_mod = exp;
	n = 0;
	mod_n = 0;
	for( i = 0; i < ABL_KIND_MAX_N; i++ ){
		rate = class_tab[chr->class_n].abl_rate[i];
		if( rate > 0 ){
			n++;
			if( randm( n ) == 0 )
				mod_n = i;
		}
		exp_add = exp * rate / _100_PERCENT;
		exp_mod -= exp_add;
		
	}
	for( i = 0; i < ABL_KIND_MAX_N; i++ ){
		long	exp_n;

		rate = class_tab[chr->class_n].abl_rate[i];
		exp_add = exp * rate / _100_PERCENT;

		if( i == mod_n )
			exp_n = exp_add + exp_mod;
		else
			exp_n = exp_add;
		chr->abl.exp[i].n += exp_n;

		if( chr->abl.exp[i].max < chr->abl.exp[i].n )
			chr->abl.exp[i].max = chr->abl.exp[i].n;
	}
	set_lev( chr, flg_draw );

	if( flg_draw )
		print_msg_mbr( chr, FLG_NULL, MSG_EXP_MBR, chr->name, exp );
}

/**/

void	set_lev( chr_t *chr, bool_t flg_draw )
{
	long	i, j;
	long	lev;
	long	need_exp;

	if( chr == NULL )
		return;

	for( i = 0; i < ABL_KIND_MAX_N; i++ ){
		lev = chr->abl.lev[i].max;
		for( j = 0; j < 1024; j++ ){
			need_exp = calc_need_exp( lev + 1, i );
			if( need_exp > chr->abl.exp[i].n )
				break;
			lev++;
			if( flg_draw ){
				print_msg_mbr( chr, FLG_NULL, MSG_LEV_UP,
						chr->name,
						get_abl_name( i ), lev );
			}
		}
		chr->abl.lev[i].n += lev - chr->abl.lev[i].max;
		chr->abl.lev[i].max = lev;
	}
}

/**/

char	*get_abl_name( abl_kind_t kind )
{
	switch( kind ){
	case ABL_KIND_HP:
		return MSG_ABL_NAME_HP;
	case ABL_KIND_MP:
		return MSG_ABL_NAME_MP;
	case ABL_KIND_DEX:
		return MSG_ABL_NAME_DEX;
	case ABL_KIND_STR:
		return MSG_ABL_NAME_STR;
	case ABL_KIND_AGI:
		return MSG_ABL_NAME_AGI;
	case ABL_KIND_WIS:
		return MSG_ABL_NAME_WIS;
	case ABL_KIND_INT:
		return MSG_ABL_NAME_INT;
	case ABL_KIND_CHA:
		return MSG_ABL_NAME_CHA;
	case ABL_KIND_FIG:
		return MSG_ABL_NAME_FIG;
	case ABL_KIND_MON:
		return MSG_ABL_NAME_MON;
	case ABL_KIND_HUN:
		return MSG_ABL_NAME_HUN;
	case ABL_KIND_THI:
		return MSG_ABL_NAME_THI;
	case ABL_KIND_MAG:
		return MSG_ABL_NAME_MAG;
	case ABL_KIND_SOR:
		return MSG_ABL_NAME_SOR;
	case ABL_KIND_ENC:
		return MSG_ABL_NAME_ENC;
	case ABL_KIND_SUM:
		return MSG_ABL_NAME_SUM;
	case ABL_KIND_PRI:
		return MSG_ABL_NAME_PRI;
	case ABL_KIND_SHA:
		return MSG_ABL_NAME_SHA;
	case ABL_KIND_BAR:
		return MSG_ABL_NAME_BAR;
	case ABL_KIND_NIN:
		return MSG_ABL_NAME_NIN;
	case ABL_KIND_MAX_N:
		break;
	}

	return MSG_NULL;
}

/**/

long	calc_lev_to_exp( long lev, abl_kind_t abl )
{
	long	n;

	if( lev <= 0 )
		return 0;

	n = lev * lev;

	n *= lev_to_exp_tab[abl].mul_lev;
	n /= _100_PERCENT;
	n *= lev_to_exp_val.mul_lev;
	n /= _100_PERCENT;

	n += lev_to_exp_tab[abl].add_lev;
	n += lev_to_exp_val.add_lev;

	return n;
}

/**/

long	calc_need_exp( long lev, abl_kind_t abl )
{
	return calc_lev_to_exp( lev, abl );
}

/**/

long	calc_lev_to_val( long lev, abl_kind_t abl )
{
	long	val;

	/* lev $B$,%^%$%J%9$J$iCM$rD>@\;XDj$9$k(B */
	if( lev <= -1 )
		return( abs( lev ) );

	val = lev * lev_to_val_tab[abl].mul_lev;
	val /= _100_PERCENT;
	val += lev_to_val_tab[abl].add_lev;

	if( val < 0 )
		val = 0;

	return val;
}

/**/

long	calc_resi( rate_t resi, long n )
{
	if( resi < 1)
		resi = 1;

	return( (n * _100_PERCENT) / resi );
}

/**/

long	get_generalist_lev( chr_t *p )
{
	long	lev;
	long	i;

	if( p == NULL )
		return 1;

	lev = 0;
	for( i = 0; i < ABL_KIND_MAX_N; i++ )
		lev += p->abl.lev[i].n;
	lev /= ABL_KIND_MAX_N;

	if( lev < 1 )
		lev = 1;

	return lev;
}

/**/

long	get_specialist_lev( chr_t *p )
{
	long	lev;
	long	i;

	if( p == NULL )
		return 1;

	lev = 1;
	for( i = 0; i < ABL_KIND_MAX_N; i++ )
		lev = max( lev, p->abl.lev[i].n );

	return lev;
}

/**/

long	add_hp( chr_t *p, long n )
{
	if( p == NULL )
		return 0;

	if( p->kind == CHR_KIND_MBR )
		return add_hp_mbr( p, n );
	else if( p->kind == CHR_KIND_MNSTR )
		return add_hp_mnstr( p, n );

	return 0;
}

/**/

long	add_mp( chr_t *chr, long n )
{
	long	pre_mp, add;

	if( chr == NULL )
		return 0;

	pre_mp = chr->abl.mp.n;

	chr->abl.mp.n += n;
	if( chr->abl.mp.n > chr->abl.mp.max )
		chr->abl.mp.n = chr->abl.mp.max;
	if( chr->abl.mp.n < 0 )
		chr->abl.mp.n = 0;

	add = chr->abl.mp.n - pre_mp;
	if( add != 0 ){
		vfx_num( chr, add );
		draw_mbr_stat( chr );
	}

	return chr->abl.mp.n;
}

/**/

long	get_chr_gold( chr_t *chr )
{
	if( chr == NULL )
		return 0;

	return chr->gold;
}

/**/

long	add_chr_gold( chr_t *chr, long gold )
{
	if( chr == NULL )
		return 0;

	chr->gold += gold;
	return chr->gold;
}

/**/

square_t	*get_square( chr_t *chr )
{
	if( chr->kind == CHR_KIND_MBR ){
		return get_square_mbr();
	} else if( chr->kind == CHR_KIND_MNSTR ){
		return( &mnstr_square );
	}

	return NULL;
}

/**/

void	set_square( chr_t *chr, square_t *sq )
{
	if( chr->kind == CHR_KIND_MBR ){
		set_square_mbr( sq );
	} else if( chr->kind == CHR_KIND_MNSTR ){
		mnstr_square = *sq;
	}
}

/**/

char	*get_trgt_name( trgt_t *trgt )
{
	if( trgt == NULL )
		return MSG_MNSTR_UNKNOWN;
	if( trgt->p == NULL )
		return MSG_MNSTR_UNKNOWN;

	switch( trgt->kind ){
	case TRGT_KIND_NULL:
		return MSG_MNSTR_UNKNOWN;
	case TRGT_KIND_MBR:
		return ((mbr_t *)trgt->p)->name;
	case TRGT_KIND_MNSTR:
		return ((mnstr_t *)trgt->p)->name;
	case TRGT_KIND_MNSTR_NULL:
		return MSG_MNSTR_UNKNOWN;
	case TRGT_KIND_ITEM:
		return ((item_t *)trgt->p)->name;
	case TRGT_KIND_DOOR:
		return MSG_MENU_SEL_OBJ_DOOR;
	case TRGT_KIND_TRAP:
		return MSG_MENU_SEL_OBJ_TRAP;
	case TRGT_KIND_SQUARE:
		return MSG_MENU_SEL_OBJ_SQUARE;
	case TRGT_KIND_POS:
		return MSG_MNSTR_UNKNOWN;
	case TRGT_KIND_AUTO:
	case TRGT_KIND_MAX_N:
		return MSG_MNSTR_UNKNOWN;
	}

	return MSG_MNSTR_UNKNOWN;
}

/**/

bool_t	cmp_chr( chr_t *p1, chr_t *p2 )
{
	abl_kind_t	abl;
	resi_kind_t	resi;

	if( strcmp( p1->name, p2->name ) != 0 )
		return FALSE;
#if	0
	if( p1->mbr_n != p2->mbr_n )
		return FALSE;
	if( p1->ls_mbr_n != p2->ls_mbr_n )
		return FALSE;
#endif
	if( p1->face_mjr != p2->face_mjr )
		return FALSE;
	if( p1->face_mnr != p2->face_mnr )
		return FALSE;
	if( p1->race.main != p2->race.main )
		return FALSE;
	if( p1->race.sub != p2->race.sub )
		return FALSE;
	if( strcmp( p1->race.name, p2->race.name ) != 0 )
		return FALSE;
	if( p1->sex != p2->sex )
		return FALSE;
#if	0
	if( p1->x != p2->x )
		return FALSE;
	if( p1->y != p2->y )
		return FALSE;
	if( p1->pre_x != p2->pre_x )
		return FALSE;
	if( p1->pre_y != p2->pre_y )
		return FALSE;
#endif
	if( p1->gold != p2->gold )
		return FALSE;
	if( p1->max_dun_lev_floor != p2->max_dun_lev_floor )
		return FALSE;
	if( p1->max_dun_lev_base != p2->max_dun_lev_base )
		return FALSE;
#if	0
	if( p1->trgt != p2->trgt )
		return FALSE;
	if( p1->act != p2->act )
		return FALSE;
#endif
#if	0
	if( p1->auto_mark[] != p2->auto_mark[] )
		return FALSE;
#endif
	if( p1->flg_chr != p2->flg_chr )
		return FALSE;
	if( p1->stat != p2->stat )
		return FALSE;
	for( abl = 0; abl < ABL_KIND_MAX_N; abl++ ){
		if( p1->abl.exp[abl].n != p2->abl.exp[abl].n )
			return FALSE;
		if( p1->abl.exp[abl].max != p2->abl.exp[abl].max )
			return FALSE;
		if( p1->abl.lev[abl].n != p2->abl.lev[abl].n )
			return FALSE;
		if( p1->abl.lev[abl].max != p2->abl.lev[abl].max )
			return FALSE;
	}
	if( p1->abl.hp.n != p2->abl.hp.n )
		return FALSE;
	if( p1->abl.hp.max != p2->abl.hp.max )
		return FALSE;
	if( p1->abl.mp.n != p2->abl.mp.n )
		return FALSE;
	if( p1->abl.mp.max != p2->abl.mp.max )
		return FALSE;

	if( p1->class_n != p2->class_n )
		return FALSE;

	for( resi = 0; resi < RESI_KIND_MAX_N; resi++ ){
		if( p1->resi[resi].n != p2->resi[resi].n )
			return FALSE;
		if( p1->resi[resi].max != p2->resi[resi].max )
			return FALSE;
	}

#if	0
	if( p1->fx != p2->fx )
		return FALSE;
#endif

	if( p1->fx_data.infra_vision != p2->fx_data.infra_vision )
		return FALSE;

	if( p1->fx_data.stomach.rate != p2->fx_data.stomach.rate )
		return FALSE;
	if( p1->fx_data.stomach.full_rate
			!= p2->fx_data.stomach.full_rate )
		return FALSE;
	if( p1->fx_data.stomach.digest_p_day
			!= p2->fx_data.stomach.digest_p_day )
		return FALSE;
	if( p1->fx_data.stomach.hungry_rate
			!= p2->fx_data.stomach.hungry_rate )
		return FALSE;
	if( p1->fx_data.stomach.starvation_rate
			!= p2->fx_data.stomach.starvation_rate )
		return FALSE;

	if( p1->fx_data.drunk_rate != p2->fx_data.drunk_rate )
		return FALSE;

	if( p1->fx_data.nicotine.rate != p2->fx_data.nicotine.rate )
		return FALSE;
	if( p1->fx_data.nicotine.poisoning_rate
			!= p2->fx_data.nicotine.poisoning_rate )
		return FALSE;

	if( p1->fx_data.friend_turn != p2->fx_data.friend_turn )
		return FALSE;

	if( p1->work.caught != p2->work.caught )
		return FALSE;

	return TRUE;
}

/**/

bool_t	chr_roll(
	chr_t *chr, abl_kind_t abl_main, abl_kind_t abl_sub,
	long difficulty
)
{
	rate_t	rate_eq_main, rate_eq_sub, rate_eq;
	rate_t	rate_chr, rate_dif;
	long	dice_chr, dice_dif;

	rate_eq_main = calc_rate_abl_equip( chr, abl_main );
	rate_eq_sub = calc_rate_abl_equip( chr, abl_sub );
	rate_eq = (rate_eq_main + rate_eq_sub) / 2;
	if( rate_eq_main < _100_PERCENT ){
		print_msg_mbr( chr, FLG_NULL, MSG_DONT_EXHIBIT_ABL_EQUIP,
				chr->name, get_abl_name( abl_main ) );
	}
	if( rate_eq_sub < _100_PERCENT ){
		print_msg_mbr( chr, FLG_NULL, MSG_DONT_EXHIBIT_ABL_EQUIP,
				chr->name, get_abl_name( abl_sub ) );
	}

	rate_chr = chr->abl.lev[abl_main].n;
	rate_chr += chr->abl.lev[abl_sub].n;
	rate_chr = rate_chr * rate_eq / _100_PERCENT;
	rate_chr += ROLL_BASE * 2;
	if( rate_chr < 1 )
		rate_chr = 1;

	rate_dif = difficulty * 2;
	rate_dif += ROLL_BASE * 2;
	if( rate_dif < 1 )
		rate_dif = 1;

	dice_chr = roll_dice( rate_chr );
	dice_dif = roll_dice( rate_dif );

#ifndef	NDEBUG
	print_msg_mbr( chr, FLG_NULL, "chr roll rate %ld/%ld",
			rate_chr, rate_dif );
	print_msg_mbr( chr, FLG_NULL, "chr roll dice %ld/%ld",
			dice_chr, dice_dif );
#endif
	return( dice_dif <= dice_chr );
}

/**/

