/*#include	<stddef.h>*/
/*#include	<stdio.h>*/
/*#include	<string.h>*/
/*#include	<ctype.h>*/
/*#include	<time.h>*/
/*#include	<sys/stat.h>*/

#include	"gmain.h"
/*#include	"dun.h"*/
/*#include	"town.h"*/
#include	"item.h"
#include	"spell.h"
/*#include	"chr.h"*/
/*#include	"party.h"*/
/*#include	"mnstr.h"*/
#include	"fight.h"
/*#include	"fx.h"*/
/*#include	"trap.h"*/
#include	"draw.h"
/*#include	"curs.h"*/
/*#include	"menu.h"*/
/*#include	"msg.h"*/
/*#include	"ver.h"*/
#include	"gmain_prot.h"
#include	"dun_prot.h"
/*#include	"town_prot.h"*/
#include	"item_prot.h"
/*#include	"spell_prot.h"*/
#include	"chr_prot.h"
/*#include	"party_prot.h"*/
#include	"mnstr_prot.h"
#include	"fight_prot.h"
#include	"fx_prot.h"
#include	"trap_prot.h"
#include	"draw_prot.h"
/*#include	"curs_prot.h"*/
/*#include	"menu_prot.h"*/
/*#include	"tmenu_prot.h"*/
/*#include	"amenu_prot.h"*/
/*#include	"gfile_prot.h"*/
/*#include	"msg_prot.h"*/

/**/

/* ٥ɶζ */
#if	1

/* ٥뤬㤤ۤɶ */
/* ٥뤬夬о夬ۤɺ̵ʤ */
#define	D_ITEM_ADD_RATE

#else

/* ٥뤬㤤Ϻ̵ */
/* ٥뤬夬о夬ۤɶϤˤʤ */

#endif

#define	HIT_FIT_AVE_N	10
#define	HIT_HNT_AVE_N	10
#define	WPN_CRTCL_FIT_AVE_N	10
#define	WPN_CRTCL_HNT_AVE_N	10
#define	DAM_FIT_AVE_N	10
#define	DAM_HNT_AVE_N	10

#define	HIT_MON_MUL	10
#define	HIT_MON_ADD	0
#define	DAM_MON_MUL	10
#define	DAM_MON_ADD	0
#define	DEF_MON_MUL	10
#define	DEF_MON_ADD	0

#define	DEF_MIN_RATE	30
#define	DEF_AVE_N	10
#define	ARMOR_CRTCL_AVE_N	5
#define	AC_AVE_N	20

/* ɸ(⤷Ƥʤ)ɸϥåΨ */
#define	DEF_DEF_RATE	150
#define	DEF_AC_RATE	150

#define	DAM_WAND_MUL	2
#define	DAM_WAND_ADD	10

#define	DAM_SPELL_MUL	2
#define	DAM_SPELL_ADD	10

#define	DOOR_DEF	12
#define	TRAP_DEF	8
#define	ITEM_DEF	6

#define	TRAINING_EXP	1

#define	ANIM_ARW_LEN	(ANIM_FRAME_N / 4)
#define	MNSTR_THROW_MJR	'*'

/**/

attack_t	mbr_attack_bash[] = {
	{ ATTACK_KIND_PUNCH, 1, FALSE, TRUE, 10, 10, 10, RESI_KIND_KNOC },
	{ ATTACK_KIND_KICK, 1, FALSE, TRUE, 10, 10, 10, RESI_KIND_KNOC },
	{ ATTACK_KIND_NULL, 0, FALSE, FALSE, 0, 0, 0, RESI_KIND_MAX_N },
};

attack_t	mbr_attack_throw[] = {
	{ ATTACK_KIND_THROW, 1, TRUE, FALSE, 10, 10, 10, RESI_KIND_KNOC },
	{ ATTACK_KIND_NULL, 0, FALSE, FALSE, 0, 0, 0, RESI_KIND_MAX_N },
};

attack_t	mbr_attack_throw_light[] = {
	{ ATTACK_KIND_THROW, 1, TRUE, FALSE, 10, 10, 10, RESI_KIND_HEAT },
	{ ATTACK_KIND_NULL, 0, FALSE, FALSE, 0, 0, 0, RESI_KIND_MAX_N },
};

/**/

bool_t	bash( chr_t *chr, chr_t *chr2, attack_t *dflt_attack )
{
	attack_t	attack;

	if( chr == NULL )
		return FALSE;
	if( chr2 == NULL )
		return FALSE;

	if( dflt_attack == NULL ){
		if( !set_attack_chr_bash( &attack, chr, FALSE ) )
			return FALSE;
	} else {
		attack = *dflt_attack;
	}

	return fight( chr, chr2, &attack );
}

/**/

bool_t	set_attack_chr_bash( attack_t *attack, chr_t *chr, bool_t flg_ave )
{
	if( chr->kind == CHR_KIND_MBR )
		return set_attack_mbr_bash( attack, chr, flg_ave );
	if( chr->kind == CHR_KIND_MNSTR )
		return set_attack_mnstr_bash( attack, chr, flg_ave );

	return FALSE;
}

/**/

bool_t	set_attack_mbr_bash(
	attack_t *attack, mbr_t *mbr, bool_t flg_ave
)
{
	item_t	*eq;
	wpn_tab_t	*wpn_tab;
	attack_t	*p;

	if( attack == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( mbr->kind != CHR_KIND_MBR )
		return FALSE;

	/* Υơ֥ */
	eq = get_mbr_item_asgn_equip( mbr );
	if( eq == NULL )
		return FALSE;

	eq = &(eq[EQUIP_KIND_WIELDING]);
	if( eq->kind == ITEM_KIND_WPN ){
		wpn_tab = eq->tab.wpn;
		if( wpn_tab != NULL ){
			if( chk_flg( wpn_tab->flg_abl, FLG_ITEM_ABL_MON ) ){
				wpn_tab = NULL;
			}
		}
	} else {
		wpn_tab = NULL;
	}

	if( wpn_tab != NULL ){
		/* ξ */
		p = get_attack( flg_ave, wpn_tab->attack, FALSE, FALSE );
		if( p == NULL )
			return FALSE;
		*attack = *p;

		attack->hit += add_hit( eq->dat.wpn.add_hit );
		attack->crtcl += add_wpn_crtcl( eq->dat.wpn.add_crtcl );
		attack->dam += add_dam( eq->dat.wpn.add_dam );
	} else {
		/* Ǽξ */
		p = get_attack( flg_ave, mbr_attack_bash, FALSE, TRUE );
		if( p == NULL )
			return FALSE;
		*attack = *p;
	}

	return TRUE;
}

/**/

bool_t	set_attack_mnstr_bash(
	attack_t *attack, mnstr_t *mnstr, bool_t flg_ave
)
{
	attack_t	*p;

	if( attack == NULL )
		return FALSE;
	if( mnstr == NULL )
		return FALSE;
	if( mnstr->kind != CHR_KIND_MNSTR )
		return FALSE;

	if( mnstr->mnstr_tab == NULL )
		return FALSE;

	p = get_attack_randm( mnstr->mnstr_tab->attack );
	if( p == NULL )
		return FALSE;

	*attack = *p;

	return TRUE;
}

/**/

bool_t	throw( chr_t *chr1, chr_t *chr2, attack_t *dflt_attack )
{
	attack_t	attack;

	if( chr1 == NULL )
		return FALSE;
	if( chr2 == NULL )
		return FALSE;

	if( dflt_attack == NULL ){
		if( !set_attack_chr_throw( &attack, chr1, FALSE ) )
			return FALSE;
	} else {
		attack = *dflt_attack;
	}

	return fight( chr1, chr2, &attack );
}

/**/

bool_t	set_attack_chr_throw( attack_t *attack, chr_t *chr, bool_t flg_ave )
{
	if( chr->kind == CHR_KIND_MBR )
		return set_attack_mbr_throw( attack, chr, flg_ave );
	if( chr->kind == CHR_KIND_MNSTR )
		return set_attack_mnstr_throw( attack, chr, flg_ave );

	return FALSE;
}

/**/

bool_t	set_attack_mbr_throw(
	attack_t *attack, mbr_t *mbr, bool_t flg_ave
)
{
	item_t	*eq;
	wpn_tab_t	*bow_tab, *arw_tab;
	attack_t	*p;

	if( attack == NULL )
		return FALSE;
	if( mbr == NULL )
		return FALSE;
	if( mbr->kind != CHR_KIND_MBR )
		return FALSE;

	eq = get_mbr_item_asgn_equip( mbr );
	if( eq == NULL )
		return FALSE;

	/* check stick */

	if( eq[EQUIP_KIND_BOW].kind == ITEM_KIND_STICK ){
		if( zap_stick( mbr, &(eq[EQUIP_KIND_BOW]) ) )
			return TRUE;
		clr_chr_trgt_act( mbr, FALSE );
	}

	/* Υơ֥ */

	if( eq[EQUIP_KIND_BOW].kind == ITEM_KIND_WPN )
		bow_tab = eq[EQUIP_KIND_BOW].tab.wpn;
	else
		bow_tab = NULL;
	if( eq[EQUIP_KIND_ARW].kind == ITEM_KIND_WPN )
		arw_tab = eq[EQUIP_KIND_ARW].tab.wpn;
	else
		arw_tab = NULL;

	if( chk_dagger( arw_tab ) ){
		/* ξ */
		p = get_attack( flg_ave, arw_tab->attack, TRUE, FALSE );
		if( p == NULL )
			return FALSE;
		*attack = *p;

		attack->hit += add_hit( eq[EQUIP_KIND_ARW]
				.dat.wpn.add_hit );
		attack->crtcl += add_wpn_crtcl( eq[EQUIP_KIND_ARW]
				.dat.wpn.add_crtcl );
		attack->dam += add_dam( eq[EQUIP_KIND_ARW]
				.dat.wpn.add_dam );
	} else if( chk_bow( arw_tab, bow_tab ) ){
		attack_t	attack_bow, attack_arw;
		/* ݤʤɤξ */

		/* bow */
		p = get_attack( flg_ave, bow_tab->attack, TRUE, FALSE );
		if( p == NULL )
			return FALSE;
		attack_bow = *p;

		attack_bow.hit += add_hit( eq[EQUIP_KIND_BOW]
				.dat.wpn.add_hit );
		attack_bow.crtcl += add_wpn_crtcl( eq[EQUIP_KIND_BOW]
				.dat.wpn.add_crtcl );
		attack_bow.dam += add_dam( eq[EQUIP_KIND_BOW]
				.dat.wpn.add_dam );

		/* arrow */
		p = get_attack( flg_ave, arw_tab->attack, TRUE, FALSE );
		if( p == NULL )
			return FALSE;
		attack_arw = *p;

		attack_arw.hit += add_hit( eq[EQUIP_KIND_ARW]
				.dat.wpn.add_hit );
		attack_arw.crtcl += add_wpn_crtcl( eq[EQUIP_KIND_ARW]
				.dat.wpn.add_crtcl );
		attack_arw.dam += add_dam( eq[EQUIP_KIND_ARW]
				.dat.wpn.add_dam );

		/* sum */
		*attack = attack_bow;
		attack->hit += attack_arw.hit;
		attack->crtcl += attack_arw.crtcl;
		attack->dam += attack_arw.dam;
	} else {
		/* ¾Υƥξ */
		if( eq[EQUIP_KIND_ARW].kind == ITEM_KIND_LIGHT ){
			p = get_attack( flg_ave, mbr_attack_throw_light,
					TRUE, FALSE );
		} else {
			p = get_attack( flg_ave, mbr_attack_throw,
					TRUE, FALSE );
		}
		if( p == NULL )
			return FALSE;
		*attack = *p;
	}

	return TRUE;
}

/**/

bool_t	set_attack_mnstr_throw(
	attack_t *attack, mnstr_t *mnstr, bool_t flg_ave
)
{
	attack_t	*p;

	if( attack == NULL )
		return FALSE;
	if( mnstr == NULL )
		return FALSE;
	if( mnstr->kind != CHR_KIND_MNSTR )
		return FALSE;

	if( mnstr->mnstr_tab == NULL )
		return FALSE;

	p = get_attack_randm( mnstr->mnstr_tab->attack );
	if( p == NULL )
		return FALSE;

	*attack = *p;

	return TRUE;
}

/**/

bool_t	chk_dagger( const wpn_tab_t *arw_tab )
{
	if( arw_tab == NULL )
		return FALSE;
	if( arw_tab->bow_kind != BOW_KIND_DAGGER )
		return FALSE;
	if( !chk_flg( arw_tab->flg, FLG_WPN_TAB_ARW ) )
		return FALSE;

	return TRUE;
}

/**/

bool_t	chk_bow( const wpn_tab_t *arw_tab, const wpn_tab_t *bow_tab )
{
	if( arw_tab == NULL )
		return FALSE;
	if( bow_tab == NULL )
		return FALSE;
	if( arw_tab->bow_kind != bow_tab->bow_kind )
		return FALSE;
	if( !chk_flg( bow_tab->flg, FLG_WPN_TAB_BOW ) )
		return FALSE;
	if( !chk_flg( arw_tab->flg, FLG_WPN_TAB_ARW ) )
		return FALSE;

	return TRUE;
}

/**/

attack_t	*get_attack(
	bool_t flg_ave, attack_t *ls, bool_t flg_throw, bool_t flg_monk
)
{
	if( flg_ave )
		return get_attack_ave( ls, flg_throw, flg_monk );
	else
		return get_attack_randm( ls );
}

/**/

attack_t	*get_attack_ave(
	attack_t *ls, bool_t flg_throw, bool_t flg_monk
)
{
	long	i;
	ratio_t	sum;
	static attack_t	ave;

	if( ls == NULL )
		return NULL;

	ave.kind = ATTACK_KIND_NULL;
	ave.ratio = 1;
	ave.resi_kind = RESI_KIND_MAX_N;
	ave.flg_throw = flg_throw;
	ave.flg_monk = flg_monk;
	ave.hit = 0;
	ave.crtcl = 0;
	ave.dam = 0;

	sum = 0;
	for( i = 0; i < 1024; i++ ){
		ratio_t	n;

		if( ls[i].kind == ATTACK_KIND_NULL )
			break;
		if( ls[i].flg_throw != flg_throw )
			continue;
		if( ls[i].flg_monk != flg_monk )
			continue;

		n = ls[i].ratio;
		sum += n;
		ave.hit += ls[i].hit * n;
		ave.crtcl += ls[i].crtcl * n;
		ave.dam += ls[i].dam * n;
	}

	if( sum <= 0 )
		return NULL;

	ave.hit /= sum;
	ave.crtcl /= sum;
	ave.dam /= sum;

	return &ave;
}

/**/

attack_t	*get_attack_randm( attack_t *ls )
{
	long	i;
	ratio_t	n, sum;

	if( ls == NULL )
		return NULL;

	sum = 0;
	for( i = 0; i < 1024; i++ ){
		if( ls[i].kind == ATTACK_KIND_NULL )
			break;
		sum += ls[i].ratio;
	}

	if( sum <= 0 )
		return NULL;

	n = randm( sum );

	sum = 0;
	for( i = 0; i < 1024; i++ ){
		if( ls[i].kind == ATTACK_KIND_NULL )
			break;
		sum += ls[i].ratio;
		if( n < sum )
			return( &(ls[i]) );
	}

	return NULL;
}

/**/

bool_t	fight( chr_t *o_p, chr_t *d_p, const attack_t *attack )
{
	chr_kind_t	o_k, d_k;
	long	o_hit, o_dam;
	char	*o_name, *d_name;
	long	d_def, d_ac;
	rate_t	d_resi;
	abl_val_t	*d_hp;
	fx_t	*d_fx;
	long	d_x, d_y;
	flg_stat_t	stat;
	item_t	*eq;
	pos_t	bgn, end;
	bool_t	flg_crtcl;
	bool_t	flg_d_null;
	bool_t	flg_auto_hit;
	bool_t	flg_serious;
	char	mjr;
	curs_attr_n_t	attr_err = CURS_ATTR_N_ERR;
	curs_attr_n_t	attr_dam, attr_crtcl;

	if( o_p == NULL )
		return FALSE;
	else
		o_k = o_p->kind;

	if( d_p == NULL )
		d_k = CHR_KIND_MNSTR;
	else
		d_k = d_p->kind;

	flg_d_null = FALSE;
	if( d_p == NULL ){
		flg_d_null = TRUE;
	} else {
		if( d_k == CHR_KIND_MNSTR )
			if( ((mnstr_t *)d_p)->mnstr_tab == NULL )
				flg_d_null = TRUE;
	}
	if( o_p->kind == CHR_KIND_MBR )
		if( ((mbr_t *)o_p)->trgt.kind == TRGT_KIND_MNSTR_NULL )
			flg_d_null = TRUE;

	if( (o_p->kind != CHR_KIND_MBR) || (d_p->kind != CHR_KIND_MBR) )
		flg_serious = TRUE;
	else
		flg_serious = FALSE;

	if( d_k == CHR_KIND_MBR ){
		attr_dam = CURS_ATTR_N_FX_MBR_MINUS;
		attr_crtcl = CURS_ATTR_N_FX_MBR_CRTCL;
	} else {
		attr_dam = CURS_ATTR_N_FX_MNSTR_MINUS;
		attr_crtcl = CURS_ATTR_N_FX_MNSTR_CRTCL;
	}

	/* ¦̾μ */

	o_name = o_p->name;

	/* ɸ¦̾ȥǡμ */

	if( flg_d_null ){
		d_name = MSG_NULL;

		d_hp = NULL;
		d_fx = NULL;
		d_x = 0;
		d_y = 0;
	} else {
		d_name = d_p->name;

		d_hp = &(d_p->abl.hp);
		d_fx = &(d_p->fx);
		d_x = d_p->x;
		d_y = d_p->y;
	}

	eq = NULL;
	if( attack->flg_throw && (o_k == CHR_KIND_MBR) ){
		eq = get_mbr_item_asgn_equip( (mbr_t *)o_p );
		if( eq[EQUIP_KIND_ARW].kind == ITEM_KIND_NULL ){
			print_msg( attr_err, FLG_NULL,
					MSG_ERR_THROW, o_name );
			clr_chr_trgt_act( (mbr_t *)o_p, TRUE );

			return FALSE;
		}
	}

	/* ¦廊뤫 */

	if( o_k == CHR_KIND_MBR )
		stat = ((mbr_t *)o_p)->stat;
	else
		stat = ((mnstr_t *)o_p)->stat;
	if( chk_flg_or( stat, FLG_STAT_NOT_EXIST
			| FLG_STAT_DEAD
			| FLG_STAT_STONE
			| FLG_STAT_PARALYZE
			| FLG_STAT_CONFUSION
			| FLG_STAT_SLEEP
			| FLG_STAT_FAINT ) ){
		return FALSE;
	}

	/* ɸ¦廊뤫 */

	if( d_k == CHR_KIND_MBR )
		stat = ((mbr_t *)d_p)->stat;
	else if( flg_d_null )
		stat = FLG_NULL;
	else
		stat = ((mnstr_t *)d_p)->stat;
	if( chk_flg_or( stat, FLG_STAT_NOT_EXIST
			| FLG_STAT_STONE
			| FLG_STAT_DEAD ) ){
		return FALSE;
	}
	if( chk_flg_or( stat, FLG_STAT_PARALYZE
			| FLG_STAT_CONFUSION
			| FLG_STAT_BLIND
			| FLG_STAT_SLEEP
			| FLG_STAT_FAINT ) ){
		flg_auto_hit = TRUE;
	} else {
		flg_auto_hit = FALSE;
	}

	/* ꤬Ƥ뤫 */

	if( !flg_d_null ){
		pos_t	pos1, pos2;

		if( o_k == CHR_KIND_MBR ){
			pos1.x = o_p->x;
			pos1.y = o_p->y;
			pos2.x = d_p->x;
			pos2.y = d_p->y;
			if( !chk_find( &pos1, &pos2 ) ){
				print_msg_n( attr_err, FLG_NULL,
						MSG_ERR_NOT_FIND,
						o_name, d_name );
				return FALSE;
			}
		} else {
			if( !chk_find_mnstr( d_p, o_p ) )
				return FALSE;
		}
	}

	print_msg( FLG_NULL, get_msg_attack( attack ), o_name, d_name );

	bgn.x = o_p->x;
	bgn.y = o_p->y;
	end.x = o_p->trgt.true_x;
	end.y = o_p->trgt.true_y;

	mjr = MNSTR_THROW_MJR;
	if( attack->flg_throw ){
		/* ꤲʪ */
		if( (o_k == CHR_KIND_MBR) && (eq != NULL) )
			mjr = get_item_mjr( &(eq[EQUIP_KIND_ARW]) );
		vfx_arw( o_k, &bgn, &end, mjr, ANIM_ARW_LEN );
	}

	/* ɸ¦Υǡ */

	if( flg_d_null ){
		d_def = 0;
		d_ac = 0;
		d_resi = _100_PERCENT;
	} else {
		d_def = get_def( d_p );
		d_def = roll_dice( d_def );
		d_ac = get_ac( d_p );
		if( d_k == CHR_KIND_MBR ){
			if( ((mbr_t *)d_p)->act.kind == ACT_KIND_NULL ){
				/* ⤷Ƥʤɸ */
				d_def *= DEF_DEF_RATE;
				d_def /= _100_PERCENT;
				d_ac *= DEF_AC_RATE;
				d_ac /= _100_PERCENT;
			}
		}
		d_resi = get_resi( d_p, attack->resi_kind );
	}
	if( flg_auto_hit )
		d_def = 0;

	/* ¦Υǡ */

	o_hit = get_hit( o_p, attack );
	o_hit = roll_dice( o_hit );
	o_dam = get_dam( o_p, attack );
	flg_crtcl = rate_randm( get_crtcl( o_p, d_p, attack ) );

	if( !flg_d_null ){
		o_dam = roll_dice( o_dam );
		o_dam = calc_resi( d_resi, o_dam );
		o_dam -= d_ac;
	}
	if( o_dam <= 0 )
		o_dam = 1;
	if( flg_crtcl ){
		o_dam *= 2;
		print_msg_n( attr_crtcl, FLG_NULL,
				MSG_FIGHT_CRTCL_STD, o_name );
		vfx_crtcl( d_k, end.x, end.y );
	}

	if( chk_slayer( o_p, d_p, attack->flg_throw ) ){
		o_hit *= 2;
		o_dam *= 2;
	}


	/* ʤ */

	if( flg_d_null || (!flg_crtcl && (d_def > o_hit)) ){
		if( flg_d_null )
			print_msg( FLG_NULL, MSG_ERR_MNSTR_NULL );
		else
			print_msg( FLG_NULL, MSG_FIGHT_MISS_STD,
					o_name, d_name );

		if( o_k != CHR_KIND_MBR )
			return TRUE;
		if( eq == NULL )
			return TRUE;
		if( !attack->flg_throw )
			return TRUE;

		/* ֹν */

		if( chk_come_back_arw( (mbr_t *)o_p ) ){
			/* ֡Τ褦äƤ */
			vfx_arw( o_k, &end, &bgn, mjr, ANIM_ARW_LEN );
		} else {
			/*  */
			dec_throw( (mbr_t *)o_p, TRUE, d_x, d_y );
		}

		return TRUE;
	}

	/* ⤬ä */

	/* ݡä */

	if( (eq != NULL) && (eq[EQUIP_KIND_ARW].kind == ITEM_KIND_POTION) ){
		o_dam = 0;

		if( d_k == CHR_KIND_MBR ){
			quaff_potion( (mbr_t *)d_p,
					&(eq[EQUIP_KIND_ARW]), FALSE );
		}
		if( d_k == CHR_KIND_MNSTR ){
			quaff_potion_mnstr( (mnstr_t *)d_p,
					&(eq[EQUIP_KIND_ARW]), FALSE );
		}
	}

	/* ᡼ɽ */

	if( o_dam != 0 ){
		print_msg_n( attr_dam, FLG_NULL, MSG_FIGHT_HIT_STD,
				o_name, d_name, o_dam );
	}

	/* ܤФ */

	if( d_fx != NULL ){
		fx_t	*fx;

		fx = srch_fx( d_fx, FX_KIND_SLEEP );
		clr_fx( fx );
	}

	/*  */

	do {
		abl_kind_t	o_abl, d_abl;
		long	o_lev, d_lev;

		if( flg_serious )
			break;
		if( o_dam <= 0 )
			break;

		if( attack->flg_throw )
			o_abl = ABL_KIND_HUN;
		else if( attack->flg_monk )
			o_abl = ABL_KIND_MON;
		else
			o_abl = ABL_KIND_FIG;
		o_lev = ((mbr_t *)o_p)->abl.lev[o_abl].n;

		d_abl = get_def_abl( d_p );
		d_lev = ((mbr_t *)d_p)->abl.lev[d_abl].n;

		if( o_lev >= d_lev )
			break;

		exp_chr( (mbr_t *)o_p, TRAINING_EXP, TRUE );
	} while( 0 );

	/* HP򸺤餹 */

	if( !flg_serious && (o_dam > d_p->abl.hp.n - 1) )
			o_dam = d_p->abl.hp.n - 1;
	add_hp( d_p, -o_dam );

	if( (d_hp != NULL) && (d_hp->n <= 0) ){
		/*  */

		print_msg_n( attr_crtcl, FLG_NULL, MSG_FIGHT_KILL_STD,
				o_name, d_name );
	}

	/* 񤹤 */

	if( attack->flg_throw && (eq != NULL) && (o_k == CHR_KIND_MBR) ){
		if( (eq[EQUIP_KIND_ARW].kind == ITEM_KIND_WPN)
				&& chk_flg( eq[EQUIP_KIND_ARW].dat.wpn.flg,
				FLG_WPN_TAB_NOT_SPEND ) ){
			/* 񤻤 */
			dec_throw( (mbr_t *)o_p, TRUE, d_x, d_y );
		} else {
			dec_throw( (mbr_t *)o_p, FALSE, d_x, d_y );
		}
	}

	return TRUE;
}

/**/

bool_t	zap_wand_mbr_attack( mbr_t *mbr, resi_kind_t resi )
{
	if( mbr == NULL )
		return FALSE;

	switch( mbr->trgt.kind ){
	case TRGT_KIND_MBR:
	case TRGT_KIND_MNSTR:
	case TRGT_KIND_MNSTR_NULL:
		break;
	default:
		return FALSE;
	}

	return( spell_attack( mbr, mbr->trgt.p,
			resi, TRUE, ABL_KIND_MAX_N, _100_PERCENT ) );
}

/**/

bool_t	spell_attack(
	chr_t *o_p, chr_t *d_p,
	resi_kind_t resi, bool_t flg_stick,
	abl_kind_t abl, rate_t rate
)
{
	flg_stat_t	o_stat;
	pos_t	o_pos, d_pos;
	char	*o_name, *d_name;
	long	dam;
	long	ac;
	bool_t	flg_serious;
	curs_attr_n_t	attr_dam, attr_crtcl;
	fx_t	*fx;

	if( o_p == NULL )
		return FALSE;
	if( d_p == NULL ){
		print_msg( FLG_NULL, MSG_ERR_MNSTR_NULL );
		if( o_p->kind == CHR_KIND_MBR )
			clr_chr_trgt_act( (mbr_t *)o_p, FALSE );
		return FALSE;
	}

	if( o_p->kind != CHR_KIND_MBR )
		flg_serious = TRUE;
	else if( d_p->kind != CHR_KIND_MBR )
		flg_serious = TRUE;
	else
		flg_serious = FALSE;

	/* ¦ǡ */

	o_stat = o_p->stat;
	o_pos.x = o_p->x;
	o_pos.y = o_p->y;
	o_name = o_p->name;

	/* ɸ¦ǡ */

	d_pos.x = d_p->x;
	d_pos.y = d_p->y;
	d_name = d_p->name;

	if( d_p->kind == CHR_KIND_MBR ){
		attr_dam = CURS_ATTR_N_FX_MBR_MINUS;
		attr_crtcl = CURS_ATTR_N_FX_MBR_CRTCL;
	} else if( d_p->kind == CHR_KIND_MNSTR ){
		attr_dam = CURS_ATTR_N_FX_MNSTR_MINUS;
		attr_crtcl = CURS_ATTR_N_FX_MNSTR_CRTCL;
	} else {
		attr_dam = CURS_ATTR_N_NORMAL;
		attr_crtcl = CURS_ATTR_N_NORMAL;
	}

	/* Ǥ뤫 */

	if( chk_flg_or( o_stat, FLG_STAT_NOT_EXIST
			| FLG_STAT_DEAD
			| FLG_STAT_STONE
			| FLG_STAT_PARALYZE
			| FLG_STAT_CONFUSION
			| FLG_STAT_SLEEP
			| FLG_STAT_FAINT ) ){
		return FALSE;
	}

	/* Ƥ뤫 */

	if( !chk_find( &o_pos, &d_pos ) ){
		print_msg( FLG_NULL, MSG_ERR_NOT_FIND, o_name, d_name );
		return FALSE;
	}

	/* ᡼ */

	if( flg_stick )
		dam = get_dam_wand( o_p );
	else
		dam = get_dam_spell( o_p, abl );
	dam = dam * rate / _100_PERCENT;
	dam = roll_dice( dam );

	/* ޡ饹 */

	ac = get_ac( d_p );

	/* и */

	if( flg_stick ){
		char	mjr = '*';

		vfx_arw( o_p->kind, &o_pos, &d_pos, mjr, ANIM_ARW_LEN );
	}

	/* ܤФ */

	fx = srch_fx( &(d_p->fx), FX_KIND_SLEEP );
	clr_fx( fx );

	/* HP򸺤餹 */

	dam = calc_resi( d_p->resi[resi].n, dam );
	dam -= ac;
	if( dam <= 0 )
		dam = 1;

	if( dam != 0 ){
		/* ᡼ɽ */
		print_msg_n( attr_dam, FLG_NULL, MSG_FIGHT_HIT_STD,
				o_name, d_name, dam );
	}

	if( !flg_serious && (dam > d_p->abl.hp.n - 1) )
			dam = d_p->abl.hp.n - 1;
	add_hp( d_p, -dam );

	/*  */

	if( d_p->abl.hp.n <= 0 ){
		print_msg_n( attr_crtcl, FLG_NULL,
				MSG_FIGHT_KILL_STD,
				o_name, d_name );
	}

	return TRUE;
}

/**/

bool_t	chr_break_door( chr_t *chr, long dr_n )
{
	long	hit;
	dun_t	*dun;
	attack_t	attack;

	dun = get_dun();

	if( chr == NULL )
		return FALSE;

	if( chk_flg( dun->door[dr_n].flg, FLG_DOOR_SHOP ) ){
		print_msg( FLG_NULL, MSG_ERR_DOOR_BREAK_SHOP );
		return TRUE;
	}
	if( chk_flg( dun->door[dr_n].flg, FLG_DOOR_BROKEN ) ){
		print_msg( FLG_NULL, MSG_ERR_DOOR_BREAK_BROKEN );
		return TRUE;
	}

	if( set_attack_chr_bash( &attack, chr, FALSE ) )
		hit = get_hit( chr, &attack );
	else
		hit = get_hit( chr, NULL );
	hit = roll_dice( hit );

	if( DOOR_DEF > hit ){
		print_msg( FLG_NULL, MSG_ERR_DOOR_BREAK_LEV );
		return FALSE;
	}

	dun->door[dr_n].flg |= FLG_DOOR_BROKEN | FLG_DOOR_OPEN;
	set_face_door( dr_n );
	draw_door( dr_n );

	print_msg( FLG_NULL, MSG_DOOR_BREAK, chr->name );

	return TRUE;
}

/**/

bool_t	chr_break_trap( chr_t *chr, trap_t *trap )
{
	long	hit;
	attack_t	attack;

	if( chr == NULL )
		return FALSE;

	if( set_attack_chr_bash( &attack, chr, FALSE ) )
		hit = get_hit( chr, &attack );
	else
		hit = get_hit( chr, NULL );
	hit = roll_dice( hit );

	if( TRAP_DEF > hit ){
		print_msg( FLG_NULL, MSG_ERR_TRAP_BREAK_LEV );
		caught_trap( trap, chr );
	} else {
		print_msg( FLG_NULL, MSG_TRAP_BREAK, chr->name );
		caught_trap( trap, chr );
		free_trap( trap );
	}

	return TRUE;
}

/**/

bool_t	chr_break_item( chr_t *chr, item_t *item )
{
	long	hit;
	attack_t	attack;

	if( chr == NULL )
		return FALSE;
	if( item == NULL )
		return FALSE;

	if( item->kind == ITEM_KIND_JUNK ){
		print_msg( FLG_NULL, MSG_ERR_ITEM_BREAK_BROKEN, item->name );
		return TRUE;
	}


	if( set_attack_chr_bash( &attack, chr, FALSE ) )
		hit = get_hit( chr, &attack );
	else
		hit = get_hit( chr, NULL );
	hit = roll_dice( hit );

	if( ITEM_DEF > hit ){
		print_msg( FLG_NULL, MSG_ERR_ITEM_BREAK_LEV, item->name );
		return FALSE;
	}


	print_msg( FLG_NULL, MSG_ITEM_BREAK, chr->name, item->name );

	break_item_contents( item, chr );
	break_item( item, TRUE );

	draw_item( item );

	return TRUE;
}

/**/

bool_t	chk_slayer( chr_t *o_p, chr_t *d_p, bool_t flg_throw )
{
	item_t	*eq;

	if( o_p == NULL )
		return FALSE;
	if( d_p == NULL )
		return FALSE;

	if( o_p->kind != CHR_KIND_MBR )
		return FALSE;

	eq = get_mbr_item_asgn_equip( (mbr_t *)o_p );

	if( flg_throw ){
		if( eq[EQUIP_KIND_ARW].kind != ITEM_KIND_WPN )
			return FALSE;
		if( eq[EQUIP_KIND_ARW].dat.wpn.slayer == d_p->face_mjr )
			return TRUE;

		if( eq[EQUIP_KIND_BOW].kind != ITEM_KIND_WPN )
			return FALSE;
		if( eq[EQUIP_KIND_BOW].dat.wpn.slayer == d_p->face_mjr )
			return TRUE;
	} else {
		if( eq[EQUIP_KIND_WIELDING].kind != ITEM_KIND_WPN )
			return FALSE;
		if( eq[EQUIP_KIND_WIELDING].dat.wpn.slayer
				== d_p->face_mjr )
			return TRUE;
	}

	return FALSE;
}

/**/

long	get_hit( chr_t *p, const attack_t *attack )
{
	long	hit, wpn_hit;
	abl_kind_t	abl;

	if( p == NULL )
		return 1;
	if( attack == NULL )
		return 1;

	/* ǽ */

	hit = 0;
	wpn_hit = attack->hit;

	if( attack->flg_throw )
		abl = ABL_KIND_HUN;
	else if( attack->flg_monk )
		abl = ABL_KIND_MON;
	else
		abl = ABL_KIND_FIG;

	hit += calc_lev_to_val( p->abl.lev[ABL_KIND_DEX].n,
			ABL_KIND_DEX );
	hit += calc_lev_to_val( p->abl.lev[abl].n, abl );

	if( abl == ABL_KIND_MON ){
		long	n;
		rate_t	rate;

		n = p->abl.lev[abl].n;
		wpn_hit += HIT_MON_MUL * n;
		if( n > 0 )
			wpn_hit += HIT_MON_ADD;

		if( p->kind == CHR_KIND_MBR ){
			rate = calc_rate_abl_equip( p, ABL_KIND_MON );
			hit = hit * rate / _100_PERCENT;
		}
	}

#ifdef	D_ITEM_ADD_RATE

	hit += HIT_FIT_AVE_N * wpn_hit / _100_PERCENT;

#else	/* D_ITEM_ADD_RATE */

	hit = hit * wpn_hit / _100_PERCENT;

#endif	/* D_ITEM_ADD_RATE */

	if( hit < 1 )
		hit = 1;

	return hit;
}

/**/

long	get_dam( chr_t *p, const attack_t *attack )
{
	long	dam, wpn_dam;
	abl_kind_t	abl;

	if( p == NULL )
		return 1;
	if( attack == NULL )
		return 1;

	/* ǽ */

	dam = 0;
	wpn_dam = attack->dam;

	if( attack->flg_throw )
		abl = ABL_KIND_HUN;
	else if( attack->flg_monk )
		abl = ABL_KIND_MON;
	else
		abl = ABL_KIND_FIG;

	dam += calc_lev_to_val( p->abl.lev[ABL_KIND_STR].n,
			ABL_KIND_STR );
	dam += calc_lev_to_val( p->abl.lev[abl].n, abl );

	if( abl == ABL_KIND_MON ){
		long	n;
		rate_t	rate;

		n = p->abl.lev[abl].n;
		wpn_dam += DAM_MON_MUL * n;
		if( n > 0 )
			wpn_dam += DAM_MON_ADD;

		if( p->kind == CHR_KIND_MBR ){
			rate = calc_rate_abl_equip( p, ABL_KIND_MON );
			dam = dam * rate / _100_PERCENT;
		}
	}

#ifdef	D_ITEM_ADD_RATE

	dam += DAM_FIT_AVE_N * wpn_dam / _100_PERCENT;

#else	/* D_ITEM_ADD_RATE */

	dam = dam * wpn_dam / _100_PERCENT;

#endif	/* D_ITEM_ADD_RATE */

	if( dam < 1 )
		dam = 1;

	return dam;
}

/**/

long	get_def( chr_t *p )
{
	long	def;
	rate_t	armor_def;
	abl_kind_t	abl;
	rate_t	rate;

	if( p == NULL )
		return 1;

	/* ǽ */

	def = 0;
	abl = get_def_abl( p );

	def += calc_lev_to_val( p->abl.lev[ABL_KIND_AGI].n,
			ABL_KIND_AGI );
	def += calc_lev_to_val( p->abl.lev[abl].n, abl );

	if( p->kind == CHR_KIND_MBR ){
		rate = calc_rate_abl_equip( p, abl );
		def = def * rate / _100_PERCENT;
	}

	armor_def = get_armor_def( p, abl );

	if( armor_def < DEF_MIN_RATE )
		armor_def = DEF_MIN_RATE;

#ifdef	D_ITEM_ADD_RATE
	def += DEF_AVE_N * armor_def / _100_PERCENT;
#else	/* D_ITEM_ADD_RATE */
	def = def * armor_def / _100_PERCENT;
#endif	/* D_ITEM_ADD_RATE */

	if( def < 1 )
		def = 1;

	return def;
}

/**/

abl_kind_t	get_def_abl( chr_t *p )
{
	if( p == NULL )
		return ABL_KIND_FIG;

	if( p->kind == CHR_KIND_MBR ){
		item_t	*eq;
		flg_item_abl	flg_abl;

		eq = get_mbr_item_asgn_equip( (mbr_t *)p );
		if( eq == NULL )
			return ABL_KIND_FIG;

		if( eq[EQUIP_KIND_WIELDING].kind != ITEM_KIND_WPN )
			return ABL_KIND_MON;

		if( eq[EQUIP_KIND_WIELDING].tab.wpn == NULL )
			return ABL_KIND_MON;
		flg_abl = eq[EQUIP_KIND_WIELDING].tab.wpn->flg_abl;
		if( chk_flg( flg_abl, FLG_ITEM_ABL_MON ) )
			return ABL_KIND_MON;
		else
			return ABL_KIND_FIG;
	} else {
		return ABL_KIND_FIG;
	}

	return ABL_KIND_FIG;
}

/**/

long	get_armor_def( chr_t *p, abl_kind_t abl )
{
	long	armor_def;

	if( abl == ABL_KIND_MON ){
		long	n;

		n = ((mbr_t*)p)->abl.lev[abl].n;
		armor_def = DEF_MON_MUL * n;
		if( n > 0 )
			armor_def += DEF_MON_ADD;

		return armor_def;
	}

	armor_def = 0;

	if( p->kind == CHR_KIND_MBR ){
		item_t	*eq;
		equip_kind_t	n;

		/* ɶΥơ֥ */
		eq = get_mbr_item_asgn_equip( (mbr_t *)p );
		if( eq == NULL )
			return 1;

		/* ɶͤä */
		for( n = 0; n < EQUIP_KIND_MAX_N; n++ ){
			if( eq[n].kind != ITEM_KIND_ARMOR )
				continue;

			armor_def += eq[n].dat.armor.def;
			armor_def += add_def( eq[n].dat.armor.add_def );
		}
	} else if( p->kind == CHR_KIND_MNSTR ){
		/* ɶͤä */
		armor_def += p->mnstr_tab->def;
	}

	return armor_def;
}

/**/

long	get_ac( chr_t *p )
{
	long	ac;
	rate_t	armor_ac;

	if( p == NULL )
		return 1;

	ac = 0;
	armor_ac = 0;

	if( p->kind == CHR_KIND_MBR ){
		item_t	*eq;
		equip_kind_t	n;

		/* ɶΥơ֥ */
		eq = get_mbr_item_asgn_equip( (mbr_t *)p );
		if( eq == NULL )
			return 0;

		/* ɶͤä */
		for( n = 0; n < EQUIP_KIND_MAX_N; n++ ){
			if( eq[n].kind != ITEM_KIND_ARMOR )
				continue;

			armor_ac += eq[n].dat.armor.ac;
			armor_ac += add_ac( eq[n].dat.armor.add_ac );
		}
	} else if( p->kind == CHR_KIND_MNSTR ){
		/* ɶͤä */
		armor_ac += p->mnstr_tab->ac;
	}

	ac = AC_AVE_N * armor_ac / _100_PERCENT;

	if( ac < 1 )
		ac = 1;

	return ac;
}

/**/

rate_t	get_crtcl( chr_t *o_p, chr_t *d_p, const attack_t *attack )
{
	rate_t	rate;

	rate = get_wpn_crtcl( o_p, attack );
	rate -= get_armor_crtcl( d_p );

	if( rate < 1 )
		rate = 1;

	return rate;
}

/**/

rate_t	get_wpn_crtcl( chr_t *p, const attack_t *attack )
{
	long	thf;
	rate_t	crtcl;

	if( p == NULL )
		return 1;
	if( attack == NULL )
		return 1;

	/* ǽ */

	thf = calc_lev_to_val( p->abl.lev[ABL_KIND_THI].n, ABL_KIND_THI );
	crtcl = thf / 2;

#ifdef	D_ITEM_ADD_RATE

	crtcl += WPN_CRTCL_FIT_AVE_N * attack->crtcl / _100_PERCENT;

#else	/* D_ITEM_ADD_RATE */

	crtcl += WPN_CRTCL_FIT_AVE_N;
	crtcl = crtcl * attack->crtcl / _100_PERCENT;

#endif	/* D_ITEM_ADD_RATE */

	if( crtcl < 1 )
		crtcl = 1;

	return crtcl;
}

/**/

rate_t	get_armor_crtcl( chr_t *p )
{
	rate_t	crtcl;
	rate_t	armor_crtcl;

	if( p == NULL )
		return 1;

	crtcl = 0;
	armor_crtcl = 0;

	if( p->kind == CHR_KIND_MBR ){
		item_t	*eq;
		equip_kind_t	n;

		/* ɶΥơ֥ */
		eq = get_mbr_item_asgn_equip( (mbr_t *)p );
		if( eq == NULL )
			return 0;

		/* ɶͤä */
		for( n = 0; n < EQUIP_KIND_MAX_N; n++ ){
			if( eq[n].kind != ITEM_KIND_ARMOR )
				continue;

			armor_crtcl += eq[n].dat.armor.crtcl;
			armor_crtcl += add_armor_crtcl(
					eq[n].dat.armor.add_crtcl );
		}
	} else if( p->kind == CHR_KIND_MNSTR ){
		/* ɶͤä */
		armor_crtcl += p->mnstr_tab->armor_crtcl;
	}

	crtcl = ARMOR_CRTCL_AVE_N * armor_crtcl / _100_PERCENT;

	if( crtcl < 1 )
		crtcl = 1;

	return crtcl;
}

/**/

long	get_dam_wand( chr_t *p )
{
	long	dam;

	if( p == NULL )
		return 1;

	dam = get_specialist_lev( p );
	dam *= 2;

	dam *= DAM_WAND_MUL;
	dam += DAM_WAND_ADD;

	if( dam < 1 )
		dam = 1;

	return dam;
}

/**/

long	get_dam_spell( chr_t *p, abl_kind_t abl )
{
	abl_kind_t	sub_abl;
	long	dam;

	if( p == NULL )
		return 1;

	switch( abl ){
	case ABL_KIND_MAG:
		sub_abl = ABL_KIND_INT;
		break;
	case ABL_KIND_SOR:
		sub_abl = ABL_KIND_INT;
		break;
	case ABL_KIND_ENC:
		sub_abl = ABL_KIND_INT;
		break;
	case ABL_KIND_SUM:
		sub_abl = ABL_KIND_INT;
		break;
	case ABL_KIND_PRI:
		sub_abl = ABL_KIND_WIS;
		break;
	case ABL_KIND_SHA:
		sub_abl = ABL_KIND_CHA;
		break;
	case ABL_KIND_BAR:
		sub_abl = ABL_KIND_CHA;
		break;
	case ABL_KIND_NIN:
		sub_abl = ABL_KIND_NIN;
		break;
	default:
		return 1;
	}

	dam = p->abl.lev[abl].n;
	dam += p->abl.lev[sub_abl].n;
	dam *= DAM_SPELL_MUL;
	dam += DAM_SPELL_ADD;

	if( dam < 1 )
		dam = 1;

	return dam;
}

/**/

rate_t	get_resi( chr_t *p, resi_kind_t resi )
{
	rate_t	n;

	if( p == NULL )
		return _100_PERCENT;

	n = p->resi[resi].n;
	n = n * get_resi_armor( p, resi ) / _100_PERCENT;

	if( n < 1)
		n = 1;

	return n;
}

/**/

char	*get_msg_attack( const attack_t *attack )
{
	switch( attack->kind ){
	case ATTACK_KIND_NULL:
		break;
	case ATTACK_KIND_PUNCH:
		return MSG_ATTACK_PUNCH;
	case ATTACK_KIND_KICK:
		return MSG_ATTACK_KICK;
	case ATTACK_KIND_BITE:
		return MSG_ATTACK_BITE;
	case ATTACK_KIND_KNOCK:
		return MSG_ATTACK_KNOCK;
	case ATTACK_KIND_STING:
		return MSG_ATTACK_STING;
	case ATTACK_KIND_SLASH:
		return MSG_ATTACK_SLASH;
	case ATTACK_KIND_MOW:
		return MSG_ATTACK_MOW;
	case ATTACK_KIND_SHOOT:
		return MSG_ATTACK_SHOOT;
	case ATTACK_KIND_THROW:
		return MSG_ATTACK_THROW;
	case ATTACK_KIND_MAX_N:
		break;
	}

#ifdef	NDEBUG
	return MSG_ATTACK_PUNCH;
#else	/* NDEBUG */
	return MSG_ATTACK_ERR;
#endif	/* NDEBUG */
}

/**/

