#ifndef	__TOWN_H__
#define	__TOWN_H__

#include	"dun.h"

typedef enum {
	SHOP_N_BAR,
	SHOP_N_INN,
	SHOP_N_TEMPLE,
	SHOP_N_WPN,
	SHOP_N_ARMOR,
	SHOP_N_MAGIC,
	SHOP_N_GROCERY,
	SHOP_N_RESTAURANT,
	SHOP_N_TEAROOM,
	SHOP_N_TOBACCO,
} shop_n_t;

#define	FACE_MNR_SHOP_INN	'i'
#define	FACE_MNR_SHOP_BAR	'b'
#define	FACE_MNR_SHOP_TEMPLE	't'
#define	FACE_MNR_SHOP_WPN	'w'
#define	FACE_MNR_SHOP_ARMOR	'a'
#define	FACE_MNR_SHOP_MAGIC	'm'
#define	FACE_MNR_SHOP_GROCERY	'g'
#define	FACE_MNR_SHOP_RESTAURANT	'r'
#define	FACE_MNR_SHOP_TEAROOM	'c'
#define	FACE_MNR_SHOP_TOBACCO	's'

#define	TOWN_PTN_COL_MAX_N	128

typedef struct {
	long	col_str_len;
	long	col_n;
	unsigned char	col_mjr[TOWN_PTN_COL_MAX_N];
	unsigned char	col_mnr[TOWN_PTN_COL_MAX_N];
	char	map_mjr[MAP_MAX_Y][MAP_MAX_X];
	char	map_mnr[MAP_MAX_Y][MAP_MAX_X];
} town_ptn_t;

typedef struct {
	long	col_code;
	char	mjr, mnr;
} town_ptn_col_tab_t;

#endif	/* __TOWN_H__ */
