/***************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2014 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: dun-tab.h,v 1.32 2014/01/07 23:40:42 bowkenken Exp $
***************************************************************/

#ifndef	DUN_TAB_H
#define	DUN_TAB_H

/***************************************************************
* µܥǡơ֥
***************************************************************/

/*  */

#define	FACE_ROOM_PTN_ITEM	'$'
#define	FACE_ROOM_PTN_MIMIC	'&'
#define	FACE_ROOM_PTN_TRAP	'^'

/* о쳬 */

#define	ROOM_LEV_PLAIN	\
	(0 + 1)
#define	ROOM_LEV_CRUMBLING	\
	(0 + 1)
#define	ROOM_LEV_L	\
	(5 + 1)
#define	ROOM_LEV_CROSS	\
	(10 + 1)
#define	ROOM_LEV_CIRCLE	\
	(15 + 1)
#define	ROOM_LEV_WINDING	\
	(20 + 1)
#define	ROOM_LEV_DOT	\
	(25 + 1)
#define	ROOM_LEV_TWIN	\
	(30 + 1)
#define	ROOM_LEV_THE_I	\
	(35 + 1)
#define	ROOM_LEV_CROSS_NEST	\
	(40 + 1)
#define	ROOM_LEV_NEST	\
	(45 + 1)
#define	ROOM_LEV_TREASURE_IN_TRAP	\
	(50 + 1)
#define	ROOM_LEV_ZIGZAG	\
	(55 + 1)
#define	ROOM_LEV_WHORL	\
	(60 + 1)
#define	ROOM_LEV_OUBLIETTE	\
	(65 + 1)
#define	ROOM_LEV_CLOVER	\
	(70 + 1)
#define	ROOM_LEV_QUARTER	\
	(75 + 1)
#define	ROOM_LEV_MIMIC	\
	(80 + 1)
#define	ROOM_LEV_CROSS_SPLIT	\
	(85 + 1)
#define	ROOM_LEV_DRUAGA	\
	(90 + 1)
#define	ROOM_LEV_DIVISION_9	\
	(95 + 1)

/***************************************************************
* ޥåסǡ
***************************************************************/

#if	0
typedef struct {
	long	min_lev, max_lev, sgn_lev;
	rate_t	rate;
	char	ptn[AREA_MAX_Y][AREA_MAX_X * 2];
	sect_t	sect[AREA_MAX_Y][AREA_MAX_X];
} room_ptn_t;
#endif

static room_ptn_t	room_ptn[] = {
	{
		ROOM_LEV_PLAIN, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},

	{
		ROOM_LEV_CRUMBLING, DUN_MAX_LEV_BASE, -1, (rate_t)40,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . ######",
			"##. . . . . . . . . . . . . . . . . ####",
			"##. . . . . . . . . . . . . . . ########",
			"##. . . . . . . . . . . . . . . . ######",
			"##. . . . . . . . . . . ##. . . ########",
			"##. . . . . . . . . . . ####. ##########",
			"##. . . . . . . . . ####################",
			"##. ##. . . . . . . . ##################",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaabbb",
			"baaaaaaaaaaaaaaaaabb",
			"baaaaaaaaaaaaaaabbbb",
			"baaaaaaaaaaaaaaaabbb",
			"baaaaaaaaaaabaaabbbb",
			"baaaaaaaaaaabbabbbbb",
			"baaaaaaaaabbbbbbbbbb",
			"babaaaaaaaabbbbbbbbb",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},

	{
		ROOM_LEV_L, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . ####################",
			"##. . . . . . . . . ####################",
			"##. . . . . . . . . ####################",
			"##. . . . . . . . . ####################",
			"##. . . . . . . . . ####################",
			"##. . . . . . . . . ####################",
			"##. . . . . . . . . ####################",
			"##. . . . . . . . . ####################",
			"##. . . . . . . . . ####################",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaabbbbbbbbbb",
			"baaaaaaaaabccccccccc",
			"baaaaaaaaabccccccccc",
			"baaaaaaaaabccccccccc",
			"baaaaaaaaabccccccccc",
			"baaaaaaaaabccccccccc",
			"baaaaaaaaabccccccccc",
			"baaaaaaaaabccccccccc",
			"baaaaaaaaabccccccccc",
			"bbbbbbbbbbbccccccccc",
		}
	},

	{
		ROOM_LEV_CROSS, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"########################################",
		},
		{
			"cccccbbbbbbbbbbccccc",
			"cccccbaaaaaaaabccccc",
			"cccccbaaaaaaaabccccc",
			"cccccbaaaaaaaabccccc",
			"cccccbaaaaaaaabccccc",
			"bbbbbbaaaaaaaabbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbaaaaaaaabbbbbb",
			"cccccbaaaaaaaabccccc",
			"cccccbaaaaaaaabccccc",
			"cccccbaaaaaaaabccccc",
			"cccccbaaaaaaaabccccc",
			"cccccbbbbbbbbbbccccc",
		}
	},

	{
		ROOM_LEV_CIRCLE, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"################. . . . ################",
			"############. . . . . . . . ############",
			"########. . . . . . . . . . . . ########",
			"######. . . . . . . . . . . . . . ######",
			"######. . . . . . . . . . . . . . ######",
			"####. . . . . . . . . . . . . . . . ####",
			"####. . . . . . . . . . . . . . . . ####",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"####. . . . . . . . . . . . . . . . ####",
			"####. . . . . . . . . . . . . . . . ####",
			"######. . . . . . . . . . . . . . ######",
			"######. . . . . . . . . . . . . . ######",
			"########. . . . . . . . . . . . ########",
			"############. . . . . . . . ############",
			"################. . . . ################",
			"########################################",
		},
		{
			"cccccccbbbbbbccccccc",
			"cccccbbbaaaabbbccccc",
			"cccbbbaaaaaaaabbbccc",
			"ccbbaaaaaaaaaaaabbcc",
			"ccbaaaaaaaaaaaaaabcc",
			"cbbaaaaaaaaaaaaaabbc",
			"cbaaaaaaaaaaaaaaaabc",
			"bbaaaaaaaaaaaaaaaabb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",

			"baaaaaaaaaaaaaaaaaab",
			"bbaaaaaaaaaaaaaaaabb",
			"cbaaaaaaaaaaaaaaaabc",
			"cbbaaaaaaaaaaaaaabbc",
			"ccbaaaaaaaaaaaaaabcc",
			"ccbbaaaaaaaaaaaabbcc",
			"cccbbbaaaaaaaabbbccc",
			"cccccbbbaaaabbbccccc",
			"cccccccbbbbbbccccccc",
		}
	},

	{
		ROOM_LEV_WINDING, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##########################. . . . . . ##",
			"##########################. . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . ##########################",
			"##. . . . . . ##########################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"aaaaaaaaaaaaaaaaaaaa",
			"acccccccccccccccccca",
			"acccccccccccccccccca",
			"acccccccccccccccccca",
			"acccccccccccccccccca",
			"acccccccccccccccccca",
			"aaaaaaaaaaaaacccccca",
			"aaaaaaaaaaaaacccccca",
			"adddddddddccccccccca",
			"adddddddddccccccccca",
			"bdddddddddcccccccccb",
			"bdddddddddcccccccccb",
			"bddddddbbbbbbbbbbbbb",
			"bddddddbbbbbbbbbbbbb",
			"bddddddddddddddddddb",
			"bddddddddddddddddddb",
			"bddddddddddddddddddb",
			"bddddddddddddddddddb",
			"bddddddddddddddddddb",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},

	{
		ROOM_LEV_DOT, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . $ . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . ####. . . . . . . . ##",
			"##. . . . . . . ########. . . . . . . ##",
			"##. . . . . . . ########. . . . . . . ##",
			"##. . . . . . . . ####. . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},

	{
		ROOM_LEV_TWIN, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"##. . . . . . . . ######################",
			"##. . . . . . . . ######################",
			"##. . . . . . . . ######################",
			"##. . . . $ . . . ######################",
			"##. . . . . . . . ######################",
			"##. . . . . . . . ######################",
			"##. . . . . . . . ######################",
			"##. . . . . . . . + + ##################",
			"##################+ + ##################",
			"##################+ + ##################",
			"##################+ + . . . . . . . . ##",
			"######################. . . . . . . . ##",
			"######################. . . . . . . . ##",
			"######################. . . . . . . . ##",
			"######################. . . . . . . . ##",
			"######################. . . . . . . . ##",
			"######################. . . . . . . . ##",
			"######################. . . . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbffffffffff",
			"baaaaaaaabffffffffff",
			"baaaaaaaabffffffffff",
			"baaaaaaaabffffffffff",
			"baaaaaaaabffffffffff",
			"baaaaaaaabffffffffff",
			"baaaaaaaabffffffffff",
			"baaaaaaaabffffffffff",
			"baaaaaaaaeefffffffff",
			"bbbbbbbbbeefffffffff",
			"fffffffffeeddddddddd",
			"fffffffffeeccccccccd",
			"ffffffffffdccccccccd",
			"ffffffffffdccccccccd",
			"ffffffffffdccccccccd",
			"ffffffffffdccccccccd",
			"ffffffffffdccccccccd",
			"ffffffffffdccccccccd",
			"ffffffffffdccccccccd",
			"ffffffffffdddddddddd",
		}
	},

	{
		ROOM_LEV_THE_I, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. $ . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##############. . . . . . ##############",
			"##############. . . . . . ##############",
			"##############. . . . . . ##############",
			"##############. . . . . . ##############",
			"##############. . . . . . ##############",
			"##############. . . . . . ##############",
			"##############. . . . . . ##############",
			"##############. . . . . . ##############",
			"##############. . . . . . ##############",
			"##############. . . . . . ##############",
			"##############. . . . . . ##############",
			"##############. . . . . . ##############",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"dddddddddddddddddddd",
			"daaaaaaaaaaaaaaaaaad",
			"daaaaaaaaaaaaaaaaaad",
			"daaaaaaaaaaaaaaaaaad",
			"dddddddbbbbbbddddddd",
			"dddddddbbbbbbddddddd",
			"dddddddbbbbbbddddddd",
			"dddddddbbbbbbddddddd",
			"dddddddbbbbbbddddddd",
			"dddddddbbbbbbddddddd",
			"dddddddbbbbbbddddddd",
			"dddddddbbbbbbddddddd",
			"dddddddbbbbbbddddddd",
			"dddddddbbbbbbddddddd",
			"dddddddbbbbbbddddddd",
			"dddddddbbbbbbddddddd",
			"dccccccccccccccccccd",
			"dccccccccccccccccccd",
			"dccccccccccccccccccd",
			"dddddddddddddddddddd",
		},
	},

	{
		ROOM_LEV_CROSS_NEST, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . ##+ + ##. . . . . . . ##",
			"##. . . . . . . ##. . ##. . . . . . . ##",
			"##. . . . . . . ##$ . ##. . . . . . . ##",
			"##. . . . . . . ########. . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"############. . . . . . . . ############",
			"########################################",
		},
		{
			"eeeeeddddddddddeeeee",
			"eeeeedccccccccdeeeee",
			"eeeeedccccccccdeeeee",
			"eeeeedccccccccdeeeee",
			"eeeeedccccccccdeeeee",
			"ddddddccccccccdddddd",
			"dccccccccccccccccccd",
			"dccccccccccccccccccd",
			"dcccccccbbbbcccccccd",
			"dcccccccbaabcccccccd",
			"dcccccccbaabcccccccd",
			"dcccccccbbbbcccccccd",
			"dccccccccccccccccccd",
			"dccccccccccccccccccd",
			"ddddddccccccccdddddd",
			"eeeeedccccccccdeeeee",
			"eeeeedccccccccdeeeee",
			"eeeeedccccccccdeeeee",
			"eeeeedccccccccdeeeee",
			"eeeeeddddddddddeeeee",
		}
	},

	{
		ROOM_LEV_NEST, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . ########################. . . ##",
			"##. . . + + + . . . . . . ######. . . ##",
			"##. . . + + + . . . . . . ######. . . ##",
			"##. . . + + + . . . . . . ######. . . ##",
			"##. . . ##. . . . . . . . . . ##. . . ##",
			"##. . . ##. . . . . $ . . . . ##. . . ##",
			"##. . . ##. . . . $ . . . . . ##. . . ##",
			"##. . . ##. . . . . . . . . . ##. . . ##",
			"##. . . ######. . . . . . ######. . . ##",
			"##. . . ######. . . . . . ######. . . ##",
			"##. . . ######. . . . . . ######. . . ##",
			"##. . . ########################. . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"eeeeeeeeeeeeeeeeeeee",
			"edddddddddddddddddde",
			"edddddddddddddddddde",
			"edddddddddddddddddde",
			"edddccbbbbbbbbccddde",
			"edddccbaaaaaabccddde",
			"edddccbaaaaaabccddde",
			"edddbbbaaaaaabbbddde",
			"edddbaaaaaaaaaabddde",
			"edddbaaaaaaaaaabddde",
			"edddbaaaaaaaaaabddde",
			"edddbaaaaaaaaaabddde",
			"edddbbbaaaaaabbbddde",
			"edddccbaaaaaabccddde",
			"edddccbaaaaaabccddde",
			"edddccbbbbbbbbccddde",
			"edddddddddddddddddde",
			"edddddddddddddddddde",
			"edddddddddddddddddde",
			"eeeeeeeeeeeeeeeeeeee",
		}
	},

	{
		ROOM_LEV_TREASURE_IN_TRAP, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . ^ ^ ^ ^ ^ ^ . . . . . . ##",
			"##. . . . . . ^ ^ ^ ^ ^ ^ . . . . . . ##",
			"##. . . . . . ^ ^ $ $ ^ ^ . . . . . . ##",
			"##. . . . . . ^ ^ $ $ ^ ^ . . . . . . ##",
			"##. . . . . . ^ ^ ^ ^ ^ ^ . . . . . . ##",
			"##. . . . . . ^ ^ ^ ^ ^ ^ . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},

	{
		ROOM_LEV_ZIGZAG, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . ####. $ . ####. . . ####. . . ##",
			"##. . . ####. . . ####. . . ####. . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"######. . . ####. . . . ####. . . ######",
			"######. . . ####. . $ . ####. . . ######",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . ####. . . ####. . . ####. . . ##",
			"##. . . ####. . . ####. $ . ####. . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaabbaaabbaaabbaaab",
			"baaabbaaabbaaabbaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbaaabbaaaabbaaabbb",
			"bbbaaabbaaaabbaaabbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaabbaaabbaaabbaaab",
			"baaabbaaabbaaabbaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},

	{
		ROOM_LEV_WHORL, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"################################. . . ##",
			"################################. . . ##",
			"##. . . . . . . . . . . . . ####. . . ##",
			"##. . . . . . . . . . . . . ####. . . ##",
			"##. . . . . . . . . . . . . ####. . . ##",
			"##. . . ##############. . . ####. . . ##",
			"##. . . ##############. . . ####. . . ##",
			"##. . . ####. . $ . . . . . ####. . . ##",
			"##. . . ####. $ . . . . . . ####. . . ##",
			"##. . . ####. . . . . . . . ####. . . ##",
			"##. . . ########################. . . ##",
			"##. . . ########################. . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"eeeeeeeeeeeeeeeeeeee",
			"eaaaaaaaaaaaaaaaaaae",
			"eaaaaaaaaaaaaaaaaaae",
			"eaaaaaaaaaaaaaaaaaae",
			"efffffffffffffffaaae",
			"efffffffffffffffaaae",
			"ebbbccccccccccffaaae",
			"ebbbccccccccccffaaae",
			"ebbbccccccccccffaaae",
			"ebbbgghhhhhcccffaaae",
			"ebbbgghhhhhcccffaaae",
			"ebbbggdddddcccffaaae",
			"ebbbggdddddcccffaaae",
			"ebbbggdddddcccffaaae",
			"ebbbggggggggggffaaae",
			"ebbbggggggggggffaaae",
			"ebbbbbbbbbbbbbbbaaae",
			"ebbbbbbbbbbbbbbbaaae",
			"ebbbbbbbbbbbbbbbaaae",
			"eeeeeeeeeeeeeeeeeeee",
		},
	},

	{
		ROOM_LEV_OUBLIETTE, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"##. . . . ##. . . . ##. . . . ##. . . ##",
			"##. $ . . ##. . . . ##. . $ . ##. . . ##",
			"##. . . . ##. . . . ##. . . . ##. . . ##",
			"##. . . . ##. . . . ##. . . . ##. . . ##",
			"##. . . . ##. . . . ##. . . . ##. . . ##",
			"##. . . . ##. . . . ##. . . . ##. . . ##",
			"##+ + + ####+ + + ######+ + + ##+ + + ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##+ + + ####+ + + ####+ + + ####+ + + ##",
			"##. . . . ##. . . . ##. . . . ##. . . ##",
			"##. . . . ##. . . . ##. . . . ##. . . ##",
			"##. . . . ##. . . . ##. . . . ##. . . ##",
			"##. . . . ##. . . . ##. . . . ##. $ . ##",
			"##. . . . ##. . . . ##. . . . ##. . . ##",
			"##. . . . ##. . . . ##. . . . ##. . . ##",
			"########################################",
		},
		{
			"jjjjjjjjjjjjjjjjjjjj",
			"jaaaajbbbbjccccjdddj",
			"jaaaajbbbbjccccjdddj",
			"jaaaajbbbbjccccjdddj",
			"jaaaajbbbbjccccjdddj",
			"jaaaajbbbbjccccjdddj",
			"jaaaajbbbbjccccjdddj",
			"jjjjjjjjjjjjjjjjjjjj",
			"jiiiiiiiiiiiiiiiiiij",
			"jiiiiiiiiiiiiiiiiiij",
			"jiiiiiiiiiiiiiiiiiij",
			"jiiiiiiiiiiiiiiiiiij",
			"jjjjjjjjjjjjjjjjjjjj",
			"jeeeejffffjggggjhhhj",
			"jeeeejffffjggggjhhhj",
			"jeeeejffffjggggjhhhj",
			"jeeeejffffjggggjhhhj",
			"jeeeejffffjggggjhhhj",
			"jeeeejffffjggggjhhhj",
			"jjjjjjjjjjjjjjjjjjjj",
		},
	},

	{
		ROOM_LEV_CLOVER, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . $ . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . ######. . . . . . ######. . . ##",
			"##. . . ########. . . . ########. . . ##",
			"##. . . ########. . . . ########. . . ##",
			"##. . . ########. . . . ########. . . ##",
			"##. . . . ######. . . . ######. . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. $ . . . . . . . . . . . . . . $ . ##",
			"##. . . . ######. . . . ######. . . . ##",
			"##. . . ########. . . . ########. . . ##",
			"##. . . ########. . . . ########. . . ##",
			"##. . . ########. . . . ########. . . ##",
			"##. . . ######. . . . . . ######. . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . $ . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaabbbaaaaaabbbaaab",
			"baaabbbbaaaabbbbaaab",
			"baaabbbbaaaabbbbaaab",
			"baaabbbbaaaabbbbaaab",
			"baaaabbbaaaabbbaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaabbbaaaabbbaaaab",
			"baaabbbbaaaabbbbaaab",
			"baaabbbbaaaabbbbaaab",
			"baaabbbbaaaabbbbaaab",
			"baaabbbaaaaaabbbaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},

	{
		ROOM_LEV_QUARTER, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"##. . . . . . . ########. . . . . . . ##",
			"##. . . . . . . ########. . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . $ . . . . . . . . . . $ . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . ########. . . . . . . ##",
			"##. . . . . . . ########. . . . . . . ##",
			"######. . . ################. . . ######",
			"######. . . ################. . . ######",
			"######. . . ################. . . ######",
			"######. . . ################. . . ######",
			"##. . . . . . . ########. . . . . . . ##",
			"##. . . . . . . ########. . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . $ . . . . . . . . . . $ . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . ########. . . . . . . ##",
			"##. . . . . . . ########. . . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaabbbbaaaaaaab",
			"baaaaaaabbbbaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaabbbbaaaaaaab",
			"baaaaaaabbbbaaaaaaab",
			"bbbaaabbbbbbbbaaabbb",
			"bbbaaabbbbbbbbaaabbb",
			"bbbaaabbbbbbbbaaabbb",
			"bbbaaabbbbbbbbaaabbb",
			"baaaaaaabbbbaaaaaaab",
			"baaaaaaabbbbaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaabbbbaaaaaaab",
			"baaaaaaabbbbaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		},
	},

	{
		ROOM_LEV_MIMIC, DUN_MAX_LEV_BASE, -1, (rate_t)5,
		{
			"########################################",
			"######. . . . . . . . . . . . . . ######",
			"######. . . . . . . . . . . . . . ######",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . & . . . . . . & . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . & . . . . . . & . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"######. . . . . . . . . . . . . . ######",
			"######. . . . . . . . . . . . . . ######",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"bbbaaaaaaaaaaaaaabbb",
			"bbbaaaaaaaaaaaaaabbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbaaaaaaaaaaaaaabbb",
			"bbbaaaaaaaaaaaaaabbb",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},

	{
		ROOM_LEV_CROSS_SPLIT, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"########. . . . . . . . . . . . ########",
			"########. . $ . . . . . . . . . ########",
			"##########. . . . . . . . . . ##########",
			"##. . ######. . . . . . . . ######. . ##",
			"##. . . ########. . . . ########. . . ##",
			"##. . . . ######. . . . ######. . . . ##",
			"##. . . . ######. . . . ######. . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. $ . . ######. . . . ######. . . . ##",
			"##. . . . ######. . . . ######. . . $ ##",
			"##. . . ########. . . . ########. . . ##",
			"##. . ######. . . . . . . . ######. . ##",
			"##########. $ . . . . . . . . ##########",
			"########. . . . . . . . . . . . ########",
			"########. . . . . . . . . . . . ########",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"bbbbaaaaaaaaaaaabbbb",
			"bbbbaaaaaaaaaaaabbbb",
			"bbbbbaaaaaaaaaabbbbb",
			"baabbbaaaaaaaabbbaab",
			"baaabbbbaaaabbbbaaab",
			"baaaabbbaaaabbbaaaab",
			"baaaabbbaaaabbbaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaabbbaaaabbbaaaab",
			"baaaabbbaaaabbbaaaab",
			"baaabbbbaaaabbbbaaab",
			"baabbbaaaaaaaabbbaab",
			"bbbbbaaaaaaaaaabbbbb",
			"bbbbaaaaaaaaaaaabbbb",
			"bbbbaaaaaaaaaaaabbbb",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},

	{
		ROOM_LEV_DRUAGA, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. $ . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"################################. . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. $ . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"################################. . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"################################. . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. $ . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"################################. . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. $ . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},

	{
		ROOM_LEV_DIVISION_9, DUN_MAX_LEV_BASE, -1, (rate_t)80,
		{
			"########################################",
			"##. . . . . ####. . . . ####. . . . . ##",
			"##. . . . . ####. . . . ####. . $ . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . $ ####. . . . ####. . . . . ##",
			"######. . ########. . ########. . ######",
			"######. . ########. . ########. . ######",
			"##. . . . . ####. . . . ####. . . . . ##",
			"##. . . . . ####. . . . ####. . . . . ##",
			"##. . . . . ####. . . . ####. . . . . ##",
			"##. . . . . ####. . . . ####. . . . . ##",
			"######. . ########. . ########. . ######",
			"######. . ########. . ########. . ######",
			"##. . . . . ####. . . . ####. . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. $ . . . ####. . . . ####. . . . . ##",
			"##. . . . . ####. . . . ####. . . $ . ##",
			"########################################",
		},
		{
			"gggggggggggggggggggg",
			"gaaaaaggbbbbggcccccg",
			"gaaaaaggbbbbggcccccg",
			"gaaaaabbbbbbbbcccccg",
			"gaaaaabbbbbbbbcccccg",
			"gaaaaaggbbbbggcccccg",
			"gggaaggggbbggggccggg",
			"gggaaggggbbggggccggg",
			"gaaaaaggbbbbggcccccg",
			"gaaaaaggbbbbggcccccg",
			"gaaaaaggbbbbggcccccg",
			"gaaaaaggbbbbggcccccg",
			"gggaaggggbbggggccggg",
			"gggaaggggbbggggccggg",
			"gaaaaaggbbbbggcccccg",
			"gaaaaabbbbbbbbcccccg",
			"gaaaaabbbbbbbbcccccg",
			"gaaaaaggbbbbggcccccg",
			"gaaaaaggbbbbggcccccg",
			"gggggggggggggggggggg",
		}
	},
};

/***************************************************************
* ܥΥޥåסǡ
***************************************************************/

static room_ptn_t	boss_room_ptn[] = {
/* MNSTR_KIND_HIGH_RE_HOO, */
	{
		10, 10, -1, (rate_t)100,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . GH. . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . ####. ##. . . . . . ##",
			"##. . . . . . . ##. . ####. . . . . . ##",
			"##. . . . . . ##. . . . ##. . . . . . ##",
			"##. . . . . ######+ ########. . . . . ##",
			"##. . . . . . ##. . . . ##. . . . . . ##",
			"##. . . . . . + . . . . ##. . . . . . ##",
			"##. . . . . . + . . . . ##. . . . . . ##",
			"##. . . . . . ##. . . . ##. . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},
/* MNSTR_KIND_GREAT_MINOTAUR, */
	{
		20, 20, -1, (rate_t)100,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . ####. . ############. . ####. . ##",
			"##. . ####. . ############. . ####. . ##",
			"##. . ####. . . . . . . . . . ####. . ##",
			"##. . ####. . . . . . . . . . ####. . ##",
			"##. . ############. . ####. . ####. . ##",
			"##. . ############. . ####. . ####. . ##",
			"##. . . . . . . . YM. . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . ####. . ############. . ####. . ##",
			"##. . ####. . ############. . ####. . ##",
			"##. . . . . . ####. . . . . . . . . . ##",
			"##. . . . . . ####. . . . . . . . . . ##",
			"##########. . ####. . ############. . ##",
			"##########. . ####. . ############. . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"mmmmmmmmmmmmmmmmmmmm",
			"maaaaaabbbbbbccccccm",
			"maaaaaabbbbbbccccccm",
			"maaaaaabbbbbbccccccm",
			"maaaaaabbbbbbccccccm",
			"maaaaaabbbbbbccccccm",
			"maaaaaabbbbbbccccccm",
			"mddddddeeeeeeffffffm",
			"mddddddeeeeeeffffffm",
			"mddddddeeeeeeffffffm",
			"mddddddeeeeeeffffffm",
			"mddddddeeeeeeffffffm",
			"mddddddeeeeeeffffffm",
			"mgggggghhhhhhiiiiiim",
			"mgggggghhhhhhiiiiiim",
			"mgggggghhhhhhiiiiiim",
			"mgggggghhhhhhiiiiiim",
			"mgggggghhhhhhiiiiiim",
			"mgggggghhhhhhiiiiiim",
			"mmmmmmmmmmmmmmmmmmmm",
		}
	},
/* MNSTR_KIND_BILLION_ELEMENTAL, */
	{
		30, 30, -1, (rate_t)100,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. ##. ##. ##. ##. ##. ##. ##. ##. . ##",
			"##. . ##. ##. ##. ##. ##. ##. ##. ##. ##",
			"##. ##. ##. ##. ##. ##. ##. ##. ##. . ##",
			"##. . ##. ##. ##. ##. ##. ##. ##. ##. ##",
			"##. ##. ##. ##. ##. ##. ##. ##. ##. . ##",
			"##. . ##. ##. ##. ##. ##. ##. ##. ##. ##",
			"##. ##. ##. ##. . . . . ##. ##. ##. . ##",
			"##. . ##. ##. ##. . . . . ##. ##. ##. ##",
			"##. ##. ##. ##. . . EB. ##. ##. ##. . ##",
			"##. . ##. ##. ##. . . . . ##. ##. ##. ##",
			"##. ##. ##. ##. ##. ##. ##. ##. ##. . ##",
			"##. . ##. ##. ##. ##. ##. ##. ##. ##. ##",
			"##. ##. ##. ##. ##. ##. ##. ##. ##. . ##",
			"##. . ##. ##. ##. ##. ##. ##. ##. ##. ##",
			"##. ##. ##. ##. ##. ##. ##. ##. ##. . ##",
			"##. . ##. ##. ##. ##. ##. ##. ##. ##. ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},
/* MNSTR_KIND_CYBERN, */
	{
		40, 40, -1, (rate_t)100,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . ##+ ##. . . . . . . . . . ##. . ##",
			"##. ##. . . ##. . . . . . . . ####. . ##",
			"##. ##. . . ##. . . . . . . . . ##. . ##",
			"##. ##. . . ##. . . . . . . . . ##. . ##",
			"##. ##. . ####. . . . . . . . . ##. . ##",
			"##. ##. . ####. . . . . . . . . ##. . ##",
			"##. ##. ##. ##. . . . . . . . . ##. . ##",
			"##. ##. ##. ##. . . MC. . . . . ##. . ##",
			"##. ####. . ##. . . . . . . . . ##. . ##",
			"##. ####. . ##. . . . . . . . . ##. . ##",
			"##. ##. . . ##. . . . . . . . . ##. . ##",
			"##. ##. . . ##. . . . . . . . . ##. . ##",
			"##. ##. . . ##. . . . . . . . . ##. . ##",
			"##. . ##+ ##. . . . . . . . . ######. ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},
/* MNSTR_KIND_GIGANTIC_CENTIPEDE, */
	{
		50, 50, -1, (rate_t)100,
		{
			"########################################",
			"######. . . . . . . . . . . . . . ######",
			"####. . . . . . . . . . . . . . . . ####",
			"##. . . . . . . . . BC. . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"####. . . . . . . . . . . . . . . . ####",
			"######. . . . . . . . . . . . . . ######",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},
/* MNSTR_KIND_MEDUSA_ZOMBIE, */
	{
		60, 60, -1, (rate_t)100,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . #@. . ##",
			"##. #@. . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . #@. . . . . . . . ##",
			"##. . . . . . . . . . . . . . #@. . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . #@. . . . . . . #@. . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . #@. YD. . . . #@. . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . #@. . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . #@. . . . . . . . . . . . ##",
			"##. . . . . . . . . . . #@. . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},
/* MNSTR_KIND_BLACK_UNICORN, */
	{
		70, 70, -1, (rate_t)100,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . WU. . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . ########. . . . . . . . . . ##",
			"##. . . . . . ########. . . . . . . . ##",
			"##. . . . . . . . ########. . . . . . ##",
			"##. . . . . . . . . . ########. . . ####",
			"##. . . . . . . . . . . . ##############",
			"##. . . . . . . . . . . . . . ##########",
			"##. . . . . . . . . . . . . ############",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},
/* MNSTR_KIND_VAMPIRE_LORD, */
	{
		80, 80, -1, (rate_t)100,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . ########. . . . . . . ##",
			"##. . . . . . ####. . ####. . . . . . ##",
			"##. . . . . . ##. UV. . ##. . . . . . ##",
			"##. . . . . . ####. . ####. . . . . . ##",
			"##. . . . . . ####. . ####. . . . . . ##",
			"##. . . . . . . ##. . ##. . . . . . . ##",
			"##. . . . . . . ##+ + ##. . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaabbbbaaaaaaab",
			"baaaaaabbccbbaaaaaab",
			"baaaaaabccccbaaaaaab",
			"baaaaaabbccbbaaaaaab",
			"baaaaaabbccbbaaaaaab",
			"baaaaaabbccbbaaaaaab",
			"baaaaaaabccbaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},
/* MNSTR_KIND_RELATIVISTIC_DAEMON, */
	{
		90, 90, -1, (rate_t)100,
		{
			"########################################",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . ##. . . . . . ##. . . . . ##",
			"##. . . . . . ##. . . . ##. . . . . . ##",
			"##. . . . . . . ##. . ##. . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . XV. . . . . . . . ##",
			"##. . . . . . . ##. . ##. . . . . . . ##",
			"##. . . . . . ##. . . . ##. . . . . . ##",
			"##. . . . . ##. . . . . . ##. . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},
/* MNSTR_KIND_ETERNAL_DRAGON, */
	{
		100, 100, -1, (rate_t)100,
		{
			"########################################",
			"##. . . . . . . ########. . . . . . . ##",
			"##. . . . . . . ########. . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"######. . . . . . . . . . . . . . ######",
			"######. . . . . . . . . . . . . . ######",
			"######. . . . . . . DX. . . . . . ######",
			"######. . . . . . . . . . . . . . ######",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . ########. . . . . . . ##",
			"##. . . . . . . ########. . . . . . . ##",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	},
};

/***************************************************************
* 饹ܥΥޥåסǡ
***************************************************************/

static room_ptn_t	last_boss_room_ptn[LAST_BOSS_ROOM_PTN_MAX_N] = {
	{
		0, DUN_MAX_LEV_BASE, -1, _100_PERCENT,
		{
			".c####################################. ",
			"####          . . . . . . .         ####",
			"##          . . . . #&. . . .         ##",
			"##          . . . . . . . . .         ##",
			"##          . . . . XE. . . .         ##",
			"##          . . . . . . . . .         ##",
			"##          . . XL. . . XR. .         ##",
			"##            . . . . . . .           ##",
			"##                                    ##",
			"##                                    ##",
			"##                                    ##",
			"##                                    ##",
			"##    . . . . . . . . . . . . . .     ##",
			"##  . . . . . . . . .z. . . . . . .   ##",
			"##  . . . . . . . . . . . . . . . .   ##",
			"##  .y.y.y.y.y.y.y.y.y.y.y.y.y.y.y.y  ##",
			"##  . . . . . . . . . . . . . . . .   ##",
			"##  . . . . . . . . .b. . . . . . .   ##",
			"##  . . . . . . . . . . . . . . . .   ##",
			"##  . . . . . . . . . . . . . . . .   ##",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
		}
	},
	{
		0, DUN_MAX_LEV_BASE, -1, _100_PERCENT,
		{
			"##  . . . . . . . . . . . . . . . .   ##",
			"##  . . . . . . . . . . . . . . . .   ##",
			"##  . . . . . . . . . . . . . . . .   ##",
			"##  . . . . . . . . . . . . . . . .   ##",
			"##  . . . . . . . . . . . . . . . .   ##",
			"##  . . . . . . . . . . . . . . . .   ##",
			"##  . . . . . . . . . . . . . . . .   ##",
			"##  . . . . . . . . . . . . . . . .   ##",
			"##    . . . . . . . . . . . . . .     ##",
			"##              . . . .               ##",
			"##              . . . .               ##",
			"##              . . . .               ##",
			"##              . . . .               ##",
			"##              . . . .               ##",
			"##              . . . .               ##",
			"##              . . . .               ##",
			"##              . . . .               ##",
			"##              . . . .               ##",
			"##              . . . .               ##",
			"##              . . . .               ##",
		},
		{
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
		}
	},
	{
		0, DUN_MAX_LEV_BASE, -1, _100_PERCENT,
		{
			"################+ + + + ################",
			"################+ + + + ################",
			"##. . . . .1.1.1. . . . .2.2.2. . . . ##",
			"##. . . . .1#&.1. . . . .2#&.2. . . . ##",
			"##. . . . .1.1.1. . . . .2.2.2. . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##.0.0.0. . . . . . . . . . . . .3.3.3##",
			"##.0#&.0. . . . . . .a. . . . . .3#&.3##",
			"##.0.0.0. . . . . . . . . . . . .3.3.3##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . . . . . . . . . . . . . . . ##",
			"##. . . . .5.5.5. . . . .4.4.4. . . . ##",
			"##. . . . .5#&.5. . . . .4#&.4. . . . ##",
			"##. . . . .5.5.5. . . . .4.4.4. . . . ##",
			"########################################",
			"########################################",
		},
		{
			"bbbbbbbbbbbbbbbbbbbb",
			"bbbbbbbbbbbbbbbbbbbb",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"baaaaaaaaaaaaaaaaaab",
			"bbbbbbbbbbbbbbbbbbbb",
			"bbbbbbbbbbbbbbbbbbbb",
		}
	}
};

/* ޥåס٥ */

map_event_tab_t	last_boss_map_event_tab[] = {
	/* ݥ */
	{ '0', event_boot_unit, },
	{ '1', event_boot_unit, },
	{ '2', event_boot_unit, },
	{ '3', event_boot_unit, },
	{ '4', event_boot_unit, },
	{ '5', event_boot_unit, },

	/* ѡƥνи */
	{ MAP_EVENT_LAST_BOSS_APPEAR_PARTY, NULL, },
	/* ѡƥƮϰ */
	{ MAP_EVENT_LAST_BOSS_BATTLE_PARTY, NULL, },
	/* ƮϻΥޥåס */
	{ MAP_EVENT_LAST_BOSS_SCROLL_MAP, NULL, },
	/* 饹ܥƮϰ */
	{ MAP_EVENT_LAST_BOSS_BATTLE_BOSS, NULL, },
	/* 饹ܥ٥ȳϰ */
	{ MAP_EVENT_LAST_BOSS_WORDS, event_begin_last_boss, },

	{ '\0', NULL, },
};

#endif	/* DUN_TAB_H */
