/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: chr.c,v 1.87 2003/11/23 04:29:50 bowkenken Exp $
*****************************************************************/

#include	"gmain.h"
/*#include	"misc.h"*/
/*#include	"turn.h"*/
/*#include	"dun.h"*/
#include	"town.h"
#include	"item.h"
#include	"spell.h"
#include	"chr.h"
#include	"party.h"
#include	"mnstr.h"
#include	"pet.h"
/*#include	"fight.h"*/
/*#include	"fx.h"*/
#include	"trap.h"
#include	"draw.h"
/*#include	"curs.h"*/
/*#include	"menu.h"*/
/*#include	"msg.h"*/
/*#include	"ver.h"*/
#include	"gmain_prot.h"
#include	"misc_prot.h"
#include	"turn_prot.h"
#include	"dun_prot.h"
#include	"town_prot.h"
#include	"item_prot.h"
#include	"spell_prot.h"
#include	"chr_prot.h"
#include	"party_prot.h"
#include	"mnstr_prot.h"
#include	"pet_prot.h"
#include	"fight_prot.h"
#include	"fx_prot.h"
#include	"trap_prot.h"
#include	"draw_prot.h"
#include	"curs_prot.h"
/*#include	"menu_prot.h"*/
/*#include	"tmenu_prot.h"*/
#include	"amenu_prot.h"
/*#include	"gfile_prot.h"*/
/*#include	"msg_prot.h"*/

/**/

#define	TOWNER_MOVE_RATE	50
#define	TOWNER_TURN_DIR_RATE	5

/**/

static lev_to_exp_t	lev_to_exp_tab[ABL_KIND_MAX_N] = {
	{ 100, 0 },	/* ABL_KIND_HP, */
	{ 100, 0 },	/* ABL_KIND_MP, */
	{ 100, 0 },	/* ABL_KIND_DEX, */
	{ 100, 0 },	/* ABL_KIND_STR, */
	{ 100, 0 },	/* ABL_KIND_QUI, */
	{ 100, 0 },	/* ABL_KIND_WIS, */
	{ 100, 0 },	/* ABL_KIND_INT, */
	{ 100, 0 },	/* ABL_KIND_CHA, */
	{ 100, 0 },	/* ABL_KIND_FIG, */
	{ 100, 0 },	/* ABL_KIND_MON, */
	{ 100, 0 },	/* ABL_KIND_HUN, */
	{ 100, 0 },	/* ABL_KIND_THI, */
	{ 100, 0 },	/* ABL_KIND_MAG, */
	{ 100, 0 },	/* ABL_KIND_SOR, */
	{ 100, 0 },	/* ABL_KIND_ENC, */
	{ 100, 0 },	/* ABL_KIND_SUM, */
	{ 100, 0 },	/* ABL_KIND_PRI, */
	{ 100, 0 },	/* ABL_KIND_SHA, */
	{ 100, 0 },	/* ABL_KIND_BAR, */
	{ 100, 0 },	/* ABL_KIND_NIN, */
};

static lev_to_exp_t	lev_to_exp_val = {
	1000, 0
};

static lev_to_val_t	lev_to_val_tab[ABL_KIND_MAX_N] = {
	{ 400, 12 },	/* ABL_KIND_HP, */
	{ 400, 12 },	/* ABL_KIND_MP, */
	{ 100, 0 },	/* ABL_KIND_DEX, */
	{ 100, 0 },	/* ABL_KIND_STR, */
	{ 100, 0 },	/* ABL_KIND_QUI, */
	{ 100, 0 },	/* ABL_KIND_WIS, */
	{ 100, 0 },	/* ABL_KIND_INT, */
	{ 100, 0 },	/* ABL_KIND_CHA, */
	{ 100, 0 },	/* ABL_KIND_FIG, */
	{ 100, 0 },	/* ABL_KIND_MON, */
	{ 100, 0 },	/* ABL_KIND_HUN, */
	{ 100, 0 },	/* ABL_KIND_THI, */
	{ 100, 0 },	/* ABL_KIND_MAG, */
	{ 100, 0 },	/* ABL_KIND_SOR, */
	{ 100, 0 },	/* ABL_KIND_ENC, */
	{ 100, 0 },	/* ABL_KIND_SUM, */
	{ 100, 0 },	/* ABL_KIND_PRI, */
	{ 100, 0 },	/* ABL_KIND_SHA, */
	{ 100, 0 },	/* ABL_KIND_BAR, */
	{ 100, 0 },	/* ABL_KIND_NIN, */
};

#define	FLAT_LEV	30

#define	LEV_TO_VAL_HP_MUL_RATE	400
#define	LEV_TO_VAL_HP_ADD	12
#define	LEV_TO_VAL_MP_MUL_RATE	400
#define	LEV_TO_VAL_MP_ADD	12

static mnstr_null_t	mnstr_null[MBR_MAX_N];
static square_t	mnstr_square;

/**/

void	init_chr( void )
{
	init_mnstr();
	init_party();
	init_pet();

	init_party_debug();
}

/**/

void	act_chr( chr_t *chr )
{
	dun_t	*dun;
	bool_t	flg;

	if( chr == NULL )
		return;
	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	move_chr_trgt( chr );

	if( !chk_can_act_chr( chr ) )
		return;

	dun = get_dun();
	flg = (chr->x == chr->trgt.x) && (chr->y == chr->trgt.y);

	switch( chr->act.kind ){
	case ACT_KIND_MAX_N:
	case ACT_KIND_SHOP:
	case ACT_KIND_RECALL:
		break;
	case ACT_KIND_NULL:
	case ACT_KIND_MNSTR_TAIL:
	case ACT_KIND_MBR_TAIL:
		chk_dec_chr_queue( chr );
		chk_clr_chr_queue( chr );
		chk_enter_discount_shop( chr );
		move_chr( chr );
		break;
	case ACT_KIND_MNSTR_FIGHT:
		bash_or_move( chr );
		break;
	case ACT_KIND_MNSTR_THROW:
		if( flg ){
			if( !chk_throw_range( chr ) )
				break;

			if( chr->trgt.kind == TRGT_KIND_MNSTR )
				throw( chr, (mnstr_t *)(chr->trgt.p), NULL );
			else if( chr->trgt.kind == TRGT_KIND_MNSTR_NULL )
				act_throw_mnstr_null( chr );
			else
				clr_chr_trgt_act( chr, FALSE );
		} else {
			move_chr( chr );
		}
		break;
	case ACT_KIND_MBR_FIGHT:
		bash_or_move( chr );
		break;
	case ACT_KIND_MBR_THROW:
		if( flg ){
			if( !chk_throw_range( chr ) )
				break;

			if( chr->trgt.kind == TRGT_KIND_MBR )
				throw( chr, chr->trgt.p, NULL );
			else
				clr_chr_trgt_act( chr, FALSE );
		} else {
			move_chr( chr );
		}
		break;
	case ACT_KIND_DOOR_OPEN:
		if( flg ){
			chr_open_door( chr, chr->trgt.n );
		} else {
			move_chr( chr );
		}
		break;
	case ACT_KIND_DOOR_CLOSE:
		if( flg ){
			chr_close_door( chr, chr->trgt.n );
		} else {
			move_chr( chr );
		}
		break;
	case ACT_KIND_DOOR_JAM:
		if( flg ){
			chr_jam_door( chr, chr->trgt.n );
		} else {
			move_chr( chr );
		}
		break;
	case ACT_KIND_DOOR_DISARM:
		if( flg ){
			chr_disarm_door( chr, chr->trgt.n );
		} else {
			move_chr( chr );
		}
		break;
	case ACT_KIND_DOOR_BREAK:
		if( flg ){
			chr_break_door( chr, chr->trgt.n );
		} else {
			move_chr( chr );
		}
		break;
	case ACT_KIND_DOOR_PEEP:
		if( flg ){
			chr_peep_door( chr, chr->trgt.n );
		} else {
			move_chr( chr );
		}
		break;
	case ACT_KIND_DOOR_SRCH:
		if( flg ){
			chr_srch_door( chr, chr->trgt.n );
		} else {
			move_chr( chr );
		}
		break;
	case ACT_KIND_TRAP_DISARM:
		if( flg ){
			if( chr_disarm_trap( chr, chr->trgt.p ) ){
				clr_chr_trgt_act( chr, FALSE );
			}
		} else {
			move_chr( chr );
		}
		break;
	case ACT_KIND_TRAP_BREAK:
		if( flg ){
			if( chr_break_trap( chr, chr->trgt.p ) ){
				clr_chr_trgt_act( chr, FALSE );
			}
		} else {
			move_chr( chr );
		}
		break;
	case ACT_KIND_TRAP_SRCH:
		if( flg ){
			chr_srch_trap( chr, chr->trgt.p );
			clr_chr_trgt_act( chr, FALSE );
		} else {
			move_chr( chr );
		}
		break;
	case ACT_KIND_ITEM_PICK_UP:
		if( flg ){
			pick_up_item( chr, chr->x, chr->y );
			clr_chr_trgt_act( chr, FALSE );
		} else {
			move_chr( chr );
		}
		break;
	case ACT_KIND_ITEM_BREAK:
		if( flg ){
			if( chr_break_item( chr, chr->trgt.p ) ){
				clr_chr_trgt_act( chr, FALSE );
			}
		} else {
			move_chr( chr );
		}
		break;
	case ACT_KIND_ITEM_SRCH:
		if( flg ){
			chr_srch_item( chr, chr->trgt.p );
			clr_chr_trgt_act( chr, FALSE );
		} else {
			move_chr( chr );
		}
		break;
	case ACT_KIND_ITEM_SEND:
		if( flg ){
			send_item( chr );
			clr_chr_trgt_act( chr, FALSE );
		} else {
			move_chr( chr );
		}
		break;
	case ACT_KIND_ITEM_RECEIVE:
		if( flg ){
			receive_item( chr );
			clr_chr_trgt_act( chr, FALSE );
		} else {
			move_chr( chr );
		}
		break;
	case ACT_KIND_ITEM_DROP:
		drop_item( chr->x, chr->y, (item_t *)(chr->act.p),
				chr->act.n );
		clr_chr_trgt_act( chr, FALSE );
		break;
	case ACT_KIND_ITEM_OPEN:
		if( flg ){
			if( chr_open_item( (item_t *)(chr->trgt.p), chr ) ){
				clr_chr_trgt_act( chr, FALSE );
			}
		} else {
			move_chr( chr );
		}
		break;
	case ACT_KIND_ITEM_DISARM:
		if( flg ){
			if( chr_disarm_item( (item_t *)(chr->trgt.p),
					chr ) ){
				clr_chr_trgt_act( chr, FALSE );
			}
		} else {
			move_chr( chr );
		}
		break;
	case ACT_KIND_EQUIP_SEL:
		equip_item_sel( chr, (item_t *)chr->act.p );
		break;
	case ACT_KIND_EQUIP:
		equip_item( chr, (item_t *)chr->act.p,
				(equip_kind_t)chr->act.n );
		clr_chr_trgt_act( chr, FALSE );
		break;
	case ACT_KIND_TAKE_OFF:
		take_off_item( chr, (equip_kind_t)chr->act.n );
		clr_chr_trgt_act( chr, FALSE );
		break;
	case ACT_KIND_EQUIP_MBR:
		if( flg ){
			equip_item( (chr_t *)chr->act.p2,
					(item_t *)chr->act.p,
					(equip_kind_t)chr->act.n );
			clr_chr_trgt_act( chr, FALSE );
		} else {
			move_chr( chr );
		}
		break;
	case ACT_KIND_TAKE_OFF_MBR:
		if( flg ){
			take_off_item( (chr_t *)chr->act.p2,
					(equip_kind_t)chr->act.n );
			clr_chr_trgt_act( chr, FALSE );
		} else {
			move_chr( chr );
		}
		break;
	case ACT_KIND_POTION_QUAFF:
		quaff_potion( chr, (item_t *)chr->act.p, TRUE );
		clr_chr_trgt_act( chr, FALSE );
		break;
	case ACT_KIND_POTION_FILL:
		fill_potion( chr, (item_t *)chr->act.p );
		clr_chr_trgt_act( chr, FALSE );
		break;
	case ACT_KIND_SCROLL_READ:
		read_scroll( chr, (item_t *)chr->act.p );
		clr_chr_trgt_act( chr, FALSE );
		break;
	case ACT_KIND_STICK_ZAP:
		zap_stick( chr, (item_t *)chr->act.p );
		stop_zapping( chr );
		break;
	case ACT_KIND_FOOD_EAT:
		eat_food( chr, (item_t *)chr->act.p );
		clr_chr_trgt_act( chr, FALSE );
		break;
	case ACT_KIND_TOBACCO_DISPOSE:
		dispose_tobacco( chr, (item_t *)chr->act.p );
		clr_chr_trgt_act( chr, FALSE );
		break;
	case ACT_KIND_SRCH:
		if( (get_turn() % 2) == chr->act.n ){
			chr_srch_obj( chr );
		} else {
			move_chr( chr );
			if( (chr->x == chr->pre_x)
					&& (chr->y == chr->pre_y) ){
				chr_srch_obj( chr );
			}
		}
		break;
	case ACT_KIND_SPELL:
		chr_cast_spell( chr, (spell_tab_t *)(chr->act.p),
				(char *)(chr->act.p2) );
		clr_chr_trgt_act( chr, FALSE );
		break;
	}

	chk_trap( chr );

	if( chk_flg( chr->stat, FLG_STAT_VANISH ) )
		chr->flg_map |= FLG_MAP_CHR_INVISIBLE;

	if( chr->attitude == ATTITUDE_HOSTILE )
		chr->flg_map &= ~FLG_MAP_CHR_NPC;
	else
		chr->flg_map |= FLG_MAP_CHR_NPC;

	if( chr->kind == CHR_KIND_MNSTR )
		set_flg_find_mnstr( chr );

	draw_chr( chr );
}

/**/

bool_t	chk_can_act_chr( chr_t *chr )
{
	if( chr == NULL )
		return FALSE;

	if( chr->kind == CHR_KIND_MBR )
		return chk_can_act_mbr( chr );
	if( chr->kind == CHR_KIND_MNSTR )
		return chk_can_act_mnstr( chr );

	return FALSE;
}

/**/

void	bash_or_move( chr_t *chr )
{
	long	dx, dy;

	if( chr == NULL )
		return;

	if( chr->trgt.kind == TRGT_KIND_MBR ){
		mbr_t *p;

		p = (mbr_t *)(chr->trgt.p);
		dx = abs( chr->x - p->x );
		dy = abs( chr->y - p->y );

		if( chr->move.force_kind == MOVE_KIND_STAGGER )
			move_chr( chr );
		else if( (dx > 1) || (dy > 1) )
			move_chr( chr );
		else
			bash( chr, (chr_t *)(chr->trgt.p), NULL );
	} else if( chr->trgt.kind == TRGT_KIND_MNSTR ){
		mnstr_t *p;

		p = (mnstr_t *)(chr->trgt.p);
		dx = abs( chr->x - p->x );
		dy = abs( chr->y - p->y );

		if( chr->move.force_kind == MOVE_KIND_STAGGER )
			move_chr( chr );
		else if( (dx > 1) || (dy > 1) )
			move_chr( chr );
		else
			bash( chr, (chr_t *)(chr->trgt.p), NULL );
	} else if( chr->trgt.kind == TRGT_KIND_MNSTR_NULL ){
		dun_t	*dun = get_dun();
		mnstr_null_t *p;
		long	c;

		p = (mnstr_null_t *)(chr->trgt.p);
		dx = abs( chr->x - p->x );
		dy = abs( chr->y - p->y );

		if( (dx > 1) || (dy > 1) ){
			move_chr( chr );
			return;
		}

		c = dun->map.chr.mjr[p->y][p->x];
		if( c == FACE_MJR_NULL ){
			print_msg_mbr( chr, FLG_NULL, MSG_S,
					MSG_ERR_MNSTR_NULL );
			clr_chr_trgt_act( chr, FALSE );
		} else if( c == FACE_MJR_MBR ){
			chr_t	*chr2;

			chr2 = get_mbr( p->x, p->y );
			if( chr2 == NULL )
				return;

			chr->act.kind = ACT_KIND_MBR_FIGHT;
			mark_mbr( chr, chr2, DIST_NEAR );
			bash( chr, chr2, NULL );
		} else {
			mnstr_t	*mns;

			mns = get_mnstr( p->x, p->y );
			if( mns == NULL )
				return;

			mark_mnstr_dflt( chr, mns );
			bash( chr, mns, NULL );
		}
	} else {
		clr_chr_trgt_act( chr, FALSE );
	}
}

/**/

void	act_throw_mnstr_null( chr_t *chr )
{
	dun_t	*dun = get_dun();
	mnstr_null_t	*p;
	long	c;

	if( chr == NULL )
		return;
	if( chr->act.kind != ACT_KIND_MNSTR_THROW )
		return;
	if( chr->trgt.kind != TRGT_KIND_MNSTR_NULL )
		return;

	p = (mnstr_null_t *)(chr->trgt.p);
	c = dun->map.chr.mjr[p->y][p->x];

	if( c == FACE_MJR_NULL ){
		throw( chr, NULL, NULL );
		clr_chr_trgt_act( chr, FALSE );
	} else if( c == FACE_MJR_MBR ){
		chr_t	*chr2;

		chr2 = get_mbr( p->x, p->y );
		if( chr2 == NULL )
			return;

		chr->act.kind = ACT_KIND_MBR_THROW;
		mark_mbr( chr, chr2, DIST_NEAR );
		throw( chr, chr2, NULL );
	} else {
		mnstr_t	*mns;

		mns = get_mnstr( p->x, p->y );
		if( mns == NULL )
			return;

		mark_mnstr_dflt( chr, mns );
		throw( chr, mns, NULL );
	}
}

/**/

bool_t	chk_assist_chr( chr_t *chr )
{
	party_t	*pty = get_party();
	long	i;

	if( chr == NULL )
		return FALSE;
	if( chr->kind != CHR_KIND_MBR )
		return FALSE;

	for( i = 0; i < MBR_MAX_N; i++ ){
		if( chk_flg_or( pty->mbr[i]->stat,
				FLG_STAT_NOT_EXIST
				| FLG_STAT_DEAD
				| FLG_STAT_STONE
				| FLG_STAT_PARALYZE
				| FLG_STAT_CONFUSION
				| FLG_STAT_SLEEP
				| FLG_STAT_FAINT ) ){
			continue;
		}
		if( pty->mbr[i]->act.kind != ACT_KIND_MBR_TAIL )
			continue;
		if( pty->mbr[i]->trgt.kind != TRGT_KIND_MBR )
			continue;
		if( pty->mbr[i]->trgt.p != chr )
			continue;
		if( abs( pty->mbr[i]->x - chr->x ) > 1 )
			continue;
		if( abs( pty->mbr[i]->y - chr->y ) > 1 )
			continue;

		return TRUE;
	}
	return FALSE;
}

/**/

void	clr_map_chr( chr_t *chr )
{
	dun_t	*dun = get_dun();
	long	nx, ny;

	if( chr == NULL )
		return;

	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	nx = chr->x;
	ny = chr->y;
	if( !clip_pos( nx, ny ) )
		return;

	dun->map.chr.mjr[ny][nx] = FACE_MJR_NULL;
	dun->map.chr.mnr[ny][nx] = FACE_MNR_NULL;
	dun->map.chr.flg[ny][nx] = FLG_NULL;

	chr_light_up( chr, nx, ny, FALSE );
}

/**/

void	set_map_chr( chr_t *chr )
{
	dun_t	*dun = get_dun();
	long	nx, ny;

	if( chr == NULL )
		return;

	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	nx = chr->x;
	ny = chr->y;
	if( !clip_pos( nx, ny ) )
		return;

	dun->map.chr.mjr[ny][nx] = chr->face.mjr;
	dun->map.chr.mnr[ny][nx] = chr->face.mnr;
	dun->map.chr.flg[ny][nx] = chr->flg_map;

	chr_light_up( chr, nx, ny, TRUE );
}

/**/

void	move_chr( chr_t *chr )
{
	rate_t	rate;

	if( chr == NULL )
		return;

	if( !clip_pos( chr->x, chr->y ) )
		return;

	chr->pre_x = chr->x;
	chr->pre_y = chr->y;

	for( rate = get_move_rate( chr ); rate > _100_PERCENT;
			rate -= _100_PERCENT ){
		move_chr_sub( chr );
	}

	if( (rate > MODIFIED_MIN_RATE) && rate_randm( rate ) )
		move_chr_sub( chr );
}

/**/

void	move_chr_sub( chr_t *chr )
{
	move_kind_t kind;

	if( chr == NULL )
		return;

	chk_chr_force_move( chr );

	kind = chr->move.force_kind;
	if( kind == MOVE_KIND_NULL )
		kind = get_move_kind_rand( chr );

	switch( kind ){
	case MOVE_KIND_NULL:
	case MOVE_KIND_MAX_N:
		break;
	case MOVE_KIND_STOP:
		break;
	case MOVE_KIND_TOWNER:
		move_chr_towner( chr );
		break;
	case MOVE_KIND_STD:
		move_chr_std( chr );
		break;
	case MOVE_KIND_STAGGER:
		move_chr_stagger( chr );
		break;
	}

	if( chr->kind == CHR_KIND_MBR )
		find_obj( chr->x, chr->y );
}

/**/

void	move_chr_towner( chr_t *chr )
{
	long	nx, ny;
	long	i;

	if( chr == NULL )
		return;

	if( !rate_randm( TOWNER_MOVE_RATE ) )
		return;

	if( chr->act.kind == ACT_KIND_DOOR_OPEN ){
		move_chr_std( chr );
		return;
	}

	/* 錄򥯥ꥢ */
	clr_map_chr( chr );

	if( rate_randm( TOWNER_TURN_DIR_RATE ) )
		turn_dir_towner( chr );

	for( i = 0; i < 256; i++ ){
		if( chr->work.towner_dx == 0 ){
			if( chr->work.towner_dy == 0 ){
				turn_dir_towner( chr );
				continue;
			}
		}

		if( can_move_chr_towner( chr, 2 ) )
			if( can_move_chr_towner( chr, 1 ) )
				break;

		turn_dir_towner( chr );
	}

	nx = chr->x + sgn( chr->work.towner_dx ) * 1;
	ny = chr->y + sgn( chr->work.towner_dy ) * 1;
	if( can_move_chr( chr, nx, ny ) ){
		chr->x = nx;
		chr->y = ny;
	}

	set_map_chr( chr );
}

/**/

void	turn_dir_towner( chr_t *chr )
{
	chr->work.towner_dx = randm( 3 ) - 1;
	chr->work.towner_dy = randm( 3 ) - 1;
}

/**/

void	move_chr_std( chr_t *chr )
{
	dun_t	*dun;
	long	*xp, *yp;
	long	nx, ny;
	long	dx, dy;

	if( chr == NULL )
		return;

	if( chk_flg( chr->stat, FLG_STAT_CAUGHT ) )
		return;

	dun = get_dun();

	xp = &(chr->x);
	yp = &(chr->y);

	/* 錄򥯥ꥢ */
	clr_map_chr( chr );

	dx = chr->trgt.x - *xp;
	dy = chr->trgt.y - *yp;

	nx = *xp + sgn( dx );
	ny = *yp + sgn( dy );

	if( !can_move_chr( chr, nx, ny ) ){
		if( dx && dy ){
			if( abs( dx ) > abs( dy ) ){
				if( chk_auto_mnstr(
						chr, nx, *yp, *xp, ny ) ){
					dx = 0;
					dy = 0;
				} else if( can_move_chr( chr, nx, *yp ) ){
					dy = 0;
				} else if( can_move_chr( chr, *xp, ny ) ){
					dx = 0;
				} else if( chk_auto_door(
						chr, nx, *yp, *xp, ny ) ){
					dx = 0;
					dy = 0;
				}
			} else {
				if( chk_auto_mnstr(
						chr, *xp, ny, nx, *yp ) ){
					dx = 0;
					dy = 0;
				} else if( can_move_chr( chr, *xp, ny ) ){
					dx = 0;
				} else if( can_move_chr( chr, nx, *yp ) ){
					dy = 0;
				} else if( chk_auto_door(
						chr, *xp, ny, nx, *yp ) ){
					dx = 0;
					dy = 0;
				}
			}
		} else if( dx ){
			if( chk_auto_mnstr(
					chr, nx, *yp - 1, nx, *yp + 1 ) ){
				dx = 0;
				dy = 0;
			} else if( can_move_chr( chr, nx, *yp - 1 ) ){
				dy = -1;
			} else if( can_move_chr( chr, nx, *yp + 1 ) ){
				dy = +1;
			} else if( chk_auto_door(
					chr, nx, *yp - 1, nx, *yp + 1 ) ){
				dx = 0;
				dy = 0;
			}
		} else if( dy ){
			if( chk_auto_mnstr(
					chr, *xp - 1, ny, *xp + 1, ny ) ){
				dx = 0;
				dy = 0;
			} else if( can_move_chr( chr, *xp - 1, ny ) ){
				dx = -1;
			} else if( can_move_chr( chr, *xp + 1, ny ) ){
				dx = +1;
			} else if( chk_auto_door(
					chr, *xp - 1, ny, *xp + 1, ny ) ){
				dx = 0;
				dy = 0;
			}
		}
	}

	nx = *xp + sgn( dx );
	ny = *yp + sgn( dy );
	if( can_move_chr( chr, nx, ny ) ){
		if( chk_flg( dun->map.chr.flg[ny][nx], FLG_MAP_CHR_NPC ) ){
			chr_t	*npc;

			npc = get_pet( nx, ny );
			if( npc != NULL ){
				clr_map_chr( npc );
				npc->x = *xp;
				npc->y = *yp;
				set_map_chr( npc );
			}
		}

		*xp = nx;
		*yp = ny;
	}

	set_map_chr( chr );
}

/**/

void	chk_chr_force_move( chr_t *chr )
{
	if( chr == NULL )
		return;

	chr->move.force_kind = MOVE_KIND_NULL;

	if( chk_chr_stagger( chr ) )
		chr->move.force_kind = MOVE_KIND_STAGGER;
	if( chr->trgt.kind == TRGT_KIND_QUEUE )
		chr->move.force_kind = MOVE_KIND_STD;
}

/**/

bool_t	chk_chr_stagger( chr_t *chr )
{
	if( chk_chr_stagger_sub( chr, FLG_STAT_CONFUSION,
			STAGGER_RATE_CHR_CONFUSION ) ){
		return TRUE;
	}
	if( chk_chr_stagger_sub( chr, FLG_STAT_BLIND,
			STAGGER_RATE_CHR_BLIND ) ){
		return TRUE;
	}
	if( chk_chr_stagger_sub( chr, FLG_STAT_DRUNK,
			STAGGER_RATE_CHR_DRUNK ) ){
		return TRUE;
	}

	return FALSE;
}

/**/

bool_t	chk_chr_stagger_sub( chr_t *chr, flg_stat_t flg, long rate )
{
	if( chr == NULL )
		return FALSE;

	if( !chk_flg( chr->stat, flg ) )
		return FALSE;
	if( !rate_randm( rate ) )
		return FALSE;
	if( chk_assist_chr( chr ) )
		return FALSE;

	return TRUE;
}

/**/

void	move_chr_stagger( chr_t *chr )
{
	long	*xp, *yp;
	long	dx, dy;
	dun_t	*dun;
	long	i;

	if( chr == NULL )
		return;

	if( chk_flg( chr->stat, FLG_STAT_CAUGHT ) )
		return;

	dun = get_dun();
	xp = &(chr->x);
	yp = &(chr->y);

	/* 錄򥯥ꥢ */
	clr_map_chr( chr );

	for( i = 0; i < 64; i++ ){
		dx = randm( 3 ) - 1;
		dy = randm( 3 ) - 1;
		if( can_move_chr( chr, *xp + dx, *yp + dy ) ){
			*xp += dx;
			*yp += dy;
			break;
		}
	}

	set_map_chr( chr );
}

/**/

move_kind_t	get_move_kind_rand( chr_t *chr )
{
	move_ls_kind_t	ls_kind;
	ratio_t	sum, n;
	move_kind_t	ret;
	long	i;

	if( chr == NULL )
		return MOVE_KIND_NULL;

	/* ư롼פڤؤ */

	if( chr->kind == CHR_KIND_MBR ){
		ls_kind = MOVE_LS_KIND_FIND;
	} else {
		/* С򸫤ĤƤ뤫ɤڤؤ */
		if( chk_flg( chr->work.flg, FLG_WORK_FIND_MBR ) )
			ls_kind = MOVE_LS_KIND_FIND;
		else
			ls_kind = MOVE_LS_KIND_NOT_FIND;
	}

	/* ͤ */

	sum = 0;
	for( i = 0; i < MOVE_LS_MAX_N; i++ ){
		if( chr->move.ls[ls_kind][i].kind == MOVE_KIND_NULL )
			break;

		sum += chr->move.ls[ls_kind][i].ratio;
	}
	if( sum <= 0 )
		return MOVE_KIND_NULL;

	/* ˷ */

	n = randm( sum );

	/* ƬФ */

	ret = MOVE_KIND_NULL;
	sum = 0;
	for( i = 0; i < MOVE_LS_MAX_N; i++ ){
		if( chr->move.ls[ls_kind][i].kind == MOVE_KIND_NULL )
			break;

		sum += chr->move.ls[ls_kind][i].ratio;
		if( n < sum ){
			ret = chr->move.ls[ls_kind][i].kind;
			break;
		}
	}

	return ret;
}

/**/

bool_t	chk_auto_door( chr_t *chr, long x1, long y1, long x2, long y2 )
{
	if( chr->kind == CHR_KIND_MBR )
		return chk_auto_door_mbr( chr, x1, y1, x2, y2 );
	if( chr->kind == CHR_KIND_MNSTR )
		return chk_auto_door_mnstr( chr, x1, y1, x2, y2 );

	return FALSE;
}

/**/

bool_t	can_move_chr( chr_t *chr, long x, long y )
{
	dun_t	*dun = get_dun();

	if( !clip_pos( x, y ) )
		return FALSE;

	do {
		if( dun->map.obj.mjr[y][x] != FACE_MJR_TRAP )
			break;
		if( dun->map.chr.mjr[y][x] != FACE_MJR_NULL )
			break;
		if( chr != NULL ){
			if( chr->trgt.kind != TRGT_KIND_POS )
				break;
			if( chr->trgt.true_x != x )
				break;
			if( chr->trgt.true_y != y )
				break;
		}

		/* 虜櫤˳ݤ˹Ԥ */
		return TRUE;
	} while( 0 );

	do {
		if( dun->map.obj.mjr[y][x] != FACE_MJR_TRAP )
			break;
		if( chr != NULL ){
			if( chr->kind == CHR_KIND_MBR ){
				if( chk_flg( dun->map.obj.flg[y][x],
						FLG_MAP_OBJ_LOOK_FLOOR ) ){
					break;
				}
				if( chk_flg( dun->map.obj.flg[y][x],
						FLG_MAP_OBJ_LOOK_WALL ) ){
					break;
				}
			}
			if( chk_flg( chr->stat, FLG_STAT_FLY ) )
				break;
			if( !chk_flg( chr->flg_chr, FLG_CHR_AVOID_TRAP ) )
				break;
		}

		/* ưŪ櫤򤱤 */
		return FALSE;
	} while( 0 );

	do {
		if( !chk_flg( dun->map.obj.flg[y][x], FLG_MAP_OBJ_PASS ) )
			break;
		if( dun->map.chr.mjr[y][x] != FACE_MJR_NULL )
			break;

		/* ̤̤ */
		return TRUE;
	} while( 0 );

	do {
		if( chr != NULL ){
			if( !chk_flg( chr->flg_chr, FLG_CHR_PASSWALL ) )
				break;
		}
		if( dun->map.chr.mjr[y][x] != FACE_MJR_NULL )
			break;

		/* ȴǽϤͭ */
		return TRUE;
	} while( 0 );

	do {
		if( !chk_flg( dun->map.obj.flg[y][x], FLG_MAP_OBJ_PASS ) )
			break;
		if( !chk_flg( dun->map.chr.flg[y][x], FLG_MAP_CHR_NPC ) )
			break;
		if( chr == NULL )
			break;
		if( chr->kind != CHR_KIND_MBR )
			break;
		if( get_pet( x, y ) == NULL )
			break;

		/* ڥåȤ줫 */
		return TRUE;
	} while( 0 );

	return FALSE;
}

/**/

bool_t	can_move_chr_towner( chr_t *chr, long d )
{
	long	nx, ny;

	nx = chr->x + sgn( chr->work.towner_dx ) * d;
	ny = chr->y + sgn( chr->work.towner_dy ) * d;

	return can_move_chr( chr, nx, ny );
}

/**/

void	set_chr_pos( chr_t *chr, long x, long y )
{
	long	r;
	long	i;

	for( r = 0; r < MAP_MAX_X; r++ ){
		for( i = 0; i < 128; i++ ){
			long	xx, yy;

			xx = x + randm( r * 2 + 1 ) - r;
			yy = y + randm( r * 2 + 1 ) - r;
			if( can_move_chr( chr, xx, yy ) ){
				chr->x = xx;
				chr->y = yy;
				set_map_chr( chr );
				return;
			}
		}
	}

	chr->x = randm( MAP_MAX_X );
	chr->y = randm( MAP_MAX_Y );
	set_map_chr( chr );
}

/**/

void	die_chr( chr_t *p, bool_t flg_add_exp )
{
	dun_t	*dun = get_dun();
	long	x, y;

	if( p == NULL )
		return;

	do {
		if( !flg_add_exp )
			break;
		if( p->kind != CHR_KIND_MNSTR )
			break;
		if( p->attitude != ATTITUDE_HOSTILE )
			break;
		if( p->mnstr_tab == NULL )
			break;

		exp_party( calc_mnstr_exp( p, dun->lev ), TRUE );
	} while( 0 );

	/* 錄򥯥ꥢ */
	x = p->x;
	y = p->y;
	clr_map_chr( p );
	draw_map( x - 1, y - 1, 3, 3 );
	draw_mbr_stat( p );

	p->stat |= FLG_STAT_DEAD;

	lost_trgt( p );
	clr_chr_trgt_act( p, TRUE );
	free_fx_all( &(p->fx) );

	if( p->kind == CHR_KIND_MBR )
		die_mbr( p );
	else if( p->kind == CHR_KIND_MNSTR )
		die_mnstr( p );
}

/**/

void	act_chr_auto_door( chr_t *chr, long x, long y )
{
	door_t	*dr;

	if( chr == NULL )
		return;

	dr = get_door( x, y );
	if( dr == NULL )
		return;

	if( chr->x < (dr->x - 1) )
		return;
	if( (dr->x + dr->dx - 1 + 1) < chr->x )
		return;
	if( chr->y < (dr->y - 1) )
		return;
	if( (dr->y + dr->dy - 1 + 1) < chr->y )
		return;

	chr_open_door( chr, dr->n );
}

/**/

bool_t	chr_open_door( chr_t *chr, long dr_n )
{
	dun_t	*dun = get_dun();

	if( chr == NULL )
		return FALSE;

	lost_trgt( chr );
	clr_chr_trgt_act( chr, FALSE );

	if( chk_discount_door( &(dun->door[dr_n]) ) ){
		if( chk_discount() ){
			if( !chk_discount_open() ){
				mark_queue( chr, TRUE );
				return FALSE;
			}
		}
	}

	if( dun->lev == 0 ){
		if( chr->kind != CHR_KIND_MBR ){
			chr_enter_door( chr, &(dun->door[dr_n]) );
			return TRUE;
		}
	}

	if( chk_flg( dun->door[dr_n].flg, FLG_DOOR_OPEN ) )
		return FALSE;

	open_door( dr_n );

	if( chk_flg( dun->door[dr_n].flg, FLG_DOOR_JAMMED )
			&& !chk_flg( dun->door[dr_n].flg,
			FLG_DOOR_OPEN ) ){
		print_msg_mbr( chr, FLG_NULL, MSG_ERR_DOOR_OPEN_JAMMED );
		return FALSE;
	} else if( chk_flg( dun->door[dr_n].flg, FLG_DOOR_GATE ) ){
		print_msg( FLG_NULL, MSG_ERR_DOOR_GATE );
		return FALSE;
	} else if( !chk_flg( dun->door[dr_n].flg, FLG_DOOR_OPEN ) ){
		return FALSE;
	}
	print_msg_mbr( chr, FLG_NULL, MSG_DOOR_OPEN, chr->name );

	return TRUE;
}

/**/

bool_t	chr_close_door( chr_t *chr, long dr_n )
{
	dun_t	*dun = get_dun();

	if( chr == NULL )
		return FALSE;

	clr_chr_trgt_act( chr, FALSE );

	if( !chk_flg( dun->door[dr_n].flg, FLG_DOOR_OPEN ) )
		return FALSE;

	close_door( dr_n );

	if( chk_flg( dun->door[dr_n].flg, FLG_DOOR_BROKEN ) ){
		print_msg_mbr( chr, FLG_NULL, MSG_ERR_DOOR_CLOSE_BROKEN );
		return FALSE;
	} else if( chk_flg( dun->door[dr_n].flg, FLG_DOOR_JAMMED ) ){
		print_msg_mbr( chr, FLG_NULL, MSG_ERR_DOOR_CLOSE_JAMMED );
		return FALSE;
	} else if( chk_flg( dun->door[dr_n].flg, FLG_DOOR_OPEN ) ){
		return FALSE;
	}
	print_msg_mbr( chr, FLG_NULL, MSG_DOOR_CLOSE, chr->name );

	return TRUE;
}

/**/

bool_t	chr_jam_door( chr_t *chr, long dr_n )
{
	item_t	*item = NULL;

	if( chr == NULL )
		return FALSE;

	clr_chr_trgt_act( chr, FALSE );

	if( chr->kind == CHR_KIND_MBR ){
		item = get_item_mbr( chr->mbr_n, ITEM_KIND_SPIKE );
		if( item == NULL ){
			print_msg_mbr( chr, FLG_NULL, MSG_ERR_DOOR_JAM_SPIKE,
					MSG_SPIKE );
			return FALSE;
		}
	}

	if( !jam_door( dr_n ) )
		return FALSE;

	if( chr->kind == CHR_KIND_MBR ){
		print_msg_mbr( chr, FLG_NULL, MSG_DOOR_JAM, chr->name );
		inc_item( item, -1 );
	}

	return TRUE;
}

/**/

bool_t	chr_disarm_door( chr_t *chr, long dr_n )
{
	rate_t	rate;

	if( chr == NULL )
		return FALSE;

	rate = get_lev( chr, ABL_KIND_THI ) * DOOR_DISARM_RATE_MUL_N;
	rate += DOOR_DISARM_RATE_ADD_N;
	if( !rate_randm( rate ) ){
		print_msg_mbr( chr, FLG_NULL, MSG_ERR_DOOR_DISARM_LEV );
		return FALSE;
	}

	clr_chr_trgt_act( chr, FALSE );

	if( !disarm_door( dr_n ) )
		return FALSE;

	print_msg_mbr( chr, FLG_NULL, MSG_DOOR_DISARM, chr->name );

	return TRUE;
}

/**/

void	chr_peep_door( chr_t *chr, long dr_n )
{
	if( chr->kind == CHR_KIND_MBR )
		mbr_peep_door( chr, dr_n );
}

/**/

void	chr_srch_door( chr_t *chr, long dr_n )
{
	clr_chr_trgt_act( chr, FALSE );

	if( chr->kind == CHR_KIND_MBR )
		mbr_srch_door( chr, dr_n );
}

/**/

bool_t	chr_disarm_trap( chr_t *chr, trap_t *trap )
{
	if( chr == NULL )
		return TRUE;
	if( trap == NULL )
		return TRUE;
	if( trap->tab == NULL )
		return TRUE;

	if( chr_roll( chr, ABL_KIND_THI, ABL_KIND_DEX, trap->difficulty ) ){
		disarm_trap( trap );
		print_msg_mbr( chr, FLG_NULL, MSG_TRAP_DISARM,
				chr->name, trap->tab->name );
		return TRUE;
	}

	if( !rate_randm( TRAP_DISARM_FAILURE_RATE ) ){
		print_msg_mbr( chr, FLG_NULL, MSG_ERR_TRAP_DISARM_LEV );
		return FALSE;
	}

	caught_trap( trap, chr );

	return TRUE;
}

/**/

void	chr_srch_trap( chr_t *chr, trap_t *trap )
{
	if( chr->kind == CHR_KIND_MBR )
		mbr_srch_trap( chr, trap );
}

/**/

bool_t	chr_open_item( item_t *item, chr_t *chr )
{
	if( item == NULL )
		return TRUE;
	if( chr == NULL )
		return TRUE;
	if( item->kind != ITEM_KIND_CHEST )
		return TRUE;

	open_item( item, chr );

	print_msg_mbr( chr, FLG_NULL, MSG_ITEM_OPEN, chr->name, item->name );

	return TRUE;
}

/**/

bool_t	chr_disarm_item( item_t *item, chr_t *chr )
{
	if( item == NULL )
		return TRUE;
	if( chr == NULL )
		return TRUE;
	if( item->kind != ITEM_KIND_CHEST )
		return TRUE;
	if( item->dat.chest.trap == NULL ){
		print_msg_mbr( chr, FLG_NULL, MSG_ITEM_DISARM_ALREADY,
				item->name );
		return TRUE;
	}

	if( chr_roll( chr, ABL_KIND_THI, ABL_KIND_DEX,
			item->dat.chest.trap->difficulty ) ){
		if( disarm_item( item ) ){
			print_msg_mbr( chr, FLG_NULL, MSG_ITEM_DISARM,
					chr->name, item->name );
		}
		return TRUE;
	}

	if( !rate_randm( ITEM_DISARM_FAILURE_RATE ) ){
		print_msg_mbr( chr, FLG_NULL, MSG_ERR_ITEM_DISARM_LEV );
		return FALSE;
	}

	chk_trap_chest( item, chr, _100_PERCENT );
	return TRUE;
}

/**/

void	chr_srch_item( chr_t *chr, item_t *item )
{
	if( chr->kind == CHR_KIND_MBR )
		mbr_srch_item( chr, item );
}

/**/

void	chr_srch_obj( chr_t *chr )
{
	if( chr->kind == CHR_KIND_MBR )
		mbr_srch_obj( chr );
}

/**/

void	chr_enter_door( chr_t *chr, door_t *dr )
{
	if( chr == NULL )
		return;
	if( dr == NULL )
		return;

	lost_trgt( chr );

	clr_map_chr( chr );
	chr->x = MAP_DEL_X;
	chr->y = MAP_DEL_Y;

	chr->work.enter_door = dr;
}

/**/

void	move_chr_trgt( chr_t *chr )
{
	party_t	*pty = get_party();
	square_t	*sq;
	long	mx, my;
	door_t	*dr;
	bool_t	flg_x, flg_y;
	long	x, y;
	long	trgt_n;
	long	trgt_x, trgt_y;

	if( chr == NULL )
		return;

	sq = get_square( chr );

	switch( chr->trgt.kind ){
	case TRGT_KIND_NULL:
	case TRGT_KIND_AUTO:
	case TRGT_KIND_MAX_N:
		return;
	case TRGT_KIND_SQUARE:
		chr->trgt.x = sq->x + sq->chr_pos[chr->mbr_n].x;
		chr->trgt.y = sq->y + sq->chr_pos[chr->mbr_n].y;
		chr->trgt.true_x = chr->trgt.x;
		chr->trgt.true_y = chr->trgt.y;
		break;
	case TRGT_KIND_MBR:
		if( chr->trgt.p == NULL )
			break;
		trgt_n = chr->trgt.n;

		if( chk_flg_or( ((chr_t *)(chr->trgt.p))->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			trgt_x = sq->x + sq->chr_pos[trgt_n].x;
			trgt_y = sq->y + sq->chr_pos[trgt_n].y;
		} else {
			trgt_x = pty->mbr[trgt_n]->x;
			trgt_y = pty->mbr[trgt_n]->y;
		}
		chr->trgt.true_x = trgt_x;
		chr->trgt.true_y = trgt_y;

		switch( chr->trgt.dist ){
		case DIST_NEAR:
			chr->trgt.x = trgt_x;
			chr->trgt.y = trgt_y;

			if( (abs( chr->trgt.x - chr->x ) <= 1)
					&& (abs( chr->trgt.y - chr->y )
					<= 1) ){
				chr->trgt.x = chr->x;
				chr->trgt.y = chr->y;
			}
			break;
		case DIST_MEDIUM:
			x = sq->x + sq->chr_pos[chr->mbr_n].x;
			x += trgt_x;
			x /= 2;
			y = sq->y + sq->chr_pos[chr->mbr_n].y;
			y += trgt_y;
			y /= 2;
			chr->trgt.x = x;
			chr->trgt.y = y;
			break;
		case DIST_FAR:
			chr->trgt.x = sq->x + sq->chr_pos[chr->mbr_n].x;
			chr->trgt.y = sq->y + sq->chr_pos[chr->mbr_n].y;
			break;
		}
		break;
	case TRGT_KIND_MNSTR:
		if( !chk_flg( ((mnstr_t *)chr->trgt.p)->flg_map,
				FLG_MAP_CHR_FIND) ){
			clr_chr_trgt_act( chr, FALSE );
			break;
		}

		chr->trgt.true_x = ((mnstr_t *)chr->trgt.p)->x;
		chr->trgt.true_y = ((mnstr_t *)chr->trgt.p)->y;

		switch( chr->trgt.dist ){
		case DIST_NEAR:
			chr->trgt.x = ((mnstr_t *)chr->trgt.p)->x;
			chr->trgt.y = ((mnstr_t *)chr->trgt.p)->y;

			if( (abs( chr->trgt.x - chr->x ) <= 1)
					&& (abs( chr->trgt.y - chr->y )
					<= 1) ){
				chr->trgt.x = chr->x;
				chr->trgt.y = chr->y;
			}
			break;
		case DIST_MEDIUM:
			x = sq->x + sq->chr_pos[chr->mbr_n].x;
			x += ((mnstr_t *)chr->trgt.p)->x;
			x /= 2;
			y = sq->y + sq->chr_pos[chr->mbr_n].y;
			y += ((mnstr_t *)chr->trgt.p)->y;
			y /= 2;
			chr->trgt.x = x;
			chr->trgt.y = y;

			if( (abs( chr->trgt.x - chr->x ) <= 1)
					&& (abs( chr->trgt.y
					- chr->y ) <= 1) ){
				chr->trgt.x = chr->x;
				chr->trgt.y = chr->y;
			}
			break;
		case DIST_FAR:
			chr->trgt.x = sq->x + sq->chr_pos[chr->mbr_n].x;
			chr->trgt.y = sq->y + sq->chr_pos[chr->mbr_n].y;
			break;
		}
		break;
	case TRGT_KIND_MNSTR_NULL:
		chr->trgt.true_x = ((mnstr_null_t *)chr->trgt.p)->x;
		chr->trgt.true_y = ((mnstr_null_t *)chr->trgt.p)->y;

		switch( chr->trgt.dist ){
		case DIST_NEAR:
			chr->trgt.x = ((mnstr_null_t *)chr->trgt.p)->x;
			chr->trgt.y = ((mnstr_null_t *)chr->trgt.p)->y;

			if( (abs( chr->trgt.x - chr->x ) <= 1)
					&& (abs( chr->trgt.y - chr->y )
					<= 1) ){
				chr->trgt.x = chr->x;
				chr->trgt.y = chr->y;
			}
			break;
		case DIST_MEDIUM:
			x = sq->x + sq->chr_pos[chr->mbr_n].x;
			x += ((mnstr_null_t *)chr->trgt.p)->x;
			x /= 2;
			y = sq->y + sq->chr_pos[chr->mbr_n].y;
			y += ((mnstr_null_t *)chr->trgt.p)->y;
			y /= 2;
			chr->trgt.x = x;
			chr->trgt.y = y;

			if( (abs( chr->trgt.x - chr->x ) <= 1)
					&& (abs( chr->trgt.y - chr->y )
					<= 1) ){
				chr->trgt.x = chr->x;
				chr->trgt.y = chr->y;
			}
			break;
		case DIST_FAR:
			chr->trgt.x = sq->x + sq->chr_pos[chr->mbr_n].x;
			chr->trgt.y = sq->y + sq->chr_pos[chr->mbr_n].y;
			break;
		}
		break;
	case TRGT_KIND_TRAP:
		chr->trgt.true_x = ((trap_t *)chr->trgt.p)->x;
		chr->trgt.true_y = ((trap_t *)chr->trgt.p)->y;
		chr->trgt.x = chr->trgt.true_x;
		chr->trgt.y = chr->trgt.true_y;
		if( (abs( chr->trgt.x - chr->x ) <= 1)
				&& (abs( chr->trgt.y - chr->y ) <= 1) ){
			chr->trgt.x = chr->x;
			chr->trgt.y = chr->y;
		}
		break;
	case TRGT_KIND_ITEM:
		break;
	case TRGT_KIND_DOOR:
		mx = chr->x;
		my = chr->y;
		dr = chr->trgt.p;
		flg_x = FALSE;
		flg_y = FALSE;

		/* ɥΣ֥åȤʤ */
		if( mx < dr->x ){
			chr->trgt.x = dr->x - 1;
		} else if( (dr->x + dr->dx - 1) < mx ){
			chr->trgt.x = (dr->x + dr->dx - 1) + 1;
		} else {
			chr->trgt.x = chr->x;
			flg_x = TRUE;
		}
		if( my < dr->y ){
			chr->trgt.y = dr->y - 1;
		} else if( (dr->y + dr->dy - 1) < my ){
			chr->trgt.y = (dr->y + dr->dy - 1) + 1;
		} else {
			chr->trgt.y = chr->y;
			flg_y = TRUE;
		}
		if( flg_x && flg_y ){	/* ɥ˵ */
			chr->trgt.x = dr->x - 1;
			chr->trgt.y = dr->y - 1;
		}
		break;
	case TRGT_KIND_QUEUE:
		if( chr->trgt.p != NULL ){
			pos_t	*q;

			q = (pos_t *)(chr->trgt.p);
			chr->trgt.x = q->x;
			chr->trgt.y = q->y;
		}
		break;
	case TRGT_KIND_POS:
		break;
	}
}

/**/

bool_t	chk_auto_mark_cont( chr_t *chr )
{
	if( chr == NULL )
		return FALSE;

	if( chk_flg( chr->flg_chr, FLG_CHR_AUTO_MARK_CONT ) ){
		exec_menu_auto_mark( chr );
		if( chr->act.kind == ACT_KIND_NULL )
			chr->flg_chr &= ~FLG_CHR_AUTO_MARK_CONT;

		return TRUE;
	}

	return FALSE;
}

/**/

void	clr_chr_trgt_act( chr_t *chr, bool_t flg_force )
{
	if( chr == NULL )
		return;

	if( flg_force || !chk_auto_mark_cont( chr ) ){
		clr_chr_trgt( chr );
		clr_chr_act( chr );
	}
}

/**/

void	clr_chr_trgt( chr_t *chr )
{
	if( chr == NULL )
		return;

	if( chr->kind == CHR_KIND_MBR ){
		mark_square( chr );
	} else if( chr->owner != NULL ){
		mark_mbr( chr, chr->owner, DIST_NEAR );
	} else {
		mark_pos( chr, chr->x, chr->y, DIST_NEAR );
	}
}

/**/

bool_t	set_chr_act(
	chr_t *chr, act_kind_t kind,
	void *p, void *p2,
	long n, long n2
)
{
	char	*msg;
	item_t	*item;

	if( chr == NULL )
		return FALSE;

	msg = MSG_NULL;
	switch( kind ){
	case ACT_KIND_NULL:
		msg = MSG_ACT_NULL;
		break;
	case ACT_KIND_MNSTR_FIGHT:
		msg = MSG_ACT_MNSTR_FIGHT;
		break;
	case ACT_KIND_MNSTR_THROW:
		msg = MSG_ACT_MNSTR_THROW;
		break;
	case ACT_KIND_MNSTR_TAIL:
		msg = MSG_ACT_MNSTR_TAIL;
		break;
	case ACT_KIND_MBR_FIGHT:
		msg = MSG_ACT_MBR_FIGHT;
		break;
	case ACT_KIND_MBR_THROW:
		msg = MSG_ACT_MBR_THROW;
		break;
	case ACT_KIND_MBR_TAIL:
		msg = MSG_ACT_MBR_TAIL;
		break;
	case ACT_KIND_DOOR_OPEN:
		msg = MSG_ACT_DOOR_OPEN;
		break;
	case ACT_KIND_DOOR_CLOSE:
		msg = MSG_ACT_DOOR_CLOSE;
		break;
	case ACT_KIND_DOOR_JAM:
		msg = MSG_ACT_DOOR_JAM;
		break;
	case ACT_KIND_DOOR_DISARM:
		msg = MSG_ACT_DOOR_DISARM;
		break;
	case ACT_KIND_DOOR_BREAK:
		msg = MSG_ACT_DOOR_BREAK;
		break;
	case ACT_KIND_DOOR_PEEP:
		msg = MSG_ACT_DOOR_PEEP;
		break;
	case ACT_KIND_DOOR_SRCH:
		msg = MSG_ACT_DOOR_SRCH;
		break;
	case ACT_KIND_TRAP_DISARM:
		msg = MSG_ACT_TRAP_DISARM;
		break;
	case ACT_KIND_TRAP_BREAK:
		msg = MSG_ACT_TRAP_BREAK;
		break;
	case ACT_KIND_TRAP_SRCH:
		msg = MSG_ACT_TRAP_SRCH;
		break;
	case ACT_KIND_ITEM_PICK_UP:
		msg = MSG_ACT_ITEM_PICK_UP;
		break;
	case ACT_KIND_ITEM_BREAK:
		msg = MSG_ACT_ITEM_BREAK;
		break;
	case ACT_KIND_ITEM_SRCH:
		msg = MSG_ACT_ITEM_SRCH;
		break;
	case ACT_KIND_ITEM_SEND:
		msg = MSG_ACT_ITEM_SEND;
		break;
	case ACT_KIND_ITEM_DROP:
		msg = MSG_ACT_ITEM_DROP;
		break;
	case ACT_KIND_ITEM_RECEIVE:
		msg = MSG_ACT_ITEM_RECEIVE;
		break;
	case ACT_KIND_ITEM_OPEN:
		msg = MSG_ACT_ITEM_OPEN;
		break;
	case ACT_KIND_ITEM_DISARM:
		msg = MSG_ACT_ITEM_DISARM;
		break;
	case ACT_KIND_EQUIP_SEL:
		msg = MSG_ACT_EQUIP;
		item = (item_t *)p;
		if( chr->kind == CHR_KIND_MBR ){
			if( item == NULL )
				return FALSE;
			if( !chk_equip_two_handed_wpn( chr, item,
					item->equip_kind ) ){
				return FALSE;
			}
		}
		break;
	case ACT_KIND_EQUIP:
		msg = MSG_ACT_EQUIP;
		item = (item_t *)p;
		if( chr->kind == CHR_KIND_MBR ){
			if( !chk_equip_two_handed_wpn( chr, item,
					item->equip_kind ) ){
				return FALSE;
			}
		}
		break;
	case ACT_KIND_TAKE_OFF:
		msg = MSG_ACT_TAKE_OFF;
		break;
	case ACT_KIND_EQUIP_MBR:
		msg = MSG_ACT_EQUIP_MBR;
		item = (item_t *)p;
		if( chr->kind == CHR_KIND_MBR ){
			if( !chk_equip_two_handed_wpn( (chr_t *)p2, item,
					item->equip_kind ) ){
				return FALSE;
			}
		}
		break;
	case ACT_KIND_TAKE_OFF_MBR:
		msg = MSG_ACT_TAKE_OFF_MBR;
		break;
	case ACT_KIND_POTION_QUAFF:
		msg = MSG_ACT_POTION_QUAFF;
		break;
	case ACT_KIND_POTION_FILL:
		msg = MSG_ACT_POTION_FILL;
		break;
	case ACT_KIND_SCROLL_READ:
		msg = MSG_ACT_SCROLL_READ;
		break;
	case ACT_KIND_STICK_ZAP:
		msg = MSG_ACT_STICK_ZAP;
		break;
	case ACT_KIND_FOOD_EAT:
		msg = MSG_ACT_FOOD_EAT;
		break;
	case ACT_KIND_TOBACCO_DISPOSE:
		msg = MSG_ACT_TOBACCO_DISPOSE;
		break;
	case ACT_KIND_SRCH:
		msg = MSG_ACT_SRCH;
		break;
	case ACT_KIND_SPELL:
		msg = ((spell_tab_t *)p)->name;
		break;
	case ACT_KIND_SHOP:
	case ACT_KIND_RECALL:
	case ACT_KIND_MAX_N:
		return FALSE;
	}

	chr->act.kind = kind;
	strncpy( chr->act.msg, msg, ACT_MSG_MAX_LEN );
	chr->act.p = p;
	chr->act.p2 = p2;
	chr->act.n = n;
	chr->act.n2 = n2;

	switch( kind ){
	case ACT_KIND_MNSTR_FIGHT:
	case ACT_KIND_MNSTR_THROW:
	case ACT_KIND_MNSTR_TAIL:
		chr->act.dflt_kind_mnstr = chr->act.kind;
		strncpy( chr->act.dflt_msg_mnstr, chr->act.msg,
				ACT_MSG_MAX_LEN );
		break;
	default:
		break;
	}

	draw_mbr_stat( chr );

	return TRUE;
}

/**/

void	clr_chr_act( chr_t *chr )
{
	if( chr == NULL )
		return;

	chr->act.kind = ACT_KIND_NULL;
	strncpy( chr->act.msg, MSG_ACT_NULL, ACT_MSG_MAX_LEN );

	draw_mbr_stat( chr );
}

/**/

void	lost_trgt( void *p )
{
	party_t	*pty = get_party();
	mnstr_t	*mns_head, *mns_p;
	pet_t	**party_pet = get_party_pet();
	long	i;

	for( i = 0; i < MBR_MAX_N; i++ ){
		mbr_t	*pp;

		pp = pty->mbr[i];

		if( chk_flg_or( pp->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		if( p == pp->trgt.p )
			clr_chr_trgt_act( pp, FALSE );
		if( p == pp->act.p )
			clr_chr_trgt_act( pp, FALSE );
	}

	mns_head = get_mnstr_used();
	for( mns_p = mns_head->next->next; mns_p != NULL;
			mns_p = mns_p->next ){
		mnstr_t	*pp;

		pp = mns_p->prev;
		if( pp == mns_head )
			break;

		if( chk_flg_or( pp->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		if( p == pp->trgt.p )
			clr_chr_trgt_act( pp, FALSE );
		if( p == pp->act.p )
			clr_chr_trgt_act( pp, FALSE );
	}

	for( i = 0; i < PET_MAX_N; i++ ){
		pet_t	*pp;

		pp = party_pet[i];

		if( pp == NULL )
			continue;
		if( chk_flg_or( pp->stat,
				FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
			continue;
		}

		if( p == pp->trgt.p )
			clr_chr_trgt_act( pp, FALSE );
		if( p == pp->act.p )
			clr_chr_trgt_act( pp, FALSE );

		if( p == pp->owner )
			clr_pet_owner( pp );
	}
}

/**/

void	mark_mbr( chr_t *chr1, mbr_t *mbr2, dist_t dist )
{
	if( chr1 == NULL )
		return;
	if( mbr2 == NULL )
		return;
	if( chk_flg_or( chr1->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	chr1->trgt.kind = TRGT_KIND_MBR;
	chr1->trgt.p = mbr2;
	chr1->trgt.n = mbr2->mbr_n;
	chr1->trgt.x = mbr2->x;
	chr1->trgt.y = mbr2->y;
	chr1->trgt.true_x = mbr2->x;
	chr1->trgt.true_y = mbr2->y;
	chr1->trgt.dist = dist;
}

/**/

void	mark_mnstr_no_regist( chr_t *chr, mnstr_t *mnstr, dist_t dist )
{
	if( chr == NULL )
		return;
	if( mnstr == NULL )
		return;
	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	chr->trgt.kind = TRGT_KIND_MNSTR;
	chr->trgt.p = mnstr;
	chr->trgt.n = 0;
	chr->trgt.x = mnstr->x;
	chr->trgt.y = mnstr->y;
	chr->trgt.true_x = chr->trgt.x;
	chr->trgt.true_y = chr->trgt.y;
	chr->trgt.dist = dist;

	print_msg_mbr( chr, FLG_MSG_NO_MORE_PREV
			| FLG_MSG_NO_MORE_NEXT,
			MSG_FMT_MARK_MNSTR,
			chr->name, mnstr->name );
}

/**/

void	mark_mnstr_dflt( chr_t *chr, mnstr_t *mnstr )
{
	if( chr == NULL )
		return;
	if( mnstr == NULL )
		return;
	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	mark_mnstr_no_regist( chr, mnstr, chr->trgt.dflt_dist_mnstr );
}

/**/

void	mark_mnstr( chr_t *chr, mnstr_t *mnstr, dist_t dist )
{
	if( chr == NULL )
		return;
	if( mnstr == NULL )
		return;
	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	if( chk_queue_chr( mnstr ) ){
		if( chk_discount() ){
			if( !chk_discount_open() ){
				mark_queue( chr, TRUE );
				return;
			}
		}
	}

	mark_mnstr_no_regist( chr, mnstr, dist );
	chr->trgt.dflt_dist_mnstr = dist;
}

/**/

void	mark_mnstr_null_no_regist( chr_t *chr, long x, long y, dist_t dist )
{
	if( chr == NULL )
		return;
	if( chr->kind != CHR_KIND_MBR )
		return;
	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	mnstr_null[chr->mbr_n].x = x;
	mnstr_null[chr->mbr_n].y = y;

	chr->trgt.kind = TRGT_KIND_MNSTR_NULL;
	chr->trgt.p = &(mnstr_null[chr->mbr_n]);
	chr->trgt.n = 0;
	chr->trgt.x = mnstr_null[chr->mbr_n].x;
	chr->trgt.y = mnstr_null[chr->mbr_n].y;
	chr->trgt.true_x = chr->trgt.x;
	chr->trgt.true_y = chr->trgt.y;
	chr->trgt.dist = dist;
}

/**/

void	mark_mnstr_null_dflt( chr_t *chr, long x, long y )
{
	if( chr == NULL )
		return;
	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	mark_mnstr_null_no_regist( chr, x, y, chr->trgt.dflt_dist_mnstr );
}

/**/

void	mark_mnstr_null( chr_t *chr, long x, long y, dist_t dist )
{
	if( chr == NULL )
		return;
	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	mark_mnstr_null_no_regist( chr, x, y, dist );
	chr->trgt.dflt_dist_mnstr = dist;
}

/**/

void	mark_item( chr_t *chr, item_t *item, dist_t dist )
{
	if( chr == NULL )
		return;
	if( item == NULL )
		return;
	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	chr->trgt.kind = TRGT_KIND_ITEM;
	chr->trgt.p = (void *)item;
	chr->trgt.n = 0;
	chr->trgt.x = item->x;
	chr->trgt.y = item->y;
	chr->trgt.true_x = chr->trgt.x;
	chr->trgt.true_y = chr->trgt.y;
	chr->trgt.dist = dist;
}

/**/

void	mark_door( chr_t *chr, door_t *dr, dist_t dist )
{
	if( chr == NULL )
		return;
	if( dr == NULL )
		return;
	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	if( chk_discount_door( dr ) ){
		if( chk_discount() ){
			if( !chk_discount_open() ){
				mark_queue( chr, TRUE );
				return;
			}
		}
	}

	chr->trgt.kind = TRGT_KIND_DOOR;
	chr->trgt.p = dr;
	chr->trgt.n = dr->n;
	chr->trgt.x = dr->x;
	chr->trgt.y = dr->y;
	chr->trgt.true_x = chr->trgt.x;
	chr->trgt.true_y = chr->trgt.y;
	chr->trgt.dist = dist;
}

/**/

void	mark_trap( chr_t *chr, trap_t *trap, dist_t dist )
{
	if( chr == NULL )
		return;
	if( trap == NULL )
		return;
	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	chr->trgt.kind = TRGT_KIND_TRAP;
	chr->trgt.p = trap;
	chr->trgt.n = 0;
	chr->trgt.x = trap->x;
	chr->trgt.y = trap->y;
	chr->trgt.true_x = chr->trgt.x;
	chr->trgt.true_y = chr->trgt.y;
	chr->trgt.dist = dist;
}

/**/

void	mark_queue( chr_t *chr, bool_t flg_all_mbr )
{
	pos_t	*q;
	long	qn;

	if( chr == NULL )
		return;
	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	if( flg_all_mbr && (chr->kind == CHR_KIND_MBR) ){
		party_t	*pty = get_party();
		long	i;

		for( i = 0; i < MBR_MAX_N; i++ ){
			mark_queue( pty->mbr[i], FALSE );
		}
		return;
	}

	if( chr->trgt.kind == TRGT_KIND_QUEUE )
		return;

	q = get_queue_tail( chr );
	if( q == NULL )
		return;
	qn = get_queue_n( chr );
	if( qn <= -1 )
		return;

	clr_chr_act( chr );

	chr->trgt.kind = TRGT_KIND_QUEUE;
	chr->trgt.p = q;
	chr->trgt.n = qn;
	chr->trgt.x = q->x;
	chr->trgt.y = q->y;
	chr->trgt.true_x = chr->trgt.x;
	chr->trgt.true_y = chr->trgt.y;
	chr->trgt.dist = DIST_NEAR;

	inc_queue_n( chr );
}

/**/

void	mark_square( chr_t *chr )
{
	party_t	*pty = get_party();

	if( chr == NULL )
		return;
	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	chr->trgt.kind = TRGT_KIND_SQUARE;
	chr->trgt.p = &(pty->square);
	chr->trgt.n = 0;
	chr->trgt.x = pty->square.x + pty->square.chr_pos[chr->mbr_n].x;
	chr->trgt.y = pty->square.y + pty->square.chr_pos[chr->mbr_n].y;
	chr->trgt.true_x = chr->trgt.x;
	chr->trgt.true_y = chr->trgt.y;
	chr->trgt.dist = DIST_NEAR;
}

/**/

void	mark_pos( chr_t *chr, long x, long y, dist_t dist )
{
	if( chr == NULL )
		return;
	if( chk_flg_or( chr->stat, FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) )
		return;

	chr->trgt.kind = TRGT_KIND_POS;
	chr->trgt.p = NULL;
	chr->trgt.n = 0;
	chr->trgt.x = x;
	chr->trgt.y = y;
	chr->trgt.true_x = chr->trgt.x;
	chr->trgt.true_y = chr->trgt.y;
	chr->trgt.dist = dist;
}

/**/

void	stop_zapping( chr_t *chr )
{
	if( chr == NULL )
		return;

	clr_chr_trgt_act( chr, FALSE );
}

/**/

void	chr_srch_begin( chr_t *chr )
{
	if( chr == NULL )
		return;

	set_chr_act( chr, ACT_KIND_SRCH, NULL, NULL, get_turn() % 2, 0 );
}

/**/

void	chr_srch_end( chr_t *chr )
{
	if( chr == NULL )
		return;

	if( chr->act.kind == ACT_KIND_SRCH )
		clr_chr_trgt_act( chr, FALSE );
}

/**/

bool_t	chk_infra_vision( chr_t *chr )
{
	if( chr == NULL )
		return FALSE;

	if( chr->fx_data.infra_vision > 0 )
		return TRUE;

	if( chr->kind == CHR_KIND_MBR ){
		switch( chr->race.main ){
		case MAIN_RACE_HUMAN:
		case MAIN_RACE_HALF_ELF:
		case MAIN_RACE_VIVID:
			return FALSE;
		case MAIN_RACE_ELF:
		case MAIN_RACE_DWARF:
			return TRUE;
		case MAIN_RACE_MAX_N:
			return FALSE;
		}
	}

	return FALSE;
}

/**/

bool_t	chr_light_up( chr_t *chr, long x, long y, bool_t flg_on )
{
	long	dx, dy;
	dun_t	*dun;

	dun = get_dun();

	if( chr == NULL )
		return FALSE;

	if( !clip_pos( x, y ) )
		return FALSE;

	if( flg_on && chk_flg_or( chr->stat,
			FLG_STAT_NOT_EXIST | FLG_STAT_DEAD ) ){
		return FALSE;
	}

	if( chr->kind == CHR_KIND_MBR ){
		if( !chk_infra_vision( chr ) ){
			item_t	*lit;

			if( chr->kind != CHR_KIND_MBR )
				return FALSE;

			lit = &(get_mbr_item_asgn_equip( chr )
					[EQUIP_KIND_LIGHT_SOURCE]);
			if( lit->kind != ITEM_KIND_LIGHT )
				return FALSE;
			if( lit->dat.light.turn <= 0 )
				return FALSE;
		}
	} else if( chr->kind == CHR_KIND_MNSTR ){
		if( chk_flg( chr->flg_chr, FLG_CHR_LIGHT ) ){
			;
		} else if( chk_flg( chr->flg_chr, FLG_CHR_DARK ) ){
			flg_on = !flg_on;
		} else {
			return FALSE;
		}
	}

	for( dy = -1; dy <= +1; dy++ ){
		long	yy;

		yy = y + dy;
		if( !clip_y( yy ) )
			continue;

		for( dx = -1; dx <= +1; dx++ ){
			long	xx;

			xx = x + dx;
			if( !clip_x( xx ) )
				continue;

			turn_light_chr( xx, yy, flg_on );

			if( calc_light_depth( xx, yy ) <= 0 )
				continue;
			if( !flg_on )
				continue;
			if( chr->kind != CHR_KIND_MBR ){
				if( !chk_flg( dun->map.chr.flg[y][x],
						FLG_MAP_CHR_FIND ) ){
					continue;
				}
			}

			dun->map.obj.flg[yy][xx] |= FLG_MAP_OBJ_FIND;
		}
	}

	return TRUE;
}

/**/

void	exp_chr(
	chr_t *chr, long exp,
	bool_t flg_print_exp,
	bool_t flg_print_lev
)
{
	long	i, n, mod_n;
	class_t	*class_tab;
	rate_t	rate;
	long	exp_add, exp_mod;

	if( chr == NULL )
		return;

	if( flg_print_exp ){
		if( exp >= 0 )
			curs_attrset_n( CURS_ATTR_N_FX_MBR_PLUS );
		else
			curs_attrset_n( CURS_ATTR_N_FX_MBR_MINUS );
		print_msg( FLG_NULL, MSG_EXP_MBR, chr->name, exp );
		curs_attrset_dflt();
	}

	if( chr->kind != CHR_KIND_MBR ){
		exp_chr_mnstr( chr, exp, flg_print_lev );
		return;
	}

	class_tab = get_class_tab();
	if( class_tab == NULL )
		return;

	rate = 0;
	for( i = 0; i < ABL_KIND_MAX_N; i++ )
		rate += class_tab[chr->class_n].abl_rate[i];
	if( rate != _100_PERCENT ){
		print_msg( FLG_NULL, MSG_ERR_CLASS_NOT_100_PERCENT,
				class_tab[chr->class_n].name );
		return;
	}

	exp_mod = exp;
	n = 0;
	mod_n = 0;
	for( i = 0; i < ABL_KIND_MAX_N; i++ ){
		rate = class_tab[chr->class_n].abl_rate[i];
		if( rate > 0 ){
			n++;
			if( randm( n ) == 0 )
				mod_n = i;
		}
		exp_add = exp * rate / _100_PERCENT;
		exp_mod -= exp_add;
		
	}
	for( i = 0; i < ABL_KIND_MAX_N; i++ ){
		long	exp_n;

		rate = class_tab[chr->class_n].abl_rate[i];
		exp_add = exp * rate / _100_PERCENT;

		if( i == mod_n )
			exp_n = exp_add + exp_mod;
		else
			exp_n = exp_add;

		chr->abl.exp[i].n += exp_n;
		if( chr->abl.exp[i].n < 0 )
			chr->abl.exp[i].n = 0;

		if( chr->abl.exp[i].max < chr->abl.exp[i].n )
			chr->abl.exp[i].max = chr->abl.exp[i].n;
	}

	chk_up_lev( chr, flg_print_lev );
}

/**/

void	chk_up_lev( chr_t *chr, bool_t flg_draw )
{
	long	i, j;
	long	need_exp;

	if( chr == NULL )
		return;

	for( i = 0; i < ABL_KIND_MAX_N; i++ ){
		for( j = 0; j < 1024; j++ ){
			need_exp = calc_need_exp( get_lev( chr, i ) + 1, i );
			if( chr->abl.exp[i].n < need_exp )
				break;
			up_lev( chr, i, +1, flg_draw );
		}
		for( j = 0; j < 1024; j++ ){
			need_exp = calc_need_exp( get_lev( chr, i ) - 0, i );
			if( chr->abl.exp[i].n >= need_exp )
				break;
			up_lev( chr, i, -1, flg_draw );
		}
	}

	chr->abl.hp.max = calc_max_hp( chr );
	chr->abl.hp.n = chr->abl.hp.max;

	chr->abl.mp.max = calc_max_mp( chr );
	chr->abl.mp.n = chr->abl.mp.max;
}

/**/

void	up_lev( chr_t *chr, abl_kind_t abl, long add, bool_t flg_draw )
{
	if( chr == NULL )
		return;

	chr->abl.lev[abl].n += add;
	if( chr->abl.lev[abl].max < chr->abl.lev[abl].n )
		chr->abl.lev[abl].max = chr->abl.lev[abl].n;

	if( flg_draw ){
		if( add > 0 ){
			curs_attrset_n( CURS_ATTR_N_FX_MBR_PLUS );
			print_msg( FLG_NULL, MSG_LEV_UP,
					chr->name,
					get_abl_name( abl ),
					get_lev( chr, abl ) );
		}
		if( add < 0 ){
			curs_attrset_n( CURS_ATTR_N_FX_MBR_MINUS );
			print_msg( FLG_NULL, MSG_LEV_DOWN,
					chr->name,
					get_abl_name( abl ),
					get_lev( chr, abl ) );
		}
		curs_attrset_dflt();
	}
}

/**/

void	set_modifier( chr_t *chr )
{
	long	i;

	if( chr == NULL )
		return;

	/* ꥻå */

	chr->face.mjr = chr->face.mjr_org;
	chr->face.mnr = chr->face.mnr_org;
	chr->sex.cur = chr->sex.org;

	chr->fx_data.armor_def = 0;
	chr->fx_data.armor_crtcl = 0;
	chr->fx_data.armor_ac = 0;

	for( i = 0; i < ABL_KIND_MAX_N; i++ )
		chr->abl.lev[i].add = 0;
	for( i = 0; i < RESI_KIND_MAX_N; i++ )
		chr->resi[i].add_n = 0;

	chr->move.speed.n = 0;
	chr->fx_data.stomach.digest_n = 0;
	chr->work.teleport_n = 0;
	chr->work.teleport_party_n = 0;
	chr->fx_data.bless = 0;

	/* ̤׻ */

	calc_modifier_equip( chr );

	/* θ̤򥻥å */

	if( chr->modifier_equip.face_mjr != FACE_MJR_NULL )
		chr->face.mjr = chr->modifier_equip.face_mjr;
	if( chr->modifier_equip.face_mnr != FACE_MNR_NULL )
		chr->face.mnr = chr->modifier_equip.face_mnr;
	if( chr->modifier_equip.sex != SEX_NULL )
		chr->sex.cur = chr->modifier_equip.sex;

	chr->fx_data.armor_def += chr->modifier_equip.armor_def;
	chr->fx_data.armor_crtcl += chr->modifier_equip.armor_crtcl;
	chr->fx_data.armor_ac += chr->modifier_equip.armor_ac;

	for( i = 0; i < ABL_KIND_MAX_N; i++ )
		chr->abl.lev[i].add += chr->modifier_equip.add_lev[i];
	for( i = 0; i < RESI_KIND_MAX_N; i++ )
		chr->resi[i].add_n += chr->modifier_equip.add_resi_n[i];

	chr->move.speed.n += chr->modifier_equip.add_move_speed;
	chr->fx_data.stomach.digest_n
			+= chr->modifier_equip.stomach_digest_n;
	chr->work.teleport_n
			+= chr->modifier_equip.teleport_n;
	chr->work.teleport_party_n
			+= chr->modifier_equip.teleport_party_n;

	if( chr->modifier_equip.bless != 0 )
		chr->fx_data.bless = chr->modifier_equip.bless;

	/* եȤͤ򥻥å */

	if( chr->modifier_fx.face_mjr != FACE_MJR_NULL )
		chr->face.mjr = chr->modifier_fx.face_mjr;
	if( chr->modifier_fx.face_mnr != FACE_MNR_NULL )
		chr->face.mnr = chr->modifier_fx.face_mnr;
	if( chr->modifier_fx.sex != SEX_NULL )
		chr->sex.cur = chr->modifier_fx.sex;

	chr->fx_data.armor_def += chr->modifier_fx.armor_def;
	chr->fx_data.armor_crtcl += chr->modifier_fx.armor_crtcl;
	chr->fx_data.armor_ac += chr->modifier_fx.armor_ac;

	for( i = 0; i < ABL_KIND_MAX_N; i++ )
		chr->abl.lev[i].add += chr->modifier_fx.add_lev[i];
	for( i = 0; i < RESI_KIND_MAX_N; i++ )
		chr->resi[i].add_n += chr->modifier_fx.add_resi_n[i];

	chr->move.speed.n += chr->modifier_fx.add_move_speed;
	chr->fx_data.stomach.digest_n
			+= chr->modifier_fx.stomach_digest_n;
	chr->work.teleport_n
			+= chr->modifier_fx.teleport_n;
	chr->work.teleport_party_n
			+= chr->modifier_fx.teleport_party_n;

	if( chr->modifier_equip.bless != 0 )
		chr->fx_data.bless = chr->modifier_equip.bless;

	/**/

	chr->abl.hp.max = calc_max_hp( chr );
	chr->abl.mp.max = calc_max_mp( chr );

	set_move_rate( chr );
}

/**/

bool_t	calc_modifier_equip( chr_t *chr )
{
	item_t	*eq;
	equip_kind_t	i, j;
	modifier_t	*src, *dst;

	if( chr == NULL )
		return FALSE;

	if( !reset_modifier( &(chr->modifier_equip) ) )
		return FALSE;
	if( chr->kind != CHR_KIND_MBR )
		return FALSE;

	eq = get_mbr_item_asgn_equip( chr );
	dst = &(chr->modifier_equip);
	for( i = 0; i < EQUIP_KIND_MAX_N; i++ ){
		if( eq[i].kind == ITEM_KIND_NULL )
			continue;

		src = &(eq[i].modifier);

		if( src->face_mjr != FACE_MJR_NULL )
			dst->face_mjr = src->face_mjr;
		if( src->face_mnr != FACE_MNR_NULL )
			dst->face_mnr = src->face_mnr;
		if( src->sex != SEX_NULL )
			dst->sex = src->sex;

		dst->armor_def += src->armor_def;
		dst->armor_crtcl += src->armor_crtcl;
		dst->armor_ac += src->armor_ac;

		for( j = 0; j < ABL_KIND_MAX_N; j++ )
			dst->add_lev[j] += src->add_lev[j];
		for( j = 0; j < RESI_KIND_MAX_N; j++ )
			dst->add_resi_n[j] += src->add_resi_n[j];

		dst->add_move_speed += src->add_move_speed;
		dst->stomach_digest_n += src->stomach_digest_n;
		dst->teleport_n += src->teleport_n;
		dst->teleport_party_n += src->teleport_party_n;

		if( src->bless != 0 )
			dst->bless = src->bless;
	}

	return TRUE;
}

/**/

bool_t	reset_modifier( modifier_t *m )
{
	long	i;

	if( m == NULL )
		return FALSE;

	m->face_mjr = FACE_MJR_NULL;
	m->face_mnr = FACE_MNR_NULL;
	m->sex = SEX_NULL;

	m->armor_def = 0;
	m->armor_crtcl = 0;
	m->armor_ac = 0;

	for( i = 0; i < ABL_KIND_MAX_N; i++ )
		m->add_lev[i] = 0;
	for( i = 0; i < RESI_KIND_MAX_N; i++ )
		m->add_resi_n[i] = 0;

	m->add_move_speed = 0;
	m->stomach_digest_n = 0;
	m->teleport_n = 0;
	m->teleport_party_n = 0;

	m->bless = 0;

	return TRUE;
}

/**/

bool_t	get_modifier_equip( chr_t *chr, modifier_t *m )
{
	if( chr == NULL )
		return FALSE;
	if( m == NULL )
		return FALSE;

	*m = chr->modifier_equip;

	return TRUE;
}

/**/

bool_t	set_modifier_equip( chr_t *chr, modifier_t *m )
{
	if( chr == NULL )
		return FALSE;
	if( m == NULL )
		return FALSE;

	chr->modifier_equip = *m;

	set_modifier( chr );

	return TRUE;
}

/**/

bool_t	get_modifier_fx( chr_t *chr, modifier_t *m )
{
	if( chr == NULL )
		return FALSE;
	if( m == NULL )
		return FALSE;

	*m = chr->modifier_fx;

	return TRUE;
}

/**/

bool_t	set_modifier_fx( chr_t *chr, modifier_t *m )
{
	if( chr == NULL )
		return FALSE;
	if( m == NULL )
		return FALSE;

	chr->modifier_fx = *m;

	set_modifier( chr );

	return TRUE;
}

/**/

rate_t	set_move_rate( chr_t *chr )
{
	chr->move.speed.rate = modified_rate( chr->move.speed.rate_org,
			chr->move.speed.n );

	return chr->move.speed.rate;
}

/**/

rate_t	get_move_rate( chr_t *chr )
{
	return chr->move.speed.rate;
}

/**/

char	*get_abl_name( abl_kind_t kind )
{
	switch( kind ){
	case ABL_KIND_HP:
		return MSG_ABL_NAME_HP;
	case ABL_KIND_MP:
		return MSG_ABL_NAME_MP;
	case ABL_KIND_DEX:
		return MSG_ABL_NAME_DEX;
	case ABL_KIND_STR:
		return MSG_ABL_NAME_STR;
	case ABL_KIND_AGI:
		return MSG_ABL_NAME_AGI;
	case ABL_KIND_WIS:
		return MSG_ABL_NAME_WIS;
	case ABL_KIND_INT:
		return MSG_ABL_NAME_INT;
	case ABL_KIND_CHA:
		return MSG_ABL_NAME_CHA;
	case ABL_KIND_FIG:
		return MSG_ABL_NAME_FIG;
	case ABL_KIND_MON:
		return MSG_ABL_NAME_MON;
	case ABL_KIND_HUN:
		return MSG_ABL_NAME_HUN;
	case ABL_KIND_THI:
		return MSG_ABL_NAME_THI;
	case ABL_KIND_MAG:
		return MSG_ABL_NAME_MAG;
	case ABL_KIND_SOR:
		return MSG_ABL_NAME_SOR;
	case ABL_KIND_ENC:
		return MSG_ABL_NAME_ENC;
	case ABL_KIND_SUM:
		return MSG_ABL_NAME_SUM;
	case ABL_KIND_PRI:
		return MSG_ABL_NAME_PRI;
	case ABL_KIND_SHA:
		return MSG_ABL_NAME_SHA;
	case ABL_KIND_BAR:
		return MSG_ABL_NAME_BAR;
	case ABL_KIND_NIN:
		return MSG_ABL_NAME_NIN;
	case ABL_KIND_MAX_N:
		break;
	}

	return MSG_NULL;
}

/**/

abl_kind_t	get_sub_abl( abl_kind_t abl_main )
{
	switch( abl_main ){
	case ABL_KIND_HP:
		return ABL_KIND_HP;
	case ABL_KIND_MP:
		return ABL_KIND_MP;
	case ABL_KIND_DEX:
		return ABL_KIND_DEX;
	case ABL_KIND_STR:
		return ABL_KIND_STR;
	case ABL_KIND_AGI:
		return ABL_KIND_AGI;
	case ABL_KIND_WIS:
		return ABL_KIND_WIS;
	case ABL_KIND_INT:
		return ABL_KIND_INT;
	case ABL_KIND_CHA:
		return ABL_KIND_CHA;
	case ABL_KIND_FIG:
		return ABL_KIND_FIG;
	case ABL_KIND_MON:
		return ABL_KIND_MON;
	case ABL_KIND_HUN:
		return ABL_KIND_HUN;
	case ABL_KIND_THI:
		return ABL_KIND_THI;
	case ABL_KIND_MAG:
		return ABL_KIND_INT;
	case ABL_KIND_SOR:
		return ABL_KIND_INT;
	case ABL_KIND_ENC:
		return ABL_KIND_INT;
	case ABL_KIND_SUM:
		return ABL_KIND_INT;
	case ABL_KIND_PRI:
		return ABL_KIND_WIS;
	case ABL_KIND_SHA:
		return ABL_KIND_CHA;
	case ABL_KIND_BAR:
		return ABL_KIND_CHA;
	case ABL_KIND_NIN:
		return ABL_KIND_NIN;
	case ABL_KIND_MAX_N:
		break;
	}

	return ABL_KIND_HP;
}

/**/

long	calc_lev_to_exp( long org_lev, abl_kind_t abl )
{
	long	lev;
	long	n;

	if( org_lev <= 0 )
		return 0;

	lev = org_lev;
	if( lev > FLAT_LEV )
		lev = FLAT_LEV;

	n = lev * lev;

	n *= lev_to_exp_tab[abl].mul_lev;
	n /= _100_PERCENT;
	n *= lev_to_exp_val.mul_lev;
	n /= _100_PERCENT;

	n += lev_to_exp_tab[abl].add_lev;
	n += lev_to_exp_val.add_lev;

	if( org_lev > FLAT_LEV ){
		long	exp1, exp2;

		exp1 = calc_lev_to_exp( FLAT_LEV - 1, abl );
		exp2 = calc_lev_to_exp( FLAT_LEV, abl );
		n += (exp2 - exp1) * (org_lev - FLAT_LEV);
	}

	return n;
}

/**/

long	calc_need_exp( long lev, abl_kind_t abl )
{
	return calc_lev_to_exp( lev, abl );
}

/**/

long	get_lev( chr_t *chr, abl_kind_t abl )
{
	if( chr == NULL )
		return 0;

	return( chr->abl.lev[abl].n + chr->abl.lev[abl].add );
}

/**/

long	get_lev_max( chr_t *chr, abl_kind_t abl )
{
	if( chr == NULL )
		return 0;

	return chr->abl.lev[abl].max;
}

/**/

rate_t	get_resi( chr_t *chr, resi_kind_t resi )
{
	if( chr == NULL )
		return _100_PERCENT;

	return modified_rate( chr->resi[resi].n, chr->resi[resi].add_n );
}

/**/

bool_t	chk_modified_lev( chr_t *chr, abl_kind_t abl )
{
	if( chr == NULL )
		return TRUE;

	if( chr->abl.lev[abl].add != 0 )
		return TRUE;
	if( chr->abl.lev[abl].n != chr->abl.lev[abl].max )
		return TRUE;

	return FALSE;
}

/**/

long	calc_lev_to_val( long lev, abl_kind_t abl )
{
	long	mul, add;
	long	val;

	mul = lev_to_val_tab[abl].mul_lev;
	add = lev_to_val_tab[abl].add_lev;

	val = lev * mul / _100_PERCENT;
	val += add;

	if( val < 1 )
		val = 1;

	return val;
}

/**/

long	calc_max_hp( chr_t *chr )
{
	if( chr == NULL )
		return 1;

	return calc_lev_to_val( get_lev( chr, ABL_KIND_HP ), ABL_KIND_HP );
}

/**/

long	calc_max_mp( chr_t *chr )
{
	if( chr == NULL )
		return 1;

	return calc_lev_to_val( get_lev( chr, ABL_KIND_MP ), ABL_KIND_MP );
}

/**/

long	calc_resi( rate_t resi, long n )
{
	if( resi < 1)
		resi = 1;

	return( (n * _100_PERCENT) / resi );
}

/**/

long	get_generalist_lev( chr_t *p )
{
	long	lev;
	long	i;

	if( p == NULL )
		return 1;

	lev = 0;
	for( i = 0; i < ABL_KIND_MAX_N; i++ )
		lev += get_lev( p, i );
	lev /= ABL_KIND_MAX_N;

	if( lev < 1 )
		lev = 1;

	return lev;
}

/**/

long	get_specialist_lev( chr_t *p )
{
	long	lev;
	long	i;

	if( p == NULL )
		return 1;

	lev = 1;
	for( i = 0; i < ABL_KIND_MAX_N; i++ )
		lev = max( lev, get_lev( p, i ) );

	return lev;
}

/**/

long	add_hp( chr_t *p, long n )
{
	long	ret = 0;

	if( p == NULL )
		return 0;

	if( p->kind == CHR_KIND_MBR )
		ret = add_hp_mbr( p, n );
	else if( p->kind == CHR_KIND_MNSTR )
		ret = add_hp_mnstr( p, n );

	return ret;
}

/**/

long	add_mp( chr_t *chr, long n )
{
	long	pre_mp, add;

	if( chr == NULL )
		return 0;

	pre_mp = chr->abl.mp.n;

	chr->abl.mp.n += n;
	if( chr->abl.mp.n > chr->abl.mp.max )
		chr->abl.mp.n = chr->abl.mp.max;
	if( chr->abl.mp.n < 0 )
		chr->abl.mp.n = 0;

	add = chr->abl.mp.n - pre_mp;
	if( add != 0 ){
		vfx_num( chr, add );
		draw_mbr_stat( chr );
	}

	return chr->abl.mp.n;
}

/**/

gold_t	get_chr_gold( chr_t *chr )
{
	if( chr == NULL )
		return 0;

	return chr->gold;
}

/**/

gold_t	add_chr_gold( chr_t *chr, gold_t gold )
{
	if( chr == NULL )
		return 0;

	chr->gold += gold;

	return chr->gold;
}

/**/

square_t	*get_square( chr_t *chr )
{
	if( chr->kind == CHR_KIND_MBR ){
		return get_square_mbr();
	} else if( chr->kind == CHR_KIND_MNSTR ){
		return( &mnstr_square );
	}

	return NULL;
}

/**/

void	set_square( chr_t *chr, square_t *sq )
{
	if( chr->kind == CHR_KIND_MBR ){
		set_square_mbr( sq );
	} else if( chr->kind == CHR_KIND_MNSTR ){
		mnstr_square = *sq;
	}
}

/**/

char	*get_trgt_name( trgt_t *trgt )
{
	if( trgt == NULL )
		return MSG_MNSTR_UNKNOWN;
	if( trgt->p == NULL )
		return MSG_MNSTR_UNKNOWN;

	switch( trgt->kind ){
	case TRGT_KIND_NULL:
		return MSG_MNSTR_UNKNOWN;
	case TRGT_KIND_MBR:
		return ((mbr_t *)trgt->p)->name;
	case TRGT_KIND_MNSTR:
		return ((mnstr_t *)trgt->p)->name;
	case TRGT_KIND_MNSTR_NULL:
		return MSG_MNSTR_UNKNOWN;
	case TRGT_KIND_ITEM:
		return ((item_t *)trgt->p)->name;
	case TRGT_KIND_DOOR:
		return MSG_MENU_SEL_OBJ_DOOR;
	case TRGT_KIND_TRAP:
		return MSG_MENU_SEL_OBJ_TRAP;
	case TRGT_KIND_QUEUE:
		return MSG_MNSTR_UNKNOWN;
	case TRGT_KIND_SQUARE:
		return MSG_MENU_SEL_OBJ_SQUARE;
	case TRGT_KIND_POS:
		return MSG_MNSTR_UNKNOWN;
	case TRGT_KIND_AUTO:
	case TRGT_KIND_MAX_N:
		return MSG_MNSTR_UNKNOWN;
	}

	return MSG_MNSTR_UNKNOWN;
}

/**/

trgt_kind_t	get_trgt_kind_from_chr( chr_t *chr )
{
	if( chr == NULL )
		return TRGT_KIND_NULL;

	switch( chr->kind ){
	case CHR_KIND_NULL:
		return TRGT_KIND_NULL;
	case CHR_KIND_MBR:
		return TRGT_KIND_MBR;
	case CHR_KIND_MNSTR:
		return TRGT_KIND_MNSTR;
	}

	return TRGT_KIND_NULL;
}

/**/

chr_kind_t	get_chr_kind_from_trgt( trgt_t *trgt )
{
	if( trgt == NULL )
		return CHR_KIND_NULL;

	switch( trgt->kind ){
	case TRGT_KIND_NULL:
		break;
	case TRGT_KIND_MBR:
		return CHR_KIND_MBR;
	case TRGT_KIND_MNSTR:
		return CHR_KIND_MNSTR;
	case TRGT_KIND_MNSTR_NULL:
	case TRGT_KIND_ITEM:
	case TRGT_KIND_DOOR:
	case TRGT_KIND_TRAP:
	case TRGT_KIND_QUEUE:
	case TRGT_KIND_SQUARE:
	case TRGT_KIND_POS:
	case TRGT_KIND_AUTO:
	case TRGT_KIND_MAX_N:
		break;
	}

	return CHR_KIND_NULL;
}

/**/

bool_t	cmp_chr( chr_t *p1, chr_t *p2 )
{
	abl_kind_t	abl;
	resi_kind_t	resi;

	if( p1->kind != p2->kind )
		return FALSE;
	if( strcmp( p1->name, p2->name ) != 0 )
		return FALSE;
#if	0
	if( p1->mbr_n != p2->mbr_n )
		return FALSE;
	if( p1->ls_mbr_n != p2->ls_mbr_n )
		return FALSE;
#endif
	if( p1->face.mjr != p2->face.mjr )
		return FALSE;
	if( p1->face.mnr != p2->face.mnr )
		return FALSE;
#if	0
	if( p1->face.mjr_org != p2->face.mjr_org )
		return FALSE;
	if( p1->face.mnr_org != p2->face.mnr_org )
		return FALSE;
#endif
	if( p1->race.main != p2->race.main )
		return FALSE;
	if( p1->race.sub != p2->race.sub )
		return FALSE;
	if( strcmp( p1->race.name, p2->race.name ) != 0 )
		return FALSE;
	if( p1->sex.cur != p2->sex.cur )
		return FALSE;
#if	0
	if( p1->sex.org != p2->sex.org )
		return FALSE;
#endif
#if	0
	if( p1->x != p2->x )
		return FALSE;
	if( p1->y != p2->y )
		return FALSE;
	if( p1->pre_x != p2->pre_x )
		return FALSE;
	if( p1->pre_y != p2->pre_y )
		return FALSE;
#endif
	if( p1->move.speed.rate != p2->move.speed.rate )
		return FALSE;
	if( p1->move.speed.rate_org != p2->move.speed.rate_org )
		return FALSE;
	if( p1->move.speed.n != p2->move.speed.n )
		return FALSE;
	if( p1->move.force_kind != p2->move.force_kind )
		return FALSE;
#if	0
	if( p1->move.ls[] != p2->move.ls[] )
		return FALSE;
#endif

	if( p1->gold != p2->gold )
		return FALSE;
	if( p1->dun_max_lev_floor != p2->dun_max_lev_floor )
		return FALSE;
	if( p1->dun_max_lev_base != p2->dun_max_lev_base )
		return FALSE;
#if	0
	if( p1->trgt != p2->trgt )
		return FALSE;
	if( p1->act != p2->act )
		return FALSE;
#endif
	if( p1->flg_chr != p2->flg_chr )
		return FALSE;
	if( p1->flg_map != p2->flg_map )
		return FALSE;
	if( p1->attitude != p2->attitude )
		return FALSE;
	if( p1->owner != p2->owner )
		return FALSE;
	if( p1->stat != p2->stat )
		return FALSE;
	for( abl = 0; abl < ABL_KIND_MAX_N; abl++ ){
		if( p1->abl.exp[abl].n != p2->abl.exp[abl].n )
			return FALSE;
		if( p1->abl.exp[abl].max != p2->abl.exp[abl].max )
			return FALSE;
		if( p1->abl.lev[abl].n != p2->abl.lev[abl].n )
			return FALSE;
		if( p1->abl.lev[abl].max != p2->abl.lev[abl].max )
			return FALSE;
#if	0
		if( p1->abl.lev[abl].add != p2->abl.lev[abl].add )
			return FALSE;
#endif
	}
	if( p1->abl.hp.n != p2->abl.hp.n )
		return FALSE;
	if( p1->abl.hp.max != p2->abl.hp.max )
		return FALSE;
	if( p1->abl.mp.n != p2->abl.mp.n )
		return FALSE;
	if( p1->abl.mp.max != p2->abl.mp.max )
		return FALSE;

	if( p1->class_n != p2->class_n )
		return FALSE;

	for( resi = 0; resi < RESI_KIND_MAX_N; resi++ ){
		if( p1->resi[resi].n != p2->resi[resi].n )
			return FALSE;
		if( p1->resi[resi].max != p2->resi[resi].max )
			return FALSE;
#if	0
		if( p1->resi[resi].add != p2->resi[resi].add )
			return FALSE;
#endif
	}

	if( p1->add_def != p2->add_def )
		return FALSE;
	if( p1->add_crtcl != p2->add_crtcl )
		return FALSE;
	if( p1->add_ac != p2->add_ac )
		return FALSE;

#if	0
	if( p1->fx != p2->fx )
		return FALSE;
#endif

	if( p1->fx_data.armor_def != p2->fx_data.armor_def )
		return FALSE;
	if( p1->fx_data.armor_crtcl != p2->fx_data.armor_crtcl )
		return FALSE;
	if( p1->fx_data.armor_ac != p2->fx_data.armor_ac )
		return FALSE;

	if( p1->fx_data.infra_vision != p2->fx_data.infra_vision )
		return FALSE;

	if( p1->fx_data.stomach.rate != p2->fx_data.stomach.rate )
		return FALSE;
	if( p1->fx_data.stomach.full_rate
			!= p2->fx_data.stomach.full_rate )
		return FALSE;
	if( p1->fx_data.stomach.digest_p_day
			!= p2->fx_data.stomach.digest_p_day )
		return FALSE;
	if( p1->fx_data.stomach.hungry_rate
			!= p2->fx_data.stomach.hungry_rate )
		return FALSE;
	if( p1->fx_data.stomach.starvation_rate
			!= p2->fx_data.stomach.starvation_rate )
		return FALSE;

	if( p1->fx_data.drunk_rate != p2->fx_data.drunk_rate )
		return FALSE;

	if( p1->fx_data.nicotine.rate != p2->fx_data.nicotine.rate )
		return FALSE;
	if( p1->fx_data.nicotine.poisoning_rate
			!= p2->fx_data.nicotine.poisoning_rate )
		return FALSE;

	if( p1->fx_data.friend_turn != p2->fx_data.friend_turn )
		return FALSE;

	if( p1->fx_data.bless != p2->fx_data.bless )
		return FALSE;

	if( p1->mnstr_kind != p2->mnstr_kind )
		return FALSE;
	if( p1->mnstr_tab != p2->mnstr_tab )
		return FALSE;

	if( p1->work.caught != p2->work.caught )
		return FALSE;

	return TRUE;
}

/**/

rate_t	calc_rate_equip( chr_t *chr, abl_kind_t abl_main, abl_kind_t abl_sub )
{
	rate_t	rate_eq_main, rate_eq_sub, rate_eq;

	rate_eq_main = calc_rate_abl_equip( chr, abl_main );
	rate_eq_sub = calc_rate_abl_equip( chr, abl_sub );

	if( rate_eq_main < _100_PERCENT ){
		print_msg_mbr( chr, FLG_NULL, MSG_DONT_EXHIBIT_ABL_EQUIP,
				chr->name, get_abl_name( abl_main ) );
	}
	if( rate_eq_sub < _100_PERCENT ){
		print_msg_mbr( chr, FLG_NULL, MSG_DONT_EXHIBIT_ABL_EQUIP,
				chr->name, get_abl_name( abl_sub ) );
	}

	rate_eq = (rate_eq_main + rate_eq_sub) / 2;

	return rate_eq;
}

/**/

bool_t	chk_find_chr( chr_t *p1, chr_t *p2 )
{
	pos_t	pos1, pos2;

	if( p1 == NULL)
		return FALSE;
	if( p2 == NULL)
		return FALSE;

	if( chk_flg_or( p1->stat,
			FLG_STAT_NOT_EXIST
			| FLG_STAT_DEAD
			| FLG_STAT_STONE
			| FLG_STAT_BLIND
			| FLG_STAT_SLEEP
			| FLG_STAT_FAINT ) ){
		return FALSE;
	}
	if( chk_flg( p2->flg_map, FLG_MAP_CHR_INVISIBLE ) )
		return FALSE;
	if( chk_flg( p2->stat, FLG_STAT_VANISH ) )
		return FALSE;
	if( calc_light_depth( p2->x, p2->y ) <= 0 )
		return FALSE;

	if( (p1->kind == CHR_KIND_MBR) && (p2->kind == CHR_KIND_MNSTR) ){
		if( abs( p2->x - p1->x ) > MNSTR_MOVE_MAX_X )
			return FALSE;
		if( abs( p2->y - p1->y ) > MNSTR_MOVE_MAX_Y )
			return FALSE;
	}

	pos1.x = p1->x;
	pos1.y = p1->y;
	pos2.x = p2->x;
	pos2.y = p2->y;
	if( !chk_find( &pos1, &pos2 ) )
		return FALSE;

	if( (p1->kind == CHR_KIND_MBR) && (p2->kind == CHR_KIND_MNSTR) )
		p2->flg_map |= FLG_MAP_CHR_FIND;

	return TRUE;
}

/**/

bool_t	roll(
	chr_t *p1, abl_kind_t abl_m1, abl_kind_t abl_s1,
	chr_t *p2, abl_kind_t abl_m2, abl_kind_t abl_s2
)
{
	rate_t	rate_eq1, rate_eq2;
	rate_t	rate1, rate2;
	long	dice1, dice2;

	if( p1 == NULL )
		return FALSE;
	if( p2 == NULL )
		return FALSE;

	if( p1->kind == CHR_KIND_MBR )
		rate_eq1 = calc_rate_equip( p1, abl_m1, abl_s1 );
	else
		rate_eq1 = _100_PERCENT;
	if( p2->kind == CHR_KIND_MBR )
		rate_eq2 = calc_rate_equip( p1, abl_m2, abl_s2 );
	else
		rate_eq2 = _100_PERCENT;

	rate_eq1 += p1->fx_data.bless;
	rate_eq2 += p2->fx_data.bless;

	rate1 = get_lev( p1, abl_m1 );
	rate1 += get_lev( p1, abl_s1 );
	rate2 = get_lev( p2, abl_m2 );
	rate2 += get_lev( p2, abl_s2 );

	/**/

	rate1 = rate1 * rate_eq1 / _100_PERCENT;
	if( rate1 < 1 )
		rate1 = 1;

	rate2 = rate2 * rate_eq2 / _100_PERCENT;
	if( rate2 < 1 )
		rate2 = 1;

	rate1 += ROLL_BASE * 2;
	rate2 += ROLL_BASE * 2;

	dice1 = roll_dice( rate1 );
	dice2 = roll_dice( rate2 );

	if( g_flg_debug ){
		print_msg( FLG_NULL, "roll() rate %ld/%ld",
				rate1, rate2 );
		print_msg( FLG_NULL, "roll() dice %ld/%ld",
				dice1, dice2 );
	}

	return( dice1 >= dice2 );
}

/**/

bool_t	chr_roll(
	chr_t *chr, abl_kind_t abl_main, abl_kind_t abl_sub,
	long difficulty
)
{
	rate_t	rate_eq, rate_chr, rate_dif;
	long	dice_chr, dice_dif;

	if( chr == NULL )
		return FALSE;

	rate_eq = calc_rate_equip( chr, abl_main, abl_sub );
	rate_eq += chr->fx_data.bless;

	rate_chr = get_lev( chr, abl_main );
	rate_chr += get_lev( chr, abl_sub );

	rate_chr = rate_chr * rate_eq / _100_PERCENT;
	if( rate_chr < 1 )
		rate_chr = 1;

	rate_dif = difficulty * 2;
	if( rate_dif < 1 )
		rate_dif = 1;

	rate_chr += ROLL_BASE * 2;
	rate_dif += ROLL_BASE * 2;

	dice_chr = roll_dice( rate_chr );
	dice_dif = roll_dice( rate_dif );

	if( g_flg_debug ){
		print_msg_mbr( chr, FLG_NULL, "chr_roll() rate %ld/%ld",
				rate_chr, rate_dif );
		print_msg_mbr( chr, FLG_NULL, "chr_roll() dice %ld/%ld",
				dice_chr, dice_dif );
	}

	return( dice_chr >= dice_dif );
}

/**/

bool_t	resi_roll(
	chr_t *o_p, abl_kind_t o_abl,
	chr_t *d_p, resi_kind_t d_resi
)
{
	rate_t	o_rate, d_rate, d_rate_resi;
	long	o_dice, d_dice;

	if( o_p == NULL )
		return FALSE;
	if( d_p == NULL )
		return FALSE;

	if( d_resi == RESI_KIND_MAX_N )
		return FALSE;

	if( o_abl == ABL_KIND_MAX_N ){
		o_rate = get_specialist_lev( o_p );
	} else {
		abl_kind_t	o_abl_sub;
		long	o_lev;
		rate_t	o_rate_eq;

		o_abl_sub = get_sub_abl( o_abl );

		o_lev = get_lev( o_p, o_abl );
		o_lev += get_lev( o_p, o_abl_sub );
		o_lev /= 2;

		o_rate_eq = calc_rate_equip( o_p, o_abl, o_abl_sub );
		o_rate = o_lev * o_rate_eq / _100_PERCENT;
	}

	d_rate = get_specialist_lev( d_p );

	d_rate_resi = get_resi( d_p, d_resi );
	d_rate = d_rate * d_rate_resi / _100_PERCENT;

	o_rate += o_p->fx_data.bless;
	d_rate += d_p->fx_data.bless;

	if( o_rate < 1 )
		o_rate = 1;
	if( d_rate < 1 )
		d_rate = 1;

	o_rate += ROLL_BASE * 2;
	d_rate += ROLL_BASE * 2;

	o_dice = roll_dice( o_rate );
	d_dice = roll_dice( d_rate );

	if( g_flg_debug ){
		print_msg( FLG_NULL, "resi_roll() rate %ld/%ld",
				d_rate, o_rate );
		print_msg( FLG_NULL, "resi_roll() dice %ld/%ld",
				d_dice, o_dice );
	}

	return( o_dice < d_dice );
}

/**/

long	roll_dice( long n )
{
#if	0
/*@@@*/
	n = randm( n + 1 ) + randm( n + 1 );
#else
	n += randm( n + 1 );
#endif
	if( n <= 0 )
		n = 1;

	return n;
}

/**/

