/*****************************************************************
* L&L - Labyrinths & Legends
* Copyright (c) 1993-2003 YOSHIMURA Tomohiko All rights reserved.
* 
* Created by BowKenKen
*   e-mail: bowkenken@users.sourceforge.jp
*   URL: https://sourceforge.jp/projects/lnl/
* 
* License is GPL
* 
* ܥץϥե꡼եȥǤ
* ʤϡ Free Software Foundation ɽ
*  GNU ̸ͭѵΡ֥С󣲡
* ϤʹߤγƥС椫餤줫򤷡
* ΥС˽äܥץ
* ۤޤѹ뤳ȤǤޤ
* 
* ܥץͭѤȤϻפޤۤˤäƤϡ
* ԾڤŪŬˤĤƤΰۤݾڤޤ,
* ʤݾڤԤʤޤ
* ܺ٤ˤĤƤ GNU ̸ͭѵɤߤ
* 
* ʤϡܥץȰ GNU ̸ͭѵ
* μ̤äƤϤǤǤʤϡ
*   Free Software Foundation, Inc.,
*   59 Temple Place, Suite 330, Boston, MA 02111-1307, USA
* ؼ񤤤Ƥ
* 
* $Id: chr.h,v 1.49 2003/11/23 04:29:50 bowkenken Exp $
*****************************************************************/

#ifndef	CHR_H
#define	CHR_H

#include	"dun.h"
#include	"resi.h"
#include	"mnstr_kind.h"
#include	"fight.h"
#include	"fx.h"

#define	ROLL_BASE	10

#define	CHR_NAME_MAX_LEN	80
#define	MBR_NAME_MAX_LEN	16
#define	MNSTR_NAME_MAX_LEN	80

#define	RACE_STR_MAX_LEN	32
#define	RACE_NAME_MAX_LEN	16

#define	MOVE_LS_MAX_N	3

#define	ABL_RATE_MIN_N	((rate_t)0)
#define	ABL_RATE_MAX_N	((rate_t)20)
#define	ABL_MAX_LEV	99

typedef unsigned long	flg_chr_t;
#define	FLG_CHR_AUTO_FIGHT	(1 << 0)
#define	FLG_CHR_AUTO_DOOR	(1 << 1)
#define	FLG_CHR_AVOID_TRAP	(1 << 2)
#define	FLG_CHR_AUTO_RELOAD	(1 << 3)
#define	FLG_CHR_AUTO_MARK_CONT	(1 << 4)
#define	FLG_CHR_AUTO_CLR_ACT	(1 << 5)
#define	FLG_CHR_CAN_OPEN_DOOR	(1 << 8)
#define	FLG_CHR_CAN_BREAK_DOOR	(1 << 9)
#define	FLG_CHR_LIGHT	(1 << 10)
#define	FLG_CHR_DARK	(1 << 11)
#define	FLG_CHR_PASSWALL	(1 << 12)
#define	FLG_CHR_MAGIC_PROTECT	(1 << 13)

typedef unsigned long	flg_stat_t;
#define	FLG_STAT_NULL	0
#define	FLG_STAT_NOT_EXIST	(1 << 0)
#define	FLG_STAT_DEAD	(1 << 1)
#define	FLG_STAT_STONE	(1 << 2)
#define	FLG_STAT_PARALYZE	(1 << 3)
#define	FLG_STAT_POISON	(1 << 4)
#define	FLG_STAT_CONFUSION	(1 << 5)
#define	FLG_STAT_BLIND	(1 << 6)
#define	FLG_STAT_SLEEP	(1 << 7)
#define	FLG_STAT_SILENCE	(1 << 8)
#define	FLG_STAT_CAUGHT	(1 << 9)
#define	FLG_STAT_FEAR	(1 << 10)
#define	FLG_STAT_HALLUCINATION	(1 << 11)
#define	FLG_STAT_CHARM	(1 << 12)
#define	FLG_STAT_HUNGRY	(1 << 13)
#define	FLG_STAT_STARVATION	(1 << 14)
#define	FLG_STAT_FAINT	(1 << 15)
#define	FLG_STAT_DRUNK	(1 << 16)
#define	FLG_STAT_FLY	(1 << 17)
#define	FLG_STAT_VANISH	(1 << 18)

typedef unsigned long	flg_work_t;
#define	FLG_WORK_FIND_MBR	(1 << 0)

#define	CLASS_MAX_N	99
#define	CLASS_NAME_MAX_LEN	20

#define	SQUARE_WIDTH	3
#define	SQUARE_HEIGHT	3

#define	ACT_MSG_MAX_LEN	64

#define	STAGGER_RATE_CHR_CONFUSION	((rate_t)70)
#define	STAGGER_RATE_CHR_BLIND	((rate_t)80)
#define	STAGGER_RATE_CHR_DRUNK	((rate_t)50)

#define	MBR_MAX_N	6
#define	MBR_N_NOT_JOIN	(-1)
#define	MBR_NO_POS	(-1)

/******************************************************************/

typedef enum {
	CHR_KIND_NULL,
	CHR_KIND_MBR,	/* С(PC) */
	CHR_KIND_MNSTR,	/* 󥹥 */
} chr_kind_t;

/* ̤ɽʸ() */

typedef struct {
	char	mjr, mnr;
	char	mjr_org, mnr_org;
} chr_face_t;

/* ² */

typedef enum {
	MAIN_RACE_HUMAN,
	MAIN_RACE_HALF_ELF,
	MAIN_RACE_ELF,
	MAIN_RACE_DWARF,
	MAIN_RACE_VIVID,
	MAIN_RACE_MAX_N,
} main_race_t;

typedef enum {
	SUB_RACE_NULL,
	SUB_RACE_CAT,
	SUB_RACE_DOG,
	SUB_RACE_MOUSE,
	SUB_RACE_RABBIT,
	SUB_RACE_MONKEY,
	SUB_RACE_PIG,
	SUB_RACE_BIRD,
	SUB_RACE_LIZARD,
	SUB_RACE_MAX_N,
} sub_race_t;

typedef struct {
	main_race_t	main;
	sub_race_t	sub;
	char	name[RACE_NAME_MAX_LEN + 1];
} race_t;

/*  */

typedef enum {
	SEX_NULL,
	MALE,
	FEMALE,
} sex_t;

typedef struct {
	sex_t	cur, org;
} sex_dat_t;

/* ư® */

typedef struct {
	rate_t	rate, rate_org;
	long	n;
} move_speed_t;

/* ⤭ */

typedef enum {
	MOVE_KIND_NULL,
	MOVE_KIND_STOP,	/*  */
	MOVE_KIND_TOWNER,
	MOVE_KIND_STD,	/* (STanDard) */
	MOVE_KIND_STAGGER,	/* եĤ */
	MOVE_KIND_MAX_N,
} move_kind_t;

typedef struct {
	move_kind_t	kind;
	ratio_t	ratio;
} move_ls_t;

typedef enum {
	MOVE_LS_KIND_FIND,
	MOVE_LS_KIND_NOT_FIND,
	MOVE_LS_KIND_MAX_N,
} move_ls_kind_t;

typedef struct {
	move_speed_t	speed;
	move_kind_t	force_kind;
	move_ls_t	ls[MOVE_LS_KIND_MAX_N][MOVE_LS_MAX_N];
} move_t;

/* ǽ */

typedef enum {
	ABL_KIND_HP,
	ABL_KIND_MP,

	ABL_KIND_DEX,
	ABL_KIND_STR,
	ABL_KIND_AGI,

	ABL_KIND_WIS,
	ABL_KIND_INT,
	ABL_KIND_CHA,

	ABL_KIND_FIG,
	ABL_KIND_MON,
	ABL_KIND_HUN,
	ABL_KIND_THI,

	ABL_KIND_MAG,
	ABL_KIND_SOR,
	ABL_KIND_ENC,
	ABL_KIND_SUM,

	ABL_KIND_PRI,
	ABL_KIND_SHA,
	ABL_KIND_BAR,
	ABL_KIND_NIN,

	ABL_KIND_MAX_N,
} abl_kind_t;

typedef struct {
	long	n, max;
} abl_exp_t;

typedef struct {
	long	n, max, add;
} abl_lev_t;

typedef struct {
	long	n, max;
} abl_val_t;

typedef struct {
	abl_exp_t	exp[ABL_KIND_MAX_N];
	abl_lev_t	lev[ABL_KIND_MAX_N];
	abl_val_t	hp, mp;
} abl_t;

typedef struct {
	long	mul_lev, add_lev;
} lev_to_exp_t;

typedef struct {
	long	mul_lev, add_lev;
} lev_to_val_t;

/* ˤ뽤 */

typedef struct {
	char	face_mjr, face_mnr;
	sex_t	sex;
	rate_t	armor_def, armor_crtcl, armor_ac;
	long	add_lev[ABL_KIND_MAX_N];
	long	add_resi_n[RESI_KIND_MAX_N];
	long	add_move_speed;
	long	stomach_digest_n;
	long	teleport_n, teleport_party_n;
	rate_t	bless;
} modifier_t;

#define	ARMOR_ALL_0	(rate_t)0, (rate_t)0, (rate_t)0
#define	ADD_LEV_ALL_0	\
	{\
		0, 0,\
		0, 0, 0, 0, 0, 0,\
		0, 0, 0, 0,\
		0, 0, 0, 0,\
		0, 0, 0, 0,\
	}
#define	ADD_RESI_N_ALL_0	\
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, }

/* 饹() */

typedef enum {
	CLASS_DFLT_NULL,
	CLASS_DFLT_FIGHTER,
	CLASS_DFLT_MONK,
	CLASS_DFLT_HUNTER,
	CLASS_DFLT_THIEF,
	CLASS_DFLT_WIZARD,
	CLASS_DFLT_SUMMONER,
	CLASS_DFLT_PRIEST,
	CLASS_DFLT_SHAMAN,
	CLASS_DFLT_BARD,
	CLASS_DFLT_NINJA,
	CLASS_DFLT_BISHOP,
} class_dflt_t;

typedef struct {
	n_msg_t	n_name;
	char	name[CLASS_NAME_MAX_LEN + 1];
	class_dflt_t	dflt;
	rate_t	abl_rate[ABL_KIND_MAX_N];
} class_t;

/*  */

typedef enum {
	ACT_KIND_NULL,
	ACT_KIND_MNSTR_FIGHT,
	ACT_KIND_MNSTR_THROW,
	ACT_KIND_MNSTR_TAIL,
	ACT_KIND_MBR_FIGHT,
	ACT_KIND_MBR_THROW,
	ACT_KIND_MBR_TAIL,
	ACT_KIND_DOOR_OPEN,
	ACT_KIND_DOOR_CLOSE,
	ACT_KIND_DOOR_JAM,
	ACT_KIND_DOOR_DISARM,
	ACT_KIND_DOOR_BREAK,
	ACT_KIND_DOOR_PEEP,
	ACT_KIND_DOOR_SRCH,
	ACT_KIND_TRAP_DISARM,
	ACT_KIND_TRAP_BREAK,
	ACT_KIND_TRAP_SRCH,
	ACT_KIND_ITEM_PICK_UP,
	ACT_KIND_ITEM_OPEN,
	ACT_KIND_ITEM_DISARM,
	ACT_KIND_ITEM_BREAK,
	ACT_KIND_ITEM_SRCH,
	ACT_KIND_ITEM_SEND,
	ACT_KIND_ITEM_DROP,
	ACT_KIND_ITEM_RECEIVE,
	ACT_KIND_EQUIP_SEL,
	ACT_KIND_EQUIP,
	ACT_KIND_TAKE_OFF,
	ACT_KIND_EQUIP_MBR,
	ACT_KIND_TAKE_OFF_MBR,
	ACT_KIND_POTION_QUAFF,
	ACT_KIND_POTION_FILL,
	ACT_KIND_SCROLL_READ,
	ACT_KIND_STICK_ZAP,
	ACT_KIND_FOOD_EAT,
	ACT_KIND_TOBACCO_DISPOSE,
	ACT_KIND_SRCH,
	ACT_KIND_SPELL,

	/* ѡƥΥ*/
	ACT_KIND_SHOP,
	ACT_KIND_RECALL,
	ACT_KIND_MAX_N,
} act_kind_t;

typedef struct {
	act_kind_t	kind;
	void	*p, *p2;
	long	n, n2;
	char	msg[ACT_MSG_MAX_LEN + 1];
	act_kind_t	dflt_kind_mnstr;
	char	dflt_msg_mnstr[ACT_MSG_MAX_LEN + 1];
} act_t;

/* å */

typedef enum {
	TRGT_KIND_NULL,
	TRGT_KIND_MBR,
	TRGT_KIND_MNSTR,
	TRGT_KIND_MNSTR_NULL,	/* 󥹥ΤʤޡȤ */
	TRGT_KIND_ITEM,
	TRGT_KIND_DOOR,
	TRGT_KIND_TRAP,
	TRGT_KIND_QUEUE,
	TRGT_KIND_SQUARE,
	TRGT_KIND_POS,
	TRGT_KIND_AUTO,
	TRGT_KIND_MAX_N,
} trgt_kind_t;

/* ֹ礤 */

typedef enum {
	DIST_NEAR,
	DIST_MEDIUM,
	DIST_FAR,
} dist_t;

/* ɸ */

typedef struct {
	trgt_kind_t	kind;
	void	*p;
	long	n;
	long	x, y;	/* åȤˤäƤϽ */
	long	true_x, true_y;	/* ̵κɸ */
	dist_t	dist, dflt_dist_mnstr;
} trgt_t;

/* ١ȿ */

typedef enum {
	ATTITUDE_MATE,
	ATTITUDE_FRIENDLY,
	ATTITUDE_NEUTRAL,
	ATTITUDE_HOSTILE,
} attitude_t;

/*  */

typedef struct {
	flg_work_t	flg;

	/*  PC ޤƤ륭οͿ */
	long	caught;

	/* ޤäưưǤʤPC */
	struct chr_t	*catch_chr;

	/* ࡦƥݡȤε륫 */
	long	teleport_n, teleport_party_n;

	long	towner_dx, towner_dy;
	door_t	*enter_door;
} chr_work_t;

/* ۡࡦ(ѡƥΰư濴) */

typedef struct {
	long	x, y;
	long	pre_x, pre_y;	/* 1κɸ */
	long	dir_x, dir_y;	/* Ƥ */

	/* Ƥθ */
	long	chr_pos_n[SQUARE_HEIGHT][SQUARE_WIDTH];

	/* ºݤθ */
	long	chr_dir[SQUARE_HEIGHT][SQUARE_WIDTH];

	/*  */
	pos_t	chr_pos[MBR_MAX_N];
} square_t;

/* 󥹥Υǡơ֥ */

typedef struct {
	/* 󥹥μ */
	mnstr_kind_t	mnstr_kind;

	/* 󥹥̾ */
	char	*name;
	n_msg_t	name_n;

	/* ʿѤο */
	long	group;

	/* ̤ɽ */
	char	face_mjr, face_mnr;

	/* ưŪ˷׻иͤν */
	rate_t	exp;

	/* ݤȤɤγ */
	rate_t	gold_rate;

	/* ׹ͥ롼 */
	void	(*func)( struct chr_t *p );

	/* ١ȿ */
	attitude_t	attitude;

	/* ǽ */
	rate_t	abl_lev_rate[ABL_KIND_MAX_N];

	/*  */
	rate_t	resi[RESI_KIND_MAX_N];

	/* ˡ */
	attack_t	attack[CHR_ATACK_MAX_N + 1];

	/* ɸξꤵƥޡ饹 */
	rate_t	def, armor_crtcl, ac;

	/* ư */
	move_t	move;

	/* ¾üưΥե饰 */
	flg_chr_t	flg_chr;

	/* ޥå(dun->map.chr.flg[y][x])˽񤯥ե饰 */
	flg_map_t	flg_map;
} mnstr_tab_t;

/* 饯(PC,NPC,󥹥) */

typedef struct chr_t {
	/* ꥹȤ */
	struct chr_t	*prev, *next;
	/* μ */
	chr_kind_t	kind;
	char	name[CHR_NAME_MAX_LEN + 1];
	/* PCλ¤ӽ */
	long	mbr_n, ls_mbr_n;
	chr_face_t	face;
	/* ² */
	race_t	race;
	/*  */
	sex_dat_t	sex;
	long	x, y;
	long	pre_x, pre_y;
	/* ưλ */
	move_t	move;
	/*  */
	gold_t	gold;
	/* ԤäΤ볬Ͼ塢ϲ */
	long	dun_max_lev_floor, dun_max_lev_base;
	trgt_t	trgt;
	act_t	act;
	flg_chr_t	flg_chr;
	flg_map_t	flg_map;
	/* ١ȿ */
	attitude_t	attitude;
	/*  */
	struct chr_t	*owner;
	/* ơ() */
	flg_stat_t	stat;
	/* ǽ */
	abl_t	abl;
	/* ߤΥ饹 */
	long	class_n;
	resi_t	resi[RESI_KIND_MAX_N];
	/* ޡ饹(󥹥λΤ) */
	long	add_def, add_crtcl, add_ac;
	/* ߳ݤäƤˡʤɤΥե */
	fx_t	fx;
	/* եȤǻȤ */
	fx_data_t	fx_data;
	/* ü */
	modifier_t	modifier_equip;
	/* եȤü */
	modifier_t	modifier_fx;
	/* 󥹥μ */
	mnstr_kind_t	mnstr_kind;
	/* 󥹥ǡơ֥ */
	mnstr_tab_t	*mnstr_tab;
	/* ¾ */
	chr_work_t	work;
} chr_t;

#endif	/* CHR_H */
